% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_wd.R
\name{open_wd}
\alias{open_wd}
\title{Open working directory}
\usage{
open_wd(path = getwd(), verbose = TRUE)
}
\arguments{
\item{path}{Directory path to be opened. By default it's the working directory. 
'wav.path' set by \code{\link{warbleR_options}} is ignored in this case.}

\item{verbose}{Logical to control whether the 'path' is printed in the console. Defaut is \code{TRUE}.}
}
\description{
\code{open_wd} opens the working directory in the default file browser.
}
\details{
The function opens the working directory using the default file browser 
and prints the working directory in the R console. This function aims to simplify
the manipulation of sound files and other files produced by many of the \code{\link{warbleR}} function.
}
\examples{
{
\donttest{open_wd()}
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{move_imgs}}

Other data manipulation: 
\code{\link{move_imgs}()},
\code{\link{split_wavs}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{data manipulation}
