% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_colms.R
\name{sort_colms}
\alias{sort_colms}
\title{Sort columns in a more intuitive order}
\usage{
sort_colms(X)
}
\arguments{
\item{X}{Data frame containing columns for sound file (sound.files), selection 
(selec), start and end time of signals ('start' and 'end') and low and high 
frequency ('bottom.freq' and 'top.freq', optional). See the example data 'lbh_selec_table'.}
}
\value{
The same data as in the input data frame but with the most relevant information
for acoustic analysis located in the first columns.
}
\description{
\code{sort_colms} sorts selection table columns in a more intuitive order.
}
\details{
The function returns the data from the input data frame with the most relevant information
for acoustic analysis located in the first columns. The priority order for column names is: "sound.files", "channel", "selec", "start", "end", "top.freq", and "bottom.freq".
}
\examples{
library(warbleR)
data("selec.table")

# mess column order
selec.table <- selec.table[, sample(1:ncol(selec.table))] 
 
 #check names
 names(selec.table)
 
 selec.table <- sort_colms(X = selec.table)

 #check names again
 names(selec.table)
  
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
