% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lspec.R
\name{lspec}
\alias{lspec}
\title{Create long spectrograms of whole sound files}
\usage{
lspec(X = NULL, flim = c(0,22), sxrow = 5, rows = 10, collevels = seq(-40, 0, 1), 
ovlp = 50, parallel = 1, wl = 512, gr = FALSE, pal = reverse.gray.colors.2, 
cex = 1, it = "jpeg", flist = NULL, redo = TRUE, path = NULL, pb = TRUE, 
fast.spec = FALSE)
}
\arguments{
\item{X}{'selection_table' object or data frame with results from \code{\link{manualoc}} or any data frame with columns
for sound file name (sound.files), selection number (selec), and start and end time of signal
(start and end). If given, two red dotted lines are plotted at the 
start and end of a selection and the selections are labeled with the selection number 
(and selection comment, if available). Default is \code{NULL}.}

\item{flim}{A numeric vector of length 2 indicating the highest and lowest 
frequency limits (kHz) of the spectrogram, as in 
\code{\link[seewave]{spectro}}. Default is c(0,22).}

\item{sxrow}{A numeric vector of length 1. Specifies seconds of spectrogram
per row. Default is 5.}

\item{rows}{A numeric vector of length 1. Specifies number of rows per 
image file. Default is 10.}

\item{collevels}{A numeric vector of length 3. Specifies levels to partition the 
amplitude range of the spectrogram (in dB). The more levels the higher the
resolution of the spectrogram. Default is seq(-40, 0, 1).}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 50. High values of ovlp 
slow down the function but produce more accurate selection limits (when X is provided).}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{gr}{Logical argument to add grid to spectrogram. Default is \code{FALSE}.}

\item{pal}{Color palette function for spectrogram. Default is reverse.gray.colors.2. See 
\code{\link[seewave]{spectro}} for more palettes.}

\item{cex}{A numeric vector of length 1 giving the amount by which text 
(including sound file and page number) should be magnified. Default is 1.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{flist}{character vector or factor indicating the subset of files that will be analyzed. Ignored
if X is provided.}

\item{redo}{Logical argument. If \code{TRUE} all selections will be analyzed again 
when code is rerun. If \code{FALSE} only the selections that do not have a image 
file in the working directory will be analyzed. Default is \code{FALSE}.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms, which substantially 
increases performance (much faster), although some options become unavailable, as collevels, and sc (amplitude scale).
This option is indicated for signals with high background noise levels. Palette colors \code{\link[monitoR]{gray.1}}, \code{\link[monitoR]{gray.2}}, 
\code{\link[monitoR]{gray.3}}, \code{\link[monitoR]{topo.1}} and \code{\link[monitoR]{rainbow.1}} (which should be imported from the package monitoR) seem
to work better with 'fast' spectograms. Palette colors \code{\link[monitoR]{gray.1}}, \code{\link[monitoR]{gray.2}}, 
\code{\link[monitoR]{gray.3}} offer 
decreasing darkness levels.}
}
\value{
image files with spectrograms of whole sound files in the working directory. Multiple pages
can be returned, depending on the length of each sound file.
}
\description{
\code{lspec} produces image files with spectrograms of whole sound files split into multiple 
  rows.
}
\details{
The function creates spectrograms for complete sound files, printing
  the name of the sound files and the "page" number (p1-p2...) at the upper 
  right corner of the image files. If results from \code{\link{manualoc}} are 
  supplied (or an equivalent data frame), the function delimits and labels the selections. 
  This function aims to facilitate visual inspection of multiple files as well as visual classification 
  of vocalization units and the analysis of animal vocal sequences.
}
\examples{
\dontrun{
# Set temporary working directory
# setwd(tempdir())

# save sound file examples
data(list = c("Phae.long1", "Phae.long2","selec.table"))
writeWave(Phae.long1,"Phae.long1.wav") 
writeWave(Phae.long2,"Phae.long2.wav")

lspec(sxrow = 2, rows = 8, pal = reverse.heat.colors, wl = 300)

# including selections
lspec(sxrow = 2, rows = 8, X = selec.table, pal = reverse.heat.colors, redo = TRUE, wl = 300)

#check this floder
getwd()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{lspec2pdf}}, \code{\link{catalog2pdf}}, 
\href{https://marce10.github.io/2017/01/07/Create_pdf_files_with_spectrograms_of_full_recordings.html}{blog post on spectrogram pdfs}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
