% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xfer_draw.R
\name{xfer_draw}
\alias{xfer_draw}
\title{xfer_draw Draw extent of transfer}
\usage{
xfer_draw(polyXfXY, polyXfID, drawXfBuf, logger = NULL, spN = NULL)
}
\arguments{
\item{polyXfXY}{coordinates of polygon endpoints obtained from user
drawn polygon}

\item{polyXfID}{numeric .ID to be used in the generation of the polygon}

\item{drawXfBuf}{the buffer to be used in generating the
SpatialPolygonsDataFrame, must be >=0 . A number must be specified.}

\item{logger}{Stores all notification messages to be displayed in the
Log Window of Wallace GUI. Insert the logger reactive list here for
running in shiny, otherwise leave the default NULL}

\item{spN}{character. Used to obtain species name for logger messages}
}
\value{
This functions returns a SpatialPolygons object based on the user
  specified coordinates (drawn on map). This SpatialPolygonsDataFrame may be
  larger than specified if drawBgBuf > 0.
}
\description{
This function creates a polygon object from coordinates of user
  drawn poylgon in the GUI.
}
\details{
This function is used in the transfer model component. In the GUI, the user
  draws a polygon to be used as the extent of transfer and may include a
  buffer to the given polygon. The function returns a
  SpatialPolygonsDataFrame object of the desired extent (+ buffer).
}
\examples{
longitude <- c(-27.78641, -74.09170, -84.01930, -129.74867,
               -142.19085, -45.55045, -28.56050)
latitude <- c(-40.40539, -37.02010, 2.28455, 40.75350,
              56.35954, 54.55045, -7.11861)
userDrawPoly <- matrix(c(longitude, latitude), byrow = FALSE,
                       ncol = 2)
drawXfBuf <- 0.5
polyXfID <- 1
polygonTest <- xfer_draw(polyXfXY = userDrawPoly, polyXfID,
                         drawXfBuf)

}
\seealso{
\code{\link{xfer_userEnvs}}
}
\author{
Gonzalo Pinilla <gepinillab@gmail.com>
}
