// Generated by rstantools.  Do not edit by hand.

/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.19.1
#include <stan/model/model_header.hpp>
namespace model_rw1_model_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_rw1_model");
    reader.add_event(145, 143, "end", "model_rw1_model");
    return reader;
}
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
gaussian_filter_rw_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                            const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                            const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                            const T3__& Ht,
                            const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                            const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 8;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));
        current_statement_begin__ = 9;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));
        current_statement_begin__ = 10;
        local_scalar_t__ loglik(DUMMY_VAR__);
        (void) loglik;  // dummy to suppress unused var warning
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,0.0);
        current_statement_begin__ = 12;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);
        current_statement_begin__ = 13;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,diag_matrix(P1));
        current_statement_begin__ = 14;
        for (int t = 1; t <= n; ++t) {
            {
            current_statement_begin__ = 15;
            local_scalar_t__ F(DUMMY_VAR__);
            (void) F;  // dummy to suppress unused var warning
            stan::math::initialize(F, DUMMY_VAR__);
            stan::math::fill(F, DUMMY_VAR__);
            stan::math::assign(F,(quad_form(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + Ht));
            current_statement_begin__ = 16;
            local_scalar_t__ v(DUMMY_VAR__);
            (void) v;  // dummy to suppress unused var warning
            stan::math::initialize(v, DUMMY_VAR__);
            stan::math::fill(v, DUMMY_VAR__);
            stan::math::assign(v,(get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), x)));
            current_statement_begin__ = 17;
            validate_non_negative_index("K", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> K(m);
            stan::math::initialize(K, DUMMY_VAR__);
            stan::math::fill(K, DUMMY_VAR__);
            stan::math::assign(K,divide(multiply(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), F));
            current_statement_begin__ = 18;
            stan::math::assign(x, add(x, multiply(K, v)));
            current_statement_begin__ = 19;
            stan::math::assign(P, add(P, add(multiply(multiply(minus(K), transpose(K)), F), Rt)));
            current_statement_begin__ = 20;
            stan::math::assign(loglik, (loglik - (0.5 * (stan::math::log(F) + ((v * v) / F)))));
            }
        }
        current_statement_begin__ = 22;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
gaussian_filter_rw_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                            const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                            const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                            const T3__& Ht,
                            const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                            const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    return gaussian_filter_rw_lpdf<false>(y,a1,P1,Ht,Rt,xreg, pstream__);
}
struct gaussian_filter_rw_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                            const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                            const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                            const T3__& Ht,
                            const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                            const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return gaussian_filter_rw_lpdf(y, a1, P1, Ht, Rt, xreg, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
gaussian_smoother_rw(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                         const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                         const T3__& Ht,
                         const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                         const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));
        current_statement_begin__ = 28;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));
        current_statement_begin__ = 29;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);
        current_statement_begin__ = 30;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,diag_matrix(P1));
        current_statement_begin__ = 31;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);
        current_statement_begin__ = 32;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);
        current_statement_begin__ = 33;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);
        current_statement_begin__ = 34;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);
        current_statement_begin__ = 35;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);
        current_statement_begin__ = 37;
        for (int t = 1; t <= n; ++t) {
            current_statement_begin__ = 38;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + Ht), 
                        "assigning variable F");
            current_statement_begin__ = 39;
            stan::model::assign(v, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), x)), 
                        "assigning variable v");
            current_statement_begin__ = 40;
            stan::model::assign(K, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        divide(multiply(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                        "assigning variable K");
            current_statement_begin__ = 41;
            stan::math::assign(x, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1))));
            current_statement_begin__ = 42;
            stan::math::assign(P, add(P, add(multiply(multiply(minus(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1)), Rt)));
        }
        current_statement_begin__ = 44;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 45;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 46;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));
            current_statement_begin__ = 47;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));
            current_statement_begin__ = 48;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        subtract(add(divide(multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), tmp), multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), dot_product(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), tmp))), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 51;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 52;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, elt_multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 53;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 54;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));
            current_statement_begin__ = 55;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));
            current_statement_begin__ = 56;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(tmp, multiply(Rt, tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 58;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "r"));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct gaussian_smoother_rw_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                         const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                         const T3__& Ht,
                         const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                         const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return gaussian_smoother_rw(y, a1, P1, Ht, Rt, xreg, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_rw1_model : public prob_grad {
private:
        int k;
        int n;
        matrix_d xreg;
        vector_d y;
        vector_d beta_mean;
        vector_d beta_sd;
        vector_d sigma_mean;
        vector_d sigma_sd;
        int n_new;
        matrix_d xreg_new;
        vector_d sigma_b_mean;
        vector_d sigma_b_sd;
        double sigma_y_mean;
        double sigma_y_sd;
public:
    model_rw1_model(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_rw1_model(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_rw1_model_namespace::model_rw1_model";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 63;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);
            current_statement_begin__ = 64;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 65;
            validate_non_negative_index("xreg", "k", k);
            validate_non_negative_index("xreg", "n", n);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(k,n));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = n;
            size_t xreg_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 66;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 67;
            validate_non_negative_index("beta_mean", "k", k);
            context__.validate_dims("data initialization", "beta_mean", "vector_d", context__.to_vec(k));
            beta_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            size_t beta_mean_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_mean_j_1_max__; ++j_1__) {
                beta_mean(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 68;
            validate_non_negative_index("beta_sd", "k", k);
            context__.validate_dims("data initialization", "beta_sd", "vector_d", context__.to_vec(k));
            beta_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            size_t beta_sd_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_sd_j_1_max__; ++j_1__) {
                beta_sd(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 69;
            validate_non_negative_index("sigma_mean", "(k + 1)", (k + 1));
            context__.validate_dims("data initialization", "sigma_mean", "vector_d", context__.to_vec((k + 1)));
            sigma_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>((k + 1));
            vals_r__ = context__.vals_r("sigma_mean");
            pos__ = 0;
            size_t sigma_mean_j_1_max__ = (k + 1);
            for (size_t j_1__ = 0; j_1__ < sigma_mean_j_1_max__; ++j_1__) {
                sigma_mean(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 70;
            validate_non_negative_index("sigma_sd", "(k + 1)", (k + 1));
            context__.validate_dims("data initialization", "sigma_sd", "vector_d", context__.to_vec((k + 1)));
            sigma_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>((k + 1));
            vals_r__ = context__.vals_r("sigma_sd");
            pos__ = 0;
            size_t sigma_sd_j_1_max__ = (k + 1);
            for (size_t j_1__ = 0; j_1__ < sigma_sd_j_1_max__; ++j_1__) {
                sigma_sd(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 71;
            context__.validate_dims("data initialization", "n_new", "int", context__.to_vec());
            n_new = int(0);
            vals_i__ = context__.vals_i("n_new");
            pos__ = 0;
            n_new = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_new", n_new, 0);
            current_statement_begin__ = 72;
            validate_non_negative_index("xreg_new", "k", k);
            validate_non_negative_index("xreg_new", "n_new", n_new);
            context__.validate_dims("data initialization", "xreg_new", "matrix_d", context__.to_vec(k,n_new));
            xreg_new = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n_new);
            vals_r__ = context__.vals_r("xreg_new");
            pos__ = 0;
            size_t xreg_new_j_2_max__ = n_new;
            size_t xreg_new_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_new_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_new_j_1_max__; ++j_1__) {
                    xreg_new(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 76;
            validate_non_negative_index("sigma_b_mean", "k", k);
            sigma_b_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            stan::math::fill(sigma_b_mean, DUMMY_VAR__);
            stan::math::assign(sigma_b_mean,stan::model::rvalue(sigma_mean, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_mean"));
            current_statement_begin__ = 77;
            validate_non_negative_index("sigma_b_sd", "k", k);
            sigma_b_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            stan::math::fill(sigma_b_sd, DUMMY_VAR__);
            stan::math::assign(sigma_b_sd,stan::model::rvalue(sigma_sd, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_sd"));
            current_statement_begin__ = 78;
            sigma_y_mean = double(0);
            stan::math::fill(sigma_y_mean, DUMMY_VAR__);
            stan::math::assign(sigma_y_mean,get_base1(sigma_mean, 1, "sigma_mean", 1));
            current_statement_begin__ = 79;
            sigma_y_sd = double(0);
            stan::math::fill(sigma_y_sd, DUMMY_VAR__);
            stan::math::assign(sigma_y_sd,get_base1(sigma_sd, 1, "sigma_sd", 1));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 83;
            validate_non_negative_index("sigma_b", "k", k);
            num_params_r__ += (1 * k);
            current_statement_begin__ = 84;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_rw1_model() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 83;
        if (!(context__.contains_r("sigma_b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_b");
        pos__ = 0U;
        validate_non_negative_index("sigma_b", "k", k);
        context__.validate_dims("parameter initialization", "sigma_b", "double", context__.to_vec(k));
        std::vector<double> sigma_b(k, double(0));
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            sigma_b[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_b_i_0_max__ = k;
        for (size_t i_0__ = 0; i_0__ < sigma_b_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_b[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_b: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 84;
        if (!(context__.contains_r("sigma_y")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_y missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_y");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_y", "double", context__.to_vec());
        double sigma_y(0);
        sigma_y = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_y);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_y: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 83;
            std::vector<local_scalar_t__> sigma_b;
            size_t sigma_b_d_0_max__ = k;
            sigma_b.reserve(sigma_b_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_b.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_b.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 84;
            local_scalar_t__ sigma_y;
            (void) sigma_y;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_y = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_y = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 88;
            validate_non_negative_index("R_vector", "k", k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> R_vector(k);
            stan::math::initialize(R_vector, DUMMY_VAR__);
            stan::math::fill(R_vector, DUMMY_VAR__);
            current_statement_begin__ = 89;
            validate_non_negative_index("P1_vector", "k", k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> P1_vector(k);
            stan::math::initialize(P1_vector, DUMMY_VAR__);
            stan::math::fill(P1_vector, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 90;
            for (int i = 1; i <= k; ++i) {
                current_statement_begin__ = 91;
                stan::model::assign(R_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(sigma_b, i, "sigma_b", 1), 2), 
                            "assigning variable R_vector");
                current_statement_begin__ = 92;
                stan::model::assign(P1_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(beta_sd, i, "beta_sd", 1), 2), 
                            "assigning variable P1_vector");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 88;
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(R_vector(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: R_vector" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable R_vector: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 89;
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(P1_vector(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: P1_vector" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable P1_vector: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 97;
            lp_accum__.add(normal_log<propto__>(sigma_b, sigma_b_mean, sigma_b_sd));
            current_statement_begin__ = 98;
            lp_accum__.add(normal_log<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
            current_statement_begin__ = 99;
            lp_accum__.add(gaussian_filter_rw_lpdf<propto__>(y, beta_mean, P1_vector, pow(sigma_y, 2), diag_matrix(R_vector), xreg, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_b");
        names__.push_back("sigma_y");
        names__.push_back("R_vector");
        names__.push_back("P1_vector");
        names__.push_back("y_rep");
        names__.push_back("beta");
        names__.push_back("y_new");
        names__.push_back("beta_new");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_new);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n_new);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_rw1_model_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> sigma_b;
        size_t sigma_b_d_0_max__ = k;
        sigma_b.reserve(sigma_b_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
            sigma_b.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_b[k_0__]);
        }
        double sigma_y = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_y);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 88;
            validate_non_negative_index("R_vector", "k", k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> R_vector(k);
            stan::math::initialize(R_vector, DUMMY_VAR__);
            stan::math::fill(R_vector, DUMMY_VAR__);
            current_statement_begin__ = 89;
            validate_non_negative_index("P1_vector", "k", k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> P1_vector(k);
            stan::math::initialize(P1_vector, DUMMY_VAR__);
            stan::math::fill(P1_vector, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 90;
            for (int i = 1; i <= k; ++i) {
                current_statement_begin__ = 91;
                stan::model::assign(R_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(sigma_b, i, "sigma_b", 1), 2), 
                            "assigning variable R_vector");
                current_statement_begin__ = 92;
                stan::model::assign(P1_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(beta_sd, i, "beta_sd", 1), 2), 
                            "assigning variable P1_vector");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t R_vector_j_1_max__ = k;
                for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                    vars__.push_back(R_vector(j_1__));
                }
                size_t P1_vector_j_1_max__ = k;
                for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                    vars__.push_back(P1_vector(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 104;
            validate_non_negative_index("y_rep", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_rep(n);
            stan::math::initialize(y_rep, DUMMY_VAR__);
            stan::math::fill(y_rep, DUMMY_VAR__);
            current_statement_begin__ = 105;
            validate_non_negative_index("beta", "k", k);
            validate_non_negative_index("beta", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta(k, n);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 106;
            validate_non_negative_index("y_new", "n_new", n_new);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_new(n_new);
            stan::math::initialize(y_new, DUMMY_VAR__);
            stan::math::fill(y_new, DUMMY_VAR__);
            current_statement_begin__ = 107;
            validate_non_negative_index("beta_new", "k", k);
            validate_non_negative_index("beta_new", "n_new", n_new);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_new(k, n_new);
            stan::math::initialize(beta_new, DUMMY_VAR__);
            stan::math::fill(beta_new, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 110;
            for (int i = 1; i <= k; ++i) {
                current_statement_begin__ = 111;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            normal_rng(get_base1(beta_mean, i, "beta_mean", 1), get_base1(beta_sd, i, "beta_sd", 1), base_rng__), 
                            "assigning variable beta");
            }
            current_statement_begin__ = 113;
            for (int t = 1; t <= (n - 1); ++t) {
                current_statement_begin__ = 114;
                for (int i = 1; i <= k; ++i) {
                    current_statement_begin__ = 115;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                normal_rng(get_base1(beta, i, t, "beta", 1), get_base1(sigma_b, i, "sigma_b", 1), base_rng__), 
                                "assigning variable beta");
                }
            }
            current_statement_begin__ = 119;
            for (int t = 1; t <= n; ++t) {
                current_statement_begin__ = 120;
                stan::model::assign(y_rep, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            normal_rng(dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta")), sigma_y, base_rng__), 
                            "assigning variable y_rep");
            }
            current_statement_begin__ = 123;
            stan::math::assign(beta, add(beta, gaussian_smoother_rw(subtract(y, y_rep), beta_mean, P1_vector, pow(sigma_y, 2), diag_matrix(R_vector), xreg, pstream__)));
            current_statement_begin__ = 126;
            for (int t = 1; t <= n; ++t) {
                current_statement_begin__ = 127;
                stan::model::assign(y_rep, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta")) + normal_rng(0, sigma_y, base_rng__)), 
                            "assigning variable y_rep");
            }
            current_statement_begin__ = 131;
            if (as_bool(logical_gt(n_new, 0))) {
                current_statement_begin__ = 132;
                for (int i = 1; i <= k; ++i) {
                    current_statement_begin__ = 133;
                    stan::model::assign(beta_new, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                normal_rng(get_base1(beta, i, n, "beta", 1), get_base1(sigma_b, i, "sigma_b", 1), base_rng__), 
                                "assigning variable beta_new");
                }
                current_statement_begin__ = 135;
                for (int t = 1; t <= (n_new - 1); ++t) {
                    current_statement_begin__ = 136;
                    stan::model::assign(y_new, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (dot_product(stan::model::rvalue(xreg_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_new"), stan::model::rvalue(beta_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_new")) + normal_rng(0, sigma_y, base_rng__)), 
                                "assigning variable y_new");
                    current_statement_begin__ = 137;
                    for (int i = 1; i <= k; ++i) {
                        current_statement_begin__ = 138;
                        stan::model::assign(beta_new, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    normal_rng(get_base1(beta_new, i, t, "beta_new", 1), get_base1(sigma_b, i, "sigma_b", 1), base_rng__), 
                                    "assigning variable beta_new");
                    }
                }
                current_statement_begin__ = 141;
                stan::model::assign(y_new, 
                            stan::model::cons_list(stan::model::index_uni(n_new), stan::model::nil_index_list()), 
                            (dot_product(stan::model::rvalue(xreg_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(n_new), stan::model::nil_index_list())), "xreg_new"), stan::model::rvalue(beta_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(n_new), stan::model::nil_index_list())), "beta_new")) + normal_rng(0, sigma_y, base_rng__)), 
                            "assigning variable y_new");
            }
            // validate, write generated quantities
            current_statement_begin__ = 104;
            size_t y_rep_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
                vars__.push_back(y_rep(j_1__));
            }
            current_statement_begin__ = 105;
            size_t beta_j_2_max__ = n;
            size_t beta_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 106;
            size_t y_new_j_1_max__ = n_new;
            for (size_t j_1__ = 0; j_1__ < y_new_j_1_max__; ++j_1__) {
                vars__.push_back(y_new(j_1__));
            }
            current_statement_begin__ = 107;
            size_t beta_new_j_2_max__ = n_new;
            size_t beta_new_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_new_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_new_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_new(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    static std::string model_name() {
        return "model_rw1_model";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "P1_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t y_rep_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_2_max__ = n;
        size_t beta_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t y_new_j_1_max__ = n_new;
        for (size_t j_1__ = 0; j_1__ < y_new_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_new" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_new_j_2_max__ = n_new;
        size_t beta_new_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_new_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_new_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_new" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "P1_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t y_rep_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_2_max__ = n;
        size_t beta_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t y_new_j_1_max__ = n_new;
        for (size_t j_1__ = 0; j_1__ < y_new_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_new" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_new_j_2_max__ = n_new;
        size_t beta_new_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_new_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_new_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_new" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_rw1_model_namespace::model_rw1_model stan_model;
#endif
