% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_stamp.R
\name{time_stamp}
\alias{time_stamp}
\title{Generate a Random Sequence of Times in H:M:S Format}
\usage{
time_stamp(n, x = seq(0, 23, by = 1), prob = NULL, random = FALSE,
  name = "Time")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{random}{logical.  If \code{TRUE} the times are randomized, otherwise the
times are sequential.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of time elements in H:M:S format.
}
\description{
Generate a random vector of times in H:M:S format.
}
\examples{
time_stamp(20)
time_stamp(20, random=TRUE)
pie(table(time_stamp(2000, x = seq(0, 23, by = 2), prob = probs(12))))
}
\seealso{
\code{\link[chron]{times}}
}
\keyword{time}
