% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_data_frame.R
\name{r_data_frame}
\alias{r_data_frame}
\title{Data Frame Production (From Variable Functions)}
\usage{
r_data_frame(n, ..., rep.sep = "_")
}
\arguments{
\item{n}{The length to pass to the randomly generated vectors.}

\item{rep.sep}{A separator to use for repeated variable names.  For example
if the \code{\link[wakefield]{age}} is used three times
(\code{r_data_frame(age, age, age)}), the name "Age" will be assigned to all
three columns.  The results in column names \code{c("Age_1", "Age_2", "Age_3")}.
To turn of this behavior use  \code{rep.sep = NULL}.  This results in
\code{c("Age", "Age.1", "Age.2")} column names in the
\code{\link[base]{data.frame}}.}

\item{\ldots}{A set of optionally named arguments.  Using \pkg{wakefield}
variable functions require no name or call parenthesis.}
}
\value{
Returns a \code{\link[dplyr]{tbl_df}}.
}
\description{
Produce a \code{\link[dplyr]{tbl_df}} data frame that allows the user to
lazily pass unnamed \pkg{wakefield} variable functions (optionally, without
call parenthesis).
}
\examples{
r_data_frame(n = 30,
    id,
    race,
    age,
    sex,
    hour,
    iq,
    height,
    died,
    Scoring = rnorm,
    Smoker = valid
)

r_data_frame(n = 30,
    id,
    race,
    age(x = 8:14),
    Gender = sex,
    Time = hour,
    iq,
    grade, grade, grade,  #repeated measures
    height(mean=50, sd = 10),
    died,
    Scoring = rnorm,
    Smoker = valid
)

r_data_frame(n = 500,
    id,
    age, age, age,
    grade, grade, grade
)

## Repeated Measures/Time Series
r_data_frame(n=100,
    id,
    age,
    sex,
    r_series(likert, 3),
    r_series(likert, 4, name = "Item", integer = TRUE)
)

## Expanded Dummy Coded Variables
r_data_frame(n=100,
    id,
    age,
    r_dummy(sex, prefix=TRUE),
    r_dummy(political)
)

## `peek` to view al columns
## `plot` (`table_heat`) for a graphic representation
library(dplyr)
r_data_frame(n=100,
    id,
    dob,
    animal,
    grade, grade,
    death,
    dummy,
    grade_letter,
    gender,
    paragraph,
    sentence
) \%>\%
   r_na() \%>\%
   peek \%>\%
   plot(palette = "Set1")
}
\references{
\url{http://stackoverflow.com/a/29617983/1000343}
}
\seealso{
\code{\link[wakefield]{r_list}},
\code{\link[wakefield]{r_series}}
\code{\link[wakefield]{r_dummy}}
}
\author{
Josh O'Brien and Tyler Rinker <tyler.rinker@gmail.com>.
}
