% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasureBoot.R
\name{ineq.weighted.boot}
\alias{ineq.weighted.boot}
\title{ineq.weighted.boot}
\usage{
ineq.weighted.boot(
  X,
  W = rep(1, length(X)),
  B = 10,
  Atkinson.e = 1,
  Jenkins.alfa = 0.8,
  Entropy.e = 0.5,
  Kolm.p = 1,
  keepSamples = FALSE,
  keepMeasures = FALSE,
  conf.alpha = 0.05,
  calib.boot = FALSE,
  Xs = rep(1, length(X)),
  total = sum(W),
  calib.method = "truncated"
)
}
\arguments{
\item{X}{is a data vector}

\item{W}{is a vector of weights}

\item{B}{numer of bootstrap samples.}

\item{Atkinson.e}{is a parameter for calculating the value of the Atkinson coefficient}

\item{Jenkins.alfa}{is the Jenkins coefficient parameter}

\item{Entropy.e}{is a entropy parameter}

\item{Kolm.p}{is a Kolm parameter}

\item{keepSamples}{if TRUE, it returns bootstrap samples of data (Xb) and weights (Wb)}

\item{keepMeasures}{if TRUE, it returns values of all inequality measures for each bootstrap sample}

\item{conf.alpha}{significance level for confidence interval}

\item{calib.boot}{if FALSE, then naive bootstrap is performed, calibrated bootstrap elsewhere}

\item{Xs}{matrix of calibration variables}

\item{total}{vector of population totals}

\item{calib.method}{weights' calibration method for function calib (sampling)}
}
\value{
By default this functions returns a data frame from ineq.weighted for weighted mean and weighted total of X as well as for each inequality measure extended with bootstrap results: expected value, bias (in \%), standard deviation, coefficient of variation, lower and upper bound of confidence interval.  If keepSamples=TRUE or keepMeasures==TRUE then the output becomes a list. If keepSamples=TRUE, the functions returns  Xb and Wb, which are the samples of vector data and the samples of weights, respectively. If keepMeasures==TRUE, the functions returns Mb, which is a set of inequality measures from bootstrapping.
}
\description{
For weighted mean and weighted total of X as well as for each inequality measure, returns outputs from ineq.weighted and bootstrap outcomes: expected value, bias (in \%), standard deviation, coefficient of variation, lower and upper bound of confidence interval.
}
\examples{
X=c(1,2,3,4,5,6,7,8,9)
W=c(2,5,6,7,3,4,5,2,5)
ineq.weighted.boot(X,W)

}
