% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_server_jobs.R
\name{get_server_jobs}
\alias{get_server_jobs}
\title{Title}
\usage{
get_server_jobs(
  base_url,
  api_version = 3.4,
  site_id,
  token,
  page_size = 100,
  include_metadata = FALSE
)
}
\arguments{
\item{base_url}{The url of the Tableau Server.}

\item{api_version}{The api version; default set to 3.4}

\item{site_id}{The site id of the Tableau server to access.}

\item{token}{The access token to the Tableau Rest API.}

\item{page_size}{Number of records to return; default is set to 100.}

\item{include_metadata}{Whether to include metadata; default is set to FALSE}
}
\value{
Dataframe containing information on server jobs.
}
\description{
Title
}
\examples{
\dontrun{
# Get server jobs
jobs <- get_server_jobs(base_url = "https://tableau.server.com",
                        api_version = 3.4,
                        site_id = "your_site_id",
                        token = "your_access_token",
                        page_size = 100,
                        include_metadata = FALSE)
head(jobs)
}
}
\seealso{
Other tableau rest api: 
\code{\link{authenticate_server}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()}
}
\concept{tableau rest api}
