% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_filters.R
\name{prep_df}
\alias{prep_df}
\title{Prepare a dataframe}
\usage{
prep_df(
  lFilters,
  lValues_for_naming,
  df,
  color_var,
  facet = "left",
  facet_var = rlang::sym("VIS_Groep"),
  facet_name_var = rlang::sym("VIS_Groep_naam")
)
}
\arguments{
\item{lFilters}{List of filters to be applied on the dataframe.}

\item{lValues_for_naming}{List of values used for naming.}

\item{df}{Dataframe to be processed.}

\item{color_var}{Variable used for coloring.}

\item{facet}{Facet grid side ("left" by default).}

\item{facet_var}{Variable used for facet grid ("VIS_Groep" by default).}

\item{facet_name_var}{Variable used for facet grid naming ("VIS_Groep_naam" by default).}
}
\value{
A prepared dataframe with applied filters and new columns.
}
\description{
Prepares a dataframe based on provided filters and naming options
}
\details{
This function collapses values from the naming list into a single string,
removes null elements from the filter list, transforms filter list into elements
suitable for filtering, applies filters, adds new columns, and casts var used as color to factor.
}
\examples{
df <- dplyr::tibble(
  VIS_Groep = sample(c("Group1", "Group2", "Group3"), 100, replace = TRUE),
  VIS_Groep_naam = sample(c("Name1", "Name2", "Name3"), 100, replace = TRUE),
  var1 = sample(c("A", "B", "C"), 100, replace = TRUE),
  var2 = rnorm(100),
  color_var = sample(c("Red", "Blue", "Green"), 100, replace = TRUE)
)
lFilters <- list("A;var1")
lValues_for_naming = list("Name1;VIS_Groep_naam", "Name2;VIS_Groep_naam")
color_var = "color_var"
dfPrepared <- prep_df(lFilters, lValues_for_naming, df, color_var, facet = "right")
}
