% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_field_existence.R
\name{assert_field_existence}
\alias{assert_field_existence}
\title{Assert Field Existence in New Data}
\usage{
assert_field_existence(new_data, previous_data, metadata)
}
\arguments{
\item{new_data}{A data frame. The new dataset whose field names need to be checked.}

\item{previous_data}{A data frame. The previous dataset used as a reference for expected fields.}

\item{metadata}{A data frame. Metadata containing a column named \code{raw_field_name}, which defines the expected field names.}
}
\value{
No return value. The function issues warnings if any expected fields are missing in the new dataset.
}
\description{
This function checks whether all fields that existed in a previous dataset are still present in a new dataset, based on a metadata reference.
It warns if any fields from the previous dataset are missing in the new dataset.
}
