% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanonevar.perm.R
\name{scanonevar.perm}
\alias{scanonevar.perm}
\title{scanonevar.perm}
\usage{
scanonevar.perm(sov, n.perms, random.seed = 27599,
  n.cores = parallel::detectCores() - 1, silent = TRUE)
}
\arguments{
\item{sov}{the scanonevar whose significance should be assessed empirically in an FWER-controlling method}

\item{n.perms}{the number of permutations to do}

\item{random.seed}{value to start the random number generator at, for reproducibility}

\item{n.cores}{number of cores to use for the permutations}

\item{silent}{Should all messaging be suppressed?}
}
\value{
27599
}
\description{
\code{scanonevar.perm} conducts many permuted forms of
the \code{scanonevar} inputted, to assess the statistical significance of the results
in the inputted scanonevar in a FWER-controlling manner.
}
\examples{
set.seed(27599)
test.cross <- qtl::sim.cross(map = qtl::sim.map(len = rep(20, 5), n.mar = 5), n.ind = 50)
scanonevar(cross = test.cross)

}
\author{
Robert W. Corty \email{rcorty@gmail.com}
}
