% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmerCluster.R
\name{lmerCluster}
\alias{lmerCluster}
\title{Run a Linear Mixed Effet Model on the mean intensity over a region of interest}
\usage{
lmerCluster(image, mask, fourdOut = NULL, formula, subjData,
  mc.preschedule = TRUE, ncores = 1, ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will call mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. All clusters must be labeled with integers in the mask passed as an argument}

\item{fourdOut}{To be passed to mergeNifti, This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to lmer()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use}

\item{...}{Additional arguments passed to lmer()}
}
\value{
Returns list of models fitted to the mean voxel intensity a region or interest.
}
\description{
This function is able to run a LME using the lmer() function. 
All clusters or region of interest must be labeled with integers in the mask passed as an argument.
The function relies on lmerTest to create p-values using the Satterthwaite Approximation.
}
\examples{


image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(c(rep(0,14),1,2), dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), id = rep(1:5,5))
fm1 <- "~ x + (1|id)"
models <- lmerCluster(image, mask, formula = fm1, subjData = covs, ncores = 1, REML=TRUE)

}

