% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_coords.R
\name{polar_coords}
\alias{polar_coords}
\title{Coordinates for Three Way Polar Plot}
\usage{
polar_coords(
  outcome,
  data,
  pvals = NULL,
  padj = pvals,
  pcutoff = 0.05,
  scheme = c("grey60", "red", "gold2", "green3", "cyan", "blue", "purple"),
  labs = NULL,
  ...
)
}
\arguments{
\item{outcome}{Outcome vector with 3 groups, ideally as a factor. If it is
not a factor, this will be coerced to a factor. This must have exactly 3
levels. NOTE: if `pvals` is given, the order of the levels in `outcome`
must correspond to the order of columns in `pvals`.}

\item{data}{Dataframe or matrix with variables in columns}

\item{pvals}{Matrix or dataframe with p-values. The first column represents a
test across all 3 categories such as one-way ANOVA or likelihood ratio
test. Columns 2-4 represent pairwise tests comparing groups A vs B, A vs C
and B vs C, where A, B, C represent levels 1, 2, 3 in `outcome`. Columns
2-4 must be provided in the correct order. If `pvals` is not given, it is
calculated using the function [calc_pvals].}

\item{padj}{Matrix or dataframe with adjusted p-values. If not supplied,
defaults to use nominal p-values from `pvals`.}

\item{pcutoff}{Cut-off for p-value significance}

\item{scheme}{Vector of colours starting with non-significant variables}

\item{labs}{Optional character vector for labelling groups. Default `NULL`
leads to abbreviated labels based on levels in `outcome` using
[abbreviate]. A vector of length 3 with custom abbreviated names for the
outcome levels can be supplied. Otherwise a vector length 7 is expected, of
the form "ns", "B+", "B+C+", "C+", "A+C+", "A+", "A+B+", where "ns" means
non-significant and A, B, C refer to levels 1, 2, 3 in `outcome`, and must
be in the correct order.}

\item{...}{Optional arguments passed to [calc_pvals]}
}
\value{
Returns an S4 'volc3d' object containing:
\itemize{
  \item{'df'} A list of 2 dataframes. Each dataframe contains both x,y,z
  coordinates as well as polar coordinates r, angle. The first dataframe has
  coordinates on scaled data. The 2nd dataframe has unscaled data (e.g. log2
  fold change for gene expression).
  \item{'outcome'} The three-group contrast factor used for comparisons
  \item{'data'} Dataframe or matrix containing the expression data
  \item{'pvals'} A dataframe containing p-values. First column is the 3-way
  comparison (LRT or ANOVA). Columns 2-4 are pairwise comparisons between
  groups A vs B, A vs C and B vs C, where A, B, C are the 3 levels in the
  outcome factor.
  \item{'padj'} A dataframe containing p-values adjusted for multiple testing
}
}
\description{
This function creates a 'volc3d' object of S3 class for downstream plots 
containing the p-values from a three-way group comparison, expression data 
sample data and polar coordinates.
}
\examples{
data(example_data)
syn_polar <- polar_coords(outcome = syn_example_meta$Pathotype,
                          data = t(syn_example_rld))

}
