% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich_rttm.R
\name{enrich_rttm}
\alias{enrich_rttm}
\title{Enrich RTTM files}
\usage{
enrich_rttm(listRttm, silence.gap = 0.5, as.tibble = TRUE)
}
\arguments{
\item{listRttm}{A list containing RTTM files.}

\item{silence.gap}{The silence gap (in seconds) between adjacent words in a keyword. Rows with \code{tdur <= silence.gap} are removed. (default: \code{0.5})}

\item{as.tibble}{Logical. Should it return a tibble?}
}
\value{
A list containing either data frames or tibbles obtained from standard RTTM files. See 'voice::read_rttm'.
}
\description{
Enrich Rich Transcription Time Marked (RTTM) files obtained from '\code{voice::read_rttm}'.
}
\examples{
\donttest{
library(voice)

url0 <- 'https://raw.githubusercontent.com/filipezabala/voiceAudios/main/rttm/sherlock0.rttm'
download.file(url0, destfile = paste0(tempdir(), '/sherlock0.rttm'))
url1 <- 'https://raw.githubusercontent.com/filipezabala/voiceAudios/main/rttm/sherlock1.rttm'
download.file(url0, destfile = paste0(tempdir(), '/sherlock1.rttm'))

rttm <- voice::read_rttm(tempdir())
(er <- voice::enrich_rttm(rttm))
class(er)
lapply(er, class)
}
}
\references{
\url{https://www.nist.gov/system/files/documents/itl/iad/mig/KWS15-evalplan-v05.pdf}
}
\seealso{
\code{voice::read_rttm}
}
