% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_discretebeta_sim.R
\name{racusum_discretebeta_arl_sim}
\alias{racusum_discretebeta_arl_sim}
\title{Compute ARLs of RA-CUSUM control charts using simulation}
\usage{
racusum_discretebeta_arl_sim(r, shape1, shape2, coeff, h, RA = 2, rs = 72,
  RQ = 1)
}
\arguments{
\item{r}{Integer Vector. Number of runs.}

\item{shape1}{Double. Shape parameter \eqn{\alpha}{alpha} \code{> 0} of the beta distribution.}

\item{shape2}{Double. Shape parameter \eqn{\beta}{beta} \code{> 0} of the beta distribution.}

\item{coeff}{Numeric Vector. Estimated intercept and slope coefficients
from a binary logistic regression model.}

\item{h}{Double. Control Chart limit for detecting deterioration/improvement.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}.}

\item{rs}{Integer. Number of intervals between \code{0} and the maximum risk score.}

\item{RQ}{Double. Defines the performance of a surgeon with the odds ratio ratio of death.
\code{Q}.}
}
\value{
Returns a single value which is the Run Length.
}
\description{
Compute ARLs of RA-CUSUM control charts using simulation.
}
\examples{
\dontrun{
library(vlad)
m <- 1e3
RLS <- sapply(1:m, racusum_discretebeta_arl_sim, shape1=1, shape2=3, coeff=c(-3.6798, 0.0768),
h=4.5, RA=2,  rs=71+1, RQ=1)
data.frame(cbind(ARL=mean(RLS), ARLSE=sd(RLS)/sqrt(m)))
}

}
\author{
Philipp Wittenberg
}
