% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_beta_mc.R
\name{racusum_beta_crit_mc}
\alias{racusum_beta_crit_mc}
\title{Compute alarm threshold of RA-CUSUM control chart assuming patient mix with beta
distribution using Markov chain approximation.}
\usage{
racusum_beta_crit_mc(
  L0,
  RA,
  g0,
  g1,
  shape1,
  shape2,
  method = 1,
  r = 600,
  jmax = 4,
  verbose = TRUE,
  RQ = 1
)
}
\arguments{
\item{L0}{Double. Prespecified Average Run Length.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}. Odds ratio of death under the null hypotheses is \code{1}.}

\item{g0}{Double. Estimated intercept coefficient from a binary logistic regression model.}

\item{g1}{Double. Estimated slope coefficient from a binary logistic regression model.}

\item{shape1}{Double. Shape parameter \eqn{\alpha}{alpha} \code{> 0} of the beta distribution.}

\item{shape2}{Double. Shape parameter \eqn{\beta}{beta} \code{> 0} of the beta distribution.}

\item{method}{Character. If \code{method = "1"} a combination of Sequential Probability Ratio
Test and Toeplitz matrix structure is used to calculate the ARL. \code{"2"} solves a linear
equation system using the classical approach of \emph{Brook and Evans (1972)} to calculate the
ARL.}

\item{r}{Double. Matrix system dimension.}

\item{jmax}{Integer. Number of digits for grid search.}

\item{verbose}{Logical. If \code{FALSE} a quiet calculation of \code{h} is done. If \code{TRUE}
verbose output of the search procedure (see details) is included.}

\item{RQ}{Double. Defines the performance of a surgeon with the odds ratio ratio of death.}
}
\value{
Returns a single value which is the control limit \code{h} for a given In-control ARL.
}
\description{
Compute alarm threshold of risk-adjusted CUSUM control chart assuming patient mix
 with beta distribution using Markov chain approximation.
}
\details{
Determines the control limit for given in-control ARL (\code{"L0"}) using
\code{\link{racusum_beta_arl_mc}} by applying a grid search.
}
\examples{
\dontrun{
library(vlad)
racusum_beta_crit_mc(L0=7500, RA=2, g0=-3.6798, g1=0.0768*71, shape1=.61, shape2=4.09, r=1000)
}
}
\author{
Philipp Wittenberg
}
