% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{facet_boxplot}
\alias{facet_boxplot}
\title{Faceted boxplots with points or violin plots}
\usage{
facet_boxplot(
  df,
  x,
  y,
  facet_var = NULL,
  boxplot_colors = NULL,
  shape = c("boxplot", "violin"),
  plot_points = TRUE
)
}
\arguments{
\item{df}{a data frame containing all the variables matching the remaining arguments}

\item{x}{categorical variable}

\item{y}{continuous variable}

\item{facet_var}{optional variable to facet data}

\item{boxplot_colors}{list of colors to use as fill for boxplots}

\item{shape}{either "boxplot" or "violin"}

\item{plot_points}{boolean variable to overlay jittered points or not. Default is \code{TRUE}}
}
\value{
a \link[ggplot2:ggplot]{ggplot2::ggplot} object
}
\description{
Faceted boxplots with points or violin plots
}
\examples{
facet_boxplot(iris, x = "Species", y = "Sepal.Length", facet_var = "Species")
}
