% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.sr.R
\name{cm.sr}
\alias{cm.sr}
\title{Selecting the best 2-Band combinations for Simple Ratio (SR)}
\usage{
cm.sr(S, x, w = wavelength(S), w.unit = NULL, cm.plot = FALSE)
}
\arguments{
\item{S}{A matrix of spectral data, a row is a spectrum across all spectral bands.}

\item{x}{A vector.}

\item{w}{A vector of wavelength.}

\item{w.unit}{Character string, default = NULL,}

\item{cm.plot}{A logic value for whether plotting the coefficient matrix or not, default FALSE.}
}
\value{
\item{cm}{Returns a correlation coefficients matrix.}
}
\description{
This function develops a optimization algorithm based on correlation analysis between spectral matrix 'spectra' and the
vegetation variable of interest x, which
determines the best spectral band combinations of the full spectrum that are most predictive for 'x'.
}
\details{
This function runs a calculation of \deqn{ NDVI = \lambda_i / \lambda_j } using all the possible pairs/combinations of any two bands (i,j)
within the full spectrum range thoroughly. A correlation analysis is then performed between the x and all possible NDVIs, and it calculates
the correlation coefficients (r) which indicates the predictive performance of each NDVI and its corresponding two-band combination. The
output is the wavelength (nm) indicating the best two bands that produce the highest value of r.
}
\examples{
library(visa)
data(NSpec.DF)
x <- NSpec.DF$N # nitrogen
S <- NSpec.DF$spectra[, seq(1, ncol(NSpec.DF$spectra), 10)] # resampled to 10 nm steps
cm <- cm.sr(S, x, cm.plot = FALSE)

}
\seealso{
\code{\link{cm.nsr}}
}
