% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts_to_cases.R
\name{counts_to_cases}
\alias{counts_to_cases}
\title{Convert data frame of counts to data frame of cases.
data frame must contain a column with frequencies (counts) as generated by
as.data.frame from a contingency table}
\usage{
counts_to_cases(x, countcol = "Freq")
}
\arguments{
\item{x}{a \code{data.frame} of counts generated from a contingency table.}

\item{countcol}{character string, name of the column of x containing the
counts. Default name of the column is  'Freq'.}
}
\value{
data frame of cases of dimension (total number of counts as sum of
'Freq' in x) times 2.
}
\description{
Convert data frame of counts to data frame of cases.
data frame must contain a column with frequencies (counts) as generated by
as.data.frame from a contingency table
}
\examples{

counts_to_cases(as.data.frame(HairEyeColor[, , 1]), countcol = "Freq")

}
