% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_theme.R
\name{apply_theme}
\alias{apply_theme}
\title{Applies a theme to a ggplot object.}
\usage{
apply_theme(gg, visR_theme_dict = NULL)
}
\arguments{
\item{gg}{object of class \code{ggplot}}

\item{visR_theme_dict}{nested list containing possible font options}
}
\value{
object of class \code{ggplot}
}
\description{
Takes in the styling options defined through \code{visR::define_theme} and applies them to a plot.
}
\examples{

library(visR)

theme <- visR::define_theme(strata = list("SEX" = list("F" = "red",
                                                       "M" = "blue"),
                                          "TRTA" = list("Placebo" = "cyan",
                                                        "Xanomeline High Dose" = "purple",
                                                        "Xanomeline Low Dose" = "brown")),
                            fontsizes = list("axis" = 12,
                                             "ticks" = 10,
                                             "legend_title" = 10,
                                             "legend_text" = 8),
                            fontfamily = "Helvetica",
                            grid = FALSE,
                            bg = "transparent",
                            legend_position = "top")


gg <- adtte \%>\%
  visR::estimate_KM(strata = "SEX") \%>\%
  visR::visr() \%>\%
  visR::add_CI() \%>\%
  visR::apply_theme(theme)
gg

}
