% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_Kalman_variances-statespace.R
\name{select_Kalman_variances}
\alias{select_Kalman_variances}
\title{Select time-invariant variances of a State-Space Model}
\usage{
select_Kalman_variances(ssm, X, y, method = "igd", ...)
}
\arguments{
\item{ssm}{the statespace object}

\item{X}{explanatory variables}

\item{y}{time series}

\item{method}{(optional, default \code{'igd'}) it can be either
\describe{
\item{\code{'igd'}}{\code{iterative_grid_search} is called}
\item{\code{'em'}}{\code{expectation_maximization} is called}
}}

\item{...}{additional parameters}
}
\value{
a new statespace object with new values in \code{kalman_params}
}
\description{
\code{select_Kalman_variances} is a function to choose hyper-parameters of the
linear Gaussian State-Space Model with time-invariant variances. It relies on the
functions \code{iterative_grid_search} and \code{expectation_maximization}.
}
