% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_aggregate.R
\name{VeloxRaster_aggregate}
\alias{VeloxRaster_aggregate}
\title{Aggregate}
\arguments{
\item{factor}{A numeric vector of length 1 or 2 indicating the aggregation factor in the x and y dimensions.
Must be positive integers > 1.}

\item{aggtype}{A character string indicating the aggregation type. See Details.}
}
\value{
Void.
}
\description{
Aggregates a VeloxRaster object to a lower resolution.
}
\details{
\code{aggtype} must be one of the following: "sum", "mean", "min", "max", "median".
}
\examples{
## Make VeloxRaster
mat <- matrix(1:100, 10, 10)
vx <- velox(mat, extent=c(0,1,0,1), res=c(0.1,0.1), crs="+proj=longlat +datum=WGS84 +no_defs")
## Aggregate
vx$aggregate(factor=c(2,2), aggtype='sum')
}

