% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplicativeBeta.R
\name{multiplicativeBeta}
\alias{completeTurnovers}
\alias{multiplicativeBeta}
\alias{multiplicativeBeta,completeTurnovers,notEndemic}
\alias{notEndemic}
\title{Multiplicative Diversity Partitioning}
\usage{
multiplicativeBeta(CommunityMatrix)

completeTurnovers(CommunityMatrix)

notEndemic(CommunityMatrix)
}
\arguments{
\item{CommunityMatrix}{a matrix}
}
\value{
A numeric vector
}
\description{
Calculates beta diversity under various Multiplicative Diversity Partitioning paradigms.
}
\details{
Takes a community matrix (see \code{presenceMatrix} or \code{abundanceMatrix}) and returns one of three types of multiplicative beta diversity discussed in Tuomisto, H (2010) "A diversity of beta diversities: straightening up a concept gone awry. Part 1. Defining beta diversity as a function of alpha and gamma diversity". \emph{Ecography} 33:2-22.
\itemize{
 \item{\code{multiplicativeBeta(CommunityMatrix):}} {Calculates the original beta diversity ratio - Gamma/Alpha. It quantifies how many times as rich gamma is than alpha.}
 \item{\code{completeTurnovers(CommunityMatrix):}} {The number of complete effective species turnovers observed among compositonal units in the dataset - (Gamma-Alpha)/Alpha.}
 \item{\code{notEndemic(CommunityMatrix):}} {The proportion of taxa in the dataset not limited to a single sample - (Gamma-Alpha)/Gamma}
}
}
\examples{
# Download a test dataset of pleistocene bivalves from the Paleobiology Database.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia","Pleistocene","Pleistocene")

# Create a community matrix with tectonic plates as "samples".
# CommunityMatrix<-abundanceMatrix(DataPBDB,"geoplate")

# "True local diversity ratio"
# multiplicativeBeta(CommunityMatrix)

# Whittaker's effective species turnover
# completeTurnovers(CommunityMatrix)

# Proportional effective species turnover
# notEndemic(CommunityMatrix)

}
\author{
Andrew A. Zaffos
}

