% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_ldv.R
\name{age_ldv}
\alias{age_ldv}
\title{Returns amount of vehicles at each age}
\usage{
age_ldv(x, name = "age", a = 1.698, b = -0.2, agemin = 1, agemax = 50,
  k = 1, bystreet = F, net, message = TRUE)
}
\arguments{
\item{x}{Numeric; numerical vector of vehicles with length equal to lines features of raod network}

\item{name}{Character; of vehicle assigned to columns of dataframe}

\item{a}{Numeric; parameter of survival equation}

\item{b}{Numeric; parameter of survival equation}

\item{agemin}{Integer; age of newest vehicles for that category}

\item{agemax}{Integer; age of oldest vehicles for that category}

\item{k}{Integer; multiplication factor}

\item{bystreet}{Logical; when TRUE it is expecting that 'a' and 'b' are numeric vectors with length equal to x}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}

\item{message}{Logical;  message with average age and total numer of vehicles}
}
\value{
dataframe of age distrubution of vehicles
}
\description{
\code{\link{age_ldv}} returns amount of vehicles at each age
}
\examples{
{
data(net)
PC_E25_1400 <- age_ldv(x = net$ldv, name = "PC_E25_1400")
plot(PC_E25_1400)
PC_E25_1400 <- age_ldv(x = net$ldv, name = "PC_E25_1400", net = net)
plot(PC_E25_1400)
}
}
