% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trait_stats.R
\name{trait_stats}
\alias{trait_stats}
\alias{trait_stats,character,vegtable-method}
\alias{trait_stats,formula,vegtable-method}
\alias{trait_proportion}
\alias{trait_proportion,character,vegtable-method}
\alias{trait_proportion,formula,vegtable-method}
\title{Statistics and proportion for taxon traits}
\usage{
trait_stats(trait, object, ...)

\S4method{trait_stats}{character,vegtable}(
  trait,
  object,
  FUN,
  head_var = "ReleveID",
  taxon_levels,
  merge_to,
  weight,
  suffix = "_stats",
  in_header = TRUE,
  na.rm = TRUE,
  ...
)

\S4method{trait_stats}{formula,vegtable}(trait, object, ...)

trait_proportion(trait, object, ...)

\S4method{trait_proportion}{character,vegtable}(
  trait,
  object,
  head_var = "ReleveID",
  trait_levels,
  taxon_levels,
  merge_to,
  include_nas = TRUE,
  weight,
  suffix = "_prop",
  in_header = TRUE,
  ...
)

\S4method{trait_proportion}{formula,vegtable}(trait, object, ...)
}
\arguments{
\item{trait}{Either a character value indicating the name of trait variable
or a formula as \code{'trait ~ head_var'}. Note that you can add multiple
variables in the form \code{trait_1 + ... + trait_n ~ head_var}.}

\item{object}{A \linkS4class{vegtable} object.}

\item{...}{Further arguments passed among methods. In the case of the
character method, they are passed to 'FUN'.}

\item{FUN}{A function usually defined as \code{foo(x, ...)} or as
\code{foo(x, w, ...)} for weighted statistics.}

\item{head_var}{Character value, the name of the variable at slot header to
be used as aggregation level for the calculation of statistics or
proportions.
If not provided, the function will use \strong{ReleveID} by default.}

\item{taxon_levels}{Character vector indicating the selected taxonomic ranks
to be considered in the output.}

\item{merge_to}{Character value indicating the taxonomic rank for
aggregation of taxa.
All ranks lower than the one indicated here will be assigned to the
respective parents at the required taxonomic rank.}

\item{weight}{Character value indicating the name of the variable at slot
\strong{samples} used as weight for the proportions. Usually the numeric
abundance.}

\item{suffix}{A suffix added to the name of the trait variable or to the
levels of categorical trait variables. I is meant to avoid homonymous
variables within the same object.}

\item{in_header}{Logical value indicating whether the output should be
inserted in the slot \strong{header} or provided as data frame. In the case
that \code{'head_var'} (or the right term in the formula method) is different
from \strong{ReleveID}, the statistics and proportions will be inserted in the
respective data frame at slot \strong{relations}.}

\item{na.rm}{A logical value indicating whether NAs should be removed for the
calculation of statistics or not. It is passed to \code{'FUN'} in
\code{trait_stats()}.}

\item{trait_levels}{Character vector indicating a selection of levels from a
trait, in the case that some levels should be ignored in the output.
Trait levels that are skipped at output will be still used for the
calculation of proportions.
This argument gets only applied for the character method.}

\item{include_nas}{Logical value indicating whether NAs should be considered
for the calculation of proportions or not.}
}
\value{
A data frame with the proportions of traits levels or statistics for
the trait variable, or an object of class \linkS4class{vegtable} including those
results at the slot \code{header}.
}
\description{
Calculation of statistics and proportions of taxon traits for plot
observations or groups of observations, considering data relationships,
taxonomic ranks and the handling of not available values.

In \code{trait_stats()} you can use customized functions, which have to be
defined as \code{foo(x, w, ...)}, where \code{'x'} is the (numeric) taxon trait and
\code{'w'} is the weight (e.g. the abundance).

With the arguments \code{taxon_levels} and \code{merge_to} the used taxonomic ranks
can be defined, where the first one indicates which ranks
have to be considered in the calculations and the second one determine the
aggregation of taxa from a lower level to a parental one.
}
\examples{
veg <- cover_trans(Kenya_veg, to = "cover")
veg <- trait_proportion("lf_behn_2018", veg,
  trait_levels = "obligate_annual", weight = "cover", include_nas = FALSE
)
summary(veg$obligate_annual_prop)
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
