% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serializers-yaml.R
\name{YAML}
\alias{YAML}
\title{The YAML serializer}
\description{
class with methods for serializing via the \pkg{yaml} package
}
\examples{
\dontrun{
(yy <- YAML$new(path = "stuff2"))
fun <- yy$serialize()
fun(list(http_interactions = list(response = list(body = "bar"))),
  path = yy$path, bytes = FALSE)
yy$deserialize_path()
yy$deserialize_string(string = "- hey\n- hi\n- hello")
yy$deserialize_string(string = "- foo\n- bar\n- 3.14")
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{file_extension}}{(character) A file extension}

\item{\code{path}}{(character) full path to the yaml file}

\item{\code{string}}{(character) path string}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{YAML$new()}}
\item \href{#method-serialize}{\code{YAML$serialize()}}
\item \href{#method-deserialize_string}{\code{YAML$deserialize_string()}}
\item \href{#method-deserialize_path}{\code{YAML$deserialize_path()}}
\item \href{#method-clone}{\code{YAML$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new YAML object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAML$new(file_extension = ".yml", path = NULL, string = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_extension}}{(character) A file extension}

\item{\code{path}}{(character) path to the cassette, excluding the cassette
directory and the file extension. only use if not passing a string}

\item{\code{string}}{(character) path string. only use if not passing a path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{YAML} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-serialize"></a>}}
\if{latex}{\out{\hypertarget{method-serialize}{}}}
\subsection{Method \code{serialize()}}{
Serializes the given hash using internal fxn write_yaml
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAML$serialize(x, path, bytes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(list) the object to serialize}

\item{\code{path}}{(character) the file path}

\item{\code{bytes}}{(logical) whether to preserve exact body bytes or not}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(character) the YAML string to write to disk
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-deserialize_string"></a>}}
\if{latex}{\out{\hypertarget{method-deserialize_string}{}}}
\subsection{Method \code{deserialize_string()}}{
Deserializes the given string using yaml::yaml.load
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAML$deserialize_string(string = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{string}}{(character) the YAML string}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(list) the deserialized object, an R list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-deserialize_path"></a>}}
\if{latex}{\out{\hypertarget{method-deserialize_path}{}}}
\subsection{Method \code{deserialize_path()}}{
Deserializes the given string using yaml::yaml.load_file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAML$deserialize_path()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(list) the deserialized object, an R list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{YAML$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
