% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.mean2}
\alias{meta.ave.mean2}
\title{Confidence interval for an average mean difference from 2-group studies}
\usage{
meta.ave.mean2(alpha, m1, m2, sd1, sd2, n1, n2, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for group 1}

\item{m2}{vector of estimated means for group 2}

\item{sd1}{vector of estimated SDs for group 1}

\item{sd2}{vector of estimated SDs for group 2}

\item{n1}{vector of group 1 sample sizes}

\item{n2}{vector of group 2 sample sizes}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item df - degrees of freedom
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average mean difference from two or more 2-group studies. A Satterthwaite
adjustment to the degrees of freedom is used to improve the accuracy of the
confidence intervals. Equality of variances within or across studies is not
assumed.
}
\examples{
m1 <- c(7.4, 6.9)
m2 <- c(6.3, 5.7)
sd1 <- c(1.72, 1.53)
sd2 <- c(2.35, 2.04)
n1 <- c(40, 60)
n2 <- c(40, 60)
meta.ave.mean2(.05, m1, m2, sd1, sd2, n1, n2, bystudy = TRUE)

# Should return:
#         Estimate        SE        LL       UL        df
# Average     1.15 0.2830183 0.5904369 1.709563 139.41053
# Study 1     1.10 0.4604590 0.1819748 2.018025  71.46729
# Study 2     1.20 0.3292036 0.5475574 1.852443 109.42136


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
