% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.semipartial}
\alias{se.semipartial}
\title{Computes the standard error for a semipartial correlation}
\usage{
se.semipartial(cor, r2, n)
}
\arguments{
\item{cor}{sample semipartial correlation}

\item{r2}{squared multiple correlation for full model}

\item{n}{sample size}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimate of semipartial correlation
\item SE - standard error
}
}
\description{
This function can be used to compute the standard error of a
semipartial correlation using the sample correlation, sample
size, and squared multiple correlation for the full model.
The effect size estimate and standard error output from this
function can be used as input in the \link[vcmeta]{meta.ave.gen},
\link[vcmeta]{meta.lc.gen}, and \link[vcmeta]{meta.lm.gen} functions
in applications where a combination of different types of correlations
are used in the meta-analysis.
}
\examples{
se.semipartial(.40, .25, 60)

# Should return: 
#                          Estimate        SE
# Semipartial correlation:      0.4 0.1063262


}
