% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_sunburst}
\alias{v_sunburst}
\title{Create a Sunburst Chart}
\usage{
v_sunburst(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  drill = TRUE,
  gap = 5,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{drill}{Drill-down function switch.}

\item{gap}{Layer gap, supports passing an array to configure layer gaps layer by layer.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Sunburst Chart
}
\examples{

library(vchartr)

# Create a sunburst and auto hide labels
vchart(countries_gdp) \%>\%
  v_sunburst(
    aes(lvl1 = REGION_UN, lvl2 = SUBREGION, lvl3 = ADMIN, value = GDP_MD),
    gap = 10,
    labelAutoVisible = list(
      enable = TRUE
    ),
    labelLayout = list(
      align = "center",
      rotate = "radial"
    )
  )


# Custom tooltip
vchart(countries_gdp) \%>\%
  v_sunburst(
    aes(lvl1 = REGION_UN, lvl2 = SUBREGION, lvl3 = ADMIN, value = GDP_MD)
  ) \%>\% 
  v_specs_tooltip(
    mark = list(
      title = list(
        value = JS("val => val?.datum?.map(data => data.name).join(' / ')")
      )
    )
  )


# Custom layout options
vchart(countries_gdp) \%>\%
  v_sunburst(
    aes(lvl1 = REGION_UN, lvl2 = SUBREGION, lvl3 = ADMIN, value = GDP_MD),
    gap = 0,
    innerRadius = c(0, 0.4, 0.8),
    outerRadius = c(0.3, 0.7, 0.85),
    labelAutoVisible = list(
      enable = TRUE,
      circumference = 1
    ),
    labelLayout = list(
      list(
        align = "center",
        rotate = "tangential",
        offset = 0
      ),
      NULL,
      list(
        align = "start",
        rotate = "radial",
        offset = 15
      )
    )
  ) \%>\% 
  v_specs(padding = 70)
}
