# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' calculate the number of heterozygous SNPs for each sample
#' @param vcffile path to the VCF file with index
#' @param region  region to extract, default "" for all
#' @param pass restrict to variants with FILTER==PASS
#' @param qual restrict to variants with QUAL > qual.
#' @param samples samples to extract, default "-" for all
#' @return A list of heterozygosity couts for each sample along with its id in the vcf header
#' @export
heterozygosity <- function(vcffile, region = "", samples = "-", pass = FALSE, qual = 0) {
    .Call(`_vcfppR_heterozygosity`, vcffile, region, samples, pass, qual)
}

#' @name vcfreader
#' @title API for manipulating the VCF/BCF.
#' @description Type the name of the class to see the details and methods
#' @return A C++ class with the following fields/methods for manipulating the VCF/BCF
#' @field new Constructor given a vcf file \itemize{
#' \item Parameter: vcffile - The path of a vcf file
#' }
#' @field new Constructor given a vcf file and the region \itemize{
#' \item Parameter: vcffile - The path of a vcf file
#' \item Parameter: region - The region to be constrained
#' }
#' @field new Constructor given a vcf file, the region and the samples \itemize{
#' \item Parameter: vcffile - The path of a vcf file
#' \item Parameter: region - The region to be constrained
#' \item Parameter: samples - The samples to be constrained. Comma separated list of samples to include (or exclude with "^" prefix).
#' }
#' @field variant Try to get next variant record. return FALSE if there are no more variants or hit the end of file, otherwise TRUE.
#' @field chr Return the CHROM field of current variant
#' @field pos Return the POS field of current variant
#' @field id Return the CHROM field of current variant
#' @field ref Return the REF field of current variant
#' @field alt Return the ALT field of current variant
#' @field qual Return the QUAL field of current variant
#' @field filter Return the FILTER field of current variant
#' @field info Return the INFO field of current variant
#' @field infoInt Return the tag value of integer type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}
#' @field infoFloat Return the tag value of float type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}
#' @field infoStr Return the tag value of string type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}
#' @field infoIntVec Return the tag value in a vector of integer type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}
#' @field infoFloatVec Return the tag value in a vector of float type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}
#' @field genotypes Return the genotype values in a vector of integers  \itemize{ \item Parameter: collapse - Boolean value indicates wheather to collapse the size of genotypes, eg, return diploid genotypes.}
#' @field formatInt Return the tag value of integer type for each sample in FORAMT field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in FORAMT}
#' @field formatFloat Return the tag value of float type for each sample in FORAMT field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in FORAMT}
#' @field formatStr Return the tag value of string type for each sample in FORAMT field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in FORAMT}
#' @field isSNP Test if current variant is exculsively a SNP or not
#' @field isIndel Test if current variant is exculsively a INDEL or not
#' @field isSV Test if current variant is exculsively a SV or not
#' @field isMultiAllelics Test if current variant is exculsively a Multi Allelics or not
#' @field isMultiAllelicSNP Test if current variant is exculsively a Multi Biallelics (SNPs) or not
#' @field hasSNP Test if current variant has a SNP or not
#' @field hasINDEL Test if current variant has a INDEL or not
#' @field hasINS Test if current variant has a INS or not
#' @field hasDEL Test if current variant has a DEL or not
#' @field hasMNP Test if current variant has a MNP or not
#' @field hasBND Test if current variant has a BND or not
#' @field hasOTHER Test if current variant has a OTHER or not
#' @field hasOVERLAP Test if current variant has a OVERLAP or not
#' @field nsamples Return the number of samples
#' @field samples Return a vector of samples id
#' @field header Return the raw string of the vcf header
#' @field string Return the raw string of current variant including newline
#' @field line Return the raw string of current variant without newline
#' @field output Init an output object for streaming out the variants to another vcf
#' @field write Streaming out current variant the output vcf
#' @field close Close the connection to the output vcf
#' @field setCHR Modify the CHR of current variant \itemize{ \item Parameter: s - A string for CHR}
#' @field setID Modify the ID of current variant \itemize{ \item Parameter: s - A string for ID}
#' @field setPOS Modify the POS of current variant \itemize{ \item Parameter: pos - An integer for POS}
#' @field setRefAlt Modify the REF and ALT of current variant \itemize{ \item Parameter: s - A string reperated by comma}
#' @field setInfoInt Modify the given tag of INT type in the INFO of current variant
#' \itemize{
#' \item Parameter: tag - A string for the tag name
#' \item Parameter: v - An integer for the tag value}
#' @field setInfoFloat Modify the given tag of FLOAT type in the INFO of current variant
#' \itemize{
#' \item Parameter: tag - A string for the tag name
#' \item Parameter: v - A double for the tag value}
#' @field setInfoStr Modify the given tag of STRING type in the INFO of current variant
#' \itemize{
#' \item Parameter: tag - A string for the tag name
#' \item Parameter: s - A string for the tag value}
#' @field setPhasing Modify the phasing status of each sample
#' \itemize{\item Parameter: v - An integer vector with size of the number of samples. only 1s and 0s are valid.}
#' @field setGenotypes Modify the genotypes of current variant
#' \itemize{\item Parameter: v - An integer vector for genotypes. Use NA or -9 for missing value.}
#' @field setFormatInt Modify the given tag of INT type in the FORMAT of current variant
#' \itemize{
#' \item Parameter: tag - A string for the tag name
#' \item Parameter: v - An integer for the tag value}
#' @field setFormatFloat Modify the given tag of FLOAT type in the FORMAT of current variant
#' \itemize{
#' \item Parameter: tag - A string for the tag name
#' \item Parameter: v - A double for the tag value}
#' @field setFormatStr Modify the given tag of STRING type in the FORMAT of current variant
#' \itemize{
#' \item Parameter: tag - A string for the tag name
#' \item Parameter: s - A string for the tag value}
#' @field rmInfoTag Remove the given tag from the INFO of current variant
#' \itemize{\item Parameter: s - A string for the tag name}
#' @field rmFormatTag Remove the given tag from the FORMAT of current variant
#' \itemize{\item Parameter: s - A string for the tag name}
#' @field setVariant Modify current variant by adding a vcf line
#' \itemize{\item Parameter: s - A string for one line in the VCF}
#' @field addINFO Add a INFO in the header of the vcf
#' \itemize{
#' \item Parameter: id - A string for the tag name
#' \item Parameter: number - A string for the number
#' \item Parameter: type - A string for the type
#' \item Parameter: desc - A string for description of what it means}
#' @field addFORMAT Add a FORMAT in the header of the vcf
#' \itemize{
#' \item Parameter: id - A string for the tag name
#' \item Parameter: number - A string for the number
#' \item Parameter: type - A string for the type
#' \item Parameter: desc - A string for description of what it means}
#' @examples
#' vcffile <- system.file("extdata", "raw.gt.vcf.gz", package="vcfppR")
#' br <- vcfreader$new(vcffile)
#' res <- rep(0L, br$nsamples())
#' while(br$variant()) {
#'   if(br$isSNP()) {
#'   gt <- br$genotypes(TRUE) == 1
#'   gt[is.na(gt)] <- FALSE
#'   res <- res + gt
#'   }
#' }
NULL

summaryVariants <- function(vcffile, region = "", samples = "-", filter_pass = FALSE, qual = 0) {
    .Call(`_vcfppR_summaryVariants`, vcffile, region, samples, filter_pass, qual)
}

summarySVs <- function(vcffile, region = "", samples = "-", filter_pass = FALSE, qual = 0) {
    .Call(`_vcfppR_summarySVs`, vcffile, region, samples, filter_pass, qual)
}

tableGT <- function(vcffile, region, samples, format, ids, qualval, pass, INFO, snps, indels, multiallelics, multisnps, svs) {
    .Call(`_vcfppR_tableGT`, vcffile, region, samples, format, ids, qualval, pass, INFO, snps, indels, multiallelics, multisnps, svs)
}

tableFormat <- function(vcffile, region, samples, format, ids, qualval, pass, INFO, snps, indels, multiallelics, multisnps, svs) {
    .Call(`_vcfppR_tableFormat`, vcffile, region, samples, format, ids, qualval, pass, INFO, snps, indels, multiallelics, multisnps, svs)
}

#' @name vcfwriter
#' @title API for writing the VCF/BCF.
#' @description Type the name of the class to see the details and methods
#' @return A C++ class with the following fields/methods for writing the VCF/BCF
#' @field new Constructor given a vcf file \itemize{
#' \item Parameter: vcffile - The path of a vcf file. don't start with "~"
#' \item Parameter: version - The version of VCF specification
#' }
#' @field addContig Add a Contig in the header of the vcf
#' \itemize{ \item Parameter: str - A string for the CONTIG name }
#' @field addFILTER Add a FILTER in the header of the vcf
#' \itemize{
#' \item Parameter: id - A string for the FILTER name
#' \item Parameter: desc - A string for description of what it means}
#' @field addINFO Add a INFO in the header of the vcf
#' \itemize{
#' \item Parameter: id - A string for the tag name
#' \item Parameter: number - A string for the number
#' \item Parameter: type - A string for the type
#' \item Parameter: desc - A string for description of what it means}
#' @field addFORMAT Add a FORMAT in the header of the vcf
#' \itemize{
#' \item Parameter: id - A string for the tag name
#' \item Parameter: number - A string for the number
#' \item Parameter: type - A string for the type
#' \item Parameter: desc - A string for description of what it means}
#' @field addSample Add a SAMPLE in the header of the vcf
#' \itemize{ \item Parameter: str - A string for a SAMPLE name }
#' @field addLine Add a line in the header of the vcf
#' \itemize{ \item Parameter: str - A string for a line in the header of VCF }
#' @field writeline Write a variant record given a line
#' \itemize{ \item Parameter: line - A string for a line in the variant of VCF. Not ended with "newline" }
#' @field close Close and save the vcf file
#' @examples
#' outvcf <- paste0(tempfile(), ".vcf.gz")
#' bw <- vcfwriter$new(outvcf, "VCF4.3")
#' bw$addContig("chr20")
#' bw$addINFO("AF", "A", "Float", "Estimated allele frequency in the range (0,1)");
#' bw$addFORMAT("GT", "1", "String", "Genotype");
#' bw$addSample("NA12878")
#' bw$addSample("NA12879")
#' s1 <- "chr20\t2006060\trs146931526\tG\tC\t100\tPASS\tAF=0.000998403\tGT\t1|0\t1/1"
#' bw$writeline(s1)
#' bw$close()
NULL

