% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_kv2.R
\name{vault_client_kv2}
\alias{vault_client_kv2}
\title{Key-Value Store (Version 2)}
\description{
Key-Value Store (Version 2)

Key-Value Store (Version 2)
}
\details{
Interact with vault's version 2 key-value store.  This is useful
for storing simple key-value data that can be versioned and for
storing metadata alongside the secrets (see
\link{vault_client_kv1} for a simpler key-value store, and see
https://www.vaultproject.io/docs/secrets/kv/kv-v2.html for
detailed information about this secret store.

A \code{kv2} store can be mounted anywhere, so all methods accept
a \code{mount} argument.  This is different to the CLI which lets
you try and read values from any vault path, but similar to other
secret and auth backends which accept arguments like
\code{-mount-point}.  So if the \code{kv2} store is mounted at
\verb{/project-secrets} for example, with a vault client
\code{vault} one could write\preformatted{vault$secrets$kv2$get("/project-secrets/mysecret",
                      mount = "project-secrets")
}

or\preformatted{kv2 <- vault$secrets$kv2$custom_mount("project-secrets")
kv2$get("mysecret")
}

If the leading part of of a path to secret within a \code{kv2}
store does not match the mount point, \code{vaultr} will throw an
error.  This approach results in more predictable error messages,
though it is a little more typing than for the CLI vault client.
}
\examples{

server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  client <- server$client()
  # With the test server as created by vaultr, the kv2 storage
  # engine is not enabled.  To use the kv2 store we must first
  # enable it; the command below will add it at the path /kv on
  # our vault server
  client$secrets$enable("kv", version = 2)

  # For ease of reading, create a 'kv' object for interacting with
  # the store (see below for the calls without this object)
  kv <- client$secrets$kv2$custom_mount("kv")
  kv$config()

  # The version-2 kv store can be treated largely the same as the
  # version-1 store, though with slightly different command names
  # (put instead of write, get instead of read)
  kv$put("/kv/path/secret", list(key = "value"))
  kv$get("/kv/path/secret")

  # But it also allows different versions to be stored at the same path:
  kv$put("/kv/path/secret", list(key = "s3cret!"))
  kv$get("/kv/path/secret")

  # Old versions can be retrieved still:
  kv$get("/kv/path/secret", version = 1)

  # And metadata about versions can be retrieved
  kv$metadata_get("/kv/path/secret")

  # cleanup
  server$kill()
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_client_kv2}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{vault_client_kv2$new()}}
\item \href{#method-config}{\code{vault_client_kv2$config()}}
\item \href{#method-custom_mount}{\code{vault_client_kv2$custom_mount()}}
\item \href{#method-delete}{\code{vault_client_kv2$delete()}}
\item \href{#method-destroy}{\code{vault_client_kv2$destroy()}}
\item \href{#method-get}{\code{vault_client_kv2$get()}}
\item \href{#method-list}{\code{vault_client_kv2$list()}}
\item \href{#method-metadata_get}{\code{vault_client_kv2$metadata_get()}}
\item \href{#method-metadata_put}{\code{vault_client_kv2$metadata_put()}}
\item \href{#method-metadata_delete}{\code{vault_client_kv2$metadata_delete()}}
\item \href{#method-put}{\code{vault_client_kv2$put()}}
\item \href{#method-undelete}{\code{vault_client_kv2$undelete()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format">}\href{../../vaultr/html/vault_client_object.html#method-format}{\code{vaultr::vault_client_object$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help">}\href{../../vaultr/html/vault_client_object.html#method-help}{\code{vaultr::vault_client_object$help()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{vault_client_kv2} object. Not typically
called by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$new(api_client, mount)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{A \link{vault_api_client} object}

\item{\code{mount}}{Mount point for the backend}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-config"></a>}}
\if{latex}{\out{\hypertarget{method-config}{}}}
\subsection{Method \code{config()}}{
Fetch the configuration for this \code{kv2} store.
Returns a named list of values, the contents of which will
depend on the vault version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$config(mount = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_mount"></a>}}
\if{latex}{\out{\hypertarget{method-custom_mount}{}}}
\subsection{Method \code{custom_mount()}}{
Set up a \code{vault_client_kv2} object at a custom
mount.  For example, suppose you mounted another copy of the
\code{kv2} secret backend at \verb{/secret2} you might use \code{kv <- vault$secrets$kv2$custom_mount("/secret2")} - this pattern is
repeated for other secret and authentication backends.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$custom_mount(mount)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mount}}{String, indicating the path that the engine is
mounted at.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a secret from the vault.  This marks the
version as deleted and will stop it from being returned from
reads, but the underlying data will not be removed. A delete
can be undone using the undelete method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$delete(path, version = NULL, mount = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to delete}

\item{\code{version}}{Optional version to delete.  If \code{NULL} (the
default) then the latest version of the secret is deleted.
Otherwise, \code{version} can be a vector of integer versions to
delete.}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-destroy"></a>}}
\if{latex}{\out{\hypertarget{method-destroy}{}}}
\subsection{Method \code{destroy()}}{
Delete a secret entirely.  Unlike \code{delete} this
operation is irreversible and is more like the \code{delete}
operation on \code{\link{vault_client_kv1}} stores.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$destroy(path, version, mount = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to delete}

\item{\code{version}}{Version numbers to delete, as a vector of
integers (this is required)}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
Read a secret from the vault
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$get(
  path,
  version = NULL,
  field = NULL,
  metadata = FALSE,
  mount = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path of the secret to read}

\item{\code{version}}{Optional version of the secret to read.  If
\code{NULL} (the default) then the most recent version is read.
Otherwise this must be a scalar integer.}

\item{\code{field}}{Optional field to read from the secret.  Each
secret is stored as a key/value set (represented in R as a
named list) and this is equivalent to using \verb{[[field]]} on
the return value.  The default, \code{NULL}, returns the full set
of values.}

\item{\code{metadata}}{Logical, indicating if we should return
metadata for this secret (lease information etc) as an
attribute along with the values itself.  Ignored if \code{field}
is specified.}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list"></a>}}
\if{latex}{\out{\hypertarget{method-list}{}}}
\subsection{Method \code{list()}}{
List data in the vault at a give path.  This can
be used to list keys, etc (e.g., at \verb{/secret}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$list(path, full_names = FALSE, mount = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path to list}

\item{\code{full_names}}{Logical, indicating if full paths (relative
to the vault root) should be returned.}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}

\item{\code{value}}{A character vector (of zero length if no keys are
found).  Paths that are "directories" (i.e., that contain
keys and could themselves be listed) will be returned with a
trailing forward slash, e.g. \verb{path/}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metadata_get"></a>}}
\if{latex}{\out{\hypertarget{method-metadata_get}{}}}
\subsection{Method \code{metadata_get()}}{
Read secret metadata and versions at the specified
path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$metadata_get(path, mount = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path of secret to read metadata for}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metadata_put"></a>}}
\if{latex}{\out{\hypertarget{method-metadata_put}{}}}
\subsection{Method \code{metadata_put()}}{
Update metadata for a secret.  This is allowed
even if a secret does not yet exist, though this requires the
\code{create} vault permission at this path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$metadata_put(
  path,
  cas_required = NULL,
  max_versions = NULL,
  mount = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path of secret to update metadata for}

\item{\code{cas_required}}{Logical, indicating that if If true the key
will require the cas parameter to be set on all write
requests (see \code{put}). If \code{FALSE}, the backend's configuration
will be used.}

\item{\code{max_versions}}{Integer, indicating the
maximum number of versions to keep per key.  If not set, the
backend's configured max version is used. Once a key has more
than the configured allowed versions the oldest version will
be permanently deleted.}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metadata_delete"></a>}}
\if{latex}{\out{\hypertarget{method-metadata_delete}{}}}
\subsection{Method \code{metadata_delete()}}{
This method permanently deletes the key metadata
and all version data for the specified key. All version
history will be removed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$metadata_delete(path, mount = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to delete}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-put"></a>}}
\if{latex}{\out{\hypertarget{method-put}{}}}
\subsection{Method \code{put()}}{
Create or update a secret in this store.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$put(path, data, cas = NULL, mount = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path for the secret to write, such as
\verb{/secret/mysecret}}

\item{\code{data}}{A named list of values to write into the vault at
this path.}

\item{\code{cas}}{Integer, indicating the "cas" value to use a
"Check-And-Set" operation. If not set the write will be
allowed. If set to 0 a write will only be allowed if the key
doesn't exist. If the index is non-zero the write will only
be allowed if the key's current version matches the version
specified in the cas parameter.}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-undelete"></a>}}
\if{latex}{\out{\hypertarget{method-undelete}{}}}
\subsection{Method \code{undelete()}}{
Undeletes the data for the provided version and
path in the key-value store. This restores the data, allowing
it to be returned on get requests.  This works with data
deleted with \verb{$delete} but not with \verb{$destroy}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_kv2$undelete(path, version, mount = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path to undelete}

\item{\code{version}}{Integer vector of versions to undelete}

\item{\code{mount}}{Custom mount path to use for this store (see \code{Details}).}
}
\if{html}{\out{</div>}}
}
}
}
