% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_auth_userpass.R
\name{vault_client_auth_userpass}
\alias{vault_client_auth_userpass}
\title{Vault Username/Password Authentication Configuration}
\description{
Interact with vault's username/password authentication backend.
This backend can be used to configure basic username+password
authentication, suitable for human users.  For more information,
please see the vault documentation
\url{https://www.vaultproject.io/docs/auth/userpass.html}
}
\section{Methods}{


\describe{
\item{\code{custom_mount}}{
  Set up a \code{vault_client_auth_userpass} object at a custom mount. For example, suppose you mounted the \code{userpass} authentication backend at \code{/userpass2} you might use \code{up <- vault$auth$userpass2$custom_mount("/userpass2")} - this pattern is repeated for other secret and authentication backends.
  \cr\emph{Usage:}\preformatted{custom_mount(mount)}

  \emph{Arguments:}
  \itemize{
    \item{\code{mount}:   String, indicating the path that the engine is mounted at.
    }
  }
}
\item{\code{write}}{
  Create or update a user.
  \cr\emph{Usage:}\preformatted{write(username, password = NULL, policies = NULL, ttl = NULL,
      max_ttl = NULL, bound_cidrs = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{username}:   Username for the user
    }

    \item{\code{password}:   Password for the user (required when creating a user only)
    }

    \item{\code{policies}:   Character vector of policies for the user
    }

    \item{\code{ttl}:   The lease duration which decides login expiration
    }

    \item{\code{max_ttl}:   Maximum duration after which login should expire
    }

    \item{\code{bound_cidrs}:   Character vector of CIDRs.  If set, restricts usage of the login and token to client IPs falling within the range of the specified CIDR(s).
    }
  }
}
\item{\code{read}}{
  Reads the properties of an existing username.
  \cr\emph{Usage:}\preformatted{read(username)}

  \emph{Arguments:}
  \itemize{
    \item{\code{username}:   Username to read
    }
  }
}
\item{\code{delete}}{
  Delete a user
  \cr\emph{Usage:}\preformatted{delete(username)}

  \emph{Arguments:}
  \itemize{
    \item{\code{username}:   Username to delete
    }
  }
}
\item{\code{update_password}}{
  Update password for a user
  \cr\emph{Usage:}\preformatted{update_password(username, password)}

  \emph{Arguments:}
  \itemize{
    \item{\code{username}:   Username for the user to update
    }

    \item{\code{password}:   New password for the user
    }
  }
}
\item{\code{update_policies}}{
  Update vault policies for a user
  \cr\emph{Usage:}\preformatted{update_policies(username, policies)}

  \emph{Arguments:}
  \itemize{
    \item{\code{username}:   Username for the user to update
    }

    \item{\code{policies}:   Character vector of policies for this user
    }
  }
}
\item{\code{list}}{
  List users known to vault
  \cr\emph{Usage:}\preformatted{list()}
}
\item{\code{login}}{
  Log into the vault using username/password authentication. Normally you would not call this directly but instead use \code{$login} with \code{method = "userpass"} and proving the \code{username} argument and optionally the \code{password} argument.  This function returns a vault token but does not set it as the client token.
  \cr\emph{Usage:}\preformatted{login(username, password = NULL)}

  \emph{Arguments:}
  \itemize{
    \item{\code{username}:   Username to authenticate with
    }

    \item{\code{password}:   Password to authenticate with. If omitted or \code{NULL} and the session is interactive, the password will be prompted for.
    }
  }
}
}
}

\examples{
server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  root <- server$client()

  # The userpass authentication backend is not enabled by default,
  # so we need to enable it first
  root$auth$enable("userpass")

  # Then we can add users:
  root$auth$userpass$write("alice", "p4ssw0rd")

  # Create a new client and login with this user:
  alice <- vaultr::vault_client(addr = server$addr)
  # it is not recommended to login with the password like this as
  # it will end up in the command history, but in interactive use
  # you will be prompted securely for password
  alice$login(method = "userpass",
              username = "alice", password = "p4ssw0rd")
  # Alice has now logged in and has only "default" policies
  alice$auth$token$lookup_self()$policies

  # (wheras our original root user has the "root" policy)
  root$auth$token$lookup_self()$policies
}
}
