% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsk_rvs.R
\name{vsk_rvs}
\alias{vsk_rvs}
\title{Generating random numbers for the Vasicek distribution}
\usage{
vsk_rvs(n, Rho, P, seed = 1)
}
\arguments{
\item{n}{An integer for the number of observations.}

\item{Rho}{The Rho parameter in the Vasicek distribution. It is in the 
range of (0, 1).}

\item{P}{The P parameter in the Vasicek distribution. It is in the 
range of (0, 1).}

\item{seed}{An integer that is used as the seed value to generate 
random numbers.}
}
\value{
A list of random number that follows the Vasicek distribution.
}
\description{
The function \code{vsk_rvs} generates random numbers for the Vasicek
distribution.
}
\examples{
vsk_rvs(10, Rho = 0.2, P = 0.1)
}
