# Vascr Import Works

    Code
      suppressMessages(vascr_import("ECIS", raw, modeled, "ECIS_Data"))
    Output
      # A tibble: 14,400 x 9
          Time Well  Frequency Unit  Value Instrument Experiment Excluded Sample
         <dbl> <chr>     <dbl> <fct> <dbl> <chr>      <chr>      <chr>    <chr> 
       1     0 A01        1000 R      394. ECIS       ECIS_Data  no       NA    
       2     0 A01       16000 R      223. ECIS       ECIS_Data  no       NA    
       3     0 A01        2000 R      316. ECIS       ECIS_Data  no       NA    
       4     0 A01         250 R      824. ECIS       ECIS_Data  no       NA    
       5     0 A01       32000 R      212. ECIS       ECIS_Data  no       NA    
       6     0 A01        4000 R      267. ECIS       ECIS_Data  no       NA    
       7     0 A01         500 R      533. ECIS       ECIS_Data  no       NA    
       8     0 A01       64000 R      205. ECIS       ECIS_Data  no       NA    
       9     0 A01        8000 R      240. ECIS       ECIS_Data  no       NA    
      10     0 B01        1000 R      388. ECIS       ECIS_Data  no       NA    
      # i 14,390 more rows

---

    Code
      vascr_import("cellzscope", raw, model, "cellZscope")
    Output
      # A tibble: 88,288 x 8
          Time Unit               Well  Value Experiment Frequency Instrument Sample  
         <dbl> <chr>              <chr> <dbl> <chr>          <dbl> <chr>      <chr>   
       1  0.03 CPE_A(sⁿ⁻¹·µF/cm²) A01    NA   cellZscope         0 cellZscope " 80,00~
       2  0.03 CPE_A(sⁿ⁻¹·µF/cm²) A02    46.8 cellZscope         0 cellZscope " 80,00~
       3  0.03 CPE_A(sⁿ⁻¹·µF/cm²) A04    42.9 cellZscope         0 cellZscope " 20,00~
       4  0.03 CPE_A(sⁿ⁻¹·µF/cm²) A05    NA   cellZscope         0 cellZscope " 20,00~
       5  0.03 CPE_A(sⁿ⁻¹·µF/cm²) B01    NA   cellZscope         0 cellZscope " 80,00~
       6  0.03 CPE_A(sⁿ⁻¹·µF/cm²) B02    NA   cellZscope         0 cellZscope " 80,00~
       7  0.03 CPE_A(sⁿ⁻¹·µF/cm²) B04    NA   cellZscope         0 cellZscope " 20,00~
       8  0.03 CPE_A(sⁿ⁻¹·µF/cm²) B05    NA   cellZscope         0 cellZscope " 20,00~
       9  1.3  CPE_A(sⁿ⁻¹·µF/cm²) A01    46.1 cellZscope         0 cellZscope " 80,00~
      10  1.3  CPE_A(sⁿ⁻¹·µF/cm²) A02    51.8 cellZscope         0 cellZscope " 80,00~
      # i 88,278 more rows

---

    Code
      vascr_import("sciospec", raw, model, "ScioSpec")
    Message
      Joining with `by = join_by(channel)`
      Joining with `by = join_by(time)`
    Output
      # A tibble: 16,160 x 11
         channel      Frequency Unit    Value Well  Instrument  Time Experiment Sample
         <chr>            <dbl> <chr>   <dbl> <chr> <chr>      <dbl> <chr>      <chr> 
       1 Channel: EC~      100. R      20261. D02   sciospec       0 ScioSpec   D02   
       2 Channel: EC~      100. I     -19551. D02   sciospec       0 ScioSpec   D02   
       3 Channel: EC~      110. R      18171. D02   sciospec       0 ScioSpec   D02   
       4 Channel: EC~      110. I     -15598. D02   sciospec       0 ScioSpec   D02   
       5 Channel: EC~      120. R      17839. D02   sciospec       0 ScioSpec   D02   
       6 Channel: EC~      120. I     -16083. D02   sciospec       0 ScioSpec   D02   
       7 Channel: EC~      132. R      17475. D02   sciospec       0 ScioSpec   D02   
       8 Channel: EC~      132. I     -14845. D02   sciospec       0 ScioSpec   D02   
       9 Channel: EC~      145. R      17380. D02   sciospec       0 ScioSpec   D02   
      10 Channel: EC~      145. I     -13290. D02   sciospec       0 ScioSpec   D02   
      # i 16,150 more rows
      # i 2 more variables: SampleID <dbl>, Excluded <chr>

---

    Data didn't import, wrong instument typed

---

    Code
      vascr_import("xCELLigence", raw, experiment = "xCELLigence")
    Output
      # A tibble: 6,336 x 10
          Time Unit  Value Well  Sample      Frequency Experiment  Instrument SampleID
         <dbl> <chr> <dbl> <chr> <chr>           <dbl> <chr>       <chr>         <int>
       1  0    CI     1    A01   HCMVEC80000     10000 xCELLigence xCELLigen~        1
       2  0    CI     1    A02   HCMVEC80000     10000 xCELLigence xCELLigen~        1
       3  0    CI     1    A03   HCMVEC80000     10000 xCELLigence xCELLigen~        1
       4  1.54 CI     3.59 A01   HCMVEC80000     10000 xCELLigence xCELLigen~        1
       5  1.54 CI     3.56 A02   HCMVEC80000     10000 xCELLigence xCELLigen~        1
       6  1.54 CI     3.72 A03   HCMVEC80000     10000 xCELLigence xCELLigen~        1
       7  3.21 CI     3.51 A01   HCMVEC80000     10000 xCELLigence xCELLigen~        1
       8  3.21 CI     3.48 A02   HCMVEC80000     10000 xCELLigence xCELLigen~        1
       9  3.21 CI     3.48 A03   HCMVEC80000     10000 xCELLigence xCELLigen~        1
      10  4.87 CI     3.39 A01   HCMVEC80000     10000 xCELLigence xCELLigen~        1
      # i 6,326 more rows
      # i 1 more variable: Excluded <chr>

# Create blank DF

    Code
      vascr_blank_df()
    Output
      # A tibble: 0 x 10
      # i 10 variables: Time <dbl>, Unit <chr>, Value <dbl>, Well <chr>,
      #   Sample <chr>, Frequency <dbl>, Experiment <fct>, Instrument <chr>,
      #   SampleID <int>, Excluded <lgl>

# Apply map

    Code
      vascr_apply_map(data.df = growth.df, map = lookup)
    Message
      ! Wells found in imported data but not map: A02 A03 B02 B03 C02 C03 D01 D02 D03 E01 E03 F01 F03 G01 G03 H01 H02 H03 A04 A05 A06 B04 B05 B06 C04 C05 C06 D04 D05 D06 E04 E05 E06 F04 F05 F06 G04 G05 G06 H04 H05 H06 A07 A08 A09 B07 B08 B09 C07 C08 C09 D07 D08 D09 E07 E08 E09 F07 F08 F09 G07 G08 G09 H07 H08 H09
      Joining with `by = join_by(Well)`
    Output
      # A tibble: 146,370 x 14
          Time Unit  Well  Value Frequency Experiment  cells line  Instrument Excluded
         <dbl> <chr> <chr> <dbl>     <dbl> <fct>       <chr> <chr> <chr>      <chr>   
       1     0 Alpha A01      NA         0 1 : Experi~ 35000 HCME~ ECIS       no      
       2     0 Alpha A02      NA         0 1 : Experi~ 35000 HCME~ ECIS       no      
       3     0 Alpha A03      NA         0 1 : Experi~ 35000 HCME~ ECIS       no      
       4     0 Alpha B01      NA         0 1 : Experi~ 30000 HCME~ ECIS       no      
       5     0 Alpha B02      NA         0 1 : Experi~ 30000 HCME~ ECIS       no      
       6     0 Alpha B03      NA         0 1 : Experi~ 30000 HCME~ ECIS       no      
       7     0 Alpha C01      NA         0 1 : Experi~ 25000 HCME~ ECIS       no      
       8     0 Alpha C02      NA         0 1 : Experi~ 25000 HCME~ ECIS       no      
       9     0 Alpha C03      NA         0 1 : Experi~ 25000 HCME~ ECIS       no      
      10     0 Alpha D01      NA         0 1 : Experi~ 20000 HCME~ ECIS       no      
      # i 146,360 more rows
      # i 4 more variables: SampleID <int>, Sample <fct>, Vehicle <chr>, HCMVEC <chr>

---

    Code
      vascr_apply_map(growth.df %>% vascr_subset(well = c("A1")) %>% select(-Sample),
      lookup)
    Message
      ! Wells found in map but not imported data: NA NA NA NA NA
      Joining with `by = join_by(Well)`
    Output
      # A tibble: 1,950 x 14
          Time Unit  Well  Value Frequency Experiment  cells line  Instrument Excluded
         <dbl> <chr> <chr> <dbl>     <dbl> <fct>       <chr> <chr> <chr>      <chr>   
       1     5 Alpha A01    2.69         0 1 : Experi~ 35000 HCME~ ECIS       no      
       2     5 Cm    A01   37.9          0 1 : Experi~ 35000 HCME~ ECIS       no      
       3     5 Drift A01   -0.94         0 1 : Experi~ 35000 HCME~ ECIS       no      
       4     5 Rb    A01    0            0 1 : Experi~ 35000 HCME~ ECIS       no      
       5     5 RMSE  A01    0.01         0 1 : Experi~ 35000 HCME~ ECIS       no      
       6    10 Alpha A01    3.34         0 1 : Experi~ 35000 HCME~ ECIS       no      
       7    10 Cm    A01   18.8          0 1 : Experi~ 35000 HCME~ ECIS       no      
       8    10 Drift A01   -1.82         0 1 : Experi~ 35000 HCME~ ECIS       no      
       9    10 Rb    A01    0            0 1 : Experi~ 35000 HCME~ ECIS       no      
      10    10 RMSE  A01    0.02         0 1 : Experi~ 35000 HCME~ ECIS       no      
      # i 1,940 more rows
      # i 4 more variables: SampleID <int>, Sample <fct>, Vehicle <chr>, HCMVEC <chr>

# Vascr_map_template works

    Code
      vascr_map_template()
    Output
      # A tibble: 0 x 5
      # i 5 variables: Experiment <???>, Well <???>, Sample <???>, SampleID <???>,
      #   Excluded <???>

# vascr regenerate map works

    Code
      vascr_regenerate_map(growth.df %>% mutate(Experiment = 1))
    Output
      # A tibble: 8 x 5
        Experiment Sample                       SampleID Excluded Well                
             <dbl> <chr>                           <int> <chr>    <chr>               
      1          1 0_cells + HCMEC D3_line             8 no       H01 H02 H03 H04 H05~
      2          1 10,000_cells + HCMEC D3_line        6 no       F01 F02 F03 F04 F05~
      3          1 15,000_cells + HCMEC D3_line        5 no       E01 E02 E03 E04 E05~
      4          1 20,000_cells + HCMEC D3_line        4 no       D01 D02 D03 D04 D05~
      5          1 25,000_cells + HCMEC D3_line        3 no       C01 C02 C03 C04 C05~
      6          1 30,000_cells + HCMEC D3_line        2 no       B01 B02 B03 B04 B05~
      7          1 35,000_cells + HCMEC D3_line        1 no       A01 A02 A03 A04 A05~
      8          1 5,000_cells + HCMEC D3_line         7 no       G01 G02 G03 G04 G05~

# Samples work

    Either `Row` and `Column' or `Well` must be specified in the input file

---

    Code
      vascr_import_map(map_1)
    Output
      # A tibble: 12 x 3
         Sample                         SampleID Well 
         <chr>                             <int> <chr>
       1 10 nM Treatment 1 + 1nm water         1 A01  
       2 10 nM Treatment 1 + 1nm water         1 A02  
       3 10 nM Treatment 1 + 1nm water         1 A03  
       4 100 nM Treatment 1 + 1nm water        3 B01  
       5 100 nM Treatment 1 + 1nm water        3 B02  
       6 100 nM Treatment 1 + 1nm water        3 B03  
       7 10 nM Treatment 2 + 1nm water         2 C04  
       8 10 nM Treatment 2 + 1nm water         2 C05  
       9 10 nM Treatment 2 + 1nm water         2 C06  
      10 100 nM Treatment 2 + 1nm water        4 D01  
      11 100 nM Treatment 2 + 1nm water        4 D02  
      12 100 nM Treatment 2 + 1nm water        4 D03  

---

    Code
      vascr_import_map(map_2)
    Output
      # A tibble: 12 x 3
         Well  Sample                         SampleID
         <chr> <chr>                             <int>
       1 A01   10 nM Treatment 1 + 1nm water         1
       2 A02   10 nM Treatment 1 + 1nm water         1
       3 A03   10 nM Treatment 1 + 1nm water         1
       4 B01   100 nM Treatment 1 + 1nm water        3
       5 B02   100 nM Treatment 1 + 1nm water        3
       6 B03   100 nM Treatment 1 + 1nm water        3
       7 C01   10 nM Treatment 2 + 1nm water         2
       8 C02   10 nM Treatment 2 + 1nm water         2
       9 C03   10 nM Treatment 2 + 1nm water         2
      10 C01   100 nM Treatment 2 + 1nm water        4
      11 C02   100 nM Treatment 2 + 1nm water        4
      12 C03   100 nM Treatment 2 + 1nm water        4

---

    i In argument: `across(c(-"Column", -"Row"))`.
    Caused by error in `across()`:
    ! Can't select columns that don't exist.
    x Column `Column` doesn't exist.

---

    Code
      vascr_import_map(map_4)
    Output
      # A tibble: 12 x 3
         SampleID Sample                         Well 
            <dbl> <chr>                          <chr>
       1        1 10 nM Treatment 1 + 1nm water  A01  
       2        1 10 nM Treatment 1 + 1nm water  A02  
       3        1 10 nM Treatment 1 + 1nm water  A03  
       4        2 100 nM Treatment 1 + 1nm water B01  
       5        2 100 nM Treatment 1 + 1nm water B02  
       6        2 100 nM Treatment 1 + 1nm water B03  
       7        3 10 nM Treatment 2 + 1nm water  A01  
       8        3 10 nM Treatment 2 + 1nm water  A02  
       9        3 10 nM Treatment 2 + 1nm water  A03  
      10        4 100 nM Treatment 2 + 1nm water D01  
      11        4 100 nM Treatment 2 + 1nm water D02  
      12        4 100 nM Treatment 2 + 1nm water D03  

---

    Code
      vascr_import_map(map_5)
    Output
      # A tibble: 12 x 3
         SampleID Sample                         Well 
            <dbl> <chr>                          <chr>
       1        1 10 nM Treatment 1 + 1nm water  A01  
       2        1 10 nM Treatment 1 + 1nm water  A02  
       3        1 10 nM Treatment 1 + 1nm water  A03  
       4        2 100 nM Treatment 1 + 1nm water B01  
       5        2 100 nM Treatment 1 + 1nm water B02  
       6        2 100 nM Treatment 1 + 1nm water B03  
       7        3 10 nM Treatment 1 + 1nm water  C01  
       8        3 10 nM Treatment 1 + 1nm water  C02  
       9        3 10 nM Treatment 1 + 1nm water  C03  
      10        4 100 nM Treatment 2 + 1nm water D01  
      11        4 100 nM Treatment 2 + 1nm water D02  
      12        4 100 nM Treatment 2 + 1nm water D03  

---

    Code
      vascr_import_map(map_6)
    Output
      # A tibble: 12 x 3
         SampleID Sample                         Well 
            <dbl> <chr>                          <chr>
       1        1 10 nM Treatment 1 + 1nm water  A01  
       2        1 10 nM Treatment 1 + 1nm water  A02  
       3        1 10 nM Treatment 1 + 1nm water  A03  
       4        2 100 nM Treatment 1 + 1nm water B01  
       5        2 100 nM Treatment 1 + 1nm water B02  
       6        2 100 nM Treatment 1 + 1nm water B03  
       7        3 10 nM Treatment 2 + 1nm water  C04  
       8        3 10 nM Treatment 2 + 1nm water  C05  
       9        3 10 nM Treatment 2 + 1nm water  C06  
      10        4 100 nM Treatment 2 + 1nm water D01  
      11        4 100 nM Treatment 2 + 1nm water D02  
      12        4 100 nM Treatment 2 + 1nm water D03  

---

    Code
      vascr_import_map(map_7)
    Output
      # A tibble: 12 x 3
         SampleID Sample                                          Well 
            <dbl> <chr>                                           <chr>
       1        1 10 nM Treatment 1 + 1nm water + 6nm Treatment 2 A01  
       2        1 10 nM Treatment 1 + 1nm water + 6nm Treatment 2 A02  
       3        1 10 nM Treatment 1 + 1nm water + 6nm Treatment 2 A03  
       4        2 100 nM Treatment 1 + 1nm water                  B01  
       5        2 100 nM Treatment 1 + 1nm water                  B02  
       6        2 100 nM Treatment 1 + 1nm water                  B03  
       7        3 10 nM Treatment 2 + 1nm water                   C04  
       8        3 10 nM Treatment 2 + 1nm water                   C05  
       9        3 10 nM Treatment 2 + 1nm water                   C06  
      10        4 100 nM Treatment 2 + 1nm water                  D01  
      11        4 100 nM Treatment 2 + 1nm water                  D02  
      12        4 100 nM Treatment 2 + 1nm water                  D03  

---

    Code
      vascr_import_map(map8)
    Output
      # A tibble: 6 x 3
        Well  Sample SampleID
        <chr> <chr>     <int>
      1 A01   S             1
      2 B03   SM            2
      3 C01   S             1
      4 D01   SM            2
      5 E01   S             1
      6 F01   St            3

---

    Code
      vascr_explode(growth.df)
    Output
      # A tibble: 146,370 x 14
          Time Unit  Well  Value Sample  Frequency Experiment cells.x line  Instrument
         <dbl> <chr> <chr> <dbl> <chr>       <dbl> <fct>      <chr>   <chr> <chr>     
       1     0 Alpha A01      NA 35,000~         0 1 : Exper~ 35000   HCME~ ECIS      
       2     0 Alpha A02      NA 35,000~         0 1 : Exper~ 35000   HCME~ ECIS      
       3     0 Alpha A03      NA 35,000~         0 1 : Exper~ 35000   HCME~ ECIS      
       4     0 Alpha B01      NA 30,000~         0 1 : Exper~ 30000   HCME~ ECIS      
       5     0 Alpha B02      NA 30,000~         0 1 : Exper~ 30000   HCME~ ECIS      
       6     0 Alpha B03      NA 30,000~         0 1 : Exper~ 30000   HCME~ ECIS      
       7     0 Alpha C01      NA 25,000~         0 1 : Exper~ 25000   HCME~ ECIS      
       8     0 Alpha C02      NA 25,000~         0 1 : Exper~ 25000   HCME~ ECIS      
       9     0 Alpha C03      NA 25,000~         0 1 : Exper~ 25000   HCME~ ECIS      
      10     0 Alpha D01      NA 20,000~         0 1 : Exper~ 20000   HCME~ ECIS      
      # i 146,360 more rows
      # i 4 more variables: SampleID <int>, Excluded <chr>, cells.y <chr>,
      #   D3_line <chr>

---

    Code
      vascr_import_map(lookup)
    Output
      # A tibble: 6 x 5
        SampleID Sample                        Well  Vehicle HCMVEC
           <int> <chr>                         <chr> <chr>   <chr> 
      1        2 Water Vehicle + 80,000 HCMVEC A01   Water   80,000
      2        2 Water Vehicle + 80,000 HCMVEC B01   Water   80,000
      3        2 Water Vehicle + 80,000 HCMVEC C01   Water   80,000
      4        1 Water Vehicle + 20,000 HCMVEC E02   Water   20,000
      5        1 Water Vehicle + 20,000 HCMVEC F02   Water   20,000
      6        1 Water Vehicle + 20,000 HCMVEC G02   Water   20,000

---

    Code
      vascr_implode(explode %>% select(-Sample))
    Output
      # A tibble: 12 x 7
         SampleID Sample            Well  `nM Treatment 1` `nm water` `nm Treatment 2`
            <dbl> <chr>             <chr> <chr>            <chr>      <chr>           
       1        1 10 nM Treatment ~ A01   10               1          6               
       2        1 10 nM Treatment ~ A02   10               1          6               
       3        1 10 nM Treatment ~ A03   10               1          6               
       4        2 100 nM Treatment~ B01   100              1          <NA>            
       5        2 100 nM Treatment~ B02   100              1          <NA>            
       6        2 100 nM Treatment~ B03   100              1          <NA>            
       7        3 1 nm water + 10 ~ C04   <NA>             1          <NA>            
       8        3 1 nm water + 10 ~ C05   <NA>             1          <NA>            
       9        3 1 nm water + 10 ~ C06   <NA>             1          <NA>            
      10        4 1 nm water + 100~ D01   <NA>             1          <NA>            
      11        4 1 nm water + 100~ D02   <NA>             1          <NA>            
      12        4 1 nm water + 100~ D03   <NA>             1          <NA>            
      # i 1 more variable: `nM Treatment 2` <chr>

---

    Code
      vascr_implode(explode %>% select(-Sample), cols = "nM Treatment 1")
    Output
      # A tibble: 12 x 7
         SampleID Sample            Well  `nM Treatment 1` `nm water` `nm Treatment 2`
            <dbl> <chr>             <chr> <chr>            <chr>      <chr>           
       1        1 "10 nM Treatment~ A01   10               1          6               
       2        1 "10 nM Treatment~ A02   10               1          6               
       3        1 "10 nM Treatment~ A03   10               1          6               
       4        2 "100 nM Treatmen~ B01   100              1          <NA>            
       5        2 "100 nM Treatmen~ B02   100              1          <NA>            
       6        2 "100 nM Treatmen~ B03   100              1          <NA>            
       7        3 ""                C04   <NA>             1          <NA>            
       8        3 ""                C05   <NA>             1          <NA>            
       9        3 ""                C06   <NA>             1          <NA>            
      10        4 ""                D01   <NA>             1          <NA>            
      11        4 ""                D02   <NA>             1          <NA>            
      12        4 ""                D03   <NA>             1          <NA>            
      # i 1 more variable: `nM Treatment 2` <chr>

# edit name works

    Code
      vascr_edit_name(growth.df, "HCMEC D3", "HCMEC/D3")
    Output
      # A tibble: 146,370 x 12
         Sample     Time Unit  Well  Value Frequency Experiment cells line  Instrument
         <chr>     <dbl> <chr> <chr> <dbl>     <dbl> <fct>      <chr> <chr> <chr>     
       1 35,000_c~     0 Alpha A01      NA         0 1 : Exper~ 35000 HCME~ ECIS      
       2 35,000_c~     0 Alpha A02      NA         0 1 : Exper~ 35000 HCME~ ECIS      
       3 35,000_c~     0 Alpha A03      NA         0 1 : Exper~ 35000 HCME~ ECIS      
       4 35,000_c~     0 Cm    A01      NA         0 1 : Exper~ 35000 HCME~ ECIS      
       5 35,000_c~     0 Cm    A02      NA         0 1 : Exper~ 35000 HCME~ ECIS      
       6 35,000_c~     0 Cm    A03      NA         0 1 : Exper~ 35000 HCME~ ECIS      
       7 35,000_c~     0 Drift A01      NA         0 1 : Exper~ 35000 HCME~ ECIS      
       8 35,000_c~     0 Drift A02      NA         0 1 : Exper~ 35000 HCME~ ECIS      
       9 35,000_c~     0 Drift A03      NA         0 1 : Exper~ 35000 HCME~ ECIS      
      10 35,000_c~     0 Rb    A01      NA         0 1 : Exper~ 35000 HCME~ ECIS      
      # i 146,360 more rows
      # i 2 more variables: SampleID <int>, Excluded <chr>

# Assign SampleID works

    Code
      growth.df %>% vascr_assign_sampleid()
    Output
           Time  Unit Well     Value                       Sample Frequency
      1       0 Alpha  A01        NA 35,000_cells + HCMEC D3_line         0
      2       0 Alpha  A02        NA 35,000_cells + HCMEC D3_line         0
      3       0 Alpha  A03        NA 35,000_cells + HCMEC D3_line         0
      4       0 Alpha  B01        NA 30,000_cells + HCMEC D3_line         0
      5       0 Alpha  B02        NA 30,000_cells + HCMEC D3_line         0
      6       0 Alpha  B03        NA 30,000_cells + HCMEC D3_line         0
      7       0 Alpha  C01        NA 25,000_cells + HCMEC D3_line         0
      8       0 Alpha  C02        NA 25,000_cells + HCMEC D3_line         0
      9       0 Alpha  C03        NA 25,000_cells + HCMEC D3_line         0
      10      0 Alpha  D01        NA 20,000_cells + HCMEC D3_line         0
      11      0 Alpha  D02        NA 20,000_cells + HCMEC D3_line         0
      12      0 Alpha  D03        NA 20,000_cells + HCMEC D3_line         0
      13      0 Alpha  E01        NA 15,000_cells + HCMEC D3_line         0
      14      0 Alpha  E02        NA 15,000_cells + HCMEC D3_line         0
      15      0 Alpha  E03        NA 15,000_cells + HCMEC D3_line         0
      16      0 Alpha  F01        NA 10,000_cells + HCMEC D3_line         0
      17      0 Alpha  F02        NA 10,000_cells + HCMEC D3_line         0
      18      0 Alpha  F03        NA 10,000_cells + HCMEC D3_line         0
      19      0 Alpha  G01        NA  5,000_cells + HCMEC D3_line         0
      20      0 Alpha  G02        NA  5,000_cells + HCMEC D3_line         0
      21      0 Alpha  G03        NA  5,000_cells + HCMEC D3_line         0
      22      0    Cm  A01        NA 35,000_cells + HCMEC D3_line         0
      23      0    Cm  A02        NA 35,000_cells + HCMEC D3_line         0
      24      0    Cm  A03        NA 35,000_cells + HCMEC D3_line         0
      25      0    Cm  B01        NA 30,000_cells + HCMEC D3_line         0
      26      0    Cm  B02        NA 30,000_cells + HCMEC D3_line         0
      27      0    Cm  B03        NA 30,000_cells + HCMEC D3_line         0
      28      0    Cm  C01        NA 25,000_cells + HCMEC D3_line         0
      29      0    Cm  C02        NA 25,000_cells + HCMEC D3_line         0
      30      0    Cm  C03        NA 25,000_cells + HCMEC D3_line         0
      31      0    Cm  D01        NA 20,000_cells + HCMEC D3_line         0
      32      0    Cm  D02        NA 20,000_cells + HCMEC D3_line         0
      33      0    Cm  D03        NA 20,000_cells + HCMEC D3_line         0
      34      0    Cm  E01        NA 15,000_cells + HCMEC D3_line         0
      35      0    Cm  E02        NA 15,000_cells + HCMEC D3_line         0
      36      0    Cm  E03        NA 15,000_cells + HCMEC D3_line         0
      37      0    Cm  F01        NA 10,000_cells + HCMEC D3_line         0
      38      0    Cm  F02        NA 10,000_cells + HCMEC D3_line         0
      39      0    Cm  F03        NA 10,000_cells + HCMEC D3_line         0
      40      0    Cm  G01        NA  5,000_cells + HCMEC D3_line         0
      41      0    Cm  G02        NA  5,000_cells + HCMEC D3_line         0
      42      0    Cm  G03        NA  5,000_cells + HCMEC D3_line         0
      43      0 Drift  A01        NA 35,000_cells + HCMEC D3_line         0
      44      0 Drift  A02        NA 35,000_cells + HCMEC D3_line         0
      45      0 Drift  A03        NA 35,000_cells + HCMEC D3_line         0
      46      0 Drift  B01        NA 30,000_cells + HCMEC D3_line         0
      47      0 Drift  B02        NA 30,000_cells + HCMEC D3_line         0
      48      0 Drift  B03        NA 30,000_cells + HCMEC D3_line         0
      49      0 Drift  C01        NA 25,000_cells + HCMEC D3_line         0
      50      0 Drift  C02        NA 25,000_cells + HCMEC D3_line         0
      51      0 Drift  C03        NA 25,000_cells + HCMEC D3_line         0
      52      0 Drift  D01        NA 20,000_cells + HCMEC D3_line         0
      53      0 Drift  D02        NA 20,000_cells + HCMEC D3_line         0
      54      0 Drift  D03        NA 20,000_cells + HCMEC D3_line         0
      55      0 Drift  E01        NA 15,000_cells + HCMEC D3_line         0
      56      0 Drift  E02        NA 15,000_cells + HCMEC D3_line         0
      57      0 Drift  E03        NA 15,000_cells + HCMEC D3_line         0
      58      0 Drift  F01        NA 10,000_cells + HCMEC D3_line         0
      59      0 Drift  F02        NA 10,000_cells + HCMEC D3_line         0
      60      0 Drift  F03        NA 10,000_cells + HCMEC D3_line         0
      61      0 Drift  G01        NA  5,000_cells + HCMEC D3_line         0
      62      0 Drift  G02        NA  5,000_cells + HCMEC D3_line         0
      63      0 Drift  G03        NA  5,000_cells + HCMEC D3_line         0
      64      0    Rb  A01        NA 35,000_cells + HCMEC D3_line         0
      65      0    Rb  A02        NA 35,000_cells + HCMEC D3_line         0
      66      0    Rb  A03        NA 35,000_cells + HCMEC D3_line         0
      67      0    Rb  B01        NA 30,000_cells + HCMEC D3_line         0
      68      0    Rb  B02        NA 30,000_cells + HCMEC D3_line         0
      69      0    Rb  B03        NA 30,000_cells + HCMEC D3_line         0
      70      0    Rb  C01        NA 25,000_cells + HCMEC D3_line         0
      71      0    Rb  C02        NA 25,000_cells + HCMEC D3_line         0
      72      0    Rb  C03        NA 25,000_cells + HCMEC D3_line         0
      73      0    Rb  D01        NA 20,000_cells + HCMEC D3_line         0
      74      0    Rb  D02        NA 20,000_cells + HCMEC D3_line         0
      75      0    Rb  D03        NA 20,000_cells + HCMEC D3_line         0
      76      0    Rb  E01        NA 15,000_cells + HCMEC D3_line         0
      77      0    Rb  E02        NA 15,000_cells + HCMEC D3_line         0
      78      0    Rb  E03        NA 15,000_cells + HCMEC D3_line         0
      79      0    Rb  F01        NA 10,000_cells + HCMEC D3_line         0
      80      0    Rb  F02        NA 10,000_cells + HCMEC D3_line         0
      81      0    Rb  F03        NA 10,000_cells + HCMEC D3_line         0
      82      0    Rb  G01        NA  5,000_cells + HCMEC D3_line         0
      83      0    Rb  G02        NA  5,000_cells + HCMEC D3_line         0
      84      0    Rb  G03        NA  5,000_cells + HCMEC D3_line         0
      85      0  RMSE  A01        NA 35,000_cells + HCMEC D3_line         0
      86      0  RMSE  A02        NA 35,000_cells + HCMEC D3_line         0
      87      0  RMSE  A03        NA 35,000_cells + HCMEC D3_line         0
      88      0  RMSE  B01        NA 30,000_cells + HCMEC D3_line         0
      89      0  RMSE  B02        NA 30,000_cells + HCMEC D3_line         0
      90      0  RMSE  B03        NA 30,000_cells + HCMEC D3_line         0
      91      0  RMSE  C01        NA 25,000_cells + HCMEC D3_line         0
      92      0  RMSE  C02        NA 25,000_cells + HCMEC D3_line         0
      93      0  RMSE  C03        NA 25,000_cells + HCMEC D3_line         0
      94      0  RMSE  D01        NA 20,000_cells + HCMEC D3_line         0
      95      0  RMSE  D02        NA 20,000_cells + HCMEC D3_line         0
      96      0  RMSE  D03        NA 20,000_cells + HCMEC D3_line         0
      97      0  RMSE  E01        NA 15,000_cells + HCMEC D3_line         0
      98      0  RMSE  E02        NA 15,000_cells + HCMEC D3_line         0
      99      0  RMSE  E03        NA 15,000_cells + HCMEC D3_line         0
      100     0  RMSE  F01        NA 10,000_cells + HCMEC D3_line         0
      101     0  RMSE  F02        NA 10,000_cells + HCMEC D3_line         0
      102     0  RMSE  F03        NA 10,000_cells + HCMEC D3_line         0
      103     0  RMSE  G01        NA  5,000_cells + HCMEC D3_line         0
      104     0  RMSE  G02        NA  5,000_cells + HCMEC D3_line         0
      105     0  RMSE  G03        NA  5,000_cells + HCMEC D3_line         0
      106     5 Alpha  A01   2.69000 35,000_cells + HCMEC D3_line         0
      107     5 Alpha  A02   2.89000 35,000_cells + HCMEC D3_line         0
      108     5 Alpha  A03   2.71000 35,000_cells + HCMEC D3_line         0
      109     5 Alpha  B01   2.52000 30,000_cells + HCMEC D3_line         0
      110     5 Alpha  B02   2.69000 30,000_cells + HCMEC D3_line         0
      111     5 Alpha  B03   2.34000 30,000_cells + HCMEC D3_line         0
      112     5 Alpha  C01   2.15000 25,000_cells + HCMEC D3_line         0
      113     5 Alpha  C02   2.35000 25,000_cells + HCMEC D3_line         0
      114     5 Alpha  C03   2.40000 25,000_cells + HCMEC D3_line         0
      115     5 Alpha  D01   1.85000 20,000_cells + HCMEC D3_line         0
      116     5 Alpha  D02   2.02000 20,000_cells + HCMEC D3_line         0
      117     5 Alpha  D03   2.05000 20,000_cells + HCMEC D3_line         0
      118     5 Alpha  E01   1.54000 15,000_cells + HCMEC D3_line         0
      119     5 Alpha  E02   1.67000 15,000_cells + HCMEC D3_line         0
      120     5 Alpha  E03   1.90000 15,000_cells + HCMEC D3_line         0
      121     5 Alpha  F01   1.34000 10,000_cells + HCMEC D3_line         0
      122     5 Alpha  F02   0.00000 10,000_cells + HCMEC D3_line         0
      123     5 Alpha  F03   1.49000 10,000_cells + HCMEC D3_line         0
      124     5 Alpha  G01   0.86000  5,000_cells + HCMEC D3_line         0
      125     5 Alpha  G02   0.81000  5,000_cells + HCMEC D3_line         0
      126     5 Alpha  G03   0.83000  5,000_cells + HCMEC D3_line         0
      127     5    Cm  A01  37.92000 35,000_cells + HCMEC D3_line         0
      128     5    Cm  A02  24.99000 35,000_cells + HCMEC D3_line         0
      129     5    Cm  A03  32.07000 35,000_cells + HCMEC D3_line         0
      130     5    Cm  B01  35.10000 30,000_cells + HCMEC D3_line         0
      131     5    Cm  B02  37.68000 30,000_cells + HCMEC D3_line         0
      132     5    Cm  B03  48.99000 30,000_cells + HCMEC D3_line         0
      133     5    Cm  C01  53.35000 25,000_cells + HCMEC D3_line         0
      134     5    Cm  C02  52.07000 25,000_cells + HCMEC D3_line         0
      135     5    Cm  C03  53.22000 25,000_cells + HCMEC D3_line         0
      136     5    Cm  D01  85.61000 20,000_cells + HCMEC D3_line         0
      137     5    Cm  D02  86.11000 20,000_cells + HCMEC D3_line         0
      138     5    Cm  D03  75.01000 20,000_cells + HCMEC D3_line         0
      139     5    Cm  E01 105.36000 15,000_cells + HCMEC D3_line         0
      140     5    Cm  E02 128.54000 15,000_cells + HCMEC D3_line         0
      141     5    Cm  E03 111.94000 15,000_cells + HCMEC D3_line         0
      142     5    Cm  F01 166.67000 10,000_cells + HCMEC D3_line         0
      143     5    Cm  F02 288.68000 10,000_cells + HCMEC D3_line         0
      144     5    Cm  F03 135.38000 10,000_cells + HCMEC D3_line         0
      145     5    Cm  G01 483.51000  5,000_cells + HCMEC D3_line         0
      146     5    Cm  G02 575.87000  5,000_cells + HCMEC D3_line         0
      147     5    Cm  G03 370.22000  5,000_cells + HCMEC D3_line         0
      148     5 Drift  A01  -0.94000 35,000_cells + HCMEC D3_line         0
      149     5 Drift  A02  -1.22000 35,000_cells + HCMEC D3_line         0
      150     5 Drift  A03  -0.65000 35,000_cells + HCMEC D3_line         0
      151     5 Drift  B01  -1.21000 30,000_cells + HCMEC D3_line         0
      152     5 Drift  B02  -1.10000 30,000_cells + HCMEC D3_line         0
      153     5 Drift  B03  -0.58000 30,000_cells + HCMEC D3_line         0
      154     5 Drift  C01  -1.26000 25,000_cells + HCMEC D3_line         0
      155     5 Drift  C02  -1.29000 25,000_cells + HCMEC D3_line         0
      156     5 Drift  C03  -0.77000 25,000_cells + HCMEC D3_line         0
      157     5 Drift  D01  -1.11000 20,000_cells + HCMEC D3_line         0
      158     5 Drift  D02  -1.14000 20,000_cells + HCMEC D3_line         0
      159     5 Drift  D03  -0.21000 20,000_cells + HCMEC D3_line         0
      160     5 Drift  E01   0.08000 15,000_cells + HCMEC D3_line         0
      161     5 Drift  E02   0.09000 15,000_cells + HCMEC D3_line         0
      162     5 Drift  E03   0.11000 15,000_cells + HCMEC D3_line         0
      163     5 Drift  F01  -0.01000 10,000_cells + HCMEC D3_line         0
      164     5 Drift  F02   0.06000 10,000_cells + HCMEC D3_line         0
      165     5 Drift  F03   0.35000 10,000_cells + HCMEC D3_line         0
      166     5 Drift  G01  -0.11000  5,000_cells + HCMEC D3_line         0
      167     5 Drift  G02  -0.01000  5,000_cells + HCMEC D3_line         0
      168     5 Drift  G03   0.36000  5,000_cells + HCMEC D3_line         0
      169     5    Rb  A01   0.00000 35,000_cells + HCMEC D3_line         0
      170     5    Rb  A02   0.00000 35,000_cells + HCMEC D3_line         0
      171     5    Rb  A03   0.00000 35,000_cells + HCMEC D3_line         0
      172     5    Rb  B01   0.00000 30,000_cells + HCMEC D3_line         0
      173     5    Rb  B02   0.00000 30,000_cells + HCMEC D3_line         0
      174     5    Rb  B03   0.00000 30,000_cells + HCMEC D3_line         0
      175     5    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      176     5    Rb  C02   0.00000 25,000_cells + HCMEC D3_line         0
      177     5    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      178     5    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      179     5    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      180     5    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      181     5    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      182     5    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      183     5    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      184     5    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      185     5    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      186     5    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      187     5    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      188     5    Rb  G02   0.01000  5,000_cells + HCMEC D3_line         0
      189     5    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      190     5  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      191     5  RMSE  A02   0.02000 35,000_cells + HCMEC D3_line         0
      192     5  RMSE  A03   0.02000 35,000_cells + HCMEC D3_line         0
      193     5  RMSE  B01   0.02000 30,000_cells + HCMEC D3_line         0
      194     5  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      195     5  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      196     5  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      197     5  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      198     5  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      199     5  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      200     5  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      201     5  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      202     5  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      203     5  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      204     5  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      205     5  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      206     5  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      207     5  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      208     5  RMSE  G01   0.00000  5,000_cells + HCMEC D3_line         0
      209     5  RMSE  G02   0.00000  5,000_cells + HCMEC D3_line         0
      210     5  RMSE  G03   0.00000  5,000_cells + HCMEC D3_line         0
      211    10 Alpha  A01   3.34000 35,000_cells + HCMEC D3_line         0
      212    10 Alpha  A02   3.77000 35,000_cells + HCMEC D3_line         0
      213    10 Alpha  A03   3.25000 35,000_cells + HCMEC D3_line         0
      214    10 Alpha  B01   3.15000 30,000_cells + HCMEC D3_line         0
      215    10 Alpha  B02   3.40000 30,000_cells + HCMEC D3_line         0
      216    10 Alpha  B03   2.89000 30,000_cells + HCMEC D3_line         0
      217    10 Alpha  C01   2.71000 25,000_cells + HCMEC D3_line         0
      218    10 Alpha  C02   2.88000 25,000_cells + HCMEC D3_line         0
      219    10 Alpha  C03   2.83000 25,000_cells + HCMEC D3_line         0
      220    10 Alpha  D01   2.27000 20,000_cells + HCMEC D3_line         0
      221    10 Alpha  D02   2.52000 20,000_cells + HCMEC D3_line         0
      222    10 Alpha  D03   2.56000 20,000_cells + HCMEC D3_line         0
      223    10 Alpha  E01   1.89000 15,000_cells + HCMEC D3_line         0
      224    10 Alpha  E02   2.01000 15,000_cells + HCMEC D3_line         0
      225    10 Alpha  E03   2.26000 15,000_cells + HCMEC D3_line         0
      226    10 Alpha  F01   1.66000 10,000_cells + HCMEC D3_line         0
      227    10 Alpha  F02   1.58000 10,000_cells + HCMEC D3_line         0
      228    10 Alpha  F03   1.81000 10,000_cells + HCMEC D3_line         0
      229    10 Alpha  G01   0.12000  5,000_cells + HCMEC D3_line         0
      230    10 Alpha  G02   0.99000  5,000_cells + HCMEC D3_line         0
      231    10 Alpha  G03   1.07000  5,000_cells + HCMEC D3_line         0
      232    10    Cm  A01  18.81000 35,000_cells + HCMEC D3_line         0
      233    10    Cm  A02  10.18000 35,000_cells + HCMEC D3_line         0
      234    10    Cm  A03  17.32000 35,000_cells + HCMEC D3_line         0
      235    10    Cm  B01  17.67000 30,000_cells + HCMEC D3_line         0
      236    10    Cm  B02  18.12000 30,000_cells + HCMEC D3_line         0
      237    10    Cm  B03  27.73000 30,000_cells + HCMEC D3_line         0
      238    10    Cm  C01  29.00000 25,000_cells + HCMEC D3_line         0
      239    10    Cm  C02  28.21000 25,000_cells + HCMEC D3_line         0
      240    10    Cm  C03  32.41000 25,000_cells + HCMEC D3_line         0
      241    10    Cm  D01  50.82000 20,000_cells + HCMEC D3_line         0
      242    10    Cm  D02  49.00000 20,000_cells + HCMEC D3_line         0
      243    10    Cm  D03  44.11000 20,000_cells + HCMEC D3_line         0
      244    10    Cm  E01  66.01000 15,000_cells + HCMEC D3_line         0
      245    10    Cm  E02  80.91000 15,000_cells + HCMEC D3_line         0
      246    10    Cm  E03  72.87000 15,000_cells + HCMEC D3_line         0
      247    10    Cm  F01  99.81000 10,000_cells + HCMEC D3_line         0
      248    10    Cm  F02 137.38000 10,000_cells + HCMEC D3_line         0
      249    10    Cm  F03  88.22000 10,000_cells + HCMEC D3_line         0
      250    10    Cm  G01 420.13000  5,000_cells + HCMEC D3_line         0
      251    10    Cm  G02 350.01000  5,000_cells + HCMEC D3_line         0
      252    10    Cm  G03 233.36000  5,000_cells + HCMEC D3_line         0
      253    10 Drift  A01  -1.82000 35,000_cells + HCMEC D3_line         0
      254    10 Drift  A02  -2.30000 35,000_cells + HCMEC D3_line         0
      255    10 Drift  A03  -1.59000 35,000_cells + HCMEC D3_line         0
      256    10 Drift  B01  -2.10000 30,000_cells + HCMEC D3_line         0
      257    10 Drift  B02  -2.16000 30,000_cells + HCMEC D3_line         0
      258    10 Drift  B03  -1.48000 30,000_cells + HCMEC D3_line         0
      259    10 Drift  C01  -2.12000 25,000_cells + HCMEC D3_line         0
      260    10 Drift  C02  -2.18000 25,000_cells + HCMEC D3_line         0
      261    10 Drift  C03  -1.62000 25,000_cells + HCMEC D3_line         0
      262    10 Drift  D01  -1.80000 20,000_cells + HCMEC D3_line         0
      263    10 Drift  D02  -1.99000 20,000_cells + HCMEC D3_line         0
      264    10 Drift  D03  -1.03000 20,000_cells + HCMEC D3_line         0
      265    10 Drift  E01  -0.50000 15,000_cells + HCMEC D3_line         0
      266    10 Drift  E02  -0.57000 15,000_cells + HCMEC D3_line         0
      267    10 Drift  E03  -0.53000 15,000_cells + HCMEC D3_line         0
      268    10 Drift  F01  -0.47000 10,000_cells + HCMEC D3_line         0
      269    10 Drift  F02  -0.43000 10,000_cells + HCMEC D3_line         0
      270    10 Drift  F03  -0.18000 10,000_cells + HCMEC D3_line         0
      271    10 Drift  G01  -0.33000  5,000_cells + HCMEC D3_line         0
      272    10 Drift  G02  -0.30000  5,000_cells + HCMEC D3_line         0
      273    10 Drift  G03   0.07000  5,000_cells + HCMEC D3_line         0
      274    10    Rb  A01   0.00000 35,000_cells + HCMEC D3_line         0
      275    10    Rb  A02   0.00000 35,000_cells + HCMEC D3_line         0
      276    10    Rb  A03   0.00000 35,000_cells + HCMEC D3_line         0
      277    10    Rb  B01   0.00000 30,000_cells + HCMEC D3_line         0
      278    10    Rb  B02   0.00000 30,000_cells + HCMEC D3_line         0
      279    10    Rb  B03   0.00000 30,000_cells + HCMEC D3_line         0
      280    10    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      281    10    Rb  C02   0.00000 25,000_cells + HCMEC D3_line         0
      282    10    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      283    10    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      284    10    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      285    10    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      286    10    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      287    10    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      288    10    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      289    10    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      290    10    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      291    10    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      292    10    Rb  G01   0.13000  5,000_cells + HCMEC D3_line         0
      293    10    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      294    10    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      295    10  RMSE  A01   0.02000 35,000_cells + HCMEC D3_line         0
      296    10  RMSE  A02   0.03000 35,000_cells + HCMEC D3_line         0
      297    10  RMSE  A03   0.02000 35,000_cells + HCMEC D3_line         0
      298    10  RMSE  B01   0.03000 30,000_cells + HCMEC D3_line         0
      299    10  RMSE  B02   0.02000 30,000_cells + HCMEC D3_line         0
      300    10  RMSE  B03   0.02000 30,000_cells + HCMEC D3_line         0
      301    10  RMSE  C01   0.02000 25,000_cells + HCMEC D3_line         0
      302    10  RMSE  C02   0.02000 25,000_cells + HCMEC D3_line         0
      303    10  RMSE  C03   0.02000 25,000_cells + HCMEC D3_line         0
      304    10  RMSE  D01   0.02000 20,000_cells + HCMEC D3_line         0
      305    10  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      306    10  RMSE  D03   0.02000 20,000_cells + HCMEC D3_line         0
      307    10  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      308    10  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      309    10  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      310    10  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      311    10  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      312    10  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      313    10  RMSE  G01   0.00000  5,000_cells + HCMEC D3_line         0
      314    10  RMSE  G02   0.00000  5,000_cells + HCMEC D3_line         0
      315    10  RMSE  G03   0.00000  5,000_cells + HCMEC D3_line         0
      316    15 Alpha  A01   4.17000 35,000_cells + HCMEC D3_line         0
      317    15 Alpha  A02   4.65000 35,000_cells + HCMEC D3_line         0
      318    15 Alpha  A03   4.05000 35,000_cells + HCMEC D3_line         0
      319    15 Alpha  B01   3.95000 30,000_cells + HCMEC D3_line         0
      320    15 Alpha  B02   4.12000 30,000_cells + HCMEC D3_line         0
      321    15 Alpha  B03   3.56000 30,000_cells + HCMEC D3_line         0
      322    15 Alpha  C01   3.33000 25,000_cells + HCMEC D3_line         0
      323    15 Alpha  C02   3.53000 25,000_cells + HCMEC D3_line         0
      324    15 Alpha  C03   3.33000 25,000_cells + HCMEC D3_line         0
      325    15 Alpha  D01   2.79000 20,000_cells + HCMEC D3_line         0
      326    15 Alpha  D02   3.00000 20,000_cells + HCMEC D3_line         0
      327    15 Alpha  D03   3.04000 20,000_cells + HCMEC D3_line         0
      328    15 Alpha  E01   2.40000 15,000_cells + HCMEC D3_line         0
      329    15 Alpha  E02   2.49000 15,000_cells + HCMEC D3_line         0
      330    15 Alpha  E03   2.68000 15,000_cells + HCMEC D3_line         0
      331    15 Alpha  F01   2.13000 10,000_cells + HCMEC D3_line         0
      332    15 Alpha  F02   1.90000 10,000_cells + HCMEC D3_line         0
      333    15 Alpha  F03   2.20000 10,000_cells + HCMEC D3_line         0
      334    15 Alpha  G01   0.00000  5,000_cells + HCMEC D3_line         0
      335    15 Alpha  G02   0.00000  5,000_cells + HCMEC D3_line         0
      336    15 Alpha  G03   1.31000  5,000_cells + HCMEC D3_line         0
      337    15    Cm  A01   8.72000 35,000_cells + HCMEC D3_line         0
      338    15    Cm  A02   4.23000 35,000_cells + HCMEC D3_line         0
      339    15    Cm  A03   8.21000 35,000_cells + HCMEC D3_line         0
      340    15    Cm  B01   8.69000 30,000_cells + HCMEC D3_line         0
      341    15    Cm  B02   8.76000 30,000_cells + HCMEC D3_line         0
      342    15    Cm  B03  15.63000 30,000_cells + HCMEC D3_line         0
      343    15    Cm  C01  16.50000 25,000_cells + HCMEC D3_line         0
      344    15    Cm  C02  15.67000 25,000_cells + HCMEC D3_line         0
      345    15    Cm  C03  20.39000 25,000_cells + HCMEC D3_line         0
      346    15    Cm  D01  30.31000 20,000_cells + HCMEC D3_line         0
      347    15    Cm  D02  28.81000 20,000_cells + HCMEC D3_line         0
      348    15    Cm  D03  27.52000 20,000_cells + HCMEC D3_line         0
      349    15    Cm  E01  42.55000 15,000_cells + HCMEC D3_line         0
      350    15    Cm  E02  50.91000 15,000_cells + HCMEC D3_line         0
      351    15    Cm  E03  45.32000 15,000_cells + HCMEC D3_line         0
      352    15    Cm  F01  59.93000 10,000_cells + HCMEC D3_line         0
      353    15    Cm  F02  89.04000 10,000_cells + HCMEC D3_line         0
      354    15    Cm  F03  54.78000 10,000_cells + HCMEC D3_line         0
      355    15    Cm  G01 278.45000  5,000_cells + HCMEC D3_line         0
      356    15    Cm  G02 316.14000  5,000_cells + HCMEC D3_line         0
      357    15    Cm  G03 153.02000  5,000_cells + HCMEC D3_line         0
      358    15 Drift  A01  -2.72000 35,000_cells + HCMEC D3_line         0
      359    15 Drift  A02  -3.20000 35,000_cells + HCMEC D3_line         0
      360    15 Drift  A03  -2.59000 35,000_cells + HCMEC D3_line         0
      361    15 Drift  B01  -3.04000 30,000_cells + HCMEC D3_line         0
      362    15 Drift  B02  -3.06000 30,000_cells + HCMEC D3_line         0
      363    15 Drift  B03  -2.37000 30,000_cells + HCMEC D3_line         0
      364    15 Drift  C01  -2.97000 25,000_cells + HCMEC D3_line         0
      365    15 Drift  C02  -3.08000 25,000_cells + HCMEC D3_line         0
      366    15 Drift  C03  -2.45000 25,000_cells + HCMEC D3_line         0
      367    15 Drift  D01  -2.62000 20,000_cells + HCMEC D3_line         0
      368    15 Drift  D02  -2.87000 20,000_cells + HCMEC D3_line         0
      369    15 Drift  D03  -1.84000 20,000_cells + HCMEC D3_line         0
      370    15 Drift  E01  -1.25000 15,000_cells + HCMEC D3_line         0
      371    15 Drift  E02  -1.27000 15,000_cells + HCMEC D3_line         0
      372    15 Drift  E03  -1.29000 15,000_cells + HCMEC D3_line         0
      373    15 Drift  F01  -1.08000 10,000_cells + HCMEC D3_line         0
      374    15 Drift  F02  -0.97000 10,000_cells + HCMEC D3_line         0
      375    15 Drift  F03  -0.72000 10,000_cells + HCMEC D3_line         0
      376    15 Drift  G01  -0.64000  5,000_cells + HCMEC D3_line         0
      377    15 Drift  G02  -0.61000  5,000_cells + HCMEC D3_line         0
      378    15 Drift  G03  -0.26000  5,000_cells + HCMEC D3_line         0
      379    15    Rb  A01   0.00000 35,000_cells + HCMEC D3_line         0
      380    15    Rb  A02   0.00000 35,000_cells + HCMEC D3_line         0
      381    15    Rb  A03   0.00000 35,000_cells + HCMEC D3_line         0
      382    15    Rb  B01   0.00000 30,000_cells + HCMEC D3_line         0
      383    15    Rb  B02   0.00000 30,000_cells + HCMEC D3_line         0
      384    15    Rb  B03   0.00000 30,000_cells + HCMEC D3_line         0
      385    15    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      386    15    Rb  C02   0.00000 25,000_cells + HCMEC D3_line         0
      387    15    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      388    15    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      389    15    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      390    15    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      391    15    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      392    15    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      393    15    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      394    15    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      395    15    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      396    15    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      397    15    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      398    15    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      399    15    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      400    15  RMSE  A01   0.02000 35,000_cells + HCMEC D3_line         0
      401    15  RMSE  A02   0.02000 35,000_cells + HCMEC D3_line         0
      402    15  RMSE  A03   0.03000 35,000_cells + HCMEC D3_line         0
      403    15  RMSE  B01   0.03000 30,000_cells + HCMEC D3_line         0
      404    15  RMSE  B02   0.03000 30,000_cells + HCMEC D3_line         0
      405    15  RMSE  B03   0.03000 30,000_cells + HCMEC D3_line         0
      406    15  RMSE  C01   0.03000 25,000_cells + HCMEC D3_line         0
      407    15  RMSE  C02   0.03000 25,000_cells + HCMEC D3_line         0
      408    15  RMSE  C03   0.02000 25,000_cells + HCMEC D3_line         0
      409    15  RMSE  D01   0.03000 20,000_cells + HCMEC D3_line         0
      410    15  RMSE  D02   0.02000 20,000_cells + HCMEC D3_line         0
      411    15  RMSE  D03   0.02000 20,000_cells + HCMEC D3_line         0
      412    15  RMSE  E01   0.02000 15,000_cells + HCMEC D3_line         0
      413    15  RMSE  E02   0.02000 15,000_cells + HCMEC D3_line         0
      414    15  RMSE  E03   0.02000 15,000_cells + HCMEC D3_line         0
      415    15  RMSE  F01   0.02000 10,000_cells + HCMEC D3_line         0
      416    15  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      417    15  RMSE  F03   0.02000 10,000_cells + HCMEC D3_line         0
      418    15  RMSE  G01   0.02000  5,000_cells + HCMEC D3_line         0
      419    15  RMSE  G02   0.02000  5,000_cells + HCMEC D3_line         0
      420    15  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      421    20 Alpha  A01   4.85000 35,000_cells + HCMEC D3_line         0
      422    20 Alpha  A02   5.30000 35,000_cells + HCMEC D3_line         0
      423    20 Alpha  A03   4.65000 35,000_cells + HCMEC D3_line         0
      424    20 Alpha  B01   4.68000 30,000_cells + HCMEC D3_line         0
      425    20 Alpha  B02   4.77000 30,000_cells + HCMEC D3_line         0
      426    20 Alpha  B03   4.08000 30,000_cells + HCMEC D3_line         0
      427    20 Alpha  C01   3.96000 25,000_cells + HCMEC D3_line         0
      428    20 Alpha  C02   4.00000 25,000_cells + HCMEC D3_line         0
      429    20 Alpha  C03   3.81000 25,000_cells + HCMEC D3_line         0
      430    20 Alpha  D01   3.29000 20,000_cells + HCMEC D3_line         0
      431    20 Alpha  D02   3.45000 20,000_cells + HCMEC D3_line         0
      432    20 Alpha  D03   3.38000 20,000_cells + HCMEC D3_line         0
      433    20 Alpha  E01   2.76000 15,000_cells + HCMEC D3_line         0
      434    20 Alpha  E02   2.82000 15,000_cells + HCMEC D3_line         0
      435    20 Alpha  E03   2.99000 15,000_cells + HCMEC D3_line         0
      436    20 Alpha  F01   2.47000 10,000_cells + HCMEC D3_line         0
      437    20 Alpha  F02   2.23000 10,000_cells + HCMEC D3_line         0
      438    20 Alpha  F03   2.52000 10,000_cells + HCMEC D3_line         0
      439    20 Alpha  G01   1.48000  5,000_cells + HCMEC D3_line         0
      440    20 Alpha  G02   1.38000  5,000_cells + HCMEC D3_line         0
      441    20 Alpha  G03   1.42000  5,000_cells + HCMEC D3_line         0
      442    20    Cm  A01   4.49000 35,000_cells + HCMEC D3_line         0
      443    20    Cm  A02   2.04000 35,000_cells + HCMEC D3_line         0
      444    20    Cm  A03   4.65000 35,000_cells + HCMEC D3_line         0
      445    20    Cm  B01   4.48000 30,000_cells + HCMEC D3_line         0
      446    20    Cm  B02   4.45000 30,000_cells + HCMEC D3_line         0
      447    20    Cm  B03   9.21000 30,000_cells + HCMEC D3_line         0
      448    20    Cm  C01  10.13000 25,000_cells + HCMEC D3_line         0
      449    20    Cm  C02   9.67000 25,000_cells + HCMEC D3_line         0
      450    20    Cm  C03  12.95000 25,000_cells + HCMEC D3_line         0
      451    20    Cm  D01  20.30000 20,000_cells + HCMEC D3_line         0
      452    20    Cm  D02  18.87000 20,000_cells + HCMEC D3_line         0
      453    20    Cm  D03  18.58000 20,000_cells + HCMEC D3_line         0
      454    20    Cm  E01  29.63000 15,000_cells + HCMEC D3_line         0
      455    20    Cm  E02  34.32000 15,000_cells + HCMEC D3_line         0
      456    20    Cm  E03  32.26000 15,000_cells + HCMEC D3_line         0
      457    20    Cm  F01  41.72000 10,000_cells + HCMEC D3_line         0
      458    20    Cm  F02  63.88000 10,000_cells + HCMEC D3_line         0
      459    20    Cm  F03  40.67000 10,000_cells + HCMEC D3_line         0
      460    20    Cm  G01 156.28000  5,000_cells + HCMEC D3_line         0
      461    20    Cm  G02 177.70000  5,000_cells + HCMEC D3_line         0
      462    20    Cm  G03 111.97000  5,000_cells + HCMEC D3_line         0
      463    20 Drift  A01  -3.39000 35,000_cells + HCMEC D3_line         0
      464    20 Drift  A02  -3.78000 35,000_cells + HCMEC D3_line         0
      465    20 Drift  A03  -3.19000 35,000_cells + HCMEC D3_line         0
      466    20 Drift  B01  -3.72000 30,000_cells + HCMEC D3_line         0
      467    20 Drift  B02  -3.74000 30,000_cells + HCMEC D3_line         0
      468    20 Drift  B03  -3.10000 30,000_cells + HCMEC D3_line         0
      469    20 Drift  C01  -3.72000 25,000_cells + HCMEC D3_line         0
      470    20 Drift  C02  -3.80000 25,000_cells + HCMEC D3_line         0
      471    20 Drift  C03  -3.15000 25,000_cells + HCMEC D3_line         0
      472    20 Drift  D01  -3.32000 20,000_cells + HCMEC D3_line         0
      473    20 Drift  D02  -3.52000 20,000_cells + HCMEC D3_line         0
      474    20 Drift  D03  -2.50000 20,000_cells + HCMEC D3_line         0
      475    20 Drift  E01  -1.81000 15,000_cells + HCMEC D3_line         0
      476    20 Drift  E02  -1.92000 15,000_cells + HCMEC D3_line         0
      477    20 Drift  E03  -1.88000 15,000_cells + HCMEC D3_line         0
      478    20 Drift  F01  -1.64000 10,000_cells + HCMEC D3_line         0
      479    20 Drift  F02  -1.52000 10,000_cells + HCMEC D3_line         0
      480    20 Drift  F03  -1.20000 10,000_cells + HCMEC D3_line         0
      481    20 Drift  G01  -0.96000  5,000_cells + HCMEC D3_line         0
      482    20 Drift  G02  -0.95000  5,000_cells + HCMEC D3_line         0
      483    20 Drift  G03  -0.56000  5,000_cells + HCMEC D3_line         0
      484    20    Rb  A01   0.00000 35,000_cells + HCMEC D3_line         0
      485    20    Rb  A02   0.01000 35,000_cells + HCMEC D3_line         0
      486    20    Rb  A03   0.00000 35,000_cells + HCMEC D3_line         0
      487    20    Rb  B01   0.00000 30,000_cells + HCMEC D3_line         0
      488    20    Rb  B02   0.00000 30,000_cells + HCMEC D3_line         0
      489    20    Rb  B03   0.00000 30,000_cells + HCMEC D3_line         0
      490    20    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      491    20    Rb  C02   0.00000 25,000_cells + HCMEC D3_line         0
      492    20    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      493    20    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      494    20    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      495    20    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      496    20    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      497    20    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      498    20    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      499    20    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      500    20    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      501    20    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      502    20    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      503    20    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      504    20    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      505    20  RMSE  A01   0.02000 35,000_cells + HCMEC D3_line         0
      506    20  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      507    20  RMSE  A03   0.02000 35,000_cells + HCMEC D3_line         0
      508    20  RMSE  B01   0.03000 30,000_cells + HCMEC D3_line         0
      509    20  RMSE  B02   0.03000 30,000_cells + HCMEC D3_line         0
      510    20  RMSE  B03   0.03000 30,000_cells + HCMEC D3_line         0
      511    20  RMSE  C01   0.04000 25,000_cells + HCMEC D3_line         0
      512    20  RMSE  C02   0.03000 25,000_cells + HCMEC D3_line         0
      513    20  RMSE  C03   0.03000 25,000_cells + HCMEC D3_line         0
      514    20  RMSE  D01   0.03000 20,000_cells + HCMEC D3_line         0
      515    20  RMSE  D02   0.03000 20,000_cells + HCMEC D3_line         0
      516    20  RMSE  D03   0.03000 20,000_cells + HCMEC D3_line         0
      517    20  RMSE  E01   0.03000 15,000_cells + HCMEC D3_line         0
      518    20  RMSE  E02   0.02000 15,000_cells + HCMEC D3_line         0
      519    20  RMSE  E03   0.02000 15,000_cells + HCMEC D3_line         0
      520    20  RMSE  F01   0.02000 10,000_cells + HCMEC D3_line         0
      521    20  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      522    20  RMSE  F03   0.02000 10,000_cells + HCMEC D3_line         0
      523    20  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      524    20  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      525    20  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      526    25 Alpha  A01   5.31000 35,000_cells + HCMEC D3_line         0
      527    25 Alpha  A02   5.32000 35,000_cells + HCMEC D3_line         0
      528    25 Alpha  A03   5.17000 35,000_cells + HCMEC D3_line         0
      529    25 Alpha  B01   5.10000 30,000_cells + HCMEC D3_line         0
      530    25 Alpha  B02   5.21000 30,000_cells + HCMEC D3_line         0
      531    25 Alpha  B03   4.59000 30,000_cells + HCMEC D3_line         0
      532    25 Alpha  C01   4.38000 25,000_cells + HCMEC D3_line         0
      533    25 Alpha  C02   4.46000 25,000_cells + HCMEC D3_line         0
      534    25 Alpha  C03   4.18000 25,000_cells + HCMEC D3_line         0
      535    25 Alpha  D01   3.69000 20,000_cells + HCMEC D3_line         0
      536    25 Alpha  D02   3.82000 20,000_cells + HCMEC D3_line         0
      537    25 Alpha  D03   3.74000 20,000_cells + HCMEC D3_line         0
      538    25 Alpha  E01   3.15000 15,000_cells + HCMEC D3_line         0
      539    25 Alpha  E02   3.22000 15,000_cells + HCMEC D3_line         0
      540    25 Alpha  E03   3.26000 15,000_cells + HCMEC D3_line         0
      541    25 Alpha  F01   2.73000 10,000_cells + HCMEC D3_line         0
      542    25 Alpha  F02   2.59000 10,000_cells + HCMEC D3_line         0
      543    25 Alpha  F03   2.72000 10,000_cells + HCMEC D3_line         0
      544    25 Alpha  G01   1.65000  5,000_cells + HCMEC D3_line         0
      545    25 Alpha  G02   1.50000  5,000_cells + HCMEC D3_line         0
      546    25 Alpha  G03   0.00000  5,000_cells + HCMEC D3_line         0
      547    25    Cm  A01   2.79000 35,000_cells + HCMEC D3_line         0
      548    25    Cm  A02   1.97000 35,000_cells + HCMEC D3_line         0
      549    25    Cm  A03   2.92000 35,000_cells + HCMEC D3_line         0
      550    25    Cm  B01   2.77000 30,000_cells + HCMEC D3_line         0
      551    25    Cm  B02   2.88000 30,000_cells + HCMEC D3_line         0
      552    25    Cm  B03   5.59000 30,000_cells + HCMEC D3_line         0
      553    25    Cm  C01   6.99000 25,000_cells + HCMEC D3_line         0
      554    25    Cm  C02   6.89000 25,000_cells + HCMEC D3_line         0
      555    25    Cm  C03   9.25000 25,000_cells + HCMEC D3_line         0
      556    25    Cm  D01  15.00000 20,000_cells + HCMEC D3_line         0
      557    25    Cm  D02  13.70000 20,000_cells + HCMEC D3_line         0
      558    25    Cm  D03  12.91000 20,000_cells + HCMEC D3_line         0
      559    25    Cm  E01  21.54000 15,000_cells + HCMEC D3_line         0
      560    25    Cm  E02  23.82000 15,000_cells + HCMEC D3_line         0
      561    25    Cm  E03  23.69000 15,000_cells + HCMEC D3_line         0
      562    25    Cm  F01  31.94000 10,000_cells + HCMEC D3_line         0
      563    25    Cm  F02  48.43000 10,000_cells + HCMEC D3_line         0
      564    25    Cm  F03  30.00000 10,000_cells + HCMEC D3_line         0
      565    25    Cm  G01 125.58000  5,000_cells + HCMEC D3_line         0
      566    25    Cm  G02 147.98000  5,000_cells + HCMEC D3_line         0
      567    25    Cm  G03 121.21000  5,000_cells + HCMEC D3_line         0
      568    25 Drift  A01  -3.86000 35,000_cells + HCMEC D3_line         0
      569    25 Drift  A02  -4.15000 35,000_cells + HCMEC D3_line         0
      570    25 Drift  A03  -3.59000 35,000_cells + HCMEC D3_line         0
      571    25 Drift  B01  -4.19000 30,000_cells + HCMEC D3_line         0
      572    25 Drift  B02  -4.28000 30,000_cells + HCMEC D3_line         0
      573    25 Drift  B03  -3.67000 30,000_cells + HCMEC D3_line         0
      574    25 Drift  C01  -4.27000 25,000_cells + HCMEC D3_line         0
      575    25 Drift  C02  -4.37000 25,000_cells + HCMEC D3_line         0
      576    25 Drift  C03  -3.71000 25,000_cells + HCMEC D3_line         0
      577    25 Drift  D01  -3.94000 20,000_cells + HCMEC D3_line         0
      578    25 Drift  D02  -3.95000 20,000_cells + HCMEC D3_line         0
      579    25 Drift  D03  -3.08000 20,000_cells + HCMEC D3_line         0
      580    25 Drift  E01  -2.35000 15,000_cells + HCMEC D3_line         0
      581    25 Drift  E02  -2.49000 15,000_cells + HCMEC D3_line         0
      582    25 Drift  E03  -2.36000 15,000_cells + HCMEC D3_line         0
      583    25 Drift  F01  -2.15000 10,000_cells + HCMEC D3_line         0
      584    25 Drift  F02  -2.00000 10,000_cells + HCMEC D3_line         0
      585    25 Drift  F03  -1.69000 10,000_cells + HCMEC D3_line         0
      586    25 Drift  G01  -1.26000  5,000_cells + HCMEC D3_line         0
      587    25 Drift  G02  -1.25000  5,000_cells + HCMEC D3_line         0
      588    25 Drift  G03  -0.88000  5,000_cells + HCMEC D3_line         0
      589    25    Rb  A01   0.00000 35,000_cells + HCMEC D3_line         0
      590    25    Rb  A02   0.42000 35,000_cells + HCMEC D3_line         0
      591    25    Rb  A03   0.00000 35,000_cells + HCMEC D3_line         0
      592    25    Rb  B01   0.00000 30,000_cells + HCMEC D3_line         0
      593    25    Rb  B02   0.00000 30,000_cells + HCMEC D3_line         0
      594    25    Rb  B03   0.00000 30,000_cells + HCMEC D3_line         0
      595    25    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      596    25    Rb  C02   0.00000 25,000_cells + HCMEC D3_line         0
      597    25    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      598    25    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      599    25    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      600    25    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      601    25    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      602    25    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      603    25    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      604    25    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      605    25    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      606    25    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      607    25    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      608    25    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      609    25    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      610    25  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      611    25  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      612    25  RMSE  A03   0.02000 35,000_cells + HCMEC D3_line         0
      613    25  RMSE  B01   0.02000 30,000_cells + HCMEC D3_line         0
      614    25  RMSE  B02   0.02000 30,000_cells + HCMEC D3_line         0
      615    25  RMSE  B03   0.03000 30,000_cells + HCMEC D3_line         0
      616    25  RMSE  C01   0.03000 25,000_cells + HCMEC D3_line         0
      617    25  RMSE  C02   0.03000 25,000_cells + HCMEC D3_line         0
      618    25  RMSE  C03   0.03000 25,000_cells + HCMEC D3_line         0
      619    25  RMSE  D01   0.03000 20,000_cells + HCMEC D3_line         0
      620    25  RMSE  D02   0.03000 20,000_cells + HCMEC D3_line         0
      621    25  RMSE  D03   0.03000 20,000_cells + HCMEC D3_line         0
      622    25  RMSE  E01   0.03000 15,000_cells + HCMEC D3_line         0
      623    25  RMSE  E02   0.03000 15,000_cells + HCMEC D3_line         0
      624    25  RMSE  E03   0.03000 15,000_cells + HCMEC D3_line         0
      625    25  RMSE  F01   0.02000 10,000_cells + HCMEC D3_line         0
      626    25  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      627    25  RMSE  F03   0.03000 10,000_cells + HCMEC D3_line         0
      628    25  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      629    25  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      630    25  RMSE  G03   0.05000  5,000_cells + HCMEC D3_line         0
      631    30 Alpha  A01   5.31000 35,000_cells + HCMEC D3_line         0
      632    30 Alpha  A02   5.27000 35,000_cells + HCMEC D3_line         0
      633    30 Alpha  A03   5.33000 35,000_cells + HCMEC D3_line         0
      634    30 Alpha  B01   5.47000 30,000_cells + HCMEC D3_line         0
      635    30 Alpha  B02   5.49000 30,000_cells + HCMEC D3_line         0
      636    30 Alpha  B03   4.95000 30,000_cells + HCMEC D3_line         0
      637    30 Alpha  C01   4.63000 25,000_cells + HCMEC D3_line         0
      638    30 Alpha  C02   4.83000 25,000_cells + HCMEC D3_line         0
      639    30 Alpha  C03   4.56000 25,000_cells + HCMEC D3_line         0
      640    30 Alpha  D01   4.01000 20,000_cells + HCMEC D3_line         0
      641    30 Alpha  D02   4.18000 20,000_cells + HCMEC D3_line         0
      642    30 Alpha  D03   4.01000 20,000_cells + HCMEC D3_line         0
      643    30 Alpha  E01   3.48000 15,000_cells + HCMEC D3_line         0
      644    30 Alpha  E02   3.51000 15,000_cells + HCMEC D3_line         0
      645    30 Alpha  E03   3.54000 15,000_cells + HCMEC D3_line         0
      646    30 Alpha  F01   3.03000 10,000_cells + HCMEC D3_line         0
      647    30 Alpha  F02   2.81000 10,000_cells + HCMEC D3_line         0
      648    30 Alpha  F03   2.94000 10,000_cells + HCMEC D3_line         0
      649    30 Alpha  G01   1.80000  5,000_cells + HCMEC D3_line         0
      650    30 Alpha  G02   1.55000  5,000_cells + HCMEC D3_line         0
      651    30 Alpha  G03   1.74000  5,000_cells + HCMEC D3_line         0
      652    30    Cm  A01   2.63000 35,000_cells + HCMEC D3_line         0
      653    30    Cm  A02   1.76000 35,000_cells + HCMEC D3_line         0
      654    30    Cm  A03   2.13000 35,000_cells + HCMEC D3_line         0
      655    30    Cm  B01   2.02000 30,000_cells + HCMEC D3_line         0
      656    30    Cm  B02   2.14000 30,000_cells + HCMEC D3_line         0
      657    30    Cm  B03   4.13000 30,000_cells + HCMEC D3_line         0
      658    30    Cm  C01   5.59000 25,000_cells + HCMEC D3_line         0
      659    30    Cm  C02   4.61000 25,000_cells + HCMEC D3_line         0
      660    30    Cm  C03   6.46000 25,000_cells + HCMEC D3_line         0
      661    30    Cm  D01  12.05000 20,000_cells + HCMEC D3_line         0
      662    30    Cm  D02  10.86000 20,000_cells + HCMEC D3_line         0
      663    30    Cm  D03  10.01000 20,000_cells + HCMEC D3_line         0
      664    30    Cm  E01  17.12000 15,000_cells + HCMEC D3_line         0
      665    30    Cm  E02  18.26000 15,000_cells + HCMEC D3_line         0
      666    30    Cm  E03  18.31000 15,000_cells + HCMEC D3_line         0
      667    30    Cm  F01  24.85000 10,000_cells + HCMEC D3_line         0
      668    30    Cm  F02  39.77000 10,000_cells + HCMEC D3_line         0
      669    30    Cm  F03  25.26000 10,000_cells + HCMEC D3_line         0
      670    30    Cm  G01 101.76000  5,000_cells + HCMEC D3_line         0
      671    30    Cm  G02 121.73000  5,000_cells + HCMEC D3_line         0
      672    30    Cm  G03  81.58000  5,000_cells + HCMEC D3_line         0
      673    30 Drift  A01  -4.15000 35,000_cells + HCMEC D3_line         0
      674    30 Drift  A02  -4.46000 35,000_cells + HCMEC D3_line         0
      675    30 Drift  A03  -3.84000 35,000_cells + HCMEC D3_line         0
      676    30 Drift  B01  -4.57000 30,000_cells + HCMEC D3_line         0
      677    30 Drift  B02  -4.66000 30,000_cells + HCMEC D3_line         0
      678    30 Drift  B03  -4.11000 30,000_cells + HCMEC D3_line         0
      679    30 Drift  C01  -4.66000 25,000_cells + HCMEC D3_line         0
      680    30 Drift  C02  -4.82000 25,000_cells + HCMEC D3_line         0
      681    30 Drift  C03  -4.16000 25,000_cells + HCMEC D3_line         0
      682    30 Drift  D01  -4.38000 20,000_cells + HCMEC D3_line         0
      683    30 Drift  D02  -4.42000 20,000_cells + HCMEC D3_line         0
      684    30 Drift  D03  -3.52000 20,000_cells + HCMEC D3_line         0
      685    30 Drift  E01  -2.82000 15,000_cells + HCMEC D3_line         0
      686    30 Drift  E02  -2.95000 15,000_cells + HCMEC D3_line         0
      687    30 Drift  E03  -2.82000 15,000_cells + HCMEC D3_line         0
      688    30 Drift  F01  -2.60000 10,000_cells + HCMEC D3_line         0
      689    30 Drift  F02  -2.47000 10,000_cells + HCMEC D3_line         0
      690    30 Drift  F03  -2.06000 10,000_cells + HCMEC D3_line         0
      691    30 Drift  G01  -1.55000  5,000_cells + HCMEC D3_line         0
      692    30 Drift  G02  -1.50000  5,000_cells + HCMEC D3_line         0
      693    30 Drift  G03  -1.14000  5,000_cells + HCMEC D3_line         0
      694    30    Rb  A01   0.20000 35,000_cells + HCMEC D3_line         0
      695    30    Rb  A02   0.84000 35,000_cells + HCMEC D3_line         0
      696    30    Rb  A03   0.21000 35,000_cells + HCMEC D3_line         0
      697    30    Rb  B01   0.01000 30,000_cells + HCMEC D3_line         0
      698    30    Rb  B02   0.09000 30,000_cells + HCMEC D3_line         0
      699    30    Rb  B03   0.00000 30,000_cells + HCMEC D3_line         0
      700    30    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      701    30    Rb  C02   0.00000 25,000_cells + HCMEC D3_line         0
      702    30    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      703    30    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      704    30    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      705    30    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      706    30    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      707    30    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      708    30    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      709    30    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      710    30    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      711    30    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      712    30    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      713    30    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      714    30    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      715    30  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      716    30  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      717    30  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      718    30  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      719    30  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      720    30  RMSE  B03   0.02000 30,000_cells + HCMEC D3_line         0
      721    30  RMSE  C01   0.03000 25,000_cells + HCMEC D3_line         0
      722    30  RMSE  C02   0.03000 25,000_cells + HCMEC D3_line         0
      723    30  RMSE  C03   0.03000 25,000_cells + HCMEC D3_line         0
      724    30  RMSE  D01   0.04000 20,000_cells + HCMEC D3_line         0
      725    30  RMSE  D02   0.03000 20,000_cells + HCMEC D3_line         0
      726    30  RMSE  D03   0.03000 20,000_cells + HCMEC D3_line         0
      727    30  RMSE  E01   0.03000 15,000_cells + HCMEC D3_line         0
      728    30  RMSE  E02   0.03000 15,000_cells + HCMEC D3_line         0
      729    30  RMSE  E03   0.03000 15,000_cells + HCMEC D3_line         0
      730    30  RMSE  F01   0.03000 10,000_cells + HCMEC D3_line         0
      731    30  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      732    30  RMSE  F03   0.03000 10,000_cells + HCMEC D3_line         0
      733    30  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      734    30  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      735    30  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      736    35 Alpha  A01   5.30000 35,000_cells + HCMEC D3_line         0
      737    35 Alpha  A02   5.16000 35,000_cells + HCMEC D3_line         0
      738    35 Alpha  A03   5.24000 35,000_cells + HCMEC D3_line         0
      739    35 Alpha  B01   5.35000 30,000_cells + HCMEC D3_line         0
      740    35 Alpha  B02   5.44000 30,000_cells + HCMEC D3_line         0
      741    35 Alpha  B03   5.18000 30,000_cells + HCMEC D3_line         0
      742    35 Alpha  C01   4.86000 25,000_cells + HCMEC D3_line         0
      743    35 Alpha  C02   5.05000 25,000_cells + HCMEC D3_line         0
      744    35 Alpha  C03   4.71000 25,000_cells + HCMEC D3_line         0
      745    35 Alpha  D01   4.22000 20,000_cells + HCMEC D3_line         0
      746    35 Alpha  D02   4.53000 20,000_cells + HCMEC D3_line         0
      747    35 Alpha  D03   4.28000 20,000_cells + HCMEC D3_line         0
      748    35 Alpha  E01   3.75000 15,000_cells + HCMEC D3_line         0
      749    35 Alpha  E02   3.75000 15,000_cells + HCMEC D3_line         0
      750    35 Alpha  E03   3.89000 15,000_cells + HCMEC D3_line         0
      751    35 Alpha  F01   3.38000 10,000_cells + HCMEC D3_line         0
      752    35 Alpha  F02   3.02000 10,000_cells + HCMEC D3_line         0
      753    35 Alpha  F03   3.15000 10,000_cells + HCMEC D3_line         0
      754    35 Alpha  G01   1.98000  5,000_cells + HCMEC D3_line         0
      755    35 Alpha  G02   1.73000  5,000_cells + HCMEC D3_line         0
      756    35 Alpha  G03   1.86000  5,000_cells + HCMEC D3_line         0
      757    35    Cm  A01   2.27000 35,000_cells + HCMEC D3_line         0
      758    35    Cm  A02   1.54000 35,000_cells + HCMEC D3_line         0
      759    35    Cm  A03   1.91000 35,000_cells + HCMEC D3_line         0
      760    35    Cm  B01   1.98000 30,000_cells + HCMEC D3_line         0
      761    35    Cm  B02   2.01000 30,000_cells + HCMEC D3_line         0
      762    35    Cm  B03   3.18000 30,000_cells + HCMEC D3_line         0
      763    35    Cm  C01   4.47000 25,000_cells + HCMEC D3_line         0
      764    35    Cm  C02   3.50000 25,000_cells + HCMEC D3_line         0
      765    35    Cm  C03   5.38000 25,000_cells + HCMEC D3_line         0
      766    35    Cm  D01   9.87000 20,000_cells + HCMEC D3_line         0
      767    35    Cm  D02   8.24000 20,000_cells + HCMEC D3_line         0
      768    35    Cm  D03   8.45000 20,000_cells + HCMEC D3_line         0
      769    35    Cm  E01  14.34000 15,000_cells + HCMEC D3_line         0
      770    35    Cm  E02  15.16000 15,000_cells + HCMEC D3_line         0
      771    35    Cm  E03  13.81000 15,000_cells + HCMEC D3_line         0
      772    35    Cm  F01  19.32000 10,000_cells + HCMEC D3_line         0
      773    35    Cm  F02  31.25000 10,000_cells + HCMEC D3_line         0
      774    35    Cm  F03  21.94000 10,000_cells + HCMEC D3_line         0
      775    35    Cm  G01  82.19000  5,000_cells + HCMEC D3_line         0
      776    35    Cm  G02  94.75000  5,000_cells + HCMEC D3_line         0
      777    35    Cm  G03  70.09000  5,000_cells + HCMEC D3_line         0
      778    35 Drift  A01  -4.45000 35,000_cells + HCMEC D3_line         0
      779    35 Drift  A02  -4.69000 35,000_cells + HCMEC D3_line         0
      780    35 Drift  A03  -4.11000 35,000_cells + HCMEC D3_line         0
      781    35 Drift  B01  -4.80000 30,000_cells + HCMEC D3_line         0
      782    35 Drift  B02  -4.91000 30,000_cells + HCMEC D3_line         0
      783    35 Drift  B03  -4.40000 30,000_cells + HCMEC D3_line         0
      784    35 Drift  C01  -4.96000 25,000_cells + HCMEC D3_line         0
      785    35 Drift  C02  -5.10000 25,000_cells + HCMEC D3_line         0
      786    35 Drift  C03  -4.46000 25,000_cells + HCMEC D3_line         0
      787    35 Drift  D01  -4.69000 20,000_cells + HCMEC D3_line         0
      788    35 Drift  D02  -4.78000 20,000_cells + HCMEC D3_line         0
      789    35 Drift  D03  -3.90000 20,000_cells + HCMEC D3_line         0
      790    35 Drift  E01  -3.19000 15,000_cells + HCMEC D3_line         0
      791    35 Drift  E02  -3.33000 15,000_cells + HCMEC D3_line         0
      792    35 Drift  E03  -3.19000 15,000_cells + HCMEC D3_line         0
      793    35 Drift  F01  -3.02000 10,000_cells + HCMEC D3_line         0
      794    35 Drift  F02  -2.83000 10,000_cells + HCMEC D3_line         0
      795    35 Drift  F03  -2.36000 10,000_cells + HCMEC D3_line         0
      796    35 Drift  G01  -1.82000  5,000_cells + HCMEC D3_line         0
      797    35 Drift  G02  -1.72000  5,000_cells + HCMEC D3_line         0
      798    35 Drift  G03  -1.39000  5,000_cells + HCMEC D3_line         0
      799    35    Rb  A01   0.56000 35,000_cells + HCMEC D3_line         0
      800    35    Rb  A02   1.20000 35,000_cells + HCMEC D3_line         0
      801    35    Rb  A03   0.56000 35,000_cells + HCMEC D3_line         0
      802    35    Rb  B01   0.46000 30,000_cells + HCMEC D3_line         0
      803    35    Rb  B02   0.37000 30,000_cells + HCMEC D3_line         0
      804    35    Rb  B03   0.00000 30,000_cells + HCMEC D3_line         0
      805    35    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      806    35    Rb  C02   0.00000 25,000_cells + HCMEC D3_line         0
      807    35    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      808    35    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      809    35    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      810    35    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      811    35    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      812    35    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      813    35    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      814    35    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      815    35    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      816    35    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      817    35    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      818    35    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      819    35    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      820    35  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      821    35  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      822    35  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      823    35  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      824    35  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      825    35  RMSE  B03   0.02000 30,000_cells + HCMEC D3_line         0
      826    35  RMSE  C01   0.03000 25,000_cells + HCMEC D3_line         0
      827    35  RMSE  C02   0.02000 25,000_cells + HCMEC D3_line         0
      828    35  RMSE  C03   0.03000 25,000_cells + HCMEC D3_line         0
      829    35  RMSE  D01   0.03000 20,000_cells + HCMEC D3_line         0
      830    35  RMSE  D02   0.03000 20,000_cells + HCMEC D3_line         0
      831    35  RMSE  D03   0.03000 20,000_cells + HCMEC D3_line         0
      832    35  RMSE  E01   0.03000 15,000_cells + HCMEC D3_line         0
      833    35  RMSE  E02   0.03000 15,000_cells + HCMEC D3_line         0
      834    35  RMSE  E03   0.03000 15,000_cells + HCMEC D3_line         0
      835    35  RMSE  F01   0.03000 10,000_cells + HCMEC D3_line         0
      836    35  RMSE  F02   0.03000 10,000_cells + HCMEC D3_line         0
      837    35  RMSE  F03   0.03000 10,000_cells + HCMEC D3_line         0
      838    35  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      839    35  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      840    35  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      841    40 Alpha  A01   5.17000 35,000_cells + HCMEC D3_line         0
      842    40 Alpha  A02   4.89000 35,000_cells + HCMEC D3_line         0
      843    40 Alpha  A03   5.12000 35,000_cells + HCMEC D3_line         0
      844    40 Alpha  B01   5.22000 30,000_cells + HCMEC D3_line         0
      845    40 Alpha  B02   5.36000 30,000_cells + HCMEC D3_line         0
      846    40 Alpha  B03   5.60000 30,000_cells + HCMEC D3_line         0
      847    40 Alpha  C01   5.19000 25,000_cells + HCMEC D3_line         0
      848    40 Alpha  C02   5.32000 25,000_cells + HCMEC D3_line         0
      849    40 Alpha  C03   4.95000 25,000_cells + HCMEC D3_line         0
      850    40 Alpha  D01   4.51000 20,000_cells + HCMEC D3_line         0
      851    40 Alpha  D02   4.78000 20,000_cells + HCMEC D3_line         0
      852    40 Alpha  D03   4.60000 20,000_cells + HCMEC D3_line         0
      853    40 Alpha  E01   4.05000 15,000_cells + HCMEC D3_line         0
      854    40 Alpha  E02   4.01000 15,000_cells + HCMEC D3_line         0
      855    40 Alpha  E03   4.11000 15,000_cells + HCMEC D3_line         0
      856    40 Alpha  F01   3.55000 10,000_cells + HCMEC D3_line         0
      857    40 Alpha  F02   3.27000 10,000_cells + HCMEC D3_line         0
      858    40 Alpha  F03   3.56000 10,000_cells + HCMEC D3_line         0
      859    40 Alpha  G01   2.08000  5,000_cells + HCMEC D3_line         0
      860    40 Alpha  G02   1.86000  5,000_cells + HCMEC D3_line         0
      861    40 Alpha  G03   1.97000  5,000_cells + HCMEC D3_line         0
      862    40    Cm  A01   1.72000 35,000_cells + HCMEC D3_line         0
      863    40    Cm  A02   1.23000 35,000_cells + HCMEC D3_line         0
      864    40    Cm  A03   1.67000 35,000_cells + HCMEC D3_line         0
      865    40    Cm  B01   1.65000 30,000_cells + HCMEC D3_line         0
      866    40    Cm  B02   1.73000 30,000_cells + HCMEC D3_line         0
      867    40    Cm  B03   2.07000 30,000_cells + HCMEC D3_line         0
      868    40    Cm  C01   3.33000 25,000_cells + HCMEC D3_line         0
      869    40    Cm  C02   2.59000 25,000_cells + HCMEC D3_line         0
      870    40    Cm  C03   4.03000 25,000_cells + HCMEC D3_line         0
      871    40    Cm  D01   7.74000 20,000_cells + HCMEC D3_line         0
      872    40    Cm  D02   6.41000 20,000_cells + HCMEC D3_line         0
      873    40    Cm  D03   5.95000 20,000_cells + HCMEC D3_line         0
      874    40    Cm  E01  11.02000 15,000_cells + HCMEC D3_line         0
      875    40    Cm  E02  12.72000 15,000_cells + HCMEC D3_line         0
      876    40    Cm  E03  10.54000 15,000_cells + HCMEC D3_line         0
      877    40    Cm  F01  15.81000 10,000_cells + HCMEC D3_line         0
      878    40    Cm  F02  24.03000 10,000_cells + HCMEC D3_line         0
      879    40    Cm  F03  17.42000 10,000_cells + HCMEC D3_line         0
      880    40    Cm  G01  70.36000  5,000_cells + HCMEC D3_line         0
      881    40    Cm  G02  74.17000  5,000_cells + HCMEC D3_line         0
      882    40    Cm  G03  58.66000  5,000_cells + HCMEC D3_line         0
      883    40 Drift  A01  -4.65000 35,000_cells + HCMEC D3_line         0
      884    40 Drift  A02  -4.85000 35,000_cells + HCMEC D3_line         0
      885    40 Drift  A03  -4.31000 35,000_cells + HCMEC D3_line         0
      886    40 Drift  B01  -4.98000 30,000_cells + HCMEC D3_line         0
      887    40 Drift  B02  -5.14000 30,000_cells + HCMEC D3_line         0
      888    40 Drift  B03  -4.72000 30,000_cells + HCMEC D3_line         0
      889    40 Drift  C01  -5.22000 25,000_cells + HCMEC D3_line         0
      890    40 Drift  C02  -5.35000 25,000_cells + HCMEC D3_line         0
      891    40 Drift  C03  -4.75000 25,000_cells + HCMEC D3_line         0
      892    40 Drift  D01  -5.05000 20,000_cells + HCMEC D3_line         0
      893    40 Drift  D02  -5.13000 20,000_cells + HCMEC D3_line         0
      894    40 Drift  D03  -4.23000 20,000_cells + HCMEC D3_line         0
      895    40 Drift  E01  -3.52000 15,000_cells + HCMEC D3_line         0
      896    40 Drift  E02  -3.69000 15,000_cells + HCMEC D3_line         0
      897    40 Drift  E03  -3.49000 15,000_cells + HCMEC D3_line         0
      898    40 Drift  F01  -3.34000 10,000_cells + HCMEC D3_line         0
      899    40 Drift  F02  -3.09000 10,000_cells + HCMEC D3_line         0
      900    40 Drift  F03  -2.77000 10,000_cells + HCMEC D3_line         0
      901    40 Drift  G01  -2.06000  5,000_cells + HCMEC D3_line         0
      902    40 Drift  G02  -1.94000  5,000_cells + HCMEC D3_line         0
      903    40 Drift  G03  -1.62000  5,000_cells + HCMEC D3_line         0
      904    40    Rb  A01   1.09000 35,000_cells + HCMEC D3_line         0
      905    40    Rb  A02   1.86000 35,000_cells + HCMEC D3_line         0
      906    40    Rb  A03   0.98000 35,000_cells + HCMEC D3_line         0
      907    40    Rb  B01   1.00000 30,000_cells + HCMEC D3_line         0
      908    40    Rb  B02   0.84000 30,000_cells + HCMEC D3_line         0
      909    40    Rb  B03   0.03000 30,000_cells + HCMEC D3_line         0
      910    40    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      911    40    Rb  C02   0.00000 25,000_cells + HCMEC D3_line         0
      912    40    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      913    40    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      914    40    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      915    40    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      916    40    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      917    40    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      918    40    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      919    40    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      920    40    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      921    40    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      922    40    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      923    40    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      924    40    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      925    40  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      926    40  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      927    40  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      928    40  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      929    40  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      930    40  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      931    40  RMSE  C01   0.02000 25,000_cells + HCMEC D3_line         0
      932    40  RMSE  C02   0.02000 25,000_cells + HCMEC D3_line         0
      933    40  RMSE  C03   0.02000 25,000_cells + HCMEC D3_line         0
      934    40  RMSE  D01   0.03000 20,000_cells + HCMEC D3_line         0
      935    40  RMSE  D02   0.03000 20,000_cells + HCMEC D3_line         0
      936    40  RMSE  D03   0.03000 20,000_cells + HCMEC D3_line         0
      937    40  RMSE  E01   0.04000 15,000_cells + HCMEC D3_line         0
      938    40  RMSE  E02   0.03000 15,000_cells + HCMEC D3_line         0
      939    40  RMSE  E03   0.03000 15,000_cells + HCMEC D3_line         0
      940    40  RMSE  F01   0.03000 10,000_cells + HCMEC D3_line         0
      941    40  RMSE  F02   0.03000 10,000_cells + HCMEC D3_line         0
      942    40  RMSE  F03   0.04000 10,000_cells + HCMEC D3_line         0
      943    40  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      944    40  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      945    40  RMSE  G03   0.02000  5,000_cells + HCMEC D3_line         0
      946    45 Alpha  A01   4.92000 35,000_cells + HCMEC D3_line         0
      947    45 Alpha  A02   4.63000 35,000_cells + HCMEC D3_line         0
      948    45 Alpha  A03   4.88000 35,000_cells + HCMEC D3_line         0
      949    45 Alpha  B01   5.06000 30,000_cells + HCMEC D3_line         0
      950    45 Alpha  B02   5.20000 30,000_cells + HCMEC D3_line         0
      951    45 Alpha  B03   5.48000 30,000_cells + HCMEC D3_line         0
      952    45 Alpha  C01   5.65000 25,000_cells + HCMEC D3_line         0
      953    45 Alpha  C02   5.63000 25,000_cells + HCMEC D3_line         0
      954    45 Alpha  C03   5.36000 25,000_cells + HCMEC D3_line         0
      955    45 Alpha  D01   4.80000 20,000_cells + HCMEC D3_line         0
      956    45 Alpha  D02   5.03000 20,000_cells + HCMEC D3_line         0
      957    45 Alpha  D03   4.90000 20,000_cells + HCMEC D3_line         0
      958    45 Alpha  E01   4.29000 15,000_cells + HCMEC D3_line         0
      959    45 Alpha  E02   4.31000 15,000_cells + HCMEC D3_line         0
      960    45 Alpha  E03   4.26000 15,000_cells + HCMEC D3_line         0
      961    45 Alpha  F01   3.84000 10,000_cells + HCMEC D3_line         0
      962    45 Alpha  F02   3.49000 10,000_cells + HCMEC D3_line         0
      963    45 Alpha  F03   3.76000 10,000_cells + HCMEC D3_line         0
      964    45 Alpha  G01   2.17000  5,000_cells + HCMEC D3_line         0
      965    45 Alpha  G02   2.01000  5,000_cells + HCMEC D3_line         0
      966    45 Alpha  G03   2.17000  5,000_cells + HCMEC D3_line         0
      967    45    Cm  A01   1.35000 35,000_cells + HCMEC D3_line         0
      968    45    Cm  A02   1.10000 35,000_cells + HCMEC D3_line         0
      969    45    Cm  A03   1.31000 35,000_cells + HCMEC D3_line         0
      970    45    Cm  B01   1.38000 30,000_cells + HCMEC D3_line         0
      971    45    Cm  B02   1.38000 30,000_cells + HCMEC D3_line         0
      972    45    Cm  B03   1.78000 30,000_cells + HCMEC D3_line         0
      973    45    Cm  C01   2.00000 25,000_cells + HCMEC D3_line         0
      974    45    Cm  C02   1.79000 25,000_cells + HCMEC D3_line         0
      975    45    Cm  C03   2.69000 25,000_cells + HCMEC D3_line         0
      976    45    Cm  D01   5.61000 20,000_cells + HCMEC D3_line         0
      977    45    Cm  D02   5.09000 20,000_cells + HCMEC D3_line         0
      978    45    Cm  D03   4.61000 20,000_cells + HCMEC D3_line         0
      979    45    Cm  E01   8.89000 15,000_cells + HCMEC D3_line         0
      980    45    Cm  E02   9.13000 15,000_cells + HCMEC D3_line         0
      981    45    Cm  E03   8.91000 15,000_cells + HCMEC D3_line         0
      982    45    Cm  F01  12.88000 10,000_cells + HCMEC D3_line         0
      983    45    Cm  F02  19.72000 10,000_cells + HCMEC D3_line         0
      984    45    Cm  F03  13.88000 10,000_cells + HCMEC D3_line         0
      985    45    Cm  G01  58.18000  5,000_cells + HCMEC D3_line         0
      986    45    Cm  G02  62.49000  5,000_cells + HCMEC D3_line         0
      987    45    Cm  G03  44.63000  5,000_cells + HCMEC D3_line         0
      988    45 Drift  A01  -4.80000 35,000_cells + HCMEC D3_line         0
      989    45 Drift  A02  -4.98000 35,000_cells + HCMEC D3_line         0
      990    45 Drift  A03  -4.47000 35,000_cells + HCMEC D3_line         0
      991    45 Drift  B01  -5.16000 30,000_cells + HCMEC D3_line         0
      992    45 Drift  B02  -5.32000 30,000_cells + HCMEC D3_line         0
      993    45 Drift  B03  -4.88000 30,000_cells + HCMEC D3_line         0
      994    45 Drift  C01  -5.49000 25,000_cells + HCMEC D3_line         0
      995    45 Drift  C02  -5.55000 25,000_cells + HCMEC D3_line         0
      996    45 Drift  C03  -5.01000 25,000_cells + HCMEC D3_line         0
      997    45 Drift  D01  -5.33000 20,000_cells + HCMEC D3_line         0
      998    45 Drift  D02  -5.36000 20,000_cells + HCMEC D3_line         0
      999    45 Drift  D03  -4.50000 20,000_cells + HCMEC D3_line         0
      1000   45 Drift  E01  -3.88000 15,000_cells + HCMEC D3_line         0
      1001   45 Drift  E02  -3.99000 15,000_cells + HCMEC D3_line         0
      1002   45 Drift  E03  -3.76000 15,000_cells + HCMEC D3_line         0
      1003   45 Drift  F01  -3.64000 10,000_cells + HCMEC D3_line         0
      1004   45 Drift  F02  -3.46000 10,000_cells + HCMEC D3_line         0
      1005   45 Drift  F03  -3.13000 10,000_cells + HCMEC D3_line         0
      1006   45 Drift  G01  -2.26000  5,000_cells + HCMEC D3_line         0
      1007   45 Drift  G02  -2.18000  5,000_cells + HCMEC D3_line         0
      1008   45 Drift  G03  -1.89000  5,000_cells + HCMEC D3_line         0
      1009   45    Rb  A01   1.70000 35,000_cells + HCMEC D3_line         0
      1010   45    Rb  A02   2.37000 35,000_cells + HCMEC D3_line         0
      1011   45    Rb  A03   1.61000 35,000_cells + HCMEC D3_line         0
      1012   45    Rb  B01   1.49000 30,000_cells + HCMEC D3_line         0
      1013   45    Rb  B02   1.45000 30,000_cells + HCMEC D3_line         0
      1014   45    Rb  B03   0.56000 30,000_cells + HCMEC D3_line         0
      1015   45    Rb  C01   0.00000 25,000_cells + HCMEC D3_line         0
      1016   45    Rb  C02   0.19000 25,000_cells + HCMEC D3_line         0
      1017   45    Rb  C03   0.00000 25,000_cells + HCMEC D3_line         0
      1018   45    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      1019   45    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      1020   45    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      1021   45    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      1022   45    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      1023   45    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      1024   45    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      1025   45    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1026   45    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      1027   45    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1028   45    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1029   45    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1030   45  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1031   45  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1032   45  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1033   45  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1034   45  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1035   45  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1036   45  RMSE  C01   0.02000 25,000_cells + HCMEC D3_line         0
      1037   45  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1038   45  RMSE  C03   0.02000 25,000_cells + HCMEC D3_line         0
      1039   45  RMSE  D01   0.03000 20,000_cells + HCMEC D3_line         0
      1040   45  RMSE  D02   0.02000 20,000_cells + HCMEC D3_line         0
      1041   45  RMSE  D03   0.02000 20,000_cells + HCMEC D3_line         0
      1042   45  RMSE  E01   0.04000 15,000_cells + HCMEC D3_line         0
      1043   45  RMSE  E02   0.03000 15,000_cells + HCMEC D3_line         0
      1044   45  RMSE  E03   0.03000 15,000_cells + HCMEC D3_line         0
      1045   45  RMSE  F01   0.03000 10,000_cells + HCMEC D3_line         0
      1046   45  RMSE  F02   0.03000 10,000_cells + HCMEC D3_line         0
      1047   45  RMSE  F03   0.04000 10,000_cells + HCMEC D3_line         0
      1048   45  RMSE  G01   0.02000  5,000_cells + HCMEC D3_line         0
      1049   45  RMSE  G02   0.02000  5,000_cells + HCMEC D3_line         0
      1050   45  RMSE  G03   0.02000  5,000_cells + HCMEC D3_line         0
      1051   50 Alpha  A01   4.65000 35,000_cells + HCMEC D3_line         0
      1052   50 Alpha  A02   4.41000 35,000_cells + HCMEC D3_line         0
      1053   50 Alpha  A03   4.65000 35,000_cells + HCMEC D3_line         0
      1054   50 Alpha  B01   4.83000 30,000_cells + HCMEC D3_line         0
      1055   50 Alpha  B02   4.95000 30,000_cells + HCMEC D3_line         0
      1056   50 Alpha  B03   5.34000 30,000_cells + HCMEC D3_line         0
      1057   50 Alpha  C01   5.61000 25,000_cells + HCMEC D3_line         0
      1058   50 Alpha  C02   5.55000 25,000_cells + HCMEC D3_line         0
      1059   50 Alpha  C03   5.55000 25,000_cells + HCMEC D3_line         0
      1060   50 Alpha  D01   5.05000 20,000_cells + HCMEC D3_line         0
      1061   50 Alpha  D02   5.33000 20,000_cells + HCMEC D3_line         0
      1062   50 Alpha  D03   5.19000 20,000_cells + HCMEC D3_line         0
      1063   50 Alpha  E01   4.59000 15,000_cells + HCMEC D3_line         0
      1064   50 Alpha  E02   4.52000 15,000_cells + HCMEC D3_line         0
      1065   50 Alpha  E03   4.58000 15,000_cells + HCMEC D3_line         0
      1066   50 Alpha  F01   4.06000 10,000_cells + HCMEC D3_line         0
      1067   50 Alpha  F02   3.76000 10,000_cells + HCMEC D3_line         0
      1068   50 Alpha  F03   4.04000 10,000_cells + HCMEC D3_line         0
      1069   50 Alpha  G01   2.34000  5,000_cells + HCMEC D3_line         0
      1070   50 Alpha  G02   2.20000  5,000_cells + HCMEC D3_line         0
      1071   50 Alpha  G03   2.29000  5,000_cells + HCMEC D3_line         0
      1072   50    Cm  A01   1.18000 35,000_cells + HCMEC D3_line         0
      1073   50    Cm  A02   1.08000 35,000_cells + HCMEC D3_line         0
      1074   50    Cm  A03   1.17000 35,000_cells + HCMEC D3_line         0
      1075   50    Cm  B01   1.15000 30,000_cells + HCMEC D3_line         0
      1076   50    Cm  B02   1.20000 30,000_cells + HCMEC D3_line         0
      1077   50    Cm  B03   1.54000 30,000_cells + HCMEC D3_line         0
      1078   50    Cm  C01   1.84000 25,000_cells + HCMEC D3_line         0
      1079   50    Cm  C02   1.66000 25,000_cells + HCMEC D3_line         0
      1080   50    Cm  C03   1.98000 25,000_cells + HCMEC D3_line         0
      1081   50    Cm  D01   4.10000 20,000_cells + HCMEC D3_line         0
      1082   50    Cm  D02   3.24000 20,000_cells + HCMEC D3_line         0
      1083   50    Cm  D03   3.24000 20,000_cells + HCMEC D3_line         0
      1084   50    Cm  E01   6.68000 15,000_cells + HCMEC D3_line         0
      1085   50    Cm  E02   7.08000 15,000_cells + HCMEC D3_line         0
      1086   50    Cm  E03   6.77000 15,000_cells + HCMEC D3_line         0
      1087   50    Cm  F01  10.46000 10,000_cells + HCMEC D3_line         0
      1088   50    Cm  F02  16.51000 10,000_cells + HCMEC D3_line         0
      1089   50    Cm  F03  10.58000 10,000_cells + HCMEC D3_line         0
      1090   50    Cm  G01  48.45000  5,000_cells + HCMEC D3_line         0
      1091   50    Cm  G02  50.64000  5,000_cells + HCMEC D3_line         0
      1092   50    Cm  G03  38.45000  5,000_cells + HCMEC D3_line         0
      1093   50 Drift  A01  -4.90000 35,000_cells + HCMEC D3_line         0
      1094   50 Drift  A02  -5.08000 35,000_cells + HCMEC D3_line         0
      1095   50 Drift  A03  -4.61000 35,000_cells + HCMEC D3_line         0
      1096   50 Drift  B01  -5.31000 30,000_cells + HCMEC D3_line         0
      1097   50 Drift  B02  -5.45000 30,000_cells + HCMEC D3_line         0
      1098   50 Drift  B03  -5.05000 30,000_cells + HCMEC D3_line         0
      1099   50 Drift  C01  -5.66000 25,000_cells + HCMEC D3_line         0
      1100   50 Drift  C02  -5.75000 25,000_cells + HCMEC D3_line         0
      1101   50 Drift  C03  -5.22000 25,000_cells + HCMEC D3_line         0
      1102   50 Drift  D01  -5.52000 20,000_cells + HCMEC D3_line         0
      1103   50 Drift  D02  -5.62000 20,000_cells + HCMEC D3_line         0
      1104   50 Drift  D03  -4.77000 20,000_cells + HCMEC D3_line         0
      1105   50 Drift  E01  -4.14000 15,000_cells + HCMEC D3_line         0
      1106   50 Drift  E02  -4.26000 15,000_cells + HCMEC D3_line         0
      1107   50 Drift  E03  -4.04000 15,000_cells + HCMEC D3_line         0
      1108   50 Drift  F01  -3.95000 10,000_cells + HCMEC D3_line         0
      1109   50 Drift  F02  -3.86000 10,000_cells + HCMEC D3_line         0
      1110   50 Drift  F03  -3.38000 10,000_cells + HCMEC D3_line         0
      1111   50 Drift  G01  -2.53000  5,000_cells + HCMEC D3_line         0
      1112   50 Drift  G02  -2.43000  5,000_cells + HCMEC D3_line         0
      1113   50 Drift  G03  -2.11000  5,000_cells + HCMEC D3_line         0
      1114   50    Rb  A01   2.16000 35,000_cells + HCMEC D3_line         0
      1115   50    Rb  A02   2.65000 35,000_cells + HCMEC D3_line         0
      1116   50    Rb  A03   2.06000 35,000_cells + HCMEC D3_line         0
      1117   50    Rb  B01   2.13000 30,000_cells + HCMEC D3_line         0
      1118   50    Rb  B02   1.99000 30,000_cells + HCMEC D3_line         0
      1119   50    Rb  B03   0.99000 30,000_cells + HCMEC D3_line         0
      1120   50    Rb  C01   0.54000 25,000_cells + HCMEC D3_line         0
      1121   50    Rb  C02   0.68000 25,000_cells + HCMEC D3_line         0
      1122   50    Rb  C03   0.17000 25,000_cells + HCMEC D3_line         0
      1123   50    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      1124   50    Rb  D02   0.00000 20,000_cells + HCMEC D3_line         0
      1125   50    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      1126   50    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      1127   50    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      1128   50    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      1129   50    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      1130   50    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1131   50    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      1132   50    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1133   50    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1134   50    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1135   50  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1136   50  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1137   50  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1138   50  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1139   50  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1140   50  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1141   50  RMSE  C01   0.02000 25,000_cells + HCMEC D3_line         0
      1142   50  RMSE  C02   0.02000 25,000_cells + HCMEC D3_line         0
      1143   50  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1144   50  RMSE  D01   0.03000 20,000_cells + HCMEC D3_line         0
      1145   50  RMSE  D02   0.02000 20,000_cells + HCMEC D3_line         0
      1146   50  RMSE  D03   0.02000 20,000_cells + HCMEC D3_line         0
      1147   50  RMSE  E01   0.03000 15,000_cells + HCMEC D3_line         0
      1148   50  RMSE  E02   0.03000 15,000_cells + HCMEC D3_line         0
      1149   50  RMSE  E03   0.03000 15,000_cells + HCMEC D3_line         0
      1150   50  RMSE  F01   0.04000 10,000_cells + HCMEC D3_line         0
      1151   50  RMSE  F02   0.04000 10,000_cells + HCMEC D3_line         0
      1152   50  RMSE  F03   0.04000 10,000_cells + HCMEC D3_line         0
      1153   50  RMSE  G01   0.02000  5,000_cells + HCMEC D3_line         0
      1154   50  RMSE  G02   0.02000  5,000_cells + HCMEC D3_line         0
      1155   50  RMSE  G03   0.02000  5,000_cells + HCMEC D3_line         0
      1156   55 Alpha  A01   4.34000 35,000_cells + HCMEC D3_line         0
      1157   55 Alpha  A02   4.26000 35,000_cells + HCMEC D3_line         0
      1158   55 Alpha  A03   4.39000 35,000_cells + HCMEC D3_line         0
      1159   55 Alpha  B01   4.53000 30,000_cells + HCMEC D3_line         0
      1160   55 Alpha  B02   4.62000 30,000_cells + HCMEC D3_line         0
      1161   55 Alpha  B03   5.05000 30,000_cells + HCMEC D3_line         0
      1162   55 Alpha  C01   5.38000 25,000_cells + HCMEC D3_line         0
      1163   55 Alpha  C02   5.18000 25,000_cells + HCMEC D3_line         0
      1164   55 Alpha  C03   5.41000 25,000_cells + HCMEC D3_line         0
      1165   55 Alpha  D01   5.52000 20,000_cells + HCMEC D3_line         0
      1166   55 Alpha  D02   5.67000 20,000_cells + HCMEC D3_line         0
      1167   55 Alpha  D03   5.49000 20,000_cells + HCMEC D3_line         0
      1168   55 Alpha  E01   4.84000 15,000_cells + HCMEC D3_line         0
      1169   55 Alpha  E02   4.71000 15,000_cells + HCMEC D3_line         0
      1170   55 Alpha  E03   4.85000 15,000_cells + HCMEC D3_line         0
      1171   55 Alpha  F01   4.27000 10,000_cells + HCMEC D3_line         0
      1172   55 Alpha  F02   3.94000 10,000_cells + HCMEC D3_line         0
      1173   55 Alpha  F03   4.21000 10,000_cells + HCMEC D3_line         0
      1174   55 Alpha  G01   2.57000  5,000_cells + HCMEC D3_line         0
      1175   55 Alpha  G02   2.40000  5,000_cells + HCMEC D3_line         0
      1176   55 Alpha  G03   2.54000  5,000_cells + HCMEC D3_line         0
      1177   55    Cm  A01   1.12000 35,000_cells + HCMEC D3_line         0
      1178   55    Cm  A02   1.07000 35,000_cells + HCMEC D3_line         0
      1179   55    Cm  A03   1.08000 35,000_cells + HCMEC D3_line         0
      1180   55    Cm  B01   1.06000 30,000_cells + HCMEC D3_line         0
      1181   55    Cm  B02   1.06000 30,000_cells + HCMEC D3_line         0
      1182   55    Cm  B03   1.27000 30,000_cells + HCMEC D3_line         0
      1183   55    Cm  C01   1.56000 25,000_cells + HCMEC D3_line         0
      1184   55    Cm  C02   1.37000 25,000_cells + HCMEC D3_line         0
      1185   55    Cm  C03   1.78000 25,000_cells + HCMEC D3_line         0
      1186   55    Cm  D01   2.35000 20,000_cells + HCMEC D3_line         0
      1187   55    Cm  D02   2.17000 20,000_cells + HCMEC D3_line         0
      1188   55    Cm  D03   2.16000 20,000_cells + HCMEC D3_line         0
      1189   55    Cm  E01   4.88000 15,000_cells + HCMEC D3_line         0
      1190   55    Cm  E02   5.67000 15,000_cells + HCMEC D3_line         0
      1191   55    Cm  E03   5.52000 15,000_cells + HCMEC D3_line         0
      1192   55    Cm  F01   7.91000 10,000_cells + HCMEC D3_line         0
      1193   55    Cm  F02  12.39000 10,000_cells + HCMEC D3_line         0
      1194   55    Cm  F03   9.01000 10,000_cells + HCMEC D3_line         0
      1195   55    Cm  G01  38.63000  5,000_cells + HCMEC D3_line         0
      1196   55    Cm  G02  43.79000  5,000_cells + HCMEC D3_line         0
      1197   55    Cm  G03  31.57000  5,000_cells + HCMEC D3_line         0
      1198   55 Drift  A01  -5.00000 35,000_cells + HCMEC D3_line         0
      1199   55 Drift  A02  -5.20000 35,000_cells + HCMEC D3_line         0
      1200   55 Drift  A03  -4.72000 35,000_cells + HCMEC D3_line         0
      1201   55 Drift  B01  -5.36000 30,000_cells + HCMEC D3_line         0
      1202   55 Drift  B02  -5.60000 30,000_cells + HCMEC D3_line         0
      1203   55 Drift  B03  -5.19000 30,000_cells + HCMEC D3_line         0
      1204   55 Drift  C01  -5.84000 25,000_cells + HCMEC D3_line         0
      1205   55 Drift  C02  -5.91000 25,000_cells + HCMEC D3_line         0
      1206   55 Drift  C03  -5.42000 25,000_cells + HCMEC D3_line         0
      1207   55 Drift  D01  -5.73000 20,000_cells + HCMEC D3_line         0
      1208   55 Drift  D02  -5.85000 20,000_cells + HCMEC D3_line         0
      1209   55 Drift  D03  -4.99000 20,000_cells + HCMEC D3_line         0
      1210   55 Drift  E01  -4.37000 15,000_cells + HCMEC D3_line         0
      1211   55 Drift  E02  -4.47000 15,000_cells + HCMEC D3_line         0
      1212   55 Drift  E03  -4.33000 15,000_cells + HCMEC D3_line         0
      1213   55 Drift  F01  -4.14000 10,000_cells + HCMEC D3_line         0
      1214   55 Drift  F02  -4.06000 10,000_cells + HCMEC D3_line         0
      1215   55 Drift  F03  -3.63000 10,000_cells + HCMEC D3_line         0
      1216   55 Drift  G01  -2.74000  5,000_cells + HCMEC D3_line         0
      1217   55 Drift  G02  -2.67000  5,000_cells + HCMEC D3_line         0
      1218   55 Drift  G03  -2.38000  5,000_cells + HCMEC D3_line         0
      1219   55    Rb  A01   2.49000 35,000_cells + HCMEC D3_line         0
      1220   55    Rb  A02   2.75000 35,000_cells + HCMEC D3_line         0
      1221   55    Rb  A03   2.41000 35,000_cells + HCMEC D3_line         0
      1222   55    Rb  B01   2.57000 30,000_cells + HCMEC D3_line         0
      1223   55    Rb  B02   2.61000 30,000_cells + HCMEC D3_line         0
      1224   55    Rb  B03   1.72000 30,000_cells + HCMEC D3_line         0
      1225   55    Rb  C01   1.20000 25,000_cells + HCMEC D3_line         0
      1226   55    Rb  C02   1.45000 25,000_cells + HCMEC D3_line         0
      1227   55    Rb  C03   0.70000 25,000_cells + HCMEC D3_line         0
      1228   55    Rb  D01   0.00000 20,000_cells + HCMEC D3_line         0
      1229   55    Rb  D02   0.12000 20,000_cells + HCMEC D3_line         0
      1230   55    Rb  D03   0.00000 20,000_cells + HCMEC D3_line         0
      1231   55    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      1232   55    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      1233   55    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      1234   55    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      1235   55    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1236   55    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      1237   55    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1238   55    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1239   55    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1240   55  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1241   55  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1242   55  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1243   55  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1244   55  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1245   55  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1246   55  RMSE  C01   0.02000 25,000_cells + HCMEC D3_line         0
      1247   55  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1248   55  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1249   55  RMSE  D01   0.02000 20,000_cells + HCMEC D3_line         0
      1250   55  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      1251   55  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      1252   55  RMSE  E01   0.03000 15,000_cells + HCMEC D3_line         0
      1253   55  RMSE  E02   0.03000 15,000_cells + HCMEC D3_line         0
      1254   55  RMSE  E03   0.03000 15,000_cells + HCMEC D3_line         0
      1255   55  RMSE  F01   0.04000 10,000_cells + HCMEC D3_line         0
      1256   55  RMSE  F02   0.04000 10,000_cells + HCMEC D3_line         0
      1257   55  RMSE  F03   0.04000 10,000_cells + HCMEC D3_line         0
      1258   55  RMSE  G01   0.02000  5,000_cells + HCMEC D3_line         0
      1259   55  RMSE  G02   0.02000  5,000_cells + HCMEC D3_line         0
      1260   55  RMSE  G03   0.03000  5,000_cells + HCMEC D3_line         0
      1261   60 Alpha  A01   4.18000 35,000_cells + HCMEC D3_line         0
      1262   60 Alpha  A02   4.15000 35,000_cells + HCMEC D3_line         0
      1263   60 Alpha  A03   4.19000 35,000_cells + HCMEC D3_line         0
      1264   60 Alpha  B01   4.37000 30,000_cells + HCMEC D3_line         0
      1265   60 Alpha  B02   4.49000 30,000_cells + HCMEC D3_line         0
      1266   60 Alpha  B03   4.78000 30,000_cells + HCMEC D3_line         0
      1267   60 Alpha  C01   5.06000 25,000_cells + HCMEC D3_line         0
      1268   60 Alpha  C02   4.99000 25,000_cells + HCMEC D3_line         0
      1269   60 Alpha  C03   5.10000 25,000_cells + HCMEC D3_line         0
      1270   60 Alpha  D01   5.63000 20,000_cells + HCMEC D3_line         0
      1271   60 Alpha  D02   5.55000 20,000_cells + HCMEC D3_line         0
      1272   60 Alpha  D03   5.46000 20,000_cells + HCMEC D3_line         0
      1273   60 Alpha  E01   5.19000 15,000_cells + HCMEC D3_line         0
      1274   60 Alpha  E02   4.95000 15,000_cells + HCMEC D3_line         0
      1275   60 Alpha  E03   5.07000 15,000_cells + HCMEC D3_line         0
      1276   60 Alpha  F01   4.55000 10,000_cells + HCMEC D3_line         0
      1277   60 Alpha  F02   4.16000 10,000_cells + HCMEC D3_line         0
      1278   60 Alpha  F03   4.51000 10,000_cells + HCMEC D3_line         0
      1279   60 Alpha  G01   2.80000  5,000_cells + HCMEC D3_line         0
      1280   60 Alpha  G02   2.70000  5,000_cells + HCMEC D3_line         0
      1281   60 Alpha  G03   2.76000  5,000_cells + HCMEC D3_line         0
      1282   60    Cm  A01   1.11000 35,000_cells + HCMEC D3_line         0
      1283   60    Cm  A02   1.09000 35,000_cells + HCMEC D3_line         0
      1284   60    Cm  A03   1.08000 35,000_cells + HCMEC D3_line         0
      1285   60    Cm  B01   1.07000 30,000_cells + HCMEC D3_line         0
      1286   60    Cm  B02   1.05000 30,000_cells + HCMEC D3_line         0
      1287   60    Cm  B03   1.14000 30,000_cells + HCMEC D3_line         0
      1288   60    Cm  C01   1.28000 25,000_cells + HCMEC D3_line         0
      1289   60    Cm  C02   1.20000 25,000_cells + HCMEC D3_line         0
      1290   60    Cm  C03   1.44000 25,000_cells + HCMEC D3_line         0
      1291   60    Cm  D01   1.78000 20,000_cells + HCMEC D3_line         0
      1292   60    Cm  D02   1.81000 20,000_cells + HCMEC D3_line         0
      1293   60    Cm  D03   1.83000 20,000_cells + HCMEC D3_line         0
      1294   60    Cm  E01   3.37000 15,000_cells + HCMEC D3_line         0
      1295   60    Cm  E02   4.00000 15,000_cells + HCMEC D3_line         0
      1296   60    Cm  E03   4.34000 15,000_cells + HCMEC D3_line         0
      1297   60    Cm  F01   6.24000 10,000_cells + HCMEC D3_line         0
      1298   60    Cm  F02   9.92000 10,000_cells + HCMEC D3_line         0
      1299   60    Cm  F03   6.96000 10,000_cells + HCMEC D3_line         0
      1300   60    Cm  G01  32.24000  5,000_cells + HCMEC D3_line         0
      1301   60    Cm  G02  36.54000  5,000_cells + HCMEC D3_line         0
      1302   60    Cm  G03  28.65000  5,000_cells + HCMEC D3_line         0
      1303   60 Drift  A01  -5.06000 35,000_cells + HCMEC D3_line         0
      1304   60 Drift  A02  -5.28000 35,000_cells + HCMEC D3_line         0
      1305   60 Drift  A03  -4.79000 35,000_cells + HCMEC D3_line         0
      1306   60 Drift  B01  -5.45000 30,000_cells + HCMEC D3_line         0
      1307   60 Drift  B02  -5.70000 30,000_cells + HCMEC D3_line         0
      1308   60 Drift  B03  -5.28000 30,000_cells + HCMEC D3_line         0
      1309   60 Drift  C01  -5.87000 25,000_cells + HCMEC D3_line         0
      1310   60 Drift  C02  -6.01000 25,000_cells + HCMEC D3_line         0
      1311   60 Drift  C03  -5.51000 25,000_cells + HCMEC D3_line         0
      1312   60 Drift  D01  -5.77000 20,000_cells + HCMEC D3_line         0
      1313   60 Drift  D02  -6.07000 20,000_cells + HCMEC D3_line         0
      1314   60 Drift  D03  -5.15000 20,000_cells + HCMEC D3_line         0
      1315   60 Drift  E01  -4.55000 15,000_cells + HCMEC D3_line         0
      1316   60 Drift  E02  -4.65000 15,000_cells + HCMEC D3_line         0
      1317   60 Drift  E03  -4.49000 15,000_cells + HCMEC D3_line         0
      1318   60 Drift  F01  -4.36000 10,000_cells + HCMEC D3_line         0
      1319   60 Drift  F02  -4.19000 10,000_cells + HCMEC D3_line         0
      1320   60 Drift  F03  -3.86000 10,000_cells + HCMEC D3_line         0
      1321   60 Drift  G01  -2.99000  5,000_cells + HCMEC D3_line         0
      1322   60 Drift  G02  -2.96000  5,000_cells + HCMEC D3_line         0
      1323   60 Drift  G03  -2.62000  5,000_cells + HCMEC D3_line         0
      1324   60    Rb  A01   2.61000 35,000_cells + HCMEC D3_line         0
      1325   60    Rb  A02   2.82000 35,000_cells + HCMEC D3_line         0
      1326   60    Rb  A03   2.55000 35,000_cells + HCMEC D3_line         0
      1327   60    Rb  B01   2.75000 30,000_cells + HCMEC D3_line         0
      1328   60    Rb  B02   2.78000 30,000_cells + HCMEC D3_line         0
      1329   60    Rb  B03   2.20000 30,000_cells + HCMEC D3_line         0
      1330   60    Rb  C01   1.91000 25,000_cells + HCMEC D3_line         0
      1331   60    Rb  C02   1.99000 25,000_cells + HCMEC D3_line         0
      1332   60    Rb  C03   1.38000 25,000_cells + HCMEC D3_line         0
      1333   60    Rb  D01   0.41000 20,000_cells + HCMEC D3_line         0
      1334   60    Rb  D02   0.69000 20,000_cells + HCMEC D3_line         0
      1335   60    Rb  D03   0.44000 20,000_cells + HCMEC D3_line         0
      1336   60    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      1337   60    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      1338   60    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      1339   60    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      1340   60    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1341   60    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      1342   60    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1343   60    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1344   60    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1345   60  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1346   60  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1347   60  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1348   60  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1349   60  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1350   60  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1351   60  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      1352   60  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1353   60  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1354   60  RMSE  D01   0.02000 20,000_cells + HCMEC D3_line         0
      1355   60  RMSE  D02   0.02000 20,000_cells + HCMEC D3_line         0
      1356   60  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      1357   60  RMSE  E01   0.03000 15,000_cells + HCMEC D3_line         0
      1358   60  RMSE  E02   0.03000 15,000_cells + HCMEC D3_line         0
      1359   60  RMSE  E03   0.03000 15,000_cells + HCMEC D3_line         0
      1360   60  RMSE  F01   0.04000 10,000_cells + HCMEC D3_line         0
      1361   60  RMSE  F02   0.05000 10,000_cells + HCMEC D3_line         0
      1362   60  RMSE  F03   0.04000 10,000_cells + HCMEC D3_line         0
      1363   60  RMSE  G01   0.03000  5,000_cells + HCMEC D3_line         0
      1364   60  RMSE  G02   0.02000  5,000_cells + HCMEC D3_line         0
      1365   60  RMSE  G03   0.03000  5,000_cells + HCMEC D3_line         0
      1366   65 Alpha  A01   4.01000 35,000_cells + HCMEC D3_line         0
      1367   65 Alpha  A02   4.05000 35,000_cells + HCMEC D3_line         0
      1368   65 Alpha  A03   4.02000 35,000_cells + HCMEC D3_line         0
      1369   65 Alpha  B01   4.28000 30,000_cells + HCMEC D3_line         0
      1370   65 Alpha  B02   4.36000 30,000_cells + HCMEC D3_line         0
      1371   65 Alpha  B03   4.53000 30,000_cells + HCMEC D3_line         0
      1372   65 Alpha  C01   4.73000 25,000_cells + HCMEC D3_line         0
      1373   65 Alpha  C02   4.69000 25,000_cells + HCMEC D3_line         0
      1374   65 Alpha  C03   4.80000 25,000_cells + HCMEC D3_line         0
      1375   65 Alpha  D01   5.42000 20,000_cells + HCMEC D3_line         0
      1376   65 Alpha  D02   5.32000 20,000_cells + HCMEC D3_line         0
      1377   65 Alpha  D03   5.30000 20,000_cells + HCMEC D3_line         0
      1378   65 Alpha  E01   5.62000 15,000_cells + HCMEC D3_line         0
      1379   65 Alpha  E02   5.40000 15,000_cells + HCMEC D3_line         0
      1380   65 Alpha  E03   5.37000 15,000_cells + HCMEC D3_line         0
      1381   65 Alpha  F01   4.75000 10,000_cells + HCMEC D3_line         0
      1382   65 Alpha  F02   4.46000 10,000_cells + HCMEC D3_line         0
      1383   65 Alpha  F03   4.79000 10,000_cells + HCMEC D3_line         0
      1384   65 Alpha  G01   3.04000  5,000_cells + HCMEC D3_line         0
      1385   65 Alpha  G02   2.85000  5,000_cells + HCMEC D3_line         0
      1386   65 Alpha  G03   2.99000  5,000_cells + HCMEC D3_line         0
      1387   65    Cm  A01   1.12000 35,000_cells + HCMEC D3_line         0
      1388   65    Cm  A02   1.09000 35,000_cells + HCMEC D3_line         0
      1389   65    Cm  A03   1.08000 35,000_cells + HCMEC D3_line         0
      1390   65    Cm  B01   1.07000 30,000_cells + HCMEC D3_line         0
      1391   65    Cm  B02   1.05000 30,000_cells + HCMEC D3_line         0
      1392   65    Cm  B03   1.08000 30,000_cells + HCMEC D3_line         0
      1393   65    Cm  C01   1.12000 25,000_cells + HCMEC D3_line         0
      1394   65    Cm  C02   1.09000 25,000_cells + HCMEC D3_line         0
      1395   65    Cm  C03   1.20000 25,000_cells + HCMEC D3_line         0
      1396   65    Cm  D01   1.53000 20,000_cells + HCMEC D3_line         0
      1397   65    Cm  D02   1.44000 20,000_cells + HCMEC D3_line         0
      1398   65    Cm  D03   1.58000 20,000_cells + HCMEC D3_line         0
      1399   65    Cm  E01   1.94000 15,000_cells + HCMEC D3_line         0
      1400   65    Cm  E02   2.42000 15,000_cells + HCMEC D3_line         0
      1401   65    Cm  E03   2.87000 15,000_cells + HCMEC D3_line         0
      1402   65    Cm  F01   4.67000 10,000_cells + HCMEC D3_line         0
      1403   65    Cm  F02   7.33000 10,000_cells + HCMEC D3_line         0
      1404   65    Cm  F03   5.28000 10,000_cells + HCMEC D3_line         0
      1405   65    Cm  G01  27.08000  5,000_cells + HCMEC D3_line         0
      1406   65    Cm  G02  32.99000  5,000_cells + HCMEC D3_line         0
      1407   65    Cm  G03  22.71000  5,000_cells + HCMEC D3_line         0
      1408   65 Drift  A01  -5.11000 35,000_cells + HCMEC D3_line         0
      1409   65 Drift  A02  -5.33000 35,000_cells + HCMEC D3_line         0
      1410   65 Drift  A03  -4.87000 35,000_cells + HCMEC D3_line         0
      1411   65 Drift  B01  -5.52000 30,000_cells + HCMEC D3_line         0
      1412   65 Drift  B02  -5.77000 30,000_cells + HCMEC D3_line         0
      1413   65 Drift  B03  -5.35000 30,000_cells + HCMEC D3_line         0
      1414   65 Drift  C01  -5.93000 25,000_cells + HCMEC D3_line         0
      1415   65 Drift  C02  -6.07000 25,000_cells + HCMEC D3_line         0
      1416   65 Drift  C03  -5.60000 25,000_cells + HCMEC D3_line         0
      1417   65 Drift  D01  -5.83000 20,000_cells + HCMEC D3_line         0
      1418   65 Drift  D02  -6.16000 20,000_cells + HCMEC D3_line         0
      1419   65 Drift  D03  -5.26000 20,000_cells + HCMEC D3_line         0
      1420   65 Drift  E01  -4.68000 15,000_cells + HCMEC D3_line         0
      1421   65 Drift  E02  -4.86000 15,000_cells + HCMEC D3_line         0
      1422   65 Drift  E03  -4.67000 15,000_cells + HCMEC D3_line         0
      1423   65 Drift  F01  -4.54000 10,000_cells + HCMEC D3_line         0
      1424   65 Drift  F02  -4.40000 10,000_cells + HCMEC D3_line         0
      1425   65 Drift  F03  -4.15000 10,000_cells + HCMEC D3_line         0
      1426   65 Drift  G01  -3.24000  5,000_cells + HCMEC D3_line         0
      1427   65 Drift  G02  -3.16000  5,000_cells + HCMEC D3_line         0
      1428   65 Drift  G03  -2.83000  5,000_cells + HCMEC D3_line         0
      1429   65    Rb  A01   2.68000 35,000_cells + HCMEC D3_line         0
      1430   65    Rb  A02   2.80000 35,000_cells + HCMEC D3_line         0
      1431   65    Rb  A03   2.60000 35,000_cells + HCMEC D3_line         0
      1432   65    Rb  B01   2.83000 30,000_cells + HCMEC D3_line         0
      1433   65    Rb  B02   2.87000 30,000_cells + HCMEC D3_line         0
      1434   65    Rb  B03   2.52000 30,000_cells + HCMEC D3_line         0
      1435   65    Rb  C01   2.44000 25,000_cells + HCMEC D3_line         0
      1436   65    Rb  C02   2.47000 25,000_cells + HCMEC D3_line         0
      1437   65    Rb  C03   1.99000 25,000_cells + HCMEC D3_line         0
      1438   65    Rb  D01   1.09000 20,000_cells + HCMEC D3_line         0
      1439   65    Rb  D02   1.32000 20,000_cells + HCMEC D3_line         0
      1440   65    Rb  D03   1.08000 20,000_cells + HCMEC D3_line         0
      1441   65    Rb  E01   0.00000 15,000_cells + HCMEC D3_line         0
      1442   65    Rb  E02   0.00000 15,000_cells + HCMEC D3_line         0
      1443   65    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      1444   65    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      1445   65    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1446   65    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      1447   65    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1448   65    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1449   65    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1450   65  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1451   65  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1452   65  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1453   65  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1454   65  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1455   65  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1456   65  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      1457   65  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1458   65  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1459   65  RMSE  D01   0.02000 20,000_cells + HCMEC D3_line         0
      1460   65  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      1461   65  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      1462   65  RMSE  E01   0.02000 15,000_cells + HCMEC D3_line         0
      1463   65  RMSE  E02   0.02000 15,000_cells + HCMEC D3_line         0
      1464   65  RMSE  E03   0.02000 15,000_cells + HCMEC D3_line         0
      1465   65  RMSE  F01   0.04000 10,000_cells + HCMEC D3_line         0
      1466   65  RMSE  F02   0.05000 10,000_cells + HCMEC D3_line         0
      1467   65  RMSE  F03   0.04000 10,000_cells + HCMEC D3_line         0
      1468   65  RMSE  G01   0.03000  5,000_cells + HCMEC D3_line         0
      1469   65  RMSE  G02   0.03000  5,000_cells + HCMEC D3_line         0
      1470   65  RMSE  G03   0.03000  5,000_cells + HCMEC D3_line         0
      1471   70 Alpha  A01   3.90000 35,000_cells + HCMEC D3_line         0
      1472   70 Alpha  A02   3.96000 35,000_cells + HCMEC D3_line         0
      1473   70 Alpha  A03   3.92000 35,000_cells + HCMEC D3_line         0
      1474   70 Alpha  B01   4.18000 30,000_cells + HCMEC D3_line         0
      1475   70 Alpha  B02   4.23000 30,000_cells + HCMEC D3_line         0
      1476   70 Alpha  B03   4.34000 30,000_cells + HCMEC D3_line         0
      1477   70 Alpha  C01   4.51000 25,000_cells + HCMEC D3_line         0
      1478   70 Alpha  C02   4.53000 25,000_cells + HCMEC D3_line         0
      1479   70 Alpha  C03   4.58000 25,000_cells + HCMEC D3_line         0
      1480   70 Alpha  D01   5.21000 20,000_cells + HCMEC D3_line         0
      1481   70 Alpha  D02   4.99000 20,000_cells + HCMEC D3_line         0
      1482   70 Alpha  D03   5.05000 20,000_cells + HCMEC D3_line         0
      1483   70 Alpha  E01   5.48000 15,000_cells + HCMEC D3_line         0
      1484   70 Alpha  E02   5.61000 15,000_cells + HCMEC D3_line         0
      1485   70 Alpha  E03   5.73000 15,000_cells + HCMEC D3_line         0
      1486   70 Alpha  F01   5.11000 10,000_cells + HCMEC D3_line         0
      1487   70 Alpha  F02   4.61000 10,000_cells + HCMEC D3_line         0
      1488   70 Alpha  F03   5.05000 10,000_cells + HCMEC D3_line         0
      1489   70 Alpha  G01   3.16000  5,000_cells + HCMEC D3_line         0
      1490   70 Alpha  G02   2.99000  5,000_cells + HCMEC D3_line         0
      1491   70 Alpha  G03   3.18000  5,000_cells + HCMEC D3_line         0
      1492   70    Cm  A01   1.13000 35,000_cells + HCMEC D3_line         0
      1493   70    Cm  A02   1.10000 35,000_cells + HCMEC D3_line         0
      1494   70    Cm  A03   1.09000 35,000_cells + HCMEC D3_line         0
      1495   70    Cm  B01   1.07000 30,000_cells + HCMEC D3_line         0
      1496   70    Cm  B02   1.06000 30,000_cells + HCMEC D3_line         0
      1497   70    Cm  B03   1.06000 30,000_cells + HCMEC D3_line         0
      1498   70    Cm  C01   1.05000 25,000_cells + HCMEC D3_line         0
      1499   70    Cm  C02   1.04000 25,000_cells + HCMEC D3_line         0
      1500   70    Cm  C03   1.11000 25,000_cells + HCMEC D3_line         0
      1501   70    Cm  D01   1.33000 20,000_cells + HCMEC D3_line         0
      1502   70    Cm  D02   1.20000 20,000_cells + HCMEC D3_line         0
      1503   70    Cm  D03   1.31000 20,000_cells + HCMEC D3_line         0
      1504   70    Cm  E01   1.82000 15,000_cells + HCMEC D3_line         0
      1505   70    Cm  E02   1.78000 15,000_cells + HCMEC D3_line         0
      1506   70    Cm  E03   1.77000 15,000_cells + HCMEC D3_line         0
      1507   70    Cm  F01   3.26000 10,000_cells + HCMEC D3_line         0
      1508   70    Cm  F02   5.95000 10,000_cells + HCMEC D3_line         0
      1509   70    Cm  F03   3.56000 10,000_cells + HCMEC D3_line         0
      1510   70    Cm  G01  22.35000  5,000_cells + HCMEC D3_line         0
      1511   70    Cm  G02  24.38000  5,000_cells + HCMEC D3_line         0
      1512   70    Cm  G03  19.38000  5,000_cells + HCMEC D3_line         0
      1513   70 Drift  A01  -5.17000 35,000_cells + HCMEC D3_line         0
      1514   70 Drift  A02  -5.41000 35,000_cells + HCMEC D3_line         0
      1515   70 Drift  A03  -4.94000 35,000_cells + HCMEC D3_line         0
      1516   70 Drift  B01  -5.61000 30,000_cells + HCMEC D3_line         0
      1517   70 Drift  B02  -5.86000 30,000_cells + HCMEC D3_line         0
      1518   70 Drift  B03  -5.40000 30,000_cells + HCMEC D3_line         0
      1519   70 Drift  C01  -5.98000 25,000_cells + HCMEC D3_line         0
      1520   70 Drift  C02  -6.17000 25,000_cells + HCMEC D3_line         0
      1521   70 Drift  C03  -5.66000 25,000_cells + HCMEC D3_line         0
      1522   70 Drift  D01  -5.85000 20,000_cells + HCMEC D3_line         0
      1523   70 Drift  D02  -6.25000 20,000_cells + HCMEC D3_line         0
      1524   70 Drift  D03  -5.32000 20,000_cells + HCMEC D3_line         0
      1525   70 Drift  E01  -4.75000 15,000_cells + HCMEC D3_line         0
      1526   70 Drift  E02  -4.98000 15,000_cells + HCMEC D3_line         0
      1527   70 Drift  E03  -4.85000 15,000_cells + HCMEC D3_line         0
      1528   70 Drift  F01  -4.66000 10,000_cells + HCMEC D3_line         0
      1529   70 Drift  F02  -4.52000 10,000_cells + HCMEC D3_line         0
      1530   70 Drift  F03  -4.29000 10,000_cells + HCMEC D3_line         0
      1531   70 Drift  G01  -3.43000  5,000_cells + HCMEC D3_line         0
      1532   70 Drift  G02  -3.39000  5,000_cells + HCMEC D3_line         0
      1533   70 Drift  G03  -3.03000  5,000_cells + HCMEC D3_line         0
      1534   70    Rb  A01   2.66000 35,000_cells + HCMEC D3_line         0
      1535   70    Rb  A02   2.75000 35,000_cells + HCMEC D3_line         0
      1536   70    Rb  A03   2.66000 35,000_cells + HCMEC D3_line         0
      1537   70    Rb  B01   2.91000 30,000_cells + HCMEC D3_line         0
      1538   70    Rb  B02   2.91000 30,000_cells + HCMEC D3_line         0
      1539   70    Rb  B03   2.70000 30,000_cells + HCMEC D3_line         0
      1540   70    Rb  C01   2.82000 25,000_cells + HCMEC D3_line         0
      1541   70    Rb  C02   2.67000 25,000_cells + HCMEC D3_line         0
      1542   70    Rb  C03   2.32000 25,000_cells + HCMEC D3_line         0
      1543   70    Rb  D01   1.57000 20,000_cells + HCMEC D3_line         0
      1544   70    Rb  D02   1.99000 20,000_cells + HCMEC D3_line         0
      1545   70    Rb  D03   1.68000 20,000_cells + HCMEC D3_line         0
      1546   70    Rb  E01   0.64000 15,000_cells + HCMEC D3_line         0
      1547   70    Rb  E02   0.30000 15,000_cells + HCMEC D3_line         0
      1548   70    Rb  E03   0.00000 15,000_cells + HCMEC D3_line         0
      1549   70    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      1550   70    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1551   70    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      1552   70    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1553   70    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1554   70    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1555   70  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1556   70  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1557   70  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1558   70  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1559   70  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1560   70  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1561   70  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      1562   70  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1563   70  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1564   70  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      1565   70  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      1566   70  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      1567   70  RMSE  E01   0.02000 15,000_cells + HCMEC D3_line         0
      1568   70  RMSE  E02   0.02000 15,000_cells + HCMEC D3_line         0
      1569   70  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      1570   70  RMSE  F01   0.03000 10,000_cells + HCMEC D3_line         0
      1571   70  RMSE  F02   0.05000 10,000_cells + HCMEC D3_line         0
      1572   70  RMSE  F03   0.04000 10,000_cells + HCMEC D3_line         0
      1573   70  RMSE  G01   0.03000  5,000_cells + HCMEC D3_line         0
      1574   70  RMSE  G02   0.03000  5,000_cells + HCMEC D3_line         0
      1575   70  RMSE  G03   0.04000  5,000_cells + HCMEC D3_line         0
      1576   75 Alpha  A01   3.84000 35,000_cells + HCMEC D3_line         0
      1577   75 Alpha  A02   3.93000 35,000_cells + HCMEC D3_line         0
      1578   75 Alpha  A03   3.84000 35,000_cells + HCMEC D3_line         0
      1579   75 Alpha  B01   4.11000 30,000_cells + HCMEC D3_line         0
      1580   75 Alpha  B02   4.20000 30,000_cells + HCMEC D3_line         0
      1581   75 Alpha  B03   4.16000 30,000_cells + HCMEC D3_line         0
      1582   75 Alpha  C01   4.37000 25,000_cells + HCMEC D3_line         0
      1583   75 Alpha  C02   4.40000 25,000_cells + HCMEC D3_line         0
      1584   75 Alpha  C03   4.36000 25,000_cells + HCMEC D3_line         0
      1585   75 Alpha  D01   4.93000 20,000_cells + HCMEC D3_line         0
      1586   75 Alpha  D02   4.74000 20,000_cells + HCMEC D3_line         0
      1587   75 Alpha  D03   4.82000 20,000_cells + HCMEC D3_line         0
      1588   75 Alpha  E01   5.30000 15,000_cells + HCMEC D3_line         0
      1589   75 Alpha  E02   5.44000 15,000_cells + HCMEC D3_line         0
      1590   75 Alpha  E03   5.56000 15,000_cells + HCMEC D3_line         0
      1591   75 Alpha  F01   5.37000 10,000_cells + HCMEC D3_line         0
      1592   75 Alpha  F02   4.95000 10,000_cells + HCMEC D3_line         0
      1593   75 Alpha  F03   5.40000 10,000_cells + HCMEC D3_line         0
      1594   75 Alpha  G01   3.36000  5,000_cells + HCMEC D3_line         0
      1595   75 Alpha  G02   3.11000  5,000_cells + HCMEC D3_line         0
      1596   75 Alpha  G03   3.41000  5,000_cells + HCMEC D3_line         0
      1597   75    Cm  A01   1.14000 35,000_cells + HCMEC D3_line         0
      1598   75    Cm  A02   1.11000 35,000_cells + HCMEC D3_line         0
      1599   75    Cm  A03   1.09000 35,000_cells + HCMEC D3_line         0
      1600   75    Cm  B01   1.08000 30,000_cells + HCMEC D3_line         0
      1601   75    Cm  B02   1.07000 30,000_cells + HCMEC D3_line         0
      1602   75    Cm  B03   1.05000 30,000_cells + HCMEC D3_line         0
      1603   75    Cm  C01   1.06000 25,000_cells + HCMEC D3_line         0
      1604   75    Cm  C02   1.04000 25,000_cells + HCMEC D3_line         0
      1605   75    Cm  C03   1.04000 25,000_cells + HCMEC D3_line         0
      1606   75    Cm  D01   1.19000 20,000_cells + HCMEC D3_line         0
      1607   75    Cm  D02   1.08000 20,000_cells + HCMEC D3_line         0
      1608   75    Cm  D03   1.20000 20,000_cells + HCMEC D3_line         0
      1609   75    Cm  E01   1.46000 15,000_cells + HCMEC D3_line         0
      1610   75    Cm  E02   1.65000 15,000_cells + HCMEC D3_line         0
      1611   75    Cm  E03   1.72000 15,000_cells + HCMEC D3_line         0
      1612   75    Cm  F01   2.25000 10,000_cells + HCMEC D3_line         0
      1613   75    Cm  F02   4.19000 10,000_cells + HCMEC D3_line         0
      1614   75    Cm  F03   2.50000 10,000_cells + HCMEC D3_line         0
      1615   75    Cm  G01  19.88000  5,000_cells + HCMEC D3_line         0
      1616   75    Cm  G02  21.68000  5,000_cells + HCMEC D3_line         0
      1617   75    Cm  G03  16.21000  5,000_cells + HCMEC D3_line         0
      1618   75 Drift  A01  -5.24000 35,000_cells + HCMEC D3_line         0
      1619   75 Drift  A02  -5.49000 35,000_cells + HCMEC D3_line         0
      1620   75 Drift  A03  -5.00000 35,000_cells + HCMEC D3_line         0
      1621   75 Drift  B01  -5.69000 30,000_cells + HCMEC D3_line         0
      1622   75 Drift  B02  -5.94000 30,000_cells + HCMEC D3_line         0
      1623   75 Drift  B03  -5.47000 30,000_cells + HCMEC D3_line         0
      1624   75 Drift  C01  -6.03000 25,000_cells + HCMEC D3_line         0
      1625   75 Drift  C02  -6.24000 25,000_cells + HCMEC D3_line         0
      1626   75 Drift  C03  -5.72000 25,000_cells + HCMEC D3_line         0
      1627   75 Drift  D01  -5.89000 20,000_cells + HCMEC D3_line         0
      1628   75 Drift  D02  -6.25000 20,000_cells + HCMEC D3_line         0
      1629   75 Drift  D03  -5.36000 20,000_cells + HCMEC D3_line         0
      1630   75 Drift  E01  -4.84000 15,000_cells + HCMEC D3_line         0
      1631   75 Drift  E02  -5.11000 15,000_cells + HCMEC D3_line         0
      1632   75 Drift  E03  -4.95000 15,000_cells + HCMEC D3_line         0
      1633   75 Drift  F01  -4.76000 10,000_cells + HCMEC D3_line         0
      1634   75 Drift  F02  -4.68000 10,000_cells + HCMEC D3_line         0
      1635   75 Drift  F03  -4.42000 10,000_cells + HCMEC D3_line         0
      1636   75 Drift  G01  -3.59000  5,000_cells + HCMEC D3_line         0
      1637   75 Drift  G02  -3.55000  5,000_cells + HCMEC D3_line         0
      1638   75 Drift  G03  -3.22000  5,000_cells + HCMEC D3_line         0
      1639   75    Rb  A01   2.61000 35,000_cells + HCMEC D3_line         0
      1640   75    Rb  A02   2.66000 35,000_cells + HCMEC D3_line         0
      1641   75    Rb  A03   2.58000 35,000_cells + HCMEC D3_line         0
      1642   75    Rb  B01   2.83000 30,000_cells + HCMEC D3_line         0
      1643   75    Rb  B02   2.86000 30,000_cells + HCMEC D3_line         0
      1644   75    Rb  B03   2.82000 30,000_cells + HCMEC D3_line         0
      1645   75    Rb  C01   2.82000 25,000_cells + HCMEC D3_line         0
      1646   75    Rb  C02   2.80000 25,000_cells + HCMEC D3_line         0
      1647   75    Rb  C03   2.69000 25,000_cells + HCMEC D3_line         0
      1648   75    Rb  D01   2.04000 20,000_cells + HCMEC D3_line         0
      1649   75    Rb  D02   2.48000 20,000_cells + HCMEC D3_line         0
      1650   75    Rb  D03   2.05000 20,000_cells + HCMEC D3_line         0
      1651   75    Rb  E01   1.30000 15,000_cells + HCMEC D3_line         0
      1652   75    Rb  E02   0.92000 15,000_cells + HCMEC D3_line         0
      1653   75    Rb  E03   0.57000 15,000_cells + HCMEC D3_line         0
      1654   75    Rb  F01   0.00000 10,000_cells + HCMEC D3_line         0
      1655   75    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1656   75    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      1657   75    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1658   75    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1659   75    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1660   75  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1661   75  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1662   75  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1663   75  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1664   75  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1665   75  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1666   75  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      1667   75  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1668   75  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1669   75  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      1670   75  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      1671   75  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      1672   75  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      1673   75  RMSE  E02   0.02000 15,000_cells + HCMEC D3_line         0
      1674   75  RMSE  E03   0.02000 15,000_cells + HCMEC D3_line         0
      1675   75  RMSE  F01   0.02000 10,000_cells + HCMEC D3_line         0
      1676   75  RMSE  F02   0.04000 10,000_cells + HCMEC D3_line         0
      1677   75  RMSE  F03   0.03000 10,000_cells + HCMEC D3_line         0
      1678   75  RMSE  G01   0.04000  5,000_cells + HCMEC D3_line         0
      1679   75  RMSE  G02   0.04000  5,000_cells + HCMEC D3_line         0
      1680   75  RMSE  G03   0.04000  5,000_cells + HCMEC D3_line         0
      1681   80 Alpha  A01   3.82000 35,000_cells + HCMEC D3_line         0
      1682   80 Alpha  A02   3.87000 35,000_cells + HCMEC D3_line         0
      1683   80 Alpha  A03   3.79000 35,000_cells + HCMEC D3_line         0
      1684   80 Alpha  B01   4.05000 30,000_cells + HCMEC D3_line         0
      1685   80 Alpha  B02   4.15000 30,000_cells + HCMEC D3_line         0
      1686   80 Alpha  B03   4.16000 30,000_cells + HCMEC D3_line         0
      1687   80 Alpha  C01   4.27000 25,000_cells + HCMEC D3_line         0
      1688   80 Alpha  C02   4.27000 25,000_cells + HCMEC D3_line         0
      1689   80 Alpha  C03   4.24000 25,000_cells + HCMEC D3_line         0
      1690   80 Alpha  D01   4.64000 20,000_cells + HCMEC D3_line         0
      1691   80 Alpha  D02   4.58000 20,000_cells + HCMEC D3_line         0
      1692   80 Alpha  D03   4.57000 20,000_cells + HCMEC D3_line         0
      1693   80 Alpha  E01   5.04000 15,000_cells + HCMEC D3_line         0
      1694   80 Alpha  E02   5.25000 15,000_cells + HCMEC D3_line         0
      1695   80 Alpha  E03   5.40000 15,000_cells + HCMEC D3_line         0
      1696   80 Alpha  F01   5.75000 10,000_cells + HCMEC D3_line         0
      1697   80 Alpha  F02   5.24000 10,000_cells + HCMEC D3_line         0
      1698   80 Alpha  F03   5.59000 10,000_cells + HCMEC D3_line         0
      1699   80 Alpha  G01   3.49000  5,000_cells + HCMEC D3_line         0
      1700   80 Alpha  G02   3.32000  5,000_cells + HCMEC D3_line         0
      1701   80 Alpha  G03   3.66000  5,000_cells + HCMEC D3_line         0
      1702   80    Cm  A01   1.16000 35,000_cells + HCMEC D3_line         0
      1703   80    Cm  A02   1.11000 35,000_cells + HCMEC D3_line         0
      1704   80    Cm  A03   1.11000 35,000_cells + HCMEC D3_line         0
      1705   80    Cm  B01   1.09000 30,000_cells + HCMEC D3_line         0
      1706   80    Cm  B02   1.07000 30,000_cells + HCMEC D3_line         0
      1707   80    Cm  B03   1.06000 30,000_cells + HCMEC D3_line         0
      1708   80    Cm  C01   1.06000 25,000_cells + HCMEC D3_line         0
      1709   80    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      1710   80    Cm  C03   1.05000 25,000_cells + HCMEC D3_line         0
      1711   80    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      1712   80    Cm  D02   1.05000 20,000_cells + HCMEC D3_line         0
      1713   80    Cm  D03   1.10000 20,000_cells + HCMEC D3_line         0
      1714   80    Cm  E01   1.18000 15,000_cells + HCMEC D3_line         0
      1715   80    Cm  E02   1.43000 15,000_cells + HCMEC D3_line         0
      1716   80    Cm  E03   1.55000 15,000_cells + HCMEC D3_line         0
      1717   80    Cm  F01   1.42000 10,000_cells + HCMEC D3_line         0
      1718   80    Cm  F02   2.92000 10,000_cells + HCMEC D3_line         0
      1719   80    Cm  F03   1.92000 10,000_cells + HCMEC D3_line         0
      1720   80    Cm  G01  16.77000  5,000_cells + HCMEC D3_line         0
      1721   80    Cm  G02  17.65000  5,000_cells + HCMEC D3_line         0
      1722   80    Cm  G03  12.99000  5,000_cells + HCMEC D3_line         0
      1723   80 Drift  A01  -5.28000 35,000_cells + HCMEC D3_line         0
      1724   80 Drift  A02  -5.55000 35,000_cells + HCMEC D3_line         0
      1725   80 Drift  A03  -5.05000 35,000_cells + HCMEC D3_line         0
      1726   80 Drift  B01  -5.75000 30,000_cells + HCMEC D3_line         0
      1727   80 Drift  B02  -6.00000 30,000_cells + HCMEC D3_line         0
      1728   80 Drift  B03  -5.53000 30,000_cells + HCMEC D3_line         0
      1729   80 Drift  C01  -6.07000 25,000_cells + HCMEC D3_line         0
      1730   80 Drift  C02  -6.27000 25,000_cells + HCMEC D3_line         0
      1731   80 Drift  C03  -5.75000 25,000_cells + HCMEC D3_line         0
      1732   80 Drift  D01  -5.92000 20,000_cells + HCMEC D3_line         0
      1733   80 Drift  D02  -6.18000 20,000_cells + HCMEC D3_line         0
      1734   80 Drift  D03  -5.40000 20,000_cells + HCMEC D3_line         0
      1735   80 Drift  E01  -4.90000 15,000_cells + HCMEC D3_line         0
      1736   80 Drift  E02  -5.15000 15,000_cells + HCMEC D3_line         0
      1737   80 Drift  E03  -5.00000 15,000_cells + HCMEC D3_line         0
      1738   80 Drift  F01  -4.84000 10,000_cells + HCMEC D3_line         0
      1739   80 Drift  F02  -4.85000 10,000_cells + HCMEC D3_line         0
      1740   80 Drift  F03  -4.52000 10,000_cells + HCMEC D3_line         0
      1741   80 Drift  G01  -3.72000  5,000_cells + HCMEC D3_line         0
      1742   80 Drift  G02  -3.72000  5,000_cells + HCMEC D3_line         0
      1743   80 Drift  G03  -3.38000  5,000_cells + HCMEC D3_line         0
      1744   80    Rb  A01   2.44000 35,000_cells + HCMEC D3_line         0
      1745   80    Rb  A02   2.61000 35,000_cells + HCMEC D3_line         0
      1746   80    Rb  A03   2.49000 35,000_cells + HCMEC D3_line         0
      1747   80    Rb  B01   2.78000 30,000_cells + HCMEC D3_line         0
      1748   80    Rb  B02   2.83000 30,000_cells + HCMEC D3_line         0
      1749   80    Rb  B03   2.79000 30,000_cells + HCMEC D3_line         0
      1750   80    Rb  C01   2.85000 25,000_cells + HCMEC D3_line         0
      1751   80    Rb  C02   2.78000 25,000_cells + HCMEC D3_line         0
      1752   80    Rb  C03   2.71000 25,000_cells + HCMEC D3_line         0
      1753   80    Rb  D01   2.48000 20,000_cells + HCMEC D3_line         0
      1754   80    Rb  D02   2.71000 20,000_cells + HCMEC D3_line         0
      1755   80    Rb  D03   2.44000 20,000_cells + HCMEC D3_line         0
      1756   80    Rb  E01   1.96000 15,000_cells + HCMEC D3_line         0
      1757   80    Rb  E02   1.36000 15,000_cells + HCMEC D3_line         0
      1758   80    Rb  E03   1.06000 15,000_cells + HCMEC D3_line         0
      1759   80    Rb  F01   0.01000 10,000_cells + HCMEC D3_line         0
      1760   80    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1761   80    Rb  F03   0.00000 10,000_cells + HCMEC D3_line         0
      1762   80    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1763   80    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1764   80    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1765   80  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1766   80  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1767   80  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1768   80  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1769   80  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1770   80  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1771   80  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      1772   80  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1773   80  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1774   80  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      1775   80  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      1776   80  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      1777   80  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      1778   80  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      1779   80  RMSE  E03   0.02000 15,000_cells + HCMEC D3_line         0
      1780   80  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      1781   80  RMSE  F02   0.03000 10,000_cells + HCMEC D3_line         0
      1782   80  RMSE  F03   0.02000 10,000_cells + HCMEC D3_line         0
      1783   80  RMSE  G01   0.04000  5,000_cells + HCMEC D3_line         0
      1784   80  RMSE  G02   0.04000  5,000_cells + HCMEC D3_line         0
      1785   80  RMSE  G03   0.04000  5,000_cells + HCMEC D3_line         0
      1786   85 Alpha  A01   3.74000 35,000_cells + HCMEC D3_line         0
      1787   85 Alpha  A02   3.81000 35,000_cells + HCMEC D3_line         0
      1788   85 Alpha  A03   3.75000 35,000_cells + HCMEC D3_line         0
      1789   85 Alpha  B01   4.05000 30,000_cells + HCMEC D3_line         0
      1790   85 Alpha  B02   4.15000 30,000_cells + HCMEC D3_line         0
      1791   85 Alpha  B03   4.11000 30,000_cells + HCMEC D3_line         0
      1792   85 Alpha  C01   4.23000 25,000_cells + HCMEC D3_line         0
      1793   85 Alpha  C02   4.20000 25,000_cells + HCMEC D3_line         0
      1794   85 Alpha  C03   4.17000 25,000_cells + HCMEC D3_line         0
      1795   85 Alpha  D01   4.52000 20,000_cells + HCMEC D3_line         0
      1796   85 Alpha  D02   4.48000 20,000_cells + HCMEC D3_line         0
      1797   85 Alpha  D03   4.38000 20,000_cells + HCMEC D3_line         0
      1798   85 Alpha  E01   4.83000 15,000_cells + HCMEC D3_line         0
      1799   85 Alpha  E02   5.01000 15,000_cells + HCMEC D3_line         0
      1800   85 Alpha  E03   5.26000 15,000_cells + HCMEC D3_line         0
      1801   85 Alpha  F01   5.54000 10,000_cells + HCMEC D3_line         0
      1802   85 Alpha  F02   5.48000 10,000_cells + HCMEC D3_line         0
      1803   85 Alpha  F03   5.83000 10,000_cells + HCMEC D3_line         0
      1804   85 Alpha  G01   3.67000  5,000_cells + HCMEC D3_line         0
      1805   85 Alpha  G02   3.51000  5,000_cells + HCMEC D3_line         0
      1806   85 Alpha  G03   3.77000  5,000_cells + HCMEC D3_line         0
      1807   85    Cm  A01   1.16000 35,000_cells + HCMEC D3_line         0
      1808   85    Cm  A02   1.12000 35,000_cells + HCMEC D3_line         0
      1809   85    Cm  A03   1.12000 35,000_cells + HCMEC D3_line         0
      1810   85    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      1811   85    Cm  B02   1.07000 30,000_cells + HCMEC D3_line         0
      1812   85    Cm  B03   1.07000 30,000_cells + HCMEC D3_line         0
      1813   85    Cm  C01   1.07000 25,000_cells + HCMEC D3_line         0
      1814   85    Cm  C02   1.04000 25,000_cells + HCMEC D3_line         0
      1815   85    Cm  C03   1.06000 25,000_cells + HCMEC D3_line         0
      1816   85    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      1817   85    Cm  D02   1.08000 20,000_cells + HCMEC D3_line         0
      1818   85    Cm  D03   1.07000 20,000_cells + HCMEC D3_line         0
      1819   85    Cm  E01   1.10000 15,000_cells + HCMEC D3_line         0
      1820   85    Cm  E02   1.19000 15,000_cells + HCMEC D3_line         0
      1821   85    Cm  E03   1.35000 15,000_cells + HCMEC D3_line         0
      1822   85    Cm  F01   1.53000 10,000_cells + HCMEC D3_line         0
      1823   85    Cm  F02   2.10000 10,000_cells + HCMEC D3_line         0
      1824   85    Cm  F03   1.42000 10,000_cells + HCMEC D3_line         0
      1825   85    Cm  G01  14.16000  5,000_cells + HCMEC D3_line         0
      1826   85    Cm  G02  14.62000  5,000_cells + HCMEC D3_line         0
      1827   85    Cm  G03  11.33000  5,000_cells + HCMEC D3_line         0
      1828   85 Drift  A01  -5.32000 35,000_cells + HCMEC D3_line         0
      1829   85 Drift  A02  -5.60000 35,000_cells + HCMEC D3_line         0
      1830   85 Drift  A03  -5.10000 35,000_cells + HCMEC D3_line         0
      1831   85 Drift  B01  -5.81000 30,000_cells + HCMEC D3_line         0
      1832   85 Drift  B02  -6.07000 30,000_cells + HCMEC D3_line         0
      1833   85 Drift  B03  -5.59000 30,000_cells + HCMEC D3_line         0
      1834   85 Drift  C01  -6.12000 25,000_cells + HCMEC D3_line         0
      1835   85 Drift  C02  -6.35000 25,000_cells + HCMEC D3_line         0
      1836   85 Drift  C03  -5.82000 25,000_cells + HCMEC D3_line         0
      1837   85 Drift  D01  -5.94000 20,000_cells + HCMEC D3_line         0
      1838   85 Drift  D02  -6.31000 20,000_cells + HCMEC D3_line         0
      1839   85 Drift  D03  -5.43000 20,000_cells + HCMEC D3_line         0
      1840   85 Drift  E01  -4.90000 15,000_cells + HCMEC D3_line         0
      1841   85 Drift  E02  -5.21000 15,000_cells + HCMEC D3_line         0
      1842   85 Drift  E03  -5.02000 15,000_cells + HCMEC D3_line         0
      1843   85 Drift  F01  -4.95000 10,000_cells + HCMEC D3_line         0
      1844   85 Drift  F02  -4.88000 10,000_cells + HCMEC D3_line         0
      1845   85 Drift  F03  -4.58000 10,000_cells + HCMEC D3_line         0
      1846   85 Drift  G01  -3.82000  5,000_cells + HCMEC D3_line         0
      1847   85 Drift  G02  -3.86000  5,000_cells + HCMEC D3_line         0
      1848   85 Drift  G03  -3.51000  5,000_cells + HCMEC D3_line         0
      1849   85    Rb  A01   2.38000 35,000_cells + HCMEC D3_line         0
      1850   85    Rb  A02   2.49000 35,000_cells + HCMEC D3_line         0
      1851   85    Rb  A03   2.38000 35,000_cells + HCMEC D3_line         0
      1852   85    Rb  B01   2.68000 30,000_cells + HCMEC D3_line         0
      1853   85    Rb  B02   2.73000 30,000_cells + HCMEC D3_line         0
      1854   85    Rb  B03   2.69000 30,000_cells + HCMEC D3_line         0
      1855   85    Rb  C01   2.80000 25,000_cells + HCMEC D3_line         0
      1856   85    Rb  C02   2.75000 25,000_cells + HCMEC D3_line         0
      1857   85    Rb  C03   2.63000 25,000_cells + HCMEC D3_line         0
      1858   85    Rb  D01   2.54000 20,000_cells + HCMEC D3_line         0
      1859   85    Rb  D02   2.64000 20,000_cells + HCMEC D3_line         0
      1860   85    Rb  D03   2.61000 20,000_cells + HCMEC D3_line         0
      1861   85    Rb  E01   2.32000 15,000_cells + HCMEC D3_line         0
      1862   85    Rb  E02   1.90000 15,000_cells + HCMEC D3_line         0
      1863   85    Rb  E03   1.51000 15,000_cells + HCMEC D3_line         0
      1864   85    Rb  F01   0.73000 10,000_cells + HCMEC D3_line         0
      1865   85    Rb  F02   0.00000 10,000_cells + HCMEC D3_line         0
      1866   85    Rb  F03   0.04000 10,000_cells + HCMEC D3_line         0
      1867   85    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1868   85    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1869   85    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1870   85  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1871   85  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1872   85  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1873   85  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1874   85  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1875   85  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1876   85  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      1877   85  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1878   85  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1879   85  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      1880   85  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      1881   85  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      1882   85  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      1883   85  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      1884   85  RMSE  E03   0.02000 15,000_cells + HCMEC D3_line         0
      1885   85  RMSE  F01   0.02000 10,000_cells + HCMEC D3_line         0
      1886   85  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      1887   85  RMSE  F03   0.02000 10,000_cells + HCMEC D3_line         0
      1888   85  RMSE  G01   0.05000  5,000_cells + HCMEC D3_line         0
      1889   85  RMSE  G02   0.04000  5,000_cells + HCMEC D3_line         0
      1890   85  RMSE  G03   0.04000  5,000_cells + HCMEC D3_line         0
      1891   90 Alpha  A01   3.71000 35,000_cells + HCMEC D3_line         0
      1892   90 Alpha  A02   3.76000 35,000_cells + HCMEC D3_line         0
      1893   90 Alpha  A03   3.68000 35,000_cells + HCMEC D3_line         0
      1894   90 Alpha  B01   4.02000 30,000_cells + HCMEC D3_line         0
      1895   90 Alpha  B02   4.09000 30,000_cells + HCMEC D3_line         0
      1896   90 Alpha  B03   4.04000 30,000_cells + HCMEC D3_line         0
      1897   90 Alpha  C01   4.19000 25,000_cells + HCMEC D3_line         0
      1898   90 Alpha  C02   4.16000 25,000_cells + HCMEC D3_line         0
      1899   90 Alpha  C03   4.13000 25,000_cells + HCMEC D3_line         0
      1900   90 Alpha  D01   4.38000 20,000_cells + HCMEC D3_line         0
      1901   90 Alpha  D02   4.35000 20,000_cells + HCMEC D3_line         0
      1902   90 Alpha  D03   4.28000 20,000_cells + HCMEC D3_line         0
      1903   90 Alpha  E01   4.68000 15,000_cells + HCMEC D3_line         0
      1904   90 Alpha  E02   4.79000 15,000_cells + HCMEC D3_line         0
      1905   90 Alpha  E03   5.02000 15,000_cells + HCMEC D3_line         0
      1906   90 Alpha  F01   5.32000 10,000_cells + HCMEC D3_line         0
      1907   90 Alpha  F02   5.80000 10,000_cells + HCMEC D3_line         0
      1908   90 Alpha  F03   5.56000 10,000_cells + HCMEC D3_line         0
      1909   90 Alpha  G01   3.80000  5,000_cells + HCMEC D3_line         0
      1910   90 Alpha  G02   3.80000  5,000_cells + HCMEC D3_line         0
      1911   90 Alpha  G03   3.95000  5,000_cells + HCMEC D3_line         0
      1912   90    Cm  A01   1.18000 35,000_cells + HCMEC D3_line         0
      1913   90    Cm  A02   1.13000 35,000_cells + HCMEC D3_line         0
      1914   90    Cm  A03   1.13000 35,000_cells + HCMEC D3_line         0
      1915   90    Cm  B01   1.09000 30,000_cells + HCMEC D3_line         0
      1916   90    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      1917   90    Cm  B03   1.07000 30,000_cells + HCMEC D3_line         0
      1918   90    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      1919   90    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      1920   90    Cm  C03   1.07000 25,000_cells + HCMEC D3_line         0
      1921   90    Cm  D01   1.07000 20,000_cells + HCMEC D3_line         0
      1922   90    Cm  D02   1.06000 20,000_cells + HCMEC D3_line         0
      1923   90    Cm  D03   1.07000 20,000_cells + HCMEC D3_line         0
      1924   90    Cm  E01   1.06000 15,000_cells + HCMEC D3_line         0
      1925   90    Cm  E02   1.12000 15,000_cells + HCMEC D3_line         0
      1926   90    Cm  E03   1.23000 15,000_cells + HCMEC D3_line         0
      1927   90    Cm  F01   1.44000 10,000_cells + HCMEC D3_line         0
      1928   90    Cm  F02   1.36000 10,000_cells + HCMEC D3_line         0
      1929   90    Cm  F03   1.56000 10,000_cells + HCMEC D3_line         0
      1930   90    Cm  G01  11.62000  5,000_cells + HCMEC D3_line         0
      1931   90    Cm  G02  12.31000  5,000_cells + HCMEC D3_line         0
      1932   90    Cm  G03   8.81000  5,000_cells + HCMEC D3_line         0
      1933   90 Drift  A01  -5.35000 35,000_cells + HCMEC D3_line         0
      1934   90 Drift  A02  -5.64000 35,000_cells + HCMEC D3_line         0
      1935   90 Drift  A03  -5.12000 35,000_cells + HCMEC D3_line         0
      1936   90 Drift  B01  -5.86000 30,000_cells + HCMEC D3_line         0
      1937   90 Drift  B02  -6.12000 30,000_cells + HCMEC D3_line         0
      1938   90 Drift  B03  -5.64000 30,000_cells + HCMEC D3_line         0
      1939   90 Drift  C01  -6.16000 25,000_cells + HCMEC D3_line         0
      1940   90 Drift  C02  -6.40000 25,000_cells + HCMEC D3_line         0
      1941   90 Drift  C03  -5.88000 25,000_cells + HCMEC D3_line         0
      1942   90 Drift  D01  -5.96000 20,000_cells + HCMEC D3_line         0
      1943   90 Drift  D02  -6.28000 20,000_cells + HCMEC D3_line         0
      1944   90 Drift  D03  -5.47000 20,000_cells + HCMEC D3_line         0
      1945   90 Drift  E01  -4.93000 15,000_cells + HCMEC D3_line         0
      1946   90 Drift  E02  -5.24000 15,000_cells + HCMEC D3_line         0
      1947   90 Drift  E03  -5.08000 15,000_cells + HCMEC D3_line         0
      1948   90 Drift  F01  -4.99000 10,000_cells + HCMEC D3_line         0
      1949   90 Drift  F02  -4.92000 10,000_cells + HCMEC D3_line         0
      1950   90 Drift  F03  -4.66000 10,000_cells + HCMEC D3_line         0
      1951   90 Drift  G01  -3.95000  5,000_cells + HCMEC D3_line         0
      1952   90 Drift  G02  -4.04000  5,000_cells + HCMEC D3_line         0
      1953   90 Drift  G03  -3.62000  5,000_cells + HCMEC D3_line         0
      1954   90    Rb  A01   2.29000 35,000_cells + HCMEC D3_line         0
      1955   90    Rb  A02   2.35000 35,000_cells + HCMEC D3_line         0
      1956   90    Rb  A03   2.27000 35,000_cells + HCMEC D3_line         0
      1957   90    Rb  B01   2.61000 30,000_cells + HCMEC D3_line         0
      1958   90    Rb  B02   2.64000 30,000_cells + HCMEC D3_line         0
      1959   90    Rb  B03   2.65000 30,000_cells + HCMEC D3_line         0
      1960   90    Rb  C01   2.72000 25,000_cells + HCMEC D3_line         0
      1961   90    Rb  C02   2.75000 25,000_cells + HCMEC D3_line         0
      1962   90    Rb  C03   2.55000 25,000_cells + HCMEC D3_line         0
      1963   90    Rb  D01   2.63000 20,000_cells + HCMEC D3_line         0
      1964   90    Rb  D02   2.71000 20,000_cells + HCMEC D3_line         0
      1965   90    Rb  D03   2.68000 20,000_cells + HCMEC D3_line         0
      1966   90    Rb  E01   2.54000 15,000_cells + HCMEC D3_line         0
      1967   90    Rb  E02   2.18000 15,000_cells + HCMEC D3_line         0
      1968   90    Rb  E03   1.88000 15,000_cells + HCMEC D3_line         0
      1969   90    Rb  F01   1.22000 10,000_cells + HCMEC D3_line         0
      1970   90    Rb  F02   0.02000 10,000_cells + HCMEC D3_line         0
      1971   90    Rb  F03   0.70000 10,000_cells + HCMEC D3_line         0
      1972   90    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      1973   90    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      1974   90    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      1975   90  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      1976   90  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      1977   90  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      1978   90  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      1979   90  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      1980   90  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      1981   90  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      1982   90  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      1983   90  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      1984   90  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      1985   90  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      1986   90  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      1987   90  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      1988   90  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      1989   90  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      1990   90  RMSE  F01   0.02000 10,000_cells + HCMEC D3_line         0
      1991   90  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      1992   90  RMSE  F03   0.02000 10,000_cells + HCMEC D3_line         0
      1993   90  RMSE  G01   0.05000  5,000_cells + HCMEC D3_line         0
      1994   90  RMSE  G02   0.05000  5,000_cells + HCMEC D3_line         0
      1995   90  RMSE  G03   0.05000  5,000_cells + HCMEC D3_line         0
      1996   95 Alpha  A01   3.67000 35,000_cells + HCMEC D3_line         0
      1997   95 Alpha  A02   3.68000 35,000_cells + HCMEC D3_line         0
      1998   95 Alpha  A03   3.65000 35,000_cells + HCMEC D3_line         0
      1999   95 Alpha  B01   3.95000 30,000_cells + HCMEC D3_line         0
      2000   95 Alpha  B02   4.01000 30,000_cells + HCMEC D3_line         0
      2001   95 Alpha  B03   3.94000 30,000_cells + HCMEC D3_line         0
      2002   95 Alpha  C01   4.11000 25,000_cells + HCMEC D3_line         0
      2003   95 Alpha  C02   4.10000 25,000_cells + HCMEC D3_line         0
      2004   95 Alpha  C03   4.07000 25,000_cells + HCMEC D3_line         0
      2005   95 Alpha  D01   4.23000 20,000_cells + HCMEC D3_line         0
      2006   95 Alpha  D02   4.28000 20,000_cells + HCMEC D3_line         0
      2007   95 Alpha  D03   4.21000 20,000_cells + HCMEC D3_line         0
      2008   95 Alpha  E01   4.47000 15,000_cells + HCMEC D3_line         0
      2009   95 Alpha  E02   4.68000 15,000_cells + HCMEC D3_line         0
      2010   95 Alpha  E03   4.76000 15,000_cells + HCMEC D3_line         0
      2011   95 Alpha  F01   5.08000 10,000_cells + HCMEC D3_line         0
      2012   95 Alpha  F02   5.69000 10,000_cells + HCMEC D3_line         0
      2013   95 Alpha  F03   5.39000 10,000_cells + HCMEC D3_line         0
      2014   95 Alpha  G01   3.99000  5,000_cells + HCMEC D3_line         0
      2015   95 Alpha  G02   4.01000  5,000_cells + HCMEC D3_line         0
      2016   95 Alpha  G03   4.00000  5,000_cells + HCMEC D3_line         0
      2017   95    Cm  A01   1.19000 35,000_cells + HCMEC D3_line         0
      2018   95    Cm  A02   1.12000 35,000_cells + HCMEC D3_line         0
      2019   95    Cm  A03   1.14000 35,000_cells + HCMEC D3_line         0
      2020   95    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      2021   95    Cm  B02   1.07000 30,000_cells + HCMEC D3_line         0
      2022   95    Cm  B03   1.08000 30,000_cells + HCMEC D3_line         0
      2023   95    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      2024   95    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      2025   95    Cm  C03   1.06000 25,000_cells + HCMEC D3_line         0
      2026   95    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      2027   95    Cm  D02   1.07000 20,000_cells + HCMEC D3_line         0
      2028   95    Cm  D03   1.06000 20,000_cells + HCMEC D3_line         0
      2029   95    Cm  E01   1.07000 15,000_cells + HCMEC D3_line         0
      2030   95    Cm  E02   1.07000 15,000_cells + HCMEC D3_line         0
      2031   95    Cm  E03   1.13000 15,000_cells + HCMEC D3_line         0
      2032   95    Cm  F01   1.29000 10,000_cells + HCMEC D3_line         0
      2033   95    Cm  F02   1.46000 10,000_cells + HCMEC D3_line         0
      2034   95    Cm  F03   1.46000 10,000_cells + HCMEC D3_line         0
      2035   95    Cm  G01   9.95000  5,000_cells + HCMEC D3_line         0
      2036   95    Cm  G02   9.54000  5,000_cells + HCMEC D3_line         0
      2037   95    Cm  G03   7.62000  5,000_cells + HCMEC D3_line         0
      2038   95 Drift  A01  -5.36000 35,000_cells + HCMEC D3_line         0
      2039   95 Drift  A02  -5.67000 35,000_cells + HCMEC D3_line         0
      2040   95 Drift  A03  -5.14000 35,000_cells + HCMEC D3_line         0
      2041   95 Drift  B01  -5.89000 30,000_cells + HCMEC D3_line         0
      2042   95 Drift  B02  -6.15000 30,000_cells + HCMEC D3_line         0
      2043   95 Drift  B03  -5.66000 30,000_cells + HCMEC D3_line         0
      2044   95 Drift  C01  -6.19000 25,000_cells + HCMEC D3_line         0
      2045   95 Drift  C02  -6.44000 25,000_cells + HCMEC D3_line         0
      2046   95 Drift  C03  -5.90000 25,000_cells + HCMEC D3_line         0
      2047   95 Drift  D01  -5.96000 20,000_cells + HCMEC D3_line         0
      2048   95 Drift  D02  -6.30000 20,000_cells + HCMEC D3_line         0
      2049   95 Drift  D03  -5.48000 20,000_cells + HCMEC D3_line         0
      2050   95 Drift  E01  -4.91000 15,000_cells + HCMEC D3_line         0
      2051   95 Drift  E02  -5.28000 15,000_cells + HCMEC D3_line         0
      2052   95 Drift  E03  -5.11000 15,000_cells + HCMEC D3_line         0
      2053   95 Drift  F01  -4.97000 10,000_cells + HCMEC D3_line         0
      2054   95 Drift  F02  -4.98000 10,000_cells + HCMEC D3_line         0
      2055   95 Drift  F03  -4.70000 10,000_cells + HCMEC D3_line         0
      2056   95 Drift  G01  -4.01000  5,000_cells + HCMEC D3_line         0
      2057   95 Drift  G02  -4.16000  5,000_cells + HCMEC D3_line         0
      2058   95 Drift  G03  -3.63000  5,000_cells + HCMEC D3_line         0
      2059   95    Rb  A01   2.17000 35,000_cells + HCMEC D3_line         0
      2060   95    Rb  A02   2.26000 35,000_cells + HCMEC D3_line         0
      2061   95    Rb  A03   2.17000 35,000_cells + HCMEC D3_line         0
      2062   95    Rb  B01   2.49000 30,000_cells + HCMEC D3_line         0
      2063   95    Rb  B02   2.55000 30,000_cells + HCMEC D3_line         0
      2064   95    Rb  B03   2.52000 30,000_cells + HCMEC D3_line         0
      2065   95    Rb  C01   2.60000 25,000_cells + HCMEC D3_line         0
      2066   95    Rb  C02   2.66000 25,000_cells + HCMEC D3_line         0
      2067   95    Rb  C03   2.64000 25,000_cells + HCMEC D3_line         0
      2068   95    Rb  D01   2.65000 20,000_cells + HCMEC D3_line         0
      2069   95    Rb  D02   2.76000 20,000_cells + HCMEC D3_line         0
      2070   95    Rb  D03   2.65000 20,000_cells + HCMEC D3_line         0
      2071   95    Rb  E01   2.62000 15,000_cells + HCMEC D3_line         0
      2072   95    Rb  E02   2.40000 15,000_cells + HCMEC D3_line         0
      2073   95    Rb  E03   2.26000 15,000_cells + HCMEC D3_line         0
      2074   95    Rb  F01   1.66000 10,000_cells + HCMEC D3_line         0
      2075   95    Rb  F02   0.50000 10,000_cells + HCMEC D3_line         0
      2076   95    Rb  F03   1.16000 10,000_cells + HCMEC D3_line         0
      2077   95    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2078   95    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2079   95    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2080   95  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2081   95  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2082   95  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2083   95  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2084   95  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2085   95  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2086   95  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2087   95  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2088   95  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2089   95  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2090   95  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2091   95  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2092   95  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2093   95  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2094   95  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2095   95  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2096   95  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      2097   95  RMSE  F03   0.02000 10,000_cells + HCMEC D3_line         0
      2098   95  RMSE  G01   0.05000  5,000_cells + HCMEC D3_line         0
      2099   95  RMSE  G02   0.05000  5,000_cells + HCMEC D3_line         0
      2100   95  RMSE  G03   0.05000  5,000_cells + HCMEC D3_line         0
      2101  100 Alpha  A01   3.64000 35,000_cells + HCMEC D3_line         0
      2102  100 Alpha  A02   3.62000 35,000_cells + HCMEC D3_line         0
      2103  100 Alpha  A03   3.58000 35,000_cells + HCMEC D3_line         0
      2104  100 Alpha  B01   3.89000 30,000_cells + HCMEC D3_line         0
      2105  100 Alpha  B02   3.98000 30,000_cells + HCMEC D3_line         0
      2106  100 Alpha  B03   3.90000 30,000_cells + HCMEC D3_line         0
      2107  100 Alpha  C01   4.07000 25,000_cells + HCMEC D3_line         0
      2108  100 Alpha  C02   4.07000 25,000_cells + HCMEC D3_line         0
      2109  100 Alpha  C03   4.06000 25,000_cells + HCMEC D3_line         0
      2110  100 Alpha  D01   4.22000 20,000_cells + HCMEC D3_line         0
      2111  100 Alpha  D02   4.26000 20,000_cells + HCMEC D3_line         0
      2112  100 Alpha  D03   4.18000 20,000_cells + HCMEC D3_line         0
      2113  100 Alpha  E01   4.37000 15,000_cells + HCMEC D3_line         0
      2114  100 Alpha  E02   4.56000 15,000_cells + HCMEC D3_line         0
      2115  100 Alpha  E03   4.62000 15,000_cells + HCMEC D3_line         0
      2116  100 Alpha  F01   4.81000 10,000_cells + HCMEC D3_line         0
      2117  100 Alpha  F02   5.51000 10,000_cells + HCMEC D3_line         0
      2118  100 Alpha  F03   5.20000 10,000_cells + HCMEC D3_line         0
      2119  100 Alpha  G01   4.09000  5,000_cells + HCMEC D3_line         0
      2120  100 Alpha  G02   4.16000  5,000_cells + HCMEC D3_line         0
      2121  100 Alpha  G03   4.19000  5,000_cells + HCMEC D3_line         0
      2122  100    Cm  A01   1.20000 35,000_cells + HCMEC D3_line         0
      2123  100    Cm  A02   1.13000 35,000_cells + HCMEC D3_line         0
      2124  100    Cm  A03   1.15000 35,000_cells + HCMEC D3_line         0
      2125  100    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      2126  100    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      2127  100    Cm  B03   1.09000 30,000_cells + HCMEC D3_line         0
      2128  100    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      2129  100    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      2130  100    Cm  C03   1.08000 25,000_cells + HCMEC D3_line         0
      2131  100    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      2132  100    Cm  D02   1.08000 20,000_cells + HCMEC D3_line         0
      2133  100    Cm  D03   1.08000 20,000_cells + HCMEC D3_line         0
      2134  100    Cm  E01   1.07000 15,000_cells + HCMEC D3_line         0
      2135  100    Cm  E02   1.05000 15,000_cells + HCMEC D3_line         0
      2136  100    Cm  E03   1.10000 15,000_cells + HCMEC D3_line         0
      2137  100    Cm  F01   1.14000 10,000_cells + HCMEC D3_line         0
      2138  100    Cm  F02   1.43000 10,000_cells + HCMEC D3_line         0
      2139  100    Cm  F03   1.34000 10,000_cells + HCMEC D3_line         0
      2140  100    Cm  G01   8.64000  5,000_cells + HCMEC D3_line         0
      2141  100    Cm  G02   8.13000  5,000_cells + HCMEC D3_line         0
      2142  100    Cm  G03   5.95000  5,000_cells + HCMEC D3_line         0
      2143  100 Drift  A01  -5.37000 35,000_cells + HCMEC D3_line         0
      2144  100 Drift  A02  -5.67000 35,000_cells + HCMEC D3_line         0
      2145  100 Drift  A03  -5.14000 35,000_cells + HCMEC D3_line         0
      2146  100 Drift  B01  -5.90000 30,000_cells + HCMEC D3_line         0
      2147  100 Drift  B02  -6.18000 30,000_cells + HCMEC D3_line         0
      2148  100 Drift  B03  -5.67000 30,000_cells + HCMEC D3_line         0
      2149  100 Drift  C01  -6.21000 25,000_cells + HCMEC D3_line         0
      2150  100 Drift  C02  -6.47000 25,000_cells + HCMEC D3_line         0
      2151  100 Drift  C03  -5.91000 25,000_cells + HCMEC D3_line         0
      2152  100 Drift  D01  -5.97000 20,000_cells + HCMEC D3_line         0
      2153  100 Drift  D02  -6.31000 20,000_cells + HCMEC D3_line         0
      2154  100 Drift  D03  -5.51000 20,000_cells + HCMEC D3_line         0
      2155  100 Drift  E01  -4.92000 15,000_cells + HCMEC D3_line         0
      2156  100 Drift  E02  -5.31000 15,000_cells + HCMEC D3_line         0
      2157  100 Drift  E03  -5.11000 15,000_cells + HCMEC D3_line         0
      2158  100 Drift  F01  -4.96000 10,000_cells + HCMEC D3_line         0
      2159  100 Drift  F02  -5.01000 10,000_cells + HCMEC D3_line         0
      2160  100 Drift  F03  -4.72000 10,000_cells + HCMEC D3_line         0
      2161  100 Drift  G01  -4.03000  5,000_cells + HCMEC D3_line         0
      2162  100 Drift  G02  -4.20000  5,000_cells + HCMEC D3_line         0
      2163  100 Drift  G03  -3.69000  5,000_cells + HCMEC D3_line         0
      2164  100    Rb  A01   2.05000 35,000_cells + HCMEC D3_line         0
      2165  100    Rb  A02   2.15000 35,000_cells + HCMEC D3_line         0
      2166  100    Rb  A03   2.08000 35,000_cells + HCMEC D3_line         0
      2167  100    Rb  B01   2.37000 30,000_cells + HCMEC D3_line         0
      2168  100    Rb  B02   2.42000 30,000_cells + HCMEC D3_line         0
      2169  100    Rb  B03   2.40000 30,000_cells + HCMEC D3_line         0
      2170  100    Rb  C01   2.56000 25,000_cells + HCMEC D3_line         0
      2171  100    Rb  C02   2.52000 25,000_cells + HCMEC D3_line         0
      2172  100    Rb  C03   2.47000 25,000_cells + HCMEC D3_line         0
      2173  100    Rb  D01   2.60000 20,000_cells + HCMEC D3_line         0
      2174  100    Rb  D02   2.65000 20,000_cells + HCMEC D3_line         0
      2175  100    Rb  D03   2.55000 20,000_cells + HCMEC D3_line         0
      2176  100    Rb  E01   2.65000 15,000_cells + HCMEC D3_line         0
      2177  100    Rb  E02   2.52000 15,000_cells + HCMEC D3_line         0
      2178  100    Rb  E03   2.38000 15,000_cells + HCMEC D3_line         0
      2179  100    Rb  F01   2.18000 10,000_cells + HCMEC D3_line         0
      2180  100    Rb  F02   0.95000 10,000_cells + HCMEC D3_line         0
      2181  100    Rb  F03   1.56000 10,000_cells + HCMEC D3_line         0
      2182  100    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2183  100    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2184  100    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2185  100  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2186  100  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2187  100  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2188  100  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2189  100  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2190  100  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2191  100  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2192  100  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2193  100  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2194  100  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2195  100  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2196  100  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2197  100  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2198  100  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2199  100  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2200  100  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2201  100  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      2202  100  RMSE  F03   0.02000 10,000_cells + HCMEC D3_line         0
      2203  100  RMSE  G01   0.05000  5,000_cells + HCMEC D3_line         0
      2204  100  RMSE  G02   0.05000  5,000_cells + HCMEC D3_line         0
      2205  100  RMSE  G03   0.05000  5,000_cells + HCMEC D3_line         0
      2206  105 Alpha  A01   3.54000 35,000_cells + HCMEC D3_line         0
      2207  105 Alpha  A02   3.59000 35,000_cells + HCMEC D3_line         0
      2208  105 Alpha  A03   3.52000 35,000_cells + HCMEC D3_line         0
      2209  105 Alpha  B01   3.84000 30,000_cells + HCMEC D3_line         0
      2210  105 Alpha  B02   3.92000 30,000_cells + HCMEC D3_line         0
      2211  105 Alpha  B03   3.83000 30,000_cells + HCMEC D3_line         0
      2212  105 Alpha  C01   4.00000 25,000_cells + HCMEC D3_line         0
      2213  105 Alpha  C02   4.06000 25,000_cells + HCMEC D3_line         0
      2214  105 Alpha  C03   3.96000 25,000_cells + HCMEC D3_line         0
      2215  105 Alpha  D01   4.21000 20,000_cells + HCMEC D3_line         0
      2216  105 Alpha  D02   4.25000 20,000_cells + HCMEC D3_line         0
      2217  105 Alpha  D03   4.15000 20,000_cells + HCMEC D3_line         0
      2218  105 Alpha  E01   4.35000 15,000_cells + HCMEC D3_line         0
      2219  105 Alpha  E02   4.47000 15,000_cells + HCMEC D3_line         0
      2220  105 Alpha  E03   4.46000 15,000_cells + HCMEC D3_line         0
      2221  105 Alpha  F01   4.68000 10,000_cells + HCMEC D3_line         0
      2222  105 Alpha  F02   5.28000 10,000_cells + HCMEC D3_line         0
      2223  105 Alpha  F03   4.94000 10,000_cells + HCMEC D3_line         0
      2224  105 Alpha  G01   4.22000  5,000_cells + HCMEC D3_line         0
      2225  105 Alpha  G02   4.37000  5,000_cells + HCMEC D3_line         0
      2226  105 Alpha  G03   4.35000  5,000_cells + HCMEC D3_line         0
      2227  105    Cm  A01   1.20000 35,000_cells + HCMEC D3_line         0
      2228  105    Cm  A02   1.13000 35,000_cells + HCMEC D3_line         0
      2229  105    Cm  A03   1.16000 35,000_cells + HCMEC D3_line         0
      2230  105    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      2231  105    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      2232  105    Cm  B03   1.10000 30,000_cells + HCMEC D3_line         0
      2233  105    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      2234  105    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      2235  105    Cm  C03   1.07000 25,000_cells + HCMEC D3_line         0
      2236  105    Cm  D01   1.10000 20,000_cells + HCMEC D3_line         0
      2237  105    Cm  D02   1.08000 20,000_cells + HCMEC D3_line         0
      2238  105    Cm  D03   1.11000 20,000_cells + HCMEC D3_line         0
      2239  105    Cm  E01   1.09000 15,000_cells + HCMEC D3_line         0
      2240  105    Cm  E02   1.05000 15,000_cells + HCMEC D3_line         0
      2241  105    Cm  E03   1.08000 15,000_cells + HCMEC D3_line         0
      2242  105    Cm  F01   1.11000 10,000_cells + HCMEC D3_line         0
      2243  105    Cm  F02   1.38000 10,000_cells + HCMEC D3_line         0
      2244  105    Cm  F03   1.27000 10,000_cells + HCMEC D3_line         0
      2245  105    Cm  G01   7.29000  5,000_cells + HCMEC D3_line         0
      2246  105    Cm  G02   6.48000  5,000_cells + HCMEC D3_line         0
      2247  105    Cm  G03   4.86000  5,000_cells + HCMEC D3_line         0
      2248  105 Drift  A01  -5.35000 35,000_cells + HCMEC D3_line         0
      2249  105 Drift  A02  -5.67000 35,000_cells + HCMEC D3_line         0
      2250  105 Drift  A03  -5.12000 35,000_cells + HCMEC D3_line         0
      2251  105 Drift  B01  -5.90000 30,000_cells + HCMEC D3_line         0
      2252  105 Drift  B02  -6.17000 30,000_cells + HCMEC D3_line         0
      2253  105 Drift  B03  -5.67000 30,000_cells + HCMEC D3_line         0
      2254  105 Drift  C01  -6.23000 25,000_cells + HCMEC D3_line         0
      2255  105 Drift  C02  -6.48000 25,000_cells + HCMEC D3_line         0
      2256  105 Drift  C03  -5.92000 25,000_cells + HCMEC D3_line         0
      2257  105 Drift  D01  -6.01000 20,000_cells + HCMEC D3_line         0
      2258  105 Drift  D02  -6.36000 20,000_cells + HCMEC D3_line         0
      2259  105 Drift  D03  -5.53000 20,000_cells + HCMEC D3_line         0
      2260  105 Drift  E01  -4.92000 15,000_cells + HCMEC D3_line         0
      2261  105 Drift  E02  -5.28000 15,000_cells + HCMEC D3_line         0
      2262  105 Drift  E03  -5.08000 15,000_cells + HCMEC D3_line         0
      2263  105 Drift  F01  -4.92000 10,000_cells + HCMEC D3_line         0
      2264  105 Drift  F02  -5.01000 10,000_cells + HCMEC D3_line         0
      2265  105 Drift  F03  -4.65000 10,000_cells + HCMEC D3_line         0
      2266  105 Drift  G01  -4.12000  5,000_cells + HCMEC D3_line         0
      2267  105 Drift  G02  -4.28000  5,000_cells + HCMEC D3_line         0
      2268  105 Drift  G03  -3.73000  5,000_cells + HCMEC D3_line         0
      2269  105    Rb  A01   1.95000 35,000_cells + HCMEC D3_line         0
      2270  105    Rb  A02   2.04000 35,000_cells + HCMEC D3_line         0
      2271  105    Rb  A03   1.99000 35,000_cells + HCMEC D3_line         0
      2272  105    Rb  B01   2.25000 30,000_cells + HCMEC D3_line         0
      2273  105    Rb  B02   2.33000 30,000_cells + HCMEC D3_line         0
      2274  105    Rb  B03   2.28000 30,000_cells + HCMEC D3_line         0
      2275  105    Rb  C01   2.40000 25,000_cells + HCMEC D3_line         0
      2276  105    Rb  C02   2.43000 25,000_cells + HCMEC D3_line         0
      2277  105    Rb  C03   2.44000 25,000_cells + HCMEC D3_line         0
      2278  105    Rb  D01   2.45000 20,000_cells + HCMEC D3_line         0
      2279  105    Rb  D02   2.55000 20,000_cells + HCMEC D3_line         0
      2280  105    Rb  D03   2.42000 20,000_cells + HCMEC D3_line         0
      2281  105    Rb  E01   2.54000 15,000_cells + HCMEC D3_line         0
      2282  105    Rb  E02   2.49000 15,000_cells + HCMEC D3_line         0
      2283  105    Rb  E03   2.50000 15,000_cells + HCMEC D3_line         0
      2284  105    Rb  F01   2.29000 10,000_cells + HCMEC D3_line         0
      2285  105    Rb  F02   1.29000 10,000_cells + HCMEC D3_line         0
      2286  105    Rb  F03   1.74000 10,000_cells + HCMEC D3_line         0
      2287  105    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2288  105    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2289  105    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2290  105  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2291  105  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2292  105  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2293  105  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2294  105  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2295  105  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2296  105  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2297  105  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2298  105  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2299  105  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2300  105  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2301  105  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2302  105  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2303  105  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2304  105  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2305  105  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2306  105  RMSE  F02   0.02000 10,000_cells + HCMEC D3_line         0
      2307  105  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      2308  105  RMSE  G01   0.05000  5,000_cells + HCMEC D3_line         0
      2309  105  RMSE  G02   0.05000  5,000_cells + HCMEC D3_line         0
      2310  105  RMSE  G03   0.04000  5,000_cells + HCMEC D3_line         0
      2311  110 Alpha  A01   3.49000 35,000_cells + HCMEC D3_line         0
      2312  110 Alpha  A02   3.52000 35,000_cells + HCMEC D3_line         0
      2313  110 Alpha  A03   3.50000 35,000_cells + HCMEC D3_line         0
      2314  110 Alpha  B01   3.79000 30,000_cells + HCMEC D3_line         0
      2315  110 Alpha  B02   3.88000 30,000_cells + HCMEC D3_line         0
      2316  110 Alpha  B03   3.79000 30,000_cells + HCMEC D3_line         0
      2317  110 Alpha  C01   3.91000 25,000_cells + HCMEC D3_line         0
      2318  110 Alpha  C02   3.97000 25,000_cells + HCMEC D3_line         0
      2319  110 Alpha  C03   3.96000 25,000_cells + HCMEC D3_line         0
      2320  110 Alpha  D01   4.16000 20,000_cells + HCMEC D3_line         0
      2321  110 Alpha  D02   4.16000 20,000_cells + HCMEC D3_line         0
      2322  110 Alpha  D03   4.09000 20,000_cells + HCMEC D3_line         0
      2323  110 Alpha  E01   4.30000 15,000_cells + HCMEC D3_line         0
      2324  110 Alpha  E02   4.38000 15,000_cells + HCMEC D3_line         0
      2325  110 Alpha  E03   4.35000 15,000_cells + HCMEC D3_line         0
      2326  110 Alpha  F01   4.55000 10,000_cells + HCMEC D3_line         0
      2327  110 Alpha  F02   5.09000 10,000_cells + HCMEC D3_line         0
      2328  110 Alpha  F03   4.69000 10,000_cells + HCMEC D3_line         0
      2329  110 Alpha  G01   4.43000  5,000_cells + HCMEC D3_line         0
      2330  110 Alpha  G02   4.53000  5,000_cells + HCMEC D3_line         0
      2331  110 Alpha  G03   4.58000  5,000_cells + HCMEC D3_line         0
      2332  110    Cm  A01   1.22000 35,000_cells + HCMEC D3_line         0
      2333  110    Cm  A02   1.14000 35,000_cells + HCMEC D3_line         0
      2334  110    Cm  A03   1.15000 35,000_cells + HCMEC D3_line         0
      2335  110    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      2336  110    Cm  B02   1.09000 30,000_cells + HCMEC D3_line         0
      2337  110    Cm  B03   1.10000 30,000_cells + HCMEC D3_line         0
      2338  110    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      2339  110    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      2340  110    Cm  C03   1.09000 25,000_cells + HCMEC D3_line         0
      2341  110    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      2342  110    Cm  D02   1.07000 20,000_cells + HCMEC D3_line         0
      2343  110    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      2344  110    Cm  E01   1.08000 15,000_cells + HCMEC D3_line         0
      2345  110    Cm  E02   1.05000 15,000_cells + HCMEC D3_line         0
      2346  110    Cm  E03   1.06000 15,000_cells + HCMEC D3_line         0
      2347  110    Cm  F01   1.08000 10,000_cells + HCMEC D3_line         0
      2348  110    Cm  F02   1.27000 10,000_cells + HCMEC D3_line         0
      2349  110    Cm  F03   1.13000 10,000_cells + HCMEC D3_line         0
      2350  110    Cm  G01   5.95000  5,000_cells + HCMEC D3_line         0
      2351  110    Cm  G02   5.27000  5,000_cells + HCMEC D3_line         0
      2352  110    Cm  G03   3.67000  5,000_cells + HCMEC D3_line         0
      2353  110 Drift  A01  -5.32000 35,000_cells + HCMEC D3_line         0
      2354  110 Drift  A02  -5.64000 35,000_cells + HCMEC D3_line         0
      2355  110 Drift  A03  -5.10000 35,000_cells + HCMEC D3_line         0
      2356  110 Drift  B01  -5.88000 30,000_cells + HCMEC D3_line         0
      2357  110 Drift  B02  -6.16000 30,000_cells + HCMEC D3_line         0
      2358  110 Drift  B03  -5.66000 30,000_cells + HCMEC D3_line         0
      2359  110 Drift  C01  -6.20000 25,000_cells + HCMEC D3_line         0
      2360  110 Drift  C02  -6.47000 25,000_cells + HCMEC D3_line         0
      2361  110 Drift  C03  -5.92000 25,000_cells + HCMEC D3_line         0
      2362  110 Drift  D01  -6.00000 20,000_cells + HCMEC D3_line         0
      2363  110 Drift  D02  -6.31000 20,000_cells + HCMEC D3_line         0
      2364  110 Drift  D03  -5.52000 20,000_cells + HCMEC D3_line         0
      2365  110 Drift  E01  -4.91000 15,000_cells + HCMEC D3_line         0
      2366  110 Drift  E02  -5.28000 15,000_cells + HCMEC D3_line         0
      2367  110 Drift  E03  -5.05000 15,000_cells + HCMEC D3_line         0
      2368  110 Drift  F01  -4.90000 10,000_cells + HCMEC D3_line         0
      2369  110 Drift  F02  -5.01000 10,000_cells + HCMEC D3_line         0
      2370  110 Drift  F03  -4.65000 10,000_cells + HCMEC D3_line         0
      2371  110 Drift  G01  -4.16000  5,000_cells + HCMEC D3_line         0
      2372  110 Drift  G02  -4.28000  5,000_cells + HCMEC D3_line         0
      2373  110 Drift  G03  -3.77000  5,000_cells + HCMEC D3_line         0
      2374  110    Rb  A01   1.81000 35,000_cells + HCMEC D3_line         0
      2375  110    Rb  A02   1.98000 35,000_cells + HCMEC D3_line         0
      2376  110    Rb  A03   1.91000 35,000_cells + HCMEC D3_line         0
      2377  110    Rb  B01   2.17000 30,000_cells + HCMEC D3_line         0
      2378  110    Rb  B02   2.19000 30,000_cells + HCMEC D3_line         0
      2379  110    Rb  B03   2.12000 30,000_cells + HCMEC D3_line         0
      2380  110    Rb  C01   2.32000 25,000_cells + HCMEC D3_line         0
      2381  110    Rb  C02   2.36000 25,000_cells + HCMEC D3_line         0
      2382  110    Rb  C03   2.27000 25,000_cells + HCMEC D3_line         0
      2383  110    Rb  D01   2.39000 20,000_cells + HCMEC D3_line         0
      2384  110    Rb  D02   2.49000 20,000_cells + HCMEC D3_line         0
      2385  110    Rb  D03   2.35000 20,000_cells + HCMEC D3_line         0
      2386  110    Rb  E01   2.55000 15,000_cells + HCMEC D3_line         0
      2387  110    Rb  E02   2.46000 15,000_cells + HCMEC D3_line         0
      2388  110    Rb  E03   2.52000 15,000_cells + HCMEC D3_line         0
      2389  110    Rb  F01   2.41000 10,000_cells + HCMEC D3_line         0
      2390  110    Rb  F02   1.65000 10,000_cells + HCMEC D3_line         0
      2391  110    Rb  F03   2.17000 10,000_cells + HCMEC D3_line         0
      2392  110    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2393  110    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2394  110    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2395  110  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2396  110  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2397  110  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2398  110  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2399  110  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2400  110  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2401  110  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2402  110  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2403  110  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2404  110  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2405  110  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2406  110  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2407  110  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2408  110  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2409  110  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2410  110  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2411  110  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      2412  110  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      2413  110  RMSE  G01   0.05000  5,000_cells + HCMEC D3_line         0
      2414  110  RMSE  G02   0.05000  5,000_cells + HCMEC D3_line         0
      2415  110  RMSE  G03   0.04000  5,000_cells + HCMEC D3_line         0
      2416  115 Alpha  A01   3.45000 35,000_cells + HCMEC D3_line         0
      2417  115 Alpha  A02   3.48000 35,000_cells + HCMEC D3_line         0
      2418  115 Alpha  A03   3.42000 35,000_cells + HCMEC D3_line         0
      2419  115 Alpha  B01   3.72000 30,000_cells + HCMEC D3_line         0
      2420  115 Alpha  B02   3.80000 30,000_cells + HCMEC D3_line         0
      2421  115 Alpha  B03   3.72000 30,000_cells + HCMEC D3_line         0
      2422  115 Alpha  C01   3.85000 25,000_cells + HCMEC D3_line         0
      2423  115 Alpha  C02   3.89000 25,000_cells + HCMEC D3_line         0
      2424  115 Alpha  C03   3.89000 25,000_cells + HCMEC D3_line         0
      2425  115 Alpha  D01   4.12000 20,000_cells + HCMEC D3_line         0
      2426  115 Alpha  D02   4.14000 20,000_cells + HCMEC D3_line         0
      2427  115 Alpha  D03   4.03000 20,000_cells + HCMEC D3_line         0
      2428  115 Alpha  E01   4.20000 15,000_cells + HCMEC D3_line         0
      2429  115 Alpha  E02   4.29000 15,000_cells + HCMEC D3_line         0
      2430  115 Alpha  E03   4.26000 15,000_cells + HCMEC D3_line         0
      2431  115 Alpha  F01   4.44000 10,000_cells + HCMEC D3_line         0
      2432  115 Alpha  F02   4.90000 10,000_cells + HCMEC D3_line         0
      2433  115 Alpha  F03   4.53000 10,000_cells + HCMEC D3_line         0
      2434  115 Alpha  G01   4.60000  5,000_cells + HCMEC D3_line         0
      2435  115 Alpha  G02   4.70000  5,000_cells + HCMEC D3_line         0
      2436  115 Alpha  G03   4.70000  5,000_cells + HCMEC D3_line         0
      2437  115    Cm  A01   1.22000 35,000_cells + HCMEC D3_line         0
      2438  115    Cm  A02   1.15000 35,000_cells + HCMEC D3_line         0
      2439  115    Cm  A03   1.17000 35,000_cells + HCMEC D3_line         0
      2440  115    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      2441  115    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      2442  115    Cm  B03   1.09000 30,000_cells + HCMEC D3_line         0
      2443  115    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      2444  115    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      2445  115    Cm  C03   1.08000 25,000_cells + HCMEC D3_line         0
      2446  115    Cm  D01   1.09000 20,000_cells + HCMEC D3_line         0
      2447  115    Cm  D02   1.07000 20,000_cells + HCMEC D3_line         0
      2448  115    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      2449  115    Cm  E01   1.07000 15,000_cells + HCMEC D3_line         0
      2450  115    Cm  E02   1.06000 15,000_cells + HCMEC D3_line         0
      2451  115    Cm  E03   1.05000 15,000_cells + HCMEC D3_line         0
      2452  115    Cm  F01   1.07000 10,000_cells + HCMEC D3_line         0
      2453  115    Cm  F02   1.21000 10,000_cells + HCMEC D3_line         0
      2454  115    Cm  F03   1.06000 10,000_cells + HCMEC D3_line         0
      2455  115    Cm  G01   4.63000  5,000_cells + HCMEC D3_line         0
      2456  115    Cm  G02   4.32000  5,000_cells + HCMEC D3_line         0
      2457  115    Cm  G03   3.10000  5,000_cells + HCMEC D3_line         0
      2458  115 Drift  A01  -5.26000 35,000_cells + HCMEC D3_line         0
      2459  115 Drift  A02  -5.59000 35,000_cells + HCMEC D3_line         0
      2460  115 Drift  A03  -5.03000 35,000_cells + HCMEC D3_line         0
      2461  115 Drift  B01  -5.85000 30,000_cells + HCMEC D3_line         0
      2462  115 Drift  B02  -6.10000 30,000_cells + HCMEC D3_line         0
      2463  115 Drift  B03  -5.62000 30,000_cells + HCMEC D3_line         0
      2464  115 Drift  C01  -6.17000 25,000_cells + HCMEC D3_line         0
      2465  115 Drift  C02  -6.44000 25,000_cells + HCMEC D3_line         0
      2466  115 Drift  C03  -5.88000 25,000_cells + HCMEC D3_line         0
      2467  115 Drift  D01  -5.96000 20,000_cells + HCMEC D3_line         0
      2468  115 Drift  D02  -6.25000 20,000_cells + HCMEC D3_line         0
      2469  115 Drift  D03  -5.48000 20,000_cells + HCMEC D3_line         0
      2470  115 Drift  E01  -4.86000 15,000_cells + HCMEC D3_line         0
      2471  115 Drift  E02  -5.26000 15,000_cells + HCMEC D3_line         0
      2472  115 Drift  E03  -5.00000 15,000_cells + HCMEC D3_line         0
      2473  115 Drift  F01  -4.85000 10,000_cells + HCMEC D3_line         0
      2474  115 Drift  F02  -4.96000 10,000_cells + HCMEC D3_line         0
      2475  115 Drift  F03  -4.59000 10,000_cells + HCMEC D3_line         0
      2476  115 Drift  G01  -4.15000  5,000_cells + HCMEC D3_line         0
      2477  115 Drift  G02  -4.28000  5,000_cells + HCMEC D3_line         0
      2478  115 Drift  G03  -3.81000  5,000_cells + HCMEC D3_line         0
      2479  115    Rb  A01   1.75000 35,000_cells + HCMEC D3_line         0
      2480  115    Rb  A02   1.86000 35,000_cells + HCMEC D3_line         0
      2481  115    Rb  A03   1.80000 35,000_cells + HCMEC D3_line         0
      2482  115    Rb  B01   2.11000 30,000_cells + HCMEC D3_line         0
      2483  115    Rb  B02   2.09000 30,000_cells + HCMEC D3_line         0
      2484  115    Rb  B03   2.05000 30,000_cells + HCMEC D3_line         0
      2485  115    Rb  C01   2.22000 25,000_cells + HCMEC D3_line         0
      2486  115    Rb  C02   2.27000 25,000_cells + HCMEC D3_line         0
      2487  115    Rb  C03   2.20000 25,000_cells + HCMEC D3_line         0
      2488  115    Rb  D01   2.23000 20,000_cells + HCMEC D3_line         0
      2489  115    Rb  D02   2.35000 20,000_cells + HCMEC D3_line         0
      2490  115    Rb  D03   2.22000 20,000_cells + HCMEC D3_line         0
      2491  115    Rb  E01   2.47000 15,000_cells + HCMEC D3_line         0
      2492  115    Rb  E02   2.35000 15,000_cells + HCMEC D3_line         0
      2493  115    Rb  E03   2.52000 15,000_cells + HCMEC D3_line         0
      2494  115    Rb  F01   2.41000 10,000_cells + HCMEC D3_line         0
      2495  115    Rb  F02   1.83000 10,000_cells + HCMEC D3_line         0
      2496  115    Rb  F03   2.34000 10,000_cells + HCMEC D3_line         0
      2497  115    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2498  115    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2499  115    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2500  115  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2501  115  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2502  115  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2503  115  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2504  115  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2505  115  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2506  115  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2507  115  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2508  115  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2509  115  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2510  115  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2511  115  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2512  115  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2513  115  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2514  115  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2515  115  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2516  115  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      2517  115  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      2518  115  RMSE  G01   0.04000  5,000_cells + HCMEC D3_line         0
      2519  115  RMSE  G02   0.04000  5,000_cells + HCMEC D3_line         0
      2520  115  RMSE  G03   0.03000  5,000_cells + HCMEC D3_line         0
      2521  120 Alpha  A01   3.43000 35,000_cells + HCMEC D3_line         0
      2522  120 Alpha  A02   3.45000 35,000_cells + HCMEC D3_line         0
      2523  120 Alpha  A03   3.39000 35,000_cells + HCMEC D3_line         0
      2524  120 Alpha  B01   3.70000 30,000_cells + HCMEC D3_line         0
      2525  120 Alpha  B02   3.76000 30,000_cells + HCMEC D3_line         0
      2526  120 Alpha  B03   3.66000 30,000_cells + HCMEC D3_line         0
      2527  120 Alpha  C01   3.81000 25,000_cells + HCMEC D3_line         0
      2528  120 Alpha  C02   3.85000 25,000_cells + HCMEC D3_line         0
      2529  120 Alpha  C03   3.82000 25,000_cells + HCMEC D3_line         0
      2530  120 Alpha  D01   4.05000 20,000_cells + HCMEC D3_line         0
      2531  120 Alpha  D02   4.08000 20,000_cells + HCMEC D3_line         0
      2532  120 Alpha  D03   3.95000 20,000_cells + HCMEC D3_line         0
      2533  120 Alpha  E01   4.12000 15,000_cells + HCMEC D3_line         0
      2534  120 Alpha  E02   4.23000 15,000_cells + HCMEC D3_line         0
      2535  120 Alpha  E03   4.22000 15,000_cells + HCMEC D3_line         0
      2536  120 Alpha  F01   4.38000 10,000_cells + HCMEC D3_line         0
      2537  120 Alpha  F02   4.66000 10,000_cells + HCMEC D3_line         0
      2538  120 Alpha  F03   4.44000 10,000_cells + HCMEC D3_line         0
      2539  120 Alpha  G01   4.74000  5,000_cells + HCMEC D3_line         0
      2540  120 Alpha  G02   4.85000  5,000_cells + HCMEC D3_line         0
      2541  120 Alpha  G03   4.87000  5,000_cells + HCMEC D3_line         0
      2542  120    Cm  A01   1.23000 35,000_cells + HCMEC D3_line         0
      2543  120    Cm  A02   1.14000 35,000_cells + HCMEC D3_line         0
      2544  120    Cm  A03   1.18000 35,000_cells + HCMEC D3_line         0
      2545  120    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      2546  120    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      2547  120    Cm  B03   1.10000 30,000_cells + HCMEC D3_line         0
      2548  120    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      2549  120    Cm  C02   1.06000 25,000_cells + HCMEC D3_line         0
      2550  120    Cm  C03   1.09000 25,000_cells + HCMEC D3_line         0
      2551  120    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      2552  120    Cm  D02   1.08000 20,000_cells + HCMEC D3_line         0
      2553  120    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      2554  120    Cm  E01   1.08000 15,000_cells + HCMEC D3_line         0
      2555  120    Cm  E02   1.04000 15,000_cells + HCMEC D3_line         0
      2556  120    Cm  E03   1.06000 15,000_cells + HCMEC D3_line         0
      2557  120    Cm  F01   1.08000 10,000_cells + HCMEC D3_line         0
      2558  120    Cm  F02   1.12000 10,000_cells + HCMEC D3_line         0
      2559  120    Cm  F03   1.05000 10,000_cells + HCMEC D3_line         0
      2560  120    Cm  G01   3.73000  5,000_cells + HCMEC D3_line         0
      2561  120    Cm  G02   3.47000  5,000_cells + HCMEC D3_line         0
      2562  120    Cm  G03   2.36000  5,000_cells + HCMEC D3_line         0
      2563  120 Drift  A01  -5.20000 35,000_cells + HCMEC D3_line         0
      2564  120 Drift  A02  -5.53000 35,000_cells + HCMEC D3_line         0
      2565  120 Drift  A03  -4.97000 35,000_cells + HCMEC D3_line         0
      2566  120 Drift  B01  -5.79000 30,000_cells + HCMEC D3_line         0
      2567  120 Drift  B02  -6.06000 30,000_cells + HCMEC D3_line         0
      2568  120 Drift  B03  -5.57000 30,000_cells + HCMEC D3_line         0
      2569  120 Drift  C01  -6.11000 25,000_cells + HCMEC D3_line         0
      2570  120 Drift  C02  -6.39000 25,000_cells + HCMEC D3_line         0
      2571  120 Drift  C03  -5.83000 25,000_cells + HCMEC D3_line         0
      2572  120 Drift  D01  -5.93000 20,000_cells + HCMEC D3_line         0
      2573  120 Drift  D02  -6.20000 20,000_cells + HCMEC D3_line         0
      2574  120 Drift  D03  -5.44000 20,000_cells + HCMEC D3_line         0
      2575  120 Drift  E01  -4.82000 15,000_cells + HCMEC D3_line         0
      2576  120 Drift  E02  -5.22000 15,000_cells + HCMEC D3_line         0
      2577  120 Drift  E03  -4.97000 15,000_cells + HCMEC D3_line         0
      2578  120 Drift  F01  -4.81000 10,000_cells + HCMEC D3_line         0
      2579  120 Drift  F02  -4.93000 10,000_cells + HCMEC D3_line         0
      2580  120 Drift  F03  -4.54000 10,000_cells + HCMEC D3_line         0
      2581  120 Drift  G01  -4.11000  5,000_cells + HCMEC D3_line         0
      2582  120 Drift  G02  -4.27000  5,000_cells + HCMEC D3_line         0
      2583  120 Drift  G03  -3.77000  5,000_cells + HCMEC D3_line         0
      2584  120    Rb  A01   1.65000 35,000_cells + HCMEC D3_line         0
      2585  120    Rb  A02   1.77000 35,000_cells + HCMEC D3_line         0
      2586  120    Rb  A03   1.71000 35,000_cells + HCMEC D3_line         0
      2587  120    Rb  B01   1.96000 30,000_cells + HCMEC D3_line         0
      2588  120    Rb  B02   2.00000 30,000_cells + HCMEC D3_line         0
      2589  120    Rb  B03   1.96000 30,000_cells + HCMEC D3_line         0
      2590  120    Rb  C01   2.10000 25,000_cells + HCMEC D3_line         0
      2591  120    Rb  C02   2.15000 25,000_cells + HCMEC D3_line         0
      2592  120    Rb  C03   2.07000 25,000_cells + HCMEC D3_line         0
      2593  120    Rb  D01   2.14000 20,000_cells + HCMEC D3_line         0
      2594  120    Rb  D02   2.17000 20,000_cells + HCMEC D3_line         0
      2595  120    Rb  D03   2.14000 20,000_cells + HCMEC D3_line         0
      2596  120    Rb  E01   2.35000 15,000_cells + HCMEC D3_line         0
      2597  120    Rb  E02   2.31000 15,000_cells + HCMEC D3_line         0
      2598  120    Rb  E03   2.44000 15,000_cells + HCMEC D3_line         0
      2599  120    Rb  F01   2.37000 10,000_cells + HCMEC D3_line         0
      2600  120    Rb  F02   2.03000 10,000_cells + HCMEC D3_line         0
      2601  120    Rb  F03   2.30000 10,000_cells + HCMEC D3_line         0
      2602  120    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2603  120    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2604  120    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2605  120  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2606  120  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2607  120  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2608  120  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2609  120  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2610  120  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2611  120  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2612  120  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2613  120  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2614  120  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2615  120  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2616  120  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2617  120  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2618  120  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2619  120  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2620  120  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2621  120  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      2622  120  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      2623  120  RMSE  G01   0.04000  5,000_cells + HCMEC D3_line         0
      2624  120  RMSE  G02   0.04000  5,000_cells + HCMEC D3_line         0
      2625  120  RMSE  G03   0.03000  5,000_cells + HCMEC D3_line         0
      2626  125 Alpha  A01   3.38000 35,000_cells + HCMEC D3_line         0
      2627  125 Alpha  A02   3.40000 35,000_cells + HCMEC D3_line         0
      2628  125 Alpha  A03   3.36000 35,000_cells + HCMEC D3_line         0
      2629  125 Alpha  B01   3.63000 30,000_cells + HCMEC D3_line         0
      2630  125 Alpha  B02   3.69000 30,000_cells + HCMEC D3_line         0
      2631  125 Alpha  B03   3.60000 30,000_cells + HCMEC D3_line         0
      2632  125 Alpha  C01   3.77000 25,000_cells + HCMEC D3_line         0
      2633  125 Alpha  C02   3.82000 25,000_cells + HCMEC D3_line         0
      2634  125 Alpha  C03   3.81000 25,000_cells + HCMEC D3_line         0
      2635  125 Alpha  D01   3.99000 20,000_cells + HCMEC D3_line         0
      2636  125 Alpha  D02   4.01000 20,000_cells + HCMEC D3_line         0
      2637  125 Alpha  D03   3.93000 20,000_cells + HCMEC D3_line         0
      2638  125 Alpha  E01   4.08000 15,000_cells + HCMEC D3_line         0
      2639  125 Alpha  E02   4.19000 15,000_cells + HCMEC D3_line         0
      2640  125 Alpha  E03   4.13000 15,000_cells + HCMEC D3_line         0
      2641  125 Alpha  F01   4.34000 10,000_cells + HCMEC D3_line         0
      2642  125 Alpha  F02   4.55000 10,000_cells + HCMEC D3_line         0
      2643  125 Alpha  F03   4.37000 10,000_cells + HCMEC D3_line         0
      2644  125 Alpha  G01   4.80000  5,000_cells + HCMEC D3_line         0
      2645  125 Alpha  G02   5.03000  5,000_cells + HCMEC D3_line         0
      2646  125 Alpha  G03   4.92000  5,000_cells + HCMEC D3_line         0
      2647  125    Cm  A01   1.24000 35,000_cells + HCMEC D3_line         0
      2648  125    Cm  A02   1.14000 35,000_cells + HCMEC D3_line         0
      2649  125    Cm  A03   1.18000 35,000_cells + HCMEC D3_line         0
      2650  125    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      2651  125    Cm  B02   1.09000 30,000_cells + HCMEC D3_line         0
      2652  125    Cm  B03   1.10000 30,000_cells + HCMEC D3_line         0
      2653  125    Cm  C01   1.09000 25,000_cells + HCMEC D3_line         0
      2654  125    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      2655  125    Cm  C03   1.08000 25,000_cells + HCMEC D3_line         0
      2656  125    Cm  D01   1.09000 20,000_cells + HCMEC D3_line         0
      2657  125    Cm  D02   1.07000 20,000_cells + HCMEC D3_line         0
      2658  125    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      2659  125    Cm  E01   1.09000 15,000_cells + HCMEC D3_line         0
      2660  125    Cm  E02   1.06000 15,000_cells + HCMEC D3_line         0
      2661  125    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      2662  125    Cm  F01   1.10000 10,000_cells + HCMEC D3_line         0
      2663  125    Cm  F02   1.08000 10,000_cells + HCMEC D3_line         0
      2664  125    Cm  F03   1.05000 10,000_cells + HCMEC D3_line         0
      2665  125    Cm  G01   3.19000  5,000_cells + HCMEC D3_line         0
      2666  125    Cm  G02   2.67000  5,000_cells + HCMEC D3_line         0
      2667  125    Cm  G03   2.19000  5,000_cells + HCMEC D3_line         0
      2668  125 Drift  A01  -5.11000 35,000_cells + HCMEC D3_line         0
      2669  125 Drift  A02  -5.45000 35,000_cells + HCMEC D3_line         0
      2670  125 Drift  A03  -4.87000 35,000_cells + HCMEC D3_line         0
      2671  125 Drift  B01  -5.72000 30,000_cells + HCMEC D3_line         0
      2672  125 Drift  B02  -5.98000 30,000_cells + HCMEC D3_line         0
      2673  125 Drift  B03  -5.48000 30,000_cells + HCMEC D3_line         0
      2674  125 Drift  C01  -6.04000 25,000_cells + HCMEC D3_line         0
      2675  125 Drift  C02  -6.32000 25,000_cells + HCMEC D3_line         0
      2676  125 Drift  C03  -5.76000 25,000_cells + HCMEC D3_line         0
      2677  125 Drift  D01  -5.85000 20,000_cells + HCMEC D3_line         0
      2678  125 Drift  D02  -6.10000 20,000_cells + HCMEC D3_line         0
      2679  125 Drift  D03  -5.37000 20,000_cells + HCMEC D3_line         0
      2680  125 Drift  E01  -4.75000 15,000_cells + HCMEC D3_line         0
      2681  125 Drift  E02  -5.18000 15,000_cells + HCMEC D3_line         0
      2682  125 Drift  E03  -4.87000 15,000_cells + HCMEC D3_line         0
      2683  125 Drift  F01  -4.74000 10,000_cells + HCMEC D3_line         0
      2684  125 Drift  F02  -4.88000 10,000_cells + HCMEC D3_line         0
      2685  125 Drift  F03  -4.47000 10,000_cells + HCMEC D3_line         0
      2686  125 Drift  G01  -4.04000  5,000_cells + HCMEC D3_line         0
      2687  125 Drift  G02  -4.20000  5,000_cells + HCMEC D3_line         0
      2688  125 Drift  G03  -3.67000  5,000_cells + HCMEC D3_line         0
      2689  125    Rb  A01   1.53000 35,000_cells + HCMEC D3_line         0
      2690  125    Rb  A02   1.68000 35,000_cells + HCMEC D3_line         0
      2691  125    Rb  A03   1.64000 35,000_cells + HCMEC D3_line         0
      2692  125    Rb  B01   1.91000 30,000_cells + HCMEC D3_line         0
      2693  125    Rb  B02   1.92000 30,000_cells + HCMEC D3_line         0
      2694  125    Rb  B03   1.89000 30,000_cells + HCMEC D3_line         0
      2695  125    Rb  C01   1.99000 25,000_cells + HCMEC D3_line         0
      2696  125    Rb  C02   2.01000 25,000_cells + HCMEC D3_line         0
      2697  125    Rb  C03   2.02000 25,000_cells + HCMEC D3_line         0
      2698  125    Rb  D01   1.98000 20,000_cells + HCMEC D3_line         0
      2699  125    Rb  D02   2.07000 20,000_cells + HCMEC D3_line         0
      2700  125    Rb  D03   2.04000 20,000_cells + HCMEC D3_line         0
      2701  125    Rb  E01   2.23000 15,000_cells + HCMEC D3_line         0
      2702  125    Rb  E02   2.20000 15,000_cells + HCMEC D3_line         0
      2703  125    Rb  E03   2.27000 15,000_cells + HCMEC D3_line         0
      2704  125    Rb  F01   2.30000 10,000_cells + HCMEC D3_line         0
      2705  125    Rb  F02   2.15000 10,000_cells + HCMEC D3_line         0
      2706  125    Rb  F03   2.35000 10,000_cells + HCMEC D3_line         0
      2707  125    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2708  125    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2709  125    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2710  125  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2711  125  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2712  125  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2713  125  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2714  125  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2715  125  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2716  125  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2717  125  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2718  125  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2719  125  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2720  125  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2721  125  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2722  125  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2723  125  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2724  125  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2725  125  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2726  125  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      2727  125  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      2728  125  RMSE  G01   0.04000  5,000_cells + HCMEC D3_line         0
      2729  125  RMSE  G02   0.03000  5,000_cells + HCMEC D3_line         0
      2730  125  RMSE  G03   0.03000  5,000_cells + HCMEC D3_line         0
      2731  130 Alpha  A01   3.30000 35,000_cells + HCMEC D3_line         0
      2732  130 Alpha  A02   3.35000 35,000_cells + HCMEC D3_line         0
      2733  130 Alpha  A03   3.32000 35,000_cells + HCMEC D3_line         0
      2734  130 Alpha  B01   3.56000 30,000_cells + HCMEC D3_line         0
      2735  130 Alpha  B02   3.63000 30,000_cells + HCMEC D3_line         0
      2736  130 Alpha  B03   3.56000 30,000_cells + HCMEC D3_line         0
      2737  130 Alpha  C01   3.73000 25,000_cells + HCMEC D3_line         0
      2738  130 Alpha  C02   3.77000 25,000_cells + HCMEC D3_line         0
      2739  130 Alpha  C03   3.77000 25,000_cells + HCMEC D3_line         0
      2740  130 Alpha  D01   3.89000 20,000_cells + HCMEC D3_line         0
      2741  130 Alpha  D02   3.91000 20,000_cells + HCMEC D3_line         0
      2742  130 Alpha  D03   3.86000 20,000_cells + HCMEC D3_line         0
      2743  130 Alpha  E01   4.05000 15,000_cells + HCMEC D3_line         0
      2744  130 Alpha  E02   4.12000 15,000_cells + HCMEC D3_line         0
      2745  130 Alpha  E03   4.06000 15,000_cells + HCMEC D3_line         0
      2746  130 Alpha  F01   4.26000 10,000_cells + HCMEC D3_line         0
      2747  130 Alpha  F02   4.48000 10,000_cells + HCMEC D3_line         0
      2748  130 Alpha  F03   4.34000 10,000_cells + HCMEC D3_line         0
      2749  130 Alpha  G01   5.00000  5,000_cells + HCMEC D3_line         0
      2750  130 Alpha  G02   5.24000  5,000_cells + HCMEC D3_line         0
      2751  130 Alpha  G03   5.06000  5,000_cells + HCMEC D3_line         0
      2752  130    Cm  A01   1.26000 35,000_cells + HCMEC D3_line         0
      2753  130    Cm  A02   1.16000 35,000_cells + HCMEC D3_line         0
      2754  130    Cm  A03   1.18000 35,000_cells + HCMEC D3_line         0
      2755  130    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      2756  130    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      2757  130    Cm  B03   1.11000 30,000_cells + HCMEC D3_line         0
      2758  130    Cm  C01   1.09000 25,000_cells + HCMEC D3_line         0
      2759  130    Cm  C02   1.06000 25,000_cells + HCMEC D3_line         0
      2760  130    Cm  C03   1.09000 25,000_cells + HCMEC D3_line         0
      2761  130    Cm  D01   1.09000 20,000_cells + HCMEC D3_line         0
      2762  130    Cm  D02   1.07000 20,000_cells + HCMEC D3_line         0
      2763  130    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      2764  130    Cm  E01   1.09000 15,000_cells + HCMEC D3_line         0
      2765  130    Cm  E02   1.06000 15,000_cells + HCMEC D3_line         0
      2766  130    Cm  E03   1.06000 15,000_cells + HCMEC D3_line         0
      2767  130    Cm  F01   1.07000 10,000_cells + HCMEC D3_line         0
      2768  130    Cm  F02   1.07000 10,000_cells + HCMEC D3_line         0
      2769  130    Cm  F03   1.05000 10,000_cells + HCMEC D3_line         0
      2770  130    Cm  G01   2.47000  5,000_cells + HCMEC D3_line         0
      2771  130    Cm  G02   2.07000  5,000_cells + HCMEC D3_line         0
      2772  130    Cm  G03   1.71000  5,000_cells + HCMEC D3_line         0
      2773  130 Drift  A01  -4.99000 35,000_cells + HCMEC D3_line         0
      2774  130 Drift  A02  -5.34000 35,000_cells + HCMEC D3_line         0
      2775  130 Drift  A03  -4.75000 35,000_cells + HCMEC D3_line         0
      2776  130 Drift  B01  -5.61000 30,000_cells + HCMEC D3_line         0
      2777  130 Drift  B02  -5.88000 30,000_cells + HCMEC D3_line         0
      2778  130 Drift  B03  -5.37000 30,000_cells + HCMEC D3_line         0
      2779  130 Drift  C01  -5.94000 25,000_cells + HCMEC D3_line         0
      2780  130 Drift  C02  -6.25000 25,000_cells + HCMEC D3_line         0
      2781  130 Drift  C03  -5.67000 25,000_cells + HCMEC D3_line         0
      2782  130 Drift  D01  -5.75000 20,000_cells + HCMEC D3_line         0
      2783  130 Drift  D02  -6.03000 20,000_cells + HCMEC D3_line         0
      2784  130 Drift  D03  -5.28000 20,000_cells + HCMEC D3_line         0
      2785  130 Drift  E01  -4.67000 15,000_cells + HCMEC D3_line         0
      2786  130 Drift  E02  -5.10000 15,000_cells + HCMEC D3_line         0
      2787  130 Drift  E03  -4.79000 15,000_cells + HCMEC D3_line         0
      2788  130 Drift  F01  -4.66000 10,000_cells + HCMEC D3_line         0
      2789  130 Drift  F02  -4.80000 10,000_cells + HCMEC D3_line         0
      2790  130 Drift  F03  -4.39000 10,000_cells + HCMEC D3_line         0
      2791  130 Drift  G01  -3.97000  5,000_cells + HCMEC D3_line         0
      2792  130 Drift  G02  -4.13000  5,000_cells + HCMEC D3_line         0
      2793  130 Drift  G03  -3.57000  5,000_cells + HCMEC D3_line         0
      2794  130    Rb  A01   1.46000 35,000_cells + HCMEC D3_line         0
      2795  130    Rb  A02   1.58000 35,000_cells + HCMEC D3_line         0
      2796  130    Rb  A03   1.53000 35,000_cells + HCMEC D3_line         0
      2797  130    Rb  B01   1.80000 30,000_cells + HCMEC D3_line         0
      2798  130    Rb  B02   1.84000 30,000_cells + HCMEC D3_line         0
      2799  130    Rb  B03   1.75000 30,000_cells + HCMEC D3_line         0
      2800  130    Rb  C01   1.88000 25,000_cells + HCMEC D3_line         0
      2801  130    Rb  C02   1.88000 25,000_cells + HCMEC D3_line         0
      2802  130    Rb  C03   1.88000 25,000_cells + HCMEC D3_line         0
      2803  130    Rb  D01   1.90000 20,000_cells + HCMEC D3_line         0
      2804  130    Rb  D02   1.98000 20,000_cells + HCMEC D3_line         0
      2805  130    Rb  D03   1.91000 20,000_cells + HCMEC D3_line         0
      2806  130    Rb  E01   2.19000 15,000_cells + HCMEC D3_line         0
      2807  130    Rb  E02   2.11000 15,000_cells + HCMEC D3_line         0
      2808  130    Rb  E03   2.23000 15,000_cells + HCMEC D3_line         0
      2809  130    Rb  F01   2.26000 10,000_cells + HCMEC D3_line         0
      2810  130    Rb  F02   2.12000 10,000_cells + HCMEC D3_line         0
      2811  130    Rb  F03   2.23000 10,000_cells + HCMEC D3_line         0
      2812  130    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2813  130    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2814  130    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2815  130  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2816  130  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2817  130  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2818  130  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2819  130  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2820  130  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2821  130  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2822  130  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2823  130  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2824  130  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2825  130  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2826  130  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2827  130  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2828  130  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2829  130  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2830  130  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2831  130  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      2832  130  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      2833  130  RMSE  G01   0.03000  5,000_cells + HCMEC D3_line         0
      2834  130  RMSE  G02   0.02000  5,000_cells + HCMEC D3_line         0
      2835  130  RMSE  G03   0.02000  5,000_cells + HCMEC D3_line         0
      2836  135 Alpha  A01   3.26000 35,000_cells + HCMEC D3_line         0
      2837  135 Alpha  A02   3.29000 35,000_cells + HCMEC D3_line         0
      2838  135 Alpha  A03   3.27000 35,000_cells + HCMEC D3_line         0
      2839  135 Alpha  B01   3.52000 30,000_cells + HCMEC D3_line         0
      2840  135 Alpha  B02   3.58000 30,000_cells + HCMEC D3_line         0
      2841  135 Alpha  B03   3.51000 30,000_cells + HCMEC D3_line         0
      2842  135 Alpha  C01   3.70000 25,000_cells + HCMEC D3_line         0
      2843  135 Alpha  C02   3.68000 25,000_cells + HCMEC D3_line         0
      2844  135 Alpha  C03   3.72000 25,000_cells + HCMEC D3_line         0
      2845  135 Alpha  D01   3.83000 20,000_cells + HCMEC D3_line         0
      2846  135 Alpha  D02   3.87000 20,000_cells + HCMEC D3_line         0
      2847  135 Alpha  D03   3.83000 20,000_cells + HCMEC D3_line         0
      2848  135 Alpha  E01   4.00000 15,000_cells + HCMEC D3_line         0
      2849  135 Alpha  E02   4.04000 15,000_cells + HCMEC D3_line         0
      2850  135 Alpha  E03   3.99000 15,000_cells + HCMEC D3_line         0
      2851  135 Alpha  F01   4.18000 10,000_cells + HCMEC D3_line         0
      2852  135 Alpha  F02   4.36000 10,000_cells + HCMEC D3_line         0
      2853  135 Alpha  F03   4.22000 10,000_cells + HCMEC D3_line         0
      2854  135 Alpha  G01   5.18000  5,000_cells + HCMEC D3_line         0
      2855  135 Alpha  G02   5.38000  5,000_cells + HCMEC D3_line         0
      2856  135 Alpha  G03   5.09000  5,000_cells + HCMEC D3_line         0
      2857  135    Cm  A01   1.26000 35,000_cells + HCMEC D3_line         0
      2858  135    Cm  A02   1.16000 35,000_cells + HCMEC D3_line         0
      2859  135    Cm  A03   1.19000 35,000_cells + HCMEC D3_line         0
      2860  135    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      2861  135    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      2862  135    Cm  B03   1.09000 30,000_cells + HCMEC D3_line         0
      2863  135    Cm  C01   1.09000 25,000_cells + HCMEC D3_line         0
      2864  135    Cm  C02   1.06000 25,000_cells + HCMEC D3_line         0
      2865  135    Cm  C03   1.09000 25,000_cells + HCMEC D3_line         0
      2866  135    Cm  D01   1.10000 20,000_cells + HCMEC D3_line         0
      2867  135    Cm  D02   1.07000 20,000_cells + HCMEC D3_line         0
      2868  135    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      2869  135    Cm  E01   1.07000 15,000_cells + HCMEC D3_line         0
      2870  135    Cm  E02   1.04000 15,000_cells + HCMEC D3_line         0
      2871  135    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      2872  135    Cm  F01   1.07000 10,000_cells + HCMEC D3_line         0
      2873  135    Cm  F02   1.06000 10,000_cells + HCMEC D3_line         0
      2874  135    Cm  F03   1.05000 10,000_cells + HCMEC D3_line         0
      2875  135    Cm  G01   2.05000  5,000_cells + HCMEC D3_line         0
      2876  135    Cm  G02   1.57000  5,000_cells + HCMEC D3_line         0
      2877  135    Cm  G03   1.46000  5,000_cells + HCMEC D3_line         0
      2878  135 Drift  A01  -4.88000 35,000_cells + HCMEC D3_line         0
      2879  135 Drift  A02  -5.21000 35,000_cells + HCMEC D3_line         0
      2880  135 Drift  A03  -4.62000 35,000_cells + HCMEC D3_line         0
      2881  135 Drift  B01  -5.51000 30,000_cells + HCMEC D3_line         0
      2882  135 Drift  B02  -5.78000 30,000_cells + HCMEC D3_line         0
      2883  135 Drift  B03  -5.27000 30,000_cells + HCMEC D3_line         0
      2884  135 Drift  C01  -5.86000 25,000_cells + HCMEC D3_line         0
      2885  135 Drift  C02  -6.14000 25,000_cells + HCMEC D3_line         0
      2886  135 Drift  C03  -5.58000 25,000_cells + HCMEC D3_line         0
      2887  135 Drift  D01  -5.66000 20,000_cells + HCMEC D3_line         0
      2888  135 Drift  D02  -5.90000 20,000_cells + HCMEC D3_line         0
      2889  135 Drift  D03  -5.20000 20,000_cells + HCMEC D3_line         0
      2890  135 Drift  E01  -4.59000 15,000_cells + HCMEC D3_line         0
      2891  135 Drift  E02  -5.01000 15,000_cells + HCMEC D3_line         0
      2892  135 Drift  E03  -4.68000 15,000_cells + HCMEC D3_line         0
      2893  135 Drift  F01  -4.57000 10,000_cells + HCMEC D3_line         0
      2894  135 Drift  F02  -4.70000 10,000_cells + HCMEC D3_line         0
      2895  135 Drift  F03  -4.29000 10,000_cells + HCMEC D3_line         0
      2896  135 Drift  G01  -3.87000  5,000_cells + HCMEC D3_line         0
      2897  135 Drift  G02  -4.05000  5,000_cells + HCMEC D3_line         0
      2898  135 Drift  G03  -3.43000  5,000_cells + HCMEC D3_line         0
      2899  135    Rb  A01   1.39000 35,000_cells + HCMEC D3_line         0
      2900  135    Rb  A02   1.52000 35,000_cells + HCMEC D3_line         0
      2901  135    Rb  A03   1.47000 35,000_cells + HCMEC D3_line         0
      2902  135    Rb  B01   1.70000 30,000_cells + HCMEC D3_line         0
      2903  135    Rb  B02   1.74000 30,000_cells + HCMEC D3_line         0
      2904  135    Rb  B03   1.72000 30,000_cells + HCMEC D3_line         0
      2905  135    Rb  C01   1.77000 25,000_cells + HCMEC D3_line         0
      2906  135    Rb  C02   1.80000 25,000_cells + HCMEC D3_line         0
      2907  135    Rb  C03   1.79000 25,000_cells + HCMEC D3_line         0
      2908  135    Rb  D01   1.76000 20,000_cells + HCMEC D3_line         0
      2909  135    Rb  D02   1.87000 20,000_cells + HCMEC D3_line         0
      2910  135    Rb  D03   1.81000 20,000_cells + HCMEC D3_line         0
      2911  135    Rb  E01   2.12000 15,000_cells + HCMEC D3_line         0
      2912  135    Rb  E02   2.08000 15,000_cells + HCMEC D3_line         0
      2913  135    Rb  E03   2.12000 15,000_cells + HCMEC D3_line         0
      2914  135    Rb  F01   2.22000 10,000_cells + HCMEC D3_line         0
      2915  135    Rb  F02   2.10000 10,000_cells + HCMEC D3_line         0
      2916  135    Rb  F03   2.25000 10,000_cells + HCMEC D3_line         0
      2917  135    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      2918  135    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      2919  135    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      2920  135  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      2921  135  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      2922  135  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      2923  135  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      2924  135  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      2925  135  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      2926  135  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      2927  135  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      2928  135  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      2929  135  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      2930  135  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      2931  135  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      2932  135  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      2933  135  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      2934  135  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      2935  135  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      2936  135  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      2937  135  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      2938  135  RMSE  G01   0.02000  5,000_cells + HCMEC D3_line         0
      2939  135  RMSE  G02   0.02000  5,000_cells + HCMEC D3_line         0
      2940  135  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      2941  140 Alpha  A01   3.22000 35,000_cells + HCMEC D3_line         0
      2942  140 Alpha  A02   3.24000 35,000_cells + HCMEC D3_line         0
      2943  140 Alpha  A03   3.24000 35,000_cells + HCMEC D3_line         0
      2944  140 Alpha  B01   3.45000 30,000_cells + HCMEC D3_line         0
      2945  140 Alpha  B02   3.53000 30,000_cells + HCMEC D3_line         0
      2946  140 Alpha  B03   3.48000 30,000_cells + HCMEC D3_line         0
      2947  140 Alpha  C01   3.64000 25,000_cells + HCMEC D3_line         0
      2948  140 Alpha  C02   3.65000 25,000_cells + HCMEC D3_line         0
      2949  140 Alpha  C03   3.71000 25,000_cells + HCMEC D3_line         0
      2950  140 Alpha  D01   3.83000 20,000_cells + HCMEC D3_line         0
      2951  140 Alpha  D02   3.89000 20,000_cells + HCMEC D3_line         0
      2952  140 Alpha  D03   3.80000 20,000_cells + HCMEC D3_line         0
      2953  140 Alpha  E01   3.93000 15,000_cells + HCMEC D3_line         0
      2954  140 Alpha  E02   4.01000 15,000_cells + HCMEC D3_line         0
      2955  140 Alpha  E03   3.92000 15,000_cells + HCMEC D3_line         0
      2956  140 Alpha  F01   4.10000 10,000_cells + HCMEC D3_line         0
      2957  140 Alpha  F02   4.29000 10,000_cells + HCMEC D3_line         0
      2958  140 Alpha  F03   4.19000 10,000_cells + HCMEC D3_line         0
      2959  140 Alpha  G01   5.25000  5,000_cells + HCMEC D3_line         0
      2960  140 Alpha  G02   5.41000  5,000_cells + HCMEC D3_line         0
      2961  140 Alpha  G03   5.17000  5,000_cells + HCMEC D3_line         0
      2962  140    Cm  A01   1.26000 35,000_cells + HCMEC D3_line         0
      2963  140    Cm  A02   1.16000 35,000_cells + HCMEC D3_line         0
      2964  140    Cm  A03   1.20000 35,000_cells + HCMEC D3_line         0
      2965  140    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      2966  140    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      2967  140    Cm  B03   1.09000 30,000_cells + HCMEC D3_line         0
      2968  140    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      2969  140    Cm  C02   1.06000 25,000_cells + HCMEC D3_line         0
      2970  140    Cm  C03   1.09000 25,000_cells + HCMEC D3_line         0
      2971  140    Cm  D01   1.11000 20,000_cells + HCMEC D3_line         0
      2972  140    Cm  D02   1.10000 20,000_cells + HCMEC D3_line         0
      2973  140    Cm  D03   1.10000 20,000_cells + HCMEC D3_line         0
      2974  140    Cm  E01   1.08000 15,000_cells + HCMEC D3_line         0
      2975  140    Cm  E02   1.05000 15,000_cells + HCMEC D3_line         0
      2976  140    Cm  E03   1.05000 15,000_cells + HCMEC D3_line         0
      2977  140    Cm  F01   1.05000 10,000_cells + HCMEC D3_line         0
      2978  140    Cm  F02   1.06000 10,000_cells + HCMEC D3_line         0
      2979  140    Cm  F03   1.07000 10,000_cells + HCMEC D3_line         0
      2980  140    Cm  G01   1.75000  5,000_cells + HCMEC D3_line         0
      2981  140    Cm  G02   1.40000  5,000_cells + HCMEC D3_line         0
      2982  140    Cm  G03   1.19000  5,000_cells + HCMEC D3_line         0
      2983  140 Drift  A01  -4.71000 35,000_cells + HCMEC D3_line         0
      2984  140 Drift  A02  -5.08000 35,000_cells + HCMEC D3_line         0
      2985  140 Drift  A03  -4.47000 35,000_cells + HCMEC D3_line         0
      2986  140 Drift  B01  -5.38000 30,000_cells + HCMEC D3_line         0
      2987  140 Drift  B02  -5.64000 30,000_cells + HCMEC D3_line         0
      2988  140 Drift  B03  -5.14000 30,000_cells + HCMEC D3_line         0
      2989  140 Drift  C01  -5.73000 25,000_cells + HCMEC D3_line         0
      2990  140 Drift  C02  -6.03000 25,000_cells + HCMEC D3_line         0
      2991  140 Drift  C03  -5.45000 25,000_cells + HCMEC D3_line         0
      2992  140 Drift  D01  -5.56000 20,000_cells + HCMEC D3_line         0
      2993  140 Drift  D02  -5.79000 20,000_cells + HCMEC D3_line         0
      2994  140 Drift  D03  -5.08000 20,000_cells + HCMEC D3_line         0
      2995  140 Drift  E01  -4.47000 15,000_cells + HCMEC D3_line         0
      2996  140 Drift  E02  -4.91000 15,000_cells + HCMEC D3_line         0
      2997  140 Drift  E03  -4.57000 15,000_cells + HCMEC D3_line         0
      2998  140 Drift  F01  -4.45000 10,000_cells + HCMEC D3_line         0
      2999  140 Drift  F02  -4.60000 10,000_cells + HCMEC D3_line         0
      3000  140 Drift  F03  -4.17000 10,000_cells + HCMEC D3_line         0
      3001  140 Drift  G01  -3.78000  5,000_cells + HCMEC D3_line         0
      3002  140 Drift  G02  -3.93000  5,000_cells + HCMEC D3_line         0
      3003  140 Drift  G03  -3.33000  5,000_cells + HCMEC D3_line         0
      3004  140    Rb  A01   1.31000 35,000_cells + HCMEC D3_line         0
      3005  140    Rb  A02   1.43000 35,000_cells + HCMEC D3_line         0
      3006  140    Rb  A03   1.40000 35,000_cells + HCMEC D3_line         0
      3007  140    Rb  B01   1.60000 30,000_cells + HCMEC D3_line         0
      3008  140    Rb  B02   1.70000 30,000_cells + HCMEC D3_line         0
      3009  140    Rb  B03   1.65000 30,000_cells + HCMEC D3_line         0
      3010  140    Rb  C01   1.67000 25,000_cells + HCMEC D3_line         0
      3011  140    Rb  C02   1.70000 25,000_cells + HCMEC D3_line         0
      3012  140    Rb  C03   1.69000 25,000_cells + HCMEC D3_line         0
      3013  140    Rb  D01   1.63000 20,000_cells + HCMEC D3_line         0
      3014  140    Rb  D02   1.69000 20,000_cells + HCMEC D3_line         0
      3015  140    Rb  D03   1.71000 20,000_cells + HCMEC D3_line         0
      3016  140    Rb  E01   1.99000 15,000_cells + HCMEC D3_line         0
      3017  140    Rb  E02   1.91000 15,000_cells + HCMEC D3_line         0
      3018  140    Rb  E03   2.05000 15,000_cells + HCMEC D3_line         0
      3019  140    Rb  F01   2.08000 10,000_cells + HCMEC D3_line         0
      3020  140    Rb  F02   2.02000 10,000_cells + HCMEC D3_line         0
      3021  140    Rb  F03   2.02000 10,000_cells + HCMEC D3_line         0
      3022  140    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      3023  140    Rb  G02   0.00000  5,000_cells + HCMEC D3_line         0
      3024  140    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      3025  140  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3026  140  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3027  140  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3028  140  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3029  140  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3030  140  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3031  140  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3032  140  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3033  140  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3034  140  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3035  140  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3036  140  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3037  140  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3038  140  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3039  140  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3040  140  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3041  140  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3042  140  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3043  140  RMSE  G01   0.02000  5,000_cells + HCMEC D3_line         0
      3044  140  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3045  140  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3046  145 Alpha  A01   3.20000 35,000_cells + HCMEC D3_line         0
      3047  145 Alpha  A02   3.17000 35,000_cells + HCMEC D3_line         0
      3048  145 Alpha  A03   3.17000 35,000_cells + HCMEC D3_line         0
      3049  145 Alpha  B01   3.40000 30,000_cells + HCMEC D3_line         0
      3050  145 Alpha  B02   3.51000 30,000_cells + HCMEC D3_line         0
      3051  145 Alpha  B03   3.44000 30,000_cells + HCMEC D3_line         0
      3052  145 Alpha  C01   3.60000 25,000_cells + HCMEC D3_line         0
      3053  145 Alpha  C02   3.57000 25,000_cells + HCMEC D3_line         0
      3054  145 Alpha  C03   3.68000 25,000_cells + HCMEC D3_line         0
      3055  145 Alpha  D01   3.78000 20,000_cells + HCMEC D3_line         0
      3056  145 Alpha  D02   3.83000 20,000_cells + HCMEC D3_line         0
      3057  145 Alpha  D03   3.73000 20,000_cells + HCMEC D3_line         0
      3058  145 Alpha  E01   3.90000 15,000_cells + HCMEC D3_line         0
      3059  145 Alpha  E02   3.93000 15,000_cells + HCMEC D3_line         0
      3060  145 Alpha  E03   3.88000 15,000_cells + HCMEC D3_line         0
      3061  145 Alpha  F01   4.08000 10,000_cells + HCMEC D3_line         0
      3062  145 Alpha  F02   4.19000 10,000_cells + HCMEC D3_line         0
      3063  145 Alpha  F03   4.07000 10,000_cells + HCMEC D3_line         0
      3064  145 Alpha  G01   5.33000  5,000_cells + HCMEC D3_line         0
      3065  145 Alpha  G02   5.41000  5,000_cells + HCMEC D3_line         0
      3066  145 Alpha  G03   5.26000  5,000_cells + HCMEC D3_line         0
      3067  145    Cm  A01   1.27000 35,000_cells + HCMEC D3_line         0
      3068  145    Cm  A02   1.18000 35,000_cells + HCMEC D3_line         0
      3069  145    Cm  A03   1.21000 35,000_cells + HCMEC D3_line         0
      3070  145    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      3071  145    Cm  B02   1.07000 30,000_cells + HCMEC D3_line         0
      3072  145    Cm  B03   1.09000 30,000_cells + HCMEC D3_line         0
      3073  145    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      3074  145    Cm  C02   1.04000 25,000_cells + HCMEC D3_line         0
      3075  145    Cm  C03   1.09000 25,000_cells + HCMEC D3_line         0
      3076  145    Cm  D01   1.09000 20,000_cells + HCMEC D3_line         0
      3077  145    Cm  D02   1.08000 20,000_cells + HCMEC D3_line         0
      3078  145    Cm  D03   1.08000 20,000_cells + HCMEC D3_line         0
      3079  145    Cm  E01   1.10000 15,000_cells + HCMEC D3_line         0
      3080  145    Cm  E02   1.02000 15,000_cells + HCMEC D3_line         0
      3081  145    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3082  145    Cm  F01   1.06000 10,000_cells + HCMEC D3_line         0
      3083  145    Cm  F02   1.07000 10,000_cells + HCMEC D3_line         0
      3084  145    Cm  F03   1.05000 10,000_cells + HCMEC D3_line         0
      3085  145    Cm  G01   1.35000  5,000_cells + HCMEC D3_line         0
      3086  145    Cm  G02   1.29000  5,000_cells + HCMEC D3_line         0
      3087  145    Cm  G03   1.09000  5,000_cells + HCMEC D3_line         0
      3088  145 Drift  A01  -4.56000 35,000_cells + HCMEC D3_line         0
      3089  145 Drift  A02  -4.93000 35,000_cells + HCMEC D3_line         0
      3090  145 Drift  A03  -4.31000 35,000_cells + HCMEC D3_line         0
      3091  145 Drift  B01  -5.24000 30,000_cells + HCMEC D3_line         0
      3092  145 Drift  B02  -5.51000 30,000_cells + HCMEC D3_line         0
      3093  145 Drift  B03  -5.00000 30,000_cells + HCMEC D3_line         0
      3094  145 Drift  C01  -5.61000 25,000_cells + HCMEC D3_line         0
      3095  145 Drift  C02  -5.90000 25,000_cells + HCMEC D3_line         0
      3096  145 Drift  C03  -5.34000 25,000_cells + HCMEC D3_line         0
      3097  145 Drift  D01  -5.44000 20,000_cells + HCMEC D3_line         0
      3098  145 Drift  D02  -5.65000 20,000_cells + HCMEC D3_line         0
      3099  145 Drift  D03  -4.96000 20,000_cells + HCMEC D3_line         0
      3100  145 Drift  E01  -4.35000 15,000_cells + HCMEC D3_line         0
      3101  145 Drift  E02  -4.81000 15,000_cells + HCMEC D3_line         0
      3102  145 Drift  E03  -4.43000 15,000_cells + HCMEC D3_line         0
      3103  145 Drift  F01  -4.34000 10,000_cells + HCMEC D3_line         0
      3104  145 Drift  F02  -4.49000 10,000_cells + HCMEC D3_line         0
      3105  145 Drift  F03  -4.04000 10,000_cells + HCMEC D3_line         0
      3106  145 Drift  G01  -3.63000  5,000_cells + HCMEC D3_line         0
      3107  145 Drift  G02  -3.83000  5,000_cells + HCMEC D3_line         0
      3108  145 Drift  G03  -3.24000  5,000_cells + HCMEC D3_line         0
      3109  145    Rb  A01   1.26000 35,000_cells + HCMEC D3_line         0
      3110  145    Rb  A02   1.35000 35,000_cells + HCMEC D3_line         0
      3111  145    Rb  A03   1.34000 35,000_cells + HCMEC D3_line         0
      3112  145    Rb  B01   1.55000 30,000_cells + HCMEC D3_line         0
      3113  145    Rb  B02   1.62000 30,000_cells + HCMEC D3_line         0
      3114  145    Rb  B03   1.56000 30,000_cells + HCMEC D3_line         0
      3115  145    Rb  C01   1.56000 25,000_cells + HCMEC D3_line         0
      3116  145    Rb  C02   1.63000 25,000_cells + HCMEC D3_line         0
      3117  145    Rb  C03   1.60000 25,000_cells + HCMEC D3_line         0
      3118  145    Rb  D01   1.57000 20,000_cells + HCMEC D3_line         0
      3119  145    Rb  D02   1.64000 20,000_cells + HCMEC D3_line         0
      3120  145    Rb  D03   1.63000 20,000_cells + HCMEC D3_line         0
      3121  145    Rb  E01   1.83000 15,000_cells + HCMEC D3_line         0
      3122  145    Rb  E02   1.89000 15,000_cells + HCMEC D3_line         0
      3123  145    Rb  E03   1.90000 15,000_cells + HCMEC D3_line         0
      3124  145    Rb  F01   1.92000 10,000_cells + HCMEC D3_line         0
      3125  145    Rb  F02   1.98000 10,000_cells + HCMEC D3_line         0
      3126  145    Rb  F03   2.04000 10,000_cells + HCMEC D3_line         0
      3127  145    Rb  G01   0.00000  5,000_cells + HCMEC D3_line         0
      3128  145    Rb  G02   0.15000  5,000_cells + HCMEC D3_line         0
      3129  145    Rb  G03   0.00000  5,000_cells + HCMEC D3_line         0
      3130  145  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3131  145  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3132  145  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3133  145  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3134  145  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3135  145  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3136  145  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3137  145  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3138  145  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3139  145  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3140  145  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3141  145  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3142  145  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3143  145  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3144  145  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3145  145  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3146  145  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3147  145  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3148  145  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3149  145  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3150  145  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3151  150 Alpha  A01   3.15000 35,000_cells + HCMEC D3_line         0
      3152  150 Alpha  A02   3.13000 35,000_cells + HCMEC D3_line         0
      3153  150 Alpha  A03   3.14000 35,000_cells + HCMEC D3_line         0
      3154  150 Alpha  B01   3.35000 30,000_cells + HCMEC D3_line         0
      3155  150 Alpha  B02   3.46000 30,000_cells + HCMEC D3_line         0
      3156  150 Alpha  B03   3.38000 30,000_cells + HCMEC D3_line         0
      3157  150 Alpha  C01   3.53000 25,000_cells + HCMEC D3_line         0
      3158  150 Alpha  C02   3.51000 25,000_cells + HCMEC D3_line         0
      3159  150 Alpha  C03   3.62000 25,000_cells + HCMEC D3_line         0
      3160  150 Alpha  D01   3.71000 20,000_cells + HCMEC D3_line         0
      3161  150 Alpha  D02   3.74000 20,000_cells + HCMEC D3_line         0
      3162  150 Alpha  D03   3.65000 20,000_cells + HCMEC D3_line         0
      3163  150 Alpha  E01   3.82000 15,000_cells + HCMEC D3_line         0
      3164  150 Alpha  E02   3.90000 15,000_cells + HCMEC D3_line         0
      3165  150 Alpha  E03   3.85000 15,000_cells + HCMEC D3_line         0
      3166  150 Alpha  F01   4.03000 10,000_cells + HCMEC D3_line         0
      3167  150 Alpha  F02   4.16000 10,000_cells + HCMEC D3_line         0
      3168  150 Alpha  F03   4.03000 10,000_cells + HCMEC D3_line         0
      3169  150 Alpha  G01   5.27000  5,000_cells + HCMEC D3_line         0
      3170  150 Alpha  G02   5.29000  5,000_cells + HCMEC D3_line         0
      3171  150 Alpha  G03   5.26000  5,000_cells + HCMEC D3_line         0
      3172  150    Cm  A01   1.29000 35,000_cells + HCMEC D3_line         0
      3173  150    Cm  A02   1.18000 35,000_cells + HCMEC D3_line         0
      3174  150    Cm  A03   1.24000 35,000_cells + HCMEC D3_line         0
      3175  150    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      3176  150    Cm  B02   1.07000 30,000_cells + HCMEC D3_line         0
      3177  150    Cm  B03   1.10000 30,000_cells + HCMEC D3_line         0
      3178  150    Cm  C01   1.09000 25,000_cells + HCMEC D3_line         0
      3179  150    Cm  C02   1.04000 25,000_cells + HCMEC D3_line         0
      3180  150    Cm  C03   1.09000 25,000_cells + HCMEC D3_line         0
      3181  150    Cm  D01   1.09000 20,000_cells + HCMEC D3_line         0
      3182  150    Cm  D02   1.07000 20,000_cells + HCMEC D3_line         0
      3183  150    Cm  D03   1.08000 20,000_cells + HCMEC D3_line         0
      3184  150    Cm  E01   1.10000 15,000_cells + HCMEC D3_line         0
      3185  150    Cm  E02   1.04000 15,000_cells + HCMEC D3_line         0
      3186  150    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3187  150    Cm  F01   1.06000 10,000_cells + HCMEC D3_line         0
      3188  150    Cm  F02   1.07000 10,000_cells + HCMEC D3_line         0
      3189  150    Cm  F03   1.05000 10,000_cells + HCMEC D3_line         0
      3190  150    Cm  G01   1.40000  5,000_cells + HCMEC D3_line         0
      3191  150    Cm  G02   1.37000  5,000_cells + HCMEC D3_line         0
      3192  150    Cm  G03   1.14000  5,000_cells + HCMEC D3_line         0
      3193  150 Drift  A01  -4.40000 35,000_cells + HCMEC D3_line         0
      3194  150 Drift  A02  -4.78000 35,000_cells + HCMEC D3_line         0
      3195  150 Drift  A03  -4.14000 35,000_cells + HCMEC D3_line         0
      3196  150 Drift  B01  -5.10000 30,000_cells + HCMEC D3_line         0
      3197  150 Drift  B02  -5.37000 30,000_cells + HCMEC D3_line         0
      3198  150 Drift  B03  -4.85000 30,000_cells + HCMEC D3_line         0
      3199  150 Drift  C01  -5.47000 25,000_cells + HCMEC D3_line         0
      3200  150 Drift  C02  -5.76000 25,000_cells + HCMEC D3_line         0
      3201  150 Drift  C03  -5.20000 25,000_cells + HCMEC D3_line         0
      3202  150 Drift  D01  -5.29000 20,000_cells + HCMEC D3_line         0
      3203  150 Drift  D02  -5.51000 20,000_cells + HCMEC D3_line         0
      3204  150 Drift  D03  -4.82000 20,000_cells + HCMEC D3_line         0
      3205  150 Drift  E01  -4.22000 15,000_cells + HCMEC D3_line         0
      3206  150 Drift  E02  -4.70000 15,000_cells + HCMEC D3_line         0
      3207  150 Drift  E03  -4.30000 15,000_cells + HCMEC D3_line         0
      3208  150 Drift  F01  -4.22000 10,000_cells + HCMEC D3_line         0
      3209  150 Drift  F02  -4.39000 10,000_cells + HCMEC D3_line         0
      3210  150 Drift  F03  -3.90000 10,000_cells + HCMEC D3_line         0
      3211  150 Drift  G01  -3.49000  5,000_cells + HCMEC D3_line         0
      3212  150 Drift  G02  -3.69000  5,000_cells + HCMEC D3_line         0
      3213  150 Drift  G03  -3.11000  5,000_cells + HCMEC D3_line         0
      3214  150    Rb  A01   1.17000 35,000_cells + HCMEC D3_line         0
      3215  150    Rb  A02   1.31000 35,000_cells + HCMEC D3_line         0
      3216  150    Rb  A03   1.26000 35,000_cells + HCMEC D3_line         0
      3217  150    Rb  B01   1.49000 30,000_cells + HCMEC D3_line         0
      3218  150    Rb  B02   1.55000 30,000_cells + HCMEC D3_line         0
      3219  150    Rb  B03   1.46000 30,000_cells + HCMEC D3_line         0
      3220  150    Rb  C01   1.46000 25,000_cells + HCMEC D3_line         0
      3221  150    Rb  C02   1.54000 25,000_cells + HCMEC D3_line         0
      3222  150    Rb  C03   1.48000 25,000_cells + HCMEC D3_line         0
      3223  150    Rb  D01   1.46000 20,000_cells + HCMEC D3_line         0
      3224  150    Rb  D02   1.57000 20,000_cells + HCMEC D3_line         0
      3225  150    Rb  D03   1.54000 20,000_cells + HCMEC D3_line         0
      3226  150    Rb  E01   1.75000 15,000_cells + HCMEC D3_line         0
      3227  150    Rb  E02   1.72000 15,000_cells + HCMEC D3_line         0
      3228  150    Rb  E03   1.85000 15,000_cells + HCMEC D3_line         0
      3229  150    Rb  F01   1.86000 10,000_cells + HCMEC D3_line         0
      3230  150    Rb  F02   1.87000 10,000_cells + HCMEC D3_line         0
      3231  150    Rb  F03   1.95000 10,000_cells + HCMEC D3_line         0
      3232  150    Rb  G01   0.12000  5,000_cells + HCMEC D3_line         0
      3233  150    Rb  G02   0.35000  5,000_cells + HCMEC D3_line         0
      3234  150    Rb  G03   0.11000  5,000_cells + HCMEC D3_line         0
      3235  150  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3236  150  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3237  150  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3238  150  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3239  150  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3240  150  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3241  150  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3242  150  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3243  150  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3244  150  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3245  150  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3246  150  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3247  150  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3248  150  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3249  150  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3250  150  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3251  150  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3252  150  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3253  150  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3254  150  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3255  150  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3256  155 Alpha  A01   3.12000 35,000_cells + HCMEC D3_line         0
      3257  155 Alpha  A02   3.12000 35,000_cells + HCMEC D3_line         0
      3258  155 Alpha  A03   3.08000 35,000_cells + HCMEC D3_line         0
      3259  155 Alpha  B01   3.34000 30,000_cells + HCMEC D3_line         0
      3260  155 Alpha  B02   3.43000 30,000_cells + HCMEC D3_line         0
      3261  155 Alpha  B03   3.35000 30,000_cells + HCMEC D3_line         0
      3262  155 Alpha  C01   3.48000 25,000_cells + HCMEC D3_line         0
      3263  155 Alpha  C02   3.47000 25,000_cells + HCMEC D3_line         0
      3264  155 Alpha  C03   3.58000 25,000_cells + HCMEC D3_line         0
      3265  155 Alpha  D01   3.61000 20,000_cells + HCMEC D3_line         0
      3266  155 Alpha  D02   3.70000 20,000_cells + HCMEC D3_line         0
      3267  155 Alpha  D03   3.63000 20,000_cells + HCMEC D3_line         0
      3268  155 Alpha  E01   3.78000 15,000_cells + HCMEC D3_line         0
      3269  155 Alpha  E02   3.85000 15,000_cells + HCMEC D3_line         0
      3270  155 Alpha  E03   3.80000 15,000_cells + HCMEC D3_line         0
      3271  155 Alpha  F01   4.01000 10,000_cells + HCMEC D3_line         0
      3272  155 Alpha  F02   4.07000 10,000_cells + HCMEC D3_line         0
      3273  155 Alpha  F03   3.97000 10,000_cells + HCMEC D3_line         0
      3274  155 Alpha  G01   5.18000  5,000_cells + HCMEC D3_line         0
      3275  155 Alpha  G02   5.23000  5,000_cells + HCMEC D3_line         0
      3276  155 Alpha  G03   5.16000  5,000_cells + HCMEC D3_line         0
      3277  155    Cm  A01   1.30000 35,000_cells + HCMEC D3_line         0
      3278  155    Cm  A02   1.18000 35,000_cells + HCMEC D3_line         0
      3279  155    Cm  A03   1.24000 35,000_cells + HCMEC D3_line         0
      3280  155    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      3281  155    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      3282  155    Cm  B03   1.09000 30,000_cells + HCMEC D3_line         0
      3283  155    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      3284  155    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      3285  155    Cm  C03   1.09000 25,000_cells + HCMEC D3_line         0
      3286  155    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      3287  155    Cm  D02   1.06000 20,000_cells + HCMEC D3_line         0
      3288  155    Cm  D03   1.07000 20,000_cells + HCMEC D3_line         0
      3289  155    Cm  E01   1.11000 15,000_cells + HCMEC D3_line         0
      3290  155    Cm  E02   1.05000 15,000_cells + HCMEC D3_line         0
      3291  155    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3292  155    Cm  F01   1.08000 10,000_cells + HCMEC D3_line         0
      3293  155    Cm  F02   1.04000 10,000_cells + HCMEC D3_line         0
      3294  155    Cm  F03   1.03000 10,000_cells + HCMEC D3_line         0
      3295  155    Cm  G01   1.50000  5,000_cells + HCMEC D3_line         0
      3296  155    Cm  G02   1.40000  5,000_cells + HCMEC D3_line         0
      3297  155    Cm  G03   1.17000  5,000_cells + HCMEC D3_line         0
      3298  155 Drift  A01  -4.22000 35,000_cells + HCMEC D3_line         0
      3299  155 Drift  A02  -4.60000 35,000_cells + HCMEC D3_line         0
      3300  155 Drift  A03  -3.94000 35,000_cells + HCMEC D3_line         0
      3301  155 Drift  B01  -4.94000 30,000_cells + HCMEC D3_line         0
      3302  155 Drift  B02  -5.20000 30,000_cells + HCMEC D3_line         0
      3303  155 Drift  B03  -4.68000 30,000_cells + HCMEC D3_line         0
      3304  155 Drift  C01  -5.29000 25,000_cells + HCMEC D3_line         0
      3305  155 Drift  C02  -5.61000 25,000_cells + HCMEC D3_line         0
      3306  155 Drift  C03  -5.04000 25,000_cells + HCMEC D3_line         0
      3307  155 Drift  D01  -5.15000 20,000_cells + HCMEC D3_line         0
      3308  155 Drift  D02  -5.36000 20,000_cells + HCMEC D3_line         0
      3309  155 Drift  D03  -4.67000 20,000_cells + HCMEC D3_line         0
      3310  155 Drift  E01  -4.07000 15,000_cells + HCMEC D3_line         0
      3311  155 Drift  E02  -4.50000 15,000_cells + HCMEC D3_line         0
      3312  155 Drift  E03  -4.15000 15,000_cells + HCMEC D3_line         0
      3313  155 Drift  F01  -4.08000 10,000_cells + HCMEC D3_line         0
      3314  155 Drift  F02  -4.24000 10,000_cells + HCMEC D3_line         0
      3315  155 Drift  F03  -3.75000 10,000_cells + HCMEC D3_line         0
      3316  155 Drift  G01  -3.35000  5,000_cells + HCMEC D3_line         0
      3317  155 Drift  G02  -3.56000  5,000_cells + HCMEC D3_line         0
      3318  155 Drift  G03  -2.97000  5,000_cells + HCMEC D3_line         0
      3319  155    Rb  A01   1.11000 35,000_cells + HCMEC D3_line         0
      3320  155    Rb  A02   1.25000 35,000_cells + HCMEC D3_line         0
      3321  155    Rb  A03   1.18000 35,000_cells + HCMEC D3_line         0
      3322  155    Rb  B01   1.38000 30,000_cells + HCMEC D3_line         0
      3323  155    Rb  B02   1.44000 30,000_cells + HCMEC D3_line         0
      3324  155    Rb  B03   1.40000 30,000_cells + HCMEC D3_line         0
      3325  155    Rb  C01   1.42000 25,000_cells + HCMEC D3_line         0
      3326  155    Rb  C02   1.43000 25,000_cells + HCMEC D3_line         0
      3327  155    Rb  C03   1.40000 25,000_cells + HCMEC D3_line         0
      3328  155    Rb  D01   1.42000 20,000_cells + HCMEC D3_line         0
      3329  155    Rb  D02   1.51000 20,000_cells + HCMEC D3_line         0
      3330  155    Rb  D03   1.45000 20,000_cells + HCMEC D3_line         0
      3331  155    Rb  E01   1.61000 15,000_cells + HCMEC D3_line         0
      3332  155    Rb  E02   1.64000 15,000_cells + HCMEC D3_line         0
      3333  155    Rb  E03   1.71000 15,000_cells + HCMEC D3_line         0
      3334  155    Rb  F01   1.73000 10,000_cells + HCMEC D3_line         0
      3335  155    Rb  F02   1.87000 10,000_cells + HCMEC D3_line         0
      3336  155    Rb  F03   1.91000 10,000_cells + HCMEC D3_line         0
      3337  155    Rb  G01   0.35000  5,000_cells + HCMEC D3_line         0
      3338  155    Rb  G02   0.49000  5,000_cells + HCMEC D3_line         0
      3339  155    Rb  G03   0.15000  5,000_cells + HCMEC D3_line         0
      3340  155  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3341  155  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3342  155  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3343  155  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3344  155  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3345  155  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3346  155  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3347  155  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3348  155  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3349  155  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3350  155  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3351  155  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3352  155  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3353  155  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3354  155  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3355  155  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3356  155  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3357  155  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3358  155  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3359  155  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3360  155  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3361  160 Alpha  A01   3.08000 35,000_cells + HCMEC D3_line         0
      3362  160 Alpha  A02   3.06000 35,000_cells + HCMEC D3_line         0
      3363  160 Alpha  A03   3.03000 35,000_cells + HCMEC D3_line         0
      3364  160 Alpha  B01   3.26000 30,000_cells + HCMEC D3_line         0
      3365  160 Alpha  B02   3.38000 30,000_cells + HCMEC D3_line         0
      3366  160 Alpha  B03   3.32000 30,000_cells + HCMEC D3_line         0
      3367  160 Alpha  C01   3.44000 25,000_cells + HCMEC D3_line         0
      3368  160 Alpha  C02   3.46000 25,000_cells + HCMEC D3_line         0
      3369  160 Alpha  C03   3.53000 25,000_cells + HCMEC D3_line         0
      3370  160 Alpha  D01   3.58000 20,000_cells + HCMEC D3_line         0
      3371  160 Alpha  D02   3.66000 20,000_cells + HCMEC D3_line         0
      3372  160 Alpha  D03   3.56000 20,000_cells + HCMEC D3_line         0
      3373  160 Alpha  E01   3.70000 15,000_cells + HCMEC D3_line         0
      3374  160 Alpha  E02   3.79000 15,000_cells + HCMEC D3_line         0
      3375  160 Alpha  E03   3.74000 15,000_cells + HCMEC D3_line         0
      3376  160 Alpha  F01   3.96000 10,000_cells + HCMEC D3_line         0
      3377  160 Alpha  F02   4.05000 10,000_cells + HCMEC D3_line         0
      3378  160 Alpha  F03   3.98000 10,000_cells + HCMEC D3_line         0
      3379  160 Alpha  G01   5.11000  5,000_cells + HCMEC D3_line         0
      3380  160 Alpha  G02   5.12000  5,000_cells + HCMEC D3_line         0
      3381  160 Alpha  G03   5.05000  5,000_cells + HCMEC D3_line         0
      3382  160    Cm  A01   1.33000 35,000_cells + HCMEC D3_line         0
      3383  160    Cm  A02   1.18000 35,000_cells + HCMEC D3_line         0
      3384  160    Cm  A03   1.26000 35,000_cells + HCMEC D3_line         0
      3385  160    Cm  B01   1.09000 30,000_cells + HCMEC D3_line         0
      3386  160    Cm  B02   1.07000 30,000_cells + HCMEC D3_line         0
      3387  160    Cm  B03   1.11000 30,000_cells + HCMEC D3_line         0
      3388  160    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      3389  160    Cm  C02   1.05000 25,000_cells + HCMEC D3_line         0
      3390  160    Cm  C03   1.07000 25,000_cells + HCMEC D3_line         0
      3391  160    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      3392  160    Cm  D02   1.04000 20,000_cells + HCMEC D3_line         0
      3393  160    Cm  D03   1.08000 20,000_cells + HCMEC D3_line         0
      3394  160    Cm  E01   1.07000 15,000_cells + HCMEC D3_line         0
      3395  160    Cm  E02   1.04000 15,000_cells + HCMEC D3_line         0
      3396  160    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3397  160    Cm  F01   1.07000 10,000_cells + HCMEC D3_line         0
      3398  160    Cm  F02   1.06000 10,000_cells + HCMEC D3_line         0
      3399  160    Cm  F03   1.06000 10,000_cells + HCMEC D3_line         0
      3400  160    Cm  G01   1.43000  5,000_cells + HCMEC D3_line         0
      3401  160    Cm  G02   1.38000  5,000_cells + HCMEC D3_line         0
      3402  160    Cm  G03   1.29000  5,000_cells + HCMEC D3_line         0
      3403  160 Drift  A01  -4.03000 35,000_cells + HCMEC D3_line         0
      3404  160 Drift  A02  -4.42000 35,000_cells + HCMEC D3_line         0
      3405  160 Drift  A03  -3.74000 35,000_cells + HCMEC D3_line         0
      3406  160 Drift  B01  -4.77000 30,000_cells + HCMEC D3_line         0
      3407  160 Drift  B02  -5.02000 30,000_cells + HCMEC D3_line         0
      3408  160 Drift  B03  -4.50000 30,000_cells + HCMEC D3_line         0
      3409  160 Drift  C01  -5.13000 25,000_cells + HCMEC D3_line         0
      3410  160 Drift  C02  -5.45000 25,000_cells + HCMEC D3_line         0
      3411  160 Drift  C03  -4.87000 25,000_cells + HCMEC D3_line         0
      3412  160 Drift  D01  -4.99000 20,000_cells + HCMEC D3_line         0
      3413  160 Drift  D02  -5.20000 20,000_cells + HCMEC D3_line         0
      3414  160 Drift  D03  -4.51000 20,000_cells + HCMEC D3_line         0
      3415  160 Drift  E01  -3.91000 15,000_cells + HCMEC D3_line         0
      3416  160 Drift  E02  -4.37000 15,000_cells + HCMEC D3_line         0
      3417  160 Drift  E03  -3.99000 15,000_cells + HCMEC D3_line         0
      3418  160 Drift  F01  -3.94000 10,000_cells + HCMEC D3_line         0
      3419  160 Drift  F02  -4.10000 10,000_cells + HCMEC D3_line         0
      3420  160 Drift  F03  -3.60000 10,000_cells + HCMEC D3_line         0
      3421  160 Drift  G01  -3.19000  5,000_cells + HCMEC D3_line         0
      3422  160 Drift  G02  -3.40000  5,000_cells + HCMEC D3_line         0
      3423  160 Drift  G03  -2.81000  5,000_cells + HCMEC D3_line         0
      3424  160    Rb  A01   1.04000 35,000_cells + HCMEC D3_line         0
      3425  160    Rb  A02   1.19000 35,000_cells + HCMEC D3_line         0
      3426  160    Rb  A03   1.12000 35,000_cells + HCMEC D3_line         0
      3427  160    Rb  B01   1.35000 30,000_cells + HCMEC D3_line         0
      3428  160    Rb  B02   1.36000 30,000_cells + HCMEC D3_line         0
      3429  160    Rb  B03   1.30000 30,000_cells + HCMEC D3_line         0
      3430  160    Rb  C01   1.31000 25,000_cells + HCMEC D3_line         0
      3431  160    Rb  C02   1.33000 25,000_cells + HCMEC D3_line         0
      3432  160    Rb  C03   1.39000 25,000_cells + HCMEC D3_line         0
      3433  160    Rb  D01   1.34000 20,000_cells + HCMEC D3_line         0
      3434  160    Rb  D02   1.46000 20,000_cells + HCMEC D3_line         0
      3435  160    Rb  D03   1.38000 20,000_cells + HCMEC D3_line         0
      3436  160    Rb  E01   1.60000 15,000_cells + HCMEC D3_line         0
      3437  160    Rb  E02   1.57000 15,000_cells + HCMEC D3_line         0
      3438  160    Rb  E03   1.63000 15,000_cells + HCMEC D3_line         0
      3439  160    Rb  F01   1.60000 10,000_cells + HCMEC D3_line         0
      3440  160    Rb  F02   1.77000 10,000_cells + HCMEC D3_line         0
      3441  160    Rb  F03   1.74000 10,000_cells + HCMEC D3_line         0
      3442  160    Rb  G01   0.32000  5,000_cells + HCMEC D3_line         0
      3443  160    Rb  G02   0.64000  5,000_cells + HCMEC D3_line         0
      3444  160    Rb  G03   0.35000  5,000_cells + HCMEC D3_line         0
      3445  160  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3446  160  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3447  160  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3448  160  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3449  160  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3450  160  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3451  160  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3452  160  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3453  160  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3454  160  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3455  160  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3456  160  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3457  160  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3458  160  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3459  160  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3460  160  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3461  160  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3462  160  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3463  160  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3464  160  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3465  160  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3466  165 Alpha  A01   3.02000 35,000_cells + HCMEC D3_line         0
      3467  165 Alpha  A02   3.03000 35,000_cells + HCMEC D3_line         0
      3468  165 Alpha  A03   2.97000 35,000_cells + HCMEC D3_line         0
      3469  165 Alpha  B01   3.25000 30,000_cells + HCMEC D3_line         0
      3470  165 Alpha  B02   3.35000 30,000_cells + HCMEC D3_line         0
      3471  165 Alpha  B03   3.27000 30,000_cells + HCMEC D3_line         0
      3472  165 Alpha  C01   3.36000 25,000_cells + HCMEC D3_line         0
      3473  165 Alpha  C02   3.37000 25,000_cells + HCMEC D3_line         0
      3474  165 Alpha  C03   3.47000 25,000_cells + HCMEC D3_line         0
      3475  165 Alpha  D01   3.51000 20,000_cells + HCMEC D3_line         0
      3476  165 Alpha  D02   3.62000 20,000_cells + HCMEC D3_line         0
      3477  165 Alpha  D03   3.50000 20,000_cells + HCMEC D3_line         0
      3478  165 Alpha  E01   3.67000 15,000_cells + HCMEC D3_line         0
      3479  165 Alpha  E02   3.71000 15,000_cells + HCMEC D3_line         0
      3480  165 Alpha  E03   3.66000 15,000_cells + HCMEC D3_line         0
      3481  165 Alpha  F01   3.92000 10,000_cells + HCMEC D3_line         0
      3482  165 Alpha  F02   3.98000 10,000_cells + HCMEC D3_line         0
      3483  165 Alpha  F03   3.91000 10,000_cells + HCMEC D3_line         0
      3484  165 Alpha  G01   5.02000  5,000_cells + HCMEC D3_line         0
      3485  165 Alpha  G02   5.03000  5,000_cells + HCMEC D3_line         0
      3486  165 Alpha  G03   4.92000  5,000_cells + HCMEC D3_line         0
      3487  165    Cm  A01   1.34000 35,000_cells + HCMEC D3_line         0
      3488  165    Cm  A02   1.19000 35,000_cells + HCMEC D3_line         0
      3489  165    Cm  A03   1.26000 35,000_cells + HCMEC D3_line         0
      3490  165    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      3491  165    Cm  B02   1.07000 30,000_cells + HCMEC D3_line         0
      3492  165    Cm  B03   1.10000 30,000_cells + HCMEC D3_line         0
      3493  165    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      3494  165    Cm  C02   1.04000 25,000_cells + HCMEC D3_line         0
      3495  165    Cm  C03   1.07000 25,000_cells + HCMEC D3_line         0
      3496  165    Cm  D01   1.08000 20,000_cells + HCMEC D3_line         0
      3497  165    Cm  D02   1.06000 20,000_cells + HCMEC D3_line         0
      3498  165    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      3499  165    Cm  E01   1.06000 15,000_cells + HCMEC D3_line         0
      3500  165    Cm  E02   1.03000 15,000_cells + HCMEC D3_line         0
      3501  165    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3502  165    Cm  F01   1.07000 10,000_cells + HCMEC D3_line         0
      3503  165    Cm  F02   1.05000 10,000_cells + HCMEC D3_line         0
      3504  165    Cm  F03   1.07000 10,000_cells + HCMEC D3_line         0
      3505  165    Cm  G01   1.43000  5,000_cells + HCMEC D3_line         0
      3506  165    Cm  G02   1.37000  5,000_cells + HCMEC D3_line         0
      3507  165    Cm  G03   1.28000  5,000_cells + HCMEC D3_line         0
      3508  165 Drift  A01  -3.82000 35,000_cells + HCMEC D3_line         0
      3509  165 Drift  A02  -4.22000 35,000_cells + HCMEC D3_line         0
      3510  165 Drift  A03  -3.52000 35,000_cells + HCMEC D3_line         0
      3511  165 Drift  B01  -4.58000 30,000_cells + HCMEC D3_line         0
      3512  165 Drift  B02  -4.84000 30,000_cells + HCMEC D3_line         0
      3513  165 Drift  B03  -4.31000 30,000_cells + HCMEC D3_line         0
      3514  165 Drift  C01  -4.95000 25,000_cells + HCMEC D3_line         0
      3515  165 Drift  C02  -5.28000 25,000_cells + HCMEC D3_line         0
      3516  165 Drift  C03  -4.68000 25,000_cells + HCMEC D3_line         0
      3517  165 Drift  D01  -4.83000 20,000_cells + HCMEC D3_line         0
      3518  165 Drift  D02  -5.03000 20,000_cells + HCMEC D3_line         0
      3519  165 Drift  D03  -4.32000 20,000_cells + HCMEC D3_line         0
      3520  165 Drift  E01  -3.74000 15,000_cells + HCMEC D3_line         0
      3521  165 Drift  E02  -4.19000 15,000_cells + HCMEC D3_line         0
      3522  165 Drift  E03  -3.81000 15,000_cells + HCMEC D3_line         0
      3523  165 Drift  F01  -3.77000 10,000_cells + HCMEC D3_line         0
      3524  165 Drift  F02  -3.97000 10,000_cells + HCMEC D3_line         0
      3525  165 Drift  F03  -3.41000 10,000_cells + HCMEC D3_line         0
      3526  165 Drift  G01  -3.03000  5,000_cells + HCMEC D3_line         0
      3527  165 Drift  G02  -3.24000  5,000_cells + HCMEC D3_line         0
      3528  165 Drift  G03  -2.63000  5,000_cells + HCMEC D3_line         0
      3529  165    Rb  A01   0.99000 35,000_cells + HCMEC D3_line         0
      3530  165    Rb  A02   1.13000 35,000_cells + HCMEC D3_line         0
      3531  165    Rb  A03   1.06000 35,000_cells + HCMEC D3_line         0
      3532  165    Rb  B01   1.26000 30,000_cells + HCMEC D3_line         0
      3533  165    Rb  B02   1.28000 30,000_cells + HCMEC D3_line         0
      3534  165    Rb  B03   1.26000 30,000_cells + HCMEC D3_line         0
      3535  165    Rb  C01   1.27000 25,000_cells + HCMEC D3_line         0
      3536  165    Rb  C02   1.30000 25,000_cells + HCMEC D3_line         0
      3537  165    Rb  C03   1.28000 25,000_cells + HCMEC D3_line         0
      3538  165    Rb  D01   1.26000 20,000_cells + HCMEC D3_line         0
      3539  165    Rb  D02   1.33000 20,000_cells + HCMEC D3_line         0
      3540  165    Rb  D03   1.30000 20,000_cells + HCMEC D3_line         0
      3541  165    Rb  E01   1.53000 15,000_cells + HCMEC D3_line         0
      3542  165    Rb  E02   1.48000 15,000_cells + HCMEC D3_line         0
      3543  165    Rb  E03   1.54000 15,000_cells + HCMEC D3_line         0
      3544  165    Rb  F01   1.55000 10,000_cells + HCMEC D3_line         0
      3545  165    Rb  F02   1.61000 10,000_cells + HCMEC D3_line         0
      3546  165    Rb  F03   1.64000 10,000_cells + HCMEC D3_line         0
      3547  165    Rb  G01   0.39000  5,000_cells + HCMEC D3_line         0
      3548  165    Rb  G02   0.68000  5,000_cells + HCMEC D3_line         0
      3549  165    Rb  G03   0.49000  5,000_cells + HCMEC D3_line         0
      3550  165  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3551  165  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3552  165  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3553  165  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3554  165  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3555  165  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3556  165  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3557  165  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3558  165  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3559  165  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3560  165  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3561  165  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3562  165  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3563  165  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3564  165  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3565  165  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3566  165  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3567  165  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3568  165  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3569  165  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3570  165  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3571  170 Alpha  A01   2.97000 35,000_cells + HCMEC D3_line         0
      3572  170 Alpha  A02   3.01000 35,000_cells + HCMEC D3_line         0
      3573  170 Alpha  A03   2.94000 35,000_cells + HCMEC D3_line         0
      3574  170 Alpha  B01   3.19000 30,000_cells + HCMEC D3_line         0
      3575  170 Alpha  B02   3.30000 30,000_cells + HCMEC D3_line         0
      3576  170 Alpha  B03   3.22000 30,000_cells + HCMEC D3_line         0
      3577  170 Alpha  C01   3.31000 25,000_cells + HCMEC D3_line         0
      3578  170 Alpha  C02   3.33000 25,000_cells + HCMEC D3_line         0
      3579  170 Alpha  C03   3.44000 25,000_cells + HCMEC D3_line         0
      3580  170 Alpha  D01   4.78000 20,000_cells + HCMEC D3_line         0
      3581  170 Alpha  D02   3.58000 20,000_cells + HCMEC D3_line         0
      3582  170 Alpha  D03   3.47000 20,000_cells + HCMEC D3_line         0
      3583  170 Alpha  E01   3.61000 15,000_cells + HCMEC D3_line         0
      3584  170 Alpha  E02   3.66000 15,000_cells + HCMEC D3_line         0
      3585  170 Alpha  E03   3.62000 15,000_cells + HCMEC D3_line         0
      3586  170 Alpha  F01   3.87000 10,000_cells + HCMEC D3_line         0
      3587  170 Alpha  F02   3.96000 10,000_cells + HCMEC D3_line         0
      3588  170 Alpha  F03   3.82000 10,000_cells + HCMEC D3_line         0
      3589  170 Alpha  G01   4.95000  5,000_cells + HCMEC D3_line         0
      3590  170 Alpha  G02   4.98000  5,000_cells + HCMEC D3_line         0
      3591  170 Alpha  G03   4.81000  5,000_cells + HCMEC D3_line         0
      3592  170    Cm  A01   1.33000 35,000_cells + HCMEC D3_line         0
      3593  170    Cm  A02   1.18000 35,000_cells + HCMEC D3_line         0
      3594  170    Cm  A03   1.28000 35,000_cells + HCMEC D3_line         0
      3595  170    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      3596  170    Cm  B02   1.06000 30,000_cells + HCMEC D3_line         0
      3597  170    Cm  B03   1.11000 30,000_cells + HCMEC D3_line         0
      3598  170    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      3599  170    Cm  C02   1.02000 25,000_cells + HCMEC D3_line         0
      3600  170    Cm  C03   1.08000 25,000_cells + HCMEC D3_line         0
      3601  170    Cm  D01   0.93000 20,000_cells + HCMEC D3_line         0
      3602  170    Cm  D02   1.06000 20,000_cells + HCMEC D3_line         0
      3603  170    Cm  D03   1.07000 20,000_cells + HCMEC D3_line         0
      3604  170    Cm  E01   1.06000 15,000_cells + HCMEC D3_line         0
      3605  170    Cm  E02   1.04000 15,000_cells + HCMEC D3_line         0
      3606  170    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3607  170    Cm  F01   1.09000 10,000_cells + HCMEC D3_line         0
      3608  170    Cm  F02   1.03000 10,000_cells + HCMEC D3_line         0
      3609  170    Cm  F03   1.06000 10,000_cells + HCMEC D3_line         0
      3610  170    Cm  G01   1.43000  5,000_cells + HCMEC D3_line         0
      3611  170    Cm  G02   1.25000  5,000_cells + HCMEC D3_line         0
      3612  170    Cm  G03   1.25000  5,000_cells + HCMEC D3_line         0
      3613  170 Drift  A01  -3.61000 35,000_cells + HCMEC D3_line         0
      3614  170 Drift  A02  -4.02000 35,000_cells + HCMEC D3_line         0
      3615  170 Drift  A03  -3.30000 35,000_cells + HCMEC D3_line         0
      3616  170 Drift  B01  -4.39000 30,000_cells + HCMEC D3_line         0
      3617  170 Drift  B02  -4.66000 30,000_cells + HCMEC D3_line         0
      3618  170 Drift  B03  -4.11000 30,000_cells + HCMEC D3_line         0
      3619  170 Drift  C01  -4.75000 25,000_cells + HCMEC D3_line         0
      3620  170 Drift  C02  -5.09000 25,000_cells + HCMEC D3_line         0
      3621  170 Drift  C03  -4.49000 25,000_cells + HCMEC D3_line         0
      3622  170 Drift  D01  -5.51000 20,000_cells + HCMEC D3_line         0
      3623  170 Drift  D02  -4.84000 20,000_cells + HCMEC D3_line         0
      3624  170 Drift  D03  -4.13000 20,000_cells + HCMEC D3_line         0
      3625  170 Drift  E01  -3.57000 15,000_cells + HCMEC D3_line         0
      3626  170 Drift  E02  -4.00000 15,000_cells + HCMEC D3_line         0
      3627  170 Drift  E03  -3.63000 15,000_cells + HCMEC D3_line         0
      3628  170 Drift  F01  -3.60000 10,000_cells + HCMEC D3_line         0
      3629  170 Drift  F02  -3.82000 10,000_cells + HCMEC D3_line         0
      3630  170 Drift  F03  -3.23000 10,000_cells + HCMEC D3_line         0
      3631  170 Drift  G01  -2.85000  5,000_cells + HCMEC D3_line         0
      3632  170 Drift  G02  -3.12000  5,000_cells + HCMEC D3_line         0
      3633  170 Drift  G03  -2.43000  5,000_cells + HCMEC D3_line         0
      3634  170    Rb  A01   0.97000 35,000_cells + HCMEC D3_line         0
      3635  170    Rb  A02   1.05000 35,000_cells + HCMEC D3_line         0
      3636  170    Rb  A03   0.99000 35,000_cells + HCMEC D3_line         0
      3637  170    Rb  B01   1.22000 30,000_cells + HCMEC D3_line         0
      3638  170    Rb  B02   1.24000 30,000_cells + HCMEC D3_line         0
      3639  170    Rb  B03   1.16000 30,000_cells + HCMEC D3_line         0
      3640  170    Rb  C01   1.17000 25,000_cells + HCMEC D3_line         0
      3641  170    Rb  C02   1.24000 25,000_cells + HCMEC D3_line         0
      3642  170    Rb  C03   1.19000 25,000_cells + HCMEC D3_line         0
      3643  170    Rb  D01   2.54000 20,000_cells + HCMEC D3_line         0
      3644  170    Rb  D02   1.24000 20,000_cells + HCMEC D3_line         0
      3645  170    Rb  D03   1.24000 20,000_cells + HCMEC D3_line         0
      3646  170    Rb  E01   1.50000 15,000_cells + HCMEC D3_line         0
      3647  170    Rb  E02   1.39000 15,000_cells + HCMEC D3_line         0
      3648  170    Rb  E03   1.45000 15,000_cells + HCMEC D3_line         0
      3649  170    Rb  F01   1.42000 10,000_cells + HCMEC D3_line         0
      3650  170    Rb  F02   1.52000 10,000_cells + HCMEC D3_line         0
      3651  170    Rb  F03   1.59000 10,000_cells + HCMEC D3_line         0
      3652  170    Rb  G01   0.48000  5,000_cells + HCMEC D3_line         0
      3653  170    Rb  G02   0.74000  5,000_cells + HCMEC D3_line         0
      3654  170    Rb  G03   0.60000  5,000_cells + HCMEC D3_line         0
      3655  170  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3656  170  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3657  170  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3658  170  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3659  170  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3660  170  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3661  170  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3662  170  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3663  170  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3664  170  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3665  170  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3666  170  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3667  170  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3668  170  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3669  170  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3670  170  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3671  170  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3672  170  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3673  170  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3674  170  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3675  170  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3676  175 Alpha  A01   2.92000 35,000_cells + HCMEC D3_line         0
      3677  175 Alpha  A02   3.02000 35,000_cells + HCMEC D3_line         0
      3678  175 Alpha  A03   2.90000 35,000_cells + HCMEC D3_line         0
      3679  175 Alpha  B01   3.15000 30,000_cells + HCMEC D3_line         0
      3680  175 Alpha  B02   3.26000 30,000_cells + HCMEC D3_line         0
      3681  175 Alpha  B03   3.19000 30,000_cells + HCMEC D3_line         0
      3682  175 Alpha  C01   3.28000 25,000_cells + HCMEC D3_line         0
      3683  175 Alpha  C02   3.28000 25,000_cells + HCMEC D3_line         0
      3684  175 Alpha  C03   3.41000 25,000_cells + HCMEC D3_line         0
      3685  175 Alpha  D01   4.73000 20,000_cells + HCMEC D3_line         0
      3686  175 Alpha  D02   3.51000 20,000_cells + HCMEC D3_line         0
      3687  175 Alpha  D03   3.41000 20,000_cells + HCMEC D3_line         0
      3688  175 Alpha  E01   3.57000 15,000_cells + HCMEC D3_line         0
      3689  175 Alpha  E02   3.64000 15,000_cells + HCMEC D3_line         0
      3690  175 Alpha  E03   3.56000 15,000_cells + HCMEC D3_line         0
      3691  175 Alpha  F01   3.82000 10,000_cells + HCMEC D3_line         0
      3692  175 Alpha  F02   3.94000 10,000_cells + HCMEC D3_line         0
      3693  175 Alpha  F03   3.78000 10,000_cells + HCMEC D3_line         0
      3694  175 Alpha  G01   4.82000  5,000_cells + HCMEC D3_line         0
      3695  175 Alpha  G02   4.86000  5,000_cells + HCMEC D3_line         0
      3696  175 Alpha  G03   4.76000  5,000_cells + HCMEC D3_line         0
      3697  175    Cm  A01   1.36000 35,000_cells + HCMEC D3_line         0
      3698  175    Cm  A02   1.18000 35,000_cells + HCMEC D3_line         0
      3699  175    Cm  A03   1.29000 35,000_cells + HCMEC D3_line         0
      3700  175    Cm  B01   1.09000 30,000_cells + HCMEC D3_line         0
      3701  175    Cm  B02   1.08000 30,000_cells + HCMEC D3_line         0
      3702  175    Cm  B03   1.10000 30,000_cells + HCMEC D3_line         0
      3703  175    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      3704  175    Cm  C02   1.02000 25,000_cells + HCMEC D3_line         0
      3705  175    Cm  C03   1.07000 25,000_cells + HCMEC D3_line         0
      3706  175    Cm  D01   0.95000 20,000_cells + HCMEC D3_line         0
      3707  175    Cm  D02   1.03000 20,000_cells + HCMEC D3_line         0
      3708  175    Cm  D03   1.07000 20,000_cells + HCMEC D3_line         0
      3709  175    Cm  E01   1.06000 15,000_cells + HCMEC D3_line         0
      3710  175    Cm  E02   1.03000 15,000_cells + HCMEC D3_line         0
      3711  175    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3712  175    Cm  F01   1.08000 10,000_cells + HCMEC D3_line         0
      3713  175    Cm  F02   1.05000 10,000_cells + HCMEC D3_line         0
      3714  175    Cm  F03   1.03000 10,000_cells + HCMEC D3_line         0
      3715  175    Cm  G01   1.37000  5,000_cells + HCMEC D3_line         0
      3716  175    Cm  G02   1.29000  5,000_cells + HCMEC D3_line         0
      3717  175    Cm  G03   1.17000  5,000_cells + HCMEC D3_line         0
      3718  175 Drift  A01  -3.36000 35,000_cells + HCMEC D3_line         0
      3719  175 Drift  A02  -3.81000 35,000_cells + HCMEC D3_line         0
      3720  175 Drift  A03  -3.05000 35,000_cells + HCMEC D3_line         0
      3721  175 Drift  B01  -4.17000 30,000_cells + HCMEC D3_line         0
      3722  175 Drift  B02  -4.44000 30,000_cells + HCMEC D3_line         0
      3723  175 Drift  B03  -3.89000 30,000_cells + HCMEC D3_line         0
      3724  175 Drift  C01  -4.54000 25,000_cells + HCMEC D3_line         0
      3725  175 Drift  C02  -4.88000 25,000_cells + HCMEC D3_line         0
      3726  175 Drift  C03  -4.28000 25,000_cells + HCMEC D3_line         0
      3727  175 Drift  D01  -5.27000 20,000_cells + HCMEC D3_line         0
      3728  175 Drift  D02  -4.63000 20,000_cells + HCMEC D3_line         0
      3729  175 Drift  D03  -3.92000 20,000_cells + HCMEC D3_line         0
      3730  175 Drift  E01  -3.36000 15,000_cells + HCMEC D3_line         0
      3731  175 Drift  E02  -3.83000 15,000_cells + HCMEC D3_line         0
      3732  175 Drift  E03  -3.43000 15,000_cells + HCMEC D3_line         0
      3733  175 Drift  F01  -3.41000 10,000_cells + HCMEC D3_line         0
      3734  175 Drift  F02  -3.68000 10,000_cells + HCMEC D3_line         0
      3735  175 Drift  F03  -3.03000 10,000_cells + HCMEC D3_line         0
      3736  175 Drift  G01  -2.65000  5,000_cells + HCMEC D3_line         0
      3737  175 Drift  G02  -2.88000  5,000_cells + HCMEC D3_line         0
      3738  175 Drift  G03  -2.24000  5,000_cells + HCMEC D3_line         0
      3739  175    Rb  A01   0.88000 35,000_cells + HCMEC D3_line         0
      3740  175    Rb  A02   0.99000 35,000_cells + HCMEC D3_line         0
      3741  175    Rb  A03   0.94000 35,000_cells + HCMEC D3_line         0
      3742  175    Rb  B01   1.16000 30,000_cells + HCMEC D3_line         0
      3743  175    Rb  B02   1.16000 30,000_cells + HCMEC D3_line         0
      3744  175    Rb  B03   1.09000 30,000_cells + HCMEC D3_line         0
      3745  175    Rb  C01   1.14000 25,000_cells + HCMEC D3_line         0
      3746  175    Rb  C02   1.17000 25,000_cells + HCMEC D3_line         0
      3747  175    Rb  C03   1.13000 25,000_cells + HCMEC D3_line         0
      3748  175    Rb  D01   2.62000 20,000_cells + HCMEC D3_line         0
      3749  175    Rb  D02   1.21000 20,000_cells + HCMEC D3_line         0
      3750  175    Rb  D03   1.18000 20,000_cells + HCMEC D3_line         0
      3751  175    Rb  E01   1.38000 15,000_cells + HCMEC D3_line         0
      3752  175    Rb  E02   1.33000 15,000_cells + HCMEC D3_line         0
      3753  175    Rb  E03   1.39000 15,000_cells + HCMEC D3_line         0
      3754  175    Rb  F01   1.33000 10,000_cells + HCMEC D3_line         0
      3755  175    Rb  F02   1.38000 10,000_cells + HCMEC D3_line         0
      3756  175    Rb  F03   1.57000 10,000_cells + HCMEC D3_line         0
      3757  175    Rb  G01   0.58000  5,000_cells + HCMEC D3_line         0
      3758  175    Rb  G02   0.71000  5,000_cells + HCMEC D3_line         0
      3759  175    Rb  G03   0.58000  5,000_cells + HCMEC D3_line         0
      3760  175  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3761  175  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3762  175  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3763  175  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3764  175  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3765  175  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3766  175  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3767  175  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3768  175  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3769  175  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3770  175  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3771  175  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3772  175  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3773  175  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3774  175  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3775  175  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3776  175  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3777  175  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3778  175  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3779  175  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3780  175  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3781  180 Alpha  A01   2.86000 35,000_cells + HCMEC D3_line         0
      3782  180 Alpha  A02   2.98000 35,000_cells + HCMEC D3_line         0
      3783  180 Alpha  A03   2.89000 35,000_cells + HCMEC D3_line         0
      3784  180 Alpha  B01   3.10000 30,000_cells + HCMEC D3_line         0
      3785  180 Alpha  B02   3.20000 30,000_cells + HCMEC D3_line         0
      3786  180 Alpha  B03   3.17000 30,000_cells + HCMEC D3_line         0
      3787  180 Alpha  C01   3.23000 25,000_cells + HCMEC D3_line         0
      3788  180 Alpha  C02   3.23000 25,000_cells + HCMEC D3_line         0
      3789  180 Alpha  C03   3.33000 25,000_cells + HCMEC D3_line         0
      3790  180 Alpha  D01   4.71000 20,000_cells + HCMEC D3_line         0
      3791  180 Alpha  D02   3.44000 20,000_cells + HCMEC D3_line         0
      3792  180 Alpha  D03   3.41000 20,000_cells + HCMEC D3_line         0
      3793  180 Alpha  E01   3.52000 15,000_cells + HCMEC D3_line         0
      3794  180 Alpha  E02   3.58000 15,000_cells + HCMEC D3_line         0
      3795  180 Alpha  E03   3.52000 15,000_cells + HCMEC D3_line         0
      3796  180 Alpha  F01   3.75000 10,000_cells + HCMEC D3_line         0
      3797  180 Alpha  F02   3.81000 10,000_cells + HCMEC D3_line         0
      3798  180 Alpha  F03   3.76000 10,000_cells + HCMEC D3_line         0
      3799  180 Alpha  G01   4.76000  5,000_cells + HCMEC D3_line         0
      3800  180 Alpha  G02   4.78000  5,000_cells + HCMEC D3_line         0
      3801  180 Alpha  G03   4.71000  5,000_cells + HCMEC D3_line         0
      3802  180    Cm  A01   1.38000 35,000_cells + HCMEC D3_line         0
      3803  180    Cm  A02   1.20000 35,000_cells + HCMEC D3_line         0
      3804  180    Cm  A03   1.31000 35,000_cells + HCMEC D3_line         0
      3805  180    Cm  B01   1.09000 30,000_cells + HCMEC D3_line         0
      3806  180    Cm  B02   1.06000 30,000_cells + HCMEC D3_line         0
      3807  180    Cm  B03   1.10000 30,000_cells + HCMEC D3_line         0
      3808  180    Cm  C01   1.09000 25,000_cells + HCMEC D3_line         0
      3809  180    Cm  C02   1.04000 25,000_cells + HCMEC D3_line         0
      3810  180    Cm  C03   1.06000 25,000_cells + HCMEC D3_line         0
      3811  180    Cm  D01   0.95000 20,000_cells + HCMEC D3_line         0
      3812  180    Cm  D02   1.04000 20,000_cells + HCMEC D3_line         0
      3813  180    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      3814  180    Cm  E01   1.06000 15,000_cells + HCMEC D3_line         0
      3815  180    Cm  E02   1.01000 15,000_cells + HCMEC D3_line         0
      3816  180    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3817  180    Cm  F01   1.07000 10,000_cells + HCMEC D3_line         0
      3818  180    Cm  F02   1.03000 10,000_cells + HCMEC D3_line         0
      3819  180    Cm  F03   1.02000 10,000_cells + HCMEC D3_line         0
      3820  180    Cm  G01   1.39000  5,000_cells + HCMEC D3_line         0
      3821  180    Cm  G02   1.26000  5,000_cells + HCMEC D3_line         0
      3822  180    Cm  G03   1.20000  5,000_cells + HCMEC D3_line         0
      3823  180 Drift  A01  -3.13000 35,000_cells + HCMEC D3_line         0
      3824  180 Drift  A02  -3.58000 35,000_cells + HCMEC D3_line         0
      3825  180 Drift  A03  -2.81000 35,000_cells + HCMEC D3_line         0
      3826  180 Drift  B01  -3.95000 30,000_cells + HCMEC D3_line         0
      3827  180 Drift  B02  -4.22000 30,000_cells + HCMEC D3_line         0
      3828  180 Drift  B03  -3.67000 30,000_cells + HCMEC D3_line         0
      3829  180 Drift  C01  -4.33000 25,000_cells + HCMEC D3_line         0
      3830  180 Drift  C02  -4.65000 25,000_cells + HCMEC D3_line         0
      3831  180 Drift  C03  -4.06000 25,000_cells + HCMEC D3_line         0
      3832  180 Drift  D01  -5.03000 20,000_cells + HCMEC D3_line         0
      3833  180 Drift  D02  -4.43000 20,000_cells + HCMEC D3_line         0
      3834  180 Drift  D03  -3.71000 20,000_cells + HCMEC D3_line         0
      3835  180 Drift  E01  -3.16000 15,000_cells + HCMEC D3_line         0
      3836  180 Drift  E02  -3.62000 15,000_cells + HCMEC D3_line         0
      3837  180 Drift  E03  -3.21000 15,000_cells + HCMEC D3_line         0
      3838  180 Drift  F01  -3.20000 10,000_cells + HCMEC D3_line         0
      3839  180 Drift  F02  -3.49000 10,000_cells + HCMEC D3_line         0
      3840  180 Drift  F03  -2.82000 10,000_cells + HCMEC D3_line         0
      3841  180 Drift  G01  -2.46000  5,000_cells + HCMEC D3_line         0
      3842  180 Drift  G02  -2.67000  5,000_cells + HCMEC D3_line         0
      3843  180 Drift  G03  -2.02000  5,000_cells + HCMEC D3_line         0
      3844  180    Rb  A01   0.81000 35,000_cells + HCMEC D3_line         0
      3845  180    Rb  A02   0.94000 35,000_cells + HCMEC D3_line         0
      3846  180    Rb  A03   0.87000 35,000_cells + HCMEC D3_line         0
      3847  180    Rb  B01   1.12000 30,000_cells + HCMEC D3_line         0
      3848  180    Rb  B02   1.14000 30,000_cells + HCMEC D3_line         0
      3849  180    Rb  B03   1.01000 30,000_cells + HCMEC D3_line         0
      3850  180    Rb  C01   1.05000 25,000_cells + HCMEC D3_line         0
      3851  180    Rb  C02   1.07000 25,000_cells + HCMEC D3_line         0
      3852  180    Rb  C03   1.06000 25,000_cells + HCMEC D3_line         0
      3853  180    Rb  D01   2.28000 20,000_cells + HCMEC D3_line         0
      3854  180    Rb  D02   1.15000 20,000_cells + HCMEC D3_line         0
      3855  180    Rb  D03   1.05000 20,000_cells + HCMEC D3_line         0
      3856  180    Rb  E01   1.34000 15,000_cells + HCMEC D3_line         0
      3857  180    Rb  E02   1.29000 15,000_cells + HCMEC D3_line         0
      3858  180    Rb  E03   1.32000 15,000_cells + HCMEC D3_line         0
      3859  180    Rb  F01   1.28000 10,000_cells + HCMEC D3_line         0
      3860  180    Rb  F02   1.36000 10,000_cells + HCMEC D3_line         0
      3861  180    Rb  F03   1.48000 10,000_cells + HCMEC D3_line         0
      3862  180    Rb  G01   0.65000  5,000_cells + HCMEC D3_line         0
      3863  180    Rb  G02   0.78000  5,000_cells + HCMEC D3_line         0
      3864  180    Rb  G03   0.62000  5,000_cells + HCMEC D3_line         0
      3865  180  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3866  180  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3867  180  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3868  180  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3869  180  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3870  180  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3871  180  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3872  180  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3873  180  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3874  180  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3875  180  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3876  180  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3877  180  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3878  180  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3879  180  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3880  180  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3881  180  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3882  180  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3883  180  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3884  180  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3885  180  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3886  185 Alpha  A01   2.80000 35,000_cells + HCMEC D3_line         0
      3887  185 Alpha  A02   2.92000 35,000_cells + HCMEC D3_line         0
      3888  185 Alpha  A03   2.84000 35,000_cells + HCMEC D3_line         0
      3889  185 Alpha  B01   3.11000 30,000_cells + HCMEC D3_line         0
      3890  185 Alpha  B02   3.19000 30,000_cells + HCMEC D3_line         0
      3891  185 Alpha  B03   3.12000 30,000_cells + HCMEC D3_line         0
      3892  185 Alpha  C01   3.21000 25,000_cells + HCMEC D3_line         0
      3893  185 Alpha  C02   3.16000 25,000_cells + HCMEC D3_line         0
      3894  185 Alpha  C03   3.30000 25,000_cells + HCMEC D3_line         0
      3895  185 Alpha  D01   4.65000 20,000_cells + HCMEC D3_line         0
      3896  185 Alpha  D02   3.39000 20,000_cells + HCMEC D3_line         0
      3897  185 Alpha  D03   3.36000 20,000_cells + HCMEC D3_line         0
      3898  185 Alpha  E01   3.50000 15,000_cells + HCMEC D3_line         0
      3899  185 Alpha  E02   3.54000 15,000_cells + HCMEC D3_line         0
      3900  185 Alpha  E03   3.50000 15,000_cells + HCMEC D3_line         0
      3901  185 Alpha  F01   3.73000 10,000_cells + HCMEC D3_line         0
      3902  185 Alpha  F02   3.78000 10,000_cells + HCMEC D3_line         0
      3903  185 Alpha  F03   3.74000 10,000_cells + HCMEC D3_line         0
      3904  185 Alpha  G01   4.65000  5,000_cells + HCMEC D3_line         0
      3905  185 Alpha  G02   4.69000  5,000_cells + HCMEC D3_line         0
      3906  185 Alpha  G03   4.70000  5,000_cells + HCMEC D3_line         0
      3907  185    Cm  A01   1.39000 35,000_cells + HCMEC D3_line         0
      3908  185    Cm  A02   1.20000 35,000_cells + HCMEC D3_line         0
      3909  185    Cm  A03   1.33000 35,000_cells + HCMEC D3_line         0
      3910  185    Cm  B01   1.10000 30,000_cells + HCMEC D3_line         0
      3911  185    Cm  B02   1.06000 30,000_cells + HCMEC D3_line         0
      3912  185    Cm  B03   1.12000 30,000_cells + HCMEC D3_line         0
      3913  185    Cm  C01   1.08000 25,000_cells + HCMEC D3_line         0
      3914  185    Cm  C02   1.04000 25,000_cells + HCMEC D3_line         0
      3915  185    Cm  C03   1.08000 25,000_cells + HCMEC D3_line         0
      3916  185    Cm  D01   0.93000 20,000_cells + HCMEC D3_line         0
      3917  185    Cm  D02   1.05000 20,000_cells + HCMEC D3_line         0
      3918  185    Cm  D03   1.08000 20,000_cells + HCMEC D3_line         0
      3919  185    Cm  E01   1.06000 15,000_cells + HCMEC D3_line         0
      3920  185    Cm  E02   1.00000 15,000_cells + HCMEC D3_line         0
      3921  185    Cm  E03   1.07000 15,000_cells + HCMEC D3_line         0
      3922  185    Cm  F01   1.06000 10,000_cells + HCMEC D3_line         0
      3923  185    Cm  F02   1.04000 10,000_cells + HCMEC D3_line         0
      3924  185    Cm  F03   1.04000 10,000_cells + HCMEC D3_line         0
      3925  185    Cm  G01   1.37000  5,000_cells + HCMEC D3_line         0
      3926  185    Cm  G02   1.20000  5,000_cells + HCMEC D3_line         0
      3927  185    Cm  G03   1.18000  5,000_cells + HCMEC D3_line         0
      3928  185 Drift  A01  -2.88000 35,000_cells + HCMEC D3_line         0
      3929  185 Drift  A02  -3.34000 35,000_cells + HCMEC D3_line         0
      3930  185 Drift  A03  -2.56000 35,000_cells + HCMEC D3_line         0
      3931  185 Drift  B01  -3.72000 30,000_cells + HCMEC D3_line         0
      3932  185 Drift  B02  -3.99000 30,000_cells + HCMEC D3_line         0
      3933  185 Drift  B03  -3.43000 30,000_cells + HCMEC D3_line         0
      3934  185 Drift  C01  -4.09000 25,000_cells + HCMEC D3_line         0
      3935  185 Drift  C02  -4.43000 25,000_cells + HCMEC D3_line         0
      3936  185 Drift  C03  -3.83000 25,000_cells + HCMEC D3_line         0
      3937  185 Drift  D01  -4.82000 20,000_cells + HCMEC D3_line         0
      3938  185 Drift  D02  -4.20000 20,000_cells + HCMEC D3_line         0
      3939  185 Drift  D03  -3.48000 20,000_cells + HCMEC D3_line         0
      3940  185 Drift  E01  -2.93000 15,000_cells + HCMEC D3_line         0
      3941  185 Drift  E02  -3.41000 15,000_cells + HCMEC D3_line         0
      3942  185 Drift  E03  -2.99000 15,000_cells + HCMEC D3_line         0
      3943  185 Drift  F01  -2.98000 10,000_cells + HCMEC D3_line         0
      3944  185 Drift  F02  -3.31000 10,000_cells + HCMEC D3_line         0
      3945  185 Drift  F03  -2.61000 10,000_cells + HCMEC D3_line         0
      3946  185 Drift  G01  -2.23000  5,000_cells + HCMEC D3_line         0
      3947  185 Drift  G02  -2.47000  5,000_cells + HCMEC D3_line         0
      3948  185 Drift  G03  -1.83000  5,000_cells + HCMEC D3_line         0
      3949  185    Rb  A01   0.77000 35,000_cells + HCMEC D3_line         0
      3950  185    Rb  A02   0.90000 35,000_cells + HCMEC D3_line         0
      3951  185    Rb  A03   0.80000 35,000_cells + HCMEC D3_line         0
      3952  185    Rb  B01   1.04000 30,000_cells + HCMEC D3_line         0
      3953  185    Rb  B02   1.04000 30,000_cells + HCMEC D3_line         0
      3954  185    Rb  B03   0.96000 30,000_cells + HCMEC D3_line         0
      3955  185    Rb  C01   0.98000 25,000_cells + HCMEC D3_line         0
      3956  185    Rb  C02   1.05000 25,000_cells + HCMEC D3_line         0
      3957  185    Rb  C03   0.98000 25,000_cells + HCMEC D3_line         0
      3958  185    Rb  D01   1.99000 20,000_cells + HCMEC D3_line         0
      3959  185    Rb  D02   1.05000 20,000_cells + HCMEC D3_line         0
      3960  185    Rb  D03   1.02000 20,000_cells + HCMEC D3_line         0
      3961  185    Rb  E01   1.27000 15,000_cells + HCMEC D3_line         0
      3962  185    Rb  E02   1.22000 15,000_cells + HCMEC D3_line         0
      3963  185    Rb  E03   1.23000 15,000_cells + HCMEC D3_line         0
      3964  185    Rb  F01   1.24000 10,000_cells + HCMEC D3_line         0
      3965  185    Rb  F02   1.26000 10,000_cells + HCMEC D3_line         0
      3966  185    Rb  F03   1.37000 10,000_cells + HCMEC D3_line         0
      3967  185    Rb  G01   0.66000  5,000_cells + HCMEC D3_line         0
      3968  185    Rb  G02   0.93000  5,000_cells + HCMEC D3_line         0
      3969  185    Rb  G03   0.58000  5,000_cells + HCMEC D3_line         0
      3970  185  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      3971  185  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      3972  185  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      3973  185  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      3974  185  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      3975  185  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      3976  185  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      3977  185  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      3978  185  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      3979  185  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      3980  185  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      3981  185  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      3982  185  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      3983  185  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      3984  185  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      3985  185  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      3986  185  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      3987  185  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      3988  185  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      3989  185  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      3990  185  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      3991  190 Alpha  A01   2.77000 35,000_cells + HCMEC D3_line         0
      3992  190 Alpha  A02   2.90000 35,000_cells + HCMEC D3_line         0
      3993  190 Alpha  A03   2.79000 35,000_cells + HCMEC D3_line         0
      3994  190 Alpha  B01   3.11000 30,000_cells + HCMEC D3_line         0
      3995  190 Alpha  B02   3.17000 30,000_cells + HCMEC D3_line         0
      3996  190 Alpha  B03   3.11000 30,000_cells + HCMEC D3_line         0
      3997  190 Alpha  C01   3.17000 25,000_cells + HCMEC D3_line         0
      3998  190 Alpha  C02   3.14000 25,000_cells + HCMEC D3_line         0
      3999  190 Alpha  C03   3.26000 25,000_cells + HCMEC D3_line         0
      4000  190 Alpha  D01   4.58000 20,000_cells + HCMEC D3_line         0
      4001  190 Alpha  D02   3.36000 20,000_cells + HCMEC D3_line         0
      4002  190 Alpha  D03   3.31000 20,000_cells + HCMEC D3_line         0
      4003  190 Alpha  E01   3.46000 15,000_cells + HCMEC D3_line         0
      4004  190 Alpha  E02   3.51000 15,000_cells + HCMEC D3_line         0
      4005  190 Alpha  E03   3.46000 15,000_cells + HCMEC D3_line         0
      4006  190 Alpha  F01   3.70000 10,000_cells + HCMEC D3_line         0
      4007  190 Alpha  F02   3.72000 10,000_cells + HCMEC D3_line         0
      4008  190 Alpha  F03   3.70000 10,000_cells + HCMEC D3_line         0
      4009  190 Alpha  G01   4.52000  5,000_cells + HCMEC D3_line         0
      4010  190 Alpha  G02   4.63000  5,000_cells + HCMEC D3_line         0
      4011  190 Alpha  G03   4.55000  5,000_cells + HCMEC D3_line         0
      4012  190    Cm  A01   1.43000 35,000_cells + HCMEC D3_line         0
      4013  190    Cm  A02   1.21000 35,000_cells + HCMEC D3_line         0
      4014  190    Cm  A03   1.34000 35,000_cells + HCMEC D3_line         0
      4015  190    Cm  B01   1.09000 30,000_cells + HCMEC D3_line         0
      4016  190    Cm  B02   1.06000 30,000_cells + HCMEC D3_line         0
      4017  190    Cm  B03   1.09000 30,000_cells + HCMEC D3_line         0
      4018  190    Cm  C01   1.07000 25,000_cells + HCMEC D3_line         0
      4019  190    Cm  C02   1.02000 25,000_cells + HCMEC D3_line         0
      4020  190    Cm  C03   1.06000 25,000_cells + HCMEC D3_line         0
      4021  190    Cm  D01   0.92000 20,000_cells + HCMEC D3_line         0
      4022  190    Cm  D02   1.03000 20,000_cells + HCMEC D3_line         0
      4023  190    Cm  D03   1.09000 20,000_cells + HCMEC D3_line         0
      4024  190    Cm  E01   1.07000 15,000_cells + HCMEC D3_line         0
      4025  190    Cm  E02   1.02000 15,000_cells + HCMEC D3_line         0
      4026  190    Cm  E03   1.06000 15,000_cells + HCMEC D3_line         0
      4027  190    Cm  F01   1.06000 10,000_cells + HCMEC D3_line         0
      4028  190    Cm  F02   1.02000 10,000_cells + HCMEC D3_line         0
      4029  190    Cm  F03   1.04000 10,000_cells + HCMEC D3_line         0
      4030  190    Cm  G01   1.35000  5,000_cells + HCMEC D3_line         0
      4031  190    Cm  G02   1.17000  5,000_cells + HCMEC D3_line         0
      4032  190    Cm  G03   1.17000  5,000_cells + HCMEC D3_line         0
      4033  190 Drift  A01  -2.62000 35,000_cells + HCMEC D3_line         0
      4034  190 Drift  A02  -3.08000 35,000_cells + HCMEC D3_line         0
      4035  190 Drift  A03  -2.28000 35,000_cells + HCMEC D3_line         0
      4036  190 Drift  B01  -3.47000 30,000_cells + HCMEC D3_line         0
      4037  190 Drift  B02  -3.74000 30,000_cells + HCMEC D3_line         0
      4038  190 Drift  B03  -3.16000 30,000_cells + HCMEC D3_line         0
      4039  190 Drift  C01  -3.84000 25,000_cells + HCMEC D3_line         0
      4040  190 Drift  C02  -4.18000 25,000_cells + HCMEC D3_line         0
      4041  190 Drift  C03  -3.57000 25,000_cells + HCMEC D3_line         0
      4042  190 Drift  D01  -4.53000 20,000_cells + HCMEC D3_line         0
      4043  190 Drift  D02  -3.94000 20,000_cells + HCMEC D3_line         0
      4044  190 Drift  D03  -3.23000 20,000_cells + HCMEC D3_line         0
      4045  190 Drift  E01  -2.69000 15,000_cells + HCMEC D3_line         0
      4046  190 Drift  E02  -3.16000 15,000_cells + HCMEC D3_line         0
      4047  190 Drift  E03  -2.73000 15,000_cells + HCMEC D3_line         0
      4048  190 Drift  F01  -2.74000 10,000_cells + HCMEC D3_line         0
      4049  190 Drift  F02  -3.11000 10,000_cells + HCMEC D3_line         0
      4050  190 Drift  F03  -2.35000 10,000_cells + HCMEC D3_line         0
      4051  190 Drift  G01  -1.98000  5,000_cells + HCMEC D3_line         0
      4052  190 Drift  G02  -2.22000  5,000_cells + HCMEC D3_line         0
      4053  190 Drift  G03  -1.53000  5,000_cells + HCMEC D3_line         0
      4054  190    Rb  A01   0.68000 35,000_cells + HCMEC D3_line         0
      4055  190    Rb  A02   0.85000 35,000_cells + HCMEC D3_line         0
      4056  190    Rb  A03   0.75000 35,000_cells + HCMEC D3_line         0
      4057  190    Rb  B01   0.97000 30,000_cells + HCMEC D3_line         0
      4058  190    Rb  B02   1.00000 30,000_cells + HCMEC D3_line         0
      4059  190    Rb  B03   0.92000 30,000_cells + HCMEC D3_line         0
      4060  190    Rb  C01   0.94000 25,000_cells + HCMEC D3_line         0
      4061  190    Rb  C02   0.99000 25,000_cells + HCMEC D3_line         0
      4062  190    Rb  C03   0.96000 25,000_cells + HCMEC D3_line         0
      4063  190    Rb  D01   1.55000 20,000_cells + HCMEC D3_line         0
      4064  190    Rb  D02   1.00000 20,000_cells + HCMEC D3_line         0
      4065  190    Rb  D03   0.96000 20,000_cells + HCMEC D3_line         0
      4066  190    Rb  E01   1.18000 15,000_cells + HCMEC D3_line         0
      4067  190    Rb  E02   1.15000 15,000_cells + HCMEC D3_line         0
      4068  190    Rb  E03   1.18000 15,000_cells + HCMEC D3_line         0
      4069  190    Rb  F01   1.20000 10,000_cells + HCMEC D3_line         0
      4070  190    Rb  F02   1.25000 10,000_cells + HCMEC D3_line         0
      4071  190    Rb  F03   1.29000 10,000_cells + HCMEC D3_line         0
      4072  190    Rb  G01   0.78000  5,000_cells + HCMEC D3_line         0
      4073  190    Rb  G02   0.96000  5,000_cells + HCMEC D3_line         0
      4074  190    Rb  G03   0.65000  5,000_cells + HCMEC D3_line         0
      4075  190  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      4076  190  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      4077  190  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      4078  190  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      4079  190  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      4080  190  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      4081  190  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      4082  190  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      4083  190  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      4084  190  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      4085  190  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      4086  190  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      4087  190  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      4088  190  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      4089  190  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      4090  190  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      4091  190  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      4092  190  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      4093  190  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      4094  190  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      4095  190  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      4096  195 Alpha  A01   2.71000 35,000_cells + HCMEC D3_line         0
      4097  195 Alpha  A02   2.90000 35,000_cells + HCMEC D3_line         0
      4098  195 Alpha  A03   2.78000 35,000_cells + HCMEC D3_line         0
      4099  195 Alpha  B01   3.03000 30,000_cells + HCMEC D3_line         0
      4100  195 Alpha  B02   3.12000 30,000_cells + HCMEC D3_line         0
      4101  195 Alpha  B03   3.06000 30,000_cells + HCMEC D3_line         0
      4102  195 Alpha  C01   3.16000 25,000_cells + HCMEC D3_line         0
      4103  195 Alpha  C02   3.12000 25,000_cells + HCMEC D3_line         0
      4104  195 Alpha  C03   3.25000 25,000_cells + HCMEC D3_line         0
      4105  195 Alpha  D01   4.50000 20,000_cells + HCMEC D3_line         0
      4106  195 Alpha  D02   3.35000 20,000_cells + HCMEC D3_line         0
      4107  195 Alpha  D03   3.31000 20,000_cells + HCMEC D3_line         0
      4108  195 Alpha  E01   3.41000 15,000_cells + HCMEC D3_line         0
      4109  195 Alpha  E02   3.45000 15,000_cells + HCMEC D3_line         0
      4110  195 Alpha  E03   3.41000 15,000_cells + HCMEC D3_line         0
      4111  195 Alpha  F01   3.65000 10,000_cells + HCMEC D3_line         0
      4112  195 Alpha  F02   3.65000 10,000_cells + HCMEC D3_line         0
      4113  195 Alpha  F03   3.65000 10,000_cells + HCMEC D3_line         0
      4114  195 Alpha  G01   4.47000  5,000_cells + HCMEC D3_line         0
      4115  195 Alpha  G02   4.52000  5,000_cells + HCMEC D3_line         0
      4116  195 Alpha  G03   4.57000  5,000_cells + HCMEC D3_line         0
      4117  195    Cm  A01   1.43000 35,000_cells + HCMEC D3_line         0
      4118  195    Cm  A02   1.23000 35,000_cells + HCMEC D3_line         0
      4119  195    Cm  A03   1.32000 35,000_cells + HCMEC D3_line         0
      4120  195    Cm  B01   1.11000 30,000_cells + HCMEC D3_line         0
      4121  195    Cm  B02   1.06000 30,000_cells + HCMEC D3_line         0
      4122  195    Cm  B03   1.11000 30,000_cells + HCMEC D3_line         0
      4123  195    Cm  C01   1.10000 25,000_cells + HCMEC D3_line         0
      4124  195    Cm  C02   1.02000 25,000_cells + HCMEC D3_line         0
      4125  195    Cm  C03   1.10000 25,000_cells + HCMEC D3_line         0
      4126  195    Cm  D01   0.90000 20,000_cells + HCMEC D3_line         0
      4127  195    Cm  D02   1.06000 20,000_cells + HCMEC D3_line         0
      4128  195    Cm  D03   1.08000 20,000_cells + HCMEC D3_line         0
      4129  195    Cm  E01   1.06000 15,000_cells + HCMEC D3_line         0
      4130  195    Cm  E02   1.02000 15,000_cells + HCMEC D3_line         0
      4131  195    Cm  E03   1.05000 15,000_cells + HCMEC D3_line         0
      4132  195    Cm  F01   1.05000 10,000_cells + HCMEC D3_line         0
      4133  195    Cm  F02   1.03000 10,000_cells + HCMEC D3_line         0
      4134  195    Cm  F03   1.04000 10,000_cells + HCMEC D3_line         0
      4135  195    Cm  G01   1.29000  5,000_cells + HCMEC D3_line         0
      4136  195    Cm  G02   1.18000  5,000_cells + HCMEC D3_line         0
      4137  195    Cm  G03   1.19000  5,000_cells + HCMEC D3_line         0
      4138  195 Drift  A01  -2.40000 35,000_cells + HCMEC D3_line         0
      4139  195 Drift  A02  -2.84000 35,000_cells + HCMEC D3_line         0
      4140  195 Drift  A03  -2.02000 35,000_cells + HCMEC D3_line         0
      4141  195 Drift  B01  -3.23000 30,000_cells + HCMEC D3_line         0
      4142  195 Drift  B02  -3.49000 30,000_cells + HCMEC D3_line         0
      4143  195 Drift  B03  -2.92000 30,000_cells + HCMEC D3_line         0
      4144  195 Drift  C01  -3.60000 25,000_cells + HCMEC D3_line         0
      4145  195 Drift  C02  -3.95000 25,000_cells + HCMEC D3_line         0
      4146  195 Drift  C03  -3.33000 25,000_cells + HCMEC D3_line         0
      4147  195 Drift  D01  -4.28000 20,000_cells + HCMEC D3_line         0
      4148  195 Drift  D02  -3.72000 20,000_cells + HCMEC D3_line         0
      4149  195 Drift  D03  -2.99000 20,000_cells + HCMEC D3_line         0
      4150  195 Drift  E01  -2.46000 15,000_cells + HCMEC D3_line         0
      4151  195 Drift  E02  -2.95000 15,000_cells + HCMEC D3_line         0
      4152  195 Drift  E03  -2.50000 15,000_cells + HCMEC D3_line         0
      4153  195 Drift  F01  -2.50000 10,000_cells + HCMEC D3_line         0
      4154  195 Drift  F02  -2.88000 10,000_cells + HCMEC D3_line         0
      4155  195 Drift  F03  -2.11000 10,000_cells + HCMEC D3_line         0
      4156  195 Drift  G01  -1.74000  5,000_cells + HCMEC D3_line         0
      4157  195 Drift  G02  -1.98000  5,000_cells + HCMEC D3_line         0
      4158  195 Drift  G03  -1.33000  5,000_cells + HCMEC D3_line         0
      4159  195    Rb  A01   0.62000 35,000_cells + HCMEC D3_line         0
      4160  195    Rb  A02   0.77000 35,000_cells + HCMEC D3_line         0
      4161  195    Rb  A03   0.69000 35,000_cells + HCMEC D3_line         0
      4162  195    Rb  B01   0.92000 30,000_cells + HCMEC D3_line         0
      4163  195    Rb  B02   0.93000 30,000_cells + HCMEC D3_line         0
      4164  195    Rb  B03   0.85000 30,000_cells + HCMEC D3_line         0
      4165  195    Rb  C01   0.84000 25,000_cells + HCMEC D3_line         0
      4166  195    Rb  C02   0.92000 25,000_cells + HCMEC D3_line         0
      4167  195    Rb  C03   0.87000 25,000_cells + HCMEC D3_line         0
      4168  195    Rb  D01   1.31000 20,000_cells + HCMEC D3_line         0
      4169  195    Rb  D02   0.88000 20,000_cells + HCMEC D3_line         0
      4170  195    Rb  D03   0.88000 20,000_cells + HCMEC D3_line         0
      4171  195    Rb  E01   1.12000 15,000_cells + HCMEC D3_line         0
      4172  195    Rb  E02   1.07000 15,000_cells + HCMEC D3_line         0
      4173  195    Rb  E03   1.13000 15,000_cells + HCMEC D3_line         0
      4174  195    Rb  F01   1.11000 10,000_cells + HCMEC D3_line         0
      4175  195    Rb  F02   1.15000 10,000_cells + HCMEC D3_line         0
      4176  195    Rb  F03   1.22000 10,000_cells + HCMEC D3_line         0
      4177  195    Rb  G01   0.80000  5,000_cells + HCMEC D3_line         0
      4178  195    Rb  G02   1.00000  5,000_cells + HCMEC D3_line         0
      4179  195    Rb  G03   0.58000  5,000_cells + HCMEC D3_line         0
      4180  195  RMSE  A01   0.01000 35,000_cells + HCMEC D3_line         0
      4181  195  RMSE  A02   0.01000 35,000_cells + HCMEC D3_line         0
      4182  195  RMSE  A03   0.01000 35,000_cells + HCMEC D3_line         0
      4183  195  RMSE  B01   0.01000 30,000_cells + HCMEC D3_line         0
      4184  195  RMSE  B02   0.01000 30,000_cells + HCMEC D3_line         0
      4185  195  RMSE  B03   0.01000 30,000_cells + HCMEC D3_line         0
      4186  195  RMSE  C01   0.01000 25,000_cells + HCMEC D3_line         0
      4187  195  RMSE  C02   0.01000 25,000_cells + HCMEC D3_line         0
      4188  195  RMSE  C03   0.01000 25,000_cells + HCMEC D3_line         0
      4189  195  RMSE  D01   0.01000 20,000_cells + HCMEC D3_line         0
      4190  195  RMSE  D02   0.01000 20,000_cells + HCMEC D3_line         0
      4191  195  RMSE  D03   0.01000 20,000_cells + HCMEC D3_line         0
      4192  195  RMSE  E01   0.01000 15,000_cells + HCMEC D3_line         0
      4193  195  RMSE  E02   0.01000 15,000_cells + HCMEC D3_line         0
      4194  195  RMSE  E03   0.01000 15,000_cells + HCMEC D3_line         0
      4195  195  RMSE  F01   0.01000 10,000_cells + HCMEC D3_line         0
      4196  195  RMSE  F02   0.01000 10,000_cells + HCMEC D3_line         0
      4197  195  RMSE  F03   0.01000 10,000_cells + HCMEC D3_line         0
      4198  195  RMSE  G01   0.01000  5,000_cells + HCMEC D3_line         0
      4199  195  RMSE  G02   0.01000  5,000_cells + HCMEC D3_line         0
      4200  195  RMSE  G03   0.01000  5,000_cells + HCMEC D3_line         0
      4201  200 Alpha  A01        NA 35,000_cells + HCMEC D3_line         0
      4202  200 Alpha  A02        NA 35,000_cells + HCMEC D3_line         0
      4203  200 Alpha  A03        NA 35,000_cells + HCMEC D3_line         0
      4204  200 Alpha  B01        NA 30,000_cells + HCMEC D3_line         0
      4205  200 Alpha  B02        NA 30,000_cells + HCMEC D3_line         0
      4206  200 Alpha  B03        NA 30,000_cells + HCMEC D3_line         0
      4207  200 Alpha  C01        NA 25,000_cells + HCMEC D3_line         0
      4208  200 Alpha  C02        NA 25,000_cells + HCMEC D3_line         0
      4209  200 Alpha  C03        NA 25,000_cells + HCMEC D3_line         0
      4210  200 Alpha  D01        NA 20,000_cells + HCMEC D3_line         0
      4211  200 Alpha  D02        NA 20,000_cells + HCMEC D3_line         0
      4212  200 Alpha  D03        NA 20,000_cells + HCMEC D3_line         0
      4213  200 Alpha  E01        NA 15,000_cells + HCMEC D3_line         0
      4214  200 Alpha  E02        NA 15,000_cells + HCMEC D3_line         0
      4215  200 Alpha  E03        NA 15,000_cells + HCMEC D3_line         0
      4216  200 Alpha  F01        NA 10,000_cells + HCMEC D3_line         0
      4217  200 Alpha  F02        NA 10,000_cells + HCMEC D3_line         0
      4218  200 Alpha  F03        NA 10,000_cells + HCMEC D3_line         0
      4219  200 Alpha  G01        NA  5,000_cells + HCMEC D3_line         0
      4220  200 Alpha  G02        NA  5,000_cells + HCMEC D3_line         0
      4221  200 Alpha  G03        NA  5,000_cells + HCMEC D3_line         0
      4222  200    Cm  A01        NA 35,000_cells + HCMEC D3_line         0
      4223  200    Cm  A02        NA 35,000_cells + HCMEC D3_line         0
      4224  200    Cm  A03        NA 35,000_cells + HCMEC D3_line         0
      4225  200    Cm  B01        NA 30,000_cells + HCMEC D3_line         0
      4226  200    Cm  B02        NA 30,000_cells + HCMEC D3_line         0
      4227  200    Cm  B03        NA 30,000_cells + HCMEC D3_line         0
      4228  200    Cm  C01        NA 25,000_cells + HCMEC D3_line         0
      4229  200    Cm  C02        NA 25,000_cells + HCMEC D3_line         0
      4230  200    Cm  C03        NA 25,000_cells + HCMEC D3_line         0
      4231  200    Cm  D01        NA 20,000_cells + HCMEC D3_line         0
      4232  200    Cm  D02        NA 20,000_cells + HCMEC D3_line         0
      4233  200    Cm  D03        NA 20,000_cells + HCMEC D3_line         0
      4234  200    Cm  E01        NA 15,000_cells + HCMEC D3_line         0
      4235  200    Cm  E02        NA 15,000_cells + HCMEC D3_line         0
      4236  200    Cm  E03        NA 15,000_cells + HCMEC D3_line         0
      4237  200    Cm  F01        NA 10,000_cells + HCMEC D3_line         0
      4238  200    Cm  F02        NA 10,000_cells + HCMEC D3_line         0
      4239  200    Cm  F03        NA 10,000_cells + HCMEC D3_line         0
      4240  200    Cm  G01        NA  5,000_cells + HCMEC D3_line         0
      4241  200    Cm  G02        NA  5,000_cells + HCMEC D3_line         0
      4242  200    Cm  G03        NA  5,000_cells + HCMEC D3_line         0
      4243  200 Drift  A01        NA 35,000_cells + HCMEC D3_line         0
      4244  200 Drift  A02        NA 35,000_cells + HCMEC D3_line         0
      4245  200 Drift  A03        NA 35,000_cells + HCMEC D3_line         0
      4246  200 Drift  B01        NA 30,000_cells + HCMEC D3_line         0
      4247  200 Drift  B02        NA 30,000_cells + HCMEC D3_line         0
      4248  200 Drift  B03        NA 30,000_cells + HCMEC D3_line         0
      4249  200 Drift  C01        NA 25,000_cells + HCMEC D3_line         0
      4250  200 Drift  C02        NA 25,000_cells + HCMEC D3_line         0
      4251  200 Drift  C03        NA 25,000_cells + HCMEC D3_line         0
      4252  200 Drift  D01        NA 20,000_cells + HCMEC D3_line         0
      4253  200 Drift  D02        NA 20,000_cells + HCMEC D3_line         0
      4254  200 Drift  D03        NA 20,000_cells + HCMEC D3_line         0
      4255  200 Drift  E01        NA 15,000_cells + HCMEC D3_line         0
      4256  200 Drift  E02        NA 15,000_cells + HCMEC D3_line         0
      4257  200 Drift  E03        NA 15,000_cells + HCMEC D3_line         0
      4258  200 Drift  F01        NA 10,000_cells + HCMEC D3_line         0
      4259  200 Drift  F02        NA 10,000_cells + HCMEC D3_line         0
      4260  200 Drift  F03        NA 10,000_cells + HCMEC D3_line         0
      4261  200 Drift  G01        NA  5,000_cells + HCMEC D3_line         0
      4262  200 Drift  G02        NA  5,000_cells + HCMEC D3_line         0
      4263  200 Drift  G03        NA  5,000_cells + HCMEC D3_line         0
      4264  200    Rb  A01        NA 35,000_cells + HCMEC D3_line         0
      4265  200    Rb  A02        NA 35,000_cells + HCMEC D3_line         0
      4266  200    Rb  A03        NA 35,000_cells + HCMEC D3_line         0
      4267  200    Rb  B01        NA 30,000_cells + HCMEC D3_line         0
      4268  200    Rb  B02        NA 30,000_cells + HCMEC D3_line         0
      4269  200    Rb  B03        NA 30,000_cells + HCMEC D3_line         0
      4270  200    Rb  C01        NA 25,000_cells + HCMEC D3_line         0
      4271  200    Rb  C02        NA 25,000_cells + HCMEC D3_line         0
      4272  200    Rb  C03        NA 25,000_cells + HCMEC D3_line         0
      4273  200    Rb  D01        NA 20,000_cells + HCMEC D3_line         0
      4274  200    Rb  D02        NA 20,000_cells + HCMEC D3_line         0
      4275  200    Rb  D03        NA 20,000_cells + HCMEC D3_line         0
      4276  200    Rb  E01        NA 15,000_cells + HCMEC D3_line         0
      4277  200    Rb  E02        NA 15,000_cells + HCMEC D3_line         0
      4278  200    Rb  E03        NA 15,000_cells + HCMEC D3_line         0
      4279  200    Rb  F01        NA 10,000_cells + HCMEC D3_line         0
      4280  200    Rb  F02        NA 10,000_cells + HCMEC D3_line         0
      4281  200    Rb  F03        NA 10,000_cells + HCMEC D3_line         0
      4282  200    Rb  G01        NA  5,000_cells + HCMEC D3_line         0
      4283  200    Rb  G02        NA  5,000_cells + HCMEC D3_line         0
      4284  200    Rb  G03        NA  5,000_cells + HCMEC D3_line         0
      4285  200  RMSE  A01        NA 35,000_cells + HCMEC D3_line         0
      4286  200  RMSE  A02        NA 35,000_cells + HCMEC D3_line         0
      4287  200  RMSE  A03        NA 35,000_cells + HCMEC D3_line         0
      4288  200  RMSE  B01        NA 30,000_cells + HCMEC D3_line         0
      4289  200  RMSE  B02        NA 30,000_cells + HCMEC D3_line         0
      4290  200  RMSE  B03        NA 30,000_cells + HCMEC D3_line         0
      4291  200  RMSE  C01        NA 25,000_cells + HCMEC D3_line         0
      4292  200  RMSE  C02        NA 25,000_cells + HCMEC D3_line         0
      4293  200  RMSE  C03        NA 25,000_cells + HCMEC D3_line         0
      4294  200  RMSE  D01        NA 20,000_cells + HCMEC D3_line         0
      4295  200  RMSE  D02        NA 20,000_cells + HCMEC D3_line         0
      4296  200  RMSE  D03        NA 20,000_cells + HCMEC D3_line         0
      4297  200  RMSE  E01        NA 15,000_cells + HCMEC D3_line         0
      4298  200  RMSE  E02        NA 15,000_cells + HCMEC D3_line         0
      4299  200  RMSE  E03        NA 15,000_cells + HCMEC D3_line         0
      4300  200  RMSE  F01        NA 10,000_cells + HCMEC D3_line         0
      4301  200  RMSE  F02        NA 10,000_cells + HCMEC D3_line         0
      4302  200  RMSE  F03        NA 10,000_cells + HCMEC D3_line         0
      4303  200  RMSE  G01        NA  5,000_cells + HCMEC D3_line         0
      4304  200  RMSE  G02        NA  5,000_cells + HCMEC D3_line         0
      4305  200  RMSE  G03        NA  5,000_cells + HCMEC D3_line         0
      4306    0     C  A01        NA 35,000_cells + HCMEC D3_line      1000
      4307    5     C  A01 117.84576 35,000_cells + HCMEC D3_line      1000
      4308   10     C  A01 116.92351 35,000_cells + HCMEC D3_line      1000
      4309   15     C  A01 115.57385 35,000_cells + HCMEC D3_line      1000
      4310   20     C  A01 114.94466 35,000_cells + HCMEC D3_line      1000
      4311   25     C  A01 114.78655 35,000_cells + HCMEC D3_line      1000
      4312   30     C  A01 115.32148 35,000_cells + HCMEC D3_line      1000
      4313   35     C  A01 115.48468 35,000_cells + HCMEC D3_line      1000
      4314   40     C  A01 116.12190 35,000_cells + HCMEC D3_line      1000
      4315   45     C  A01 116.98194 35,000_cells + HCMEC D3_line      1000
      4316   50     C  A01 117.91218 35,000_cells + HCMEC D3_line      1000
      4317   55     C  A01 118.71455 35,000_cells + HCMEC D3_line      1000
      4318   60     C  A01 119.34482 35,000_cells + HCMEC D3_line      1000
      4319   65     C  A01 119.96451 35,000_cells + HCMEC D3_line      1000
      4320   70     C  A01 120.56143 35,000_cells + HCMEC D3_line      1000
      4321   75     C  A01 120.94865 35,000_cells + HCMEC D3_line      1000
      4322   80     C  A01 121.33362 35,000_cells + HCMEC D3_line      1000
      4323   85     C  A01 121.71808 35,000_cells + HCMEC D3_line      1000
      4324   90     C  A01 121.97599 35,000_cells + HCMEC D3_line      1000
      4325   95     C  A01 122.26871 35,000_cells + HCMEC D3_line      1000
      4326  100     C  A01 122.46997 35,000_cells + HCMEC D3_line      1000
      4327  105     C  A01 122.82769 35,000_cells + HCMEC D3_line      1000
      4328  110     C  A01 123.16506 35,000_cells + HCMEC D3_line      1000
      4329  115     C  A01 123.32736 35,000_cells + HCMEC D3_line      1000
      4330  120     C  A01 123.57619 35,000_cells + HCMEC D3_line      1000
      4331  125     C  A01 123.77549 35,000_cells + HCMEC D3_line      1000
      4332  130     C  A01 124.00030 35,000_cells + HCMEC D3_line      1000
      4333  135     C  A01 124.23253 35,000_cells + HCMEC D3_line      1000
      4334  140     C  A01 124.44092 35,000_cells + HCMEC D3_line      1000
      4335  145     C  A01 124.59529 35,000_cells + HCMEC D3_line      1000
      4336  150     C  A01 124.85012 35,000_cells + HCMEC D3_line      1000
      4337  155     C  A01 124.97768 35,000_cells + HCMEC D3_line      1000
      4338  160     C  A01 125.20618 35,000_cells + HCMEC D3_line      1000
      4339  165     C  A01 125.42740 35,000_cells + HCMEC D3_line      1000
      4340  170     C  A01 125.57698 35,000_cells + HCMEC D3_line      1000
      4341  175     C  A01 125.78225 35,000_cells + HCMEC D3_line      1000
      4342  180     C  A01 125.93935 35,000_cells + HCMEC D3_line      1000
      4343  185     C  A01 126.09663 35,000_cells + HCMEC D3_line      1000
      4344  190     C  A01 126.20072 35,000_cells + HCMEC D3_line      1000
      4345  195     C  A01 126.30873 35,000_cells + HCMEC D3_line      1000
      4346  200     C  A01        NA 35,000_cells + HCMEC D3_line      1000
      4347    0     C  A01        NA 35,000_cells + HCMEC D3_line     16000
      4348    5     C  A01  79.36012 35,000_cells + HCMEC D3_line     16000
      4349   10     C  A01  69.98077 35,000_cells + HCMEC D3_line     16000
      4350   15     C  A01  58.99523 35,000_cells + HCMEC D3_line     16000
      4351   20     C  A01  51.34751 35,000_cells + HCMEC D3_line     16000
      4352   25     C  A01  47.46892 35,000_cells + HCMEC D3_line     16000
      4353   30     C  A01  46.05375 35,000_cells + HCMEC D3_line     16000
      4354   35     C  A01  43.99531 35,000_cells + HCMEC D3_line     16000
      4355   40     C  A01  42.59318 35,000_cells + HCMEC D3_line     16000
      4356   45     C  A01  42.25120 35,000_cells + HCMEC D3_line     16000
      4357   50     C  A01  42.55949 35,000_cells + HCMEC D3_line     16000
      4358   55     C  A01  43.31542 35,000_cells + HCMEC D3_line     16000
      4359   60     C  A01  43.82494 35,000_cells + HCMEC D3_line     16000
      4360   65     C  A01  44.53030 35,000_cells + HCMEC D3_line     16000
      4361   70     C  A01  45.51089 35,000_cells + HCMEC D3_line     16000
      4362   75     C  A01  46.35622 35,000_cells + HCMEC D3_line     16000
      4363   80     C  A01  47.72342 35,000_cells + HCMEC D3_line     16000
      4364   85     C  A01  49.03148 35,000_cells + HCMEC D3_line     16000
      4365   90     C  A01  49.98514 35,000_cells + HCMEC D3_line     16000
      4366   95     C  A01  51.27412 35,000_cells + HCMEC D3_line     16000
      4367  100     C  A01  52.69573 35,000_cells + HCMEC D3_line     16000
      4368  105     C  A01  54.72573 35,000_cells + HCMEC D3_line     16000
      4369  110     C  A01  56.64348 35,000_cells + HCMEC D3_line     16000
      4370  115     C  A01  57.79391 35,000_cells + HCMEC D3_line     16000
      4371  120     C  A01  58.87112 35,000_cells + HCMEC D3_line     16000
      4372  125     C  A01  60.62649 35,000_cells + HCMEC D3_line     16000
      4373  130     C  A01  62.34203 35,000_cells + HCMEC D3_line     16000
      4374  135     C  A01  63.51840 35,000_cells + HCMEC D3_line     16000
      4375  140     C  A01  64.99880 35,000_cells + HCMEC D3_line     16000
      4376  145     C  A01  65.77113 35,000_cells + HCMEC D3_line     16000
      4377  150     C  A01  67.36103 35,000_cells + HCMEC D3_line     16000
      4378  155     C  A01  68.36551 35,000_cells + HCMEC D3_line     16000
      4379  160     C  A01  69.68458 35,000_cells + HCMEC D3_line     16000
      4380  165     C  A01  70.92706 35,000_cells + HCMEC D3_line     16000
      4381  170     C  A01  72.03146 35,000_cells + HCMEC D3_line     16000
      4382  175     C  A01  73.65866 35,000_cells + HCMEC D3_line     16000
      4383  180     C  A01  75.29787 35,000_cells + HCMEC D3_line     16000
      4384  185     C  A01  76.68229 35,000_cells + HCMEC D3_line     16000
      4385  190     C  A01  78.02089 35,000_cells + HCMEC D3_line     16000
      4386  195     C  A01  79.76957 35,000_cells + HCMEC D3_line     16000
      4387  200     C  A01        NA 35,000_cells + HCMEC D3_line     16000
      4388    0     C  A01        NA 35,000_cells + HCMEC D3_line      2000
      4389    5     C  A01 112.84547 35,000_cells + HCMEC D3_line      2000
      4390   10     C  A01 110.02839 35,000_cells + HCMEC D3_line      2000
      4391   15     C  A01 106.43806 35,000_cells + HCMEC D3_line      2000
      4392   20     C  A01 104.46145 35,000_cells + HCMEC D3_line      2000
      4393   25     C  A01 103.75781 35,000_cells + HCMEC D3_line      2000
      4394   30     C  A01 104.14078 35,000_cells + HCMEC D3_line      2000
      4395   35     C  A01 104.29296 35,000_cells + HCMEC D3_line      2000
      4396   40     C  A01 105.38779 35,000_cells + HCMEC D3_line      2000
      4397   45     C  A01 106.92864 35,000_cells + HCMEC D3_line      2000
      4398   50     C  A01 108.57518 35,000_cells + HCMEC D3_line      2000
      4399   55     C  A01 110.08092 35,000_cells + HCMEC D3_line      2000
      4400   60     C  A01 111.03963 35,000_cells + HCMEC D3_line      2000
      4401   65     C  A01 112.07060 35,000_cells + HCMEC D3_line      2000
      4402   70     C  A01 112.97584 35,000_cells + HCMEC D3_line      2000
      4403   75     C  A01 113.50210 35,000_cells + HCMEC D3_line      2000
      4404   80     C  A01 114.14763 35,000_cells + HCMEC D3_line      2000
      4405   85     C  A01 114.83288 35,000_cells + HCMEC D3_line      2000
      4406   90     C  A01 115.24456 35,000_cells + HCMEC D3_line      2000
      4407   95     C  A01 115.75062 35,000_cells + HCMEC D3_line      2000
      4408  100     C  A01 116.09957 35,000_cells + HCMEC D3_line      2000
      4409  105     C  A01 116.81112 35,000_cells + HCMEC D3_line      2000
      4410  110     C  A01 117.49101 35,000_cells + HCMEC D3_line      2000
      4411  115     C  A01 117.75625 35,000_cells + HCMEC D3_line      2000
      4412  120     C  A01 118.20879 35,000_cells + HCMEC D3_line      2000
      4413  125     C  A01 118.59669 35,000_cells + HCMEC D3_line      2000
      4414  130     C  A01 119.08800 35,000_cells + HCMEC D3_line      2000
      4415  135     C  A01 119.54289 35,000_cells + HCMEC D3_line      2000
      4416  140     C  A01 119.89648 35,000_cells + HCMEC D3_line      2000
      4417  145     C  A01 120.16434 35,000_cells + HCMEC D3_line      2000
      4418  150     C  A01 120.67791 35,000_cells + HCMEC D3_line      2000
      4419  155     C  A01 120.91185 35,000_cells + HCMEC D3_line      2000
      4420  160     C  A01 121.38791 35,000_cells + HCMEC D3_line      2000
      4421  165     C  A01 121.85412 35,000_cells + HCMEC D3_line      2000
      4422  170     C  A01 122.14356 35,000_cells + HCMEC D3_line      2000
      4423  175     C  A01 122.59871 35,000_cells + HCMEC D3_line      2000
      4424  180     C  A01 122.98614 35,000_cells + HCMEC D3_line      2000
      4425  185     C  A01 123.37529 35,000_cells + HCMEC D3_line      2000
      4426  190     C  A01 123.67160 35,000_cells + HCMEC D3_line      2000
      4427  195     C  A01 123.98483 35,000_cells + HCMEC D3_line      2000
      4428  200     C  A01        NA 35,000_cells + HCMEC D3_line      2000
      4429    0     C  A01        NA 35,000_cells + HCMEC D3_line       250
      4430    5     C  A01 123.26230 35,000_cells + HCMEC D3_line       250
      4431   10     C  A01 123.11698 35,000_cells + HCMEC D3_line       250
      4432   15     C  A01 122.92755 35,000_cells + HCMEC D3_line       250
      4433   20     C  A01 122.92461 35,000_cells + HCMEC D3_line       250
      4434   25     C  A01 123.06066 35,000_cells + HCMEC D3_line       250
      4435   30     C  A01 123.35987 35,000_cells + HCMEC D3_line       250
      4436   35     C  A01 123.57683 35,000_cells + HCMEC D3_line       250
      4437   40     C  A01 123.89626 35,000_cells + HCMEC D3_line       250
      4438   45     C  A01 124.25142 35,000_cells + HCMEC D3_line       250
      4439   50     C  A01 124.62006 35,000_cells + HCMEC D3_line       250
      4440   55     C  A01 124.95087 35,000_cells + HCMEC D3_line       250
      4441   60     C  A01 125.29221 35,000_cells + HCMEC D3_line       250
      4442   65     C  A01 125.60117 35,000_cells + HCMEC D3_line       250
      4443   70     C  A01 125.88533 35,000_cells + HCMEC D3_line       250
      4444   75     C  A01 126.11319 35,000_cells + HCMEC D3_line       250
      4445   80     C  A01 126.33054 35,000_cells + HCMEC D3_line       250
      4446   85     C  A01 126.54861 35,000_cells + HCMEC D3_line       250
      4447   90     C  A01 126.73464 35,000_cells + HCMEC D3_line       250
      4448   95     C  A01 126.91832 35,000_cells + HCMEC D3_line       250
      4449  100     C  A01 127.06544 35,000_cells + HCMEC D3_line       250
      4450  105     C  A01 127.24044 35,000_cells + HCMEC D3_line       250
      4451  110     C  A01 127.38906 35,000_cells + HCMEC D3_line       250
      4452  115     C  A01 127.53299 35,000_cells + HCMEC D3_line       250
      4453  120     C  A01 127.66290 35,000_cells + HCMEC D3_line       250
      4454  125     C  A01 127.77935 35,000_cells + HCMEC D3_line       250
      4455  130     C  A01 127.90236 35,000_cells + HCMEC D3_line       250
      4456  135     C  A01 128.01068 35,000_cells + HCMEC D3_line       250
      4457  140     C  A01 128.14599 35,000_cells + HCMEC D3_line       250
      4458  145     C  A01 128.25821 35,000_cells + HCMEC D3_line       250
      4459  150     C  A01 128.35569 35,000_cells + HCMEC D3_line       250
      4460  155     C  A01 128.44398 35,000_cells + HCMEC D3_line       250
      4461  160     C  A01 128.53784 35,000_cells + HCMEC D3_line       250
      4462  165     C  A01 128.63105 35,000_cells + HCMEC D3_line       250
      4463  170     C  A01 128.71624 35,000_cells + HCMEC D3_line       250
      4464  175     C  A01 128.80521 35,000_cells + HCMEC D3_line       250
      4465  180     C  A01 128.86954 35,000_cells + HCMEC D3_line       250
      4466  185     C  A01 128.92863 35,000_cells + HCMEC D3_line       250
      4467  190     C  A01 128.96446 35,000_cells + HCMEC D3_line       250
      4468  195     C  A01 128.97348 35,000_cells + HCMEC D3_line       250
      4469  200     C  A01        NA 35,000_cells + HCMEC D3_line       250
      4470    0     C  A01        NA 35,000_cells + HCMEC D3_line     32000
      4471    5     C  A01  66.65768 35,000_cells + HCMEC D3_line     32000
      4472   10     C  A01  57.14920 35,000_cells + HCMEC D3_line     32000
      4473   15     C  A01  46.02891 35,000_cells + HCMEC D3_line     32000
      4474   20     C  A01  37.98628 35,000_cells + HCMEC D3_line     32000
      4475   25     C  A01  33.55287 35,000_cells + HCMEC D3_line     32000
      4476   30     C  A01  31.82642 35,000_cells + HCMEC D3_line     32000
      4477   35     C  A01  29.13370 35,000_cells + HCMEC D3_line     32000
      4478   40     C  A01  26.29429 35,000_cells + HCMEC D3_line     32000
      4479   45     C  A01  24.23323 35,000_cells + HCMEC D3_line     32000
      4480   50     C  A01  23.16552 35,000_cells + HCMEC D3_line     32000
      4481   55     C  A01  22.61333 35,000_cells + HCMEC D3_line     32000
      4482   60     C  A01  22.46643 35,000_cells + HCMEC D3_line     32000
      4483   65     C  A01  22.51257 35,000_cells + HCMEC D3_line     32000
      4484   70     C  A01  22.92491 35,000_cells + HCMEC D3_line     32000
      4485   75     C  A01  23.35998 35,000_cells + HCMEC D3_line     32000
      4486   80     C  A01  24.39090 35,000_cells + HCMEC D3_line     32000
      4487   85     C  A01  25.07271 35,000_cells + HCMEC D3_line     32000
      4488   90     C  A01  25.71895 35,000_cells + HCMEC D3_line     32000
      4489   95     C  A01  26.65939 35,000_cells + HCMEC D3_line     32000
      4490  100     C  A01  27.69167 35,000_cells + HCMEC D3_line     32000
      4491  105     C  A01  28.97373 35,000_cells + HCMEC D3_line     32000
      4492  110     C  A01  30.47634 35,000_cells + HCMEC D3_line     32000
      4493  115     C  A01  31.28135 35,000_cells + HCMEC D3_line     32000
      4494  120     C  A01  32.20544 35,000_cells + HCMEC D3_line     32000
      4495  125     C  A01  33.71680 35,000_cells + HCMEC D3_line     32000
      4496  130     C  A01  35.05647 35,000_cells + HCMEC D3_line     32000
      4497  135     C  A01  36.07956 35,000_cells + HCMEC D3_line     32000
      4498  140     C  A01  37.39259 35,000_cells + HCMEC D3_line     32000
      4499  145     C  A01  38.13059 35,000_cells + HCMEC D3_line     32000
      4500  150     C  A01  39.62031 35,000_cells + HCMEC D3_line     32000
      4501  155     C  A01  40.59143 35,000_cells + HCMEC D3_line     32000
      4502  160     C  A01  41.89756 35,000_cells + HCMEC D3_line     32000
      4503  165     C  A01  43.05081 35,000_cells + HCMEC D3_line     32000
      4504  170     C  A01  44.01092 35,000_cells + HCMEC D3_line     32000
      4505  175     C  A01  45.71191 35,000_cells + HCMEC D3_line     32000
      4506  180     C  A01  47.41311 35,000_cells + HCMEC D3_line     32000
      4507  185     C  A01  48.82418 35,000_cells + HCMEC D3_line     32000
      4508  190     C  A01  50.44780 35,000_cells + HCMEC D3_line     32000
      4509  195     C  A01  52.38377 35,000_cells + HCMEC D3_line     32000
      4510  200     C  A01        NA 35,000_cells + HCMEC D3_line     32000
      4511    0     C  A01        NA 35,000_cells + HCMEC D3_line      4000
      4512    5     C  A01 104.21521 35,000_cells + HCMEC D3_line      4000
      4513   10     C  A01  98.82943 35,000_cells + HCMEC D3_line      4000
      4514   15     C  A01  92.29687 35,000_cells + HCMEC D3_line      4000
      4515   20     C  A01  88.41540 35,000_cells + HCMEC D3_line      4000
      4516   25     C  A01  86.89610 35,000_cells + HCMEC D3_line      4000
      4517   30     C  A01  86.82697 35,000_cells + HCMEC D3_line      4000
      4518   35     C  A01  86.71116 35,000_cells + HCMEC D3_line      4000
      4519   40     C  A01  87.94536 35,000_cells + HCMEC D3_line      4000
      4520   45     C  A01  90.01151 35,000_cells + HCMEC D3_line      4000
      4521   50     C  A01  92.25425 35,000_cells + HCMEC D3_line      4000
      4522   55     C  A01  94.64856 35,000_cells + HCMEC D3_line      4000
      4523   60     C  A01  96.00462 35,000_cells + HCMEC D3_line      4000
      4524   65     C  A01  97.52413 35,000_cells + HCMEC D3_line      4000
      4525   70     C  A01  98.87883 35,000_cells + HCMEC D3_line      4000
      4526   75     C  A01  99.65159 35,000_cells + HCMEC D3_line      4000
      4527   80     C  A01 100.51863 35,000_cells + HCMEC D3_line      4000
      4528   85     C  A01 101.57623 35,000_cells + HCMEC D3_line      4000
      4529   90     C  A01 102.19627 35,000_cells + HCMEC D3_line      4000
      4530   95     C  A01 102.96324 35,000_cells + HCMEC D3_line      4000
      4531  100     C  A01 103.62687 35,000_cells + HCMEC D3_line      4000
      4532  105     C  A01 104.83472 35,000_cells + HCMEC D3_line      4000
      4533  110     C  A01 105.87271 35,000_cells + HCMEC D3_line      4000
      4534  115     C  A01 106.34093 35,000_cells + HCMEC D3_line      4000
      4535  120     C  A01 107.03358 35,000_cells + HCMEC D3_line      4000
      4536  125     C  A01 107.76118 35,000_cells + HCMEC D3_line      4000
      4537  130     C  A01 108.64374 35,000_cells + HCMEC D3_line      4000
      4538  135     C  A01 109.33146 35,000_cells + HCMEC D3_line      4000
      4539  140     C  A01 109.93311 35,000_cells + HCMEC D3_line      4000
      4540  145     C  A01 110.34703 35,000_cells + HCMEC D3_line      4000
      4541  150     C  A01 111.15544 35,000_cells + HCMEC D3_line      4000
      4542  155     C  A01 111.58944 35,000_cells + HCMEC D3_line      4000
      4543  160     C  A01 112.35916 35,000_cells + HCMEC D3_line      4000
      4544  165     C  A01 113.11025 35,000_cells + HCMEC D3_line      4000
      4545  170     C  A01 113.64546 35,000_cells + HCMEC D3_line      4000
      4546  175     C  A01 114.46644 35,000_cells + HCMEC D3_line      4000
      4547  180     C  A01 115.17358 35,000_cells + HCMEC D3_line      4000
      4548  185     C  A01 115.89029 35,000_cells + HCMEC D3_line      4000
      4549  190     C  A01 116.48087 35,000_cells + HCMEC D3_line      4000
      4550  195     C  A01 117.14075 35,000_cells + HCMEC D3_line      4000
      4551  200     C  A01        NA 35,000_cells + HCMEC D3_line      4000
      4552    0     C  A01        NA 35,000_cells + HCMEC D3_line       500
      4553    5     C  A01 121.04961 35,000_cells + HCMEC D3_line       500
      4554   10     C  A01 120.80763 35,000_cells + HCMEC D3_line       500
      4555   15     C  A01 120.38595 35,000_cells + HCMEC D3_line       500
      4556   20     C  A01 120.26552 35,000_cells + HCMEC D3_line       500
      4557   25     C  A01 120.32529 35,000_cells + HCMEC D3_line       500
      4558   30     C  A01 120.75071 35,000_cells + HCMEC D3_line       500
      4559   35     C  A01 120.91645 35,000_cells + HCMEC D3_line       500
      4560   40     C  A01 121.33249 35,000_cells + HCMEC D3_line       500
      4561   45     C  A01 121.83752 35,000_cells + HCMEC D3_line       500
      4562   50     C  A01 122.35440 35,000_cells + HCMEC D3_line       500
      4563   55     C  A01 122.81457 35,000_cells + HCMEC D3_line       500
      4564   60     C  A01 123.23422 35,000_cells + HCMEC D3_line       500
      4565   65     C  A01 123.63999 35,000_cells + HCMEC D3_line       500
      4566   70     C  A01 124.00537 35,000_cells + HCMEC D3_line       500
      4567   75     C  A01 124.29232 35,000_cells + HCMEC D3_line       500
      4568   80     C  A01 124.55940 35,000_cells + HCMEC D3_line       500
      4569   85     C  A01 124.80853 35,000_cells + HCMEC D3_line       500
      4570   90     C  A01 125.00816 35,000_cells + HCMEC D3_line       500
      4571   95     C  A01 125.21681 35,000_cells + HCMEC D3_line       500
      4572  100     C  A01 125.37207 35,000_cells + HCMEC D3_line       500
      4573  105     C  A01 125.58261 35,000_cells + HCMEC D3_line       500
      4574  110     C  A01 125.78755 35,000_cells + HCMEC D3_line       500
      4575  115     C  A01 125.93591 35,000_cells + HCMEC D3_line       500
      4576  120     C  A01 126.09557 35,000_cells + HCMEC D3_line       500
      4577  125     C  A01 126.23667 35,000_cells + HCMEC D3_line       500
      4578  130     C  A01 126.38452 35,000_cells + HCMEC D3_line       500
      4579  135     C  A01 126.53269 35,000_cells + HCMEC D3_line       500
      4580  140     C  A01 126.66795 35,000_cells + HCMEC D3_line       500
      4581  145     C  A01 126.79141 35,000_cells + HCMEC D3_line       500
      4582  150     C  A01 126.92979 35,000_cells + HCMEC D3_line       500
      4583  155     C  A01 127.03047 35,000_cells + HCMEC D3_line       500
      4584  160     C  A01 127.15009 35,000_cells + HCMEC D3_line       500
      4585  165     C  A01 127.27461 35,000_cells + HCMEC D3_line       500
      4586  170     C  A01 127.37762 35,000_cells + HCMEC D3_line       500
      4587  175     C  A01 127.48395 35,000_cells + HCMEC D3_line       500
      4588  180     C  A01 127.56922 35,000_cells + HCMEC D3_line       500
      4589  185     C  A01 127.64077 35,000_cells + HCMEC D3_line       500
      4590  190     C  A01 127.68873 35,000_cells + HCMEC D3_line       500
      4591  195     C  A01 127.72512 35,000_cells + HCMEC D3_line       500
      4592  200     C  A01        NA 35,000_cells + HCMEC D3_line       500
      4593    0     C  A01        NA 35,000_cells + HCMEC D3_line     64000
      4594    5     C  A01  50.80751 35,000_cells + HCMEC D3_line     64000
      4595   10     C  A01  43.08633 35,000_cells + HCMEC D3_line     64000
      4596   15     C  A01  34.14057 35,000_cells + HCMEC D3_line     64000
      4597   20     C  A01  27.42713 35,000_cells + HCMEC D3_line     64000
      4598   25     C  A01  23.42749 35,000_cells + HCMEC D3_line     64000
      4599   30     C  A01  21.84604 35,000_cells + HCMEC D3_line     64000
      4600   35     C  A01  19.29789 35,000_cells + HCMEC D3_line     64000
      4601   40     C  A01  16.17391 35,000_cells + HCMEC D3_line     64000
      4602   45     C  A01  13.63127 35,000_cells + HCMEC D3_line     64000
      4603   50     C  A01  12.30024 35,000_cells + HCMEC D3_line     64000
      4604   55     C  A01  11.57828 35,000_cells + HCMEC D3_line     64000
      4605   60     C  A01  11.34759 35,000_cells + HCMEC D3_line     64000
      4606   65     C  A01  11.27950 35,000_cells + HCMEC D3_line     64000
      4607   70     C  A01  11.43510 35,000_cells + HCMEC D3_line     64000
      4608   75     C  A01  11.62374 35,000_cells + HCMEC D3_line     64000
      4609   80     C  A01  12.14572 35,000_cells + HCMEC D3_line     64000
      4610   85     C  A01  12.37027 35,000_cells + HCMEC D3_line     64000
      4611   90     C  A01  12.67713 35,000_cells + HCMEC D3_line     64000
      4612   95     C  A01  13.12622 35,000_cells + HCMEC D3_line     64000
      4613  100     C  A01  13.61308 35,000_cells + HCMEC D3_line     64000
      4614  105     C  A01  14.13416 35,000_cells + HCMEC D3_line     64000
      4615  110     C  A01  14.88225 35,000_cells + HCMEC D3_line     64000
      4616  115     C  A01  15.24003 35,000_cells + HCMEC D3_line     64000
      4617  120     C  A01  15.77113 35,000_cells + HCMEC D3_line     64000
      4618  125     C  A01  16.53689 35,000_cells + HCMEC D3_line     64000
      4619  130     C  A01  17.17909 35,000_cells + HCMEC D3_line     64000
      4620  135     C  A01  17.71104 35,000_cells + HCMEC D3_line     64000
      4621  140     C  A01  18.40899 35,000_cells + HCMEC D3_line     64000
      4622  145     C  A01  18.83345 35,000_cells + HCMEC D3_line     64000
      4623  150     C  A01  19.69903 35,000_cells + HCMEC D3_line     64000
      4624  155     C  A01  20.30073 35,000_cells + HCMEC D3_line     64000
      4625  160     C  A01  21.14324 35,000_cells + HCMEC D3_line     64000
      4626  165     C  A01  21.84081 35,000_cells + HCMEC D3_line     64000
      4627  170     C  A01  22.33079 35,000_cells + HCMEC D3_line     64000
      4628  175     C  A01  23.48989 35,000_cells + HCMEC D3_line     64000
      4629  180     C  A01  24.58434 35,000_cells + HCMEC D3_line     64000
      4630  185     C  A01  25.51675 35,000_cells + HCMEC D3_line     64000
      4631  190     C  A01  26.83636 35,000_cells + HCMEC D3_line     64000
      4632  195     C  A01  28.16434 35,000_cells + HCMEC D3_line     64000
      4633  200     C  A01        NA 35,000_cells + HCMEC D3_line     64000
      4634    0     C  A01        NA 35,000_cells + HCMEC D3_line      8000
      4635    5     C  A01  91.83237 35,000_cells + HCMEC D3_line      8000
      4636   10     C  A01  84.02854 35,000_cells + HCMEC D3_line      8000
      4637   15     C  A01  74.86533 35,000_cells + HCMEC D3_line      8000
      4638   20     C  A01  68.96727 35,000_cells + HCMEC D3_line      8000
      4639   25     C  A01  66.22502 35,000_cells + HCMEC D3_line      8000
      4640   30     C  A01  65.47479 35,000_cells + HCMEC D3_line      8000
      4641   35     C  A01  64.43723 35,000_cells + HCMEC D3_line      8000
      4642   40     C  A01  64.80977 35,000_cells + HCMEC D3_line      8000
      4643   45     C  A01  66.34196 35,000_cells + HCMEC D3_line      8000
      4644   50     C  A01  68.24287 35,000_cells + HCMEC D3_line      8000
      4645   55     C  A01  70.56264 35,000_cells + HCMEC D3_line      8000
      4646   60     C  A01  71.85768 35,000_cells + HCMEC D3_line      8000
      4647   65     C  A01  73.34298 35,000_cells + HCMEC D3_line      8000
      4648   70     C  A01  74.77755 35,000_cells + HCMEC D3_line      8000
      4649   75     C  A01  75.76682 35,000_cells + HCMEC D3_line      8000
      4650   80     C  A01  76.95821 35,000_cells + HCMEC D3_line      8000
      4651   85     C  A01  78.36387 35,000_cells + HCMEC D3_line      8000
      4652   90     C  A01  79.23605 35,000_cells + HCMEC D3_line      8000
      4653   95     C  A01  80.36408 35,000_cells + HCMEC D3_line      8000
      4654  100     C  A01  81.53214 35,000_cells + HCMEC D3_line      8000
      4655  105     C  A01  83.38086 35,000_cells + HCMEC D3_line      8000
      4656  110     C  A01  84.96062 35,000_cells + HCMEC D3_line      8000
      4657  115     C  A01  85.82966 35,000_cells + HCMEC D3_line      8000
      4658  120     C  A01  86.70826 35,000_cells + HCMEC D3_line      8000
      4659  125     C  A01  88.02514 35,000_cells + HCMEC D3_line      8000
      4660  130     C  A01  89.46354 35,000_cells + HCMEC D3_line      8000
      4661  135     C  A01  90.40686 35,000_cells + HCMEC D3_line      8000
      4662  140     C  A01  91.46035 35,000_cells + HCMEC D3_line      8000
      4663  145     C  A01  92.05005 35,000_cells + HCMEC D3_line      8000
      4664  150     C  A01  93.22461 35,000_cells + HCMEC D3_line      8000
      4665  155     C  A01  93.93193 35,000_cells + HCMEC D3_line      8000
      4666  160     C  A01  94.97776 35,000_cells + HCMEC D3_line      8000
      4667  165     C  A01  95.97223 35,000_cells + HCMEC D3_line      8000
      4668  170     C  A01  96.82509 35,000_cells + HCMEC D3_line      8000
      4669  175     C  A01  98.00582 35,000_cells + HCMEC D3_line      8000
      4670  180     C  A01  99.13624 35,000_cells + HCMEC D3_line      8000
      4671  185     C  A01 100.21659 35,000_cells + HCMEC D3_line      8000
      4672  190     C  A01 101.07764 35,000_cells + HCMEC D3_line      8000
      4673  195     C  A01 102.25136 35,000_cells + HCMEC D3_line      8000
      4674  200     C  A01        NA 35,000_cells + HCMEC D3_line      8000
      4675    0     C  A02        NA 35,000_cells + HCMEC D3_line      1000
      4676    5     C  A02 117.14241 35,000_cells + HCMEC D3_line      1000
      4677   10     C  A02 115.70241 35,000_cells + HCMEC D3_line      1000
      4678   15     C  A02 114.49107 35,000_cells + HCMEC D3_line      1000
      4679   20     C  A02 114.35148 35,000_cells + HCMEC D3_line      1000
      4680   25     C  A02 114.65560 35,000_cells + HCMEC D3_line      1000
      4681   30     C  A02 115.10754 35,000_cells + HCMEC D3_line      1000
      4682   35     C  A02 115.62474 35,000_cells + HCMEC D3_line      1000
      4683   40     C  A02 116.46235 35,000_cells + HCMEC D3_line      1000
      4684   45     C  A02 117.28690 35,000_cells + HCMEC D3_line      1000
      4685   50     C  A02 118.01279 35,000_cells + HCMEC D3_line      1000
      4686   55     C  A02 118.49316 35,000_cells + HCMEC D3_line      1000
      4687   60     C  A02 119.12550 35,000_cells + HCMEC D3_line      1000
      4688   65     C  A02 119.76180 35,000_cells + HCMEC D3_line      1000
      4689   70     C  A02 120.20497 35,000_cells + HCMEC D3_line      1000
      4690   75     C  A02 120.60100 35,000_cells + HCMEC D3_line      1000
      4691   80     C  A02 120.88741 35,000_cells + HCMEC D3_line      1000
      4692   85     C  A02 121.29300 35,000_cells + HCMEC D3_line      1000
      4693   90     C  A02 121.60679 35,000_cells + HCMEC D3_line      1000
      4694   95     C  A02 121.89513 35,000_cells + HCMEC D3_line      1000
      4695  100     C  A02 122.14642 35,000_cells + HCMEC D3_line      1000
      4696  105     C  A02 122.43542 35,000_cells + HCMEC D3_line      1000
      4697  110     C  A02 122.72018 35,000_cells + HCMEC D3_line      1000
      4698  115     C  A02 122.94003 35,000_cells + HCMEC D3_line      1000
      4699  120     C  A02 123.10200 35,000_cells + HCMEC D3_line      1000
      4700  125     C  A02 123.30511 35,000_cells + HCMEC D3_line      1000
      4701  130     C  A02 123.56943 35,000_cells + HCMEC D3_line      1000
      4702  135     C  A02 123.78395 35,000_cells + HCMEC D3_line      1000
      4703  140     C  A02 124.02547 35,000_cells + HCMEC D3_line      1000
      4704  145     C  A02 124.22248 35,000_cells + HCMEC D3_line      1000
      4705  150     C  A02 124.37938 35,000_cells + HCMEC D3_line      1000
      4706  155     C  A02 124.47917 35,000_cells + HCMEC D3_line      1000
      4707  160     C  A02 124.68265 35,000_cells + HCMEC D3_line      1000
      4708  165     C  A02 124.82699 35,000_cells + HCMEC D3_line      1000
      4709  170     C  A02 124.92989 35,000_cells + HCMEC D3_line      1000
      4710  175     C  A02 124.99763 35,000_cells + HCMEC D3_line      1000
      4711  180     C  A02 125.16193 35,000_cells + HCMEC D3_line      1000
      4712  185     C  A02 125.34484 35,000_cells + HCMEC D3_line      1000
      4713  190     C  A02 125.40708 35,000_cells + HCMEC D3_line      1000
      4714  195     C  A02 125.48399 35,000_cells + HCMEC D3_line      1000
      4715  200     C  A02        NA 35,000_cells + HCMEC D3_line      1000
      4716    0     C  A02        NA 35,000_cells + HCMEC D3_line     16000
      4717    5     C  A02  75.59721 35,000_cells + HCMEC D3_line     16000
      4718   10     C  A02  63.34768 35,000_cells + HCMEC D3_line     16000
      4719   15     C  A02  53.42305 35,000_cells + HCMEC D3_line     16000
      4720   20     C  A02  47.97371 35,000_cells + HCMEC D3_line     16000
      4721   25     C  A02  45.19191 35,000_cells + HCMEC D3_line     16000
      4722   30     C  A02  43.26918 35,000_cells + HCMEC D3_line     16000
      4723   35     C  A02  42.52611 35,000_cells + HCMEC D3_line     16000
      4724   40     C  A02  42.09808 35,000_cells + HCMEC D3_line     16000
      4725   45     C  A02  41.87243 35,000_cells + HCMEC D3_line     16000
      4726   50     C  A02  42.02026 35,000_cells + HCMEC D3_line     16000
      4727   55     C  A02  42.50293 35,000_cells + HCMEC D3_line     16000
      4728   60     C  A02  42.70816 35,000_cells + HCMEC D3_line     16000
      4729   65     C  A02  43.53804 35,000_cells + HCMEC D3_line     16000
      4730   70     C  A02  44.58299 35,000_cells + HCMEC D3_line     16000
      4731   75     C  A02  45.51862 35,000_cells + HCMEC D3_line     16000
      4732   80     C  A02  46.37416 35,000_cells + HCMEC D3_line     16000
      4733   85     C  A02  47.92039 35,000_cells + HCMEC D3_line     16000
      4734   90     C  A02  49.43701 35,000_cells + HCMEC D3_line     16000
      4735   95     C  A02  51.13524 35,000_cells + HCMEC D3_line     16000
      4736  100     C  A02  52.69280 35,000_cells + HCMEC D3_line     16000
      4737  105     C  A02  54.05277 35,000_cells + HCMEC D3_line     16000
      4738  110     C  A02  55.42086 35,000_cells + HCMEC D3_line     16000
      4739  115     C  A02  56.98524 35,000_cells + HCMEC D3_line     16000
      4740  120     C  A02  58.28521 35,000_cells + HCMEC D3_line     16000
      4741  125     C  A02  59.81487 35,000_cells + HCMEC D3_line     16000
      4742  130     C  A02  61.20044 35,000_cells + HCMEC D3_line     16000
      4743  135     C  A02  62.82237 35,000_cells + HCMEC D3_line     16000
      4744  140     C  A02  64.33190 35,000_cells + HCMEC D3_line     16000
      4745  145     C  A02  65.99160 35,000_cells + HCMEC D3_line     16000
      4746  150     C  A02  67.01055 35,000_cells + HCMEC D3_line     16000
      4747  155     C  A02  67.88116 35,000_cells + HCMEC D3_line     16000
      4748  160     C  A02  69.35420 35,000_cells + HCMEC D3_line     16000
      4749  165     C  A02  70.49300 35,000_cells + HCMEC D3_line     16000
      4750  170     C  A02  71.61701 35,000_cells + HCMEC D3_line     16000
      4751  175     C  A02  72.24534 35,000_cells + HCMEC D3_line     16000
      4752  180     C  A02  73.12728 35,000_cells + HCMEC D3_line     16000
      4753  185     C  A02  74.56090 35,000_cells + HCMEC D3_line     16000
      4754  190     C  A02  75.41955 35,000_cells + HCMEC D3_line     16000
      4755  195     C  A02  76.07838 35,000_cells + HCMEC D3_line     16000
      4756  200     C  A02        NA 35,000_cells + HCMEC D3_line     16000
      4757    0     C  A02        NA 35,000_cells + HCMEC D3_line      2000
      4758    5     C  A02 111.75486 35,000_cells + HCMEC D3_line      2000
      4759   10     C  A02 107.92748 35,000_cells + HCMEC D3_line      2000
      4760   15     C  A02 104.76594 35,000_cells + HCMEC D3_line      2000
      4761   20     C  A02 103.93682 35,000_cells + HCMEC D3_line      2000
      4762   25     C  A02 103.82452 35,000_cells + HCMEC D3_line      2000
      4763   30     C  A02 104.38425 35,000_cells + HCMEC D3_line      2000
      4764   35     C  A02 105.13762 35,000_cells + HCMEC D3_line      2000
      4765   40     C  A02 106.62794 35,000_cells + HCMEC D3_line      2000
      4766   45     C  A02 108.09368 35,000_cells + HCMEC D3_line      2000
      4767   50     C  A02 109.21944 35,000_cells + HCMEC D3_line      2000
      4768   55     C  A02 109.96879 35,000_cells + HCMEC D3_line      2000
      4769   60     C  A02 110.96077 35,000_cells + HCMEC D3_line      2000
      4770   65     C  A02 111.80998 35,000_cells + HCMEC D3_line      2000
      4771   70     C  A02 112.54096 35,000_cells + HCMEC D3_line      2000
      4772   75     C  A02 113.07652 35,000_cells + HCMEC D3_line      2000
      4773   80     C  A02 113.47935 35,000_cells + HCMEC D3_line      2000
      4774   85     C  A02 114.25500 35,000_cells + HCMEC D3_line      2000
      4775   90     C  A02 114.82915 35,000_cells + HCMEC D3_line      2000
      4776   95     C  A02 115.40724 35,000_cells + HCMEC D3_line      2000
      4777  100     C  A02 115.90761 35,000_cells + HCMEC D3_line      2000
      4778  105     C  A02 116.40695 35,000_cells + HCMEC D3_line      2000
      4779  110     C  A02 116.93674 35,000_cells + HCMEC D3_line      2000
      4780  115     C  A02 117.34291 35,000_cells + HCMEC D3_line      2000
      4781  120     C  A02 117.66029 35,000_cells + HCMEC D3_line      2000
      4782  125     C  A02 118.06365 35,000_cells + HCMEC D3_line      2000
      4783  130     C  A02 118.57396 35,000_cells + HCMEC D3_line      2000
      4784  135     C  A02 118.99481 35,000_cells + HCMEC D3_line      2000
      4785  140     C  A02 119.47996 35,000_cells + HCMEC D3_line      2000
      4786  145     C  A02 119.93633 35,000_cells + HCMEC D3_line      2000
      4787  150     C  A02 120.22639 35,000_cells + HCMEC D3_line      2000
      4788  155     C  A02 120.43212 35,000_cells + HCMEC D3_line      2000
      4789  160     C  A02 120.86905 35,000_cells + HCMEC D3_line      2000
      4790  165     C  A02 121.13071 35,000_cells + HCMEC D3_line      2000
      4791  170     C  A02 121.34166 35,000_cells + HCMEC D3_line      2000
      4792  175     C  A02 121.43282 35,000_cells + HCMEC D3_line      2000
      4793  180     C  A02 121.79153 35,000_cells + HCMEC D3_line      2000
      4794  185     C  A02 122.23099 35,000_cells + HCMEC D3_line      2000
      4795  190     C  A02 122.39160 35,000_cells + HCMEC D3_line      2000
      4796  195     C  A02 122.53069 35,000_cells + HCMEC D3_line      2000
      4797  200     C  A02        NA 35,000_cells + HCMEC D3_line      2000
      4798    0     C  A02        NA 35,000_cells + HCMEC D3_line       250
      4799    5     C  A02 122.91601 35,000_cells + HCMEC D3_line       250
      4800   10     C  A02 122.52396 35,000_cells + HCMEC D3_line       250
      4801   15     C  A02 122.32011 35,000_cells + HCMEC D3_line       250
      4802   20     C  A02 122.44003 35,000_cells + HCMEC D3_line       250
      4803   25     C  A02 122.68900 35,000_cells + HCMEC D3_line       250
      4804   30     C  A02 122.96120 35,000_cells + HCMEC D3_line       250
      4805   35     C  A02 123.26946 35,000_cells + HCMEC D3_line       250
      4806   40     C  A02 123.63402 35,000_cells + HCMEC D3_line       250
      4807   45     C  A02 124.01620 35,000_cells + HCMEC D3_line       250
      4808   50     C  A02 124.39084 35,000_cells + HCMEC D3_line       250
      4809   55     C  A02 124.69670 35,000_cells + HCMEC D3_line       250
      4810   60     C  A02 125.00493 35,000_cells + HCMEC D3_line       250
      4811   65     C  A02 125.32222 35,000_cells + HCMEC D3_line       250
      4812   70     C  A02 125.56109 35,000_cells + HCMEC D3_line       250
      4813   75     C  A02 125.77337 35,000_cells + HCMEC D3_line       250
      4814   80     C  A02 125.97626 35,000_cells + HCMEC D3_line       250
      4815   85     C  A02 126.17798 35,000_cells + HCMEC D3_line       250
      4816   90     C  A02 126.34586 35,000_cells + HCMEC D3_line       250
      4817   95     C  A02 126.51078 35,000_cells + HCMEC D3_line       250
      4818  100     C  A02 126.66283 35,000_cells + HCMEC D3_line       250
      4819  105     C  A02 126.82158 35,000_cells + HCMEC D3_line       250
      4820  110     C  A02 126.95885 35,000_cells + HCMEC D3_line       250
      4821  115     C  A02 127.08530 35,000_cells + HCMEC D3_line       250
      4822  120     C  A02 127.21162 35,000_cells + HCMEC D3_line       250
      4823  125     C  A02 127.32815 35,000_cells + HCMEC D3_line       250
      4824  130     C  A02 127.43575 35,000_cells + HCMEC D3_line       250
      4825  135     C  A02 127.55530 35,000_cells + HCMEC D3_line       250
      4826  140     C  A02 127.65991 35,000_cells + HCMEC D3_line       250
      4827  145     C  A02 127.75551 35,000_cells + HCMEC D3_line       250
      4828  150     C  A02 127.84629 35,000_cells + HCMEC D3_line       250
      4829  155     C  A02 127.93887 35,000_cells + HCMEC D3_line       250
      4830  160     C  A02 128.01647 35,000_cells + HCMEC D3_line       250
      4831  165     C  A02 128.09959 35,000_cells + HCMEC D3_line       250
      4832  170     C  A02 128.16033 35,000_cells + HCMEC D3_line       250
      4833  175     C  A02 128.21668 35,000_cells + HCMEC D3_line       250
      4834  180     C  A02 128.27584 35,000_cells + HCMEC D3_line       250
      4835  185     C  A02 128.32706 35,000_cells + HCMEC D3_line       250
      4836  190     C  A02 128.36328 35,000_cells + HCMEC D3_line       250
      4837  195     C  A02 128.39348 35,000_cells + HCMEC D3_line       250
      4838  200     C  A02        NA 35,000_cells + HCMEC D3_line       250
      4839    0     C  A02        NA 35,000_cells + HCMEC D3_line     32000
      4840    5     C  A02  62.48397 35,000_cells + HCMEC D3_line     32000
      4841   10     C  A02  49.93819 35,000_cells + HCMEC D3_line     32000
      4842   15     C  A02  39.47179 35,000_cells + HCMEC D3_line     32000
      4843   20     C  A02  33.18358 35,000_cells + HCMEC D3_line     32000
      4844   25     C  A02  30.02368 35,000_cells + HCMEC D3_line     32000
      4845   30     C  A02  27.49747 35,000_cells + HCMEC D3_line     32000
      4846   35     C  A02  25.89151 35,000_cells + HCMEC D3_line     32000
      4847   40     C  A02  23.79984 35,000_cells + HCMEC D3_line     32000
      4848   45     C  A02  22.42341 35,000_cells + HCMEC D3_line     32000
      4849   50     C  A02  21.76919 35,000_cells + HCMEC D3_line     32000
      4850   55     C  A02  21.65167 35,000_cells + HCMEC D3_line     32000
      4851   60     C  A02  21.53631 35,000_cells + HCMEC D3_line     32000
      4852   65     C  A02  21.89250 35,000_cells + HCMEC D3_line     32000
      4853   70     C  A02  22.38358 35,000_cells + HCMEC D3_line     32000
      4854   75     C  A02  22.96132 35,000_cells + HCMEC D3_line     32000
      4855   80     C  A02  23.40862 35,000_cells + HCMEC D3_line     32000
      4856   85     C  A02  24.37793 35,000_cells + HCMEC D3_line     32000
      4857   90     C  A02  25.37897 35,000_cells + HCMEC D3_line     32000
      4858   95     C  A02  26.42383 35,000_cells + HCMEC D3_line     32000
      4859  100     C  A02  27.49869 35,000_cells + HCMEC D3_line     32000
      4860  105     C  A02  28.51028 35,000_cells + HCMEC D3_line     32000
      4861  110     C  A02  29.36623 35,000_cells + HCMEC D3_line     32000
      4862  115     C  A02  30.58884 35,000_cells + HCMEC D3_line     32000
      4863  120     C  A02  31.63880 35,000_cells + HCMEC D3_line     32000
      4864  125     C  A02  32.81640 35,000_cells + HCMEC D3_line     32000
      4865  130     C  A02  34.01755 35,000_cells + HCMEC D3_line     32000
      4866  135     C  A02  35.24990 35,000_cells + HCMEC D3_line     32000
      4867  140     C  A02  36.59819 35,000_cells + HCMEC D3_line     32000
      4868  145     C  A02  38.02091 35,000_cells + HCMEC D3_line     32000
      4869  150     C  A02  38.90798 35,000_cells + HCMEC D3_line     32000
      4870  155     C  A02  39.81059 35,000_cells + HCMEC D3_line     32000
      4871  160     C  A02  41.15959 35,000_cells + HCMEC D3_line     32000
      4872  165     C  A02  42.28495 35,000_cells + HCMEC D3_line     32000
      4873  170     C  A02  43.60895 35,000_cells + HCMEC D3_line     32000
      4874  175     C  A02  44.45037 35,000_cells + HCMEC D3_line     32000
      4875  180     C  A02  45.33946 35,000_cells + HCMEC D3_line     32000
      4876  185     C  A02  46.74633 35,000_cells + HCMEC D3_line     32000
      4877  190     C  A02  47.76807 35,000_cells + HCMEC D3_line     32000
      4878  195     C  A02  48.77086 35,000_cells + HCMEC D3_line     32000
      4879  200     C  A02        NA 35,000_cells + HCMEC D3_line     32000
      4880    0     C  A02        NA 35,000_cells + HCMEC D3_line      4000
      4881    5     C  A02 102.47403 35,000_cells + HCMEC D3_line      4000
      4882   10     C  A02  95.39733 35,000_cells + HCMEC D3_line      4000
      4883   15     C  A02  89.73144 35,000_cells + HCMEC D3_line      4000
      4884   20     C  A02  87.81246 35,000_cells + HCMEC D3_line      4000
      4885   25     C  A02  86.92457 35,000_cells + HCMEC D3_line      4000
      4886   30     C  A02  87.09611 35,000_cells + HCMEC D3_line      4000
      4887   35     C  A02  87.92794 35,000_cells + HCMEC D3_line      4000
      4888   40     C  A02  89.96883 35,000_cells + HCMEC D3_line      4000
      4889   45     C  A02  91.88145 35,000_cells + HCMEC D3_line      4000
      4890   50     C  A02  93.40100 35,000_cells + HCMEC D3_line      4000
      4891   55     C  A02  94.60065 35,000_cells + HCMEC D3_line      4000
      4892   60     C  A02  95.81250 35,000_cells + HCMEC D3_line      4000
      4893   65     C  A02  96.98878 35,000_cells + HCMEC D3_line      4000
      4894   70     C  A02  98.17984 35,000_cells + HCMEC D3_line      4000
      4895   75     C  A02  98.91973 35,000_cells + HCMEC D3_line      4000
      4896   80     C  A02  99.59053 35,000_cells + HCMEC D3_line      4000
      4897   85     C  A02 100.85839 35,000_cells + HCMEC D3_line      4000
      4898   90     C  A02 101.77363 35,000_cells + HCMEC D3_line      4000
      4899   95     C  A02 102.80891 35,000_cells + HCMEC D3_line      4000
      4900  100     C  A02 103.71030 35,000_cells + HCMEC D3_line      4000
      4901  105     C  A02 104.41681 35,000_cells + HCMEC D3_line      4000
      4902  110     C  A02 105.29858 35,000_cells + HCMEC D3_line      4000
      4903  115     C  A02 105.98910 35,000_cells + HCMEC D3_line      4000
      4904  120     C  A02 106.52668 35,000_cells + HCMEC D3_line      4000
      4905  125     C  A02 107.26717 35,000_cells + HCMEC D3_line      4000
      4906  130     C  A02 108.01271 35,000_cells + HCMEC D3_line      4000
      4907  135     C  A02 108.76433 35,000_cells + HCMEC D3_line      4000
      4908  140     C  A02 109.56337 35,000_cells + HCMEC D3_line      4000
      4909  145     C  A02 110.41373 35,000_cells + HCMEC D3_line      4000
      4910  150     C  A02 110.88943 35,000_cells + HCMEC D3_line      4000
      4911  155     C  A02 111.25800 35,000_cells + HCMEC D3_line      4000
      4912  160     C  A02 112.02105 35,000_cells + HCMEC D3_line      4000
      4913  165     C  A02 112.45939 35,000_cells + HCMEC D3_line      4000
      4914  170     C  A02 112.82087 35,000_cells + HCMEC D3_line      4000
      4915  175     C  A02 112.95894 35,000_cells + HCMEC D3_line      4000
      4916  180     C  A02 113.53227 35,000_cells + HCMEC D3_line      4000
      4917  185     C  A02 114.30658 35,000_cells + HCMEC D3_line      4000
      4918  190     C  A02 114.63919 35,000_cells + HCMEC D3_line      4000
      4919  195     C  A02 114.86193 35,000_cells + HCMEC D3_line      4000
      4920  200     C  A02        NA 35,000_cells + HCMEC D3_line      4000
      4921    0     C  A02        NA 35,000_cells + HCMEC D3_line       500
      4922    5     C  A02 120.54442 35,000_cells + HCMEC D3_line       500
      4923   10     C  A02 119.99490 35,000_cells + HCMEC D3_line       500
      4924   15     C  A02 119.58659 35,000_cells + HCMEC D3_line       500
      4925   20     C  A02 119.65247 35,000_cells + HCMEC D3_line       500
      4926   25     C  A02 119.97956 35,000_cells + HCMEC D3_line       500
      4927   30     C  A02 120.32462 35,000_cells + HCMEC D3_line       500
      4928   35     C  A02 120.70079 35,000_cells + HCMEC D3_line       500
      4929   40     C  A02 121.20956 35,000_cells + HCMEC D3_line       500
      4930   45     C  A02 121.71093 35,000_cells + HCMEC D3_line       500
      4931   50     C  A02 122.19421 35,000_cells + HCMEC D3_line       500
      4932   55     C  A02 122.55343 35,000_cells + HCMEC D3_line       500
      4933   60     C  A02 122.95200 35,000_cells + HCMEC D3_line       500
      4934   65     C  A02 123.39715 35,000_cells + HCMEC D3_line       500
      4935   70     C  A02 123.69996 35,000_cells + HCMEC D3_line       500
      4936   75     C  A02 123.96471 35,000_cells + HCMEC D3_line       500
      4937   80     C  A02 124.18138 35,000_cells + HCMEC D3_line       500
      4938   85     C  A02 124.43008 35,000_cells + HCMEC D3_line       500
      4939   90     C  A02 124.63836 35,000_cells + HCMEC D3_line       500
      4940   95     C  A02 124.82699 35,000_cells + HCMEC D3_line       500
      4941  100     C  A02 125.01056 35,000_cells + HCMEC D3_line       500
      4942  105     C  A02 125.19766 35,000_cells + HCMEC D3_line       500
      4943  110     C  A02 125.37607 35,000_cells + HCMEC D3_line       500
      4944  115     C  A02 125.51711 35,000_cells + HCMEC D3_line       500
      4945  120     C  A02 125.65867 35,000_cells + HCMEC D3_line       500
      4946  125     C  A02 125.79377 35,000_cells + HCMEC D3_line       500
      4947  130     C  A02 125.94888 35,000_cells + HCMEC D3_line       500
      4948  135     C  A02 126.08041 35,000_cells + HCMEC D3_line       500
      4949  140     C  A02 126.21546 35,000_cells + HCMEC D3_line       500
      4950  145     C  A02 126.32909 35,000_cells + HCMEC D3_line       500
      4951  150     C  A02 126.43403 35,000_cells + HCMEC D3_line       500
      4952  155     C  A02 126.53361 35,000_cells + HCMEC D3_line       500
      4953  160     C  A02 126.64321 35,000_cells + HCMEC D3_line       500
      4954  165     C  A02 126.73212 35,000_cells + HCMEC D3_line       500
      4955  170     C  A02 126.80611 35,000_cells + HCMEC D3_line       500
      4956  175     C  A02 126.86426 35,000_cells + HCMEC D3_line       500
      4957  180     C  A02 126.94783 35,000_cells + HCMEC D3_line       500
      4958  185     C  A02 127.03479 35,000_cells + HCMEC D3_line       500
      4959  190     C  A02 127.07015 35,000_cells + HCMEC D3_line       500
      4960  195     C  A02 127.10760 35,000_cells + HCMEC D3_line       500
      4961  200     C  A02        NA 35,000_cells + HCMEC D3_line       500
      4962    0     C  A02        NA 35,000_cells + HCMEC D3_line     64000
      4963    5     C  A02  47.18325 35,000_cells + HCMEC D3_line     64000
      4964   10     C  A02  37.02599 35,000_cells + HCMEC D3_line     64000
      4965   15     C  A02  28.15502 35,000_cells + HCMEC D3_line     64000
      4966   20     C  A02  22.52256 35,000_cells + HCMEC D3_line     64000
      4967   25     C  A02  19.73266 35,000_cells + HCMEC D3_line     64000
      4968   30     C  A02  17.36838 35,000_cells + HCMEC D3_line     64000
      4969   35     C  A02  15.59026 35,000_cells + HCMEC D3_line     64000
      4970   40     C  A02  13.14130 35,000_cells + HCMEC D3_line     64000
      4971   45     C  A02  11.75151 35,000_cells + HCMEC D3_line     64000
      4972   50     C  A02  11.16185 35,000_cells + HCMEC D3_line     64000
      4973   55     C  A02  11.00064 35,000_cells + HCMEC D3_line     64000
      4974   60     C  A02  10.93658 35,000_cells + HCMEC D3_line     64000
      4975   65     C  A02  11.07334 35,000_cells + HCMEC D3_line     64000
      4976   70     C  A02  11.26068 35,000_cells + HCMEC D3_line     64000
      4977   75     C  A02  11.52518 35,000_cells + HCMEC D3_line     64000
      4978   80     C  A02  11.67687 35,000_cells + HCMEC D3_line     64000
      4979   85     C  A02  12.09968 35,000_cells + HCMEC D3_line     64000
      4980   90     C  A02  12.57562 35,000_cells + HCMEC D3_line     64000
      4981   95     C  A02  12.96615 35,000_cells + HCMEC D3_line     64000
      4982  100     C  A02  13.44330 35,000_cells + HCMEC D3_line     64000
      4983  105     C  A02  13.93475 35,000_cells + HCMEC D3_line     64000
      4984  110     C  A02  14.25523 35,000_cells + HCMEC D3_line     64000
      4985  115     C  A02  14.86485 35,000_cells + HCMEC D3_line     64000
      4986  120     C  A02  15.37402 35,000_cells + HCMEC D3_line     64000
      4987  125     C  A02  15.97260 35,000_cells + HCMEC D3_line     64000
      4988  130     C  A02  16.57023 35,000_cells + HCMEC D3_line     64000
      4989  135     C  A02  17.16611 35,000_cells + HCMEC D3_line     64000
      4990  140     C  A02  17.87636 35,000_cells + HCMEC D3_line     64000
      4991  145     C  A02  18.63761 35,000_cells + HCMEC D3_line     64000
      4992  150     C  A02  19.06418 35,000_cells + HCMEC D3_line     64000
      4993  155     C  A02  19.65871 35,000_cells + HCMEC D3_line     64000
      4994  160     C  A02  20.39463 35,000_cells + HCMEC D3_line     64000
      4995  165     C  A02  21.05449 35,000_cells + HCMEC D3_line     64000
      4996  170     C  A02  21.95193 35,000_cells + HCMEC D3_line     64000
      4997  175     C  A02  22.54167 35,000_cells + HCMEC D3_line     64000
      4998  180     C  A02  23.19637 35,000_cells + HCMEC D3_line     64000
      4999  185     C  A02  24.10706 35,000_cells + HCMEC D3_line     64000
      5000  190     C  A02  24.76939 35,000_cells + HCMEC D3_line     64000
      5001  195     C  A02  25.67945 35,000_cells + HCMEC D3_line     64000
      5002  200     C  A02        NA 35,000_cells + HCMEC D3_line     64000
      5003    0     C  A02        NA 35,000_cells + HCMEC D3_line      8000
      5004    5     C  A02  89.05617 35,000_cells + HCMEC D3_line      8000
      5005   10     C  A02  78.98141 35,000_cells + HCMEC D3_line      8000
      5006   15     C  A02  70.99549 35,000_cells + HCMEC D3_line      8000
      5007   20     C  A02  67.33588 35,000_cells + HCMEC D3_line      8000
      5008   25     C  A02  65.38854 35,000_cells + HCMEC D3_line      8000
      5009   30     C  A02  64.57370 35,000_cells + HCMEC D3_line      8000
      5010   35     C  A02  64.95723 35,000_cells + HCMEC D3_line      8000
      5011   40     C  A02  66.45491 35,000_cells + HCMEC D3_line      8000
      5012   45     C  A02  67.83357 35,000_cells + HCMEC D3_line      8000
      5013   50     C  A02  69.13714 35,000_cells + HCMEC D3_line      8000
      5014   55     C  A02  70.33780 35,000_cells + HCMEC D3_line      8000
      5015   60     C  A02  71.20469 35,000_cells + HCMEC D3_line      8000
      5016   65     C  A02  72.47491 35,000_cells + HCMEC D3_line      8000
      5017   70     C  A02  73.87417 35,000_cells + HCMEC D3_line      8000
      5018   75     C  A02  74.79107 35,000_cells + HCMEC D3_line      8000
      5019   80     C  A02  75.73364 35,000_cells + HCMEC D3_line      8000
      5020   85     C  A02  77.36926 35,000_cells + HCMEC D3_line      8000
      5021   90     C  A02  78.74388 35,000_cells + HCMEC D3_line      8000
      5022   95     C  A02  80.34927 35,000_cells + HCMEC D3_line      8000
      5023  100     C  A02  81.77920 35,000_cells + HCMEC D3_line      8000
      5024  105     C  A02  82.83536 35,000_cells + HCMEC D3_line      8000
      5025  110     C  A02  84.13400 35,000_cells + HCMEC D3_line      8000
      5026  115     C  A02  85.31203 35,000_cells + HCMEC D3_line      8000
      5027  120     C  A02  86.24959 35,000_cells + HCMEC D3_line      8000
      5028  125     C  A02  87.47588 35,000_cells + HCMEC D3_line      8000
      5029  130     C  A02  88.56722 35,000_cells + HCMEC D3_line      8000
      5030  135     C  A02  89.84370 35,000_cells + HCMEC D3_line      8000
      5031  140     C  A02  91.02331 35,000_cells + HCMEC D3_line      8000
      5032  145     C  A02  92.40510 35,000_cells + HCMEC D3_line      8000
      5033  150     C  A02  93.15989 35,000_cells + HCMEC D3_line      8000
      5034  155     C  A02  93.74154 35,000_cells + HCMEC D3_line      8000
      5035  160     C  A02  94.86760 35,000_cells + HCMEC D3_line      8000
      5036  165     C  A02  95.56667 35,000_cells + HCMEC D3_line      8000
      5037  170     C  A02  96.25010 35,000_cells + HCMEC D3_line      8000
      5038  175     C  A02  96.49753 35,000_cells + HCMEC D3_line      8000
      5039  180     C  A02  97.21776 35,000_cells + HCMEC D3_line      8000
      5040  185     C  A02  98.32557 35,000_cells + HCMEC D3_line      8000
      5041  190     C  A02  98.86513 35,000_cells + HCMEC D3_line      8000
      5042  195     C  A02  99.18570 35,000_cells + HCMEC D3_line      8000
      5043  200     C  A02        NA 35,000_cells + HCMEC D3_line      8000
      5044    0     C  A03        NA 35,000_cells + HCMEC D3_line      1000
      5045    5     C  A03 118.06626 35,000_cells + HCMEC D3_line      1000
      5046   10     C  A03 117.22765 35,000_cells + HCMEC D3_line      1000
      5047   15     C  A03 115.77691 35,000_cells + HCMEC D3_line      1000
      5048   20     C  A03 115.30408 35,000_cells + HCMEC D3_line      1000
      5049   25     C  A03 115.22148 35,000_cells + HCMEC D3_line      1000
      5050   30     C  A03 115.84586 35,000_cells + HCMEC D3_line      1000
      5051   35     C  A03 116.38068 35,000_cells + HCMEC D3_line      1000
      5052   40     C  A03 117.08894 35,000_cells + HCMEC D3_line      1000
      5053   45     C  A03 117.78619 35,000_cells + HCMEC D3_line      1000
      5054   50     C  A03 118.51341 35,000_cells + HCMEC D3_line      1000
      5055   55     C  A03 119.20349 35,000_cells + HCMEC D3_line      1000
      5056   60     C  A03 119.88700 35,000_cells + HCMEC D3_line      1000
      5057   65     C  A03 120.44896 35,000_cells + HCMEC D3_line      1000
      5058   70     C  A03 120.94278 35,000_cells + HCMEC D3_line      1000
      5059   75     C  A03 121.36597 35,000_cells + HCMEC D3_line      1000
      5060   80     C  A03 121.70477 35,000_cells + HCMEC D3_line      1000
      5061   85     C  A03 122.08047 35,000_cells + HCMEC D3_line      1000
      5062   90     C  A03 122.47411 35,000_cells + HCMEC D3_line      1000
      5063   95     C  A03 122.70517 35,000_cells + HCMEC D3_line      1000
      5064  100     C  A03 122.98384 35,000_cells + HCMEC D3_line      1000
      5065  105     C  A03 123.21737 35,000_cells + HCMEC D3_line      1000
      5066  110     C  A03 123.41130 35,000_cells + HCMEC D3_line      1000
      5067  115     C  A03 123.68831 35,000_cells + HCMEC D3_line      1000
      5068  120     C  A03 123.93290 35,000_cells + HCMEC D3_line      1000
      5069  125     C  A03 124.13951 35,000_cells + HCMEC D3_line      1000
      5070  130     C  A03 124.35583 35,000_cells + HCMEC D3_line      1000
      5071  135     C  A03 124.57121 35,000_cells + HCMEC D3_line      1000
      5072  140     C  A03 124.73801 35,000_cells + HCMEC D3_line      1000
      5073  145     C  A03 124.95601 35,000_cells + HCMEC D3_line      1000
      5074  150     C  A03 125.13580 35,000_cells + HCMEC D3_line      1000
      5075  155     C  A03 125.37015 35,000_cells + HCMEC D3_line      1000
      5076  160     C  A03 125.60941 35,000_cells + HCMEC D3_line      1000
      5077  165     C  A03 125.78399 35,000_cells + HCMEC D3_line      1000
      5078  170     C  A03 125.98173 35,000_cells + HCMEC D3_line      1000
      5079  175     C  A03 126.14276 35,000_cells + HCMEC D3_line      1000
      5080  180     C  A03 126.27197 35,000_cells + HCMEC D3_line      1000
      5081  185     C  A03 126.42326 35,000_cells + HCMEC D3_line      1000
      5082  190     C  A03 126.55670 35,000_cells + HCMEC D3_line      1000
      5083  195     C  A03 126.64011 35,000_cells + HCMEC D3_line      1000
      5084  200     C  A03        NA 35,000_cells + HCMEC D3_line      1000
      5085    0     C  A03        NA 35,000_cells + HCMEC D3_line     16000
      5086    5     C  A03  79.35875 35,000_cells + HCMEC D3_line     16000
      5087   10     C  A03  71.16109 35,000_cells + HCMEC D3_line     16000
      5088   15     C  A03  60.62088 35,000_cells + HCMEC D3_line     16000
      5089   20     C  A03  53.72353 35,000_cells + HCMEC D3_line     16000
      5090   25     C  A03  48.88170 35,000_cells + HCMEC D3_line     16000
      5091   30     C  A03  46.35717 35,000_cells + HCMEC D3_line     16000
      5092   35     C  A03  45.13368 35,000_cells + HCMEC D3_line     16000
      5093   40     C  A03  43.87975 35,000_cells + HCMEC D3_line     16000
      5094   45     C  A03  43.37920 35,000_cells + HCMEC D3_line     16000
      5095   50     C  A03  43.32112 35,000_cells + HCMEC D3_line     16000
      5096   55     C  A03  43.81949 35,000_cells + HCMEC D3_line     16000
      5097   60     C  A03  44.51485 35,000_cells + HCMEC D3_line     16000
      5098   65     C  A03  45.60465 35,000_cells + HCMEC D3_line     16000
      5099   70     C  A03  45.88300 35,000_cells + HCMEC D3_line     16000
      5100   75     C  A03  47.19652 35,000_cells + HCMEC D3_line     16000
      5101   80     C  A03  48.19147 35,000_cells + HCMEC D3_line     16000
      5102   85     C  A03  49.35851 35,000_cells + HCMEC D3_line     16000
      5103   90     C  A03  50.93503 35,000_cells + HCMEC D3_line     16000
      5104   95     C  A03  52.15264 35,000_cells + HCMEC D3_line     16000
      5105  100     C  A03  53.71555 35,000_cells + HCMEC D3_line     16000
      5106  105     C  A03  55.10267 35,000_cells + HCMEC D3_line     16000
      5107  110     C  A03  56.40627 35,000_cells + HCMEC D3_line     16000
      5108  115     C  A03  58.14183 35,000_cells + HCMEC D3_line     16000
      5109  120     C  A03  59.40320 35,000_cells + HCMEC D3_line     16000
      5110  125     C  A03  60.56633 35,000_cells + HCMEC D3_line     16000
      5111  130     C  A03  62.16513 35,000_cells + HCMEC D3_line     16000
      5112  135     C  A03  63.31815 35,000_cells + HCMEC D3_line     16000
      5113  140     C  A03  64.56734 35,000_cells + HCMEC D3_line     16000
      5114  145     C  A03  66.03018 35,000_cells + HCMEC D3_line     16000
      5115  150     C  A03  67.14481 35,000_cells + HCMEC D3_line     16000
      5116  155     C  A03  68.83087 35,000_cells + HCMEC D3_line     16000
      5117  160     C  A03  70.26045 35,000_cells + HCMEC D3_line     16000
      5118  165     C  A03  71.75029 35,000_cells + HCMEC D3_line     16000
      5119  170     C  A03  72.79587 35,000_cells + HCMEC D3_line     16000
      5120  175     C  A03  74.07287 35,000_cells + HCMEC D3_line     16000
      5121  180     C  A03  74.94612 35,000_cells + HCMEC D3_line     16000
      5122  185     C  A03  76.41746 35,000_cells + HCMEC D3_line     16000
      5123  190     C  A03  77.78857 35,000_cells + HCMEC D3_line     16000
      5124  195     C  A03  78.70812 35,000_cells + HCMEC D3_line     16000
      5125  200     C  A03        NA 35,000_cells + HCMEC D3_line     16000
      5126    0     C  A03        NA 35,000_cells + HCMEC D3_line      2000
      5127    5     C  A03 112.86843 35,000_cells + HCMEC D3_line      2000
      5128   10     C  A03 110.51160 35,000_cells + HCMEC D3_line      2000
      5129   15     C  A03 106.93893 35,000_cells + HCMEC D3_line      2000
      5130   20     C  A03 105.22721 35,000_cells + HCMEC D3_line      2000
      5131   25     C  A03 104.39545 35,000_cells + HCMEC D3_line      2000
      5132   30     C  A03 105.00159 35,000_cells + HCMEC D3_line      2000
      5133   35     C  A03 105.74282 35,000_cells + HCMEC D3_line      2000
      5134   40     C  A03 106.67323 35,000_cells + HCMEC D3_line      2000
      5135   45     C  A03 107.97117 35,000_cells + HCMEC D3_line      2000
      5136   50     C  A03 109.19989 35,000_cells + HCMEC D3_line      2000
      5137   55     C  A03 110.42675 35,000_cells + HCMEC D3_line      2000
      5138   60     C  A03 111.62942 35,000_cells + HCMEC D3_line      2000
      5139   65     C  A03 112.60559 35,000_cells + HCMEC D3_line      2000
      5140   70     C  A03 113.36362 35,000_cells + HCMEC D3_line      2000
      5141   75     C  A03 114.09173 35,000_cells + HCMEC D3_line      2000
      5142   80     C  A03 114.67442 35,000_cells + HCMEC D3_line      2000
      5143   85     C  A03 115.27689 35,000_cells + HCMEC D3_line      2000
      5144   90     C  A03 115.97831 35,000_cells + HCMEC D3_line      2000
      5145   95     C  A03 116.35695 35,000_cells + HCMEC D3_line      2000
      5146  100     C  A03 116.88866 35,000_cells + HCMEC D3_line      2000
      5147  105     C  A03 117.35390 35,000_cells + HCMEC D3_line      2000
      5148  110     C  A03 117.64494 35,000_cells + HCMEC D3_line      2000
      5149  115     C  A03 118.23572 35,000_cells + HCMEC D3_line      2000
      5150  120     C  A03 118.65509 35,000_cells + HCMEC D3_line      2000
      5151  125     C  A03 118.97954 35,000_cells + HCMEC D3_line      2000
      5152  130     C  A03 119.41292 35,000_cells + HCMEC D3_line      2000
      5153  135     C  A03 119.78051 35,000_cells + HCMEC D3_line      2000
      5154  140     C  A03 120.08262 35,000_cells + HCMEC D3_line      2000
      5155  145     C  A03 120.53552 35,000_cells + HCMEC D3_line      2000
      5156  150     C  A03 120.87666 35,000_cells + HCMEC D3_line      2000
      5157  155     C  A03 121.32852 35,000_cells + HCMEC D3_line      2000
      5158  160     C  A03 121.84709 35,000_cells + HCMEC D3_line      2000
      5159  165     C  A03 122.21751 35,000_cells + HCMEC D3_line      2000
      5160  170     C  A03 122.59968 35,000_cells + HCMEC D3_line      2000
      5161  175     C  A03 122.92345 35,000_cells + HCMEC D3_line      2000
      5162  180     C  A03 123.13256 35,000_cells + HCMEC D3_line      2000
      5163  185     C  A03 123.46889 35,000_cells + HCMEC D3_line      2000
      5164  190     C  A03 123.80711 35,000_cells + HCMEC D3_line      2000
      5165  195     C  A03 123.98380 35,000_cells + HCMEC D3_line      2000
      5166  200     C  A03        NA 35,000_cells + HCMEC D3_line      2000
      5167    0     C  A03        NA 35,000_cells + HCMEC D3_line       250
      5168    5     C  A03 123.61705 35,000_cells + HCMEC D3_line       250
      5169   10     C  A03 123.40468 35,000_cells + HCMEC D3_line       250
      5170   15     C  A03 123.10083 35,000_cells + HCMEC D3_line       250
      5171   20     C  A03 123.18798 35,000_cells + HCMEC D3_line       250
      5172   25     C  A03 123.40516 35,000_cells + HCMEC D3_line       250
      5173   30     C  A03 123.75502 35,000_cells + HCMEC D3_line       250
      5174   35     C  A03 124.01799 35,000_cells + HCMEC D3_line       250
      5175   40     C  A03 124.33309 35,000_cells + HCMEC D3_line       250
      5176   45     C  A03 124.67257 35,000_cells + HCMEC D3_line       250
      5177   50     C  A03 125.00728 35,000_cells + HCMEC D3_line       250
      5178   55     C  A03 125.32972 35,000_cells + HCMEC D3_line       250
      5179   60     C  A03 125.64068 35,000_cells + HCMEC D3_line       250
      5180   65     C  A03 125.91985 35,000_cells + HCMEC D3_line       250
      5181   70     C  A03 126.18659 35,000_cells + HCMEC D3_line       250
      5182   75     C  A03 126.42782 35,000_cells + HCMEC D3_line       250
      5183   80     C  A03 126.64073 35,000_cells + HCMEC D3_line       250
      5184   85     C  A03 126.84899 35,000_cells + HCMEC D3_line       250
      5185   90     C  A03 127.04044 35,000_cells + HCMEC D3_line       250
      5186   95     C  A03 127.21381 35,000_cells + HCMEC D3_line       250
      5187  100     C  A03 127.38453 35,000_cells + HCMEC D3_line       250
      5188  105     C  A03 127.54959 35,000_cells + HCMEC D3_line       250
      5189  110     C  A03 127.68824 35,000_cells + HCMEC D3_line       250
      5190  115     C  A03 127.84028 35,000_cells + HCMEC D3_line       250
      5191  120     C  A03 127.96904 35,000_cells + HCMEC D3_line       250
      5192  125     C  A03 128.10983 35,000_cells + HCMEC D3_line       250
      5193  130     C  A03 128.23389 35,000_cells + HCMEC D3_line       250
      5194  135     C  A03 128.35780 35,000_cells + HCMEC D3_line       250
      5195  140     C  A03 128.47755 35,000_cells + HCMEC D3_line       250
      5196  145     C  A03 128.59528 35,000_cells + HCMEC D3_line       250
      5197  150     C  A03 128.70226 35,000_cells + HCMEC D3_line       250
      5198  155     C  A03 128.82203 35,000_cells + HCMEC D3_line       250
      5199  160     C  A03 128.92583 35,000_cells + HCMEC D3_line       250
      5200  165     C  A03 129.02396 35,000_cells + HCMEC D3_line       250
      5201  170     C  A03 129.11924 35,000_cells + HCMEC D3_line       250
      5202  175     C  A03 129.22616 35,000_cells + HCMEC D3_line       250
      5203  180     C  A03 129.29032 35,000_cells + HCMEC D3_line       250
      5204  185     C  A03 129.35838 35,000_cells + HCMEC D3_line       250
      5205  190     C  A03 129.42065 35,000_cells + HCMEC D3_line       250
      5206  195     C  A03 129.47791 35,000_cells + HCMEC D3_line       250
      5207  200     C  A03        NA 35,000_cells + HCMEC D3_line       250
      5208    0     C  A03        NA 35,000_cells + HCMEC D3_line     32000
      5209    5     C  A03  66.33106 35,000_cells + HCMEC D3_line     32000
      5210   10     C  A03  57.88796 35,000_cells + HCMEC D3_line     32000
      5211   15     C  A03  47.35816 35,000_cells + HCMEC D3_line     32000
      5212   20     C  A03  40.25465 35,000_cells + HCMEC D3_line     32000
      5213   25     C  A03  35.12571 35,000_cells + HCMEC D3_line     32000
      5214   30     C  A03  31.72974 35,000_cells + HCMEC D3_line     32000
      5215   35     C  A03  29.61097 35,000_cells + HCMEC D3_line     32000
      5216   40     C  A03  27.36108 35,000_cells + HCMEC D3_line     32000
      5217   45     C  A03  25.09269 35,000_cells + HCMEC D3_line     32000
      5218   50     C  A03  23.81238 35,000_cells + HCMEC D3_line     32000
      5219   55     C  A03  23.07735 35,000_cells + HCMEC D3_line     32000
      5220   60     C  A03  22.93953 35,000_cells + HCMEC D3_line     32000
      5221   65     C  A03  23.21835 35,000_cells + HCMEC D3_line     32000
      5222   70     C  A03  23.17613 35,000_cells + HCMEC D3_line     32000
      5223   75     C  A03  23.85276 35,000_cells + HCMEC D3_line     32000
      5224   80     C  A03  24.51569 35,000_cells + HCMEC D3_line     32000
      5225   85     C  A03  25.26522 35,000_cells + HCMEC D3_line     32000
      5226   90     C  A03  26.29272 35,000_cells + HCMEC D3_line     32000
      5227   95     C  A03  27.15228 35,000_cells + HCMEC D3_line     32000
      5228  100     C  A03  28.14761 35,000_cells + HCMEC D3_line     32000
      5229  105     C  A03  29.11159 35,000_cells + HCMEC D3_line     32000
      5230  110     C  A03  30.05632 35,000_cells + HCMEC D3_line     32000
      5231  115     C  A03  31.31890 35,000_cells + HCMEC D3_line     32000
      5232  120     C  A03  32.34224 35,000_cells + HCMEC D3_line     32000
      5233  125     C  A03  33.32421 35,000_cells + HCMEC D3_line     32000
      5234  130     C  A03  34.70848 35,000_cells + HCMEC D3_line     32000
      5235  135     C  A03  35.67812 35,000_cells + HCMEC D3_line     32000
      5236  140     C  A03  36.78391 35,000_cells + HCMEC D3_line     32000
      5237  145     C  A03  37.94664 35,000_cells + HCMEC D3_line     32000
      5238  150     C  A03  39.07571 35,000_cells + HCMEC D3_line     32000
      5239  155     C  A03  40.59435 35,000_cells + HCMEC D3_line     32000
      5240  160     C  A03  41.92526 35,000_cells + HCMEC D3_line     32000
      5241  165     C  A03  43.36704 35,000_cells + HCMEC D3_line     32000
      5242  170     C  A03  44.48680 35,000_cells + HCMEC D3_line     32000
      5243  175     C  A03  45.73606 35,000_cells + HCMEC D3_line     32000
      5244  180     C  A03  46.83095 35,000_cells + HCMEC D3_line     32000
      5245  185     C  A03  48.48739 35,000_cells + HCMEC D3_line     32000
      5246  190     C  A03  49.89138 35,000_cells + HCMEC D3_line     32000
      5247  195     C  A03  51.13119 35,000_cells + HCMEC D3_line     32000
      5248  200     C  A03        NA 35,000_cells + HCMEC D3_line     32000
      5249    0     C  A03        NA 35,000_cells + HCMEC D3_line      4000
      5250    5     C  A03 104.13720 35,000_cells + HCMEC D3_line      4000
      5251   10     C  A03  99.59732 35,000_cells + HCMEC D3_line      4000
      5252   15     C  A03  93.21698 35,000_cells + HCMEC D3_line      4000
      5253   20     C  A03  89.69707 35,000_cells + HCMEC D3_line      4000
      5254   25     C  A03  87.70841 35,000_cells + HCMEC D3_line      4000
      5255   30     C  A03  87.88362 35,000_cells + HCMEC D3_line      4000
      5256   35     C  A03  88.58571 35,000_cells + HCMEC D3_line      4000
      5257   40     C  A03  89.39257 35,000_cells + HCMEC D3_line      4000
      5258   45     C  A03  91.28464 35,000_cells + HCMEC D3_line      4000
      5259   50     C  A03  93.00583 35,000_cells + HCMEC D3_line      4000
      5260   55     C  A03  94.86179 35,000_cells + HCMEC D3_line      4000
      5261   60     C  A03  96.64789 35,000_cells + HCMEC D3_line      4000
      5262   65     C  A03  98.23431 35,000_cells + HCMEC D3_line      4000
      5263   70     C  A03  99.23058 35,000_cells + HCMEC D3_line      4000
      5264   75     C  A03 100.44810 35,000_cells + HCMEC D3_line      4000
      5265   80     C  A03 101.25635 35,000_cells + HCMEC D3_line      4000
      5266   85     C  A03 102.10571 35,000_cells + HCMEC D3_line      4000
      5267   90     C  A03 103.15855 35,000_cells + HCMEC D3_line      4000
      5268   95     C  A03 103.78851 35,000_cells + HCMEC D3_line      4000
      5269  100     C  A03 104.72566 35,000_cells + HCMEC D3_line      4000
      5270  105     C  A03 105.51319 35,000_cells + HCMEC D3_line      4000
      5271  110     C  A03 106.02145 35,000_cells + HCMEC D3_line      4000
      5272  115     C  A03 107.02401 35,000_cells + HCMEC D3_line      4000
      5273  120     C  A03 107.67107 35,000_cells + HCMEC D3_line      4000
      5274  125     C  A03 108.16645 35,000_cells + HCMEC D3_line      4000
      5275  130     C  A03 108.88934 35,000_cells + HCMEC D3_line      4000
      5276  135     C  A03 109.47714 35,000_cells + HCMEC D3_line      4000
      5277  140     C  A03 109.99860 35,000_cells + HCMEC D3_line      4000
      5278  145     C  A03 110.81347 35,000_cells + HCMEC D3_line      4000
      5279  150     C  A03 111.33399 35,000_cells + HCMEC D3_line      4000
      5280  155     C  A03 112.15114 35,000_cells + HCMEC D3_line      4000
      5281  160     C  A03 112.97682 35,000_cells + HCMEC D3_line      4000
      5282  165     C  A03 113.64773 35,000_cells + HCMEC D3_line      4000
      5283  170     C  A03 114.23775 35,000_cells + HCMEC D3_line      4000
      5284  175     C  A03 114.82378 35,000_cells + HCMEC D3_line      4000
      5285  180     C  A03 115.13544 35,000_cells + HCMEC D3_line      4000
      5286  185     C  A03 115.74862 35,000_cells + HCMEC D3_line      4000
      5287  190     C  A03 116.41380 35,000_cells + HCMEC D3_line      4000
      5288  195     C  A03 116.70397 35,000_cells + HCMEC D3_line      4000
      5289  200     C  A03        NA 35,000_cells + HCMEC D3_line      4000
      5290    0     C  A03        NA 35,000_cells + HCMEC D3_line       500
      5291    5     C  A03 121.35217 35,000_cells + HCMEC D3_line       500
      5292   10     C  A03 121.04807 35,000_cells + HCMEC D3_line       500
      5293   15     C  A03 120.47824 35,000_cells + HCMEC D3_line       500
      5294   20     C  A03 120.47187 35,000_cells + HCMEC D3_line       500
      5295   25     C  A03 120.65367 35,000_cells + HCMEC D3_line       500
      5296   30     C  A03 121.13364 35,000_cells + HCMEC D3_line       500
      5297   35     C  A03 121.49270 35,000_cells + HCMEC D3_line       500
      5298   40     C  A03 121.95879 35,000_cells + HCMEC D3_line       500
      5299   45     C  A03 122.38948 35,000_cells + HCMEC D3_line       500
      5300   50     C  A03 122.84115 35,000_cells + HCMEC D3_line       500
      5301   55     C  A03 123.26857 35,000_cells + HCMEC D3_line       500
      5302   60     C  A03 123.67468 35,000_cells + HCMEC D3_line       500
      5303   65     C  A03 124.02605 35,000_cells + HCMEC D3_line       500
      5304   70     C  A03 124.35122 35,000_cells + HCMEC D3_line       500
      5305   75     C  A03 124.61786 35,000_cells + HCMEC D3_line       500
      5306   80     C  A03 124.87509 35,000_cells + HCMEC D3_line       500
      5307   85     C  A03 125.13105 35,000_cells + HCMEC D3_line       500
      5308   90     C  A03 125.37127 35,000_cells + HCMEC D3_line       500
      5309   95     C  A03 125.56086 35,000_cells + HCMEC D3_line       500
      5310  100     C  A03 125.75328 35,000_cells + HCMEC D3_line       500
      5311  105     C  A03 125.92867 35,000_cells + HCMEC D3_line       500
      5312  110     C  A03 126.07953 35,000_cells + HCMEC D3_line       500
      5313  115     C  A03 126.25914 35,000_cells + HCMEC D3_line       500
      5314  120     C  A03 126.42233 35,000_cells + HCMEC D3_line       500
      5315  125     C  A03 126.57905 35,000_cells + HCMEC D3_line       500
      5316  130     C  A03 126.71634 35,000_cells + HCMEC D3_line       500
      5317  135     C  A03 126.86594 35,000_cells + HCMEC D3_line       500
      5318  140     C  A03 127.00583 35,000_cells + HCMEC D3_line       500
      5319  145     C  A03 127.14015 35,000_cells + HCMEC D3_line       500
      5320  150     C  A03 127.26967 35,000_cells + HCMEC D3_line       500
      5321  155     C  A03 127.40533 35,000_cells + HCMEC D3_line       500
      5322  160     C  A03 127.53965 35,000_cells + HCMEC D3_line       500
      5323  165     C  A03 127.65658 35,000_cells + HCMEC D3_line       500
      5324  170     C  A03 127.76432 35,000_cells + HCMEC D3_line       500
      5325  175     C  A03 127.88963 35,000_cells + HCMEC D3_line       500
      5326  180     C  A03 127.96701 35,000_cells + HCMEC D3_line       500
      5327  185     C  A03 128.05155 35,000_cells + HCMEC D3_line       500
      5328  190     C  A03 128.12874 35,000_cells + HCMEC D3_line       500
      5329  195     C  A03 128.18042 35,000_cells + HCMEC D3_line       500
      5330  200     C  A03        NA 35,000_cells + HCMEC D3_line       500
      5331    0     C  A03        NA 35,000_cells + HCMEC D3_line     64000
      5332    5     C  A03  50.11403 35,000_cells + HCMEC D3_line     64000
      5333   10     C  A03  43.30432 35,000_cells + HCMEC D3_line     64000
      5334   15     C  A03  34.75050 35,000_cells + HCMEC D3_line     64000
      5335   20     C  A03  28.87170 35,000_cells + HCMEC D3_line     64000
      5336   25     C  A03  24.67238 35,000_cells + HCMEC D3_line     64000
      5337   30     C  A03  21.46411 35,000_cells + HCMEC D3_line     64000
      5338   35     C  A03  19.21780 35,000_cells + HCMEC D3_line     64000
      5339   40     C  A03  16.92001 35,000_cells + HCMEC D3_line     64000
      5340   45     C  A03  14.19162 35,000_cells + HCMEC D3_line     64000
      5341   50     C  A03  12.75980 35,000_cells + HCMEC D3_line     64000
      5342   55     C  A03  11.81327 35,000_cells + HCMEC D3_line     64000
      5343   60     C  A03  11.58355 35,000_cells + HCMEC D3_line     64000
      5344   65     C  A03  11.59594 35,000_cells + HCMEC D3_line     64000
      5345   70     C  A03  11.51990 35,000_cells + HCMEC D3_line     64000
      5346   75     C  A03  11.79923 35,000_cells + HCMEC D3_line     64000
      5347   80     C  A03  12.11396 35,000_cells + HCMEC D3_line     64000
      5348   85     C  A03  12.47013 35,000_cells + HCMEC D3_line     64000
      5349   90     C  A03  12.91951 35,000_cells + HCMEC D3_line     64000
      5350   95     C  A03  13.30511 35,000_cells + HCMEC D3_line     64000
      5351  100     C  A03  13.72936 35,000_cells + HCMEC D3_line     64000
      5352  105     C  A03  14.16101 35,000_cells + HCMEC D3_line     64000
      5353  110     C  A03  14.58290 35,000_cells + HCMEC D3_line     64000
      5354  115     C  A03  15.21043 35,000_cells + HCMEC D3_line     64000
      5355  120     C  A03  15.71146 35,000_cells + HCMEC D3_line     64000
      5356  125     C  A03  16.18952 35,000_cells + HCMEC D3_line     64000
      5357  130     C  A03  16.90708 35,000_cells + HCMEC D3_line     64000
      5358  135     C  A03  17.40305 35,000_cells + HCMEC D3_line     64000
      5359  140     C  A03  17.96241 35,000_cells + HCMEC D3_line     64000
      5360  145     C  A03  18.54348 35,000_cells + HCMEC D3_line     64000
      5361  150     C  A03  19.22934 35,000_cells + HCMEC D3_line     64000
      5362  155     C  A03  20.09759 35,000_cells + HCMEC D3_line     64000
      5363  160     C  A03  20.87611 35,000_cells + HCMEC D3_line     64000
      5364  165     C  A03  21.71399 35,000_cells + HCMEC D3_line     64000
      5365  170     C  A03  22.49837 35,000_cells + HCMEC D3_line     64000
      5366  175     C  A03  23.26099 35,000_cells + HCMEC D3_line     64000
      5367  180     C  A03  24.11076 35,000_cells + HCMEC D3_line     64000
      5368  185     C  A03  25.21442 35,000_cells + HCMEC D3_line     64000
      5369  190     C  A03  26.14548 35,000_cells + HCMEC D3_line     64000
      5370  195     C  A03  27.10604 35,000_cells + HCMEC D3_line     64000
      5371  200     C  A03        NA 35,000_cells + HCMEC D3_line     64000
      5372    0     C  A03        NA 35,000_cells + HCMEC D3_line      8000
      5373    5     C  A03  91.86031 35,000_cells + HCMEC D3_line      8000
      5374   10     C  A03  85.16184 35,000_cells + HCMEC D3_line      8000
      5375   15     C  A03  76.25393 35,000_cells + HCMEC D3_line      8000
      5376   20     C  A03  70.84075 35,000_cells + HCMEC D3_line      8000
      5377   25     C  A03  67.31815 35,000_cells + HCMEC D3_line      8000
      5378   30     C  A03  66.21567 35,000_cells + HCMEC D3_line      8000
      5379   35     C  A03  66.16903 35,000_cells + HCMEC D3_line      8000
      5380   40     C  A03  66.22184 35,000_cells + HCMEC D3_line      8000
      5381   45     C  A03  67.64857 35,000_cells + HCMEC D3_line      8000
      5382   50     C  A03  69.05647 35,000_cells + HCMEC D3_line      8000
      5383   55     C  A03  70.84506 35,000_cells + HCMEC D3_line      8000
      5384   60     C  A03  72.56161 35,000_cells + HCMEC D3_line      8000
      5385   65     C  A03  74.33095 35,000_cells + HCMEC D3_line      8000
      5386   70     C  A03  75.15244 35,000_cells + HCMEC D3_line      8000
      5387   75     C  A03  76.69203 35,000_cells + HCMEC D3_line      8000
      5388   80     C  A03  77.70892 35,000_cells + HCMEC D3_line      8000
      5389   85     C  A03  78.85485 35,000_cells + HCMEC D3_line      8000
      5390   90     C  A03  80.36376 35,000_cells + HCMEC D3_line      8000
      5391   95     C  A03  81.37505 35,000_cells + HCMEC D3_line      8000
      5392  100     C  A03  82.80787 35,000_cells + HCMEC D3_line      8000
      5393  105     C  A03  84.04682 35,000_cells + HCMEC D3_line      8000
      5394  110     C  A03  85.00727 35,000_cells + HCMEC D3_line      8000
      5395  115     C  A03  86.53314 35,000_cells + HCMEC D3_line      8000
      5396  120     C  A03  87.49334 35,000_cells + HCMEC D3_line      8000
      5397  125     C  A03  88.31387 35,000_cells + HCMEC D3_line      8000
      5398  130     C  A03  89.50354 35,000_cells + HCMEC D3_line      8000
      5399  135     C  A03  90.42173 35,000_cells + HCMEC D3_line      8000
      5400  140     C  A03  91.33591 35,000_cells + HCMEC D3_line      8000
      5401  145     C  A03  92.58215 35,000_cells + HCMEC D3_line      8000
      5402  150     C  A03  93.37326 35,000_cells + HCMEC D3_line      8000
      5403  155     C  A03  94.62710 35,000_cells + HCMEC D3_line      8000
      5404  160     C  A03  95.76859 35,000_cells + HCMEC D3_line      8000
      5405  165     C  A03  96.82385 35,000_cells + HCMEC D3_line      8000
      5406  170     C  A03  97.59611 35,000_cells + HCMEC D3_line      8000
      5407  175     C  A03  98.49230 35,000_cells + HCMEC D3_line      8000
      5408  180     C  A03  99.02707 35,000_cells + HCMEC D3_line      8000
      5409  185     C  A03  99.97911 35,000_cells + HCMEC D3_line      8000
      5410  190     C  A03 100.96438 35,000_cells + HCMEC D3_line      8000
      5411  195     C  A03 101.45964 35,000_cells + HCMEC D3_line      8000
      5412  200     C  A03        NA 35,000_cells + HCMEC D3_line      8000
      5413    0     C  B01        NA 30,000_cells + HCMEC D3_line      1000
      5414    5     C  B01 117.54290 30,000_cells + HCMEC D3_line      1000
      5415   10     C  B01 116.79815 30,000_cells + HCMEC D3_line      1000
      5416   15     C  B01 115.36584 30,000_cells + HCMEC D3_line      1000
      5417   20     C  B01 114.58072 30,000_cells + HCMEC D3_line      1000
      5418   25     C  B01 114.61220 30,000_cells + HCMEC D3_line      1000
      5419   30     C  B01 114.39601 30,000_cells + HCMEC D3_line      1000
      5420   35     C  B01 115.13241 30,000_cells + HCMEC D3_line      1000
      5421   40     C  B01 115.92191 30,000_cells + HCMEC D3_line      1000
      5422   45     C  B01 116.47510 30,000_cells + HCMEC D3_line      1000
      5423   50     C  B01 117.06329 30,000_cells + HCMEC D3_line      1000
      5424   55     C  B01 118.02619 30,000_cells + HCMEC D3_line      1000
      5425   60     C  B01 118.59094 30,000_cells + HCMEC D3_line      1000
      5426   65     C  B01 119.00072 30,000_cells + HCMEC D3_line      1000
      5427   70     C  B01 119.39671 30,000_cells + HCMEC D3_line      1000
      5428   75     C  B01 119.82700 30,000_cells + HCMEC D3_line      1000
      5429   80     C  B01 120.20115 30,000_cells + HCMEC D3_line      1000
      5430   85     C  B01 120.44292 30,000_cells + HCMEC D3_line      1000
      5431   90     C  B01 120.65663 30,000_cells + HCMEC D3_line      1000
      5432   95     C  B01 121.08245 30,000_cells + HCMEC D3_line      1000
      5433  100     C  B01 121.32625 30,000_cells + HCMEC D3_line      1000
      5434  105     C  B01 121.67179 30,000_cells + HCMEC D3_line      1000
      5435  110     C  B01 121.86394 30,000_cells + HCMEC D3_line      1000
      5436  115     C  B01 122.10525 30,000_cells + HCMEC D3_line      1000
      5437  120     C  B01 122.25666 30,000_cells + HCMEC D3_line      1000
      5438  125     C  B01 122.48456 30,000_cells + HCMEC D3_line      1000
      5439  130     C  B01 122.76418 30,000_cells + HCMEC D3_line      1000
      5440  135     C  B01 122.96269 30,000_cells + HCMEC D3_line      1000
      5441  140     C  B01 123.17455 30,000_cells + HCMEC D3_line      1000
      5442  145     C  B01 123.38325 30,000_cells + HCMEC D3_line      1000
      5443  150     C  B01 123.56057 30,000_cells + HCMEC D3_line      1000
      5444  155     C  B01 123.70688 30,000_cells + HCMEC D3_line      1000
      5445  160     C  B01 123.84945 30,000_cells + HCMEC D3_line      1000
      5446  165     C  B01 124.05130 30,000_cells + HCMEC D3_line      1000
      5447  170     C  B01 124.19574 30,000_cells + HCMEC D3_line      1000
      5448  175     C  B01 124.31065 30,000_cells + HCMEC D3_line      1000
      5449  180     C  B01 124.44103 30,000_cells + HCMEC D3_line      1000
      5450  185     C  B01 124.52662 30,000_cells + HCMEC D3_line      1000
      5451  190     C  B01 124.53145 30,000_cells + HCMEC D3_line      1000
      5452  195     C  B01 124.77677 30,000_cells + HCMEC D3_line      1000
      5453  200     C  B01        NA 30,000_cells + HCMEC D3_line      1000
      5454    0     C  B01        NA 30,000_cells + HCMEC D3_line     16000
      5455    5     C  B01  81.27067 30,000_cells + HCMEC D3_line     16000
      5456   10     C  B01  72.21993 30,000_cells + HCMEC D3_line     16000
      5457   15     C  B01  61.57589 30,000_cells + HCMEC D3_line     16000
      5458   20     C  B01  53.25006 30,000_cells + HCMEC D3_line     16000
      5459   25     C  B01  49.44370 30,000_cells + HCMEC D3_line     16000
      5460   30     C  B01  46.70971 30,000_cells + HCMEC D3_line     16000
      5461   35     C  B01  44.66990 30,000_cells + HCMEC D3_line     16000
      5462   40     C  B01  42.94546 30,000_cells + HCMEC D3_line     16000
      5463   45     C  B01  42.24517 30,000_cells + HCMEC D3_line     16000
      5464   50     C  B01  41.52590 30,000_cells + HCMEC D3_line     16000
      5465   55     C  B01  41.80390 30,000_cells + HCMEC D3_line     16000
      5466   60     C  B01  41.75462 30,000_cells + HCMEC D3_line     16000
      5467   65     C  B01  41.85278 30,000_cells + HCMEC D3_line     16000
      5468   70     C  B01  42.01835 30,000_cells + HCMEC D3_line     16000
      5469   75     C  B01  43.02838 30,000_cells + HCMEC D3_line     16000
      5470   80     C  B01  43.83023 30,000_cells + HCMEC D3_line     16000
      5471   85     C  B01  44.51788 30,000_cells + HCMEC D3_line     16000
      5472   90     C  B01  45.33896 30,000_cells + HCMEC D3_line     16000
      5473   95     C  B01  46.91627 30,000_cells + HCMEC D3_line     16000
      5474  100     C  B01  48.30251 30,000_cells + HCMEC D3_line     16000
      5475  105     C  B01  49.80256 30,000_cells + HCMEC D3_line     16000
      5476  110     C  B01  51.14274 30,000_cells + HCMEC D3_line     16000
      5477  115     C  B01  52.35430 30,000_cells + HCMEC D3_line     16000
      5478  120     C  B01  53.99063 30,000_cells + HCMEC D3_line     16000
      5479  125     C  B01  55.30927 30,000_cells + HCMEC D3_line     16000
      5480  130     C  B01  56.98105 30,000_cells + HCMEC D3_line     16000
      5481  135     C  B01  58.45023 30,000_cells + HCMEC D3_line     16000
      5482  140     C  B01  60.31004 30,000_cells + HCMEC D3_line     16000
      5483  145     C  B01  61.45394 30,000_cells + HCMEC D3_line     16000
      5484  150     C  B01  62.97597 30,000_cells + HCMEC D3_line     16000
      5485  155     C  B01  64.07074 30,000_cells + HCMEC D3_line     16000
      5486  160     C  B01  65.61948 30,000_cells + HCMEC D3_line     16000
      5487  165     C  B01  66.44798 30,000_cells + HCMEC D3_line     16000
      5488  170     C  B01  67.92289 30,000_cells + HCMEC D3_line     16000
      5489  175     C  B01  69.09320 30,000_cells + HCMEC D3_line     16000
      5490  180     C  B01  70.25572 30,000_cells + HCMEC D3_line     16000
      5491  185     C  B01  70.86503 30,000_cells + HCMEC D3_line     16000
      5492  190     C  B01  71.79569 30,000_cells + HCMEC D3_line     16000
      5493  195     C  B01  73.13324 30,000_cells + HCMEC D3_line     16000
      5494  200     C  B01        NA 30,000_cells + HCMEC D3_line     16000
      5495    0     C  B01        NA 30,000_cells + HCMEC D3_line      2000
      5496    5     C  B01 112.93538 30,000_cells + HCMEC D3_line      2000
      5497   10     C  B01 110.37727 30,000_cells + HCMEC D3_line      2000
      5498   15     C  B01 106.81961 30,000_cells + HCMEC D3_line      2000
      5499   20     C  B01 104.46948 30,000_cells + HCMEC D3_line      2000
      5500   25     C  B01 104.08814 30,000_cells + HCMEC D3_line      2000
      5501   30     C  B01 103.30537 30,000_cells + HCMEC D3_line      2000
      5502   35     C  B01 104.18678 30,000_cells + HCMEC D3_line      2000
      5503   40     C  B01 105.30648 30,000_cells + HCMEC D3_line      2000
      5504   45     C  B01 106.23578 30,000_cells + HCMEC D3_line      2000
      5505   50     C  B01 107.29446 30,000_cells + HCMEC D3_line      2000
      5506   55     C  B01 108.85304 30,000_cells + HCMEC D3_line      2000
      5507   60     C  B01 109.73863 30,000_cells + HCMEC D3_line      2000
      5508   65     C  B01 110.32887 30,000_cells + HCMEC D3_line      2000
      5509   70     C  B01 110.93131 30,000_cells + HCMEC D3_line      2000
      5510   75     C  B01 111.59406 30,000_cells + HCMEC D3_line      2000
      5511   80     C  B01 112.21878 30,000_cells + HCMEC D3_line      2000
      5512   85     C  B01 112.48611 30,000_cells + HCMEC D3_line      2000
      5513   90     C  B01 112.81928 30,000_cells + HCMEC D3_line      2000
      5514   95     C  B01 113.53950 30,000_cells + HCMEC D3_line      2000
      5515  100     C  B01 114.01858 30,000_cells + HCMEC D3_line      2000
      5516  105     C  B01 114.68221 30,000_cells + HCMEC D3_line      2000
      5517  110     C  B01 115.07326 30,000_cells + HCMEC D3_line      2000
      5518  115     C  B01 115.55084 30,000_cells + HCMEC D3_line      2000
      5519  120     C  B01 115.87205 30,000_cells + HCMEC D3_line      2000
      5520  125     C  B01 116.32933 30,000_cells + HCMEC D3_line      2000
      5521  130     C  B01 116.95697 30,000_cells + HCMEC D3_line      2000
      5522  135     C  B01 117.33526 30,000_cells + HCMEC D3_line      2000
      5523  140     C  B01 117.83357 30,000_cells + HCMEC D3_line      2000
      5524  145     C  B01 118.24966 30,000_cells + HCMEC D3_line      2000
      5525  150     C  B01 118.63917 30,000_cells + HCMEC D3_line      2000
      5526  155     C  B01 118.93155 30,000_cells + HCMEC D3_line      2000
      5527  160     C  B01 119.29283 30,000_cells + HCMEC D3_line      2000
      5528  165     C  B01 119.66633 30,000_cells + HCMEC D3_line      2000
      5529  170     C  B01 119.98834 30,000_cells + HCMEC D3_line      2000
      5530  175     C  B01 120.27683 30,000_cells + HCMEC D3_line      2000
      5531  180     C  B01 120.57430 30,000_cells + HCMEC D3_line      2000
      5532  185     C  B01 120.70647 30,000_cells + HCMEC D3_line      2000
      5533  190     C  B01 120.73580 30,000_cells + HCMEC D3_line      2000
      5534  195     C  B01 121.37053 30,000_cells + HCMEC D3_line      2000
      5535  200     C  B01        NA 30,000_cells + HCMEC D3_line      2000
      5536    0     C  B01        NA 30,000_cells + HCMEC D3_line       250
      5537    5     C  B01 122.92621 30,000_cells + HCMEC D3_line       250
      5538   10     C  B01 122.76626 30,000_cells + HCMEC D3_line       250
      5539   15     C  B01 122.52724 30,000_cells + HCMEC D3_line       250
      5540   20     C  B01 122.50440 30,000_cells + HCMEC D3_line       250
      5541   25     C  B01 122.63964 30,000_cells + HCMEC D3_line       250
      5542   30     C  B01 122.81762 30,000_cells + HCMEC D3_line       250
      5543   35     C  B01 123.13115 30,000_cells + HCMEC D3_line       250
      5544   40     C  B01 123.47385 30,000_cells + HCMEC D3_line       250
      5545   45     C  B01 123.78157 30,000_cells + HCMEC D3_line       250
      5546   50     C  B01 124.08147 30,000_cells + HCMEC D3_line       250
      5547   55     C  B01 124.48482 30,000_cells + HCMEC D3_line       250
      5548   60     C  B01 124.77788 30,000_cells + HCMEC D3_line       250
      5549   65     C  B01 125.06043 30,000_cells + HCMEC D3_line       250
      5550   70     C  B01 125.29284 30,000_cells + HCMEC D3_line       250
      5551   75     C  B01 125.51337 30,000_cells + HCMEC D3_line       250
      5552   80     C  B01 125.71507 30,000_cells + HCMEC D3_line       250
      5553   85     C  B01 125.88991 30,000_cells + HCMEC D3_line       250
      5554   90     C  B01 126.05122 30,000_cells + HCMEC D3_line       250
      5555   95     C  B01 126.21316 30,000_cells + HCMEC D3_line       250
      5556  100     C  B01 126.35972 30,000_cells + HCMEC D3_line       250
      5557  105     C  B01 126.50818 30,000_cells + HCMEC D3_line       250
      5558  110     C  B01 126.63376 30,000_cells + HCMEC D3_line       250
      5559  115     C  B01 126.74028 30,000_cells + HCMEC D3_line       250
      5560  120     C  B01 126.86145 30,000_cells + HCMEC D3_line       250
      5561  125     C  B01 126.96298 30,000_cells + HCMEC D3_line       250
      5562  130     C  B01 127.07269 30,000_cells + HCMEC D3_line       250
      5563  135     C  B01 127.16388 30,000_cells + HCMEC D3_line       250
      5564  140     C  B01 127.25745 30,000_cells + HCMEC D3_line       250
      5565  145     C  B01 127.33480 30,000_cells + HCMEC D3_line       250
      5566  150     C  B01 127.41052 30,000_cells + HCMEC D3_line       250
      5567  155     C  B01 127.48070 30,000_cells + HCMEC D3_line       250
      5568  160     C  B01 127.54744 30,000_cells + HCMEC D3_line       250
      5569  165     C  B01 127.60799 30,000_cells + HCMEC D3_line       250
      5570  170     C  B01 127.67401 30,000_cells + HCMEC D3_line       250
      5571  175     C  B01 127.73103 30,000_cells + HCMEC D3_line       250
      5572  180     C  B01 127.77204 30,000_cells + HCMEC D3_line       250
      5573  185     C  B01 127.81833 30,000_cells + HCMEC D3_line       250
      5574  190     C  B01 127.83806 30,000_cells + HCMEC D3_line       250
      5575  195     C  B01 127.87835 30,000_cells + HCMEC D3_line       250
      5576  200     C  B01        NA 30,000_cells + HCMEC D3_line       250
      5577    0     C  B01        NA 30,000_cells + HCMEC D3_line     32000
      5578    5     C  B01  68.10479 30,000_cells + HCMEC D3_line     32000
      5579   10     C  B01  59.05755 30,000_cells + HCMEC D3_line     32000
      5580   15     C  B01  48.37903 30,000_cells + HCMEC D3_line     32000
      5581   20     C  B01  39.81400 30,000_cells + HCMEC D3_line     32000
      5582   25     C  B01  35.40265 30,000_cells + HCMEC D3_line     32000
      5583   30     C  B01  32.49471 30,000_cells + HCMEC D3_line     32000
      5584   35     C  B01  29.72440 30,000_cells + HCMEC D3_line     32000
      5585   40     C  B01  26.82444 30,000_cells + HCMEC D3_line     32000
      5586   45     C  B01  24.91821 30,000_cells + HCMEC D3_line     32000
      5587   50     C  B01  22.87659 30,000_cells + HCMEC D3_line     32000
      5588   55     C  B01  21.88296 30,000_cells + HCMEC D3_line     32000
      5589   60     C  B01  21.40196 30,000_cells + HCMEC D3_line     32000
      5590   65     C  B01  21.23562 30,000_cells + HCMEC D3_line     32000
      5591   70     C  B01  21.08434 30,000_cells + HCMEC D3_line     32000
      5592   75     C  B01  21.62195 30,000_cells + HCMEC D3_line     32000
      5593   80     C  B01  22.03187 30,000_cells + HCMEC D3_line     32000
      5594   85     C  B01  22.53590 30,000_cells + HCMEC D3_line     32000
      5595   90     C  B01  23.02692 30,000_cells + HCMEC D3_line     32000
      5596   95     C  B01  23.97082 30,000_cells + HCMEC D3_line     32000
      5597  100     C  B01  24.88441 30,000_cells + HCMEC D3_line     32000
      5598  105     C  B01  25.89797 30,000_cells + HCMEC D3_line     32000
      5599  110     C  B01  26.73949 30,000_cells + HCMEC D3_line     32000
      5600  115     C  B01  27.50220 30,000_cells + HCMEC D3_line     32000
      5601  120     C  B01  28.79101 30,000_cells + HCMEC D3_line     32000
      5602  125     C  B01  29.63141 30,000_cells + HCMEC D3_line     32000
      5603  130     C  B01  30.93027 30,000_cells + HCMEC D3_line     32000
      5604  135     C  B01  32.10033 30,000_cells + HCMEC D3_line     32000
      5605  140     C  B01  33.53916 30,000_cells + HCMEC D3_line     32000
      5606  145     C  B01  34.46034 30,000_cells + HCMEC D3_line     32000
      5607  150     C  B01  35.68331 30,000_cells + HCMEC D3_line     32000
      5608  155     C  B01  36.85431 30,000_cells + HCMEC D3_line     32000
      5609  160     C  B01  38.02985 30,000_cells + HCMEC D3_line     32000
      5610  165     C  B01  39.10294 30,000_cells + HCMEC D3_line     32000
      5611  170     C  B01  40.34969 30,000_cells + HCMEC D3_line     32000
      5612  175     C  B01  41.42341 30,000_cells + HCMEC D3_line     32000
      5613  180     C  B01  42.49538 30,000_cells + HCMEC D3_line     32000
      5614  185     C  B01  43.35686 30,000_cells + HCMEC D3_line     32000
      5615  190     C  B01  44.52726 30,000_cells + HCMEC D3_line     32000
      5616  195     C  B01  45.77613 30,000_cells + HCMEC D3_line     32000
      5617  200     C  B01        NA 30,000_cells + HCMEC D3_line     32000
      5618    0     C  B01        NA 30,000_cells + HCMEC D3_line      4000
      5619    5     C  B01 105.03710 30,000_cells + HCMEC D3_line      4000
      5620   10     C  B01  99.91225 30,000_cells + HCMEC D3_line      4000
      5621   15     C  B01  93.58549 30,000_cells + HCMEC D3_line      4000
      5622   20     C  B01  89.11487 30,000_cells + HCMEC D3_line      4000
      5623   25     C  B01  87.91499 30,000_cells + HCMEC D3_line      4000
      5624   30     C  B01  86.51154 30,000_cells + HCMEC D3_line      4000
      5625   35     C  B01  87.02628 30,000_cells + HCMEC D3_line      4000
      5626   40     C  B01  87.94797 30,000_cells + HCMEC D3_line      4000
      5627   45     C  B01  89.12589 30,000_cells + HCMEC D3_line      4000
      5628   50     C  B01  90.53797 30,000_cells + HCMEC D3_line      4000
      5629   55     C  B01  92.65245 30,000_cells + HCMEC D3_line      4000
      5630   60     C  B01  93.79222 30,000_cells + HCMEC D3_line      4000
      5631   65     C  B01  94.57155 30,000_cells + HCMEC D3_line      4000
      5632   70     C  B01  95.41775 30,000_cells + HCMEC D3_line      4000
      5633   75     C  B01  96.43280 30,000_cells + HCMEC D3_line      4000
      5634   80     C  B01  97.37613 30,000_cells + HCMEC D3_line      4000
      5635   85     C  B01  97.76983 30,000_cells + HCMEC D3_line      4000
      5636   90     C  B01  98.34988 30,000_cells + HCMEC D3_line      4000
      5637   95     C  B01  99.55877 30,000_cells + HCMEC D3_line      4000
      5638  100     C  B01 100.39547 30,000_cells + HCMEC D3_line      4000
      5639  105     C  B01 101.39487 30,000_cells + HCMEC D3_line      4000
      5640  110     C  B01 102.14520 30,000_cells + HCMEC D3_line      4000
      5641  115     C  B01 102.98897 30,000_cells + HCMEC D3_line      4000
      5642  120     C  B01 103.60136 30,000_cells + HCMEC D3_line      4000
      5643  125     C  B01 104.37832 30,000_cells + HCMEC D3_line      4000
      5644  130     C  B01 105.44195 30,000_cells + HCMEC D3_line      4000
      5645  135     C  B01 106.08532 30,000_cells + HCMEC D3_line      4000
      5646  140     C  B01 107.02358 30,000_cells + HCMEC D3_line      4000
      5647  145     C  B01 107.65791 30,000_cells + HCMEC D3_line      4000
      5648  150     C  B01 108.38693 30,000_cells + HCMEC D3_line      4000
      5649  155     C  B01 108.85832 30,000_cells + HCMEC D3_line      4000
      5650  160     C  B01 109.59882 30,000_cells + HCMEC D3_line      4000
      5651  165     C  B01 110.02386 30,000_cells + HCMEC D3_line      4000
      5652  170     C  B01 110.67251 30,000_cells + HCMEC D3_line      4000
      5653  175     C  B01 111.21310 30,000_cells + HCMEC D3_line      4000
      5654  180     C  B01 111.75750 30,000_cells + HCMEC D3_line      4000
      5655  185     C  B01 111.90350 30,000_cells + HCMEC D3_line      4000
      5656  190     C  B01 112.06645 30,000_cells + HCMEC D3_line      4000
      5657  195     C  B01 113.10230 30,000_cells + HCMEC D3_line      4000
      5658  200     C  B01        NA 30,000_cells + HCMEC D3_line      4000
      5659    0     C  B01        NA 30,000_cells + HCMEC D3_line       500
      5660    5     C  B01 120.67470 30,000_cells + HCMEC D3_line       500
      5661   10     C  B01 120.48803 30,000_cells + HCMEC D3_line       500
      5662   15     C  B01 119.97435 30,000_cells + HCMEC D3_line       500
      5663   20     C  B01 119.81917 30,000_cells + HCMEC D3_line       500
      5664   25     C  B01 119.94553 30,000_cells + HCMEC D3_line       500
      5665   30     C  B01 120.01888 30,000_cells + HCMEC D3_line       500
      5666   35     C  B01 120.49391 30,000_cells + HCMEC D3_line       500
      5667   40     C  B01 120.99860 30,000_cells + HCMEC D3_line       500
      5668   45     C  B01 121.38750 30,000_cells + HCMEC D3_line       500
      5669   50     C  B01 121.74373 30,000_cells + HCMEC D3_line       500
      5670   55     C  B01 122.34100 30,000_cells + HCMEC D3_line       500
      5671   60     C  B01 122.70733 30,000_cells + HCMEC D3_line       500
      5672   65     C  B01 123.01291 30,000_cells + HCMEC D3_line       500
      5673   70     C  B01 123.30379 30,000_cells + HCMEC D3_line       500
      5674   75     C  B01 123.58235 30,000_cells + HCMEC D3_line       500
      5675   80     C  B01 123.82390 30,000_cells + HCMEC D3_line       500
      5676   85     C  B01 124.02396 30,000_cells + HCMEC D3_line       500
      5677   90     C  B01 124.18898 30,000_cells + HCMEC D3_line       500
      5678   95     C  B01 124.43173 30,000_cells + HCMEC D3_line       500
      5679  100     C  B01 124.58936 30,000_cells + HCMEC D3_line       500
      5680  105     C  B01 124.79657 30,000_cells + HCMEC D3_line       500
      5681  110     C  B01 124.94231 30,000_cells + HCMEC D3_line       500
      5682  115     C  B01 125.07760 30,000_cells + HCMEC D3_line       500
      5683  120     C  B01 125.19242 30,000_cells + HCMEC D3_line       500
      5684  125     C  B01 125.33784 30,000_cells + HCMEC D3_line       500
      5685  130     C  B01 125.48229 30,000_cells + HCMEC D3_line       500
      5686  135     C  B01 125.60354 30,000_cells + HCMEC D3_line       500
      5687  140     C  B01 125.71269 30,000_cells + HCMEC D3_line       500
      5688  145     C  B01 125.83043 30,000_cells + HCMEC D3_line       500
      5689  150     C  B01 125.92773 30,000_cells + HCMEC D3_line       500
      5690  155     C  B01 126.01859 30,000_cells + HCMEC D3_line       500
      5691  160     C  B01 126.10138 30,000_cells + HCMEC D3_line       500
      5692  165     C  B01 126.20222 30,000_cells + HCMEC D3_line       500
      5693  170     C  B01 126.27718 30,000_cells + HCMEC D3_line       500
      5694  175     C  B01 126.34943 30,000_cells + HCMEC D3_line       500
      5695  180     C  B01 126.41298 30,000_cells + HCMEC D3_line       500
      5696  185     C  B01 126.46242 30,000_cells + HCMEC D3_line       500
      5697  190     C  B01 126.47328 30,000_cells + HCMEC D3_line       500
      5698  195     C  B01 126.57265 30,000_cells + HCMEC D3_line       500
      5699  200     C  B01        NA 30,000_cells + HCMEC D3_line       500
      5700    0     C  B01        NA 30,000_cells + HCMEC D3_line     64000
      5701    5     C  B01  50.99575 30,000_cells + HCMEC D3_line     64000
      5702   10     C  B01  44.00106 30,000_cells + HCMEC D3_line     64000
      5703   15     C  B01  35.52260 30,000_cells + HCMEC D3_line     64000
      5704   20     C  B01  28.61250 30,000_cells + HCMEC D3_line     64000
      5705   25     C  B01  24.75430 30,000_cells + HCMEC D3_line     64000
      5706   30     C  B01  22.25422 30,000_cells + HCMEC D3_line     64000
      5707   35     C  B01  19.70160 30,000_cells + HCMEC D3_line     64000
      5708   40     C  B01  16.68797 30,000_cells + HCMEC D3_line     64000
      5709   45     C  B01  14.50212 30,000_cells + HCMEC D3_line     64000
      5710   50     C  B01  12.37032 30,000_cells + HCMEC D3_line     64000
      5711   55     C  B01  11.28086 30,000_cells + HCMEC D3_line     64000
      5712   60     C  B01  10.95535 30,000_cells + HCMEC D3_line     64000
      5713   65     C  B01  10.83580 30,000_cells + HCMEC D3_line     64000
      5714   70     C  B01  10.72190 30,000_cells + HCMEC D3_line     64000
      5715   75     C  B01  10.94472 30,000_cells + HCMEC D3_line     64000
      5716   80     C  B01  11.13164 30,000_cells + HCMEC D3_line     64000
      5717   85     C  B01  11.38451 30,000_cells + HCMEC D3_line     64000
      5718   90     C  B01  11.58116 30,000_cells + HCMEC D3_line     64000
      5719   95     C  B01  11.99450 30,000_cells + HCMEC D3_line     64000
      5720  100     C  B01  12.38907 30,000_cells + HCMEC D3_line     64000
      5721  105     C  B01  12.85270 30,000_cells + HCMEC D3_line     64000
      5722  110     C  B01  13.17532 30,000_cells + HCMEC D3_line     64000
      5723  115     C  B01  13.47836 30,000_cells + HCMEC D3_line     64000
      5724  120     C  B01  14.12629 30,000_cells + HCMEC D3_line     64000
      5725  125     C  B01  14.44490 30,000_cells + HCMEC D3_line     64000
      5726  130     C  B01  15.11421 30,000_cells + HCMEC D3_line     64000
      5727  135     C  B01  15.69989 30,000_cells + HCMEC D3_line     64000
      5728  140     C  B01  16.39639 30,000_cells + HCMEC D3_line     64000
      5729  145     C  B01  16.83870 30,000_cells + HCMEC D3_line     64000
      5730  150     C  B01  17.42208 30,000_cells + HCMEC D3_line     64000
      5731  155     C  B01  18.19860 30,000_cells + HCMEC D3_line     64000
      5732  160     C  B01  18.69089 30,000_cells + HCMEC D3_line     64000
      5733  165     C  B01  19.41012 30,000_cells + HCMEC D3_line     64000
      5734  170     C  B01  20.03165 30,000_cells + HCMEC D3_line     64000
      5735  175     C  B01  20.68211 30,000_cells + HCMEC D3_line     64000
      5736  180     C  B01  21.30670 30,000_cells + HCMEC D3_line     64000
      5737  185     C  B01  21.97114 30,000_cells + HCMEC D3_line     64000
      5738  190     C  B01  22.80789 30,000_cells + HCMEC D3_line     64000
      5739  195     C  B01  23.64469 30,000_cells + HCMEC D3_line     64000
      5740  200     C  B01        NA 30,000_cells + HCMEC D3_line     64000
      5741    0     C  B01        NA 30,000_cells + HCMEC D3_line      8000
      5742    5     C  B01  93.43615 30,000_cells + HCMEC D3_line      8000
      5743   10     C  B01  85.89770 30,000_cells + HCMEC D3_line      8000
      5744   15     C  B01  77.02715 30,000_cells + HCMEC D3_line      8000
      5745   20     C  B01  70.42620 30,000_cells + HCMEC D3_line      8000
      5746   25     C  B01  67.92036 30,000_cells + HCMEC D3_line      8000
      5747   30     C  B01  65.76566 30,000_cells + HCMEC D3_line      8000
      5748   35     C  B01  65.05019 30,000_cells + HCMEC D3_line      8000
      5749   40     C  B01  64.92353 30,000_cells + HCMEC D3_line      8000
      5750   45     C  B01  65.64441 30,000_cells + HCMEC D3_line      8000
      5751   50     C  B01  66.58110 30,000_cells + HCMEC D3_line      8000
      5752   55     C  B01  68.42634 30,000_cells + HCMEC D3_line      8000
      5753   60     C  B01  69.22465 30,000_cells + HCMEC D3_line      8000
      5754   65     C  B01  69.84391 30,000_cells + HCMEC D3_line      8000
      5755   70     C  B01  70.58099 30,000_cells + HCMEC D3_line      8000
      5756   75     C  B01  71.79536 30,000_cells + HCMEC D3_line      8000
      5757   80     C  B01  72.86314 30,000_cells + HCMEC D3_line      8000
      5758   85     C  B01  73.41820 30,000_cells + HCMEC D3_line      8000
      5759   90     C  B01  74.26198 30,000_cells + HCMEC D3_line      8000
      5760   95     C  B01  75.86224 30,000_cells + HCMEC D3_line      8000
      5761  100     C  B01  77.16812 30,000_cells + HCMEC D3_line      8000
      5762  105     C  B01  78.57707 30,000_cells + HCMEC D3_line      8000
      5763  110     C  B01  79.79585 30,000_cells + HCMEC D3_line      8000
      5764  115     C  B01  81.00216 30,000_cells + HCMEC D3_line      8000
      5765  120     C  B01  82.20338 30,000_cells + HCMEC D3_line      8000
      5766  125     C  B01  83.39091 30,000_cells + HCMEC D3_line      8000
      5767  130     C  B01  84.86661 30,000_cells + HCMEC D3_line      8000
      5768  135     C  B01  85.99026 30,000_cells + HCMEC D3_line      8000
      5769  140     C  B01  87.51107 30,000_cells + HCMEC D3_line      8000
      5770  145     C  B01  88.44016 30,000_cells + HCMEC D3_line      8000
      5771  150     C  B01  89.61944 30,000_cells + HCMEC D3_line      8000
      5772  155     C  B01  90.40139 30,000_cells + HCMEC D3_line      8000
      5773  160     C  B01  91.64503 30,000_cells + HCMEC D3_line      8000
      5774  165     C  B01  92.17553 30,000_cells + HCMEC D3_line      8000
      5775  170     C  B01  93.26799 30,000_cells + HCMEC D3_line      8000
      5776  175     C  B01  94.12870 30,000_cells + HCMEC D3_line      8000
      5777  180     C  B01  94.98037 30,000_cells + HCMEC D3_line      8000
      5778  185     C  B01  95.23503 30,000_cells + HCMEC D3_line      8000
      5779  190     C  B01  95.68340 30,000_cells + HCMEC D3_line      8000
      5780  195     C  B01  96.91540 30,000_cells + HCMEC D3_line      8000
      5781  200     C  B01        NA 30,000_cells + HCMEC D3_line      8000
      5782    0     C  B02        NA 30,000_cells + HCMEC D3_line      1000
      5783    5     C  B02 117.47402 30,000_cells + HCMEC D3_line      1000
      5784   10     C  B02 116.10632 30,000_cells + HCMEC D3_line      1000
      5785   15     C  B02 114.94367 30,000_cells + HCMEC D3_line      1000
      5786   20     C  B02 114.30128 30,000_cells + HCMEC D3_line      1000
      5787   25     C  B02 114.08017 30,000_cells + HCMEC D3_line      1000
      5788   30     C  B02 114.26361 30,000_cells + HCMEC D3_line      1000
      5789   35     C  B02 114.92020 30,000_cells + HCMEC D3_line      1000
      5790   40     C  B02 115.32646 30,000_cells + HCMEC D3_line      1000
      5791   45     C  B02 115.99526 30,000_cells + HCMEC D3_line      1000
      5792   50     C  B02 116.74503 30,000_cells + HCMEC D3_line      1000
      5793   55     C  B02 117.28254 30,000_cells + HCMEC D3_line      1000
      5794   60     C  B02 117.73159 30,000_cells + HCMEC D3_line      1000
      5795   65     C  B02 118.30824 30,000_cells + HCMEC D3_line      1000
      5796   70     C  B02 118.85804 30,000_cells + HCMEC D3_line      1000
      5797   75     C  B02 119.23800 30,000_cells + HCMEC D3_line      1000
      5798   80     C  B02 119.48925 30,000_cells + HCMEC D3_line      1000
      5799   85     C  B02 119.76450 30,000_cells + HCMEC D3_line      1000
      5800   90     C  B02 120.10211 30,000_cells + HCMEC D3_line      1000
      5801   95     C  B02 120.45556 30,000_cells + HCMEC D3_line      1000
      5802  100     C  B02 120.66056 30,000_cells + HCMEC D3_line      1000
      5803  105     C  B02 120.98517 30,000_cells + HCMEC D3_line      1000
      5804  110     C  B02 121.26692 30,000_cells + HCMEC D3_line      1000
      5805  115     C  B02 121.60483 30,000_cells + HCMEC D3_line      1000
      5806  120     C  B02 121.81981 30,000_cells + HCMEC D3_line      1000
      5807  125     C  B02 122.11203 30,000_cells + HCMEC D3_line      1000
      5808  130     C  B02 122.28230 30,000_cells + HCMEC D3_line      1000
      5809  135     C  B02 122.55841 30,000_cells + HCMEC D3_line      1000
      5810  140     C  B02 122.72418 30,000_cells + HCMEC D3_line      1000
      5811  145     C  B02 122.82403 30,000_cells + HCMEC D3_line      1000
      5812  150     C  B02 122.99982 30,000_cells + HCMEC D3_line      1000
      5813  155     C  B02 123.19941 30,000_cells + HCMEC D3_line      1000
      5814  160     C  B02 123.42439 30,000_cells + HCMEC D3_line      1000
      5815  165     C  B02 123.55243 30,000_cells + HCMEC D3_line      1000
      5816  170     C  B02 123.65859 30,000_cells + HCMEC D3_line      1000
      5817  175     C  B02 123.88553 30,000_cells + HCMEC D3_line      1000
      5818  180     C  B02 124.05062 30,000_cells + HCMEC D3_line      1000
      5819  185     C  B02 124.16525 30,000_cells + HCMEC D3_line      1000
      5820  190     C  B02 124.21811 30,000_cells + HCMEC D3_line      1000
      5821  195     C  B02 124.35682 30,000_cells + HCMEC D3_line      1000
      5822  200     C  B02        NA 30,000_cells + HCMEC D3_line      1000
      5823    0     C  B02        NA 30,000_cells + HCMEC D3_line     16000
      5824    5     C  B02  80.06229 30,000_cells + HCMEC D3_line     16000
      5825   10     C  B02  69.84090 30,000_cells + HCMEC D3_line     16000
      5826   15     C  B02  60.06885 30,000_cells + HCMEC D3_line     16000
      5827   20     C  B02  52.64781 30,000_cells + HCMEC D3_line     16000
      5828   25     C  B02  48.49555 30,000_cells + HCMEC D3_line     16000
      5829   30     C  B02  45.88667 30,000_cells + HCMEC D3_line     16000
      5830   35     C  B02  44.51907 30,000_cells + HCMEC D3_line     16000
      5831   40     C  B02  42.66947 30,000_cells + HCMEC D3_line     16000
      5832   45     C  B02  41.49089 30,000_cells + HCMEC D3_line     16000
      5833   50     C  B02  41.06238 30,000_cells + HCMEC D3_line     16000
      5834   55     C  B02  40.95837 30,000_cells + HCMEC D3_line     16000
      5835   60     C  B02  40.84921 30,000_cells + HCMEC D3_line     16000
      5836   65     C  B02  41.23168 30,000_cells + HCMEC D3_line     16000
      5837   70     C  B02  41.77300 30,000_cells + HCMEC D3_line     16000
      5838   75     C  B02  42.14170 30,000_cells + HCMEC D3_line     16000
      5839   80     C  B02  42.87633 30,000_cells + HCMEC D3_line     16000
      5840   85     C  B02  43.57907 30,000_cells + HCMEC D3_line     16000
      5841   90     C  B02  44.66039 30,000_cells + HCMEC D3_line     16000
      5842   95     C  B02  46.20447 30,000_cells + HCMEC D3_line     16000
      5843  100     C  B02  47.32932 30,000_cells + HCMEC D3_line     16000
      5844  105     C  B02  48.70496 30,000_cells + HCMEC D3_line     16000
      5845  110     C  B02  50.08650 30,000_cells + HCMEC D3_line     16000
      5846  115     C  B02  52.01101 30,000_cells + HCMEC D3_line     16000
      5847  120     C  B02  53.15940 30,000_cells + HCMEC D3_line     16000
      5848  125     C  B02  54.65538 30,000_cells + HCMEC D3_line     16000
      5849  130     C  B02  56.10970 30,000_cells + HCMEC D3_line     16000
      5850  135     C  B02  57.62970 30,000_cells + HCMEC D3_line     16000
      5851  140     C  B02  58.68389 30,000_cells + HCMEC D3_line     16000
      5852  145     C  B02  59.81006 30,000_cells + HCMEC D3_line     16000
      5853  150     C  B02  61.08287 30,000_cells + HCMEC D3_line     16000
      5854  155     C  B02  62.56250 30,000_cells + HCMEC D3_line     16000
      5855  160     C  B02  64.09558 30,000_cells + HCMEC D3_line     16000
      5856  165     C  B02  65.13902 30,000_cells + HCMEC D3_line     16000
      5857  170     C  B02  66.28805 30,000_cells + HCMEC D3_line     16000
      5858  175     C  B02  67.52638 30,000_cells + HCMEC D3_line     16000
      5859  180     C  B02  68.77816 30,000_cells + HCMEC D3_line     16000
      5860  185     C  B02  69.74866 30,000_cells + HCMEC D3_line     16000
      5861  190     C  B02  70.50923 30,000_cells + HCMEC D3_line     16000
      5862  195     C  B02  72.01058 30,000_cells + HCMEC D3_line     16000
      5863  200     C  B02        NA 30,000_cells + HCMEC D3_line     16000
      5864    0     C  B02        NA 30,000_cells + HCMEC D3_line      2000
      5865    5     C  B02 112.31892 30,000_cells + HCMEC D3_line      2000
      5866   10     C  B02 108.88187 30,000_cells + HCMEC D3_line      2000
      5867   15     C  B02 105.72906 30,000_cells + HCMEC D3_line      2000
      5868   20     C  B02 103.75585 30,000_cells + HCMEC D3_line      2000
      5869   25     C  B02 103.04244 30,000_cells + HCMEC D3_line      2000
      5870   30     C  B02 102.96848 30,000_cells + HCMEC D3_line      2000
      5871   35     C  B02 103.73518 30,000_cells + HCMEC D3_line      2000
      5872   40     C  B02 104.32372 30,000_cells + HCMEC D3_line      2000
      5873   45     C  B02 105.39708 30,000_cells + HCMEC D3_line      2000
      5874   50     C  B02 106.69766 30,000_cells + HCMEC D3_line      2000
      5875   55     C  B02 107.89938 30,000_cells + HCMEC D3_line      2000
      5876   60     C  B02 108.54850 30,000_cells + HCMEC D3_line      2000
      5877   65     C  B02 109.40549 30,000_cells + HCMEC D3_line      2000
      5878   70     C  B02 110.31369 30,000_cells + HCMEC D3_line      2000
      5879   75     C  B02 110.81746 30,000_cells + HCMEC D3_line      2000
      5880   80     C  B02 111.16454 30,000_cells + HCMEC D3_line      2000
      5881   85     C  B02 111.58955 30,000_cells + HCMEC D3_line      2000
      5882   90     C  B02 112.09651 30,000_cells + HCMEC D3_line      2000
      5883   95     C  B02 112.74520 30,000_cells + HCMEC D3_line      2000
      5884  100     C  B02 113.07072 30,000_cells + HCMEC D3_line      2000
      5885  105     C  B02 113.65552 30,000_cells + HCMEC D3_line      2000
      5886  110     C  B02 114.20890 30,000_cells + HCMEC D3_line      2000
      5887  115     C  B02 114.85604 30,000_cells + HCMEC D3_line      2000
      5888  120     C  B02 115.28604 30,000_cells + HCMEC D3_line      2000
      5889  125     C  B02 115.89235 30,000_cells + HCMEC D3_line      2000
      5890  130     C  B02 116.24667 30,000_cells + HCMEC D3_line      2000
      5891  135     C  B02 116.79226 30,000_cells + HCMEC D3_line      2000
      5892  140     C  B02 117.12209 30,000_cells + HCMEC D3_line      2000
      5893  145     C  B02 117.30372 30,000_cells + HCMEC D3_line      2000
      5894  150     C  B02 117.67682 30,000_cells + HCMEC D3_line      2000
      5895  155     C  B02 118.09629 30,000_cells + HCMEC D3_line      2000
      5896  160     C  B02 118.58104 30,000_cells + HCMEC D3_line      2000
      5897  165     C  B02 118.85274 30,000_cells + HCMEC D3_line      2000
      5898  170     C  B02 119.09077 30,000_cells + HCMEC D3_line      2000
      5899  175     C  B02 119.60417 30,000_cells + HCMEC D3_line      2000
      5900  180     C  B02 119.98441 30,000_cells + HCMEC D3_line      2000
      5901  185     C  B02 120.26598 30,000_cells + HCMEC D3_line      2000
      5902  190     C  B02 120.35678 30,000_cells + HCMEC D3_line      2000
      5903  195     C  B02 120.74307 30,000_cells + HCMEC D3_line      2000
      5904  200     C  B02        NA 30,000_cells + HCMEC D3_line      2000
      5905    0     C  B02        NA 30,000_cells + HCMEC D3_line       250
      5906    5     C  B02 123.05728 30,000_cells + HCMEC D3_line       250
      5907   10     C  B02 122.69680 30,000_cells + HCMEC D3_line       250
      5908   15     C  B02 122.50832 30,000_cells + HCMEC D3_line       250
      5909   20     C  B02 122.48228 30,000_cells + HCMEC D3_line       250
      5910   25     C  B02 122.52821 30,000_cells + HCMEC D3_line       250
      5911   30     C  B02 122.69987 30,000_cells + HCMEC D3_line       250
      5912   35     C  B02 122.99361 30,000_cells + HCMEC D3_line       250
      5913   40     C  B02 123.25587 30,000_cells + HCMEC D3_line       250
      5914   45     C  B02 123.56828 30,000_cells + HCMEC D3_line       250
      5915   50     C  B02 123.90062 30,000_cells + HCMEC D3_line       250
      5916   55     C  B02 124.17365 30,000_cells + HCMEC D3_line       250
      5917   60     C  B02 124.44924 30,000_cells + HCMEC D3_line       250
      5918   65     C  B02 124.72991 30,000_cells + HCMEC D3_line       250
      5919   70     C  B02 124.96760 30,000_cells + HCMEC D3_line       250
      5920   75     C  B02 125.18186 30,000_cells + HCMEC D3_line       250
      5921   80     C  B02 125.37873 30,000_cells + HCMEC D3_line       250
      5922   85     C  B02 125.54236 30,000_cells + HCMEC D3_line       250
      5923   90     C  B02 125.70249 30,000_cells + HCMEC D3_line       250
      5924   95     C  B02 125.86357 30,000_cells + HCMEC D3_line       250
      5925  100     C  B02 125.98704 30,000_cells + HCMEC D3_line       250
      5926  105     C  B02 126.14537 30,000_cells + HCMEC D3_line       250
      5927  110     C  B02 126.26003 30,000_cells + HCMEC D3_line       250
      5928  115     C  B02 126.40137 30,000_cells + HCMEC D3_line       250
      5929  120     C  B02 126.50606 30,000_cells + HCMEC D3_line       250
      5930  125     C  B02 126.61381 30,000_cells + HCMEC D3_line       250
      5931  130     C  B02 126.70539 30,000_cells + HCMEC D3_line       250
      5932  135     C  B02 126.79912 30,000_cells + HCMEC D3_line       250
      5933  140     C  B02 126.89791 30,000_cells + HCMEC D3_line       250
      5934  145     C  B02 126.97963 30,000_cells + HCMEC D3_line       250
      5935  150     C  B02 127.05219 30,000_cells + HCMEC D3_line       250
      5936  155     C  B02 127.12423 30,000_cells + HCMEC D3_line       250
      5937  160     C  B02 127.20334 30,000_cells + HCMEC D3_line       250
      5938  165     C  B02 127.25932 30,000_cells + HCMEC D3_line       250
      5939  170     C  B02 127.31381 30,000_cells + HCMEC D3_line       250
      5940  175     C  B02 127.37480 30,000_cells + HCMEC D3_line       250
      5941  180     C  B02 127.41786 30,000_cells + HCMEC D3_line       250
      5942  185     C  B02 127.46520 30,000_cells + HCMEC D3_line       250
      5943  190     C  B02 127.49125 30,000_cells + HCMEC D3_line       250
      5944  195     C  B02 127.53207 30,000_cells + HCMEC D3_line       250
      5945  200     C  B02        NA 30,000_cells + HCMEC D3_line       250
      5946    0     C  B02        NA 30,000_cells + HCMEC D3_line     32000
      5947    5     C  B02  67.55532 30,000_cells + HCMEC D3_line     32000
      5948   10     C  B02  57.21802 30,000_cells + HCMEC D3_line     32000
      5949   15     C  B02  47.30611 30,000_cells + HCMEC D3_line     32000
      5950   20     C  B02  39.44140 30,000_cells + HCMEC D3_line     32000
      5951   25     C  B02  34.84962 30,000_cells + HCMEC D3_line     32000
      5952   30     C  B02  31.80778 30,000_cells + HCMEC D3_line     32000
      5953   35     C  B02  30.01293 30,000_cells + HCMEC D3_line     32000
      5954   40     C  B02  27.27705 30,000_cells + HCMEC D3_line     32000
      5955   45     C  B02  24.73291 30,000_cells + HCMEC D3_line     32000
      5956   50     C  B02  23.04561 30,000_cells + HCMEC D3_line     32000
      5957   55     C  B02  21.48129 30,000_cells + HCMEC D3_line     32000
      5958   60     C  B02  21.00990 30,000_cells + HCMEC D3_line     32000
      5959   65     C  B02  20.92781 30,000_cells + HCMEC D3_line     32000
      5960   70     C  B02  21.01736 30,000_cells + HCMEC D3_line     32000
      5961   75     C  B02  21.24698 30,000_cells + HCMEC D3_line     32000
      5962   80     C  B02  21.58623 30,000_cells + HCMEC D3_line     32000
      5963   85     C  B02  22.07037 30,000_cells + HCMEC D3_line     32000
      5964   90     C  B02  22.70925 30,000_cells + HCMEC D3_line     32000
      5965   95     C  B02  23.59014 30,000_cells + HCMEC D3_line     32000
      5966  100     C  B02  24.37185 30,000_cells + HCMEC D3_line     32000
      5967  105     C  B02  25.23160 30,000_cells + HCMEC D3_line     32000
      5968  110     C  B02  26.24986 30,000_cells + HCMEC D3_line     32000
      5969  115     C  B02  27.47367 30,000_cells + HCMEC D3_line     32000
      5970  120     C  B02  28.32166 30,000_cells + HCMEC D3_line     32000
      5971  125     C  B02  29.35130 30,000_cells + HCMEC D3_line     32000
      5972  130     C  B02  30.36844 30,000_cells + HCMEC D3_line     32000
      5973  135     C  B02  31.53843 30,000_cells + HCMEC D3_line     32000
      5974  140     C  B02  32.29792 30,000_cells + HCMEC D3_line     32000
      5975  145     C  B02  33.26104 30,000_cells + HCMEC D3_line     32000
      5976  150     C  B02  34.30746 30,000_cells + HCMEC D3_line     32000
      5977  155     C  B02  35.70953 30,000_cells + HCMEC D3_line     32000
      5978  160     C  B02  37.13792 30,000_cells + HCMEC D3_line     32000
      5979  165     C  B02  38.16006 30,000_cells + HCMEC D3_line     32000
      5980  170     C  B02  39.16546 30,000_cells + HCMEC D3_line     32000
      5981  175     C  B02  40.36439 30,000_cells + HCMEC D3_line     32000
      5982  180     C  B02  41.49671 30,000_cells + HCMEC D3_line     32000
      5983  185     C  B02  42.68877 30,000_cells + HCMEC D3_line     32000
      5984  190     C  B02  43.48051 30,000_cells + HCMEC D3_line     32000
      5985  195     C  B02  45.01531 30,000_cells + HCMEC D3_line     32000
      5986  200     C  B02        NA 30,000_cells + HCMEC D3_line     32000
      5987    0     C  B02        NA 30,000_cells + HCMEC D3_line      4000
      5988    5     C  B02 103.84050 30,000_cells + HCMEC D3_line      4000
      5989   10     C  B02  97.70354 30,000_cells + HCMEC D3_line      4000
      5990   15     C  B02  91.94278 30,000_cells + HCMEC D3_line      4000
      5991   20     C  B02  88.12983 30,000_cells + HCMEC D3_line      4000
      5992   25     C  B02  86.54613 30,000_cells + HCMEC D3_line      4000
      5993   30     C  B02  85.87049 30,000_cells + HCMEC D3_line      4000
      5994   35     C  B02  86.23973 30,000_cells + HCMEC D3_line      4000
      5995   40     C  B02  86.63220 30,000_cells + HCMEC D3_line      4000
      5996   45     C  B02  87.82641 30,000_cells + HCMEC D3_line      4000
      5997   50     C  B02  89.57362 30,000_cells + HCMEC D3_line      4000
      5998   55     C  B02  91.50867 30,000_cells + HCMEC D3_line      4000
      5999   60     C  B02  92.36282 30,000_cells + HCMEC D3_line      4000
      6000   65     C  B02  93.52595 30,000_cells + HCMEC D3_line      4000
      6001   70     C  B02  94.79713 30,000_cells + HCMEC D3_line      4000
      6002   75     C  B02  95.37840 30,000_cells + HCMEC D3_line      4000
      6003   80     C  B02  96.04762 30,000_cells + HCMEC D3_line      4000
      6004   85     C  B02  96.63924 30,000_cells + HCMEC D3_line      4000
      6005   90     C  B02  97.44475 30,000_cells + HCMEC D3_line      4000
      6006   95     C  B02  98.63133 30,000_cells + HCMEC D3_line      4000
      6007  100     C  B02  99.26099 30,000_cells + HCMEC D3_line      4000
      6008  105     C  B02 100.22743 30,000_cells + HCMEC D3_line      4000
      6009  110     C  B02 101.05796 30,000_cells + HCMEC D3_line      4000
      6010  115     C  B02 102.18536 30,000_cells + HCMEC D3_line      4000
      6011  120     C  B02 102.84041 30,000_cells + HCMEC D3_line      4000
      6012  125     C  B02 103.85152 30,000_cells + HCMEC D3_line      4000
      6013  130     C  B02 104.51374 30,000_cells + HCMEC D3_line      4000
      6014  135     C  B02 105.44425 30,000_cells + HCMEC D3_line      4000
      6015  140     C  B02 105.98672 30,000_cells + HCMEC D3_line      4000
      6016  145     C  B02 106.31824 30,000_cells + HCMEC D3_line      4000
      6017  150     C  B02 106.96581 30,000_cells + HCMEC D3_line      4000
      6018  155     C  B02 107.65736 30,000_cells + HCMEC D3_line      4000
      6019  160     C  B02 108.43197 30,000_cells + HCMEC D3_line      4000
      6020  165     C  B02 108.89594 30,000_cells + HCMEC D3_line      4000
      6021  170     C  B02 109.35669 30,000_cells + HCMEC D3_line      4000
      6022  175     C  B02 110.16567 30,000_cells + HCMEC D3_line      4000
      6023  180     C  B02 110.81711 30,000_cells + HCMEC D3_line      4000
      6024  185     C  B02 111.24954 30,000_cells + HCMEC D3_line      4000
      6025  190     C  B02 111.45218 30,000_cells + HCMEC D3_line      4000
      6026  195     C  B02 112.21073 30,000_cells + HCMEC D3_line      4000
      6027  200     C  B02        NA 30,000_cells + HCMEC D3_line      4000
      6028    0     C  B02        NA 30,000_cells + HCMEC D3_line       500
      6029    5     C  B02 120.79591 30,000_cells + HCMEC D3_line       500
      6030   10     C  B02 120.25906 30,000_cells + HCMEC D3_line       500
      6031   15     C  B02 119.89570 30,000_cells + HCMEC D3_line       500
      6032   20     C  B02 119.75623 30,000_cells + HCMEC D3_line       500
      6033   25     C  B02 119.72338 30,000_cells + HCMEC D3_line       500
      6034   30     C  B02 119.89460 30,000_cells + HCMEC D3_line       500
      6035   35     C  B02 120.33532 30,000_cells + HCMEC D3_line       500
      6036   40     C  B02 120.66019 30,000_cells + HCMEC D3_line       500
      6037   45     C  B02 121.09217 30,000_cells + HCMEC D3_line       500
      6038   50     C  B02 121.56059 30,000_cells + HCMEC D3_line       500
      6039   55     C  B02 121.87071 30,000_cells + HCMEC D3_line       500
      6040   60     C  B02 122.19154 30,000_cells + HCMEC D3_line       500
      6041   65     C  B02 122.57658 30,000_cells + HCMEC D3_line       500
      6042   70     C  B02 122.90059 30,000_cells + HCMEC D3_line       500
      6043   75     C  B02 123.17267 30,000_cells + HCMEC D3_line       500
      6044   80     C  B02 123.37846 30,000_cells + HCMEC D3_line       500
      6045   85     C  B02 123.56975 30,000_cells + HCMEC D3_line       500
      6046   90     C  B02 123.78845 30,000_cells + HCMEC D3_line       500
      6047   95     C  B02 123.98659 30,000_cells + HCMEC D3_line       500
      6048  100     C  B02 124.13743 30,000_cells + HCMEC D3_line       500
      6049  105     C  B02 124.33394 30,000_cells + HCMEC D3_line       500
      6050  110     C  B02 124.49623 30,000_cells + HCMEC D3_line       500
      6051  115     C  B02 124.69191 30,000_cells + HCMEC D3_line       500
      6052  120     C  B02 124.82652 30,000_cells + HCMEC D3_line       500
      6053  125     C  B02 124.97694 30,000_cells + HCMEC D3_line       500
      6054  130     C  B02 125.10419 30,000_cells + HCMEC D3_line       500
      6055  135     C  B02 125.24445 30,000_cells + HCMEC D3_line       500
      6056  140     C  B02 125.35330 30,000_cells + HCMEC D3_line       500
      6057  145     C  B02 125.42973 30,000_cells + HCMEC D3_line       500
      6058  150     C  B02 125.53517 30,000_cells + HCMEC D3_line       500
      6059  155     C  B02 125.64060 30,000_cells + HCMEC D3_line       500
      6060  160     C  B02 125.73986 30,000_cells + HCMEC D3_line       500
      6061  165     C  B02 125.82357 30,000_cells + HCMEC D3_line       500
      6062  170     C  B02 125.88962 30,000_cells + HCMEC D3_line       500
      6063  175     C  B02 125.99081 30,000_cells + HCMEC D3_line       500
      6064  180     C  B02 126.07240 30,000_cells + HCMEC D3_line       500
      6065  185     C  B02 126.12017 30,000_cells + HCMEC D3_line       500
      6066  190     C  B02 126.15668 30,000_cells + HCMEC D3_line       500
      6067  195     C  B02 126.22098 30,000_cells + HCMEC D3_line       500
      6068  200     C  B02        NA 30,000_cells + HCMEC D3_line       500
      6069    0     C  B02        NA 30,000_cells + HCMEC D3_line     64000
      6070    5     C  B02  51.38436 30,000_cells + HCMEC D3_line     64000
      6071   10     C  B02  43.08274 30,000_cells + HCMEC D3_line     64000
      6072   15     C  B02  34.99041 30,000_cells + HCMEC D3_line     64000
      6073   20     C  B02  28.35793 30,000_cells + HCMEC D3_line     64000
      6074   25     C  B02  24.45435 30,000_cells + HCMEC D3_line     64000
      6075   30     C  B02  21.76230 30,000_cells + HCMEC D3_line     64000
      6076   35     C  B02  20.08548 30,000_cells + HCMEC D3_line     64000
      6077   40     C  B02  17.38373 30,000_cells + HCMEC D3_line     64000
      6078   45     C  B02  14.54821 30,000_cells + HCMEC D3_line     64000
      6079   50     C  B02  12.75969 30,000_cells + HCMEC D3_line     64000
      6080   55     C  B02  11.14880 30,000_cells + HCMEC D3_line     64000
      6081   60     C  B02  10.81134 30,000_cells + HCMEC D3_line     64000
      6082   65     C  B02  10.71027 30,000_cells + HCMEC D3_line     64000
      6083   70     C  B02  10.69881 30,000_cells + HCMEC D3_line     64000
      6084   75     C  B02  10.86312 30,000_cells + HCMEC D3_line     64000
      6085   80     C  B02  10.96966 30,000_cells + HCMEC D3_line     64000
      6086   85     C  B02  11.20665 30,000_cells + HCMEC D3_line     64000
      6087   90     C  B02  11.47660 30,000_cells + HCMEC D3_line     64000
      6088   95     C  B02  11.80564 30,000_cells + HCMEC D3_line     64000
      6089  100     C  B02  12.19301 30,000_cells + HCMEC D3_line     64000
      6090  105     C  B02  12.52562 30,000_cells + HCMEC D3_line     64000
      6091  110     C  B02  13.06557 30,000_cells + HCMEC D3_line     64000
      6092  115     C  B02  13.54239 30,000_cells + HCMEC D3_line     64000
      6093  120     C  B02  13.95081 30,000_cells + HCMEC D3_line     64000
      6094  125     C  B02  14.40766 30,000_cells + HCMEC D3_line     64000
      6095  130     C  B02  14.85494 30,000_cells + HCMEC D3_line     64000
      6096  135     C  B02  15.46884 30,000_cells + HCMEC D3_line     64000
      6097  140     C  B02  15.78142 30,000_cells + HCMEC D3_line     64000
      6098  145     C  B02  16.25959 30,000_cells + HCMEC D3_line     64000
      6099  150     C  B02  16.81753 30,000_cells + HCMEC D3_line     64000
      6100  155     C  B02  17.60501 30,000_cells + HCMEC D3_line     64000
      6101  160     C  B02  18.41213 30,000_cells + HCMEC D3_line     64000
      6102  165     C  B02  19.05070 30,000_cells + HCMEC D3_line     64000
      6103  170     C  B02  19.54391 30,000_cells + HCMEC D3_line     64000
      6104  175     C  B02  20.38117 30,000_cells + HCMEC D3_line     64000
      6105  180     C  B02  20.90354 30,000_cells + HCMEC D3_line     64000
      6106  185     C  B02  21.84501 30,000_cells + HCMEC D3_line     64000
      6107  190     C  B02  22.30848 30,000_cells + HCMEC D3_line     64000
      6108  195     C  B02  23.34426 30,000_cells + HCMEC D3_line     64000
      6109  200     C  B02        NA 30,000_cells + HCMEC D3_line     64000
      6110    0     C  B02        NA 30,000_cells + HCMEC D3_line      8000
      6111    5     C  B02  92.01741 30,000_cells + HCMEC D3_line      8000
      6112   10     C  B02  83.39373 30,000_cells + HCMEC D3_line      8000
      6113   15     C  B02  75.24545 30,000_cells + HCMEC D3_line      8000
      6114   20     C  B02  69.50576 30,000_cells + HCMEC D3_line      8000
      6115   25     C  B02  66.59559 30,000_cells + HCMEC D3_line      8000
      6116   30     C  B02  64.90192 30,000_cells + HCMEC D3_line      8000
      6117   35     C  B02  64.39615 30,000_cells + HCMEC D3_line      8000
      6118   40     C  B02  63.86291 30,000_cells + HCMEC D3_line      8000
      6119   45     C  B02  64.33716 30,000_cells + HCMEC D3_line      8000
      6120   50     C  B02  65.56941 30,000_cells + HCMEC D3_line      8000
      6121   55     C  B02  67.27172 30,000_cells + HCMEC D3_line      8000
      6122   60     C  B02  67.89720 30,000_cells + HCMEC D3_line      8000
      6123   65     C  B02  68.94140 30,000_cells + HCMEC D3_line      8000
      6124   70     C  B02  70.09191 30,000_cells + HCMEC D3_line      8000
      6125   75     C  B02  70.61151 30,000_cells + HCMEC D3_line      8000
      6126   80     C  B02  71.52801 30,000_cells + HCMEC D3_line      8000
      6127   85     C  B02  72.22399 30,000_cells + HCMEC D3_line      8000
      6128   90     C  B02  73.34551 30,000_cells + HCMEC D3_line      8000
      6129   95     C  B02  74.95841 30,000_cells + HCMEC D3_line      8000
      6130  100     C  B02  75.96642 30,000_cells + HCMEC D3_line      8000
      6131  105     C  B02  77.33799 30,000_cells + HCMEC D3_line      8000
      6132  110     C  B02  78.54704 30,000_cells + HCMEC D3_line      8000
      6133  115     C  B02  80.28715 30,000_cells + HCMEC D3_line      8000
      6134  120     C  B02  81.27700 30,000_cells + HCMEC D3_line      8000
      6135  125     C  B02  82.65434 30,000_cells + HCMEC D3_line      8000
      6136  130     C  B02  83.85291 30,000_cells + HCMEC D3_line      8000
      6137  135     C  B02  85.20306 30,000_cells + HCMEC D3_line      8000
      6138  140     C  B02  86.04485 30,000_cells + HCMEC D3_line      8000
      6139  145     C  B02  86.79953 30,000_cells + HCMEC D3_line      8000
      6140  150     C  B02  87.80223 30,000_cells + HCMEC D3_line      8000
      6141  155     C  B02  88.89846 30,000_cells + HCMEC D3_line      8000
      6142  160     C  B02  90.09145 30,000_cells + HCMEC D3_line      8000
      6143  165     C  B02  90.82824 30,000_cells + HCMEC D3_line      8000
      6144  170     C  B02  91.64422 30,000_cells + HCMEC D3_line      8000
      6145  175     C  B02  92.69155 30,000_cells + HCMEC D3_line      8000
      6146  180     C  B02  93.65171 30,000_cells + HCMEC D3_line      8000
      6147  185     C  B02  94.28367 30,000_cells + HCMEC D3_line      8000
      6148  190     C  B02  94.67942 30,000_cells + HCMEC D3_line      8000
      6149  195     C  B02  95.81262 30,000_cells + HCMEC D3_line      8000
      6150  200     C  B02        NA 30,000_cells + HCMEC D3_line      8000
      6151    0     C  B03        NA 30,000_cells + HCMEC D3_line      1000
      6152    5     C  B03 118.66826 30,000_cells + HCMEC D3_line      1000
      6153   10     C  B03 117.81245 30,000_cells + HCMEC D3_line      1000
      6154   15     C  B03 116.44761 30,000_cells + HCMEC D3_line      1000
      6155   20     C  B03 115.65036 30,000_cells + HCMEC D3_line      1000
      6156   25     C  B03 115.12326 30,000_cells + HCMEC D3_line      1000
      6157   30     C  B03 114.96674 30,000_cells + HCMEC D3_line      1000
      6158   35     C  B03 115.36798 30,000_cells + HCMEC D3_line      1000
      6159   40     C  B03 115.35884 30,000_cells + HCMEC D3_line      1000
      6160   45     C  B03 116.13126 30,000_cells + HCMEC D3_line      1000
      6161   50     C  B03 116.79973 30,000_cells + HCMEC D3_line      1000
      6162   55     C  B03 117.60490 30,000_cells + HCMEC D3_line      1000
      6163   60     C  B03 118.28590 30,000_cells + HCMEC D3_line      1000
      6164   65     C  B03 119.00908 30,000_cells + HCMEC D3_line      1000
      6165   70     C  B03 119.66373 30,000_cells + HCMEC D3_line      1000
      6166   75     C  B03 120.12228 30,000_cells + HCMEC D3_line      1000
      6167   80     C  B03 120.32605 30,000_cells + HCMEC D3_line      1000
      6168   85     C  B03 120.61748 30,000_cells + HCMEC D3_line      1000
      6169   90     C  B03 121.00725 30,000_cells + HCMEC D3_line      1000
      6170   95     C  B03 121.36197 30,000_cells + HCMEC D3_line      1000
      6171  100     C  B03 121.67013 30,000_cells + HCMEC D3_line      1000
      6172  105     C  B03 121.93454 30,000_cells + HCMEC D3_line      1000
      6173  110     C  B03 122.21446 30,000_cells + HCMEC D3_line      1000
      6174  115     C  B03 122.41908 30,000_cells + HCMEC D3_line      1000
      6175  120     C  B03 122.68092 30,000_cells + HCMEC D3_line      1000
      6176  125     C  B03 123.02156 30,000_cells + HCMEC D3_line      1000
      6177  130     C  B03 123.26308 30,000_cells + HCMEC D3_line      1000
      6178  135     C  B03 123.40532 30,000_cells + HCMEC D3_line      1000
      6179  140     C  B03 123.54515 30,000_cells + HCMEC D3_line      1000
      6180  145     C  B03 123.67579 30,000_cells + HCMEC D3_line      1000
      6181  150     C  B03 123.91393 30,000_cells + HCMEC D3_line      1000
      6182  155     C  B03 123.99516 30,000_cells + HCMEC D3_line      1000
      6183  160     C  B03 124.23099 30,000_cells + HCMEC D3_line      1000
      6184  165     C  B03 124.38803 30,000_cells + HCMEC D3_line      1000
      6185  170     C  B03 124.55257 30,000_cells + HCMEC D3_line      1000
      6186  175     C  B03 124.71827 30,000_cells + HCMEC D3_line      1000
      6187  180     C  B03 124.80101 30,000_cells + HCMEC D3_line      1000
      6188  185     C  B03 124.97050 30,000_cells + HCMEC D3_line      1000
      6189  190     C  B03 124.98902 30,000_cells + HCMEC D3_line      1000
      6190  195     C  B03 125.12292 30,000_cells + HCMEC D3_line      1000
      6191  200     C  B03        NA 30,000_cells + HCMEC D3_line      1000
      6192    0     C  B03        NA 30,000_cells + HCMEC D3_line     16000
      6193    5     C  B03  84.83278 30,000_cells + HCMEC D3_line     16000
      6194   10     C  B03  77.30691 30,000_cells + HCMEC D3_line     16000
      6195   15     C  B03  68.36439 30,000_cells + HCMEC D3_line     16000
      6196   20     C  B03  61.09856 30,000_cells + HCMEC D3_line     16000
      6197   25     C  B03  54.88399 30,000_cells + HCMEC D3_line     16000
      6198   30     C  B03  51.19706 30,000_cells + HCMEC D3_line     16000
      6199   35     C  B03  48.98987 30,000_cells + HCMEC D3_line     16000
      6200   40     C  B03  45.53939 30,000_cells + HCMEC D3_line     16000
      6201   45     C  B03  43.63705 30,000_cells + HCMEC D3_line     16000
      6202   50     C  B03  42.66192 30,000_cells + HCMEC D3_line     16000
      6203   55     C  B03  41.56091 30,000_cells + HCMEC D3_line     16000
      6204   60     C  B03  41.63825 30,000_cells + HCMEC D3_line     16000
      6205   65     C  B03  41.92252 30,000_cells + HCMEC D3_line     16000
      6206   70     C  B03  42.44134 30,000_cells + HCMEC D3_line     16000
      6207   75     C  B03  43.11969 30,000_cells + HCMEC D3_line     16000
      6208   80     C  B03  43.27717 30,000_cells + HCMEC D3_line     16000
      6209   85     C  B03  44.33565 30,000_cells + HCMEC D3_line     16000
      6210   90     C  B03  45.25127 30,000_cells + HCMEC D3_line     16000
      6211   95     C  B03  47.11848 30,000_cells + HCMEC D3_line     16000
      6212  100     C  B03  48.26454 30,000_cells + HCMEC D3_line     16000
      6213  105     C  B03  49.87210 30,000_cells + HCMEC D3_line     16000
      6214  110     C  B03  51.67456 30,000_cells + HCMEC D3_line     16000
      6215  115     C  B03  53.04802 30,000_cells + HCMEC D3_line     16000
      6216  120     C  B03  54.48021 30,000_cells + HCMEC D3_line     16000
      6217  125     C  B03  55.98402 30,000_cells + HCMEC D3_line     16000
      6218  130     C  B03  57.51257 30,000_cells + HCMEC D3_line     16000
      6219  135     C  B03  58.70012 30,000_cells + HCMEC D3_line     16000
      6220  140     C  B03  59.81365 30,000_cells + HCMEC D3_line     16000
      6221  145     C  B03  61.21784 30,000_cells + HCMEC D3_line     16000
      6222  150     C  B03  62.78159 30,000_cells + HCMEC D3_line     16000
      6223  155     C  B03  63.95767 30,000_cells + HCMEC D3_line     16000
      6224  160     C  B03  65.18428 30,000_cells + HCMEC D3_line     16000
      6225  165     C  B03  66.43638 30,000_cells + HCMEC D3_line     16000
      6226  170     C  B03  67.97609 30,000_cells + HCMEC D3_line     16000
      6227  175     C  B03  69.23450 30,000_cells + HCMEC D3_line     16000
      6228  180     C  B03  70.44851 30,000_cells + HCMEC D3_line     16000
      6229  185     C  B03  71.56999 30,000_cells + HCMEC D3_line     16000
      6230  190     C  B03  72.39812 30,000_cells + HCMEC D3_line     16000
      6231  195     C  B03  73.60798 30,000_cells + HCMEC D3_line     16000
      6232  200     C  B03        NA 30,000_cells + HCMEC D3_line     16000
      6233    0     C  B03        NA 30,000_cells + HCMEC D3_line      2000
      6234    5     C  B03 114.40839 30,000_cells + HCMEC D3_line      2000
      6235   10     C  B03 111.91508 30,000_cells + HCMEC D3_line      2000
      6236   15     C  B03 108.46146 30,000_cells + HCMEC D3_line      2000
      6237   20     C  B03 106.28748 30,000_cells + HCMEC D3_line      2000
      6238   25     C  B03 104.66524 30,000_cells + HCMEC D3_line      2000
      6239   30     C  B03 103.87504 30,000_cells + HCMEC D3_line      2000
      6240   35     C  B03 104.08162 30,000_cells + HCMEC D3_line      2000
      6241   40     C  B03 103.71400 30,000_cells + HCMEC D3_line      2000
      6242   45     C  B03 104.74353 30,000_cells + HCMEC D3_line      2000
      6243   50     C  B03 105.75723 30,000_cells + HCMEC D3_line      2000
      6244   55     C  B03 107.24012 30,000_cells + HCMEC D3_line      2000
      6245   60     C  B03 108.57713 30,000_cells + HCMEC D3_line      2000
      6246   65     C  B03 109.86340 30,000_cells + HCMEC D3_line      2000
      6247   70     C  B03 110.94933 30,000_cells + HCMEC D3_line      2000
      6248   75     C  B03 111.78723 30,000_cells + HCMEC D3_line      2000
      6249   80     C  B03 111.97213 30,000_cells + HCMEC D3_line      2000
      6250   85     C  B03 112.45497 30,000_cells + HCMEC D3_line      2000
      6251   90     C  B03 113.07943 30,000_cells + HCMEC D3_line      2000
      6252   95     C  B03 113.75314 30,000_cells + HCMEC D3_line      2000
      6253  100     C  B03 114.32957 30,000_cells + HCMEC D3_line      2000
      6254  105     C  B03 114.88122 30,000_cells + HCMEC D3_line      2000
      6255  110     C  B03 115.45132 30,000_cells + HCMEC D3_line      2000
      6256  115     C  B03 115.88440 30,000_cells + HCMEC D3_line      2000
      6257  120     C  B03 116.42922 30,000_cells + HCMEC D3_line      2000
      6258  125     C  B03 117.06818 30,000_cells + HCMEC D3_line      2000
      6259  130     C  B03 117.56179 30,000_cells + HCMEC D3_line      2000
      6260  135     C  B03 117.81977 30,000_cells + HCMEC D3_line      2000
      6261  140     C  B03 118.11636 30,000_cells + HCMEC D3_line      2000
      6262  145     C  B03 118.39390 30,000_cells + HCMEC D3_line      2000
      6263  150     C  B03 118.93497 30,000_cells + HCMEC D3_line      2000
      6264  155     C  B03 119.09125 30,000_cells + HCMEC D3_line      2000
      6265  160     C  B03 119.55708 30,000_cells + HCMEC D3_line      2000
      6266  165     C  B03 119.88491 30,000_cells + HCMEC D3_line      2000
      6267  170     C  B03 120.27025 30,000_cells + HCMEC D3_line      2000
      6268  175     C  B03 120.61726 30,000_cells + HCMEC D3_line      2000
      6269  180     C  B03 120.83663 30,000_cells + HCMEC D3_line      2000
      6270  185     C  B03 121.22202 30,000_cells + HCMEC D3_line      2000
      6271  190     C  B03 121.27080 30,000_cells + HCMEC D3_line      2000
      6272  195     C  B03 121.61526 30,000_cells + HCMEC D3_line      2000
      6273  200     C  B03        NA 30,000_cells + HCMEC D3_line      2000
      6274    0     C  B03        NA 30,000_cells + HCMEC D3_line       250
      6275    5     C  B03 123.70990 30,000_cells + HCMEC D3_line       250
      6276   10     C  B03 123.55254 30,000_cells + HCMEC D3_line       250
      6277   15     C  B03 123.38106 30,000_cells + HCMEC D3_line       250
      6278   20     C  B03 123.29480 30,000_cells + HCMEC D3_line       250
      6279   25     C  B03 123.31034 30,000_cells + HCMEC D3_line       250
      6280   30     C  B03 123.41445 30,000_cells + HCMEC D3_line       250
      6281   35     C  B03 123.64891 30,000_cells + HCMEC D3_line       250
      6282   40     C  B03 123.80606 30,000_cells + HCMEC D3_line       250
      6283   45     C  B03 124.13552 30,000_cells + HCMEC D3_line       250
      6284   50     C  B03 124.43145 30,000_cells + HCMEC D3_line       250
      6285   55     C  B03 124.71308 30,000_cells + HCMEC D3_line       250
      6286   60     C  B03 125.00234 30,000_cells + HCMEC D3_line       250
      6287   65     C  B03 125.29368 30,000_cells + HCMEC D3_line       250
      6288   70     C  B03 125.56834 30,000_cells + HCMEC D3_line       250
      6289   75     C  B03 125.79665 30,000_cells + HCMEC D3_line       250
      6290   80     C  B03 126.00656 30,000_cells + HCMEC D3_line       250
      6291   85     C  B03 126.18881 30,000_cells + HCMEC D3_line       250
      6292   90     C  B03 126.35736 30,000_cells + HCMEC D3_line       250
      6293   95     C  B03 126.51557 30,000_cells + HCMEC D3_line       250
      6294  100     C  B03 126.67367 30,000_cells + HCMEC D3_line       250
      6295  105     C  B03 126.81196 30,000_cells + HCMEC D3_line       250
      6296  110     C  B03 126.94121 30,000_cells + HCMEC D3_line       250
      6297  115     C  B03 127.05141 30,000_cells + HCMEC D3_line       250
      6298  120     C  B03 127.16463 30,000_cells + HCMEC D3_line       250
      6299  125     C  B03 127.28959 30,000_cells + HCMEC D3_line       250
      6300  130     C  B03 127.39434 30,000_cells + HCMEC D3_line       250
      6301  135     C  B03 127.48492 30,000_cells + HCMEC D3_line       250
      6302  140     C  B03 127.57739 30,000_cells + HCMEC D3_line       250
      6303  145     C  B03 127.66318 30,000_cells + HCMEC D3_line       250
      6304  150     C  B03 127.74984 30,000_cells + HCMEC D3_line       250
      6305  155     C  B03 127.82136 30,000_cells + HCMEC D3_line       250
      6306  160     C  B03 127.90303 30,000_cells + HCMEC D3_line       250
      6307  165     C  B03 127.97017 30,000_cells + HCMEC D3_line       250
      6308  170     C  B03 128.03829 30,000_cells + HCMEC D3_line       250
      6309  175     C  B03 128.10271 30,000_cells + HCMEC D3_line       250
      6310  180     C  B03 128.15548 30,000_cells + HCMEC D3_line       250
      6311  185     C  B03 128.20707 30,000_cells + HCMEC D3_line       250
      6312  190     C  B03 128.24743 30,000_cells + HCMEC D3_line       250
      6313  195     C  B03 128.28541 30,000_cells + HCMEC D3_line       250
      6314  200     C  B03        NA 30,000_cells + HCMEC D3_line       250
      6315    0     C  B03        NA 30,000_cells + HCMEC D3_line     32000
      6316    5     C  B03  72.00210 30,000_cells + HCMEC D3_line     32000
      6317   10     C  B03  64.52269 30,000_cells + HCMEC D3_line     32000
      6318   15     C  B03  55.75817 30,000_cells + HCMEC D3_line     32000
      6319   20     C  B03  48.33985 30,000_cells + HCMEC D3_line     32000
      6320   25     C  B03  41.89711 30,000_cells + HCMEC D3_line     32000
      6321   30     C  B03  38.28614 30,000_cells + HCMEC D3_line     32000
      6322   35     C  B03  35.75571 30,000_cells + HCMEC D3_line     32000
      6323   40     C  B03  31.96224 30,000_cells + HCMEC D3_line     32000
      6324   45     C  B03  28.81506 30,000_cells + HCMEC D3_line     32000
      6325   50     C  B03  26.79464 30,000_cells + HCMEC D3_line     32000
      6326   55     C  B03  24.03573 30,000_cells + HCMEC D3_line     32000
      6327   60     C  B03  22.79002 30,000_cells + HCMEC D3_line     32000
      6328   65     C  B03  22.07478 30,000_cells + HCMEC D3_line     32000
      6329   70     C  B03  21.82167 30,000_cells + HCMEC D3_line     32000
      6330   75     C  B03  21.75473 30,000_cells + HCMEC D3_line     32000
      6331   80     C  B03  21.86191 30,000_cells + HCMEC D3_line     32000
      6332   85     C  B03  22.48928 30,000_cells + HCMEC D3_line     32000
      6333   90     C  B03  22.94354 30,000_cells + HCMEC D3_line     32000
      6334   95     C  B03  24.02099 30,000_cells + HCMEC D3_line     32000
      6335  100     C  B03  24.85925 30,000_cells + HCMEC D3_line     32000
      6336  105     C  B03  25.88938 30,000_cells + HCMEC D3_line     32000
      6337  110     C  B03  27.20031 30,000_cells + HCMEC D3_line     32000
      6338  115     C  B03  28.06533 30,000_cells + HCMEC D3_line     32000
      6339  120     C  B03  29.08176 30,000_cells + HCMEC D3_line     32000
      6340  125     C  B03  30.12679 30,000_cells + HCMEC D3_line     32000
      6341  130     C  B03  31.40315 30,000_cells + HCMEC D3_line     32000
      6342  135     C  B03  32.20115 30,000_cells + HCMEC D3_line     32000
      6343  140     C  B03  33.12084 30,000_cells + HCMEC D3_line     32000
      6344  145     C  B03  34.32974 30,000_cells + HCMEC D3_line     32000
      6345  150     C  B03  35.66609 30,000_cells + HCMEC D3_line     32000
      6346  155     C  B03  36.73655 30,000_cells + HCMEC D3_line     32000
      6347  160     C  B03  37.96747 30,000_cells + HCMEC D3_line     32000
      6348  165     C  B03  39.06786 30,000_cells + HCMEC D3_line     32000
      6349  170     C  B03  40.60181 30,000_cells + HCMEC D3_line     32000
      6350  175     C  B03  41.89599 30,000_cells + HCMEC D3_line     32000
      6351  180     C  B03  43.25992 30,000_cells + HCMEC D3_line     32000
      6352  185     C  B03  44.36839 30,000_cells + HCMEC D3_line     32000
      6353  190     C  B03  45.27733 30,000_cells + HCMEC D3_line     32000
      6354  195     C  B03  46.51299 30,000_cells + HCMEC D3_line     32000
      6355  200     C  B03        NA 30,000_cells + HCMEC D3_line     32000
      6356    0     C  B03        NA 30,000_cells + HCMEC D3_line      4000
      6357    5     C  B03 107.01997 30,000_cells + HCMEC D3_line      4000
      6358   10     C  B03 102.49834 30,000_cells + HCMEC D3_line      4000
      6359   15     C  B03  96.55791 30,000_cells + HCMEC D3_line      4000
      6360   20     C  B03  92.46916 30,000_cells + HCMEC D3_line      4000
      6361   25     C  B03  89.23135 30,000_cells + HCMEC D3_line      4000
      6362   30     C  B03  87.43118 30,000_cells + HCMEC D3_line      4000
      6363   35     C  B03  87.03411 30,000_cells + HCMEC D3_line      4000
      6364   40     C  B03  85.92075 30,000_cells + HCMEC D3_line      4000
      6365   45     C  B03  86.71498 30,000_cells + HCMEC D3_line      4000
      6366   50     C  B03  87.75071 30,000_cells + HCMEC D3_line      4000
      6367   55     C  B03  89.62368 30,000_cells + HCMEC D3_line      4000
      6368   60     C  B03  91.64434 30,000_cells + HCMEC D3_line      4000
      6369   65     C  B03  93.46365 30,000_cells + HCMEC D3_line      4000
      6370   70     C  B03  95.01383 30,000_cells + HCMEC D3_line      4000
      6371   75     C  B03  96.45466 30,000_cells + HCMEC D3_line      4000
      6372   80     C  B03  96.58759 30,000_cells + HCMEC D3_line      4000
      6373   85     C  B03  97.49465 30,000_cells + HCMEC D3_line      4000
      6374   90     C  B03  98.39706 30,000_cells + HCMEC D3_line      4000
      6375   95     C  B03  99.76221 30,000_cells + HCMEC D3_line      4000
      6376  100     C  B03 100.61967 30,000_cells + HCMEC D3_line      4000
      6377  105     C  B03 101.59352 30,000_cells + HCMEC D3_line      4000
      6378  110     C  B03 102.55995 30,000_cells + HCMEC D3_line      4000
      6379  115     C  B03 103.39540 30,000_cells + HCMEC D3_line      4000
      6380  120     C  B03 104.23921 30,000_cells + HCMEC D3_line      4000
      6381  125     C  B03 105.21753 30,000_cells + HCMEC D3_line      4000
      6382  130     C  B03 105.99543 30,000_cells + HCMEC D3_line      4000
      6383  135     C  B03 106.49095 30,000_cells + HCMEC D3_line      4000
      6384  140     C  B03 107.06248 30,000_cells + HCMEC D3_line      4000
      6385  145     C  B03 107.58006 30,000_cells + HCMEC D3_line      4000
      6386  150     C  B03 108.49242 30,000_cells + HCMEC D3_line      4000
      6387  155     C  B03 108.85473 30,000_cells + HCMEC D3_line      4000
      6388  160     C  B03 109.49910 30,000_cells + HCMEC D3_line      4000
      6389  165     C  B03 110.09731 30,000_cells + HCMEC D3_line      4000
      6390  170     C  B03 110.75572 30,000_cells + HCMEC D3_line      4000
      6391  175     C  B03 111.35800 30,000_cells + HCMEC D3_line      4000
      6392  180     C  B03 111.77602 30,000_cells + HCMEC D3_line      4000
      6393  185     C  B03 112.43159 30,000_cells + HCMEC D3_line      4000
      6394  190     C  B03 112.59419 30,000_cells + HCMEC D3_line      4000
      6395  195     C  B03 113.24811 30,000_cells + HCMEC D3_line      4000
      6396  200     C  B03        NA 30,000_cells + HCMEC D3_line      4000
      6397    0     C  B03        NA 30,000_cells + HCMEC D3_line       500
      6398    5     C  B03 121.57443 30,000_cells + HCMEC D3_line       500
      6399   10     C  B03 121.33851 30,000_cells + HCMEC D3_line       500
      6400   15     C  B03 120.91041 30,000_cells + HCMEC D3_line       500
      6401   20     C  B03 120.69256 30,000_cells + HCMEC D3_line       500
      6402   25     C  B03 120.58669 30,000_cells + HCMEC D3_line       500
      6403   30     C  B03 120.62323 30,000_cells + HCMEC D3_line       500
      6404   35     C  B03 120.94812 30,000_cells + HCMEC D3_line       500
      6405   40     C  B03 121.07102 30,000_cells + HCMEC D3_line       500
      6406   45     C  B03 121.56462 30,000_cells + HCMEC D3_line       500
      6407   50     C  B03 121.98027 30,000_cells + HCMEC D3_line       500
      6408   55     C  B03 122.42851 30,000_cells + HCMEC D3_line       500
      6409   60     C  B03 122.80673 30,000_cells + HCMEC D3_line       500
      6410   65     C  B03 123.21931 30,000_cells + HCMEC D3_line       500
      6411   70     C  B03 123.59754 30,000_cells + HCMEC D3_line       500
      6412   75     C  B03 123.88487 30,000_cells + HCMEC D3_line       500
      6413   80     C  B03 124.08540 30,000_cells + HCMEC D3_line       500
      6414   85     C  B03 124.29571 30,000_cells + HCMEC D3_line       500
      6415   90     C  B03 124.54311 30,000_cells + HCMEC D3_line       500
      6416   95     C  B03 124.73757 30,000_cells + HCMEC D3_line       500
      6417  100     C  B03 124.92989 30,000_cells + HCMEC D3_line       500
      6418  105     C  B03 125.09798 30,000_cells + HCMEC D3_line       500
      6419  110     C  B03 125.25385 30,000_cells + HCMEC D3_line       500
      6420  115     C  B03 125.38856 30,000_cells + HCMEC D3_line       500
      6421  120     C  B03 125.54793 30,000_cells + HCMEC D3_line       500
      6422  125     C  B03 125.72812 30,000_cells + HCMEC D3_line       500
      6423  130     C  B03 125.85803 30,000_cells + HCMEC D3_line       500
      6424  135     C  B03 125.96360 30,000_cells + HCMEC D3_line       500
      6425  140     C  B03 126.06499 30,000_cells + HCMEC D3_line       500
      6426  145     C  B03 126.15795 30,000_cells + HCMEC D3_line       500
      6427  150     C  B03 126.28068 30,000_cells + HCMEC D3_line       500
      6428  155     C  B03 126.35403 30,000_cells + HCMEC D3_line       500
      6429  160     C  B03 126.47153 30,000_cells + HCMEC D3_line       500
      6430  165     C  B03 126.56648 30,000_cells + HCMEC D3_line       500
      6431  170     C  B03 126.64604 30,000_cells + HCMEC D3_line       500
      6432  175     C  B03 126.73038 30,000_cells + HCMEC D3_line       500
      6433  180     C  B03 126.80011 30,000_cells + HCMEC D3_line       500
      6434  185     C  B03 126.87322 30,000_cells + HCMEC D3_line       500
      6435  190     C  B03 126.90266 30,000_cells + HCMEC D3_line       500
      6436  195     C  B03 126.95908 30,000_cells + HCMEC D3_line       500
      6437  200     C  B03        NA 30,000_cells + HCMEC D3_line       500
      6438    0     C  B03        NA 30,000_cells + HCMEC D3_line     64000
      6439    5     C  B03  54.58037 30,000_cells + HCMEC D3_line     64000
      6440   10     C  B03  48.67117 30,000_cells + HCMEC D3_line     64000
      6441   15     C  B03  41.81233 30,000_cells + HCMEC D3_line     64000
      6442   20     C  B03  35.71130 30,000_cells + HCMEC D3_line     64000
      6443   25     C  B03  30.40152 30,000_cells + HCMEC D3_line     64000
      6444   30     C  B03  27.59718 30,000_cells + HCMEC D3_line     64000
      6445   35     C  B03  25.42759 30,000_cells + HCMEC D3_line     64000
      6446   40     C  B03  22.21933 30,000_cells + HCMEC D3_line     64000
      6447   45     C  B03  18.83674 30,000_cells + HCMEC D3_line     64000
      6448   50     C  B03  16.65108 30,000_cells + HCMEC D3_line     64000
      6449   55     C  B03  13.67354 30,000_cells + HCMEC D3_line     64000
      6450   60     C  B03  12.28366 30,000_cells + HCMEC D3_line     64000
      6451   65     C  B03  11.49318 30,000_cells + HCMEC D3_line     64000
      6452   70     C  B03  11.14268 30,000_cells + HCMEC D3_line     64000
      6453   75     C  B03  10.94968 30,000_cells + HCMEC D3_line     64000
      6454   80     C  B03  11.02124 30,000_cells + HCMEC D3_line     64000
      6455   85     C  B03  11.31666 30,000_cells + HCMEC D3_line     64000
      6456   90     C  B03  11.47233 30,000_cells + HCMEC D3_line     64000
      6457   95     C  B03  11.91758 30,000_cells + HCMEC D3_line     64000
      6458  100     C  B03  12.32402 30,000_cells + HCMEC D3_line     64000
      6459  105     C  B03  12.76478 30,000_cells + HCMEC D3_line     64000
      6460  110     C  B03  13.40857 30,000_cells + HCMEC D3_line     64000
      6461  115     C  B03  13.73996 30,000_cells + HCMEC D3_line     64000
      6462  120     C  B03  14.19094 30,000_cells + HCMEC D3_line     64000
      6463  125     C  B03  14.66177 30,000_cells + HCMEC D3_line     64000
      6464  130     C  B03  15.37414 30,000_cells + HCMEC D3_line     64000
      6465  135     C  B03  15.67624 30,000_cells + HCMEC D3_line     64000
      6466  140     C  B03  16.12556 30,000_cells + HCMEC D3_line     64000
      6467  145     C  B03  16.75915 30,000_cells + HCMEC D3_line     64000
      6468  150     C  B03  17.50743 30,000_cells + HCMEC D3_line     64000
      6469  155     C  B03  18.05438 30,000_cells + HCMEC D3_line     64000
      6470  160     C  B03  18.80531 30,000_cells + HCMEC D3_line     64000
      6471  165     C  B03  19.38540 30,000_cells + HCMEC D3_line     64000
      6472  170     C  B03  20.35577 30,000_cells + HCMEC D3_line     64000
      6473  175     C  B03  21.12125 30,000_cells + HCMEC D3_line     64000
      6474  180     C  B03  22.03012 30,000_cells + HCMEC D3_line     64000
      6475  185     C  B03  22.79232 30,000_cells + HCMEC D3_line     64000
      6476  190     C  B03  23.32789 30,000_cells + HCMEC D3_line     64000
      6477  195     C  B03  24.27568 30,000_cells + HCMEC D3_line     64000
      6478  200     C  B03        NA 30,000_cells + HCMEC D3_line     64000
      6479    0     C  B03        NA 30,000_cells + HCMEC D3_line      8000
      6480    5     C  B03  96.30395 30,000_cells + HCMEC D3_line      8000
      6481   10     C  B03  89.81992 30,000_cells + HCMEC D3_line      8000
      6482   15     C  B03  81.97285 30,000_cells + HCMEC D3_line      8000
      6483   20     C  B03  76.02534 30,000_cells + HCMEC D3_line      8000
      6484   25     C  B03  71.11943 30,000_cells + HCMEC D3_line      8000
      6485   30     C  B03  68.19158 30,000_cells + HCMEC D3_line      8000
      6486   35     C  B03  66.83784 30,000_cells + HCMEC D3_line      8000
      6487   40     C  B03  64.42017 30,000_cells + HCMEC D3_line      8000
      6488   45     C  B03  64.08956 30,000_cells + HCMEC D3_line      8000
      6489   50     C  B03  64.45348 30,000_cells + HCMEC D3_line      8000
      6490   55     C  B03  65.50609 30,000_cells + HCMEC D3_line      8000
      6491   60     C  B03  67.20463 30,000_cells + HCMEC D3_line      8000
      6492   65     C  B03  68.74473 30,000_cells + HCMEC D3_line      8000
      6493   70     C  B03  70.21633 30,000_cells + HCMEC D3_line      8000
      6494   75     C  B03  71.75280 30,000_cells + HCMEC D3_line      8000
      6495   80     C  B03  71.88199 30,000_cells + HCMEC D3_line      8000
      6496   85     C  B03  73.05697 30,000_cells + HCMEC D3_line      8000
      6497   90     C  B03  74.15029 30,000_cells + HCMEC D3_line      8000
      6498   95     C  B03  76.12526 30,000_cells + HCMEC D3_line      8000
      6499  100     C  B03  77.19700 30,000_cells + HCMEC D3_line      8000
      6500  105     C  B03  78.72738 30,000_cells + HCMEC D3_line      8000
      6501  110     C  B03  80.25614 30,000_cells + HCMEC D3_line      8000
      6502  115     C  B03  81.55477 30,000_cells + HCMEC D3_line      8000
      6503  120     C  B03  82.80426 30,000_cells + HCMEC D3_line      8000
      6504  125     C  B03  84.16819 30,000_cells + HCMEC D3_line      8000
      6505  130     C  B03  85.31540 30,000_cells + HCMEC D3_line      8000
      6506  135     C  B03  86.27672 30,000_cells + HCMEC D3_line      8000
      6507  140     C  B03  87.18116 30,000_cells + HCMEC D3_line      8000
      6508  145     C  B03  88.17882 30,000_cells + HCMEC D3_line      8000
      6509  150     C  B03  89.47201 30,000_cells + HCMEC D3_line      8000
      6510  155     C  B03  90.27904 30,000_cells + HCMEC D3_line      8000
      6511  160     C  B03  91.17113 30,000_cells + HCMEC D3_line      8000
      6512  165     C  B03  92.14950 30,000_cells + HCMEC D3_line      8000
      6513  170     C  B03  93.21334 30,000_cells + HCMEC D3_line      8000
      6514  175     C  B03  94.08515 30,000_cells + HCMEC D3_line      8000
      6515  180     C  B03  94.79398 30,000_cells + HCMEC D3_line      8000
      6516  185     C  B03  95.71911 30,000_cells + HCMEC D3_line      8000
      6517  190     C  B03  96.15320 30,000_cells + HCMEC D3_line      8000
      6518  195     C  B03  97.11230 30,000_cells + HCMEC D3_line      8000
      6519  200     C  B03        NA 30,000_cells + HCMEC D3_line      8000
      6520    0     C  C01        NA 25,000_cells + HCMEC D3_line      1000
      6521    5     C  C01 118.06220 25,000_cells + HCMEC D3_line      1000
      6522   10     C  C01 117.21453 25,000_cells + HCMEC D3_line      1000
      6523   15     C  C01 116.14031 25,000_cells + HCMEC D3_line      1000
      6524   20     C  C01 115.03389 25,000_cells + HCMEC D3_line      1000
      6525   25     C  C01 114.43425 25,000_cells + HCMEC D3_line      1000
      6526   30     C  C01 114.34331 25,000_cells + HCMEC D3_line      1000
      6527   35     C  C01 114.55417 25,000_cells + HCMEC D3_line      1000
      6528   40     C  C01 114.64716 25,000_cells + HCMEC D3_line      1000
      6529   45     C  C01 114.83780 25,000_cells + HCMEC D3_line      1000
      6530   50     C  C01 115.50575 25,000_cells + HCMEC D3_line      1000
      6531   55     C  C01 115.84906 25,000_cells + HCMEC D3_line      1000
      6532   60     C  C01 116.87566 25,000_cells + HCMEC D3_line      1000
      6533   65     C  C01 117.69030 25,000_cells + HCMEC D3_line      1000
      6534   70     C  C01 118.22587 25,000_cells + HCMEC D3_line      1000
      6535   75     C  C01 118.86897 25,000_cells + HCMEC D3_line      1000
      6536   80     C  C01 119.33174 25,000_cells + HCMEC D3_line      1000
      6537   85     C  C01 119.63097 25,000_cells + HCMEC D3_line      1000
      6538   90     C  C01 119.91816 25,000_cells + HCMEC D3_line      1000
      6539   95     C  C01 120.28962 25,000_cells + HCMEC D3_line      1000
      6540  100     C  C01 120.43593 25,000_cells + HCMEC D3_line      1000
      6541  105     C  C01 120.79898 25,000_cells + HCMEC D3_line      1000
      6542  110     C  C01 121.16021 25,000_cells + HCMEC D3_line      1000
      6543  115     C  C01 121.36381 25,000_cells + HCMEC D3_line      1000
      6544  120     C  C01 121.65580 25,000_cells + HCMEC D3_line      1000
      6545  125     C  C01 121.89118 25,000_cells + HCMEC D3_line      1000
      6546  130     C  C01 122.01693 25,000_cells + HCMEC D3_line      1000
      6547  135     C  C01 122.19449 25,000_cells + HCMEC D3_line      1000
      6548  140     C  C01 122.42078 25,000_cells + HCMEC D3_line      1000
      6549  145     C  C01 122.47850 25,000_cells + HCMEC D3_line      1000
      6550  150     C  C01 122.80876 25,000_cells + HCMEC D3_line      1000
      6551  155     C  C01 123.08677 25,000_cells + HCMEC D3_line      1000
      6552  160     C  C01 123.22577 25,000_cells + HCMEC D3_line      1000
      6553  165     C  C01 123.41682 25,000_cells + HCMEC D3_line      1000
      6554  170     C  C01 123.64003 25,000_cells + HCMEC D3_line      1000
      6555  175     C  C01 123.76037 25,000_cells + HCMEC D3_line      1000
      6556  180     C  C01 123.92949 25,000_cells + HCMEC D3_line      1000
      6557  185     C  C01 124.03052 25,000_cells + HCMEC D3_line      1000
      6558  190     C  C01 124.13313 25,000_cells + HCMEC D3_line      1000
      6559  195     C  C01 124.27204 25,000_cells + HCMEC D3_line      1000
      6560  200     C  C01        NA 25,000_cells + HCMEC D3_line      1000
      6561    0     C  C01        NA 25,000_cells + HCMEC D3_line     16000
      6562    5     C  C01  86.58603 25,000_cells + HCMEC D3_line     16000
      6563   10     C  C01  79.22759 25,000_cells + HCMEC D3_line     16000
      6564   15     C  C01  70.72677 25,000_cells + HCMEC D3_line     16000
      6565   20     C  C01  62.64714 25,000_cells + HCMEC D3_line     16000
      6566   25     C  C01  57.43470 25,000_cells + HCMEC D3_line     16000
      6567   30     C  C01  54.60213 25,000_cells + HCMEC D3_line     16000
      6568   35     C  C01  52.05983 25,000_cells + HCMEC D3_line     16000
      6569   40     C  C01  48.99040 25,000_cells + HCMEC D3_line     16000
      6570   45     C  C01  45.46218 25,000_cells + HCMEC D3_line     16000
      6571   50     C  C01  42.45753 25,000_cells + HCMEC D3_line     16000
      6572   55     C  C01  40.83809 25,000_cells + HCMEC D3_line     16000
      6573   60     C  C01  40.16794 25,000_cells + HCMEC D3_line     16000
      6574   65     C  C01  40.59216 25,000_cells + HCMEC D3_line     16000
      6575   70     C  C01  40.47279 25,000_cells + HCMEC D3_line     16000
      6576   75     C  C01  41.47303 25,000_cells + HCMEC D3_line     16000
      6577   80     C  C01  41.98132 25,000_cells + HCMEC D3_line     16000
      6578   85     C  C01  42.49571 25,000_cells + HCMEC D3_line     16000
      6579   90     C  C01  43.28447 25,000_cells + HCMEC D3_line     16000
      6580   95     C  C01  44.77895 25,000_cells + HCMEC D3_line     16000
      6581  100     C  C01  45.59024 25,000_cells + HCMEC D3_line     16000
      6582  105     C  C01  47.40768 25,000_cells + HCMEC D3_line     16000
      6583  110     C  C01  48.92326 25,000_cells + HCMEC D3_line     16000
      6584  115     C  C01  50.35145 25,000_cells + HCMEC D3_line     16000
      6585  120     C  C01  51.74703 25,000_cells + HCMEC D3_line     16000
      6586  125     C  C01  53.08311 25,000_cells + HCMEC D3_line     16000
      6587  130     C  C01  54.41403 25,000_cells + HCMEC D3_line     16000
      6588  135     C  C01  55.82552 25,000_cells + HCMEC D3_line     16000
      6589  140     C  C01  57.57708 25,000_cells + HCMEC D3_line     16000
      6590  145     C  C01  59.22925 25,000_cells + HCMEC D3_line     16000
      6591  150     C  C01  60.97270 25,000_cells + HCMEC D3_line     16000
      6592  155     C  C01  61.98677 25,000_cells + HCMEC D3_line     16000
      6593  160     C  C01  63.56441 25,000_cells + HCMEC D3_line     16000
      6594  165     C  C01  64.95165 25,000_cells + HCMEC D3_line     16000
      6595  170     C  C01  66.53713 25,000_cells + HCMEC D3_line     16000
      6596  175     C  C01  67.43934 25,000_cells + HCMEC D3_line     16000
      6597  180     C  C01  68.85754 25,000_cells + HCMEC D3_line     16000
      6598  185     C  C01  69.97618 25,000_cells + HCMEC D3_line     16000
      6599  190     C  C01  70.95264 25,000_cells + HCMEC D3_line     16000
      6600  195     C  C01  71.77503 25,000_cells + HCMEC D3_line     16000
      6601  200     C  C01        NA 25,000_cells + HCMEC D3_line     16000
      6602    0     C  C01        NA 25,000_cells + HCMEC D3_line      2000
      6603    5     C  C01 114.33173 25,000_cells + HCMEC D3_line      2000
      6604   10     C  C01 111.84962 25,000_cells + HCMEC D3_line      2000
      6605   15     C  C01 108.95556 25,000_cells + HCMEC D3_line      2000
      6606   20     C  C01 106.04338 25,000_cells + HCMEC D3_line      2000
      6607   25     C  C01 104.41520 25,000_cells + HCMEC D3_line      2000
      6608   30     C  C01 103.72947 25,000_cells + HCMEC D3_line      2000
      6609   35     C  C01 103.64239 25,000_cells + HCMEC D3_line      2000
      6610   40     C  C01 103.19280 25,000_cells + HCMEC D3_line      2000
      6611   45     C  C01 103.06190 25,000_cells + HCMEC D3_line      2000
      6612   50     C  C01 103.86553 25,000_cells + HCMEC D3_line      2000
      6613   55     C  C01 104.64613 25,000_cells + HCMEC D3_line      2000
      6614   60     C  C01 106.46681 25,000_cells + HCMEC D3_line      2000
      6615   65     C  C01 108.00820 25,000_cells + HCMEC D3_line      2000
      6616   70     C  C01 108.98982 25,000_cells + HCMEC D3_line      2000
      6617   75     C  C01 110.00117 25,000_cells + HCMEC D3_line      2000
      6618   80     C  C01 110.66368 25,000_cells + HCMEC D3_line      2000
      6619   85     C  C01 111.13363 25,000_cells + HCMEC D3_line      2000
      6620   90     C  C01 111.56322 25,000_cells + HCMEC D3_line      2000
      6621   95     C  C01 112.17688 25,000_cells + HCMEC D3_line      2000
      6622  100     C  C01 112.44399 25,000_cells + HCMEC D3_line      2000
      6623  105     C  C01 113.08788 25,000_cells + HCMEC D3_line      2000
      6624  110     C  C01 113.82684 25,000_cells + HCMEC D3_line      2000
      6625  115     C  C01 114.29761 25,000_cells + HCMEC D3_line      2000
      6626  120     C  C01 114.86720 25,000_cells + HCMEC D3_line      2000
      6627  125     C  C01 115.35969 25,000_cells + HCMEC D3_line      2000
      6628  130     C  C01 115.64795 25,000_cells + HCMEC D3_line      2000
      6629  135     C  C01 115.99295 25,000_cells + HCMEC D3_line      2000
      6630  140     C  C01 116.45162 25,000_cells + HCMEC D3_line      2000
      6631  145     C  C01 116.65160 25,000_cells + HCMEC D3_line      2000
      6632  150     C  C01 117.35381 25,000_cells + HCMEC D3_line      2000
      6633  155     C  C01 117.87475 25,000_cells + HCMEC D3_line      2000
      6634  160     C  C01 118.19054 25,000_cells + HCMEC D3_line      2000
      6635  165     C  C01 118.62535 25,000_cells + HCMEC D3_line      2000
      6636  170     C  C01 119.13761 25,000_cells + HCMEC D3_line      2000
      6637  175     C  C01 119.43329 25,000_cells + HCMEC D3_line      2000
      6638  180     C  C01 119.83702 25,000_cells + HCMEC D3_line      2000
      6639  185     C  C01 120.08533 25,000_cells + HCMEC D3_line      2000
      6640  190     C  C01 120.35394 25,000_cells + HCMEC D3_line      2000
      6641  195     C  C01 120.70069 25,000_cells + HCMEC D3_line      2000
      6642  200     C  C01        NA 25,000_cells + HCMEC D3_line      2000
      6643    0     C  C01        NA 25,000_cells + HCMEC D3_line       250
      6644    5     C  C01 122.86553 25,000_cells + HCMEC D3_line       250
      6645   10     C  C01 122.74178 25,000_cells + HCMEC D3_line       250
      6646   15     C  C01 122.61430 25,000_cells + HCMEC D3_line       250
      6647   20     C  C01 122.50499 25,000_cells + HCMEC D3_line       250
      6648   25     C  C01 122.53290 25,000_cells + HCMEC D3_line       250
      6649   30     C  C01 122.70150 25,000_cells + HCMEC D3_line       250
      6650   35     C  C01 122.92137 25,000_cells + HCMEC D3_line       250
      6651   40     C  C01 123.15415 25,000_cells + HCMEC D3_line       250
      6652   45     C  C01 123.34972 25,000_cells + HCMEC D3_line       250
      6653   50     C  C01 123.62718 25,000_cells + HCMEC D3_line       250
      6654   55     C  C01 123.85786 25,000_cells + HCMEC D3_line       250
      6655   60     C  C01 124.21824 25,000_cells + HCMEC D3_line       250
      6656   65     C  C01 124.52802 25,000_cells + HCMEC D3_line       250
      6657   70     C  C01 124.80185 25,000_cells + HCMEC D3_line       250
      6658   75     C  C01 125.05739 25,000_cells + HCMEC D3_line       250
      6659   80     C  C01 125.28223 25,000_cells + HCMEC D3_line       250
      6660   85     C  C01 125.48655 25,000_cells + HCMEC D3_line       250
      6661   90     C  C01 125.65363 25,000_cells + HCMEC D3_line       250
      6662   95     C  C01 125.81189 25,000_cells + HCMEC D3_line       250
      6663  100     C  C01 125.93731 25,000_cells + HCMEC D3_line       250
      6664  105     C  C01 126.06858 25,000_cells + HCMEC D3_line       250
      6665  110     C  C01 126.20681 25,000_cells + HCMEC D3_line       250
      6666  115     C  C01 126.31093 25,000_cells + HCMEC D3_line       250
      6667  120     C  C01 126.42960 25,000_cells + HCMEC D3_line       250
      6668  125     C  C01 126.53605 25,000_cells + HCMEC D3_line       250
      6669  130     C  C01 126.62659 25,000_cells + HCMEC D3_line       250
      6670  135     C  C01 126.69368 25,000_cells + HCMEC D3_line       250
      6671  140     C  C01 126.77799 25,000_cells + HCMEC D3_line       250
      6672  145     C  C01 126.84077 25,000_cells + HCMEC D3_line       250
      6673  150     C  C01 126.92170 25,000_cells + HCMEC D3_line       250
      6674  155     C  C01 127.00969 25,000_cells + HCMEC D3_line       250
      6675  160     C  C01 127.06229 25,000_cells + HCMEC D3_line       250
      6676  165     C  C01 127.12162 25,000_cells + HCMEC D3_line       250
      6677  170     C  C01 127.18790 25,000_cells + HCMEC D3_line       250
      6678  175     C  C01 127.23920 25,000_cells + HCMEC D3_line       250
      6679  180     C  C01 127.27742 25,000_cells + HCMEC D3_line       250
      6680  185     C  C01 127.33245 25,000_cells + HCMEC D3_line       250
      6681  190     C  C01 127.34735 25,000_cells + HCMEC D3_line       250
      6682  195     C  C01 127.38678 25,000_cells + HCMEC D3_line       250
      6683  200     C  C01        NA 25,000_cells + HCMEC D3_line       250
      6684    0     C  C01        NA 25,000_cells + HCMEC D3_line     32000
      6685    5     C  C01  73.39965 25,000_cells + HCMEC D3_line     32000
      6686   10     C  C01  66.34921 25,000_cells + HCMEC D3_line     32000
      6687   15     C  C01  58.14601 25,000_cells + HCMEC D3_line     32000
      6688   20     C  C01  50.35396 25,000_cells + HCMEC D3_line     32000
      6689   25     C  C01  45.02373 25,000_cells + HCMEC D3_line     32000
      6690   30     C  C01  42.11897 25,000_cells + HCMEC D3_line     32000
      6691   35     C  C01  39.52145 25,000_cells + HCMEC D3_line     32000
      6692   40     C  C01  36.47387 25,000_cells + HCMEC D3_line     32000
      6693   45     C  C01  32.30942 25,000_cells + HCMEC D3_line     32000
      6694   50     C  C01  28.45204 25,000_cells + HCMEC D3_line     32000
      6695   55     C  C01  25.29111 25,000_cells + HCMEC D3_line     32000
      6696   60     C  C01  22.88204 25,000_cells + HCMEC D3_line     32000
      6697   65     C  C01  21.72215 25,000_cells + HCMEC D3_line     32000
      6698   70     C  C01  20.79679 25,000_cells + HCMEC D3_line     32000
      6699   75     C  C01  21.13614 25,000_cells + HCMEC D3_line     32000
      6700   80     C  C01  21.24510 25,000_cells + HCMEC D3_line     32000
      6701   85     C  C01  21.51692 25,000_cells + HCMEC D3_line     32000
      6702   90     C  C01  21.98639 25,000_cells + HCMEC D3_line     32000
      6703   95     C  C01  22.87682 25,000_cells + HCMEC D3_line     32000
      6704  100     C  C01  23.28994 25,000_cells + HCMEC D3_line     32000
      6705  105     C  C01  24.45900 25,000_cells + HCMEC D3_line     32000
      6706  110     C  C01  25.34786 25,000_cells + HCMEC D3_line     32000
      6707  115     C  C01  26.28508 25,000_cells + HCMEC D3_line     32000
      6708  120     C  C01  27.32039 25,000_cells + HCMEC D3_line     32000
      6709  125     C  C01  28.31467 25,000_cells + HCMEC D3_line     32000
      6710  130     C  C01  29.35120 25,000_cells + HCMEC D3_line     32000
      6711  135     C  C01  30.47711 25,000_cells + HCMEC D3_line     32000
      6712  140     C  C01  31.83022 25,000_cells + HCMEC D3_line     32000
      6713  145     C  C01  33.18513 25,000_cells + HCMEC D3_line     32000
      6714  150     C  C01  34.70581 25,000_cells + HCMEC D3_line     32000
      6715  155     C  C01  35.49861 25,000_cells + HCMEC D3_line     32000
      6716  160     C  C01  37.00299 25,000_cells + HCMEC D3_line     32000
      6717  165     C  C01  38.12434 25,000_cells + HCMEC D3_line     32000
      6718  170     C  C01  39.70307 25,000_cells + HCMEC D3_line     32000
      6719  175     C  C01  40.54199 25,000_cells + HCMEC D3_line     32000
      6720  180     C  C01  41.98592 25,000_cells + HCMEC D3_line     32000
      6721  185     C  C01  43.20296 25,000_cells + HCMEC D3_line     32000
      6722  190     C  C01  44.21631 25,000_cells + HCMEC D3_line     32000
      6723  195     C  C01  45.26160 25,000_cells + HCMEC D3_line     32000
      6724  200     C  C01        NA 25,000_cells + HCMEC D3_line     32000
      6725    0     C  C01        NA 25,000_cells + HCMEC D3_line      4000
      6726    5     C  C01 107.69272 25,000_cells + HCMEC D3_line      4000
      6727   10     C  C01 103.15050 25,000_cells + HCMEC D3_line      4000
      6728   15     C  C01  97.85722 25,000_cells + HCMEC D3_line      4000
      6729   20     C  C01  92.72031 25,000_cells + HCMEC D3_line      4000
      6730   25     C  C01  89.80675 25,000_cells + HCMEC D3_line      4000
      6731   30     C  C01  88.31482 25,000_cells + HCMEC D3_line      4000
      6732   35     C  C01  87.46990 25,000_cells + HCMEC D3_line      4000
      6733   40     C  C01  86.07287 25,000_cells + HCMEC D3_line      4000
      6734   45     C  C01  85.19493 25,000_cells + HCMEC D3_line      4000
      6735   50     C  C01  85.27559 25,000_cells + HCMEC D3_line      4000
      6736   55     C  C01  86.46035 25,000_cells + HCMEC D3_line      4000
      6737   60     C  C01  88.77434 25,000_cells + HCMEC D3_line      4000
      6738   65     C  C01  91.08243 25,000_cells + HCMEC D3_line      4000
      6739   70     C  C01  92.46237 25,000_cells + HCMEC D3_line      4000
      6740   75     C  C01  93.99473 25,000_cells + HCMEC D3_line      4000
      6741   80     C  C01  94.86362 25,000_cells + HCMEC D3_line      4000
      6742   85     C  C01  95.59868 25,000_cells + HCMEC D3_line      4000
      6743   90     C  C01  96.27549 25,000_cells + HCMEC D3_line      4000
      6744   95     C  C01  97.39506 25,000_cells + HCMEC D3_line      4000
      6745  100     C  C01  97.99037 25,000_cells + HCMEC D3_line      4000
      6746  105     C  C01  99.16970 25,000_cells + HCMEC D3_line      4000
      6747  110     C  C01 100.37531 25,000_cells + HCMEC D3_line      4000
      6748  115     C  C01 101.26624 25,000_cells + HCMEC D3_line      4000
      6749  120     C  C01 102.10279 25,000_cells + HCMEC D3_line      4000
      6750  125     C  C01 102.90683 25,000_cells + HCMEC D3_line      4000
      6751  130     C  C01 103.44056 25,000_cells + HCMEC D3_line      4000
      6752  135     C  C01 104.04892 25,000_cells + HCMEC D3_line      4000
      6753  140     C  C01 104.83087 25,000_cells + HCMEC D3_line      4000
      6754  145     C  C01 105.37493 25,000_cells + HCMEC D3_line      4000
      6755  150     C  C01 106.44577 25,000_cells + HCMEC D3_line      4000
      6756  155     C  C01 107.17714 25,000_cells + HCMEC D3_line      4000
      6757  160     C  C01 107.78594 25,000_cells + HCMEC D3_line      4000
      6758  165     C  C01 108.55964 25,000_cells + HCMEC D3_line      4000
      6759  170     C  C01 109.37371 25,000_cells + HCMEC D3_line      4000
      6760  175     C  C01 109.89516 25,000_cells + HCMEC D3_line      4000
      6761  180     C  C01 110.63773 25,000_cells + HCMEC D3_line      4000
      6762  185     C  C01 111.05385 25,000_cells + HCMEC D3_line      4000
      6763  190     C  C01 111.53210 25,000_cells + HCMEC D3_line      4000
      6764  195     C  C01 112.09450 25,000_cells + HCMEC D3_line      4000
      6765  200     C  C01        NA 25,000_cells + HCMEC D3_line      4000
      6766    0     C  C01        NA 25,000_cells + HCMEC D3_line       500
      6767    5     C  C01 120.78287 25,000_cells + HCMEC D3_line       500
      6768   10     C  C01 120.55659 25,000_cells + HCMEC D3_line       500
      6769   15     C  C01 120.23225 25,000_cells + HCMEC D3_line       500
      6770   20     C  C01 119.91406 25,000_cells + HCMEC D3_line       500
      6771   25     C  C01 119.79546 25,000_cells + HCMEC D3_line       500
      6772   30     C  C01 119.91610 25,000_cells + HCMEC D3_line       500
      6773   35     C  C01 120.16264 25,000_cells + HCMEC D3_line       500
      6774   40     C  C01 120.38355 25,000_cells + HCMEC D3_line       500
      6775   45     C  C01 120.60149 25,000_cells + HCMEC D3_line       500
      6776   50     C  C01 121.02454 25,000_cells + HCMEC D3_line       500
      6777   55     C  C01 121.26546 25,000_cells + HCMEC D3_line       500
      6778   60     C  C01 121.84008 25,000_cells + HCMEC D3_line       500
      6779   65     C  C01 122.28055 25,000_cells + HCMEC D3_line       500
      6780   70     C  C01 122.62583 25,000_cells + HCMEC D3_line       500
      6781   75     C  C01 123.00290 25,000_cells + HCMEC D3_line       500
      6782   80     C  C01 123.30096 25,000_cells + HCMEC D3_line       500
      6783   85     C  C01 123.52140 25,000_cells + HCMEC D3_line       500
      6784   90     C  C01 123.72253 25,000_cells + HCMEC D3_line       500
      6785   95     C  C01 123.93791 25,000_cells + HCMEC D3_line       500
      6786  100     C  C01 124.07819 25,000_cells + HCMEC D3_line       500
      6787  105     C  C01 124.26892 25,000_cells + HCMEC D3_line       500
      6788  110     C  C01 124.46805 25,000_cells + HCMEC D3_line       500
      6789  115     C  C01 124.58224 25,000_cells + HCMEC D3_line       500
      6790  120     C  C01 124.74723 25,000_cells + HCMEC D3_line       500
      6791  125     C  C01 124.87988 25,000_cells + HCMEC D3_line       500
      6792  130     C  C01 124.97737 25,000_cells + HCMEC D3_line       500
      6793  135     C  C01 125.08528 25,000_cells + HCMEC D3_line       500
      6794  140     C  C01 125.19600 25,000_cells + HCMEC D3_line       500
      6795  145     C  C01 125.25833 25,000_cells + HCMEC D3_line       500
      6796  150     C  C01 125.40765 25,000_cells + HCMEC D3_line       500
      6797  155     C  C01 125.53736 25,000_cells + HCMEC D3_line       500
      6798  160     C  C01 125.61192 25,000_cells + HCMEC D3_line       500
      6799  165     C  C01 125.70158 25,000_cells + HCMEC D3_line       500
      6800  170     C  C01 125.80385 25,000_cells + HCMEC D3_line       500
      6801  175     C  C01 125.86798 25,000_cells + HCMEC D3_line       500
      6802  180     C  C01 125.94337 25,000_cells + HCMEC D3_line       500
      6803  185     C  C01 125.99624 25,000_cells + HCMEC D3_line       500
      6804  190     C  C01 126.03703 25,000_cells + HCMEC D3_line       500
      6805  195     C  C01 126.09847 25,000_cells + HCMEC D3_line       500
      6806  200     C  C01        NA 25,000_cells + HCMEC D3_line       500
      6807    0     C  C01        NA 25,000_cells + HCMEC D3_line     64000
      6808    5     C  C01  54.70134 25,000_cells + HCMEC D3_line     64000
      6809   10     C  C01  49.46644 25,000_cells + HCMEC D3_line     64000
      6810   15     C  C01  43.25482 25,000_cells + HCMEC D3_line     64000
      6811   20     C  C01  37.37697 25,000_cells + HCMEC D3_line     64000
      6812   25     C  C01  33.16469 25,000_cells + HCMEC D3_line     64000
      6813   30     C  C01  30.78922 25,000_cells + HCMEC D3_line     64000
      6814   35     C  C01  28.75843 25,000_cells + HCMEC D3_line     64000
      6815   40     C  C01  26.22846 25,000_cells + HCMEC D3_line     64000
      6816   45     C  C01  22.50425 25,000_cells + HCMEC D3_line     64000
      6817   50     C  C01  18.95996 25,000_cells + HCMEC D3_line     64000
      6818   55     C  C01  15.67067 25,000_cells + HCMEC D3_line     64000
      6819   60     C  C01  13.03936 25,000_cells + HCMEC D3_line     64000
      6820   65     C  C01  11.55486 25,000_cells + HCMEC D3_line     64000
      6821   70     C  C01  10.72494 25,000_cells + HCMEC D3_line     64000
      6822   75     C  C01  10.81915 25,000_cells + HCMEC D3_line     64000
      6823   80     C  C01  10.81681 25,000_cells + HCMEC D3_line     64000
      6824   85     C  C01  10.94850 25,000_cells + HCMEC D3_line     64000
      6825   90     C  C01  11.17962 25,000_cells + HCMEC D3_line     64000
      6826   95     C  C01  11.54944 25,000_cells + HCMEC D3_line     64000
      6827  100     C  C01  11.71555 25,000_cells + HCMEC D3_line     64000
      6828  105     C  C01  12.22379 25,000_cells + HCMEC D3_line     64000
      6829  110     C  C01  12.56472 25,000_cells + HCMEC D3_line     64000
      6830  115     C  C01  12.95618 25,000_cells + HCMEC D3_line     64000
      6831  120     C  C01  13.46340 25,000_cells + HCMEC D3_line     64000
      6832  125     C  C01  13.98091 25,000_cells + HCMEC D3_line     64000
      6833  130     C  C01  14.46953 25,000_cells + HCMEC D3_line     64000
      6834  135     C  C01  15.03051 25,000_cells + HCMEC D3_line     64000
      6835  140     C  C01  15.67922 25,000_cells + HCMEC D3_line     64000
      6836  145     C  C01  16.38253 25,000_cells + HCMEC D3_line     64000
      6837  150     C  C01  17.17575 25,000_cells + HCMEC D3_line     64000
      6838  155     C  C01  17.55419 25,000_cells + HCMEC D3_line     64000
      6839  160     C  C01  18.46561 25,000_cells + HCMEC D3_line     64000
      6840  165     C  C01  18.99394 25,000_cells + HCMEC D3_line     64000
      6841  170     C  C01  19.98630 25,000_cells + HCMEC D3_line     64000
      6842  175     C  C01  20.44745 25,000_cells + HCMEC D3_line     64000
      6843  180     C  C01  21.44724 25,000_cells + HCMEC D3_line     64000
      6844  185     C  C01  22.24970 25,000_cells + HCMEC D3_line     64000
      6845  190     C  C01  22.87220 25,000_cells + HCMEC D3_line     64000
      6846  195     C  C01  23.88511 25,000_cells + HCMEC D3_line     64000
      6847  200     C  C01        NA 25,000_cells + HCMEC D3_line     64000
      6848    0     C  C01        NA 25,000_cells + HCMEC D3_line      8000
      6849    5     C  C01  97.65125 25,000_cells + HCMEC D3_line      8000
      6850   10     C  C01  91.21680 25,000_cells + HCMEC D3_line      8000
      6851   15     C  C01  83.86100 25,000_cells + HCMEC D3_line      8000
      6852   20     C  C01  76.88011 25,000_cells + HCMEC D3_line      8000
      6853   25     C  C01  72.67757 25,000_cells + HCMEC D3_line      8000
      6854   30     C  C01  70.40954 25,000_cells + HCMEC D3_line      8000
      6855   35     C  C01  68.57570 25,000_cells + HCMEC D3_line      8000
      6856   40     C  C01  66.13199 25,000_cells + HCMEC D3_line      8000
      6857   45     C  C01  63.87771 25,000_cells + HCMEC D3_line      8000
      6858   50     C  C01  62.43061 25,000_cells + HCMEC D3_line      8000
      6859   55     C  C01  62.85524 25,000_cells + HCMEC D3_line      8000
      6860   60     C  C01  64.38270 25,000_cells + HCMEC D3_line      8000
      6861   65     C  C01  66.50341 25,000_cells + HCMEC D3_line      8000
      6862   70     C  C01  67.58649 25,000_cells + HCMEC D3_line      8000
      6863   75     C  C01  69.19566 25,000_cells + HCMEC D3_line      8000
      6864   80     C  C01  70.08779 25,000_cells + HCMEC D3_line      8000
      6865   85     C  C01  70.85470 25,000_cells + HCMEC D3_line      8000
      6866   90     C  C01  71.71559 25,000_cells + HCMEC D3_line      8000
      6867   95     C  C01  73.28572 25,000_cells + HCMEC D3_line      8000
      6868  100     C  C01  74.19059 25,000_cells + HCMEC D3_line      8000
      6869  105     C  C01  75.91866 25,000_cells + HCMEC D3_line      8000
      6870  110     C  C01  77.54315 25,000_cells + HCMEC D3_line      8000
      6871  115     C  C01  78.88289 25,000_cells + HCMEC D3_line      8000
      6872  120     C  C01  80.05956 25,000_cells + HCMEC D3_line      8000
      6873  125     C  C01  81.24359 25,000_cells + HCMEC D3_line      8000
      6874  130     C  C01  82.24018 25,000_cells + HCMEC D3_line      8000
      6875  135     C  C01  83.28776 25,000_cells + HCMEC D3_line      8000
      6876  140     C  C01  84.64003 25,000_cells + HCMEC D3_line      8000
      6877  145     C  C01  85.81907 25,000_cells + HCMEC D3_line      8000
      6878  150     C  C01  87.26042 25,000_cells + HCMEC D3_line      8000
      6879  155     C  C01  88.19381 25,000_cells + HCMEC D3_line      8000
      6880  160     C  C01  89.31076 25,000_cells + HCMEC D3_line      8000
      6881  165     C  C01  90.47065 25,000_cells + HCMEC D3_line      8000
      6882  170     C  C01  91.69476 25,000_cells + HCMEC D3_line      8000
      6883  175     C  C01  92.39902 25,000_cells + HCMEC D3_line      8000
      6884  180     C  C01  93.48357 25,000_cells + HCMEC D3_line      8000
      6885  185     C  C01  94.15245 25,000_cells + HCMEC D3_line      8000
      6886  190     C  C01  94.84738 25,000_cells + HCMEC D3_line      8000
      6887  195     C  C01  95.50418 25,000_cells + HCMEC D3_line      8000
      6888  200     C  C01        NA 25,000_cells + HCMEC D3_line      8000
      6889    0     C  C02        NA 25,000_cells + HCMEC D3_line      1000
      6890    5     C  C02 117.70803 25,000_cells + HCMEC D3_line      1000
      6891   10     C  C02 116.90740 25,000_cells + HCMEC D3_line      1000
      6892   15     C  C02 115.70348 25,000_cells + HCMEC D3_line      1000
      6893   20     C  C02 115.02346 25,000_cells + HCMEC D3_line      1000
      6894   25     C  C02 114.27553 25,000_cells + HCMEC D3_line      1000
      6895   30     C  C02 114.13410 25,000_cells + HCMEC D3_line      1000
      6896   35     C  C02 114.42870 25,000_cells + HCMEC D3_line      1000
      6897   40     C  C02 114.71191 25,000_cells + HCMEC D3_line      1000
      6898   45     C  C02 115.13496 25,000_cells + HCMEC D3_line      1000
      6899   50     C  C02 115.54587 25,000_cells + HCMEC D3_line      1000
      6900   55     C  C02 116.39732 25,000_cells + HCMEC D3_line      1000
      6901   60     C  C02 116.93491 25,000_cells + HCMEC D3_line      1000
      6902   65     C  C02 117.73111 25,000_cells + HCMEC D3_line      1000
      6903   70     C  C02 118.15695 25,000_cells + HCMEC D3_line      1000
      6904   75     C  C02 118.68590 25,000_cells + HCMEC D3_line      1000
      6905   80     C  C02 119.30338 25,000_cells + HCMEC D3_line      1000
      6906   85     C  C02 119.61410 25,000_cells + HCMEC D3_line      1000
      6907   90     C  C02 119.80867 25,000_cells + HCMEC D3_line      1000
      6908   95     C  C02 120.06611 25,000_cells + HCMEC D3_line      1000
      6909  100     C  C02 120.33420 25,000_cells + HCMEC D3_line      1000
      6910  105     C  C02 120.48908 25,000_cells + HCMEC D3_line      1000
      6911  110     C  C02 120.79891 25,000_cells + HCMEC D3_line      1000
      6912  115     C  C02 121.11441 25,000_cells + HCMEC D3_line      1000
      6913  120     C  C02 121.33385 25,000_cells + HCMEC D3_line      1000
      6914  125     C  C02 121.48797 25,000_cells + HCMEC D3_line      1000
      6915  130     C  C02 121.65797 25,000_cells + HCMEC D3_line      1000
      6916  135     C  C02 121.99231 25,000_cells + HCMEC D3_line      1000
      6917  140     C  C02 122.13837 25,000_cells + HCMEC D3_line      1000
      6918  145     C  C02 122.32567 25,000_cells + HCMEC D3_line      1000
      6919  150     C  C02 122.50768 25,000_cells + HCMEC D3_line      1000
      6920  155     C  C02 122.59149 25,000_cells + HCMEC D3_line      1000
      6921  160     C  C02 122.70636 25,000_cells + HCMEC D3_line      1000
      6922  165     C  C02 122.89771 25,000_cells + HCMEC D3_line      1000
      6923  170     C  C02 122.98584 25,000_cells + HCMEC D3_line      1000
      6924  175     C  C02 123.17184 25,000_cells + HCMEC D3_line      1000
      6925  180     C  C02 123.44513 25,000_cells + HCMEC D3_line      1000
      6926  185     C  C02 123.60477 25,000_cells + HCMEC D3_line      1000
      6927  190     C  C02 123.61440 25,000_cells + HCMEC D3_line      1000
      6928  195     C  C02 123.69599 25,000_cells + HCMEC D3_line      1000
      6929  200     C  C02        NA 25,000_cells + HCMEC D3_line      1000
      6930    0     C  C02        NA 25,000_cells + HCMEC D3_line     16000
      6931    5     C  C02  84.40516 25,000_cells + HCMEC D3_line     16000
      6932   10     C  C02  76.97338 25,000_cells + HCMEC D3_line     16000
      6933   15     C  C02  68.29495 25,000_cells + HCMEC D3_line     16000
      6934   20     C  C02  61.60130 25,000_cells + HCMEC D3_line     16000
      6935   25     C  C02  56.26264 25,000_cells + HCMEC D3_line     16000
      6936   30     C  C02  52.10084 25,000_cells + HCMEC D3_line     16000
      6937   35     C  C02  50.11411 25,000_cells + HCMEC D3_line     16000
      6938   40     C  C02  47.81387 25,000_cells + HCMEC D3_line     16000
      6939   45     C  C02  44.62580 25,000_cells + HCMEC D3_line     16000
      6940   50     C  C02  42.49268 25,000_cells + HCMEC D3_line     16000
      6941   55     C  C02  41.63425 25,000_cells + HCMEC D3_line     16000
      6942   60     C  C02  40.83627 25,000_cells + HCMEC D3_line     16000
      6943   65     C  C02  40.91032 25,000_cells + HCMEC D3_line     16000
      6944   70     C  C02  41.38565 25,000_cells + HCMEC D3_line     16000
      6945   75     C  C02  41.49712 25,000_cells + HCMEC D3_line     16000
      6946   80     C  C02  42.49018 25,000_cells + HCMEC D3_line     16000
      6947   85     C  C02  43.37279 25,000_cells + HCMEC D3_line     16000
      6948   90     C  C02  43.55283 25,000_cells + HCMEC D3_line     16000
      6949   95     C  C02  44.83388 25,000_cells + HCMEC D3_line     16000
      6950  100     C  C02  46.05438 25,000_cells + HCMEC D3_line     16000
      6951  105     C  C02  46.79323 25,000_cells + HCMEC D3_line     16000
      6952  110     C  C02  48.28164 25,000_cells + HCMEC D3_line     16000
      6953  115     C  C02  49.80669 25,000_cells + HCMEC D3_line     16000
      6954  120     C  C02  51.01273 25,000_cells + HCMEC D3_line     16000
      6955  125     C  C02  52.79209 25,000_cells + HCMEC D3_line     16000
      6956  130     C  C02  54.26765 25,000_cells + HCMEC D3_line     16000
      6957  135     C  C02  55.94536 25,000_cells + HCMEC D3_line     16000
      6958  140     C  C02  57.37509 25,000_cells + HCMEC D3_line     16000
      6959  145     C  C02  59.26354 25,000_cells + HCMEC D3_line     16000
      6960  150     C  C02  60.87606 25,000_cells + HCMEC D3_line     16000
      6961  155     C  C02  62.25698 25,000_cells + HCMEC D3_line     16000
      6962  160     C  C02  63.27177 25,000_cells + HCMEC D3_line     16000
      6963  165     C  C02  64.87112 25,000_cells + HCMEC D3_line     16000
      6964  170     C  C02  66.17017 25,000_cells + HCMEC D3_line     16000
      6965  175     C  C02  67.43816 25,000_cells + HCMEC D3_line     16000
      6966  180     C  C02  69.01273 25,000_cells + HCMEC D3_line     16000
      6967  185     C  C02  70.23961 25,000_cells + HCMEC D3_line     16000
      6968  190     C  C02  71.32053 25,000_cells + HCMEC D3_line     16000
      6969  195     C  C02  72.21162 25,000_cells + HCMEC D3_line     16000
      6970  200     C  C02        NA 25,000_cells + HCMEC D3_line     16000
      6971    0     C  C02        NA 25,000_cells + HCMEC D3_line      2000
      6972    5     C  C02 113.54420 25,000_cells + HCMEC D3_line      2000
      6973   10     C  C02 111.16091 25,000_cells + HCMEC D3_line      2000
      6974   15     C  C02 107.97012 25,000_cells + HCMEC D3_line      2000
      6975   20     C  C02 106.08511 25,000_cells + HCMEC D3_line      2000
      6976   25     C  C02 104.18632 25,000_cells + HCMEC D3_line      2000
      6977   30     C  C02 103.40732 25,000_cells + HCMEC D3_line      2000
      6978   35     C  C02 103.39585 25,000_cells + HCMEC D3_line      2000
      6979   40     C  C02 103.41529 25,000_cells + HCMEC D3_line      2000
      6980   45     C  C02 103.58275 25,000_cells + HCMEC D3_line      2000
      6981   50     C  C02 104.10850 25,000_cells + HCMEC D3_line      2000
      6982   55     C  C02 105.84485 25,000_cells + HCMEC D3_line      2000
      6983   60     C  C02 106.77474 25,000_cells + HCMEC D3_line      2000
      6984   65     C  C02 108.18281 25,000_cells + HCMEC D3_line      2000
      6985   70     C  C02 108.97474 25,000_cells + HCMEC D3_line      2000
      6986   75     C  C02 109.88172 25,000_cells + HCMEC D3_line      2000
      6987   80     C  C02 110.87894 25,000_cells + HCMEC D3_line      2000
      6988   85     C  C02 111.41009 25,000_cells + HCMEC D3_line      2000
      6989   90     C  C02 111.70231 25,000_cells + HCMEC D3_line      2000
      6990   95     C  C02 112.18416 25,000_cells + HCMEC D3_line      2000
      6991  100     C  C02 112.57531 25,000_cells + HCMEC D3_line      2000
      6992  105     C  C02 112.78851 25,000_cells + HCMEC D3_line      2000
      6993  110     C  C02 113.42272 25,000_cells + HCMEC D3_line      2000
      6994  115     C  C02 114.08795 25,000_cells + HCMEC D3_line      2000
      6995  120     C  C02 114.55247 25,000_cells + HCMEC D3_line      2000
      6996  125     C  C02 114.87628 25,000_cells + HCMEC D3_line      2000
      6997  130     C  C02 115.29311 25,000_cells + HCMEC D3_line      2000
      6998  135     C  C02 115.98623 25,000_cells + HCMEC D3_line      2000
      6999  140     C  C02 116.30611 25,000_cells + HCMEC D3_line      2000
      7000  145     C  C02 116.75072 25,000_cells + HCMEC D3_line      2000
      7001  150     C  C02 117.19376 25,000_cells + HCMEC D3_line      2000
      7002  155     C  C02 117.45392 25,000_cells + HCMEC D3_line      2000
      7003  160     C  C02 117.70459 25,000_cells + HCMEC D3_line      2000
      7004  165     C  C02 118.15620 25,000_cells + HCMEC D3_line      2000
      7005  170     C  C02 118.41736 25,000_cells + HCMEC D3_line      2000
      7006  175     C  C02 118.79396 25,000_cells + HCMEC D3_line      2000
      7007  180     C  C02 119.39163 25,000_cells + HCMEC D3_line      2000
      7008  185     C  C02 119.75910 25,000_cells + HCMEC D3_line      2000
      7009  190     C  C02 119.87475 25,000_cells + HCMEC D3_line      2000
      7010  195     C  C02 120.12335 25,000_cells + HCMEC D3_line      2000
      7011  200     C  C02        NA 25,000_cells + HCMEC D3_line      2000
      7012    0     C  C02        NA 25,000_cells + HCMEC D3_line       250
      7013    5     C  C02 122.82796 25,000_cells + HCMEC D3_line       250
      7014   10     C  C02 122.67108 25,000_cells + HCMEC D3_line       250
      7015   15     C  C02 122.47325 25,000_cells + HCMEC D3_line       250
      7016   20     C  C02 122.40576 25,000_cells + HCMEC D3_line       250
      7017   25     C  C02 122.40945 25,000_cells + HCMEC D3_line       250
      7018   30     C  C02 122.49704 25,000_cells + HCMEC D3_line       250
      7019   35     C  C02 122.74662 25,000_cells + HCMEC D3_line       250
      7020   40     C  C02 122.99281 25,000_cells + HCMEC D3_line       250
      7021   45     C  C02 123.27349 25,000_cells + HCMEC D3_line       250
      7022   50     C  C02 123.50732 25,000_cells + HCMEC D3_line       250
      7023   55     C  C02 123.76414 25,000_cells + HCMEC D3_line       250
      7024   60     C  C02 124.04094 25,000_cells + HCMEC D3_line       250
      7025   65     C  C02 124.32992 25,000_cells + HCMEC D3_line       250
      7026   70     C  C02 124.55751 25,000_cells + HCMEC D3_line       250
      7027   75     C  C02 124.77990 25,000_cells + HCMEC D3_line       250
      7028   80     C  C02 125.01068 25,000_cells + HCMEC D3_line       250
      7029   85     C  C02 125.17139 25,000_cells + HCMEC D3_line       250
      7030   90     C  C02 125.32814 25,000_cells + HCMEC D3_line       250
      7031   95     C  C02 125.47402 25,000_cells + HCMEC D3_line       250
      7032  100     C  C02 125.59650 25,000_cells + HCMEC D3_line       250
      7033  105     C  C02 125.72798 25,000_cells + HCMEC D3_line       250
      7034  110     C  C02 125.84964 25,000_cells + HCMEC D3_line       250
      7035  115     C  C02 125.94348 25,000_cells + HCMEC D3_line       250
      7036  120     C  C02 126.06401 25,000_cells + HCMEC D3_line       250
      7037  125     C  C02 126.15272 25,000_cells + HCMEC D3_line       250
      7038  130     C  C02 126.20953 25,000_cells + HCMEC D3_line       250
      7039  135     C  C02 126.30973 25,000_cells + HCMEC D3_line       250
      7040  140     C  C02 126.38115 25,000_cells + HCMEC D3_line       250
      7041  145     C  C02 126.45458 25,000_cells + HCMEC D3_line       250
      7042  150     C  C02 126.52712 25,000_cells + HCMEC D3_line       250
      7043  155     C  C02 126.57633 25,000_cells + HCMEC D3_line       250
      7044  160     C  C02 126.63437 25,000_cells + HCMEC D3_line       250
      7045  165     C  C02 126.67690 25,000_cells + HCMEC D3_line       250
      7046  170     C  C02 126.72864 25,000_cells + HCMEC D3_line       250
      7047  175     C  C02 126.78763 25,000_cells + HCMEC D3_line       250
      7048  180     C  C02 126.84020 25,000_cells + HCMEC D3_line       250
      7049  185     C  C02 126.87991 25,000_cells + HCMEC D3_line       250
      7050  190     C  C02 126.89755 25,000_cells + HCMEC D3_line       250
      7051  195     C  C02 126.92316 25,000_cells + HCMEC D3_line       250
      7052  200     C  C02        NA 25,000_cells + HCMEC D3_line       250
      7053    0     C  C02        NA 25,000_cells + HCMEC D3_line     32000
      7054    5     C  C02  71.73581 25,000_cells + HCMEC D3_line     32000
      7055   10     C  C02  64.13532 25,000_cells + HCMEC D3_line     32000
      7056   15     C  C02  55.67558 25,000_cells + HCMEC D3_line     32000
      7057   20     C  C02  48.94287 25,000_cells + HCMEC D3_line     32000
      7058   25     C  C02  43.77491 25,000_cells + HCMEC D3_line     32000
      7059   30     C  C02  39.37446 25,000_cells + HCMEC D3_line     32000
      7060   35     C  C02  37.06588 25,000_cells + HCMEC D3_line     32000
      7061   40     C  C02  34.67453 25,000_cells + HCMEC D3_line     32000
      7062   45     C  C02  30.75043 25,000_cells + HCMEC D3_line     32000
      7063   50     C  C02  27.85945 25,000_cells + HCMEC D3_line     32000
      7064   55     C  C02  24.81098 25,000_cells + HCMEC D3_line     32000
      7065   60     C  C02  22.98208 25,000_cells + HCMEC D3_line     32000
      7066   65     C  C02  21.80206 25,000_cells + HCMEC D3_line     32000
      7067   70     C  C02  21.50548 25,000_cells + HCMEC D3_line     32000
      7068   75     C  C02  21.25554 25,000_cells + HCMEC D3_line     32000
      7069   80     C  C02  21.66904 25,000_cells + HCMEC D3_line     32000
      7070   85     C  C02  22.05436 25,000_cells + HCMEC D3_line     32000
      7071   90     C  C02  22.08855 25,000_cells + HCMEC D3_line     32000
      7072   95     C  C02  22.82546 25,000_cells + HCMEC D3_line     32000
      7073  100     C  C02  23.65810 25,000_cells + HCMEC D3_line     32000
      7074  105     C  C02  24.21205 25,000_cells + HCMEC D3_line     32000
      7075  110     C  C02  25.05369 25,000_cells + HCMEC D3_line     32000
      7076  115     C  C02  26.00018 25,000_cells + HCMEC D3_line     32000
      7077  120     C  C02  26.88746 25,000_cells + HCMEC D3_line     32000
      7078  125     C  C02  28.23141 25,000_cells + HCMEC D3_line     32000
      7079  130     C  C02  29.36704 25,000_cells + HCMEC D3_line     32000
      7080  135     C  C02  30.54716 25,000_cells + HCMEC D3_line     32000
      7081  140     C  C02  31.70302 25,000_cells + HCMEC D3_line     32000
      7082  145     C  C02  33.09063 25,000_cells + HCMEC D3_line     32000
      7083  150     C  C02  34.40526 25,000_cells + HCMEC D3_line     32000
      7084  155     C  C02  35.72279 25,000_cells + HCMEC D3_line     32000
      7085  160     C  C02  36.84834 25,000_cells + HCMEC D3_line     32000
      7086  165     C  C02  38.07694 25,000_cells + HCMEC D3_line     32000
      7087  170     C  C02  39.26402 25,000_cells + HCMEC D3_line     32000
      7088  175     C  C02  40.48704 25,000_cells + HCMEC D3_line     32000
      7089  180     C  C02  42.10669 25,000_cells + HCMEC D3_line     32000
      7090  185     C  C02  43.13289 25,000_cells + HCMEC D3_line     32000
      7091  190     C  C02  44.35412 25,000_cells + HCMEC D3_line     32000
      7092  195     C  C02  45.39834 25,000_cells + HCMEC D3_line     32000
      7093  200     C  C02        NA 25,000_cells + HCMEC D3_line     32000
      7094    0     C  C02        NA 25,000_cells + HCMEC D3_line      4000
      7095    5     C  C02 106.34090 25,000_cells + HCMEC D3_line      4000
      7096   10     C  C02 101.93033 25,000_cells + HCMEC D3_line      4000
      7097   15     C  C02  96.22381 25,000_cells + HCMEC D3_line      4000
      7098   20     C  C02  92.57134 25,000_cells + HCMEC D3_line      4000
      7099   25     C  C02  89.28726 25,000_cells + HCMEC D3_line      4000
      7100   30     C  C02  87.42862 25,000_cells + HCMEC D3_line      4000
      7101   35     C  C02  86.90308 25,000_cells + HCMEC D3_line      4000
      7102   40     C  C02  86.23552 25,000_cells + HCMEC D3_line      4000
      7103   45     C  C02  85.70753 25,000_cells + HCMEC D3_line      4000
      7104   50     C  C02  85.89297 25,000_cells + HCMEC D3_line      4000
      7105   55     C  C02  88.28365 25,000_cells + HCMEC D3_line      4000
      7106   60     C  C02  89.47069 25,000_cells + HCMEC D3_line      4000
      7107   65     C  C02  91.42114 25,000_cells + HCMEC D3_line      4000
      7108   70     C  C02  92.66024 25,000_cells + HCMEC D3_line      4000
      7109   75     C  C02  93.84270 25,000_cells + HCMEC D3_line      4000
      7110   80     C  C02  95.28567 25,000_cells + HCMEC D3_line      4000
      7111   85     C  C02  96.19609 25,000_cells + HCMEC D3_line      4000
      7112   90     C  C02  96.62383 25,000_cells + HCMEC D3_line      4000
      7113   95     C  C02  97.58221 25,000_cells + HCMEC D3_line      4000
      7114  100     C  C02  98.31236 25,000_cells + HCMEC D3_line      4000
      7115  105     C  C02  98.71832 25,000_cells + HCMEC D3_line      4000
      7116  110     C  C02  99.84850 25,000_cells + HCMEC D3_line      4000
      7117  115     C  C02 100.94565 25,000_cells + HCMEC D3_line      4000
      7118  120     C  C02 101.68781 25,000_cells + HCMEC D3_line      4000
      7119  125     C  C02 102.33869 25,000_cells + HCMEC D3_line      4000
      7120  130     C  C02 103.11485 25,000_cells + HCMEC D3_line      4000
      7121  135     C  C02 104.20900 25,000_cells + HCMEC D3_line      4000
      7122  140     C  C02 104.81487 25,000_cells + HCMEC D3_line      4000
      7123  145     C  C02 105.67135 25,000_cells + HCMEC D3_line      4000
      7124  150     C  C02 106.49956 25,000_cells + HCMEC D3_line      4000
      7125  155     C  C02 107.03352 25,000_cells + HCMEC D3_line      4000
      7126  160     C  C02 107.47203 25,000_cells + HCMEC D3_line      4000
      7127  165     C  C02 108.30312 25,000_cells + HCMEC D3_line      4000
      7128  170     C  C02 108.87697 25,000_cells + HCMEC D3_line      4000
      7129  175     C  C02 109.46301 25,000_cells + HCMEC D3_line      4000
      7130  180     C  C02 110.39290 25,000_cells + HCMEC D3_line      4000
      7131  185     C  C02 111.10596 25,000_cells + HCMEC D3_line      4000
      7132  190     C  C02 111.41372 25,000_cells + HCMEC D3_line      4000
      7133  195     C  C02 111.81613 25,000_cells + HCMEC D3_line      4000
      7134  200     C  C02        NA 25,000_cells + HCMEC D3_line      4000
      7135    0     C  C02        NA 25,000_cells + HCMEC D3_line       500
      7136    5     C  C02 120.64100 25,000_cells + HCMEC D3_line       500
      7137   10     C  C02 120.41674 25,000_cells + HCMEC D3_line       500
      7138   15     C  C02 120.02286 25,000_cells + HCMEC D3_line       500
      7139   20     C  C02 119.82170 25,000_cells + HCMEC D3_line       500
      7140   25     C  C02 119.62660 25,000_cells + HCMEC D3_line       500
      7141   30     C  C02 119.69087 25,000_cells + HCMEC D3_line       500
      7142   35     C  C02 119.99737 25,000_cells + HCMEC D3_line       500
      7143   40     C  C02 120.29480 25,000_cells + HCMEC D3_line       500
      7144   45     C  C02 120.67753 25,000_cells + HCMEC D3_line       500
      7145   50     C  C02 120.96358 25,000_cells + HCMEC D3_line       500
      7146   55     C  C02 121.39682 25,000_cells + HCMEC D3_line       500
      7147   60     C  C02 121.75049 25,000_cells + HCMEC D3_line       500
      7148   65     C  C02 122.18384 25,000_cells + HCMEC D3_line       500
      7149   70     C  C02 122.46503 25,000_cells + HCMEC D3_line       500
      7150   75     C  C02 122.76761 25,000_cells + HCMEC D3_line       500
      7151   80     C  C02 123.10728 25,000_cells + HCMEC D3_line       500
      7152   85     C  C02 123.31170 25,000_cells + HCMEC D3_line       500
      7153   90     C  C02 123.47203 25,000_cells + HCMEC D3_line       500
      7154   95     C  C02 123.63334 25,000_cells + HCMEC D3_line       500
      7155  100     C  C02 123.80277 25,000_cells + HCMEC D3_line       500
      7156  105     C  C02 123.93529 25,000_cells + HCMEC D3_line       500
      7157  110     C  C02 124.09788 25,000_cells + HCMEC D3_line       500
      7158  115     C  C02 124.26583 25,000_cells + HCMEC D3_line       500
      7159  120     C  C02 124.39492 25,000_cells + HCMEC D3_line       500
      7160  125     C  C02 124.49326 25,000_cells + HCMEC D3_line       500
      7161  130     C  C02 124.59163 25,000_cells + HCMEC D3_line       500
      7162  135     C  C02 124.74285 25,000_cells + HCMEC D3_line       500
      7163  140     C  C02 124.83913 25,000_cells + HCMEC D3_line       500
      7164  145     C  C02 124.93932 25,000_cells + HCMEC D3_line       500
      7165  150     C  C02 125.02890 25,000_cells + HCMEC D3_line       500
      7166  155     C  C02 125.08368 25,000_cells + HCMEC D3_line       500
      7167  160     C  C02 125.14774 25,000_cells + HCMEC D3_line       500
      7168  165     C  C02 125.23920 25,000_cells + HCMEC D3_line       500
      7169  170     C  C02 125.28714 25,000_cells + HCMEC D3_line       500
      7170  175     C  C02 125.38092 25,000_cells + HCMEC D3_line       500
      7171  180     C  C02 125.49271 25,000_cells + HCMEC D3_line       500
      7172  185     C  C02 125.56232 25,000_cells + HCMEC D3_line       500
      7173  190     C  C02 125.55906 25,000_cells + HCMEC D3_line       500
      7174  195     C  C02 125.60037 25,000_cells + HCMEC D3_line       500
      7175  200     C  C02        NA 25,000_cells + HCMEC D3_line       500
      7176    0     C  C02        NA 25,000_cells + HCMEC D3_line     64000
      7177    5     C  C02  54.45206 25,000_cells + HCMEC D3_line     64000
      7178   10     C  C02  48.18728 25,000_cells + HCMEC D3_line     64000
      7179   15     C  C02  41.49570 25,000_cells + HCMEC D3_line     64000
      7180   20     C  C02  36.06491 25,000_cells + HCMEC D3_line     64000
      7181   25     C  C02  32.23353 25,000_cells + HCMEC D3_line     64000
      7182   30     C  C02  28.54222 25,000_cells + HCMEC D3_line     64000
      7183   35     C  C02  26.38594 25,000_cells + HCMEC D3_line     64000
      7184   40     C  C02  24.38645 25,000_cells + HCMEC D3_line     64000
      7185   45     C  C02  20.83631 25,000_cells + HCMEC D3_line     64000
      7186   50     C  C02  18.11951 25,000_cells + HCMEC D3_line     64000
      7187   55     C  C02  14.62832 25,000_cells + HCMEC D3_line     64000
      7188   60     C  C02  12.81325 25,000_cells + HCMEC D3_line     64000
      7189   65     C  C02  11.52762 25,000_cells + HCMEC D3_line     64000
      7190   70     C  C02  11.09406 25,000_cells + HCMEC D3_line     64000
      7191   75     C  C02  10.89085 25,000_cells + HCMEC D3_line     64000
      7192   80     C  C02  11.04345 25,000_cells + HCMEC D3_line     64000
      7193   85     C  C02  11.12412 25,000_cells + HCMEC D3_line     64000
      7194   90     C  C02  11.17582 25,000_cells + HCMEC D3_line     64000
      7195   95     C  C02  11.46311 25,000_cells + HCMEC D3_line     64000
      7196  100     C  C02  11.87419 25,000_cells + HCMEC D3_line     64000
      7197  105     C  C02  12.14129 25,000_cells + HCMEC D3_line     64000
      7198  110     C  C02  12.43964 25,000_cells + HCMEC D3_line     64000
      7199  115     C  C02  12.84904 25,000_cells + HCMEC D3_line     64000
      7200  120     C  C02  13.30167 25,000_cells + HCMEC D3_line     64000
      7201  125     C  C02  13.92143 25,000_cells + HCMEC D3_line     64000
      7202  130     C  C02  14.54958 25,000_cells + HCMEC D3_line     64000
      7203  135     C  C02  15.03757 25,000_cells + HCMEC D3_line     64000
      7204  140     C  C02  15.67239 25,000_cells + HCMEC D3_line     64000
      7205  145     C  C02  16.24002 25,000_cells + HCMEC D3_line     64000
      7206  150     C  C02  16.93643 25,000_cells + HCMEC D3_line     64000
      7207  155     C  C02  17.68563 25,000_cells + HCMEC D3_line     64000
      7208  160     C  C02  18.43072 25,000_cells + HCMEC D3_line     64000
      7209  165     C  C02  18.99445 25,000_cells + HCMEC D3_line     64000
      7210  170     C  C02  19.68497 25,000_cells + HCMEC D3_line     64000
      7211  175     C  C02  20.40215 25,000_cells + HCMEC D3_line     64000
      7212  180     C  C02  21.52895 25,000_cells + HCMEC D3_line     64000
      7213  185     C  C02  22.05177 25,000_cells + HCMEC D3_line     64000
      7214  190     C  C02  22.85598 25,000_cells + HCMEC D3_line     64000
      7215  195     C  C02  23.70310 25,000_cells + HCMEC D3_line     64000
      7216  200     C  C02        NA 25,000_cells + HCMEC D3_line     64000
      7217    0     C  C02        NA 25,000_cells + HCMEC D3_line      8000
      7218    5     C  C02  95.72708 25,000_cells + HCMEC D3_line      8000
      7219   10     C  C02  89.38786 25,000_cells + HCMEC D3_line      8000
      7220   15     C  C02  81.74106 25,000_cells + HCMEC D3_line      8000
      7221   20     C  C02  76.32993 25,000_cells + HCMEC D3_line      8000
      7222   25     C  C02  71.78476 25,000_cells + HCMEC D3_line      8000
      7223   30     C  C02  68.68716 25,000_cells + HCMEC D3_line      8000
      7224   35     C  C02  67.41146 25,000_cells + HCMEC D3_line      8000
      7225   40     C  C02  65.73475 25,000_cells + HCMEC D3_line      8000
      7226   45     C  C02  63.90646 25,000_cells + HCMEC D3_line      8000
      7227   50     C  C02  63.06509 25,000_cells + HCMEC D3_line      8000
      7228   55     C  C02  64.67215 25,000_cells + HCMEC D3_line      8000
      7229   60     C  C02  65.34944 25,000_cells + HCMEC D3_line      8000
      7230   65     C  C02  66.94598 25,000_cells + HCMEC D3_line      8000
      7231   70     C  C02  68.22094 25,000_cells + HCMEC D3_line      8000
      7232   75     C  C02  69.05679 25,000_cells + HCMEC D3_line      8000
      7233   80     C  C02  70.59028 25,000_cells + HCMEC D3_line      8000
      7234   85     C  C02  71.70490 25,000_cells + HCMEC D3_line      8000
      7235   90     C  C02  72.12885 25,000_cells + HCMEC D3_line      8000
      7236   95     C  C02  73.46654 25,000_cells + HCMEC D3_line      8000
      7237  100     C  C02  74.59447 25,000_cells + HCMEC D3_line      8000
      7238  105     C  C02  75.20802 25,000_cells + HCMEC D3_line      8000
      7239  110     C  C02  76.79847 25,000_cells + HCMEC D3_line      8000
      7240  115     C  C02  78.33472 25,000_cells + HCMEC D3_line      8000
      7241  120     C  C02  79.40618 25,000_cells + HCMEC D3_line      8000
      7242  125     C  C02  80.71757 25,000_cells + HCMEC D3_line      8000
      7243  130     C  C02  81.95080 25,000_cells + HCMEC D3_line      8000
      7244  135     C  C02  83.47123 25,000_cells + HCMEC D3_line      8000
      7245  140     C  C02  84.55500 25,000_cells + HCMEC D3_line      8000
      7246  145     C  C02  86.04408 25,000_cells + HCMEC D3_line      8000
      7247  150     C  C02  87.36400 25,000_cells + HCMEC D3_line      8000
      7248  155     C  C02  88.35755 25,000_cells + HCMEC D3_line      8000
      7249  160     C  C02  89.04440 25,000_cells + HCMEC D3_line      8000
      7250  165     C  C02  90.37624 25,000_cells + HCMEC D3_line      8000
      7251  170     C  C02  91.40117 25,000_cells + HCMEC D3_line      8000
      7252  175     C  C02  92.29191 25,000_cells + HCMEC D3_line      8000
      7253  180     C  C02  93.50613 25,000_cells + HCMEC D3_line      8000
      7254  185     C  C02  94.55223 25,000_cells + HCMEC D3_line      8000
      7255  190     C  C02  95.18211 25,000_cells + HCMEC D3_line      8000
      7256  195     C  C02  95.73448 25,000_cells + HCMEC D3_line      8000
      7257  200     C  C02        NA 25,000_cells + HCMEC D3_line      8000
      7258    0     C  C03        NA 25,000_cells + HCMEC D3_line      1000
      7259    5     C  C03 118.24939 25,000_cells + HCMEC D3_line      1000
      7260   10     C  C03 117.76417 25,000_cells + HCMEC D3_line      1000
      7261   15     C  C03 116.84750 25,000_cells + HCMEC D3_line      1000
      7262   20     C  C03 116.12553 25,000_cells + HCMEC D3_line      1000
      7263   25     C  C03 115.69914 25,000_cells + HCMEC D3_line      1000
      7264   30     C  C03 115.34104 25,000_cells + HCMEC D3_line      1000
      7265   35     C  C03 115.65920 25,000_cells + HCMEC D3_line      1000
      7266   40     C  C03 115.88392 25,000_cells + HCMEC D3_line      1000
      7267   45     C  C03 116.02732 25,000_cells + HCMEC D3_line      1000
      7268   50     C  C03 116.35170 25,000_cells + HCMEC D3_line      1000
      7269   55     C  C03 116.62171 25,000_cells + HCMEC D3_line      1000
      7270   60     C  C03 117.58845 25,000_cells + HCMEC D3_line      1000
      7271   65     C  C03 118.26795 25,000_cells + HCMEC D3_line      1000
      7272   70     C  C03 118.90772 25,000_cells + HCMEC D3_line      1000
      7273   75     C  C03 119.40413 25,000_cells + HCMEC D3_line      1000
      7274   80     C  C03 119.87722 25,000_cells + HCMEC D3_line      1000
      7275   85     C  C03 120.18923 25,000_cells + HCMEC D3_line      1000
      7276   90     C  C03 120.43141 25,000_cells + HCMEC D3_line      1000
      7277   95     C  C03 120.69498 25,000_cells + HCMEC D3_line      1000
      7278  100     C  C03 120.95639 25,000_cells + HCMEC D3_line      1000
      7279  105     C  C03 121.25009 25,000_cells + HCMEC D3_line      1000
      7280  110     C  C03 121.48663 25,000_cells + HCMEC D3_line      1000
      7281  115     C  C03 121.74950 25,000_cells + HCMEC D3_line      1000
      7282  120     C  C03 122.08382 25,000_cells + HCMEC D3_line      1000
      7283  125     C  C03 122.23497 25,000_cells + HCMEC D3_line      1000
      7284  130     C  C03 122.50310 25,000_cells + HCMEC D3_line      1000
      7285  135     C  C03 122.63650 25,000_cells + HCMEC D3_line      1000
      7286  140     C  C03 122.80127 25,000_cells + HCMEC D3_line      1000
      7287  145     C  C03 122.90141 25,000_cells + HCMEC D3_line      1000
      7288  150     C  C03 123.04370 25,000_cells + HCMEC D3_line      1000
      7289  155     C  C03 123.21964 25,000_cells + HCMEC D3_line      1000
      7290  160     C  C03 123.37733 25,000_cells + HCMEC D3_line      1000
      7291  165     C  C03 123.59092 25,000_cells + HCMEC D3_line      1000
      7292  170     C  C03 123.71666 25,000_cells + HCMEC D3_line      1000
      7293  175     C  C03 123.87072 25,000_cells + HCMEC D3_line      1000
      7294  180     C  C03 124.09564 25,000_cells + HCMEC D3_line      1000
      7295  185     C  C03 124.21561 25,000_cells + HCMEC D3_line      1000
      7296  190     C  C03 124.31706 25,000_cells + HCMEC D3_line      1000
      7297  195     C  C03 124.43675 25,000_cells + HCMEC D3_line      1000
      7298  200     C  C03        NA 25,000_cells + HCMEC D3_line      1000
      7299    0     C  C03        NA 25,000_cells + HCMEC D3_line     16000
      7300    5     C  C03  84.84654 25,000_cells + HCMEC D3_line     16000
      7301   10     C  C03  78.49876 25,000_cells + HCMEC D3_line     16000
      7302   15     C  C03  71.62379 25,000_cells + HCMEC D3_line     16000
      7303   20     C  C03  64.87344 25,000_cells + HCMEC D3_line     16000
      7304   25     C  C03  59.98997 25,000_cells + HCMEC D3_line     16000
      7305   30     C  C03  55.42217 25,000_cells + HCMEC D3_line     16000
      7306   35     C  C03  53.55622 25,000_cells + HCMEC D3_line     16000
      7307   40     C  C03  50.99727 25,000_cells + HCMEC D3_line     16000
      7308   45     C  C03  47.41774 25,000_cells + HCMEC D3_line     16000
      7309   50     C  C03  45.12558 25,000_cells + HCMEC D3_line     16000
      7310   55     C  C03  43.23381 25,000_cells + HCMEC D3_line     16000
      7311   60     C  C03  42.41935 25,000_cells + HCMEC D3_line     16000
      7312   65     C  C03  42.32086 25,000_cells + HCMEC D3_line     16000
      7313   70     C  C03  42.65629 25,000_cells + HCMEC D3_line     16000
      7314   75     C  C03  42.62389 25,000_cells + HCMEC D3_line     16000
      7315   80     C  C03  43.38711 25,000_cells + HCMEC D3_line     16000
      7316   85     C  C03  44.35837 25,000_cells + HCMEC D3_line     16000
      7317   90     C  C03  45.14964 25,000_cells + HCMEC D3_line     16000
      7318   95     C  C03  45.20413 25,000_cells + HCMEC D3_line     16000
      7319  100     C  C03  46.44655 25,000_cells + HCMEC D3_line     16000
      7320  105     C  C03  47.65618 25,000_cells + HCMEC D3_line     16000
      7321  110     C  C03  48.89853 25,000_cells + HCMEC D3_line     16000
      7322  115     C  C03  50.19335 25,000_cells + HCMEC D3_line     16000
      7323  120     C  C03  51.85923 25,000_cells + HCMEC D3_line     16000
      7324  125     C  C03  52.59297 25,000_cells + HCMEC D3_line     16000
      7325  130     C  C03  54.18869 25,000_cells + HCMEC D3_line     16000
      7326  135     C  C03  55.51334 25,000_cells + HCMEC D3_line     16000
      7327  140     C  C03  56.50519 25,000_cells + HCMEC D3_line     16000
      7328  145     C  C03  57.90366 25,000_cells + HCMEC D3_line     16000
      7329  150     C  C03  59.59201 25,000_cells + HCMEC D3_line     16000
      7330  155     C  C03  60.85094 25,000_cells + HCMEC D3_line     16000
      7331  160     C  C03  61.93704 25,000_cells + HCMEC D3_line     16000
      7332  165     C  C03  63.61269 25,000_cells + HCMEC D3_line     16000
      7333  170     C  C03  64.85895 25,000_cells + HCMEC D3_line     16000
      7334  175     C  C03  65.93156 25,000_cells + HCMEC D3_line     16000
      7335  180     C  C03  67.69641 25,000_cells + HCMEC D3_line     16000
      7336  185     C  C03  68.77175 25,000_cells + HCMEC D3_line     16000
      7337  190     C  C03  69.71484 25,000_cells + HCMEC D3_line     16000
      7338  195     C  C03  70.45432 25,000_cells + HCMEC D3_line     16000
      7339  200     C  C03        NA 25,000_cells + HCMEC D3_line     16000
      7340    0     C  C03        NA 25,000_cells + HCMEC D3_line      2000
      7341    5     C  C03 113.82309 25,000_cells + HCMEC D3_line      2000
      7342   10     C  C03 112.01708 25,000_cells + HCMEC D3_line      2000
      7343   15     C  C03 109.54874 25,000_cells + HCMEC D3_line      2000
      7344   20     C  C03 107.45261 25,000_cells + HCMEC D3_line      2000
      7345   25     C  C03 106.07757 25,000_cells + HCMEC D3_line      2000
      7346   30     C  C03 104.82208 25,000_cells + HCMEC D3_line      2000
      7347   35     C  C03 105.05554 25,000_cells + HCMEC D3_line      2000
      7348   40     C  C03 104.94840 25,000_cells + HCMEC D3_line      2000
      7349   45     C  C03 104.55566 25,000_cells + HCMEC D3_line      2000
      7350   50     C  C03 104.83085 25,000_cells + HCMEC D3_line      2000
      7351   55     C  C03 105.32346 25,000_cells + HCMEC D3_line      2000
      7352   60     C  C03 107.13308 25,000_cells + HCMEC D3_line      2000
      7353   65     C  C03 108.48040 25,000_cells + HCMEC D3_line      2000
      7354   70     C  C03 109.64177 25,000_cells + HCMEC D3_line      2000
      7355   75     C  C03 110.57816 25,000_cells + HCMEC D3_line      2000
      7356   80     C  C03 111.38214 25,000_cells + HCMEC D3_line      2000
      7357   85     C  C03 111.94444 25,000_cells + HCMEC D3_line      2000
      7358   90     C  C03 112.29301 25,000_cells + HCMEC D3_line      2000
      7359   95     C  C03 112.65077 25,000_cells + HCMEC D3_line      2000
      7360  100     C  C03 113.00274 25,000_cells + HCMEC D3_line      2000
      7361  105     C  C03 113.51433 25,000_cells + HCMEC D3_line      2000
      7362  110     C  C03 113.96512 25,000_cells + HCMEC D3_line      2000
      7363  115     C  C03 114.50283 25,000_cells + HCMEC D3_line      2000
      7364  120     C  C03 115.17897 25,000_cells + HCMEC D3_line      2000
      7365  125     C  C03 115.44941 25,000_cells + HCMEC D3_line      2000
      7366  130     C  C03 115.99830 25,000_cells + HCMEC D3_line      2000
      7367  135     C  C03 116.31011 25,000_cells + HCMEC D3_line      2000
      7368  140     C  C03 116.62849 25,000_cells + HCMEC D3_line      2000
      7369  145     C  C03 116.82939 25,000_cells + HCMEC D3_line      2000
      7370  150     C  C03 117.22231 25,000_cells + HCMEC D3_line      2000
      7371  155     C  C03 117.59078 25,000_cells + HCMEC D3_line      2000
      7372  160     C  C03 117.95640 25,000_cells + HCMEC D3_line      2000
      7373  165     C  C03 118.45684 25,000_cells + HCMEC D3_line      2000
      7374  170     C  C03 118.74126 25,000_cells + HCMEC D3_line      2000
      7375  175     C  C03 119.09055 25,000_cells + HCMEC D3_line      2000
      7376  180     C  C03 119.64514 25,000_cells + HCMEC D3_line      2000
      7377  185     C  C03 119.93158 25,000_cells + HCMEC D3_line      2000
      7378  190     C  C03 120.17488 25,000_cells + HCMEC D3_line      2000
      7379  195     C  C03 120.44601 25,000_cells + HCMEC D3_line      2000
      7380  200     C  C03        NA 25,000_cells + HCMEC D3_line      2000
      7381    0     C  C03        NA 25,000_cells + HCMEC D3_line       250
      7382    5     C  C03 123.46692 25,000_cells + HCMEC D3_line       250
      7383   10     C  C03 123.36754 25,000_cells + HCMEC D3_line       250
      7384   15     C  C03 123.26872 25,000_cells + HCMEC D3_line       250
      7385   20     C  C03 123.23862 25,000_cells + HCMEC D3_line       250
      7386   25     C  C03 123.26192 25,000_cells + HCMEC D3_line       250
      7387   30     C  C03 123.34965 25,000_cells + HCMEC D3_line       250
      7388   35     C  C03 123.57059 25,000_cells + HCMEC D3_line       250
      7389   40     C  C03 123.76910 25,000_cells + HCMEC D3_line       250
      7390   45     C  C03 123.97634 25,000_cells + HCMEC D3_line       250
      7391   50     C  C03 124.19832 25,000_cells + HCMEC D3_line       250
      7392   55     C  C03 124.40091 25,000_cells + HCMEC D3_line       250
      7393   60     C  C03 124.69693 25,000_cells + HCMEC D3_line       250
      7394   65     C  C03 124.95970 25,000_cells + HCMEC D3_line       250
      7395   70     C  C03 125.23451 25,000_cells + HCMEC D3_line       250
      7396   75     C  C03 125.46833 25,000_cells + HCMEC D3_line       250
      7397   80     C  C03 125.70438 25,000_cells + HCMEC D3_line       250
      7398   85     C  C03 125.87901 25,000_cells + HCMEC D3_line       250
      7399   90     C  C03 126.03382 25,000_cells + HCMEC D3_line       250
      7400   95     C  C03 126.19193 25,000_cells + HCMEC D3_line       250
      7401  100     C  C03 126.34296 25,000_cells + HCMEC D3_line       250
      7402  105     C  C03 126.48423 25,000_cells + HCMEC D3_line       250
      7403  110     C  C03 126.58935 25,000_cells + HCMEC D3_line       250
      7404  115     C  C03 126.70393 25,000_cells + HCMEC D3_line       250
      7405  120     C  C03 126.81280 25,000_cells + HCMEC D3_line       250
      7406  125     C  C03 126.90969 25,000_cells + HCMEC D3_line       250
      7407  130     C  C03 126.99881 25,000_cells + HCMEC D3_line       250
      7408  135     C  C03 127.06124 25,000_cells + HCMEC D3_line       250
      7409  140     C  C03 127.15652 25,000_cells + HCMEC D3_line       250
      7410  145     C  C03 127.21275 25,000_cells + HCMEC D3_line       250
      7411  150     C  C03 127.28035 25,000_cells + HCMEC D3_line       250
      7412  155     C  C03 127.34780 25,000_cells + HCMEC D3_line       250
      7413  160     C  C03 127.41047 25,000_cells + HCMEC D3_line       250
      7414  165     C  C03 127.47639 25,000_cells + HCMEC D3_line       250
      7415  170     C  C03 127.53067 25,000_cells + HCMEC D3_line       250
      7416  175     C  C03 127.58238 25,000_cells + HCMEC D3_line       250
      7417  180     C  C03 127.63111 25,000_cells + HCMEC D3_line       250
      7418  185     C  C03 127.67733 25,000_cells + HCMEC D3_line       250
      7419  190     C  C03 127.71024 25,000_cells + HCMEC D3_line       250
      7420  195     C  C03 127.74258 25,000_cells + HCMEC D3_line       250
      7421  200     C  C03        NA 25,000_cells + HCMEC D3_line       250
      7422    0     C  C03        NA 25,000_cells + HCMEC D3_line     32000
      7423    5     C  C03  72.34458 25,000_cells + HCMEC D3_line     32000
      7424   10     C  C03  66.09190 25,000_cells + HCMEC D3_line     32000
      7425   15     C  C03  59.29172 25,000_cells + HCMEC D3_line     32000
      7426   20     C  C03  52.52457 25,000_cells + HCMEC D3_line     32000
      7427   25     C  C03  47.62557 25,000_cells + HCMEC D3_line     32000
      7428   30     C  C03  43.03916 25,000_cells + HCMEC D3_line     32000
      7429   35     C  C03  41.04046 25,000_cells + HCMEC D3_line     32000
      7430   40     C  C03  38.26786 25,000_cells + HCMEC D3_line     32000
      7431   45     C  C03  34.44003 25,000_cells + HCMEC D3_line     32000
      7432   50     C  C03  31.34786 25,000_cells + HCMEC D3_line     32000
      7433   55     C  C03  28.15801 25,000_cells + HCMEC D3_line     32000
      7434   60     C  C03  25.38929 25,000_cells + HCMEC D3_line     32000
      7435   65     C  C03  23.58188 25,000_cells + HCMEC D3_line     32000
      7436   70     C  C03  22.83923 25,000_cells + HCMEC D3_line     32000
      7437   75     C  C03  21.91682 25,000_cells + HCMEC D3_line     32000
      7438   80     C  C03  22.14806 25,000_cells + HCMEC D3_line     32000
      7439   85     C  C03  22.66377 25,000_cells + HCMEC D3_line     32000
      7440   90     C  C03  23.17788 25,000_cells + HCMEC D3_line     32000
      7441   95     C  C03  22.96391 25,000_cells + HCMEC D3_line     32000
      7442  100     C  C03  23.89166 25,000_cells + HCMEC D3_line     32000
      7443  105     C  C03  24.48479 25,000_cells + HCMEC D3_line     32000
      7444  110     C  C03  25.50404 25,000_cells + HCMEC D3_line     32000
      7445  115     C  C03  26.27508 25,000_cells + HCMEC D3_line     32000
      7446  120     C  C03  27.47159 25,000_cells + HCMEC D3_line     32000
      7447  125     C  C03  28.00687 25,000_cells + HCMEC D3_line     32000
      7448  130     C  C03  29.27140 25,000_cells + HCMEC D3_line     32000
      7449  135     C  C03  30.30520 25,000_cells + HCMEC D3_line     32000
      7450  140     C  C03  31.17419 25,000_cells + HCMEC D3_line     32000
      7451  145     C  C03  32.33558 25,000_cells + HCMEC D3_line     32000
      7452  150     C  C03  33.75999 25,000_cells + HCMEC D3_line     32000
      7453  155     C  C03  34.81972 25,000_cells + HCMEC D3_line     32000
      7454  160     C  C03  35.65843 25,000_cells + HCMEC D3_line     32000
      7455  165     C  C03  37.21602 25,000_cells + HCMEC D3_line     32000
      7456  170     C  C03  38.50362 25,000_cells + HCMEC D3_line     32000
      7457  175     C  C03  39.55101 25,000_cells + HCMEC D3_line     32000
      7458  180     C  C03  41.16578 25,000_cells + HCMEC D3_line     32000
      7459  185     C  C03  42.28855 25,000_cells + HCMEC D3_line     32000
      7460  190     C  C03  43.18278 25,000_cells + HCMEC D3_line     32000
      7461  195     C  C03  44.10210 25,000_cells + HCMEC D3_line     32000
      7462  200     C  C03        NA 25,000_cells + HCMEC D3_line     32000
      7463    0     C  C03        NA 25,000_cells + HCMEC D3_line      4000
      7464    5     C  C03 106.41565 25,000_cells + HCMEC D3_line      4000
      7465   10     C  C03 102.78555 25,000_cells + HCMEC D3_line      4000
      7466   15     C  C03  98.39162 25,000_cells + HCMEC D3_line      4000
      7467   20     C  C03  94.45457 25,000_cells + HCMEC D3_line      4000
      7468   25     C  C03  91.71333 25,000_cells + HCMEC D3_line      4000
      7469   30     C  C03  89.20286 25,000_cells + HCMEC D3_line      4000
      7470   35     C  C03  88.93207 25,000_cells + HCMEC D3_line      4000
      7471   40     C  C03  88.06193 25,000_cells + HCMEC D3_line      4000
      7472   45     C  C03  86.73419 25,000_cells + HCMEC D3_line      4000
      7473   50     C  C03  86.71675 25,000_cells + HCMEC D3_line      4000
      7474   55     C  C03  87.27466 25,000_cells + HCMEC D3_line      4000
      7475   60     C  C03  89.61277 25,000_cells + HCMEC D3_line      4000
      7476   65     C  C03  91.60613 25,000_cells + HCMEC D3_line      4000
      7477   70     C  C03  93.31547 25,000_cells + HCMEC D3_line      4000
      7478   75     C  C03  94.67146 25,000_cells + HCMEC D3_line      4000
      7479   80     C  C03  95.89807 25,000_cells + HCMEC D3_line      4000
      7480   85     C  C03  96.91188 25,000_cells + HCMEC D3_line      4000
      7481   90     C  C03  97.53079 25,000_cells + HCMEC D3_line      4000
      7482   95     C  C03  97.97449 25,000_cells + HCMEC D3_line      4000
      7483  100     C  C03  98.59103 25,000_cells + HCMEC D3_line      4000
      7484  105     C  C03  99.60193 25,000_cells + HCMEC D3_line      4000
      7485  110     C  C03 100.20486 25,000_cells + HCMEC D3_line      4000
      7486  115     C  C03 101.09934 25,000_cells + HCMEC D3_line      4000
      7487  120     C  C03 102.20353 25,000_cells + HCMEC D3_line      4000
      7488  125     C  C03 102.60635 25,000_cells + HCMEC D3_line      4000
      7489  130     C  C03 103.45336 25,000_cells + HCMEC D3_line      4000
      7490  135     C  C03 104.06100 25,000_cells + HCMEC D3_line      4000
      7491  140     C  C03 104.54543 25,000_cells + HCMEC D3_line      4000
      7492  145     C  C03 104.98851 25,000_cells + HCMEC D3_line      4000
      7493  150     C  C03 105.78372 25,000_cells + HCMEC D3_line      4000
      7494  155     C  C03 106.40821 25,000_cells + HCMEC D3_line      4000
      7495  160     C  C03 107.05910 25,000_cells + HCMEC D3_line      4000
      7496  165     C  C03 107.90492 25,000_cells + HCMEC D3_line      4000
      7497  170     C  C03 108.42765 25,000_cells + HCMEC D3_line      4000
      7498  175     C  C03 108.99981 25,000_cells + HCMEC D3_line      4000
      7499  180     C  C03 109.95670 25,000_cells + HCMEC D3_line      4000
      7500  185     C  C03 110.46638 25,000_cells + HCMEC D3_line      4000
      7501  190     C  C03 110.90604 25,000_cells + HCMEC D3_line      4000
      7502  195     C  C03 111.32362 25,000_cells + HCMEC D3_line      4000
      7503  200     C  C03        NA 25,000_cells + HCMEC D3_line      4000
      7504    0     C  C03        NA 25,000_cells + HCMEC D3_line       500
      7505    5     C  C03 121.29452 25,000_cells + HCMEC D3_line       500
      7506   10     C  C03 121.19115 25,000_cells + HCMEC D3_line       500
      7507   15     C  C03 120.93607 25,000_cells + HCMEC D3_line       500
      7508   20     C  C03 120.77514 25,000_cells + HCMEC D3_line       500
      7509   25     C  C03 120.72201 25,000_cells + HCMEC D3_line       500
      7510   30     C  C03 120.70939 25,000_cells + HCMEC D3_line       500
      7511   35     C  C03 120.97680 25,000_cells + HCMEC D3_line       500
      7512   40     C  C03 121.19804 25,000_cells + HCMEC D3_line       500
      7513   45     C  C03 121.44690 25,000_cells + HCMEC D3_line       500
      7514   50     C  C03 121.71785 25,000_cells + HCMEC D3_line       500
      7515   55     C  C03 121.92405 25,000_cells + HCMEC D3_line       500
      7516   60     C  C03 122.41563 25,000_cells + HCMEC D3_line       500
      7517   65     C  C03 122.80001 25,000_cells + HCMEC D3_line       500
      7518   70     C  C03 123.16811 25,000_cells + HCMEC D3_line       500
      7519   75     C  C03 123.45616 25,000_cells + HCMEC D3_line       500
      7520   80     C  C03 123.74539 25,000_cells + HCMEC D3_line       500
      7521   85     C  C03 123.95826 25,000_cells + HCMEC D3_line       500
      7522   90     C  C03 124.14201 25,000_cells + HCMEC D3_line       500
      7523   95     C  C03 124.33127 25,000_cells + HCMEC D3_line       500
      7524  100     C  C03 124.51464 25,000_cells + HCMEC D3_line       500
      7525  105     C  C03 124.70450 25,000_cells + HCMEC D3_line       500
      7526  110     C  C03 124.84197 25,000_cells + HCMEC D3_line       500
      7527  115     C  C03 124.99753 25,000_cells + HCMEC D3_line       500
      7528  120     C  C03 125.16276 25,000_cells + HCMEC D3_line       500
      7529  125     C  C03 125.27790 25,000_cells + HCMEC D3_line       500
      7530  130     C  C03 125.40748 25,000_cells + HCMEC D3_line       500
      7531  135     C  C03 125.48717 25,000_cells + HCMEC D3_line       500
      7532  140     C  C03 125.59764 25,000_cells + HCMEC D3_line       500
      7533  145     C  C03 125.67007 25,000_cells + HCMEC D3_line       500
      7534  150     C  C03 125.74300 25,000_cells + HCMEC D3_line       500
      7535  155     C  C03 125.83540 25,000_cells + HCMEC D3_line       500
      7536  160     C  C03 125.92576 25,000_cells + HCMEC D3_line       500
      7537  165     C  C03 126.02177 25,000_cells + HCMEC D3_line       500
      7538  170     C  C03 126.08268 25,000_cells + HCMEC D3_line       500
      7539  175     C  C03 126.16149 25,000_cells + HCMEC D3_line       500
      7540  180     C  C03 126.25696 25,000_cells + HCMEC D3_line       500
      7541  185     C  C03 126.31767 25,000_cells + HCMEC D3_line       500
      7542  190     C  C03 126.36937 25,000_cells + HCMEC D3_line       500
      7543  195     C  C03 126.42014 25,000_cells + HCMEC D3_line       500
      7544  200     C  C03        NA 25,000_cells + HCMEC D3_line       500
      7545    0     C  C03        NA 25,000_cells + HCMEC D3_line     64000
      7546    5     C  C03  54.82683 25,000_cells + HCMEC D3_line     64000
      7547   10     C  C03  50.11125 25,000_cells + HCMEC D3_line     64000
      7548   15     C  C03  44.81080 25,000_cells + HCMEC D3_line     64000
      7549   20     C  C03  39.39440 25,000_cells + HCMEC D3_line     64000
      7550   25     C  C03  35.50932 25,000_cells + HCMEC D3_line     64000
      7551   30     C  C03  31.73315 25,000_cells + HCMEC D3_line     64000
      7552   35     C  C03  30.06938 25,000_cells + HCMEC D3_line     64000
      7553   40     C  C03  27.70662 25,000_cells + HCMEC D3_line     64000
      7554   45     C  C03  24.43503 25,000_cells + HCMEC D3_line     64000
      7555   50     C  C03  21.51102 25,000_cells + HCMEC D3_line     64000
      7556   55     C  C03  18.28022 25,000_cells + HCMEC D3_line     64000
      7557   60     C  C03  15.09648 25,000_cells + HCMEC D3_line     64000
      7558   65     C  C03  12.87735 25,000_cells + HCMEC D3_line     64000
      7559   70     C  C03  11.98691 25,000_cells + HCMEC D3_line     64000
      7560   75     C  C03  11.09839 25,000_cells + HCMEC D3_line     64000
      7561   80     C  C03  11.15868 25,000_cells + HCMEC D3_line     64000
      7562   85     C  C03  11.39164 25,000_cells + HCMEC D3_line     64000
      7563   90     C  C03  11.64104 25,000_cells + HCMEC D3_line     64000
      7564   95     C  C03  11.46248 25,000_cells + HCMEC D3_line     64000
      7565  100     C  C03  11.92647 25,000_cells + HCMEC D3_line     64000
      7566  105     C  C03  12.09749 25,000_cells + HCMEC D3_line     64000
      7567  110     C  C03  12.65761 25,000_cells + HCMEC D3_line     64000
      7568  115     C  C03  12.95530 25,000_cells + HCMEC D3_line     64000
      7569  120     C  C03  13.53934 25,000_cells + HCMEC D3_line     64000
      7570  125     C  C03  13.77593 25,000_cells + HCMEC D3_line     64000
      7571  130     C  C03  14.42179 25,000_cells + HCMEC D3_line     64000
      7572  135     C  C03  14.89818 25,000_cells + HCMEC D3_line     64000
      7573  140     C  C03  15.44035 25,000_cells + HCMEC D3_line     64000
      7574  145     C  C03  15.99780 25,000_cells + HCMEC D3_line     64000
      7575  150     C  C03  16.79659 25,000_cells + HCMEC D3_line     64000
      7576  155     C  C03  17.38108 25,000_cells + HCMEC D3_line     64000
      7577  160     C  C03  17.70196 25,000_cells + HCMEC D3_line     64000
      7578  165     C  C03  18.62698 25,000_cells + HCMEC D3_line     64000
      7579  170     C  C03  19.46791 25,000_cells + HCMEC D3_line     64000
      7580  175     C  C03  20.13406 25,000_cells + HCMEC D3_line     64000
      7581  180     C  C03  21.01272 25,000_cells + HCMEC D3_line     64000
      7582  185     C  C03  21.85465 25,000_cells + HCMEC D3_line     64000
      7583  190     C  C03  22.32523 25,000_cells + HCMEC D3_line     64000
      7584  195     C  C03  23.16304 25,000_cells + HCMEC D3_line     64000
      7585  200     C  C03        NA 25,000_cells + HCMEC D3_line     64000
      7586    0     C  C03        NA 25,000_cells + HCMEC D3_line      8000
      7587    5     C  C03  95.90551 25,000_cells + HCMEC D3_line      8000
      7588   10     C  C03  90.49811 25,000_cells + HCMEC D3_line      8000
      7589   15     C  C03  84.53077 25,000_cells + HCMEC D3_line      8000
      7590   20     C  C03  78.90271 25,000_cells + HCMEC D3_line      8000
      7591   25     C  C03  74.87326 25,000_cells + HCMEC D3_line      8000
      7592   30     C  C03  71.13161 25,000_cells + HCMEC D3_line      8000
      7593   35     C  C03  69.98760 25,000_cells + HCMEC D3_line      8000
      7594   40     C  C03  68.19965 25,000_cells + HCMEC D3_line      8000
      7595   45     C  C03  65.58823 25,000_cells + HCMEC D3_line      8000
      7596   50     C  C03  64.56805 25,000_cells + HCMEC D3_line      8000
      7597   55     C  C03  64.28743 25,000_cells + HCMEC D3_line      8000
      7598   60     C  C03  65.79040 25,000_cells + HCMEC D3_line      8000
      7599   65     C  C03  67.47560 25,000_cells + HCMEC D3_line      8000
      7600   70     C  C03  69.01311 25,000_cells + HCMEC D3_line      8000
      7601   75     C  C03  70.15213 25,000_cells + HCMEC D3_line      8000
      7602   80     C  C03  71.45497 25,000_cells + HCMEC D3_line      8000
      7603   85     C  C03  72.69418 25,000_cells + HCMEC D3_line      8000
      7604   90     C  C03  73.50305 25,000_cells + HCMEC D3_line      8000
      7605   95     C  C03  73.89404 25,000_cells + HCMEC D3_line      8000
      7606  100     C  C03  74.88555 25,000_cells + HCMEC D3_line      8000
      7607  105     C  C03  76.32577 25,000_cells + HCMEC D3_line      8000
      7608  110     C  C03  77.25259 25,000_cells + HCMEC D3_line      8000
      7609  115     C  C03  78.52188 25,000_cells + HCMEC D3_line      8000
      7610  120     C  C03  80.11072 25,000_cells + HCMEC D3_line      8000
      7611  125     C  C03  80.71591 25,000_cells + HCMEC D3_line      8000
      7612  130     C  C03  81.97520 25,000_cells + HCMEC D3_line      8000
      7613  135     C  C03  83.01733 25,000_cells + HCMEC D3_line      8000
      7614  140     C  C03  83.75745 25,000_cells + HCMEC D3_line      8000
      7615  145     C  C03  84.71360 25,000_cells + HCMEC D3_line      8000
      7616  150     C  C03  86.06151 25,000_cells + HCMEC D3_line      8000
      7617  155     C  C03  87.05103 25,000_cells + HCMEC D3_line      8000
      7618  160     C  C03  87.98783 25,000_cells + HCMEC D3_line      8000
      7619  165     C  C03  89.29092 25,000_cells + HCMEC D3_line      8000
      7620  170     C  C03  90.17353 25,000_cells + HCMEC D3_line      8000
      7621  175     C  C03  90.99616 25,000_cells + HCMEC D3_line      8000
      7622  180     C  C03  92.41210 25,000_cells + HCMEC D3_line      8000
      7623  185     C  C03  93.16908 25,000_cells + HCMEC D3_line      8000
      7624  190     C  C03  93.83854 25,000_cells + HCMEC D3_line      8000
      7625  195     C  C03  94.36490 25,000_cells + HCMEC D3_line      8000
      7626  200     C  C03        NA 25,000_cells + HCMEC D3_line      8000
      7627    0     C  D01        NA 20,000_cells + HCMEC D3_line      1000
      7628    5     C  D01 118.27255 20,000_cells + HCMEC D3_line      1000
      7629   10     C  D01 118.01159 20,000_cells + HCMEC D3_line      1000
      7630   15     C  D01 117.02219 20,000_cells + HCMEC D3_line      1000
      7631   20     C  D01 115.98055 20,000_cells + HCMEC D3_line      1000
      7632   25     C  D01 115.16296 20,000_cells + HCMEC D3_line      1000
      7633   30     C  D01 114.69472 20,000_cells + HCMEC D3_line      1000
      7634   35     C  D01 114.86024 20,000_cells + HCMEC D3_line      1000
      7635   40     C  D01 114.68446 20,000_cells + HCMEC D3_line      1000
      7636   45     C  D01 114.62359 20,000_cells + HCMEC D3_line      1000
      7637   50     C  D01 115.01686 20,000_cells + HCMEC D3_line      1000
      7638   55     C  D01 115.16074 20,000_cells + HCMEC D3_line      1000
      7639   60     C  D01 115.95150 20,000_cells + HCMEC D3_line      1000
      7640   65     C  D01 116.67318 20,000_cells + HCMEC D3_line      1000
      7641   70     C  D01 117.30312 20,000_cells + HCMEC D3_line      1000
      7642   75     C  D01 117.95657 20,000_cells + HCMEC D3_line      1000
      7643   80     C  D01 118.52551 20,000_cells + HCMEC D3_line      1000
      7644   85     C  D01 119.21537 20,000_cells + HCMEC D3_line      1000
      7645   90     C  D01 119.65669 20,000_cells + HCMEC D3_line      1000
      7646   95     C  D01 120.27016 20,000_cells + HCMEC D3_line      1000
      7647  100     C  D01 120.44685 20,000_cells + HCMEC D3_line      1000
      7648  105     C  D01 120.57124 20,000_cells + HCMEC D3_line      1000
      7649  110     C  D01 120.72878 20,000_cells + HCMEC D3_line      1000
      7650  115     C  D01 120.91065 20,000_cells + HCMEC D3_line      1000
      7651  120     C  D01 121.19094 20,000_cells + HCMEC D3_line      1000
      7652  125     C  D01 121.61544 20,000_cells + HCMEC D3_line      1000
      7653  130     C  D01 121.90686 20,000_cells + HCMEC D3_line      1000
      7654  135     C  D01 122.24843 20,000_cells + HCMEC D3_line      1000
      7655  140     C  D01 122.24323 20,000_cells + HCMEC D3_line      1000
      7656  145     C  D01 122.36406 20,000_cells + HCMEC D3_line      1000
      7657  150     C  D01 122.69192 20,000_cells + HCMEC D3_line      1000
      7658  155     C  D01 122.97343 20,000_cells + HCMEC D3_line      1000
      7659  160     C  D01 123.14876 20,000_cells + HCMEC D3_line      1000
      7660  165     C  D01 123.29953 20,000_cells + HCMEC D3_line      1000
      7661  170     C  D01 118.70181 20,000_cells + HCMEC D3_line      1000
      7662  175     C  D01 119.22247 20,000_cells + HCMEC D3_line      1000
      7663  180     C  D01 119.80090 20,000_cells + HCMEC D3_line      1000
      7664  185     C  D01 120.03479 20,000_cells + HCMEC D3_line      1000
      7665  190     C  D01 120.84305 20,000_cells + HCMEC D3_line      1000
      7666  195     C  D01 121.30488 20,000_cells + HCMEC D3_line      1000
      7667  200     C  D01        NA 20,000_cells + HCMEC D3_line      1000
      7668    0     C  D01        NA 20,000_cells + HCMEC D3_line     16000
      7669    5     C  D01  90.84631 20,000_cells + HCMEC D3_line     16000
      7670   10     C  D01  85.72800 20,000_cells + HCMEC D3_line     16000
      7671   15     C  D01  79.18104 20,000_cells + HCMEC D3_line     16000
      7672   20     C  D01  72.59819 20,000_cells + HCMEC D3_line     16000
      7673   25     C  D01  67.37450 20,000_cells + HCMEC D3_line     16000
      7674   30     C  D01  63.42144 20,000_cells + HCMEC D3_line     16000
      7675   35     C  D01  60.60111 20,000_cells + HCMEC D3_line     16000
      7676   40     C  D01  57.01521 20,000_cells + HCMEC D3_line     16000
      7677   45     C  D01  53.45007 20,000_cells + HCMEC D3_line     16000
      7678   50     C  D01  50.68010 20,000_cells + HCMEC D3_line     16000
      7679   55     C  D01  46.59964 20,000_cells + HCMEC D3_line     16000
      7680   60     C  D01  43.44071 20,000_cells + HCMEC D3_line     16000
      7681   65     C  D01  41.48963 20,000_cells + HCMEC D3_line     16000
      7682   70     C  D01  41.06432 20,000_cells + HCMEC D3_line     16000
      7683   75     C  D01  41.21612 20,000_cells + HCMEC D3_line     16000
      7684   80     C  D01  41.62799 20,000_cells + HCMEC D3_line     16000
      7685   85     C  D01  42.06384 20,000_cells + HCMEC D3_line     16000
      7686   90     C  D01  42.63176 20,000_cells + HCMEC D3_line     16000
      7687   95     C  D01  43.57562 20,000_cells + HCMEC D3_line     16000
      7688  100     C  D01  44.00825 20,000_cells + HCMEC D3_line     16000
      7689  105     C  D01  45.02363 20,000_cells + HCMEC D3_line     16000
      7690  110     C  D01  46.18240 20,000_cells + HCMEC D3_line     16000
      7691  115     C  D01  47.74347 20,000_cells + HCMEC D3_line     16000
      7692  120     C  D01  49.14092 20,000_cells + HCMEC D3_line     16000
      7693  125     C  D01  50.98450 20,000_cells + HCMEC D3_line     16000
      7694  130     C  D01  52.65457 20,000_cells + HCMEC D3_line     16000
      7695  135     C  D01  54.47188 20,000_cells + HCMEC D3_line     16000
      7696  140     C  D01  55.46539 20,000_cells + HCMEC D3_line     16000
      7697  145     C  D01  56.92850 20,000_cells + HCMEC D3_line     16000
      7698  150     C  D01  58.74496 20,000_cells + HCMEC D3_line     16000
      7699  155     C  D01  60.44272 20,000_cells + HCMEC D3_line     16000
      7700  160     C  D01  61.49486 20,000_cells + HCMEC D3_line     16000
      7701  165     C  D01  63.18534 20,000_cells + HCMEC D3_line     16000
      7702  170     C  D01  41.96801 20,000_cells + HCMEC D3_line     16000
      7703  175     C  D01  41.50601 20,000_cells + HCMEC D3_line     16000
      7704  180     C  D01  43.77373 20,000_cells + HCMEC D3_line     16000
      7705  185     C  D01  46.26254 20,000_cells + HCMEC D3_line     16000
      7706  190     C  D01  49.67347 20,000_cells + HCMEC D3_line     16000
      7707  195     C  D01  52.20878 20,000_cells + HCMEC D3_line     16000
      7708  200     C  D01        NA 20,000_cells + HCMEC D3_line     16000
      7709    0     C  D01        NA 20,000_cells + HCMEC D3_line      2000
      7710    5     C  D01 115.36295 20,000_cells + HCMEC D3_line      2000
      7711   10     C  D01 113.90227 20,000_cells + HCMEC D3_line      2000
      7712   15     C  D01 111.28519 20,000_cells + HCMEC D3_line      2000
      7713   20     C  D01 108.68855 20,000_cells + HCMEC D3_line      2000
      7714   25     C  D01 106.78595 20,000_cells + HCMEC D3_line      2000
      7715   30     C  D01 105.34902 20,000_cells + HCMEC D3_line      2000
      7716   35     C  D01 104.95554 20,000_cells + HCMEC D3_line      2000
      7717   40     C  D01 104.07411 20,000_cells + HCMEC D3_line      2000
      7718   45     C  D01 103.41517 20,000_cells + HCMEC D3_line      2000
      7719   50     C  D01 103.50467 20,000_cells + HCMEC D3_line      2000
      7720   55     C  D01 103.27025 20,000_cells + HCMEC D3_line      2000
      7721   60     C  D01 104.21793 20,000_cells + HCMEC D3_line      2000
      7722   65     C  D01 105.34140 20,000_cells + HCMEC D3_line      2000
      7723   70     C  D01 106.43162 20,000_cells + HCMEC D3_line      2000
      7724   75     C  D01 107.71122 20,000_cells + HCMEC D3_line      2000
      7725   80     C  D01 108.91053 20,000_cells + HCMEC D3_line      2000
      7726   85     C  D01 109.92067 20,000_cells + HCMEC D3_line      2000
      7727   90     C  D01 110.64124 20,000_cells + HCMEC D3_line      2000
      7728   95     C  D01 111.71982 20,000_cells + HCMEC D3_line      2000
      7729  100     C  D01 111.91153 20,000_cells + HCMEC D3_line      2000
      7730  105     C  D01 112.14581 20,000_cells + HCMEC D3_line      2000
      7731  110     C  D01 112.41168 20,000_cells + HCMEC D3_line      2000
      7732  115     C  D01 112.76898 20,000_cells + HCMEC D3_line      2000
      7733  120     C  D01 113.40700 20,000_cells + HCMEC D3_line      2000
      7734  125     C  D01 114.25498 20,000_cells + HCMEC D3_line      2000
      7735  130     C  D01 114.83699 20,000_cells + HCMEC D3_line      2000
      7736  135     C  D01 115.54107 20,000_cells + HCMEC D3_line      2000
      7737  140     C  D01 115.63646 20,000_cells + HCMEC D3_line      2000
      7738  145     C  D01 115.90395 20,000_cells + HCMEC D3_line      2000
      7739  150     C  D01 116.57118 20,000_cells + HCMEC D3_line      2000
      7740  155     C  D01 117.24509 20,000_cells + HCMEC D3_line      2000
      7741  160     C  D01 117.62176 20,000_cells + HCMEC D3_line      2000
      7742  165     C  D01 118.02549 20,000_cells + HCMEC D3_line      2000
      7743  170     C  D01 108.67605 20,000_cells + HCMEC D3_line      2000
      7744  175     C  D01 109.42714 20,000_cells + HCMEC D3_line      2000
      7745  180     C  D01 110.37130 20,000_cells + HCMEC D3_line      2000
      7746  185     C  D01 110.99291 20,000_cells + HCMEC D3_line      2000
      7747  190     C  D01 112.46144 20,000_cells + HCMEC D3_line      2000
      7748  195     C  D01 113.37529 20,000_cells + HCMEC D3_line      2000
      7749  200     C  D01        NA 20,000_cells + HCMEC D3_line      2000
      7750    0     C  D01        NA 20,000_cells + HCMEC D3_line       250
      7751    5     C  D01 123.04375 20,000_cells + HCMEC D3_line       250
      7752   10     C  D01 123.14874 20,000_cells + HCMEC D3_line       250
      7753   15     C  D01 123.05632 20,000_cells + HCMEC D3_line       250
      7754   20     C  D01 123.01692 20,000_cells + HCMEC D3_line       250
      7755   25     C  D01 122.96244 20,000_cells + HCMEC D3_line       250
      7756   30     C  D01 123.05855 20,000_cells + HCMEC D3_line       250
      7757   35     C  D01 123.27709 20,000_cells + HCMEC D3_line       250
      7758   40     C  D01 123.37716 20,000_cells + HCMEC D3_line       250
      7759   45     C  D01 123.55550 20,000_cells + HCMEC D3_line       250
      7760   50     C  D01 123.80889 20,000_cells + HCMEC D3_line       250
      7761   55     C  D01 123.99103 20,000_cells + HCMEC D3_line       250
      7762   60     C  D01 124.34956 20,000_cells + HCMEC D3_line       250
      7763   65     C  D01 124.65254 20,000_cells + HCMEC D3_line       250
      7764   70     C  D01 124.97767 20,000_cells + HCMEC D3_line       250
      7765   75     C  D01 125.24059 20,000_cells + HCMEC D3_line       250
      7766   80     C  D01 125.47571 20,000_cells + HCMEC D3_line       250
      7767   85     C  D01 125.72536 20,000_cells + HCMEC D3_line       250
      7768   90     C  D01 125.92521 20,000_cells + HCMEC D3_line       250
      7769   95     C  D01 126.11142 20,000_cells + HCMEC D3_line       250
      7770  100     C  D01 126.26026 20,000_cells + HCMEC D3_line       250
      7771  105     C  D01 126.36404 20,000_cells + HCMEC D3_line       250
      7772  110     C  D01 126.47851 20,000_cells + HCMEC D3_line       250
      7773  115     C  D01 126.58582 20,000_cells + HCMEC D3_line       250
      7774  120     C  D01 126.67311 20,000_cells + HCMEC D3_line       250
      7775  125     C  D01 126.78174 20,000_cells + HCMEC D3_line       250
      7776  130     C  D01 126.88067 20,000_cells + HCMEC D3_line       250
      7777  135     C  D01 126.95620 20,000_cells + HCMEC D3_line       250
      7778  140     C  D01 127.00991 20,000_cells + HCMEC D3_line       250
      7779  145     C  D01 127.07107 20,000_cells + HCMEC D3_line       250
      7780  150     C  D01 127.15387 20,000_cells + HCMEC D3_line       250
      7781  155     C  D01 127.19340 20,000_cells + HCMEC D3_line       250
      7782  160     C  D01 127.24959 20,000_cells + HCMEC D3_line       250
      7783  165     C  D01 127.27675 20,000_cells + HCMEC D3_line       250
      7784  170     C  D01 126.17795 20,000_cells + HCMEC D3_line       250
      7785  175     C  D01 126.26960 20,000_cells + HCMEC D3_line       250
      7786  180     C  D01 126.34065 20,000_cells + HCMEC D3_line       250
      7787  185     C  D01 126.36463 20,000_cells + HCMEC D3_line       250
      7788  190     C  D01 126.44239 20,000_cells + HCMEC D3_line       250
      7789  195     C  D01 126.49573 20,000_cells + HCMEC D3_line       250
      7790  200     C  D01        NA 20,000_cells + HCMEC D3_line       250
      7791    0     C  D01        NA 20,000_cells + HCMEC D3_line     32000
      7792    5     C  D01  77.63223 20,000_cells + HCMEC D3_line     32000
      7793   10     C  D01  72.68936 20,000_cells + HCMEC D3_line     32000
      7794   15     C  D01  66.58194 20,000_cells + HCMEC D3_line     32000
      7795   20     C  D01  60.28434 20,000_cells + HCMEC D3_line     32000
      7796   25     C  D01  55.33303 20,000_cells + HCMEC D3_line     32000
      7797   30     C  D01  51.57849 20,000_cells + HCMEC D3_line     32000
      7798   35     C  D01  48.72011 20,000_cells + HCMEC D3_line     32000
      7799   40     C  D01  45.33358 20,000_cells + HCMEC D3_line     32000
      7800   45     C  D01  41.54436 20,000_cells + HCMEC D3_line     32000
      7801   50     C  D01  38.43896 20,000_cells + HCMEC D3_line     32000
      7802   55     C  D01  33.56956 20,000_cells + HCMEC D3_line     32000
      7803   60     C  D01  29.35110 20,000_cells + HCMEC D3_line     32000
      7804   65     C  D01  25.92524 20,000_cells + HCMEC D3_line     32000
      7805   70     C  D01  24.22827 20,000_cells + HCMEC D3_line     32000
      7806   75     C  D01  22.97805 20,000_cells + HCMEC D3_line     32000
      7807   80     C  D01  22.03976 20,000_cells + HCMEC D3_line     32000
      7808   85     C  D01  22.03274 20,000_cells + HCMEC D3_line     32000
      7809   90     C  D01  22.01598 20,000_cells + HCMEC D3_line     32000
      7810   95     C  D01  22.31035 20,000_cells + HCMEC D3_line     32000
      7811  100     C  D01  22.61440 20,000_cells + HCMEC D3_line     32000
      7812  105     C  D01  23.37211 20,000_cells + HCMEC D3_line     32000
      7813  110     C  D01  24.01050 20,000_cells + HCMEC D3_line     32000
      7814  115     C  D01  25.08934 20,000_cells + HCMEC D3_line     32000
      7815  120     C  D01  25.99084 20,000_cells + HCMEC D3_line     32000
      7816  125     C  D01  27.35471 20,000_cells + HCMEC D3_line     32000
      7817  130     C  D01  28.43405 20,000_cells + HCMEC D3_line     32000
      7818  135     C  D01  29.86462 20,000_cells + HCMEC D3_line     32000
      7819  140     C  D01  30.83099 20,000_cells + HCMEC D3_line     32000
      7820  145     C  D01  31.86556 20,000_cells + HCMEC D3_line     32000
      7821  150     C  D01  33.35889 20,000_cells + HCMEC D3_line     32000
      7822  155     C  D01  34.56290 20,000_cells + HCMEC D3_line     32000
      7823  160     C  D01  35.57646 20,000_cells + HCMEC D3_line     32000
      7824  165     C  D01  37.06774 20,000_cells + HCMEC D3_line     32000
      7825  170     C  D01  22.20062 20,000_cells + HCMEC D3_line     32000
      7826  175     C  D01  21.83857 20,000_cells + HCMEC D3_line     32000
      7827  180     C  D01  23.70927 20,000_cells + HCMEC D3_line     32000
      7828  185     C  D01  25.68430 20,000_cells + HCMEC D3_line     32000
      7829  190     C  D01  28.79477 20,000_cells + HCMEC D3_line     32000
      7830  195     C  D01  31.07263 20,000_cells + HCMEC D3_line     32000
      7831  200     C  D01        NA 20,000_cells + HCMEC D3_line     32000
      7832    0     C  D01        NA 20,000_cells + HCMEC D3_line      4000
      7833    5     C  D01 109.98809 20,000_cells + HCMEC D3_line      4000
      7834   10     C  D01 106.94123 20,000_cells + HCMEC D3_line      4000
      7835   15     C  D01 102.51832 20,000_cells + HCMEC D3_line      4000
      7836   20     C  D01  98.16539 20,000_cells + HCMEC D3_line      4000
      7837   25     C  D01  94.83071 20,000_cells + HCMEC D3_line      4000
      7838   30     C  D01  92.23279 20,000_cells + HCMEC D3_line      4000
      7839   35     C  D01  90.83003 20,000_cells + HCMEC D3_line      4000
      7840   40     C  D01  88.88261 20,000_cells + HCMEC D3_line      4000
      7841   45     C  D01  87.25611 20,000_cells + HCMEC D3_line      4000
      7842   50     C  D01  86.56975 20,000_cells + HCMEC D3_line      4000
      7843   55     C  D01  85.50607 20,000_cells + HCMEC D3_line      4000
      7844   60     C  D01  85.84227 20,000_cells + HCMEC D3_line      4000
      7845   65     C  D01  86.97562 20,000_cells + HCMEC D3_line      4000
      7846   70     C  D01  88.50815 20,000_cells + HCMEC D3_line      4000
      7847   75     C  D01  90.40084 20,000_cells + HCMEC D3_line      4000
      7848   80     C  D01  92.35241 20,000_cells + HCMEC D3_line      4000
      7849   85     C  D01  93.61666 20,000_cells + HCMEC D3_line      4000
      7850   90     C  D01  94.72030 20,000_cells + HCMEC D3_line      4000
      7851   95     C  D01  96.31050 20,000_cells + HCMEC D3_line      4000
      7852  100     C  D01  96.58933 20,000_cells + HCMEC D3_line      4000
      7853  105     C  D01  97.11312 20,000_cells + HCMEC D3_line      4000
      7854  110     C  D01  97.76129 20,000_cells + HCMEC D3_line      4000
      7855  115     C  D01  98.60619 20,000_cells + HCMEC D3_line      4000
      7856  120     C  D01  99.63568 20,000_cells + HCMEC D3_line      4000
      7857  125     C  D01 100.86616 20,000_cells + HCMEC D3_line      4000
      7858  130     C  D01 101.90292 20,000_cells + HCMEC D3_line      4000
      7859  135     C  D01 102.98435 20,000_cells + HCMEC D3_line      4000
      7860  140     C  D01 103.27413 20,000_cells + HCMEC D3_line      4000
      7861  145     C  D01 103.85404 20,000_cells + HCMEC D3_line      4000
      7862  150     C  D01 104.87479 20,000_cells + HCMEC D3_line      4000
      7863  155     C  D01 106.03627 20,000_cells + HCMEC D3_line      4000
      7864  160     C  D01 106.61107 20,000_cells + HCMEC D3_line      4000
      7865  165     C  D01 107.42607 20,000_cells + HCMEC D3_line      4000
      7866  170     C  D01  92.15565 20,000_cells + HCMEC D3_line      4000
      7867  175     C  D01  92.73625 20,000_cells + HCMEC D3_line      4000
      7868  180     C  D01  94.19267 20,000_cells + HCMEC D3_line      4000
      7869  185     C  D01  95.54663 20,000_cells + HCMEC D3_line      4000
      7870  190     C  D01  97.64331 20,000_cells + HCMEC D3_line      4000
      7871  195     C  D01  98.98677 20,000_cells + HCMEC D3_line      4000
      7872  200     C  D01        NA 20,000_cells + HCMEC D3_line      4000
      7873    0     C  D01        NA 20,000_cells + HCMEC D3_line       500
      7874    5     C  D01 120.83394 20,000_cells + HCMEC D3_line       500
      7875   10     C  D01 120.94996 20,000_cells + HCMEC D3_line       500
      7876   15     C  D01 120.66601 20,000_cells + HCMEC D3_line       500
      7877   20     C  D01 120.40552 20,000_cells + HCMEC D3_line       500
      7878   25     C  D01 120.14746 20,000_cells + HCMEC D3_line       500
      7879   30     C  D01 120.10182 20,000_cells + HCMEC D3_line       500
      7880   35     C  D01 120.35716 20,000_cells + HCMEC D3_line       500
      7881   40     C  D01 120.41210 20,000_cells + HCMEC D3_line       500
      7882   45     C  D01 120.54044 20,000_cells + HCMEC D3_line       500
      7883   50     C  D01 120.91133 20,000_cells + HCMEC D3_line       500
      7884   55     C  D01 121.09478 20,000_cells + HCMEC D3_line       500
      7885   60     C  D01 121.61675 20,000_cells + HCMEC D3_line       500
      7886   65     C  D01 122.09011 20,000_cells + HCMEC D3_line       500
      7887   70     C  D01 122.51530 20,000_cells + HCMEC D3_line       500
      7888   75     C  D01 122.88727 20,000_cells + HCMEC D3_line       500
      7889   80     C  D01 123.19520 20,000_cells + HCMEC D3_line       500
      7890   85     C  D01 123.60184 20,000_cells + HCMEC D3_line       500
      7891   90     C  D01 123.86779 20,000_cells + HCMEC D3_line       500
      7892   95     C  D01 124.18017 20,000_cells + HCMEC D3_line       500
      7893  100     C  D01 124.33335 20,000_cells + HCMEC D3_line       500
      7894  105     C  D01 124.43557 20,000_cells + HCMEC D3_line       500
      7895  110     C  D01 124.54978 20,000_cells + HCMEC D3_line       500
      7896  115     C  D01 124.67299 20,000_cells + HCMEC D3_line       500
      7897  120     C  D01 124.81783 20,000_cells + HCMEC D3_line       500
      7898  125     C  D01 125.00960 20,000_cells + HCMEC D3_line       500
      7899  130     C  D01 125.16809 20,000_cells + HCMEC D3_line       500
      7900  135     C  D01 125.32208 20,000_cells + HCMEC D3_line       500
      7901  140     C  D01 125.34002 20,000_cells + HCMEC D3_line       500
      7902  145     C  D01 125.41856 20,000_cells + HCMEC D3_line       500
      7903  150     C  D01 125.56973 20,000_cells + HCMEC D3_line       500
      7904  155     C  D01 125.67710 20,000_cells + HCMEC D3_line       500
      7905  160     C  D01 125.75840 20,000_cells + HCMEC D3_line       500
      7906  165     C  D01 125.81278 20,000_cells + HCMEC D3_line       500
      7907  170     C  D01 123.77698 20,000_cells + HCMEC D3_line       500
      7908  175     C  D01 124.02043 20,000_cells + HCMEC D3_line       500
      7909  180     C  D01 124.24890 20,000_cells + HCMEC D3_line       500
      7910  185     C  D01 124.30329 20,000_cells + HCMEC D3_line       500
      7911  190     C  D01 124.61441 20,000_cells + HCMEC D3_line       500
      7912  195     C  D01 124.80997 20,000_cells + HCMEC D3_line       500
      7913  200     C  D01        NA 20,000_cells + HCMEC D3_line       500
      7914    0     C  D01        NA 20,000_cells + HCMEC D3_line     64000
      7915    5     C  D01  58.16140 20,000_cells + HCMEC D3_line     64000
      7916   10     C  D01  54.40202 20,000_cells + HCMEC D3_line     64000
      7917   15     C  D01  49.77951 20,000_cells + HCMEC D3_line     64000
      7918   20     C  D01  45.05251 20,000_cells + HCMEC D3_line     64000
      7919   25     C  D01  41.38464 20,000_cells + HCMEC D3_line     64000
      7920   30     C  D01  38.71678 20,000_cells + HCMEC D3_line     64000
      7921   35     C  D01  36.45614 20,000_cells + HCMEC D3_line     64000
      7922   40     C  D01  33.96307 20,000_cells + HCMEC D3_line     64000
      7923   45     C  D01  30.77689 20,000_cells + HCMEC D3_line     64000
      7924   50     C  D01  28.10208 20,000_cells + HCMEC D3_line     64000
      7925   55     C  D01  23.62665 20,000_cells + HCMEC D3_line     64000
      7926   60     C  D01  19.61586 20,000_cells + HCMEC D3_line     64000
      7927   65     C  D01  16.14664 20,000_cells + HCMEC D3_line     64000
      7928   70     C  D01  14.19239 20,000_cells + HCMEC D3_line     64000
      7929   75     C  D01  12.65740 20,000_cells + HCMEC D3_line     64000
      7930   80     C  D01  11.47414 20,000_cells + HCMEC D3_line     64000
      7931   85     C  D01  11.40049 20,000_cells + HCMEC D3_line     64000
      7932   90     C  D01  11.24641 20,000_cells + HCMEC D3_line     64000
      7933   95     C  D01  11.31212 20,000_cells + HCMEC D3_line     64000
      7934  100     C  D01  11.47024 20,000_cells + HCMEC D3_line     64000
      7935  105     C  D01  11.88934 20,000_cells + HCMEC D3_line     64000
      7936  110     C  D01  12.07081 20,000_cells + HCMEC D3_line     64000
      7937  115     C  D01  12.60327 20,000_cells + HCMEC D3_line     64000
      7938  120     C  D01  12.97674 20,000_cells + HCMEC D3_line     64000
      7939  125     C  D01  13.69169 20,000_cells + HCMEC D3_line     64000
      7940  130     C  D01  14.10123 20,000_cells + HCMEC D3_line     64000
      7941  135     C  D01  14.88309 20,000_cells + HCMEC D3_line     64000
      7942  140     C  D01  15.46932 20,000_cells + HCMEC D3_line     64000
      7943  145     C  D01  15.91230 20,000_cells + HCMEC D3_line     64000
      7944  150     C  D01  16.71988 20,000_cells + HCMEC D3_line     64000
      7945  155     C  D01  17.24346 20,000_cells + HCMEC D3_line     64000
      7946  160     C  D01  17.86757 20,000_cells + HCMEC D3_line     64000
      7947  165     C  D01  18.68680 20,000_cells + HCMEC D3_line     64000
      7948  170     C  D01  11.52644 20,000_cells + HCMEC D3_line     64000
      7949  175     C  D01  11.40162 20,000_cells + HCMEC D3_line     64000
      7950  180     C  D01  12.44920 20,000_cells + HCMEC D3_line     64000
      7951  185     C  D01  13.50601 20,000_cells + HCMEC D3_line     64000
      7952  190     C  D01  15.54990 20,000_cells + HCMEC D3_line     64000
      7953  195     C  D01  16.95940 20,000_cells + HCMEC D3_line     64000
      7954  200     C  D01        NA 20,000_cells + HCMEC D3_line     64000
      7955    0     C  D01        NA 20,000_cells + HCMEC D3_line      8000
      7956    5     C  D01 101.22000 20,000_cells + HCMEC D3_line      8000
      7957   10     C  D01  96.78336 20,000_cells + HCMEC D3_line      8000
      7958   15     C  D01  90.84010 20,000_cells + HCMEC D3_line      8000
      7959   20     C  D01  85.05681 20,000_cells + HCMEC D3_line      8000
      7960   25     C  D01  80.48323 20,000_cells + HCMEC D3_line      8000
      7961   30     C  D01  76.98465 20,000_cells + HCMEC D3_line      8000
      7962   35     C  D01  74.69785 20,000_cells + HCMEC D3_line      8000
      7963   40     C  D01  71.70737 20,000_cells + HCMEC D3_line      8000
      7964   45     C  D01  68.99928 20,000_cells + HCMEC D3_line      8000
      7965   50     C  D01  67.21503 20,000_cells + HCMEC D3_line      8000
      7966   55     C  D01  64.62954 20,000_cells + HCMEC D3_line      8000
      7967   60     C  D01  63.29500 20,000_cells + HCMEC D3_line      8000
      7968   65     C  D01  63.35098 20,000_cells + HCMEC D3_line      8000
      7969   70     C  D01  64.46661 20,000_cells + HCMEC D3_line      8000
      7970   75     C  D01  66.12334 20,000_cells + HCMEC D3_line      8000
      7971   80     C  D01  67.96402 20,000_cells + HCMEC D3_line      8000
      7972   85     C  D01  69.01184 20,000_cells + HCMEC D3_line      8000
      7973   90     C  D01  70.18069 20,000_cells + HCMEC D3_line      8000
      7974   95     C  D01  71.76641 20,000_cells + HCMEC D3_line      8000
      7975  100     C  D01  72.18300 20,000_cells + HCMEC D3_line      8000
      7976  105     C  D01  73.04094 20,000_cells + HCMEC D3_line      8000
      7977  110     C  D01  74.19536 20,000_cells + HCMEC D3_line      8000
      7978  115     C  D01  75.58143 20,000_cells + HCMEC D3_line      8000
      7979  120     C  D01  76.99665 20,000_cells + HCMEC D3_line      8000
      7980  125     C  D01  78.65788 20,000_cells + HCMEC D3_line      8000
      7981  130     C  D01  80.22209 20,000_cells + HCMEC D3_line      8000
      7982  135     C  D01  81.77726 20,000_cells + HCMEC D3_line      8000
      7983  140     C  D01  82.40726 20,000_cells + HCMEC D3_line      8000
      7984  145     C  D01  83.54546 20,000_cells + HCMEC D3_line      8000
      7985  150     C  D01  85.03282 20,000_cells + HCMEC D3_line      8000
      7986  155     C  D01  86.65170 20,000_cells + HCMEC D3_line      8000
      7987  160     C  D01  87.47531 20,000_cells + HCMEC D3_line      8000
      7988  165     C  D01  88.81312 20,000_cells + HCMEC D3_line      8000
      7989  170     C  D01  68.19167 20,000_cells + HCMEC D3_line      8000
      7990  175     C  D01  68.17501 20,000_cells + HCMEC D3_line      8000
      7991  180     C  D01  70.08232 20,000_cells + HCMEC D3_line      8000
      7992  185     C  D01  72.20379 20,000_cells + HCMEC D3_line      8000
      7993  190     C  D01  74.99188 20,000_cells + HCMEC D3_line      8000
      7994  195     C  D01  76.96411 20,000_cells + HCMEC D3_line      8000
      7995  200     C  D01        NA 20,000_cells + HCMEC D3_line      8000
      7996    0     C  D02        NA 20,000_cells + HCMEC D3_line      1000
      7997    5     C  D02 118.15003 20,000_cells + HCMEC D3_line      1000
      7998   10     C  D02 117.45272 20,000_cells + HCMEC D3_line      1000
      7999   15     C  D02 116.52096 20,000_cells + HCMEC D3_line      1000
      8000   20     C  D02 115.76489 20,000_cells + HCMEC D3_line      1000
      8001   25     C  D02 115.41886 20,000_cells + HCMEC D3_line      1000
      8002   30     C  D02 114.83719 20,000_cells + HCMEC D3_line      1000
      8003   35     C  D02 114.48959 20,000_cells + HCMEC D3_line      1000
      8004   40     C  D02 114.41941 20,000_cells + HCMEC D3_line      1000
      8005   45     C  D02 114.60362 20,000_cells + HCMEC D3_line      1000
      8006   50     C  D02 114.75890 20,000_cells + HCMEC D3_line      1000
      8007   55     C  D02 114.99021 20,000_cells + HCMEC D3_line      1000
      8008   60     C  D02 115.45432 20,000_cells + HCMEC D3_line      1000
      8009   65     C  D02 116.08672 20,000_cells + HCMEC D3_line      1000
      8010   70     C  D02 116.94630 20,000_cells + HCMEC D3_line      1000
      8011   75     C  D02 117.57082 20,000_cells + HCMEC D3_line      1000
      8012   80     C  D02 118.26395 20,000_cells + HCMEC D3_line      1000
      8013   85     C  D02 118.80270 20,000_cells + HCMEC D3_line      1000
      8014   90     C  D02 119.28714 20,000_cells + HCMEC D3_line      1000
      8015   95     C  D02 119.61761 20,000_cells + HCMEC D3_line      1000
      8016  100     C  D02 119.90985 20,000_cells + HCMEC D3_line      1000
      8017  105     C  D02 119.91843 20,000_cells + HCMEC D3_line      1000
      8018  110     C  D02 120.33763 20,000_cells + HCMEC D3_line      1000
      8019  115     C  D02 120.50082 20,000_cells + HCMEC D3_line      1000
      8020  120     C  D02 120.84304 20,000_cells + HCMEC D3_line      1000
      8021  125     C  D02 121.21045 20,000_cells + HCMEC D3_line      1000
      8022  130     C  D02 121.44630 20,000_cells + HCMEC D3_line      1000
      8023  135     C  D02 121.74263 20,000_cells + HCMEC D3_line      1000
      8024  140     C  D02 121.86518 20,000_cells + HCMEC D3_line      1000
      8025  145     C  D02 122.20846 20,000_cells + HCMEC D3_line      1000
      8026  150     C  D02 122.46550 20,000_cells + HCMEC D3_line      1000
      8027  155     C  D02 122.60099 20,000_cells + HCMEC D3_line      1000
      8028  160     C  D02 122.69632 20,000_cells + HCMEC D3_line      1000
      8029  165     C  D02 122.90787 20,000_cells + HCMEC D3_line      1000
      8030  170     C  D02 123.15008 20,000_cells + HCMEC D3_line      1000
      8031  175     C  D02 123.30829 20,000_cells + HCMEC D3_line      1000
      8032  180     C  D02 123.45828 20,000_cells + HCMEC D3_line      1000
      8033  185     C  D02 123.63337 20,000_cells + HCMEC D3_line      1000
      8034  190     C  D02 123.69601 20,000_cells + HCMEC D3_line      1000
      8035  195     C  D02 123.76912 20,000_cells + HCMEC D3_line      1000
      8036  200     C  D02        NA 20,000_cells + HCMEC D3_line      1000
      8037    0     C  D02        NA 20,000_cells + HCMEC D3_line     16000
      8038    5     C  D02  89.38453 20,000_cells + HCMEC D3_line     16000
      8039   10     C  D02  83.04126 20,000_cells + HCMEC D3_line     16000
      8040   15     C  D02  76.14966 20,000_cells + HCMEC D3_line     16000
      8041   20     C  D02  69.78178 20,000_cells + HCMEC D3_line     16000
      8042   25     C  D02  64.94820 20,000_cells + HCMEC D3_line     16000
      8043   30     C  D02  60.65655 20,000_cells + HCMEC D3_line     16000
      8044   35     C  D02  56.50828 20,000_cells + HCMEC D3_line     16000
      8045   40     C  D02  53.56562 20,000_cells + HCMEC D3_line     16000
      8046   45     C  D02  50.91612 20,000_cells + HCMEC D3_line     16000
      8047   50     C  D02  47.94735 20,000_cells + HCMEC D3_line     16000
      8048   55     C  D02  44.45637 20,000_cells + HCMEC D3_line     16000
      8049   60     C  D02  42.15113 20,000_cells + HCMEC D3_line     16000
      8050   65     C  D02  41.19263 20,000_cells + HCMEC D3_line     16000
      8051   70     C  D02  40.95774 20,000_cells + HCMEC D3_line     16000
      8052   75     C  D02  40.79833 20,000_cells + HCMEC D3_line     16000
      8053   80     C  D02  40.81753 20,000_cells + HCMEC D3_line     16000
      8054   85     C  D02  41.75578 20,000_cells + HCMEC D3_line     16000
      8055   90     C  D02  42.45634 20,000_cells + HCMEC D3_line     16000
      8056   95     C  D02  42.49522 20,000_cells + HCMEC D3_line     16000
      8057  100     C  D02  43.28117 20,000_cells + HCMEC D3_line     16000
      8058  105     C  D02  44.02889 20,000_cells + HCMEC D3_line     16000
      8059  110     C  D02  45.54144 20,000_cells + HCMEC D3_line     16000
      8060  115     C  D02  46.75354 20,000_cells + HCMEC D3_line     16000
      8061  120     C  D02  48.62439 20,000_cells + HCMEC D3_line     16000
      8062  125     C  D02  50.17406 20,000_cells + HCMEC D3_line     16000
      8063  130     C  D02  52.00304 20,000_cells + HCMEC D3_line     16000
      8064  135     C  D02  53.33044 20,000_cells + HCMEC D3_line     16000
      8065  140     C  D02  54.30675 20,000_cells + HCMEC D3_line     16000
      8066  145     C  D02  55.70843 20,000_cells + HCMEC D3_line     16000
      8067  150     C  D02  57.50352 20,000_cells + HCMEC D3_line     16000
      8068  155     C  D02  58.66400 20,000_cells + HCMEC D3_line     16000
      8069  160     C  D02  59.78385 20,000_cells + HCMEC D3_line     16000
      8070  165     C  D02  61.17632 20,000_cells + HCMEC D3_line     16000
      8071  170     C  D02  62.49171 20,000_cells + HCMEC D3_line     16000
      8072  175     C  D02  63.94713 20,000_cells + HCMEC D3_line     16000
      8073  180     C  D02  65.36660 20,000_cells + HCMEC D3_line     16000
      8074  185     C  D02  66.88050 20,000_cells + HCMEC D3_line     16000
      8075  190     C  D02  67.95309 20,000_cells + HCMEC D3_line     16000
      8076  195     C  D02  68.89615 20,000_cells + HCMEC D3_line     16000
      8077  200     C  D02        NA 20,000_cells + HCMEC D3_line     16000
      8078    0     C  D02        NA 20,000_cells + HCMEC D3_line      2000
      8079    5     C  D02 114.86210 20,000_cells + HCMEC D3_line      2000
      8080   10     C  D02 112.77286 20,000_cells + HCMEC D3_line      2000
      8081   15     C  D02 110.31589 20,000_cells + HCMEC D3_line      2000
      8082   20     C  D02 108.22068 20,000_cells + HCMEC D3_line      2000
      8083   25     C  D02 106.74131 20,000_cells + HCMEC D3_line      2000
      8084   30     C  D02 105.07920 20,000_cells + HCMEC D3_line      2000
      8085   35     C  D02 103.80107 20,000_cells + HCMEC D3_line      2000
      8086   40     C  D02 103.20890 20,000_cells + HCMEC D3_line      2000
      8087   45     C  D02 102.83417 20,000_cells + HCMEC D3_line      2000
      8088   50     C  D02 102.82374 20,000_cells + HCMEC D3_line      2000
      8089   55     C  D02 102.96366 20,000_cells + HCMEC D3_line      2000
      8090   60     C  D02 103.86305 20,000_cells + HCMEC D3_line      2000
      8091   65     C  D02 105.02080 20,000_cells + HCMEC D3_line      2000
      8092   70     C  D02 106.64455 20,000_cells + HCMEC D3_line      2000
      8093   75     C  D02 107.77893 20,000_cells + HCMEC D3_line      2000
      8094   80     C  D02 108.73548 20,000_cells + HCMEC D3_line      2000
      8095   85     C  D02 109.66590 20,000_cells + HCMEC D3_line      2000
      8096   90     C  D02 110.46470 20,000_cells + HCMEC D3_line      2000
      8097   95     C  D02 110.97009 20,000_cells + HCMEC D3_line      2000
      8098  100     C  D02 111.43111 20,000_cells + HCMEC D3_line      2000
      8099  105     C  D02 111.43175 20,000_cells + HCMEC D3_line      2000
      8100  110     C  D02 112.11230 20,000_cells + HCMEC D3_line      2000
      8101  115     C  D02 112.34271 20,000_cells + HCMEC D3_line      2000
      8102  120     C  D02 113.04603 20,000_cells + HCMEC D3_line      2000
      8103  125     C  D02 113.76605 20,000_cells + HCMEC D3_line      2000
      8104  130     C  D02 114.38858 20,000_cells + HCMEC D3_line      2000
      8105  135     C  D02 114.86931 20,000_cells + HCMEC D3_line      2000
      8106  140     C  D02 115.07771 20,000_cells + HCMEC D3_line      2000
      8107  145     C  D02 115.66475 20,000_cells + HCMEC D3_line      2000
      8108  150     C  D02 116.30031 20,000_cells + HCMEC D3_line      2000
      8109  155     C  D02 116.60887 20,000_cells + HCMEC D3_line      2000
      8110  160     C  D02 116.84567 20,000_cells + HCMEC D3_line      2000
      8111  165     C  D02 117.35178 20,000_cells + HCMEC D3_line      2000
      8112  170     C  D02 117.82135 20,000_cells + HCMEC D3_line      2000
      8113  175     C  D02 118.22294 20,000_cells + HCMEC D3_line      2000
      8114  180     C  D02 118.62410 20,000_cells + HCMEC D3_line      2000
      8115  185     C  D02 119.10882 20,000_cells + HCMEC D3_line      2000
      8116  190     C  D02 119.28758 20,000_cells + HCMEC D3_line      2000
      8117  195     C  D02 119.50890 20,000_cells + HCMEC D3_line      2000
      8118  200     C  D02        NA 20,000_cells + HCMEC D3_line      2000
      8119    0     C  D02        NA 20,000_cells + HCMEC D3_line       250
      8120    5     C  D02 123.00555 20,000_cells + HCMEC D3_line       250
      8121   10     C  D02 122.90958 20,000_cells + HCMEC D3_line       250
      8122   15     C  D02 122.74932 20,000_cells + HCMEC D3_line       250
      8123   20     C  D02 122.75852 20,000_cells + HCMEC D3_line       250
      8124   25     C  D02 122.94345 20,000_cells + HCMEC D3_line       250
      8125   30     C  D02 123.01098 20,000_cells + HCMEC D3_line       250
      8126   35     C  D02 123.15287 20,000_cells + HCMEC D3_line       250
      8127   40     C  D02 123.26945 20,000_cells + HCMEC D3_line       250
      8128   45     C  D02 123.51254 20,000_cells + HCMEC D3_line       250
      8129   50     C  D02 123.67774 20,000_cells + HCMEC D3_line       250
      8130   55     C  D02 123.84439 20,000_cells + HCMEC D3_line       250
      8131   60     C  D02 123.95267 20,000_cells + HCMEC D3_line       250
      8132   65     C  D02 124.21390 20,000_cells + HCMEC D3_line       250
      8133   70     C  D02 124.45171 20,000_cells + HCMEC D3_line       250
      8134   75     C  D02 124.76833 20,000_cells + HCMEC D3_line       250
      8135   80     C  D02 125.13789 20,000_cells + HCMEC D3_line       250
      8136   85     C  D02 125.23269 20,000_cells + HCMEC D3_line       250
      8137   90     C  D02 125.50041 20,000_cells + HCMEC D3_line       250
      8138   95     C  D02 125.66177 20,000_cells + HCMEC D3_line       250
      8139  100     C  D02 125.80607 20,000_cells + HCMEC D3_line       250
      8140  105     C  D02 125.88915 20,000_cells + HCMEC D3_line       250
      8141  110     C  D02 126.06751 20,000_cells + HCMEC D3_line       250
      8142  115     C  D02 126.19735 20,000_cells + HCMEC D3_line       250
      8143  120     C  D02 126.31876 20,000_cells + HCMEC D3_line       250
      8144  125     C  D02 126.44312 20,000_cells + HCMEC D3_line       250
      8145  130     C  D02 126.50500 20,000_cells + HCMEC D3_line       250
      8146  135     C  D02 126.63079 20,000_cells + HCMEC D3_line       250
      8147  140     C  D02 126.69684 20,000_cells + HCMEC D3_line       250
      8148  145     C  D02 126.79246 20,000_cells + HCMEC D3_line       250
      8149  150     C  D02 126.86465 20,000_cells + HCMEC D3_line       250
      8150  155     C  D02 126.91082 20,000_cells + HCMEC D3_line       250
      8151  160     C  D02 126.96175 20,000_cells + HCMEC D3_line       250
      8152  165     C  D02 127.00824 20,000_cells + HCMEC D3_line       250
      8153  170     C  D02 127.06783 20,000_cells + HCMEC D3_line       250
      8154  175     C  D02 127.11335 20,000_cells + HCMEC D3_line       250
      8155  180     C  D02 127.14409 20,000_cells + HCMEC D3_line       250
      8156  185     C  D02 127.18732 20,000_cells + HCMEC D3_line       250
      8157  190     C  D02 127.21593 20,000_cells + HCMEC D3_line       250
      8158  195     C  D02 127.22799 20,000_cells + HCMEC D3_line       250
      8159  200     C  D02        NA 20,000_cells + HCMEC D3_line       250
      8160    0     C  D02        NA 20,000_cells + HCMEC D3_line     32000
      8161    5     C  D02  76.92251 20,000_cells + HCMEC D3_line     32000
      8162   10     C  D02  70.71684 20,000_cells + HCMEC D3_line     32000
      8163   15     C  D02  63.74390 20,000_cells + HCMEC D3_line     32000
      8164   20     C  D02  57.44535 20,000_cells + HCMEC D3_line     32000
      8165   25     C  D02  52.60625 20,000_cells + HCMEC D3_line     32000
      8166   30     C  D02  48.64019 20,000_cells + HCMEC D3_line     32000
      8167   35     C  D02  44.48792 20,000_cells + HCMEC D3_line     32000
      8168   40     C  D02  41.52552 20,000_cells + HCMEC D3_line     32000
      8169   45     C  D02  38.95242 20,000_cells + HCMEC D3_line     32000
      8170   50     C  D02  35.27485 20,000_cells + HCMEC D3_line     32000
      8171   55     C  D02  31.08506 20,000_cells + HCMEC D3_line     32000
      8172   60     C  D02  27.64589 20,000_cells + HCMEC D3_line     32000
      8173   65     C  D02  24.94971 20,000_cells + HCMEC D3_line     32000
      8174   70     C  D02  22.95589 20,000_cells + HCMEC D3_line     32000
      8175   75     C  D02  21.69343 20,000_cells + HCMEC D3_line     32000
      8176   80     C  D02  21.15773 20,000_cells + HCMEC D3_line     32000
      8177   85     C  D02  21.66150 20,000_cells + HCMEC D3_line     32000
      8178   90     C  D02  21.75895 20,000_cells + HCMEC D3_line     32000
      8179   95     C  D02  21.63278 20,000_cells + HCMEC D3_line     32000
      8180  100     C  D02  22.20878 20,000_cells + HCMEC D3_line     32000
      8181  105     C  D02  22.71472 20,000_cells + HCMEC D3_line     32000
      8182  110     C  D02  23.48771 20,000_cells + HCMEC D3_line     32000
      8183  115     C  D02  24.34242 20,000_cells + HCMEC D3_line     32000
      8184  120     C  D02  25.71022 20,000_cells + HCMEC D3_line     32000
      8185  125     C  D02  26.71482 20,000_cells + HCMEC D3_line     32000
      8186  130     C  D02  27.87584 20,000_cells + HCMEC D3_line     32000
      8187  135     C  D02  28.91303 20,000_cells + HCMEC D3_line     32000
      8188  140     C  D02  30.05877 20,000_cells + HCMEC D3_line     32000
      8189  145     C  D02  31.01174 20,000_cells + HCMEC D3_line     32000
      8190  150     C  D02  32.29381 20,000_cells + HCMEC D3_line     32000
      8191  155     C  D02  33.20530 20,000_cells + HCMEC D3_line     32000
      8192  160     C  D02  34.13983 20,000_cells + HCMEC D3_line     32000
      8193  165     C  D02  35.52905 20,000_cells + HCMEC D3_line     32000
      8194  170     C  D02  36.77509 20,000_cells + HCMEC D3_line     32000
      8195  175     C  D02  37.94313 20,000_cells + HCMEC D3_line     32000
      8196  180     C  D02  39.17890 20,000_cells + HCMEC D3_line     32000
      8197  185     C  D02  40.71046 20,000_cells + HCMEC D3_line     32000
      8198  190     C  D02  41.78213 20,000_cells + HCMEC D3_line     32000
      8199  195     C  D02  43.02926 20,000_cells + HCMEC D3_line     32000
      8200  200     C  D02        NA 20,000_cells + HCMEC D3_line     32000
      8201    0     C  D02        NA 20,000_cells + HCMEC D3_line      4000
      8202    5     C  D02 108.98647 20,000_cells + HCMEC D3_line      4000
      8203   10     C  D02 105.06038 20,000_cells + HCMEC D3_line      4000
      8204   15     C  D02 100.85083 20,000_cells + HCMEC D3_line      4000
      8205   20     C  D02  97.01971 20,000_cells + HCMEC D3_line      4000
      8206   25     C  D02  94.07741 20,000_cells + HCMEC D3_line      4000
      8207   30     C  D02  91.16655 20,000_cells + HCMEC D3_line      4000
      8208   35     C  D02  88.72073 20,000_cells + HCMEC D3_line      4000
      8209   40     C  D02  87.15524 20,000_cells + HCMEC D3_line      4000
      8210   45     C  D02  85.91001 20,000_cells + HCMEC D3_line      4000
      8211   50     C  D02  85.36541 20,000_cells + HCMEC D3_line      4000
      8212   55     C  D02  84.88242 20,000_cells + HCMEC D3_line      4000
      8213   60     C  D02  85.56657 20,000_cells + HCMEC D3_line      4000
      8214   65     C  D02  87.09910 20,000_cells + HCMEC D3_line      4000
      8215   70     C  D02  89.36036 20,000_cells + HCMEC D3_line      4000
      8216   75     C  D02  90.98317 20,000_cells + HCMEC D3_line      4000
      8217   80     C  D02  92.14081 20,000_cells + HCMEC D3_line      4000
      8218   85     C  D02  93.46262 20,000_cells + HCMEC D3_line      4000
      8219   90     C  D02  94.68849 20,000_cells + HCMEC D3_line      4000
      8220   95     C  D02  95.26874 20,000_cells + HCMEC D3_line      4000
      8221  100     C  D02  95.94489 20,000_cells + HCMEC D3_line      4000
      8222  105     C  D02  96.19673 20,000_cells + HCMEC D3_line      4000
      8223  110     C  D02  97.41532 20,000_cells + HCMEC D3_line      4000
      8224  115     C  D02  97.95937 20,000_cells + HCMEC D3_line      4000
      8225  120     C  D02  99.16886 20,000_cells + HCMEC D3_line      4000
      8226  125     C  D02 100.25265 20,000_cells + HCMEC D3_line      4000
      8227  130     C  D02 101.44158 20,000_cells + HCMEC D3_line      4000
      8228  135     C  D02 102.16931 20,000_cells + HCMEC D3_line      4000
      8229  140     C  D02 102.43379 20,000_cells + HCMEC D3_line      4000
      8230  145     C  D02 103.27656 20,000_cells + HCMEC D3_line      4000
      8231  150     C  D02 104.38944 20,000_cells + HCMEC D3_line      4000
      8232  155     C  D02 104.97576 20,000_cells + HCMEC D3_line      4000
      8233  160     C  D02 105.44913 20,000_cells + HCMEC D3_line      4000
      8234  165     C  D02 106.25282 20,000_cells + HCMEC D3_line      4000
      8235  170     C  D02 106.95120 20,000_cells + HCMEC D3_line      4000
      8236  175     C  D02 107.67166 20,000_cells + HCMEC D3_line      4000
      8237  180     C  D02 108.44336 20,000_cells + HCMEC D3_line      4000
      8238  185     C  D02 109.29686 20,000_cells + HCMEC D3_line      4000
      8239  190     C  D02 109.70989 20,000_cells + HCMEC D3_line      4000
      8240  195     C  D02 110.08568 20,000_cells + HCMEC D3_line      4000
      8241  200     C  D02        NA 20,000_cells + HCMEC D3_line      4000
      8242    0     C  D02        NA 20,000_cells + HCMEC D3_line       500
      8243    5     C  D02 120.80801 20,000_cells + HCMEC D3_line       500
      8244   10     C  D02 120.63129 20,000_cells + HCMEC D3_line       500
      8245   15     C  D02 120.33377 20,000_cells + HCMEC D3_line       500
      8246   20     C  D02 120.18310 20,000_cells + HCMEC D3_line       500
      8247   25     C  D02 120.30161 20,000_cells + HCMEC D3_line       500
      8248   30     C  D02 120.22828 20,000_cells + HCMEC D3_line       500
      8249   35     C  D02 120.25658 20,000_cells + HCMEC D3_line       500
      8250   40     C  D02 120.32277 20,000_cells + HCMEC D3_line       500
      8251   45     C  D02 120.62122 20,000_cells + HCMEC D3_line       500
      8252   50     C  D02 120.79474 20,000_cells + HCMEC D3_line       500
      8253   55     C  D02 120.97671 20,000_cells + HCMEC D3_line       500
      8254   60     C  D02 121.16244 20,000_cells + HCMEC D3_line       500
      8255   65     C  D02 121.54071 20,000_cells + HCMEC D3_line       500
      8256   70     C  D02 121.96665 20,000_cells + HCMEC D3_line       500
      8257   75     C  D02 122.36895 20,000_cells + HCMEC D3_line       500
      8258   80     C  D02 122.85074 20,000_cells + HCMEC D3_line       500
      8259   85     C  D02 123.08888 20,000_cells + HCMEC D3_line       500
      8260   90     C  D02 123.40660 20,000_cells + HCMEC D3_line       500
      8261   95     C  D02 123.61630 20,000_cells + HCMEC D3_line       500
      8262  100     C  D02 123.79727 20,000_cells + HCMEC D3_line       500
      8263  105     C  D02 123.85500 20,000_cells + HCMEC D3_line       500
      8264  110     C  D02 124.11113 20,000_cells + HCMEC D3_line       500
      8265  115     C  D02 124.25409 20,000_cells + HCMEC D3_line       500
      8266  120     C  D02 124.43589 20,000_cells + HCMEC D3_line       500
      8267  125     C  D02 124.64430 20,000_cells + HCMEC D3_line       500
      8268  130     C  D02 124.74011 20,000_cells + HCMEC D3_line       500
      8269  135     C  D02 124.93535 20,000_cells + HCMEC D3_line       500
      8270  140     C  D02 125.02308 20,000_cells + HCMEC D3_line       500
      8271  145     C  D02 125.18359 20,000_cells + HCMEC D3_line       500
      8272  150     C  D02 125.30754 20,000_cells + HCMEC D3_line       500
      8273  155     C  D02 125.37310 20,000_cells + HCMEC D3_line       500
      8274  160     C  D02 125.43008 20,000_cells + HCMEC D3_line       500
      8275  165     C  D02 125.51648 20,000_cells + HCMEC D3_line       500
      8276  170     C  D02 125.62969 20,000_cells + HCMEC D3_line       500
      8277  175     C  D02 125.69445 20,000_cells + HCMEC D3_line       500
      8278  180     C  D02 125.76036 20,000_cells + HCMEC D3_line       500
      8279  185     C  D02 125.82745 20,000_cells + HCMEC D3_line       500
      8280  190     C  D02 125.84690 20,000_cells + HCMEC D3_line       500
      8281  195     C  D02 125.88482 20,000_cells + HCMEC D3_line       500
      8282  200     C  D02        NA 20,000_cells + HCMEC D3_line       500
      8283    0     C  D02        NA 20,000_cells + HCMEC D3_line     64000
      8284    5     C  D02  58.82288 20,000_cells + HCMEC D3_line     64000
      8285   10     C  D02  53.88920 20,000_cells + HCMEC D3_line     64000
      8286   15     C  D02  48.38653 20,000_cells + HCMEC D3_line     64000
      8287   20     C  D02  43.40303 20,000_cells + HCMEC D3_line     64000
      8288   25     C  D02  39.58901 20,000_cells + HCMEC D3_line     64000
      8289   30     C  D02  36.66602 20,000_cells + HCMEC D3_line     64000
      8290   35     C  D02  33.29575 20,000_cells + HCMEC D3_line     64000
      8291   40     C  D02  30.88650 20,000_cells + HCMEC D3_line     64000
      8292   45     C  D02  28.76245 20,000_cells + HCMEC D3_line     64000
      8293   50     C  D02  25.24527 20,000_cells + HCMEC D3_line     64000
      8294   55     C  D02  21.61210 20,000_cells + HCMEC D3_line     64000
      8295   60     C  D02  18.15389 20,000_cells + HCMEC D3_line     64000
      8296   65     C  D02  15.06006 20,000_cells + HCMEC D3_line     64000
      8297   70     C  D02  12.71051 20,000_cells + HCMEC D3_line     64000
      8298   75     C  D02  11.40977 20,000_cells + HCMEC D3_line     64000
      8299   80     C  D02  10.92051 20,000_cells + HCMEC D3_line     64000
      8300   85     C  D02  11.18328 20,000_cells + HCMEC D3_line     64000
      8301   90     C  D02  11.08636 20,000_cells + HCMEC D3_line     64000
      8302   95     C  D02  11.01593 20,000_cells + HCMEC D3_line     64000
      8303  100     C  D02  11.32401 20,000_cells + HCMEC D3_line     64000
      8304  105     C  D02  11.55713 20,000_cells + HCMEC D3_line     64000
      8305  110     C  D02  11.79691 20,000_cells + HCMEC D3_line     64000
      8306  115     C  D02  12.23917 20,000_cells + HCMEC D3_line     64000
      8307  120     C  D02  12.88931 20,000_cells + HCMEC D3_line     64000
      8308  125     C  D02  13.32336 20,000_cells + HCMEC D3_line     64000
      8309  130     C  D02  13.82659 20,000_cells + HCMEC D3_line     64000
      8310  135     C  D02  14.34093 20,000_cells + HCMEC D3_line     64000
      8311  140     C  D02  15.10700 20,000_cells + HCMEC D3_line     64000
      8312  145     C  D02  15.54555 20,000_cells + HCMEC D3_line     64000
      8313  150     C  D02  16.12165 20,000_cells + HCMEC D3_line     64000
      8314  155     C  D02  16.57459 20,000_cells + HCMEC D3_line     64000
      8315  160     C  D02  17.01227 20,000_cells + HCMEC D3_line     64000
      8316  165     C  D02  17.93866 20,000_cells + HCMEC D3_line     64000
      8317  170     C  D02  18.71613 20,000_cells + HCMEC D3_line     64000
      8318  175     C  D02  19.21560 20,000_cells + HCMEC D3_line     64000
      8319  180     C  D02  19.93319 20,000_cells + HCMEC D3_line     64000
      8320  185     C  D02  20.97170 20,000_cells + HCMEC D3_line     64000
      8321  190     C  D02  21.64498 20,000_cells + HCMEC D3_line     64000
      8322  195     C  D02  22.71451 20,000_cells + HCMEC D3_line     64000
      8323  200     C  D02        NA 20,000_cells + HCMEC D3_line     64000
      8324    0     C  D02        NA 20,000_cells + HCMEC D3_line      8000
      8325    5     C  D02  99.77300 20,000_cells + HCMEC D3_line      8000
      8326   10     C  D02  94.25310 20,000_cells + HCMEC D3_line      8000
      8327   15     C  D02  88.38985 20,000_cells + HCMEC D3_line      8000
      8328   20     C  D02  82.98037 20,000_cells + HCMEC D3_line      8000
      8329   25     C  D02  78.85208 20,000_cells + HCMEC D3_line      8000
      8330   30     C  D02  74.99989 20,000_cells + HCMEC D3_line      8000
      8331   35     C  D02  71.52670 20,000_cells + HCMEC D3_line      8000
      8332   40     C  D02  69.08586 20,000_cells + HCMEC D3_line      8000
      8333   45     C  D02  66.96274 20,000_cells + HCMEC D3_line      8000
                 Experiment cells     line Instrument SampleID Excluded
      1    1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2    1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3    1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4    1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      5    1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      6    1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      7    1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      8    1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      9    1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      10   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      11   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      12   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      13   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      14   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      15   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      16   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      17   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      18   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      19   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      20   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      21   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      22   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      23   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      24   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      25   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      26   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      27   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      28   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      29   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      30   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      31   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      32   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      33   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      34   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      35   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      36   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      37   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      38   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      39   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      40   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      41   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      42   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      43   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      44   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      45   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      46   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      47   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      48   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      49   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      50   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      51   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      52   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      53   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      54   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      55   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      56   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      57   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      58   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      59   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      60   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      61   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      62   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      63   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      64   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      65   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      66   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      67   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      68   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      69   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      70   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      71   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      72   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      73   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      74   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      75   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      76   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      77   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      78   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      79   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      80   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      81   1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      82   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      83   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      84   1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      85   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      86   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      87   1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      88   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      89   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      90   1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      91   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      92   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      93   1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      94   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      95   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      96   1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      97   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      98   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      99   1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      100  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      101  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      102  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      103  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      104  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      105  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      106  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      107  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      108  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      109  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      110  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      111  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      112  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      113  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      114  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      115  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      116  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      117  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      118  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      119  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      120  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      121  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      122  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      123  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      124  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      125  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      126  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      127  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      128  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      129  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      130  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      131  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      132  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      133  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      134  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      135  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      136  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      137  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      138  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      139  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      140  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      141  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      142  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      143  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      144  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      145  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      146  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      147  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      148  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      149  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      150  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      151  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      152  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      153  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      154  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      155  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      156  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      157  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      158  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      159  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      160  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      161  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      162  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      163  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      164  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      165  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      166  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      167  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      168  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      169  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      170  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      171  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      172  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      173  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      174  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      175  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      176  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      177  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      178  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      179  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      180  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      181  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      182  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      183  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      184  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      185  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      186  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      187  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      188  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      189  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      190  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      191  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      192  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      193  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      194  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      195  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      196  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      197  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      198  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      199  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      200  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      201  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      202  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      203  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      204  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      205  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      206  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      207  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      208  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      209  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      210  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      211  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      212  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      213  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      214  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      215  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      216  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      217  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      218  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      219  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      220  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      221  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      222  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      223  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      224  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      225  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      226  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      227  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      228  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      229  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      230  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      231  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      232  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      233  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      234  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      235  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      236  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      237  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      238  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      239  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      240  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      241  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      242  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      243  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      244  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      245  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      246  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      247  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      248  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      249  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      250  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      251  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      252  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      253  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      254  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      255  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      256  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      257  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      258  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      259  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      260  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      261  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      262  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      263  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      264  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      265  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      266  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      267  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      268  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      269  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      270  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      271  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      272  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      273  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      274  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      275  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      276  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      277  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      278  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      279  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      280  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      281  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      282  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      283  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      284  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      285  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      286  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      287  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      288  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      289  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      290  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      291  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      292  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      293  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      294  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      295  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      296  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      297  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      298  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      299  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      300  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      301  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      302  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      303  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      304  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      305  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      306  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      307  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      308  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      309  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      310  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      311  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      312  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      313  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      314  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      315  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      316  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      317  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      318  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      319  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      320  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      321  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      322  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      323  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      324  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      325  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      326  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      327  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      328  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      329  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      330  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      331  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      332  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      333  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      334  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      335  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      336  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      337  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      338  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      339  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      340  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      341  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      342  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      343  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      344  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      345  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      346  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      347  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      348  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      349  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      350  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      351  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      352  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      353  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      354  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      355  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      356  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      357  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      358  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      359  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      360  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      361  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      362  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      363  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      364  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      365  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      366  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      367  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      368  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      369  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      370  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      371  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      372  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      373  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      374  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      375  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      376  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      377  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      378  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      379  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      380  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      381  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      382  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      383  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      384  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      385  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      386  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      387  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      388  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      389  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      390  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      391  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      392  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      393  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      394  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      395  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      396  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      397  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      398  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      399  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      400  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      401  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      402  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      403  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      404  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      405  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      406  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      407  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      408  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      409  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      410  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      411  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      412  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      413  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      414  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      415  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      416  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      417  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      418  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      419  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      420  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      421  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      422  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      423  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      424  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      425  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      426  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      427  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      428  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      429  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      430  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      431  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      432  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      433  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      434  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      435  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      436  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      437  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      438  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      439  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      440  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      441  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      442  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      443  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      444  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      445  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      446  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      447  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      448  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      449  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      450  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      451  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      452  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      453  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      454  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      455  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      456  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      457  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      458  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      459  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      460  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      461  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      462  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      463  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      464  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      465  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      466  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      467  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      468  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      469  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      470  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      471  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      472  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      473  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      474  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      475  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      476  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      477  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      478  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      479  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      480  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      481  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      482  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      483  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      484  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      485  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      486  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      487  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      488  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      489  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      490  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      491  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      492  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      493  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      494  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      495  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      496  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      497  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      498  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      499  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      500  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      501  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      502  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      503  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      504  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      505  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      506  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      507  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      508  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      509  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      510  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      511  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      512  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      513  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      514  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      515  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      516  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      517  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      518  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      519  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      520  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      521  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      522  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      523  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      524  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      525  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      526  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      527  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      528  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      529  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      530  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      531  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      532  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      533  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      534  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      535  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      536  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      537  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      538  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      539  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      540  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      541  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      542  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      543  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      544  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      545  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      546  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      547  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      548  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      549  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      550  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      551  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      552  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      553  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      554  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      555  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      556  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      557  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      558  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      559  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      560  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      561  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      562  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      563  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      564  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      565  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      566  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      567  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      568  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      569  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      570  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      571  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      572  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      573  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      574  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      575  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      576  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      577  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      578  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      579  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      580  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      581  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      582  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      583  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      584  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      585  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      586  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      587  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      588  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      589  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      590  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      591  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      592  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      593  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      594  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      595  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      596  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      597  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      598  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      599  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      600  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      601  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      602  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      603  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      604  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      605  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      606  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      607  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      608  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      609  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      610  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      611  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      612  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      613  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      614  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      615  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      616  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      617  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      618  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      619  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      620  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      621  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      622  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      623  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      624  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      625  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      626  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      627  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      628  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      629  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      630  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      631  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      632  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      633  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      634  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      635  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      636  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      637  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      638  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      639  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      640  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      641  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      642  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      643  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      644  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      645  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      646  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      647  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      648  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      649  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      650  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      651  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      652  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      653  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      654  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      655  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      656  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      657  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      658  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      659  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      660  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      661  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      662  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      663  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      664  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      665  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      666  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      667  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      668  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      669  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      670  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      671  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      672  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      673  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      674  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      675  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      676  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      677  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      678  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      679  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      680  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      681  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      682  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      683  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      684  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      685  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      686  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      687  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      688  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      689  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      690  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      691  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      692  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      693  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      694  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      695  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      696  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      697  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      698  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      699  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      700  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      701  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      702  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      703  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      704  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      705  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      706  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      707  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      708  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      709  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      710  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      711  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      712  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      713  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      714  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      715  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      716  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      717  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      718  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      719  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      720  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      721  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      722  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      723  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      724  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      725  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      726  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      727  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      728  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      729  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      730  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      731  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      732  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      733  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      734  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      735  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      736  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      737  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      738  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      739  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      740  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      741  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      742  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      743  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      744  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      745  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      746  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      747  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      748  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      749  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      750  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      751  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      752  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      753  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      754  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      755  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      756  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      757  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      758  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      759  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      760  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      761  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      762  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      763  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      764  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      765  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      766  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      767  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      768  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      769  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      770  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      771  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      772  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      773  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      774  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      775  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      776  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      777  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      778  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      779  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      780  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      781  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      782  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      783  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      784  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      785  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      786  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      787  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      788  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      789  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      790  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      791  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      792  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      793  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      794  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      795  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      796  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      797  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      798  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      799  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      800  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      801  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      802  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      803  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      804  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      805  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      806  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      807  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      808  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      809  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      810  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      811  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      812  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      813  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      814  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      815  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      816  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      817  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      818  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      819  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      820  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      821  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      822  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      823  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      824  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      825  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      826  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      827  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      828  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      829  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      830  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      831  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      832  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      833  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      834  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      835  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      836  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      837  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      838  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      839  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      840  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      841  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      842  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      843  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      844  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      845  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      846  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      847  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      848  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      849  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      850  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      851  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      852  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      853  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      854  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      855  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      856  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      857  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      858  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      859  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      860  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      861  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      862  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      863  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      864  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      865  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      866  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      867  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      868  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      869  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      870  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      871  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      872  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      873  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      874  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      875  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      876  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      877  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      878  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      879  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      880  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      881  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      882  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      883  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      884  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      885  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      886  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      887  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      888  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      889  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      890  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      891  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      892  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      893  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      894  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      895  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      896  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      897  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      898  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      899  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      900  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      901  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      902  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      903  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      904  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      905  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      906  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      907  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      908  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      909  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      910  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      911  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      912  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      913  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      914  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      915  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      916  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      917  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      918  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      919  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      920  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      921  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      922  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      923  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      924  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      925  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      926  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      927  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      928  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      929  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      930  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      931  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      932  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      933  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      934  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      935  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      936  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      937  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      938  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      939  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      940  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      941  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      942  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      943  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      944  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      945  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      946  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      947  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      948  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      949  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      950  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      951  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      952  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      953  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      954  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      955  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      956  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      957  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      958  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      959  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      960  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      961  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      962  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      963  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      964  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      965  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      966  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      967  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      968  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      969  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      970  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      971  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      972  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      973  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      974  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      975  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      976  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      977  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      978  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      979  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      980  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      981  1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      982  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      983  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      984  1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      985  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      986  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      987  1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      988  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      989  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      990  1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      991  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      992  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      993  1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      994  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      995  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      996  1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      997  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      998  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      999  1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1000 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1001 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1002 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1003 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1004 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1005 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1006 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1007 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1008 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1009 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1010 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1011 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1012 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1013 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1014 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1015 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1016 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1017 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1018 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1019 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1020 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1021 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1022 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1023 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1024 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1025 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1026 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1027 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1028 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1029 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1030 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1031 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1032 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1033 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1034 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1035 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1036 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1037 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1038 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1039 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1040 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1041 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1042 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1043 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1044 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1045 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1046 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1047 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1048 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1049 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1050 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1051 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1052 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1053 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1054 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1055 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1056 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1057 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1058 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1059 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1060 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1061 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1062 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1063 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1064 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1065 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1066 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1067 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1068 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1069 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1070 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1071 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1072 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1073 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1074 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1075 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1076 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1077 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1078 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1079 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1080 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1081 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1082 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1083 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1084 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1085 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1086 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1087 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1088 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1089 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1090 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1091 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1092 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1093 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1094 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1095 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1096 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1097 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1098 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1099 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1100 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1101 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1102 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1103 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1104 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1105 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1106 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1107 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1108 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1109 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1110 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1111 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1112 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1113 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1114 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1115 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1116 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1117 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1118 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1119 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1120 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1121 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1122 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1123 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1124 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1125 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1126 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1127 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1128 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1129 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1130 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1131 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1132 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1133 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1134 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1135 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1136 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1137 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1138 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1139 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1140 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1141 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1142 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1143 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1144 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1145 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1146 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1147 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1148 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1149 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1150 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1151 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1152 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1153 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1154 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1155 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1156 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1157 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1158 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1159 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1160 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1161 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1162 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1163 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1164 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1165 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1166 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1167 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1168 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1169 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1170 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1171 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1172 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1173 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1174 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1175 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1176 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1177 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1178 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1179 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1180 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1181 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1182 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1183 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1184 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1185 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1186 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1187 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1188 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1189 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1190 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1191 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1192 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1193 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1194 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1195 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1196 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1197 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1198 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1199 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1200 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1201 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1202 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1203 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1204 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1205 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1206 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1207 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1208 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1209 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1210 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1211 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1212 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1213 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1214 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1215 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1216 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1217 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1218 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1219 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1220 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1221 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1222 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1223 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1224 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1225 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1226 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1227 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1228 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1229 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1230 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1231 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1232 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1233 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1234 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1235 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1236 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1237 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1238 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1239 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1240 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1241 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1242 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1243 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1244 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1245 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1246 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1247 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1248 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1249 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1250 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1251 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1252 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1253 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1254 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1255 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1256 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1257 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1258 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1259 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1260 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1261 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1262 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1263 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1264 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1265 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1266 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1267 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1268 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1269 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1270 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1271 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1272 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1273 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1274 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1275 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1276 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1277 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1278 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1279 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1280 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1281 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1282 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1283 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1284 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1285 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1286 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1287 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1288 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1289 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1290 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1291 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1292 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1293 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1294 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1295 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1296 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1297 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1298 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1299 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1300 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1301 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1302 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1303 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1304 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1305 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1306 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1307 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1308 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1309 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1310 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1311 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1312 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1313 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1314 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1315 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1316 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1317 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1318 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1319 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1320 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1321 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1322 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1323 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1324 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1325 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1326 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1327 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1328 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1329 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1330 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1331 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1332 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1333 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1334 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1335 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1336 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1337 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1338 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1339 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1340 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1341 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1342 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1343 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1344 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1345 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1346 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1347 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1348 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1349 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1350 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1351 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1352 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1353 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1354 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1355 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1356 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1357 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1358 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1359 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1360 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1361 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1362 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1363 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1364 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1365 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1366 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1367 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1368 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1369 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1370 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1371 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1372 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1373 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1374 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1375 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1376 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1377 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1378 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1379 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1380 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1381 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1382 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1383 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1384 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1385 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1386 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1387 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1388 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1389 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1390 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1391 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1392 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1393 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1394 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1395 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1396 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1397 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1398 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1399 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1400 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1401 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1402 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1403 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1404 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1405 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1406 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1407 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1408 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1409 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1410 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1411 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1412 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1413 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1414 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1415 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1416 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1417 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1418 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1419 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1420 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1421 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1422 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1423 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1424 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1425 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1426 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1427 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1428 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1429 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1430 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1431 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1432 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1433 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1434 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1435 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1436 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1437 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1438 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1439 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1440 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1441 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1442 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1443 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1444 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1445 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1446 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1447 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1448 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1449 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1450 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1451 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1452 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1453 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1454 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1455 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1456 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1457 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1458 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1459 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1460 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1461 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1462 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1463 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1464 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1465 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1466 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1467 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1468 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1469 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1470 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1471 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1472 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1473 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1474 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1475 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1476 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1477 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1478 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1479 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1480 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1481 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1482 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1483 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1484 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1485 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1486 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1487 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1488 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1489 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1490 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1491 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1492 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1493 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1494 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1495 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1496 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1497 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1498 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1499 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1500 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1501 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1502 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1503 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1504 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1505 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1506 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1507 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1508 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1509 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1510 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1511 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1512 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1513 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1514 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1515 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1516 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1517 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1518 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1519 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1520 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1521 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1522 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1523 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1524 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1525 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1526 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1527 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1528 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1529 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1530 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1531 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1532 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1533 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1534 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1535 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1536 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1537 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1538 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1539 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1540 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1541 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1542 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1543 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1544 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1545 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1546 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1547 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1548 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1549 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1550 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1551 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1552 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1553 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1554 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1555 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1556 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1557 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1558 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1559 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1560 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1561 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1562 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1563 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1564 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1565 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1566 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1567 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1568 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1569 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1570 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1571 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1572 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1573 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1574 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1575 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1576 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1577 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1578 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1579 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1580 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1581 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1582 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1583 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1584 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1585 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1586 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1587 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1588 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1589 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1590 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1591 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1592 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1593 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1594 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1595 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1596 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1597 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1598 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1599 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1600 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1601 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1602 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1603 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1604 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1605 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1606 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1607 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1608 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1609 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1610 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1611 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1612 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1613 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1614 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1615 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1616 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1617 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1618 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1619 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1620 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1621 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1622 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1623 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1624 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1625 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1626 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1627 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1628 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1629 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1630 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1631 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1632 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1633 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1634 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1635 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1636 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1637 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1638 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1639 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1640 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1641 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1642 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1643 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1644 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1645 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1646 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1647 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1648 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1649 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1650 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1651 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1652 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1653 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1654 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1655 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1656 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1657 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1658 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1659 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1660 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1661 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1662 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1663 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1664 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1665 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1666 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1667 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1668 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1669 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1670 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1671 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1672 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1673 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1674 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1675 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1676 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1677 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1678 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1679 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1680 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1681 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1682 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1683 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1684 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1685 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1686 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1687 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1688 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1689 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1690 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1691 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1692 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1693 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1694 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1695 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1696 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1697 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1698 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1699 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1700 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1701 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1702 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1703 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1704 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1705 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1706 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1707 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1708 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1709 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1710 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1711 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1712 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1713 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1714 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1715 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1716 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1717 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1718 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1719 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1720 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1721 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1722 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1723 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1724 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1725 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1726 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1727 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1728 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1729 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1730 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1731 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1732 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1733 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1734 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1735 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1736 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1737 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1738 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1739 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1740 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1741 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1742 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1743 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1744 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1745 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1746 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1747 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1748 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1749 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1750 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1751 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1752 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1753 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1754 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1755 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1756 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1757 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1758 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1759 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1760 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1761 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1762 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1763 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1764 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1765 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1766 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1767 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1768 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1769 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1770 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1771 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1772 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1773 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1774 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1775 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1776 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1777 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1778 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1779 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1780 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1781 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1782 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1783 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1784 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1785 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1786 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1787 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1788 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1789 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1790 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1791 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1792 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1793 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1794 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1795 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1796 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1797 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1798 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1799 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1800 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1801 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1802 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1803 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1804 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1805 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1806 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1807 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1808 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1809 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1810 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1811 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1812 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1813 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1814 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1815 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1816 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1817 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1818 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1819 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1820 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1821 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1822 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1823 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1824 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1825 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1826 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1827 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1828 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1829 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1830 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1831 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1832 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1833 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1834 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1835 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1836 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1837 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1838 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1839 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1840 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1841 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1842 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1843 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1844 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1845 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1846 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1847 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1848 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1849 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1850 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1851 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1852 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1853 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1854 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1855 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1856 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1857 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1858 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1859 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1860 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1861 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1862 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1863 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1864 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1865 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1866 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1867 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1868 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1869 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1870 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1871 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1872 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1873 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1874 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1875 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1876 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1877 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1878 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1879 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1880 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1881 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1882 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1883 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1884 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1885 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1886 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1887 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1888 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1889 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1890 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1891 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1892 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1893 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1894 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1895 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1896 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1897 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1898 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1899 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1900 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1901 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1902 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1903 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1904 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1905 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1906 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1907 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1908 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1909 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1910 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1911 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1912 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1913 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1914 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1915 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1916 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1917 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1918 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1919 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1920 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1921 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1922 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1923 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1924 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1925 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1926 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1927 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1928 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1929 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1930 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1931 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1932 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1933 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1934 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1935 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1936 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1937 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1938 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1939 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1940 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1941 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1942 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1943 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1944 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1945 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1946 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1947 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1948 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1949 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1950 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1951 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1952 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1953 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1954 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1955 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1956 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1957 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1958 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1959 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1960 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1961 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1962 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1963 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1964 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1965 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1966 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1967 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1968 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1969 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1970 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1971 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1972 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1973 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1974 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1975 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1976 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1977 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1978 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1979 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1980 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      1981 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1982 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1983 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      1984 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1985 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1986 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      1987 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1988 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1989 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      1990 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1991 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1992 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      1993 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1994 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1995 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      1996 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1997 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1998 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      1999 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2000 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2001 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2002 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2003 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2004 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2005 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2006 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2007 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2008 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2009 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2010 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2011 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2012 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2013 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2014 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2015 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2016 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2017 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2018 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2019 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2020 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2021 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2022 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2023 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2024 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2025 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2026 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2027 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2028 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2029 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2030 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2031 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2032 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2033 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2034 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2035 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2036 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2037 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2038 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2039 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2040 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2041 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2042 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2043 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2044 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2045 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2046 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2047 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2048 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2049 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2050 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2051 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2052 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2053 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2054 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2055 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2056 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2057 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2058 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2059 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2060 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2061 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2062 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2063 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2064 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2065 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2066 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2067 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2068 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2069 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2070 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2071 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2072 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2073 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2074 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2075 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2076 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2077 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2078 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2079 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2080 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2081 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2082 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2083 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2084 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2085 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2086 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2087 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2088 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2089 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2090 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2091 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2092 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2093 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2094 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2095 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2096 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2097 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2098 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2099 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2100 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2101 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2102 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2103 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2104 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2105 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2106 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2107 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2108 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2109 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2110 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2111 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2112 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2113 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2114 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2115 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2116 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2117 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2118 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2119 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2120 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2121 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2122 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2123 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2124 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2125 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2126 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2127 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2128 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2129 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2130 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2131 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2132 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2133 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2134 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2135 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2136 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2137 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2138 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2139 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2140 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2141 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2142 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2143 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2144 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2145 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2146 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2147 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2148 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2149 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2150 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2151 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2152 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2153 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2154 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2155 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2156 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2157 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2158 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2159 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2160 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2161 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2162 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2163 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2164 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2165 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2166 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2167 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2168 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2169 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2170 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2171 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2172 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2173 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2174 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2175 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2176 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2177 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2178 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2179 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2180 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2181 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2182 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2183 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2184 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2185 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2186 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2187 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2188 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2189 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2190 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2191 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2192 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2193 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2194 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2195 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2196 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2197 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2198 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2199 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2200 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2201 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2202 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2203 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2204 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2205 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2206 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2207 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2208 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2209 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2210 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2211 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2212 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2213 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2214 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2215 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2216 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2217 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2218 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2219 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2220 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2221 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2222 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2223 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2224 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2225 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2226 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2227 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2228 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2229 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2230 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2231 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2232 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2233 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2234 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2235 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2236 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2237 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2238 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2239 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2240 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2241 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2242 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2243 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2244 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2245 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2246 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2247 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2248 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2249 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2250 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2251 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2252 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2253 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2254 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2255 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2256 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2257 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2258 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2259 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2260 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2261 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2262 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2263 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2264 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2265 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2266 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2267 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2268 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2269 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2270 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2271 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2272 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2273 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2274 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2275 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2276 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2277 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2278 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2279 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2280 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2281 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2282 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2283 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2284 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2285 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2286 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2287 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2288 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2289 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2290 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2291 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2292 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2293 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2294 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2295 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2296 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2297 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2298 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2299 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2300 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2301 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2302 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2303 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2304 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2305 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2306 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2307 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2308 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2309 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2310 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2311 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2312 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2313 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2314 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2315 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2316 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2317 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2318 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2319 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2320 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2321 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2322 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2323 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2324 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2325 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2326 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2327 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2328 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2329 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2330 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2331 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2332 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2333 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2334 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2335 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2336 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2337 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2338 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2339 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2340 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2341 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2342 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2343 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2344 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2345 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2346 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2347 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2348 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2349 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2350 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2351 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2352 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2353 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2354 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2355 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2356 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2357 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2358 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2359 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2360 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2361 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2362 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2363 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2364 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2365 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2366 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2367 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2368 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2369 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2370 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2371 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2372 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2373 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2374 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2375 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2376 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2377 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2378 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2379 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2380 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2381 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2382 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2383 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2384 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2385 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2386 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2387 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2388 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2389 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2390 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2391 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2392 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2393 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2394 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2395 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2396 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2397 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2398 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2399 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2400 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2401 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2402 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2403 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2404 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2405 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2406 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2407 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2408 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2409 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2410 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2411 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2412 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2413 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2414 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2415 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2416 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2417 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2418 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2419 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2420 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2421 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2422 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2423 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2424 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2425 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2426 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2427 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2428 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2429 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2430 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2431 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2432 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2433 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2434 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2435 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2436 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2437 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2438 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2439 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2440 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2441 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2442 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2443 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2444 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2445 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2446 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2447 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2448 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2449 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2450 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2451 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2452 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2453 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2454 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2455 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2456 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2457 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2458 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2459 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2460 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2461 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2462 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2463 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2464 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2465 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2466 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2467 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2468 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2469 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2470 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2471 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2472 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2473 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2474 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2475 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2476 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2477 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2478 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2479 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2480 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2481 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2482 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2483 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2484 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2485 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2486 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2487 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2488 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2489 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2490 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2491 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2492 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2493 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2494 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2495 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2496 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2497 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2498 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2499 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2500 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2501 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2502 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2503 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2504 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2505 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2506 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2507 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2508 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2509 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2510 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2511 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2512 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2513 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2514 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2515 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2516 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2517 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2518 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2519 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2520 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2521 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2522 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2523 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2524 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2525 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2526 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2527 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2528 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2529 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2530 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2531 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2532 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2533 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2534 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2535 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2536 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2537 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2538 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2539 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2540 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2541 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2542 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2543 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2544 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2545 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2546 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2547 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2548 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2549 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2550 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2551 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2552 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2553 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2554 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2555 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2556 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2557 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2558 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2559 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2560 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2561 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2562 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2563 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2564 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2565 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2566 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2567 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2568 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2569 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2570 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2571 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2572 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2573 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2574 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2575 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2576 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2577 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2578 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2579 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2580 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2581 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2582 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2583 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2584 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2585 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2586 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2587 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2588 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2589 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2590 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2591 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2592 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2593 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2594 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2595 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2596 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2597 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2598 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2599 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2600 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2601 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2602 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2603 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2604 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2605 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2606 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2607 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2608 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2609 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2610 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2611 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2612 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2613 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2614 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2615 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2616 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2617 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2618 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2619 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2620 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2621 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2622 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2623 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2624 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2625 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2626 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2627 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2628 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2629 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2630 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2631 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2632 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2633 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2634 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2635 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2636 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2637 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2638 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2639 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2640 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2641 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2642 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2643 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2644 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2645 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2646 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2647 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2648 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2649 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2650 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2651 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2652 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2653 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2654 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2655 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2656 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2657 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2658 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2659 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2660 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2661 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2662 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2663 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2664 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2665 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2666 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2667 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2668 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2669 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2670 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2671 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2672 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2673 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2674 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2675 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2676 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2677 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2678 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2679 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2680 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2681 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2682 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2683 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2684 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2685 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2686 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2687 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2688 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2689 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2690 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2691 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2692 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2693 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2694 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2695 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2696 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2697 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2698 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2699 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2700 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2701 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2702 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2703 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2704 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2705 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2706 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2707 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2708 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2709 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2710 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2711 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2712 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2713 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2714 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2715 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2716 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2717 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2718 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2719 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2720 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2721 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2722 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2723 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2724 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2725 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2726 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2727 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2728 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2729 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2730 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2731 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2732 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2733 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2734 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2735 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2736 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2737 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2738 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2739 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2740 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2741 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2742 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2743 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2744 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2745 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2746 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2747 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2748 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2749 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2750 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2751 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2752 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2753 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2754 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2755 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2756 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2757 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2758 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2759 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2760 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2761 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2762 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2763 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2764 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2765 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2766 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2767 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2768 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2769 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2770 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2771 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2772 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2773 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2774 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2775 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2776 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2777 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2778 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2779 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2780 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2781 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2782 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2783 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2784 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2785 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2786 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2787 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2788 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2789 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2790 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2791 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2792 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2793 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2794 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2795 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2796 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2797 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2798 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2799 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2800 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2801 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2802 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2803 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2804 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2805 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2806 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2807 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2808 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2809 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2810 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2811 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2812 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2813 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2814 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2815 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2816 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2817 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2818 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2819 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2820 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2821 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2822 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2823 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2824 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2825 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2826 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2827 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2828 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2829 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2830 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2831 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2832 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2833 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2834 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2835 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2836 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2837 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2838 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2839 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2840 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2841 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2842 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2843 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2844 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2845 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2846 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2847 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2848 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2849 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2850 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2851 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2852 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2853 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2854 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2855 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2856 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2857 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2858 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2859 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2860 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2861 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2862 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2863 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2864 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2865 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2866 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2867 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2868 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2869 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2870 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2871 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2872 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2873 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2874 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2875 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2876 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2877 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2878 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2879 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2880 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2881 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2882 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2883 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2884 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2885 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2886 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2887 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2888 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2889 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2890 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2891 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2892 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2893 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2894 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2895 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2896 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2897 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2898 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2899 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2900 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2901 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2902 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2903 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2904 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2905 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2906 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2907 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2908 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2909 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2910 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2911 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2912 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2913 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2914 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2915 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2916 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2917 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2918 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2919 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2920 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2921 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2922 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2923 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2924 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2925 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2926 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2927 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2928 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2929 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2930 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2931 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2932 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2933 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2934 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2935 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2936 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2937 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2938 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2939 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2940 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2941 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2942 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2943 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2944 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2945 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2946 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2947 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2948 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2949 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2950 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2951 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2952 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2953 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2954 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2955 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2956 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2957 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2958 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2959 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2960 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2961 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2962 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2963 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2964 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2965 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2966 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2967 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2968 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2969 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2970 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2971 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2972 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2973 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2974 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2975 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2976 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2977 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2978 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2979 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2980 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2981 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2982 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      2983 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2984 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2985 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      2986 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2987 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2988 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      2989 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2990 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2991 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      2992 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2993 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2994 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      2995 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2996 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2997 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      2998 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      2999 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3000 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3001 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3002 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3003 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3004 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3005 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3006 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3007 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3008 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3009 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3010 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3011 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3012 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3013 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3014 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3015 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3016 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3017 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3018 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3019 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3020 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3021 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3022 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3023 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3024 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3025 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3026 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3027 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3028 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3029 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3030 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3031 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3032 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3033 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3034 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3035 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3036 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3037 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3038 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3039 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3040 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3041 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3042 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3043 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3044 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3045 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3046 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3047 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3048 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3049 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3050 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3051 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3052 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3053 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3054 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3055 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3056 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3057 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3058 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3059 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3060 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3061 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3062 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3063 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3064 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3065 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3066 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3067 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3068 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3069 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3070 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3071 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3072 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3073 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3074 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3075 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3076 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3077 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3078 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3079 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3080 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3081 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3082 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3083 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3084 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3085 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3086 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3087 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3088 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3089 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3090 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3091 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3092 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3093 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3094 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3095 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3096 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3097 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3098 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3099 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3100 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3101 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3102 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3103 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3104 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3105 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3106 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3107 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3108 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3109 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3110 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3111 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3112 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3113 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3114 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3115 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3116 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3117 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3118 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3119 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3120 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3121 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3122 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3123 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3124 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3125 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3126 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3127 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3128 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3129 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3130 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3131 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3132 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3133 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3134 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3135 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3136 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3137 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3138 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3139 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3140 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3141 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3142 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3143 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3144 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3145 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3146 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3147 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3148 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3149 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3150 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3151 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3152 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3153 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3154 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3155 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3156 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3157 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3158 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3159 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3160 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3161 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3162 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3163 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3164 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3165 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3166 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3167 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3168 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3169 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3170 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3171 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3172 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3173 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3174 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3175 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3176 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3177 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3178 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3179 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3180 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3181 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3182 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3183 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3184 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3185 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3186 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3187 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3188 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3189 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3190 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3191 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3192 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3193 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3194 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3195 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3196 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3197 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3198 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3199 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3200 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3201 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3202 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3203 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3204 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3205 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3206 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3207 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3208 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3209 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3210 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3211 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3212 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3213 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3214 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3215 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3216 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3217 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3218 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3219 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3220 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3221 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3222 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3223 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3224 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3225 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3226 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3227 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3228 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3229 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3230 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3231 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3232 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3233 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3234 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3235 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3236 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3237 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3238 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3239 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3240 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3241 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3242 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3243 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3244 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3245 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3246 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3247 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3248 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3249 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3250 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3251 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3252 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3253 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3254 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3255 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3256 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3257 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3258 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3259 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3260 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3261 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3262 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3263 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3264 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3265 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3266 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3267 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3268 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3269 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3270 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3271 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3272 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3273 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3274 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3275 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3276 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3277 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3278 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3279 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3280 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3281 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3282 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3283 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3284 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3285 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3286 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3287 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3288 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3289 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3290 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3291 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3292 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3293 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3294 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3295 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3296 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3297 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3298 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3299 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3300 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3301 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3302 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3303 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3304 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3305 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3306 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3307 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3308 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3309 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3310 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3311 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3312 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3313 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3314 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3315 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3316 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3317 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3318 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3319 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3320 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3321 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3322 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3323 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3324 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3325 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3326 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3327 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3328 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3329 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3330 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3331 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3332 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3333 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3334 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3335 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3336 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3337 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3338 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3339 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3340 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3341 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3342 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3343 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3344 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3345 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3346 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3347 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3348 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3349 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3350 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3351 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3352 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3353 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3354 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3355 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3356 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3357 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3358 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3359 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3360 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3361 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3362 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3363 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3364 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3365 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3366 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3367 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3368 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3369 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3370 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3371 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3372 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3373 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3374 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3375 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3376 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3377 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3378 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3379 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3380 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3381 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3382 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3383 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3384 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3385 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3386 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3387 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3388 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3389 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3390 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3391 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3392 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3393 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3394 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3395 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3396 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3397 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3398 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3399 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3400 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3401 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3402 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3403 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3404 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3405 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3406 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3407 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3408 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3409 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3410 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3411 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3412 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3413 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3414 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3415 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3416 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3417 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3418 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3419 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3420 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3421 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3422 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3423 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3424 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3425 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3426 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3427 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3428 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3429 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3430 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3431 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3432 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3433 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3434 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3435 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3436 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3437 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3438 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3439 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3440 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3441 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3442 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3443 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3444 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3445 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3446 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3447 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3448 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3449 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3450 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3451 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3452 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3453 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3454 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3455 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3456 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3457 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3458 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3459 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3460 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3461 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3462 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3463 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3464 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3465 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3466 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3467 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3468 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3469 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3470 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3471 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3472 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3473 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3474 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3475 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3476 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3477 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3478 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3479 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3480 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3481 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3482 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3483 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3484 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3485 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3486 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3487 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3488 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3489 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3490 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3491 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3492 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3493 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3494 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3495 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3496 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3497 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3498 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3499 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3500 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3501 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3502 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3503 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3504 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3505 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3506 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3507 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3508 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3509 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3510 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3511 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3512 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3513 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3514 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3515 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3516 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3517 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3518 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3519 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3520 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3521 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3522 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3523 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3524 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3525 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3526 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3527 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3528 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3529 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3530 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3531 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3532 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3533 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3534 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3535 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3536 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3537 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3538 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3539 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3540 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3541 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3542 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3543 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3544 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3545 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3546 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3547 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3548 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3549 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3550 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3551 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3552 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3553 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3554 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3555 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3556 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3557 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3558 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3559 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3560 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3561 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3562 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3563 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3564 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3565 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3566 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3567 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3568 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3569 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3570 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3571 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3572 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3573 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3574 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3575 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3576 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3577 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3578 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3579 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3580 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3581 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3582 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3583 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3584 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3585 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3586 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3587 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3588 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3589 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3590 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3591 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3592 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3593 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3594 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3595 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3596 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3597 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3598 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3599 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3600 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3601 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3602 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3603 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3604 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3605 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3606 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3607 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3608 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3609 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3610 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3611 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3612 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3613 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3614 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3615 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3616 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3617 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3618 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3619 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3620 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3621 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3622 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3623 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3624 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3625 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3626 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3627 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3628 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3629 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3630 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3631 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3632 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3633 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3634 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3635 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3636 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3637 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3638 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3639 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3640 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3641 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3642 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3643 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3644 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3645 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3646 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3647 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3648 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3649 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3650 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3651 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3652 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3653 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3654 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3655 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3656 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3657 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3658 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3659 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3660 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3661 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3662 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3663 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3664 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3665 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3666 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3667 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3668 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3669 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3670 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3671 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3672 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3673 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3674 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3675 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3676 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3677 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3678 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3679 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3680 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3681 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3682 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3683 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3684 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3685 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3686 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3687 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3688 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3689 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3690 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3691 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3692 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3693 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3694 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3695 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3696 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3697 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3698 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3699 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3700 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3701 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3702 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3703 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3704 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3705 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3706 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3707 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3708 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3709 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3710 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3711 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3712 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3713 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3714 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3715 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3716 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3717 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3718 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3719 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3720 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3721 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3722 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3723 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3724 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3725 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3726 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3727 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3728 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3729 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3730 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3731 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3732 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3733 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3734 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3735 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3736 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3737 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3738 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3739 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3740 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3741 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3742 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3743 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3744 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3745 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3746 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3747 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3748 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3749 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3750 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3751 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3752 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3753 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3754 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3755 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3756 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3757 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3758 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3759 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3760 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3761 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3762 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3763 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3764 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3765 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3766 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3767 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3768 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3769 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3770 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3771 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3772 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3773 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3774 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3775 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3776 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3777 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3778 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3779 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3780 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3781 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3782 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3783 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3784 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3785 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3786 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3787 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3788 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3789 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3790 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3791 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3792 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3793 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3794 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3795 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3796 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3797 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3798 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3799 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3800 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3801 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3802 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3803 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3804 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3805 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3806 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3807 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3808 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3809 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3810 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3811 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3812 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3813 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3814 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3815 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3816 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3817 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3818 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3819 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3820 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3821 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3822 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3823 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3824 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3825 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3826 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3827 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3828 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3829 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3830 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3831 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3832 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3833 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3834 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3835 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3836 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3837 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3838 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3839 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3840 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3841 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3842 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3843 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3844 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3845 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3846 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3847 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3848 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3849 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3850 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3851 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3852 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3853 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3854 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3855 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3856 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3857 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3858 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3859 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3860 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3861 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3862 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3863 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3864 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3865 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3866 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3867 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3868 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3869 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3870 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3871 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3872 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3873 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3874 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3875 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3876 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3877 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3878 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3879 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3880 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3881 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3882 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3883 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3884 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3885 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3886 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3887 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3888 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3889 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3890 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3891 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3892 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3893 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3894 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3895 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3896 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3897 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3898 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3899 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3900 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3901 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3902 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3903 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3904 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3905 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3906 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3907 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3908 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3909 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3910 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3911 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3912 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3913 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3914 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3915 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3916 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3917 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3918 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3919 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3920 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3921 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3922 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3923 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3924 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3925 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3926 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3927 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3928 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3929 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3930 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3931 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3932 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3933 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3934 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3935 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3936 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3937 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3938 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3939 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3940 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3941 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3942 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3943 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3944 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3945 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3946 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3947 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3948 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3949 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3950 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3951 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3952 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3953 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3954 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3955 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3956 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3957 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3958 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3959 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3960 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3961 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3962 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3963 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3964 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3965 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3966 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3967 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3968 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3969 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3970 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3971 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3972 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3973 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3974 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3975 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3976 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3977 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3978 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3979 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3980 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3981 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      3982 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3983 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3984 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      3985 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3986 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3987 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      3988 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3989 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3990 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      3991 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3992 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3993 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      3994 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3995 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3996 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      3997 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3998 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      3999 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4000 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4001 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4002 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4003 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4004 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4005 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4006 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4007 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4008 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4009 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4010 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4011 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4012 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4013 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4014 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4015 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4016 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4017 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4018 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4019 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4020 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4021 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4022 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4023 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4024 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4025 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4026 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4027 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4028 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4029 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4030 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4031 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4032 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4033 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4034 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4035 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4036 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4037 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4038 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4039 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4040 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4041 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4042 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4043 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4044 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4045 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4046 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4047 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4048 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4049 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4050 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4051 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4052 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4053 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4054 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4055 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4056 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4057 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4058 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4059 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4060 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4061 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4062 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4063 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4064 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4065 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4066 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4067 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4068 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4069 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4070 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4071 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4072 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4073 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4074 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4075 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4076 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4077 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4078 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4079 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4080 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4081 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4082 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4083 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4084 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4085 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4086 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4087 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4088 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4089 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4090 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4091 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4092 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4093 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4094 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4095 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4096 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4097 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4098 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4099 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4100 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4101 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4102 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4103 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4104 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4105 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4106 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4107 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4108 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4109 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4110 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4111 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4112 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4113 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4114 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4115 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4116 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4117 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4118 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4119 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4120 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4121 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4122 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4123 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4124 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4125 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4126 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4127 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4128 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4129 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4130 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4131 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4132 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4133 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4134 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4135 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4136 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4137 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4138 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4139 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4140 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4141 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4142 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4143 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4144 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4145 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4146 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4147 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4148 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4149 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4150 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4151 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4152 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4153 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4154 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4155 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4156 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4157 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4158 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4159 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4160 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4161 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4162 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4163 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4164 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4165 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4166 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4167 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4168 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4169 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4170 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4171 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4172 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4173 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4174 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4175 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4176 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4177 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4178 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4179 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4180 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4181 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4182 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4183 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4184 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4185 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4186 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4187 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4188 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4189 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4190 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4191 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4192 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4193 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4194 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4195 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4196 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4197 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4198 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4199 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4200 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4201 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4202 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4203 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4204 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4205 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4206 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4207 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4208 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4209 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4210 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4211 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4212 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4213 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4214 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4215 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4216 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4217 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4218 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4219 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4220 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4221 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4222 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4223 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4224 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4225 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4226 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4227 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4228 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4229 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4230 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4231 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4232 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4233 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4234 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4235 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4236 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4237 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4238 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4239 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4240 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4241 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4242 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4243 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4244 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4245 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4246 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4247 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4248 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4249 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4250 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4251 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4252 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4253 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4254 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4255 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4256 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4257 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4258 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4259 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4260 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4261 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4262 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4263 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4264 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4265 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4266 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4267 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4268 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4269 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4270 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4271 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4272 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4273 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4274 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4275 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4276 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4277 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4278 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4279 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4280 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4281 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4282 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4283 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4284 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4285 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4286 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4287 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4288 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4289 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4290 1 : Experiment 1 30000 HCMEC D3       ECIS        2       no
      4291 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4292 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4293 1 : Experiment 1 25000 HCMEC D3       ECIS        3       no
      4294 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4295 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4296 1 : Experiment 1 20000 HCMEC D3       ECIS        4       no
      4297 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4298 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4299 1 : Experiment 1 15000 HCMEC D3       ECIS        5       no
      4300 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4301 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4302 1 : Experiment 1 10000 HCMEC D3       ECIS        6       no
      4303 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4304 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4305 1 : Experiment 1  5000 HCMEC D3       ECIS        7       no
      4306 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4307 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4308 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4309 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4310 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4311 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4312 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4313 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4314 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4315 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4316 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4317 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4318 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4319 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4320 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4321 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4322 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4323 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4324 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4325 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4326 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4327 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4328 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4329 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4330 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4331 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4332 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4333 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4334 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4335 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4336 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4337 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4338 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4339 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4340 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4341 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4342 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4343 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4344 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4345 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4346 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4347 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4348 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4349 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4350 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4351 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4352 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4353 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4354 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4355 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4356 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4357 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4358 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4359 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4360 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4361 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4362 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4363 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4364 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4365 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4366 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4367 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4368 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4369 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4370 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4371 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4372 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4373 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4374 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4375 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4376 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4377 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4378 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4379 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4380 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4381 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4382 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4383 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4384 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4385 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4386 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4387 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4388 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4389 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4390 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4391 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4392 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4393 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4394 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4395 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4396 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4397 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4398 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4399 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4400 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4401 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4402 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4403 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4404 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4405 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4406 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4407 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4408 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4409 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4410 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4411 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4412 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4413 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4414 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4415 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4416 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4417 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4418 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4419 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4420 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4421 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4422 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4423 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4424 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4425 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4426 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4427 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4428 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4429 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4430 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4431 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4432 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4433 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4434 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4435 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4436 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4437 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4438 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4439 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4440 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4441 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4442 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4443 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4444 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4445 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4446 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4447 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4448 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4449 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4450 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4451 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4452 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4453 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4454 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4455 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4456 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4457 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4458 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4459 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4460 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4461 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4462 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4463 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4464 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4465 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4466 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4467 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4468 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4469 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4470 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4471 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4472 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4473 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4474 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4475 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4476 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4477 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4478 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4479 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4480 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4481 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4482 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4483 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4484 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4485 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4486 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4487 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4488 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4489 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4490 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4491 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4492 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4493 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4494 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4495 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4496 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4497 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4498 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4499 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4500 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4501 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4502 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4503 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4504 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4505 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4506 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4507 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4508 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4509 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4510 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4511 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4512 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4513 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4514 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4515 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4516 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4517 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4518 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4519 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4520 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4521 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4522 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4523 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4524 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4525 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4526 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4527 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4528 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4529 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4530 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4531 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4532 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4533 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4534 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4535 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4536 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4537 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4538 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4539 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4540 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4541 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4542 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4543 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4544 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4545 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4546 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4547 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4548 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4549 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4550 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4551 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4552 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4553 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4554 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4555 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4556 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4557 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4558 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4559 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4560 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4561 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4562 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4563 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4564 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4565 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4566 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4567 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4568 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4569 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4570 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4571 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4572 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4573 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4574 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4575 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4576 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4577 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4578 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4579 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4580 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4581 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4582 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4583 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4584 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4585 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4586 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4587 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4588 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4589 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4590 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4591 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4592 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4593 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4594 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4595 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4596 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4597 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4598 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4599 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4600 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4601 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4602 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4603 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4604 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4605 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4606 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4607 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4608 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4609 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4610 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4611 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4612 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4613 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4614 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4615 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4616 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4617 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4618 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4619 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4620 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4621 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4622 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4623 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4624 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4625 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4626 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4627 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4628 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4629 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4630 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4631 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4632 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4633 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4634 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4635 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4636 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4637 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4638 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4639 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4640 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4641 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4642 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4643 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4644 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4645 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4646 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4647 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4648 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4649 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4650 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4651 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4652 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4653 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4654 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4655 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4656 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4657 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4658 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4659 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4660 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4661 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4662 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4663 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4664 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4665 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4666 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4667 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4668 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4669 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4670 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4671 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4672 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4673 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4674 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4675 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4676 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4677 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4678 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4679 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4680 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4681 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4682 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4683 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4684 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4685 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4686 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4687 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4688 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4689 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4690 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4691 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4692 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4693 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4694 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4695 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4696 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4697 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4698 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4699 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4700 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4701 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4702 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4703 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4704 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4705 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4706 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4707 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4708 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4709 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4710 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4711 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4712 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4713 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4714 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4715 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4716 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4717 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4718 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4719 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4720 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4721 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4722 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4723 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4724 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4725 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4726 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4727 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4728 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4729 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4730 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4731 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4732 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4733 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4734 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4735 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4736 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4737 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4738 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4739 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4740 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4741 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4742 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4743 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4744 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4745 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4746 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4747 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4748 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4749 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4750 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4751 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4752 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4753 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4754 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4755 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4756 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4757 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4758 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4759 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4760 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4761 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4762 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4763 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4764 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4765 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4766 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4767 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4768 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4769 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4770 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4771 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4772 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4773 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4774 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4775 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4776 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4777 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4778 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4779 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4780 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4781 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4782 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4783 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4784 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4785 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4786 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4787 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4788 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4789 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4790 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4791 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4792 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
      4793 1 : Experiment 1 35000 HCMEC D3       ECIS        1       no
    