% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_naming.R
\name{vascr_import}
\alias{vascr_import}
\title{Import an impedance datafile to vascr}
\usage{
vascr_import(
  instrument = NULL,
  raw = NULL,
  modeled = NULL,
  experiment = NULL,
  shear = FALSE
)
}
\arguments{
\item{instrument}{Instrument to import from, either ECIS, xCELLigence or cellZscope}

\item{raw}{Path to raw data file}

\item{modeled}{Path to modeled data file from manufacturer's software}

\item{experiment}{Name for the experiment being imported}

\item{shear}{True or False, is a shear plate used, as these have a different electrode layout. Defaults to False.}
}
\value{
A vascr dataset for subsequent analysis
}
\description{
Import an impedance datafile to vascr
}
\examples{
\donttest{

# ECIS
raw = system.file('extdata/instruments/ecis_TimeResample.abp', package = 'vascr')
modeled = system.file('extdata/instruments/ecis_TimeResample_RbA.csv', package = 'vascr')
vascr_import("ECIS", raw, modeled, "ECIS_Data")

# xCELLigence
raw = system.file('extdata/instruments/xcell.plt', package = 'vascr')
# No modeling for this system
vascr_import("xCELLigence", raw, experiment = "xCELLigence")

# cellZscope
model = system.file("extdata/instruments/zscopemodel.txt", package = "vascr")
raw = system.file("extdata/instruments/zscoperaw.txt", package = "vascr")
vascr_import("cellzscope", raw, model, "cellZscope")

#' # ScioSpec
raw = system.file("extdata/instruments/ScioSpec", package = "vascr")
vascr_import("sciospec", raw, model, "ScioSpec")

}
}
