% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-SVC_mle.R
\name{predict.SVC_mle}
\alias{predict.SVC_mle}
\title{Prediction of SVCs (and response variable)}
\usage{
\method{predict}{SVC_mle}(
  object,
  newlocs = NULL,
  newX = NULL,
  newW = NULL,
  newdata = NULL,
  compute.y.var = FALSE,
  ...
)
}
\arguments{
\item{object}{(\code{SVC_mle}) \cr
Model obtained from \code{\link{SVC_mle}} function call.}

\item{newlocs}{(\code{NULL} or \code{matrix(n.new, 2)}) \cr
If \code{NULL}, then function uses observed locations of model to estimate
SVCs. Otherwise, these are the new locations the SVCs are predicted for.}

\item{newX}{(\code{NULL} or \code{matrix(n.new, q)}) \cr
If provided (together with \code{newW}), the function also returns the
predicted response variable.}

\item{newW}{(\code{NULL} or \code{matrix(n.new, p)}) \cr
If provided (together with \code{newX}), the function also returns the
predicted response variable.}

\item{newdata}{(\code{NULL} or \code{data.frame(n.new, p)}) \cr
This argument can be used, when the \code{SVC_mle} function has been called
with an formula, see examples.}

\item{compute.y.var}{(\code{logical(1)}) \cr
If \code{TRUE} and the response is being estimated, the predictive
variance of each estimate will be computed.}

\item{...}{further arguments}
}
\value{
The function returns a data frame of \code{n.new} rows and with
columns
\itemize{
  \item \code{SVC_1, ..., SVC_p}: the predicted SVC at locations \code{newlocs}.
  \item \code{y.pred}, if \code{newX} and \code{newW} are provided
  \item \code{y.var}, if \code{newX} and \code{newW} are provided and
  \code{compute.y.var} is set to \code{TRUE}.
  \item \code{loc_x, loc_y}, the locations of the predictions
}
}
\description{
Prediction of SVCs (and response variable)
}
\examples{
## ---- toy example ----
## We use the sampled, i.e., one dimensional SVCs
str(SVCdata)
# sub-sample data to have feasible run time for example
set.seed(123)
id <- sample(length(SVCdata$locs), 50)

## SVC_mle call with matrix arguments
fit_mat <- with(SVCdata, SVC_mle(
  y[id], X[id, ], locs[id], 
  control = SVC_mle_control(profileLik = TRUE, cov.name = "mat32")))

## SVC_mle call with formula
df <- with(SVCdata, data.frame(y = y[id], X = X[id, -1]))
fit_form <- SVC_mle(
  y ~ X, data = df, locs = SVCdata$locs[id], 
  control = SVC_mle_control(profileLik = TRUE, cov.name = "mat32")
)

## prediction

# predicting SVCs
predict(fit_mat, newlocs = 1:2)
predict(fit_form, newlocs = 1:2)

# predicting SVCs and response providing new covariates
predict(
  fit_mat, 
  newX = matrix(c(1, 1, 3, 4), ncol = 2), 
  newW = matrix(c(1, 1, 3, 4), ncol = 2), 
  newlocs = 1:2
)
predict(fit_form, newdata = data.frame(X = 3:4), newlocs = 1:2)

}
\references{
Dambon, J. A., Sigrist, F., Furrer, R. (2021)
   \emph{Maximum likelihood estimation of spatially varying coefficient
   models for large data with an application to real estate price prediction},
   Spatial Statistics \doi{10.1016/j.spasta.2020.100470}
}
\seealso{
\code{\link{SVC_mle}}
}
\author{
Jakob Dambon
}
