"Psi.vec2var" <-
function(x, nstep=10, ...){
  if(!(class(x)=="vec2var")){
    stop("\nPlease provide an object of class 'vec2var', generated by 'vec2var()'.\n")
  }
  nstep <- abs(as.integer(nstep))
  Phi <- Phi(x, nstep = nstep)
  Psi <- array(0, dim=dim(Phi))
  params <- ncol(x$datamat[, -c(1:x$K)])
  sigma.u <- crossprod(x$resid) / x$obs
  P <- t(chol(sigma.u))
  dim3 <- dim(Phi)[3]
  for(i in 1:dim3){
    Psi[, , i] <- Phi[, , i] %*% P
  }
  return(Psi)
}
