% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy.R
\name{dummy}
\alias{dummy}
\title{Creating Dummy-Code Columns for Values of a Variable}
\usage{
dummy(df, var, remove = FALSE)
}
\arguments{
\item{df}{data frame to read in.}

\item{var}{the variable to be dummy-coded. Is automatically converted to a character string.}

\item{remove}{logical (default set to \code{F}). When set to \code{remove = T}, will return a data frame using the true number of dummy coded columns (e.g. \emph{n-1}).}
}
\value{
This function updates the data frame with new variables (columns) representing unique values of a selected variable, and a binary score (0/1) for the absence or presence of a column's represented value for each observation.
}
\description{
This function applies dummy-coding to a variable of interest, enabling the creation of \emph{n} or \emph{n-1} columns/variables based on \emph{n} number of attributes for the variable.
}
\examples{
data <- howell_aids_long

dummy(data, student)
}
