% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMAB_GMDB_PDE_solver.R
\name{va_pde_pricer}
\alias{va_pde_pricer}
\title{PDE Pricing of Variable Annuity}
\usage{
va_pde_pricer(F0 = 100, r = 0.03, sigma = 0.165, x = 50, delta = 0,
  fee = 0.01, beta = 150, T = 5, dt = 0.1, dF = 0.1,
  lambda = function(t) makeham(t, x = 50, A = 1e-04, B = 0.00035, c = 1.075),
  K = function(t, T) {     0.05 * (1 - t/T)^3 }, Fmax = 500)
}
\arguments{
\item{F0}{numeric scalar with the initial value of the underlying fund}

\item{r}{numeric scalar with the constant interest rate}

\item{sigma}{numeric scalar with the constant volatility}

\item{x}{numeric integer with the age of the insured}

\item{delta}{numeric scalar with the roll-up rate of the GMAB and GMDB}

\item{fee}{numeric scalar with the state-dependent base fee}

\item{beta}{numeric scalar with the state-dependent barrier
It should be greater than \code{F0}.
If set to \code{Inf} the fee structure becomes constant}

\item{T}{numeric integer with the maturity of the contract}

\item{dt}{numeric scalar with the discretization step of the
time dimension}

\item{dF}{numeric scalar with the discretization step for
the fund dimension}

\item{lambda}{function with the intensity of mortality.
Default is \code{\link{makeham}} with parameters
\code{x = 50, A = 0.0001, B = 0.00035, c = 1.075}}

\item{K}{function with the  surrender penalty.}

\item{Fmax}{numeric scalar with the maximum fund value}
}
\value{
numeric scalar with the VA price
}
\description{
\code{va_pde_pricer} returns the price of a VA with GMAB and GMDB
guarantees. The underlying fund is a GBM and the intensity of mortality
is deterministic. The fee has a  state-dependent structure.
}
\details{
This function resolves the PDE in [MK2017] by means of the  finite
difference implicit method. It requires the package limSolve to be
installed.
}
\examples{
lambda <- function(t) mu(t, x = 50, c1 = 90.43 , c2 = 10.36)
K <- function(t, T) {0.05 * ( 1 - t / T)^3}

va <- va_pde_pricer(lambda = lambda, K = K, Fmax = 200)

va
}
\references{
\enumerate{
 \item{[MK2017]}{ \cite{A. MacKay, M. Augustyniak, C. Bernard, and M.R.
   Hardy.
 Risk management of policyholder behavior in equity-linked life insurance.
 The Journal of Risk and Insurance, 84(2):661-690, 2017. DOI: 10.1111/jori.12094}}
}
}
