% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bed.r
\name{read_bigwig}
\alias{read_bigwig}
\title{Import and convert a bigwig file into a valr compatible tbl}
\usage{
read_bigwig(path, set_strand = "+")
}
\arguments{
\item{path}{path to bigWig file}

\item{set_strand}{strand to add to output (defaults to "+")}
}
\description{
This function will output a 5 column tibble with
zero-based chrom, start, end, score, and strand columns.
}
\note{
This functions uses \code{rtracklayer} to import bigwigs which
has unstable support for the windows platform and therefore may error
for windows users (particularly for 32 bit window users).
}
\examples{
\dontrun{
if (.Platform$OS.type != "windows") {
  bw <- read_bigwig(valr_example("hg19.dnase1.bw"))
  head(bw)
}
}
}
