% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confront.R
\name{confront.tbl_sql}
\alias{confront.tbl_sql}
\alias{confront,ANY,validator,ANY-method}
\title{Validate data in database \code{tbl} with \code{validator} rules.}
\usage{
confront.tbl_sql(tbl, x, ref, key = NULL, sparse = FALSE, compute = FALSE, ...)

\S4method{confront}{ANY,validator,ANY}(dat, x, ref, key = NULL, sparse = FALSE, ...)
}
\arguments{
\item{tbl}{\code{\link[dbplyr:tbl.src_dbi]{dbplyr::tbl_dbi()}} table in a database, retrieved with \code{\link[=tbl]{tbl()}}}

\item{x}{\code{\link[validate:validator]{validate::validator()}} object with validation rules.}

\item{ref}{reference object (not working)}

\item{key}{\code{character} with key column name.}

\item{sparse}{\code{logical} should only fails be stored in the db?}

\item{compute}{\code{logical} if \code{TRUE} the check stores a temporary table in the database.}

\item{...}{passed through to \code{\link[=compute]{compute()}}, if \code{compute} is \code{TRUE}}

\item{dat}{an object of class `tbl_sql``.}
}
\value{
a \code{\link[=tbl_validation]{tbl_validation()}} object, containing the confrontation query and processing information.
}
\description{
Confront \code{\link[dbplyr:tbl.src_dbi]{dbplyr::tbl_dbi()}} objects with \code{\link[validate:validator]{validate::validator()}} rules, making it
possible to execute \code{validator()} rules on database tables. Validation results
can be stored in the db or retrieved into R.
}
\details{
\code{validatedb} builds upon \code{dplyr} and \code{dbplyr}, so it works on all databases
that have a dbplyr compatible database driver (DBI / odbc).
\code{validatedb} translates \code{validator} rules into \code{dplyr} commands resulting in
a lazy query object. The result of a validation can be stored in the database
using \code{compute} or retrieved into R with \code{values}.
}
\examples{
# create a table in a database
income <- data.frame(id = letters[1:2], age=c(12,35), salary = c(1000,NA))
con <- dbplyr::src_memdb()
tbl_income <- dplyr::copy_to(con, income, overwrite=TRUE)
print(tbl_income)

# Let's define a rule set and confront the table with it:
rules <- validator( is_adult   = age >= 18
                  , has_income = salary > 0
                  , mean_age   = mean(age,na.rm=TRUE) > 20
                  )

# and confront!
cf <- confront(tbl_income, rules)
print(cf)
summary(cf)

# Values (i.e. validations on the table) can be retrieved like in `validate` 
# with`type="matrix"` (simplify = TRUE)
values(cf, type = "matrix")

# But often this seems more handy:
values(cf, type = "tbl")

# We can see the sql code by using `show_query`:
show_query(cf)

# identical
show_query(values(cf, type = "tbl"))

# adding a key often is handy in a database
cf <- confront(tbl_income, rules, key = "id")
print(cf)
values(cf, type="tbl")

# sparse results in db
cf_sparse <- confront(tbl_income, rules, sparse=TRUE)
values(cf_sparse, type="tbl")
}
\seealso{
Other validation: 
\code{\link{tbl_validation-class}},
\code{\link{values,tbl_validation-method}}
}
\concept{validation}
