% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utr_analysis.R
\name{getTranscriptIdsForCodonVariants}
\alias{getTranscriptIdsForCodonVariants}
\title{Find the ensembl_transcript_id and codon positions for variants}
\usage{
getTranscriptIdsForCodonVariants(variantsTable, transcriptRegions, checkRegion)
}
\arguments{
\item{variantsTable}{variants table}

\item{transcriptRegions}{transcripts structure table from ensembl}

\item{checkRegion}{check if a transcript within a region stopCodon or startCodon}
}
\value{
A data table containing two columns: ensembl_transcript_id (id of transcripts for each variant which its mutation Pos is within those transcripts checkRegion.)
                                       codon_positions (positions of each nucleotides in the codon)
}
\description{
Find the ensembl_transcript_id and codon positions for variants
}
\details{
For each variant, get all transcripts and extract their checkRegion's coordinates. For each transcript, check if the mutation Pos
is within the region, if so, add that transcript's ensembl_transcript_id. If the mutation Pos is within multiple transcripts checkRegions,
the transcripts ids are concatenate into one string with ";".
}
\keyword{internal}
