% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{mcut_threshold}
\alias{mcut_threshold}
\alias{mcut_threshold.default}
\alias{mcut_threshold.mlresult}
\title{Maximum Cut Thresholding (MCut)}
\usage{
mcut_threshold(prediction, probability = FALSE)

\method{mcut_threshold}{default}(prediction, probability = FALSE)

\method{mcut_threshold}{mlresult}(prediction, probability = FALSE)
}
\arguments{
\item{prediction}{A matrix or mlresult.}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.
(Default: \code{FALSE})}
}
\value{
A mlresult object.
}
\description{
The Maximum Cut (MCut) automatically determines a threshold for each instance
that selects a subset of labels with higher scores than others. This leads to
the selection of the middle of the interval defined by these two scores as
the threshold.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Maximum Cut Thresholding (MCut) method for matrix

\item \code{mlresult}: Maximum Cut Thresholding (MCut) for mlresult
}}
\examples{
prediction <- matrix(runif(16), ncol = 4)
mcut_threshold(prediction)
}
\references{
Largeron, C., Moulin, C., & Gery, M. (2012). MCut: A Thresholding Strategy
 for Multi-label Classification. In 11th International Symposium, IDA 2012
 (pp. 172-183).
}
\seealso{
Other threshold: \code{\link{fixed_threshold}},
  \code{\link{lcard_threshold}},
  \code{\link{pcut_threshold}},
  \code{\link{rcut_threshold}},
  \code{\link{scut_threshold}},
  \code{\link{subset_correction}}
}

