% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KDE.R
\name{KDE_utils}
\alias{KDE_utils}
\alias{KDE.load}
\alias{print.kde}
\alias{plot.kde}
\title{Utilities for KDE fits}
\usage{
KDE.load(object, envir = NULL, overwrite = TRUE)

\method{print}{kde}(x, digits = 6, ...)

\method{plot}{kde}(
  x,
  digits = 6,
  n = 512,
  cut = 4,
  fill.colour = "dodgerblue",
  fill.color = fill.colour,
  ...
)
}
\arguments{
\item{object, x}{A KDE object}

\item{envir}{The target environment}

\item{overwrite}{If FALSE, aborts if the function names are already present in the target environment}

\item{digits}{Number of digits to print}

\item{...}{unused}

\item{n}{number of bins}

\item{cut}{cutoffs for xaxis (in steps of bw)}

\item{fill.colour, fill.color}{fill color of bars}
}
\value{
KDE.load returns \code{envir}

\code{print.kde} returns \code{x}, invisibly

\code{plot.kde} returns the plot as recorded by \code{recordPlot}
}
\description{
Utilities for KDE fits

\code{KDE.load} copies KDE distribution functions from a KDE object to a target environment.

\code{print.kde} prints the KDE object and returns it invisibly.

\code{plot.kde} draws a plot of the KDE.
}
