% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{moments}
\alias{moments}
\title{Sample Moments}
\usage{
moments(
  x,
  skew.type = NULL,
  kurt.type = NULL,
  kurt.excess = FALSE,
  na.rm = TRUE,
  include.sd = FALSE
)
}
\arguments{
\item{x}{A data vector/matrix/list}

\item{skew.type}{The type of kurtosis statistic used ('Moment', 'Fisher Pearson' or 'Adjusted Fisher Pearson')}

\item{kurt.type}{The type of kurtosis statistic used ('Moment', 'Fisher Pearson' or 'Adjusted Fisher Pearson')}

\item{kurt.excess}{Logical value; if \code{TRUE} the function gives the excess kurtosis (instead of raw kurtosis)}

\item{na.rm}{Logical value; if \code{TRUE} the function removes \code{NA} values}

\item{include.sd}{Logical value; if \code{TRUE} the output includes a column for the sample standard deviation (if needed)}
}
\value{
A data frame containing the sample moments of the data vector/matrix
}
\description{
\code{moments} returns the sample moments of a data vector/matrix
}
\details{
This function computes the sample moments for a data vector, matrix or list (sample mean, sample variance, sample skewness and sample kurtosis).
For a vector input the function returns a single value for each sample moment of the data.  For a matrix or list input the function treats each
column/element as a data vector and returns a matrix of values for the sample moments of each of these datasets.  The function can compute
different types of skewness and kurtosis statistics using the \code{skew.type}, \code{kurt.type} and \code{kurt.excess} inputs.  (For details
on the different types of skewness and kurtosis statistics, see Joanes and Gill 1998.)
}
\examples{
#Create some subgroups of mock data and a pooled dataset
set.seed(1)
N    <- c(28, 44, 51)
SUB1 <- rnorm(N[1])
SUB2 <- rnorm(N[2])
SUB3 <- rnorm(N[3])
DATA <- list(Subgroup1 = SUB1, Subgroup2 = SUB2, Subgroup3 = SUB3)
POOL <- c(SUB1, SUB2, SUB3)

#Compute sample moments for subgroups and pooled data
MOMENTS <- moments(DATA)
POOLMOM <- moments(POOL)

#Compute pooled moments via sample decomposition
sample.decomp(moments = MOMENTS)
}
