% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{calc_chunks}
\alias{calc_chunks}
\title{Calculate data chunk indices}
\usage{
calc_chunks(x, size = 10, reverse = FALSE)
}
\arguments{
\item{x}{A data frame or vector.}

\item{size}{An integer. The number of items (e.g. rows in a tibble)
that make up a given chunk. Must be a positive integer. Caps out at data
maximum.}

\item{reverse}{A logical. Calculate chunks from back to front.}
}
\value{
An iterable list of row indices for each chunk of data.
}
\description{
Calculates chunk indices of a data object
for a given chunk size (number of items per chunk).
}
\examples{
# Create chunk map for a data frame
chunks <- calc_chunks(mtcars, size = 6)

# Iterate through chunks of data
for (chunk in chunks) print(paste0(rownames(mtcars[chunk,]), collapse = ', '))
}
