% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd_endpoints.R
\name{ustfd_table_columns}
\alias{ustfd_table_columns}
\title{Return a table of known fields for known endpoints}
\source{
\url{https://fiscaldata.treasury.gov/api-documentation/#fields-by-endpoint}
}
\usage{
ustfd_table_columns(endpoints = NULL)
}
\arguments{
\item{endpoints}{one or more strings representing a valid endpoint}
}
\value{
tibble
}
\description{
\code{ustfd_table_columns} returns the column dictionaries for the specified endpoint(s).
See \code{\link[=ustfd_tables]{ustfd_tables()}} for known endpoints.
}
\details{
The format of a dictionary is a tibble with one row for every
table column and the following columns:
\itemize{
\item \code{endpoint} - the ID of the table this column belongs to
\item \code{colum_name} - the field name recognizable to the API interface
\item \code{data_type} - one of: "DATE", "STRING", "CURRENCY", "NUMBER",
"PERCENTAGE", "YEAR", "QUARTER", "MONTH", "DAY"
\item \code{pretty_name} - a descriptive label
\item \code{definition} -  definition of the colmn's value
\item \code{is_required} - logical value
}
}
\examples{
library(ustfd)
ustfd_table_columns(ustfd_tables(ustfd_datasets()$dataset[2])$endpoint)



}
\seealso{
Other ustfd_user:
\code{\link{endpoint_exists}()},
\code{\link{ustfd_all_pages}()},
\code{\link{ustfd_datasets}()},
\code{\link{ustfd_query}()},
\code{\link{ustfd_simple}()},
\code{\link{ustfd_tables}()}
}
\concept{ustfd_user}
