\name{ursaRaster}
\alias{class-ursaRaster}
\alias{is.ursa}
\alias{is_ursa}
\alias{print.ursaRaster}
\alias{str.ursaRaster}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
   Definition of \code{ursaRaster} class.
}
\description{
\code{ursaRaster} is S3 class for manipulation with georeferred raster images. See \sQuote{Value} \var{section}.
\cr\code{is.ursa} checks inhering to class \code{ursaRaster}
}
\usage{
\method{print}{ursaRaster}(x, digits = NA, grid = FALSE, raw = FALSE, ...)

\method{str}{ursaRaster}(object,...)

is.ursa(obj, ref = NULL)
is_ursa(obj, ref = NULL)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, object}{
\code{ursaRaster} object.
}

  \item{obj}{
Any.
}
  \item{digits}{
Passed to \code{\link[base]{format}} function
}
  \item{grid}{
Logical. If \code{grid=TRUE} then returns simplified metadata.
}
  \item{raw}{
Logical. If \code{FALSE} and values are categories, then attempting to restore numeric values from categorical names is before calculating of statistics. If \code{TRUE} then values for statistics are used as is. Default is \code{FALSE}.
}
  \item{\dots}{
Passed to \code{\link[base]{format}} function
}
  \item{ref}{
Character or \code{NULL}. If character, then checking of \code{ursaRaster} sub-class(es):
\tabular{ll}{
   \strong{Pattern} \tab \strong{Description}
   \cr \code{NULL} \tab \code{\link[ursa:classRaster]{ursaRaster}}
   \cr \code{(raster|brick|ursa)} \tab \code{\link[ursa:classRaster]{ursaRaster}}
   \cr \code{grid} \tab \code{\link[ursa:classGrid]{ursaGrid}}
   \cr \code{(ct|color|table)} \tab \code{\link[ursa:classColorTable]{ursaColorTable}}
   \cr \code{stack} \tab \code{\link[ursa:classStack]{ursaStack}}
   \cr \code{con} \tab \code{\link[ursa:classConnection]{ursaConnection}}
   \cr \code{val} \tab \code{\link[ursa:classValue]{ursaNumeric}} OR \code{\link[ursa:classValue]{ursaCategory}}
   \cr \code{cat} \tab \code{\link[ursa:classValue]{ursaCategory}}
}
}
}
\details{
%%~ Currently, \code{ursa()} does nothing.
%%~ \cr
\code{is.ursa()} is designed mainly for developers to check arguments' class in function's call. \code{is_ursa} is a synonym to \code{is.ursa}.
\cr
Stucture of \code{ursaRaster} class is generated by non-public \code{.raster.skeleton()} function.
}
\value{
\code{ursaRaster} is \R's S3 class. It is a list with items:
\item{grid}{Geospatial properties. \code{\link[ursa:classGrid]{ursaGrid}} object}
\item{con}{Connection properties.\code{\link[ursa:classConnection]{ursaConnection}} object}
\item{value}{2-dimensional numerical or integer matrix of classes \code{\link[ursa:classValue]{ursaValue}} in \emph{(spatial, temporal)} specification formed from \emph{(samples*lines, bands)}. If data are not in memory, then \code{NA}.}
\item{dim}{Dimension of \code{$value}. If bands are interpeted as observations in time, then it is \emph{spatial} by \emph{temporal} dimension of data. Even data are not in memory, \code{dim} is a dimension of whole data.}
%%~ \item{ind}{Integer. Used to mark spatial component in matrix compression (\code{\link[ursa:codec]{compress}}, \code{\link[ursa:codec]{decompress}})}
\item{name}{Band names}
\item{colortable}{Color table. \code{\link[ursa:classColorTable]{ursaColorTable}} object}


\code{is.ursa(x)} returns \code{TRUE}, if class of \code{x} is \code{ursaRaster}
}
%%~ \references{
%%~ %% ~put references to the literature/web site here ~
%%~ }
\author{
Nikita Platonov \email{platonov@sevin.ru}
}
%%~ \note{
%%~ %%  ~~further notes~~
%%~ }

%% ~Make other sections like Warning with \section{Warning }{....} ~

%%~ \seealso{
%%~ %% ~~objects to See Also as \code{\link{help}}, ~~~
%%~ }
\examples{
session_grid(NULL)
print(methods(class="ursaRaster"))

a <- pixelsize()
print(a)
print(a,grid=TRUE)
s <- substr(as.character(sessionInfo()),1,48)
b <- rep(a,length(s))
bandname(b) <- s
print(b)

require(datasets)
data(volcano)
print(is.ursa(a))
print(is.ursa(volcano))
print(is.ursa(as.ursa(volcano)))
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{classes}
\keyword{print}
