% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suffix.R
\name{tld_refresh}
\alias{tld_refresh}
\title{Retrieve a TLD dataset}
\usage{
tld_refresh()
}
\value{
a dataset equivalent in format to \code{\link{tld_dataset}}.
}
\description{
\code{urltools} comes with an inbuilt
dataset of top level domains (TLDs), \code{\link{tld_dataset}}.
This is used in \code{\link{tld_extract}} to identify the top-level domain
within a particular domain name.

While updates to the dataset will be included in each new package release,
there's going to be a gap between changes to TLDs and changes to the package.
Accordingly, the package also includes \code{tld_refresh}, which generates
and returns a \emph{fresh} version of the dataset. This can then be passed through
to \code{\link{tld_extract}}.
}
\examples{
\dontrun{
new_tlds <- tld_refresh()
}

}
\seealso{
\code{\link{tld_extract}} to extract suffixes from domain names,
or \code{\link{tld_dataset}} for the inbuilt, default version of the data.
}

